/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.entities.OperatingPlatform;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.OperatingPlatformToHost.HostReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostOperatingPlatform.HostOperatingPlatform;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.line.Line;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OperatingPlatformReferences
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(OperatingPlatformReferences.class);
    private static final String className = OperatingPlatformReferences.class.getName();
    public static final String[] REFERENCE_NAMES_SET_VALUES = new String[]{"host", null};
    public static final String[] RELATIONSHIP_NAMES_SET_VALUES = new String[]{"HostOperatingPlatform", null};
    public static final Set<String> REFERENCE_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(REFERENCE_NAMES_SET_VALUES)));
    public static final Set<String> RELATIONSHIP_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(RELATIONSHIP_NAMES_SET_VALUES)));
    private Set<HostReference> host;

    public OperatingPlatformReferences(String entityGuid, Set<Line> lines) throws InvalidParameterException {
        if (lines != null) {
            for (Line relationship : lines) {
                for (int i = 0; i < RELATIONSHIP_NAMES_SET_VALUES.length; ++i) {
                    String referenceName;
                    if (!relationship.getName().equals(RELATIONSHIP_NAMES_SET_VALUES[i]) || !"host".equals(referenceName = REFERENCE_NAMES_SET_VALUES[i])) continue;
                    HostOperatingPlatform hostOperatingPlatform_relationship = (HostOperatingPlatform)relationship;
                    HostReference hostReference = new HostReference(entityGuid, hostOperatingPlatform_relationship);
                    if (this.host == null) {
                        this.host = new HashSet<HostReference>();
                    }
                    this.host.add(hostReference);
                }
            }
        }
    }

    public Set<HostReference> getHostReferences() {
        return this.host;
    }

    public void setHostReferences(Set<HostReference> host) {
        this.host = host;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("OperatingPlatformReferences{");
        sb.append("hostReference='").append(this.host.toString());
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OperatingPlatformReferences typedThat = (OperatingPlatformReferences)o;
        if (this.host != null && !Objects.equals(this.host, typedThat.host)) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.host);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

