/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Person;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ActorProfileToActorProfile.FollowsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ActorProfileToActorProfile.LeadsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ActorProfileToActorProfile.PeersReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ActorProfileToCollection.ActorCollectionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ActorProfileToCommunity.CommunitiesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ActorProfileToContactDetails.ContactsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ActorProfileToGovernanceResponsibility.ContactForReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ActorProfileToReferenceable.ContributionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ActorProfileToUserIdentity.UserIdentitiesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.PersonToReferenceable.ResponsibilitiesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToActorProfile.ContributorsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToCertificationType.CertificationsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToComment.CommentsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToCommunity.CommunityUsesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalId.AlsoKnownAsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalId.ManagedResourcesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalReference.ExternalReferenceReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToGlossaryTerm.MeaningReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToInformalTag.TagsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToLicenseType.LicensesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToLike.LikesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToMeeting.MeetingsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToNoteLog.NoteLogsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToPerson.StaffReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToProject.ProjectUseReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToProject.ProjectsImpactingAssetsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToPropertyFacet.FacetsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRating.StarRatingsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRelatedMedia.RelatedMediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToToDo.ActionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToToDo.TodosReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ActorCollection.ActorCollection;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedComment.AttachedComment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedLike.AttachedLike;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedNoteLog.AttachedNoteLog;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedRating.AttachedRating;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedTag.AttachedTag;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Certification.Certification;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CommunityMembership.CommunityMembership;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CommunityResources.CommunityResources;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ContactThrough.ContactThrough;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Contributor.Contributor;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdLink.ExternalIdLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdScope.ExternalIdScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalReferenceLink.ExternalReferenceLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Leadership.Leadership;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.License.License;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MediaReference.MediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MeetingOnReferenceable.MeetingOnReferenceable;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Peer.Peer;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProfileIdentity.ProfileIdentity;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectResources.ProjectResources;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectScope.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReferenceableFacet.ReferenceableFacet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ResponsibilityStaffContact.ResponsibilityStaffContact;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SemanticAssignment.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.StaffAssignment.StaffAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoOnReferenceable.ToDoOnReferenceable;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoSource.ToDoSource;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.line.Line;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class PersonReferences
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(PersonReferences.class);
    private static final String className = PersonReferences.class.getName();
    public static final String[] REFERENCE_NAMES_SET_VALUES = new String[]{"responsibilities", "userIdentities", "communityUses", "meaning", "projectUse", "actorCollections", "contactFor", "externalReference", "communities", "relatedMedia", "leads", "actions", "peers", "projectsImpactingAssets", "alsoKnownAs", "managedResources", "noteLogs", "staff", "meetings", "starRatings", "likes", "tags", "follows", "facets", "contacts", "certifications", "contributors", "comments", "licenses", "contributions", "todos", null};
    public static final String[] RELATIONSHIP_NAMES_SET_VALUES = new String[]{"StaffAssignment", "ProfileIdentity", "CommunityResources", "SemanticAssignment", "ProjectResources", "ActorCollection", "ResponsibilityStaffContact", "ExternalReferenceLink", "CommunityMembership", "MediaReference", "Leadership", "ToDoSource", "Peer", "ProjectScope", "ExternalIdLink", "ExternalIdScope", "AttachedNoteLog", "StaffAssignment", "MeetingOnReferenceable", "AttachedRating", "AttachedLike", "AttachedTag", "Leadership", "ReferenceableFacet", "ContactThrough", "Certification", "Contributor", "AttachedComment", "License", "Contributor", "ToDoOnReferenceable", null};
    public static final Set<String> REFERENCE_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(REFERENCE_NAMES_SET_VALUES)));
    public static final Set<String> RELATIONSHIP_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(RELATIONSHIP_NAMES_SET_VALUES)));
    private Set<ResponsibilitiesReference> responsibilities;
    private Set<UserIdentitiesReference> userIdentities;
    private Set<CommunityUsesReference> communityUses;
    private Set<MeaningReference> meaning;
    private Set<ProjectUseReference> projectUse;
    private Set<ActorCollectionsReference> actorCollections;
    private Set<ContactForReference> contactFor;
    private Set<ExternalReferenceReference> externalReference;
    private Set<CommunitiesReference> communities;
    private Set<RelatedMediaReference> relatedMedia;
    private Set<LeadsReference> leads;
    private Set<ActionsReference> actions;
    private Set<PeersReference> peers;
    private Set<ProjectsImpactingAssetsReference> projectsImpactingAssets;
    private Set<AlsoKnownAsReference> alsoKnownAs;
    private Set<ManagedResourcesReference> managedResources;
    private Set<NoteLogsReference> noteLogs;
    private Set<StaffReference> staff;
    private Set<MeetingsReference> meetings;
    private Set<StarRatingsReference> starRatings;
    private Set<LikesReference> likes;
    private Set<TagsReference> tags;
    private Set<FollowsReference> follows;
    private Set<FacetsReference> facets;
    private Set<ContactsReference> contacts;
    private Set<CertificationsReference> certifications;
    private Set<ContributorsReference> contributors;
    private Set<CommentsReference> comments;
    private Set<LicensesReference> licenses;
    private Set<ContributionsReference> contributions;
    private Set<TodosReference> todos;

    public PersonReferences(String entityGuid, Set<Line> lines) throws InvalidParameterException {
        if (lines != null) {
            for (Line relationship : lines) {
                for (int i = 0; i < RELATIONSHIP_NAMES_SET_VALUES.length; ++i) {
                    Contributor contributor_relationship;
                    Leadership leadership_relationship;
                    StaffAssignment staffAssignment_relationship;
                    if (!relationship.getName().equals(RELATIONSHIP_NAMES_SET_VALUES[i])) continue;
                    String referenceName = REFERENCE_NAMES_SET_VALUES[i];
                    if ("responsibilities".equals(referenceName)) {
                        staffAssignment_relationship = (StaffAssignment)relationship;
                        ResponsibilitiesReference responsibilitiesReference = new ResponsibilitiesReference(entityGuid, staffAssignment_relationship);
                        if (this.responsibilities == null) {
                            this.responsibilities = new HashSet<ResponsibilitiesReference>();
                        }
                        this.responsibilities.add(responsibilitiesReference);
                    }
                    if ("userIdentities".equals(referenceName)) {
                        ProfileIdentity profileIdentity_relationship = (ProfileIdentity)relationship;
                        UserIdentitiesReference userIdentitiesReference = new UserIdentitiesReference(entityGuid, profileIdentity_relationship);
                        if (this.userIdentities == null) {
                            this.userIdentities = new HashSet<UserIdentitiesReference>();
                        }
                        this.userIdentities.add(userIdentitiesReference);
                    }
                    if ("communityUses".equals(referenceName)) {
                        CommunityResources communityResources_relationship = (CommunityResources)relationship;
                        CommunityUsesReference communityUsesReference = new CommunityUsesReference(entityGuid, communityResources_relationship);
                        if (this.communityUses == null) {
                            this.communityUses = new HashSet<CommunityUsesReference>();
                        }
                        this.communityUses.add(communityUsesReference);
                    }
                    if ("meaning".equals(referenceName)) {
                        SemanticAssignment semanticAssignment_relationship = (SemanticAssignment)relationship;
                        MeaningReference meaningReference = new MeaningReference(entityGuid, semanticAssignment_relationship);
                        if (this.meaning == null) {
                            this.meaning = new HashSet<MeaningReference>();
                        }
                        this.meaning.add(meaningReference);
                    }
                    if ("projectUse".equals(referenceName)) {
                        ProjectResources projectResources_relationship = (ProjectResources)relationship;
                        ProjectUseReference projectUseReference = new ProjectUseReference(entityGuid, projectResources_relationship);
                        if (this.projectUse == null) {
                            this.projectUse = new HashSet<ProjectUseReference>();
                        }
                        this.projectUse.add(projectUseReference);
                    }
                    if ("actorCollections".equals(referenceName)) {
                        ActorCollection actorCollection_relationship = (ActorCollection)relationship;
                        ActorCollectionsReference actorCollectionsReference = new ActorCollectionsReference(entityGuid, actorCollection_relationship);
                        if (this.actorCollections == null) {
                            this.actorCollections = new HashSet<ActorCollectionsReference>();
                        }
                        this.actorCollections.add(actorCollectionsReference);
                    }
                    if ("contactFor".equals(referenceName)) {
                        ResponsibilityStaffContact responsibilityStaffContact_relationship = (ResponsibilityStaffContact)relationship;
                        ContactForReference contactForReference = new ContactForReference(entityGuid, responsibilityStaffContact_relationship);
                        if (this.contactFor == null) {
                            this.contactFor = new HashSet<ContactForReference>();
                        }
                        this.contactFor.add(contactForReference);
                    }
                    if ("externalReference".equals(referenceName)) {
                        ExternalReferenceLink externalReferenceLink_relationship = (ExternalReferenceLink)relationship;
                        ExternalReferenceReference externalReferenceReference = new ExternalReferenceReference(entityGuid, externalReferenceLink_relationship);
                        if (this.externalReference == null) {
                            this.externalReference = new HashSet<ExternalReferenceReference>();
                        }
                        this.externalReference.add(externalReferenceReference);
                    }
                    if ("communities".equals(referenceName)) {
                        CommunityMembership communityMembership_relationship = (CommunityMembership)relationship;
                        CommunitiesReference communitiesReference = new CommunitiesReference(entityGuid, communityMembership_relationship);
                        if (this.communities == null) {
                            this.communities = new HashSet<CommunitiesReference>();
                        }
                        this.communities.add(communitiesReference);
                    }
                    if ("relatedMedia".equals(referenceName)) {
                        MediaReference mediaReference_relationship = (MediaReference)relationship;
                        RelatedMediaReference relatedMediaReference = new RelatedMediaReference(entityGuid, mediaReference_relationship);
                        if (this.relatedMedia == null) {
                            this.relatedMedia = new HashSet<RelatedMediaReference>();
                        }
                        this.relatedMedia.add(relatedMediaReference);
                    }
                    if ("leads".equals(referenceName)) {
                        leadership_relationship = (Leadership)relationship;
                        LeadsReference leadsReference = new LeadsReference(entityGuid, leadership_relationship);
                        if (this.leads == null) {
                            this.leads = new HashSet<LeadsReference>();
                        }
                        this.leads.add(leadsReference);
                    }
                    if ("actions".equals(referenceName)) {
                        ToDoSource toDoSource_relationship = (ToDoSource)relationship;
                        ActionsReference actionsReference = new ActionsReference(entityGuid, toDoSource_relationship);
                        if (this.actions == null) {
                            this.actions = new HashSet<ActionsReference>();
                        }
                        this.actions.add(actionsReference);
                    }
                    if ("peers".equals(referenceName)) {
                        Peer peer_relationship = (Peer)relationship;
                        PeersReference peersReference = new PeersReference(entityGuid, peer_relationship);
                        if (this.peers == null) {
                            this.peers = new HashSet<PeersReference>();
                        }
                        this.peers.add(peersReference);
                    }
                    if ("projectsImpactingAssets".equals(referenceName)) {
                        ProjectScope projectScope_relationship = (ProjectScope)relationship;
                        ProjectsImpactingAssetsReference projectsImpactingAssetsReference = new ProjectsImpactingAssetsReference(entityGuid, projectScope_relationship);
                        if (this.projectsImpactingAssets == null) {
                            this.projectsImpactingAssets = new HashSet<ProjectsImpactingAssetsReference>();
                        }
                        this.projectsImpactingAssets.add(projectsImpactingAssetsReference);
                    }
                    if ("alsoKnownAs".equals(referenceName)) {
                        ExternalIdLink externalIdLink_relationship = (ExternalIdLink)relationship;
                        AlsoKnownAsReference alsoKnownAsReference = new AlsoKnownAsReference(entityGuid, externalIdLink_relationship);
                        if (this.alsoKnownAs == null) {
                            this.alsoKnownAs = new HashSet<AlsoKnownAsReference>();
                        }
                        this.alsoKnownAs.add(alsoKnownAsReference);
                    }
                    if ("managedResources".equals(referenceName)) {
                        ExternalIdScope externalIdScope_relationship = (ExternalIdScope)relationship;
                        ManagedResourcesReference managedResourcesReference = new ManagedResourcesReference(entityGuid, externalIdScope_relationship);
                        if (this.managedResources == null) {
                            this.managedResources = new HashSet<ManagedResourcesReference>();
                        }
                        this.managedResources.add(managedResourcesReference);
                    }
                    if ("noteLogs".equals(referenceName)) {
                        AttachedNoteLog attachedNoteLog_relationship = (AttachedNoteLog)relationship;
                        NoteLogsReference noteLogsReference = new NoteLogsReference(entityGuid, attachedNoteLog_relationship);
                        if (this.noteLogs == null) {
                            this.noteLogs = new HashSet<NoteLogsReference>();
                        }
                        this.noteLogs.add(noteLogsReference);
                    }
                    if ("staff".equals(referenceName)) {
                        staffAssignment_relationship = (StaffAssignment)relationship;
                        StaffReference staffReference = new StaffReference(entityGuid, staffAssignment_relationship);
                        if (this.staff == null) {
                            this.staff = new HashSet<StaffReference>();
                        }
                        this.staff.add(staffReference);
                    }
                    if ("meetings".equals(referenceName)) {
                        MeetingOnReferenceable meetingOnReferenceable_relationship = (MeetingOnReferenceable)relationship;
                        MeetingsReference meetingsReference = new MeetingsReference(entityGuid, meetingOnReferenceable_relationship);
                        if (this.meetings == null) {
                            this.meetings = new HashSet<MeetingsReference>();
                        }
                        this.meetings.add(meetingsReference);
                    }
                    if ("starRatings".equals(referenceName)) {
                        AttachedRating attachedRating_relationship = (AttachedRating)relationship;
                        StarRatingsReference starRatingsReference = new StarRatingsReference(entityGuid, attachedRating_relationship);
                        if (this.starRatings == null) {
                            this.starRatings = new HashSet<StarRatingsReference>();
                        }
                        this.starRatings.add(starRatingsReference);
                    }
                    if ("likes".equals(referenceName)) {
                        AttachedLike attachedLike_relationship = (AttachedLike)relationship;
                        LikesReference likesReference = new LikesReference(entityGuid, attachedLike_relationship);
                        if (this.likes == null) {
                            this.likes = new HashSet<LikesReference>();
                        }
                        this.likes.add(likesReference);
                    }
                    if ("tags".equals(referenceName)) {
                        AttachedTag attachedTag_relationship = (AttachedTag)relationship;
                        TagsReference tagsReference = new TagsReference(entityGuid, attachedTag_relationship);
                        if (this.tags == null) {
                            this.tags = new HashSet<TagsReference>();
                        }
                        this.tags.add(tagsReference);
                    }
                    if ("follows".equals(referenceName)) {
                        leadership_relationship = (Leadership)relationship;
                        FollowsReference followsReference = new FollowsReference(entityGuid, leadership_relationship);
                        if (this.follows == null) {
                            this.follows = new HashSet<FollowsReference>();
                        }
                        this.follows.add(followsReference);
                    }
                    if ("facets".equals(referenceName)) {
                        ReferenceableFacet referenceableFacet_relationship = (ReferenceableFacet)relationship;
                        FacetsReference facetsReference = new FacetsReference(entityGuid, referenceableFacet_relationship);
                        if (this.facets == null) {
                            this.facets = new HashSet<FacetsReference>();
                        }
                        this.facets.add(facetsReference);
                    }
                    if ("contacts".equals(referenceName)) {
                        ContactThrough contactThrough_relationship = (ContactThrough)relationship;
                        ContactsReference contactsReference = new ContactsReference(entityGuid, contactThrough_relationship);
                        if (this.contacts == null) {
                            this.contacts = new HashSet<ContactsReference>();
                        }
                        this.contacts.add(contactsReference);
                    }
                    if ("certifications".equals(referenceName)) {
                        Certification certification_relationship = (Certification)relationship;
                        CertificationsReference certificationsReference = new CertificationsReference(entityGuid, certification_relationship);
                        if (this.certifications == null) {
                            this.certifications = new HashSet<CertificationsReference>();
                        }
                        this.certifications.add(certificationsReference);
                    }
                    if ("contributors".equals(referenceName)) {
                        contributor_relationship = (Contributor)relationship;
                        ContributorsReference contributorsReference = new ContributorsReference(entityGuid, contributor_relationship);
                        if (this.contributors == null) {
                            this.contributors = new HashSet<ContributorsReference>();
                        }
                        this.contributors.add(contributorsReference);
                    }
                    if ("comments".equals(referenceName)) {
                        AttachedComment attachedComment_relationship = (AttachedComment)relationship;
                        CommentsReference commentsReference = new CommentsReference(entityGuid, attachedComment_relationship);
                        if (this.comments == null) {
                            this.comments = new HashSet<CommentsReference>();
                        }
                        this.comments.add(commentsReference);
                    }
                    if ("licenses".equals(referenceName)) {
                        License license_relationship = (License)relationship;
                        LicensesReference licensesReference = new LicensesReference(entityGuid, license_relationship);
                        if (this.licenses == null) {
                            this.licenses = new HashSet<LicensesReference>();
                        }
                        this.licenses.add(licensesReference);
                    }
                    if ("contributions".equals(referenceName)) {
                        contributor_relationship = (Contributor)relationship;
                        ContributionsReference contributionsReference = new ContributionsReference(entityGuid, contributor_relationship);
                        if (this.contributions == null) {
                            this.contributions = new HashSet<ContributionsReference>();
                        }
                        this.contributions.add(contributionsReference);
                    }
                    if (!"todos".equals(referenceName)) continue;
                    ToDoOnReferenceable toDoOnReferenceable_relationship = (ToDoOnReferenceable)relationship;
                    TodosReference todosReference = new TodosReference(entityGuid, toDoOnReferenceable_relationship);
                    if (this.todos == null) {
                        this.todos = new HashSet<TodosReference>();
                    }
                    this.todos.add(todosReference);
                }
            }
        }
    }

    public Set<ResponsibilitiesReference> getResponsibilitiesReferences() {
        return this.responsibilities;
    }

    public void setResponsibilitiesReferences(Set<ResponsibilitiesReference> responsibilities) {
        this.responsibilities = responsibilities;
    }

    public Set<UserIdentitiesReference> getUserIdentitiesReferences() {
        return this.userIdentities;
    }

    public void setUserIdentitiesReferences(Set<UserIdentitiesReference> userIdentities) {
        this.userIdentities = userIdentities;
    }

    public Set<CommunityUsesReference> getCommunityUsesReferences() {
        return this.communityUses;
    }

    public void setCommunityUsesReferences(Set<CommunityUsesReference> communityUses) {
        this.communityUses = communityUses;
    }

    public Set<MeaningReference> getMeaningReferences() {
        return this.meaning;
    }

    public void setMeaningReferences(Set<MeaningReference> meaning) {
        this.meaning = meaning;
    }

    public Set<ProjectUseReference> getProjectUseReferences() {
        return this.projectUse;
    }

    public void setProjectUseReferences(Set<ProjectUseReference> projectUse) {
        this.projectUse = projectUse;
    }

    public Set<ActorCollectionsReference> getActorCollectionsReferences() {
        return this.actorCollections;
    }

    public void setActorCollectionsReferences(Set<ActorCollectionsReference> actorCollections) {
        this.actorCollections = actorCollections;
    }

    public Set<ContactForReference> getContactForReferences() {
        return this.contactFor;
    }

    public void setContactForReferences(Set<ContactForReference> contactFor) {
        this.contactFor = contactFor;
    }

    public Set<ExternalReferenceReference> getExternalReferenceReferences() {
        return this.externalReference;
    }

    public void setExternalReferenceReferences(Set<ExternalReferenceReference> externalReference) {
        this.externalReference = externalReference;
    }

    public Set<CommunitiesReference> getCommunitiesReferences() {
        return this.communities;
    }

    public void setCommunitiesReferences(Set<CommunitiesReference> communities) {
        this.communities = communities;
    }

    public Set<RelatedMediaReference> getRelatedMediaReferences() {
        return this.relatedMedia;
    }

    public void setRelatedMediaReferences(Set<RelatedMediaReference> relatedMedia) {
        this.relatedMedia = relatedMedia;
    }

    public Set<LeadsReference> getLeadsReferences() {
        return this.leads;
    }

    public void setLeadsReferences(Set<LeadsReference> leads) {
        this.leads = leads;
    }

    public Set<ActionsReference> getActionsReferences() {
        return this.actions;
    }

    public void setActionsReferences(Set<ActionsReference> actions) {
        this.actions = actions;
    }

    public Set<PeersReference> getPeersReferences() {
        return this.peers;
    }

    public void setPeersReferences(Set<PeersReference> peers) {
        this.peers = peers;
    }

    public Set<ProjectsImpactingAssetsReference> getProjectsImpactingAssetsReferences() {
        return this.projectsImpactingAssets;
    }

    public void setProjectsImpactingAssetsReferences(Set<ProjectsImpactingAssetsReference> projectsImpactingAssets) {
        this.projectsImpactingAssets = projectsImpactingAssets;
    }

    public Set<AlsoKnownAsReference> getAlsoKnownAsReferences() {
        return this.alsoKnownAs;
    }

    public void setAlsoKnownAsReferences(Set<AlsoKnownAsReference> alsoKnownAs) {
        this.alsoKnownAs = alsoKnownAs;
    }

    public Set<ManagedResourcesReference> getManagedResourcesReferences() {
        return this.managedResources;
    }

    public void setManagedResourcesReferences(Set<ManagedResourcesReference> managedResources) {
        this.managedResources = managedResources;
    }

    public Set<NoteLogsReference> getNoteLogsReferences() {
        return this.noteLogs;
    }

    public void setNoteLogsReferences(Set<NoteLogsReference> noteLogs) {
        this.noteLogs = noteLogs;
    }

    public Set<StaffReference> getStaffReferences() {
        return this.staff;
    }

    public void setStaffReferences(Set<StaffReference> staff) {
        this.staff = staff;
    }

    public Set<MeetingsReference> getMeetingsReferences() {
        return this.meetings;
    }

    public void setMeetingsReferences(Set<MeetingsReference> meetings) {
        this.meetings = meetings;
    }

    public Set<StarRatingsReference> getStarRatingsReferences() {
        return this.starRatings;
    }

    public void setStarRatingsReferences(Set<StarRatingsReference> starRatings) {
        this.starRatings = starRatings;
    }

    public Set<LikesReference> getLikesReferences() {
        return this.likes;
    }

    public void setLikesReferences(Set<LikesReference> likes) {
        this.likes = likes;
    }

    public Set<TagsReference> getTagsReferences() {
        return this.tags;
    }

    public void setTagsReferences(Set<TagsReference> tags) {
        this.tags = tags;
    }

    public Set<FollowsReference> getFollowsReferences() {
        return this.follows;
    }

    public void setFollowsReferences(Set<FollowsReference> follows) {
        this.follows = follows;
    }

    public Set<FacetsReference> getFacetsReferences() {
        return this.facets;
    }

    public void setFacetsReferences(Set<FacetsReference> facets) {
        this.facets = facets;
    }

    public Set<ContactsReference> getContactsReferences() {
        return this.contacts;
    }

    public void setContactsReferences(Set<ContactsReference> contacts) {
        this.contacts = contacts;
    }

    public Set<CertificationsReference> getCertificationsReferences() {
        return this.certifications;
    }

    public void setCertificationsReferences(Set<CertificationsReference> certifications) {
        this.certifications = certifications;
    }

    public Set<ContributorsReference> getContributorsReferences() {
        return this.contributors;
    }

    public void setContributorsReferences(Set<ContributorsReference> contributors) {
        this.contributors = contributors;
    }

    public Set<CommentsReference> getCommentsReferences() {
        return this.comments;
    }

    public void setCommentsReferences(Set<CommentsReference> comments) {
        this.comments = comments;
    }

    public Set<LicensesReference> getLicensesReferences() {
        return this.licenses;
    }

    public void setLicensesReferences(Set<LicensesReference> licenses) {
        this.licenses = licenses;
    }

    public Set<ContributionsReference> getContributionsReferences() {
        return this.contributions;
    }

    public void setContributionsReferences(Set<ContributionsReference> contributions) {
        this.contributions = contributions;
    }

    public Set<TodosReference> getTodosReferences() {
        return this.todos;
    }

    public void setTodosReferences(Set<TodosReference> todos) {
        this.todos = todos;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("PersonReferences{");
        sb.append("responsibilitiesReference='").append(this.responsibilities.toString());
        sb.append("userIdentitiesReference='").append(this.userIdentities.toString());
        sb.append("communityUsesReference='").append(this.communityUses.toString());
        sb.append("meaningReference='").append(this.meaning.toString());
        sb.append("projectUseReference='").append(this.projectUse.toString());
        sb.append("actorCollectionsReference='").append(this.actorCollections.toString());
        sb.append("contactForReference='").append(this.contactFor.toString());
        sb.append("externalReferenceReference='").append(this.externalReference.toString());
        sb.append("communitiesReference='").append(this.communities.toString());
        sb.append("relatedMediaReference='").append(this.relatedMedia.toString());
        sb.append("leadsReference='").append(this.leads.toString());
        sb.append("actionsReference='").append(this.actions.toString());
        sb.append("peersReference='").append(this.peers.toString());
        sb.append("projectsImpactingAssetsReference='").append(this.projectsImpactingAssets.toString());
        sb.append("alsoKnownAsReference='").append(this.alsoKnownAs.toString());
        sb.append("managedResourcesReference='").append(this.managedResources.toString());
        sb.append("noteLogsReference='").append(this.noteLogs.toString());
        sb.append("staffReference='").append(this.staff.toString());
        sb.append("meetingsReference='").append(this.meetings.toString());
        sb.append("starRatingsReference='").append(this.starRatings.toString());
        sb.append("likesReference='").append(this.likes.toString());
        sb.append("tagsReference='").append(this.tags.toString());
        sb.append("followsReference='").append(this.follows.toString());
        sb.append("facetsReference='").append(this.facets.toString());
        sb.append("contactsReference='").append(this.contacts.toString());
        sb.append("certificationsReference='").append(this.certifications.toString());
        sb.append("contributorsReference='").append(this.contributors.toString());
        sb.append("commentsReference='").append(this.comments.toString());
        sb.append("licensesReference='").append(this.licenses.toString());
        sb.append("contributionsReference='").append(this.contributions.toString());
        sb.append("todosReference='").append(this.todos.toString());
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersonReferences typedThat = (PersonReferences)o;
        if (this.responsibilities != null && !Objects.equals(this.responsibilities, typedThat.responsibilities)) {
            return false;
        }
        if (this.userIdentities != null && !Objects.equals(this.userIdentities, typedThat.userIdentities)) {
            return false;
        }
        if (this.communityUses != null && !Objects.equals(this.communityUses, typedThat.communityUses)) {
            return false;
        }
        if (this.meaning != null && !Objects.equals(this.meaning, typedThat.meaning)) {
            return false;
        }
        if (this.projectUse != null && !Objects.equals(this.projectUse, typedThat.projectUse)) {
            return false;
        }
        if (this.actorCollections != null && !Objects.equals(this.actorCollections, typedThat.actorCollections)) {
            return false;
        }
        if (this.contactFor != null && !Objects.equals(this.contactFor, typedThat.contactFor)) {
            return false;
        }
        if (this.externalReference != null && !Objects.equals(this.externalReference, typedThat.externalReference)) {
            return false;
        }
        if (this.communities != null && !Objects.equals(this.communities, typedThat.communities)) {
            return false;
        }
        if (this.relatedMedia != null && !Objects.equals(this.relatedMedia, typedThat.relatedMedia)) {
            return false;
        }
        if (this.leads != null && !Objects.equals(this.leads, typedThat.leads)) {
            return false;
        }
        if (this.actions != null && !Objects.equals(this.actions, typedThat.actions)) {
            return false;
        }
        if (this.peers != null && !Objects.equals(this.peers, typedThat.peers)) {
            return false;
        }
        if (this.projectsImpactingAssets != null && !Objects.equals(this.projectsImpactingAssets, typedThat.projectsImpactingAssets)) {
            return false;
        }
        if (this.alsoKnownAs != null && !Objects.equals(this.alsoKnownAs, typedThat.alsoKnownAs)) {
            return false;
        }
        if (this.managedResources != null && !Objects.equals(this.managedResources, typedThat.managedResources)) {
            return false;
        }
        if (this.noteLogs != null && !Objects.equals(this.noteLogs, typedThat.noteLogs)) {
            return false;
        }
        if (this.staff != null && !Objects.equals(this.staff, typedThat.staff)) {
            return false;
        }
        if (this.meetings != null && !Objects.equals(this.meetings, typedThat.meetings)) {
            return false;
        }
        if (this.starRatings != null && !Objects.equals(this.starRatings, typedThat.starRatings)) {
            return false;
        }
        if (this.likes != null && !Objects.equals(this.likes, typedThat.likes)) {
            return false;
        }
        if (this.tags != null && !Objects.equals(this.tags, typedThat.tags)) {
            return false;
        }
        if (this.follows != null && !Objects.equals(this.follows, typedThat.follows)) {
            return false;
        }
        if (this.facets != null && !Objects.equals(this.facets, typedThat.facets)) {
            return false;
        }
        if (this.contacts != null && !Objects.equals(this.contacts, typedThat.contacts)) {
            return false;
        }
        if (this.certifications != null && !Objects.equals(this.certifications, typedThat.certifications)) {
            return false;
        }
        if (this.contributors != null && !Objects.equals(this.contributors, typedThat.contributors)) {
            return false;
        }
        if (this.comments != null && !Objects.equals(this.comments, typedThat.comments)) {
            return false;
        }
        if (this.licenses != null && !Objects.equals(this.licenses, typedThat.licenses)) {
            return false;
        }
        if (this.contributions != null && !Objects.equals(this.contributions, typedThat.contributions)) {
            return false;
        }
        if (this.todos != null && !Objects.equals(this.todos, typedThat.todos)) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.responsibilities, this.userIdentities, this.communityUses, this.meaning, this.projectUse, this.actorCollections, this.contactFor, this.externalReference, this.communities, this.relatedMedia, this.leads, this.actions, this.peers, this.projectsImpactingAssets, this.alsoKnownAs, this.managedResources, this.noteLogs, this.staff, this.meetings, this.starRatings, this.likes, this.tags, this.follows, this.facets, this.contacts, this.certifications, this.contributors, this.comments, this.licenses, this.contributions, this.todos);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

