/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.entities.VirtualConnection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.VirtualConnection.VirtualConnection;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.server.properties.classifications.ClassificationFactory;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.archivemanager.OMRSArchiveAccessor;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualConnectionMapper {
    private static final Logger log = LoggerFactory.getLogger(VirtualConnectionMapper.class);
    private static final String className = VirtualConnectionMapper.class.getName();

    public static VirtualConnection mapOmrsEntityDetailToVirtualConnection(EntityDetail omrsEntityDetail) throws InvalidParameterException {
        String entityTypeName = omrsEntityDetail.getType().getTypeDefName();
        if ("VirtualConnection".equals(entityTypeName)) {
            VirtualConnection virtualConnection = new VirtualConnection();
            SystemAttributes systemAttributes = new SystemAttributes();
            InstanceStatus instanceStatus = omrsEntityDetail.getStatus();
            Status omas_status = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
            systemAttributes.setStatus(omas_status);
            systemAttributes.setCreatedBy(omrsEntityDetail.getCreatedBy());
            systemAttributes.setUpdatedBy(omrsEntityDetail.getUpdatedBy());
            systemAttributes.setCreateTime(omrsEntityDetail.getCreateTime());
            systemAttributes.setUpdateTime(omrsEntityDetail.getUpdateTime());
            systemAttributes.setVersion(Long.valueOf(omrsEntityDetail.getVersion()));
            systemAttributes.setGUID(omrsEntityDetail.getGUID());
            virtualConnection.setSystemAttributes(systemAttributes);
            InstanceProperties omrsEntityDetailProperties = omrsEntityDetail.getProperties();
            Iterator omrsPropertyIterator = omrsEntityDetailProperties.getPropertyNames();
            block5: while (omrsPropertyIterator.hasNext()) {
                String name = (String)omrsPropertyIterator.next();
                InstancePropertyValue value = omrsEntityDetailProperties.getPropertyValue(name);
                switch (value.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                        Object actualValue = primitivePropertyValue.getPrimitiveValue();
                        if (VirtualConnection.ATTRIBUTE_NAMES_SET.contains(name)) {
                            if (name.equals("displayName")) {
                                virtualConnection.setDisplayName((String)actualValue);
                            }
                            if (name.equals("description")) {
                                virtualConnection.setDescription((String)actualValue);
                            }
                            if (!name.equals("qualifiedName")) break;
                            virtualConnection.setQualifiedName((String)actualValue);
                            break;
                        }
                        if (null == virtualConnection.getExtraAttributes()) {
                            virtualConnection.setExtraAttributes(new HashMap<String, Object>());
                        }
                        virtualConnection.getExtraAttributes().put(name, primitivePropertyValue);
                        break;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                        String symbolicName = enumPropertyValue.getSymbolicName();
                        if (VirtualConnection.ENUM_NAMES_SET.contains(name)) break;
                        if (null == virtualConnection.getExtraAttributes()) {
                            virtualConnection.setExtraAttributes(new HashMap<String, Object>());
                        }
                        virtualConnection.getExtraAttributes().put(name, enumPropertyValue);
                        break;
                    }
                    case MAP: {
                        String mapvalue;
                        PrimitivePropertyValue primitivePropertyMapValue;
                        String mapkey;
                        Iterator iter;
                        HashMap<String, String> actualMap;
                        if (!VirtualConnection.MAP_NAMES_SET.contains(name)) break;
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                        InstanceProperties instancePropertyForMap = mapPropertyValue.getMapValues();
                        if (name.equals("securedProperties")) {
                            actualMap = new HashMap<String, String>();
                            iter = instancePropertyForMap.getPropertyNames();
                            while (iter.hasNext()) {
                                mapkey = (String)iter.next();
                                primitivePropertyMapValue = (PrimitivePropertyValue)instancePropertyForMap.getPropertyValue(mapkey);
                                mapvalue = (String)primitivePropertyMapValue.getPrimitiveValue();
                                actualMap.put(mapkey, mapvalue);
                            }
                            virtualConnection.setSecuredProperties(actualMap);
                        }
                        if (!name.equals("additionalProperties")) continue block5;
                        actualMap = new HashMap();
                        iter = instancePropertyForMap.getPropertyNames();
                        while (iter.hasNext()) {
                            mapkey = (String)iter.next();
                            primitivePropertyMapValue = (PrimitivePropertyValue)instancePropertyForMap.getPropertyValue(mapkey);
                            mapvalue = (String)primitivePropertyMapValue.getPrimitiveValue();
                            actualMap.put(mapkey, mapvalue);
                        }
                        virtualConnection.setAdditionalProperties(actualMap);
                        break;
                    }
                }
            }
            List omrsclassifications = omrsEntityDetail.getClassifications();
            if (omrsclassifications != null && !omrsclassifications.isEmpty()) {
                for (Classification omrsClassification : omrsclassifications) {
                    String omrsClassificationName = omrsClassification.getName();
                    org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification omasClassification = ClassificationFactory.getClassification(omrsClassificationName, omrsClassification);
                    if (omasClassification != null) {
                        if (virtualConnection.classifications == null) {
                            virtualConnection.classifications = new ArrayList<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification>();
                        }
                        virtualConnection.classifications.add(omasClassification);
                        continue;
                    }
                    if (null == virtualConnection.getExtraClassifications()) {
                        virtualConnection.setExtraClassifications(new HashMap<String, Classification>());
                    }
                    virtualConnection.getExtraClassifications().put(omrsClassificationName, omrsClassification);
                }
            }
            return virtualConnection;
        }
        return null;
    }

    public static EntityDetail mapVirtualConnectionToOmrsEntityDetail(VirtualConnection virtualConnection) {
        PrimitivePropertyValue primitivePropertyValue;
        MapPropertyValue mapPropertyValue;
        Map<String, String> map;
        PrimitivePropertyValue primitivePropertyValue2;
        EntityDetail omrsEntityDetail = new EntityDetail();
        SystemAttributes systemAttributes = virtualConnection.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsEntityDetail.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsEntityDetail.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsEntityDetail.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsEntityDetail.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsEntityDetail.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getGUID() != null) {
                omrsEntityDetail.setGUID(systemAttributes.getGUID());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToStatusInstance(systemAttributes.getStatus());
                omrsEntityDetail.setStatus(instanceStatus);
            }
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        if (virtualConnection.getDisplayName() != null) {
            primitivePropertyValue2 = new PrimitivePropertyValue();
            primitivePropertyValue2.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue2.setPrimitiveValue((Object)virtualConnection.getDisplayName());
            instanceProperties.setProperty("displayName", (InstancePropertyValue)primitivePropertyValue2);
        }
        if (virtualConnection.getDescription() != null) {
            primitivePropertyValue2 = new PrimitivePropertyValue();
            primitivePropertyValue2.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue2.setPrimitiveValue((Object)virtualConnection.getDescription());
            instanceProperties.setProperty("description", (InstancePropertyValue)primitivePropertyValue2);
        }
        if (virtualConnection.getQualifiedName() != null) {
            primitivePropertyValue2 = new PrimitivePropertyValue();
            primitivePropertyValue2.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue2.setPrimitiveValue((Object)virtualConnection.getQualifiedName());
            instanceProperties.setProperty("qualifiedName", (InstancePropertyValue)primitivePropertyValue2);
        }
        if (virtualConnection.getSecuredProperties() != null) {
            map = virtualConnection.getSecuredProperties();
            mapPropertyValue = new MapPropertyValue();
            for (String key : map.keySet()) {
                primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue.setPrimitiveValue((Object)map.get(key));
                mapPropertyValue.setMapValue(key, (InstancePropertyValue)primitivePropertyValue);
            }
            instanceProperties.setProperty("securedProperties", (InstancePropertyValue)mapPropertyValue);
        }
        if (virtualConnection.getAdditionalProperties() != null) {
            map = virtualConnection.getAdditionalProperties();
            mapPropertyValue = new MapPropertyValue();
            for (String key : map.keySet()) {
                primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue.setPrimitiveValue((Object)map.get(key));
                mapPropertyValue.setMapValue(key, (InstancePropertyValue)primitivePropertyValue);
            }
            instanceProperties.setProperty("additionalProperties", (InstancePropertyValue)mapPropertyValue);
        }
        omrsEntityDetail.setProperties(instanceProperties);
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef typeDef = archiveAccessor.getEntityDefByName("VirtualConnection");
        InstanceType template = SubjectAreaUtils.createTemplateFromTypeDef((TypeDef)typeDef);
        InstanceType instanceType = new InstanceType(template);
        omrsEntityDetail.setType(instanceType);
        VirtualConnectionMapper.populateOmrsEntityWithBeanClassifications(omrsEntityDetail, virtualConnection.getClassifications());
        return omrsEntityDetail;
    }

    private static void populateOmrsEntityWithBeanClassifications(EntityDetail omrsEntityDetail, List<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification> beanClassifications) {
        if (beanClassifications != null && beanClassifications.size() > 0) {
            ArrayList<Classification> omrsClassifications = new ArrayList<Classification>();
            for (org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification beanClassification : beanClassifications) {
                SystemAttributes systemAttributes = beanClassification.getSystemAttributes();
                Classification omrsClassification = new Classification();
                if (systemAttributes != null) {
                    if (systemAttributes.getCreatedBy() != null) {
                        omrsClassification.setCreatedBy(systemAttributes.getCreatedBy());
                    }
                    if (systemAttributes.getUpdatedBy() != null) {
                        omrsClassification.setUpdatedBy(systemAttributes.getUpdatedBy());
                    }
                    if (systemAttributes.getCreateTime() != null) {
                        omrsClassification.setCreateTime(systemAttributes.getCreateTime());
                    }
                    if (systemAttributes.getUpdateTime() != null) {
                        omrsClassification.setUpdateTime(systemAttributes.getUpdateTime());
                    }
                    if (systemAttributes.getVersion() != null) {
                        omrsClassification.setVersion(systemAttributes.getVersion().longValue());
                    }
                }
                omrsClassification.setName(beanClassification.getClassificationName());
                omrsClassification.setProperties(beanClassification.obtainInstanceProperties());
                omrsClassifications.add(omrsClassification);
            }
            omrsEntityDetail.setClassifications(omrsClassifications);
        }
    }
}

