/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.references.ActorProfileToContactDetails;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ContactDetails.ContactDetails;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.Reference;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.line.Line;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ContactsReference
extends Reference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ContactsReference.class);
    private static final String className = ContactsReference.class.getName();
    protected String relationship_Type = "ContactThrough";
    protected String name = "contacts";
    protected ContactDetails contactDetails = null;
    private String contactMethodType;
    private String contactMethodValue;

    public ContactDetails getContactDetails() {
        return this.contactDetails;
    }

    public void setContactDetails(ContactDetails contactDetails) {
        this.contactDetails = contactDetails;
    }

    public String getContactMethodType() {
        return this.contactMethodType;
    }

    public void setContactMethodType(String contactMethodType) {
        this.contactMethodType = contactMethodType;
    }

    public String getContactMethodValue() {
        return this.contactMethodValue;
    }

    public void setContactMethodValue(String contactMethodValue) {
        this.contactMethodValue = contactMethodValue;
    }

    public ContactsReference() {
        this(null, null, null);
    }

    public ContactsReference(String guid) {
        this(guid, null, null);
    }

    public ContactsReference(String guid, String relatedEndType) {
        this(guid, relatedEndType, null);
    }

    public ContactsReference(String relatedEndType, Map<String, Object> uniqueAttributes) {
        this(null, relatedEndType, uniqueAttributes);
    }

    public ContactsReference(String relatedEndType, final String attrName, final Object attrValue) {
        this(null, relatedEndType, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(attrName, attrValue);
            }
        });
    }

    public ContactsReference(String guid, String relatedEndType, Map<String, Object> uniqueAttributes) {
        this.setRelationshipGuid(guid);
        this.setRelatedEndType(relatedEndType);
        this.setUniqueAttributes(uniqueAttributes);
    }

    public ContactsReference(Reference other) {
        if (other != null) {
            this.setRelationshipGuid(other.getRelationshipGuid());
            this.setRelatedEndGuid(other.getRelatedEndGuid());
            this.setRelatedEndType(other.getRelatedEndType());
            this.setUniqueAttributes(other.getUniqueAttributes());
        }
    }

    public ContactsReference(String entityGuid, Line line) {
        this.setRelationshipGuid(line.getGuid());
        if (entityGuid.equals(line.getEntity1Guid())) {
            this.setRelatedEndGuid(line.getEntity2Guid());
            this.setRelatedEndType(line.getEntity2Type());
        } else {
            this.setRelatedEndGuid(line.getEntity1Guid());
            this.setRelatedEndType(line.getEntity1Type());
        }
    }

    public ContactsReference(Map objIdMap) {
        if (objIdMap != null) {
            Object reg = objIdMap.get("relatedEndGuid");
            Object rg = objIdMap.get("RelationshipGuid");
            Object t = objIdMap.get("relatedEndType");
            Object u = objIdMap.get("uniqueAttributes");
            if (reg != null) {
                this.setRelatedEndGuid(reg.toString());
            }
            if (rg != null) {
                this.setRelationshipGuid(rg.toString());
            }
            if (t != null) {
                this.setRelatedEndType(t.toString());
            }
            if (u != null && u instanceof Map) {
                this.setUniqueAttributes((Map)u);
            }
        }
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("Reference{");
        sb.append("relatedEndGuid='").append(this.getRelatedEndGuid()).append('\'');
        sb.append("relationshipGuid='").append(this.getRelationshipGuid()).append('\'');
        sb.append("relatedEndType='").append(this.getRelatedEndType()).append('\'');
        sb.append(", uniqueAttributes={");
        sb.append("}");
        sb.append("{");
        sb.append("this.contactMethodType ");
        sb.append("this.contactMethodValue ");
        sb.append('}');
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reference that = (Reference)o;
        if (this.relatedEndGuid != null && !Objects.equals(this.relatedEndGuid, that.getRelatedEndGuid())) {
            return false;
        }
        if (this.relationshipGuid != null && !Objects.equals(this.relationshipGuid, that.getRelationshipGuid())) {
            return false;
        }
        ContactsReference typedThat = (ContactsReference)that;
        if (this.contactMethodType != null && !Objects.equals(this.contactMethodType, typedThat.getContactMethodType())) {
            return false;
        }
        if (this.contactMethodValue != null && !Objects.equals(this.contactMethodValue, typedThat.getContactMethodValue())) {
            return false;
        }
        return Objects.equals(this.relatedEndType, that.getRelatedEndType()) && Objects.equals(this.uniqueAttributes, that.getUniqueAttributes());
    }

    public int hashCode() {
        return this.relatedEndGuid != null ? Objects.hash(this.relatedEndGuid) : Objects.hash(this.relatedEndType, this.uniqueAttributes, this.contactMethodType, this.contactMethodValue);
    }
}

