/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalId;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ExternalId.ExternalId;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.Reference;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.line.Line;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AlsoKnownAsReference
extends Reference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(AlsoKnownAsReference.class);
    private static final String className = AlsoKnownAsReference.class.getName();
    protected String relationship_Type = "ExternalIdLink";
    protected String name = "alsoKnownAs";
    protected ExternalId externalId = null;
    private String description;
    private String usage;
    private String source;

    public ExternalId getExternalId() {
        return this.externalId;
    }

    public void setExternalId(ExternalId externalId) {
        this.externalId = externalId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public AlsoKnownAsReference() {
        this(null, null, null);
    }

    public AlsoKnownAsReference(String guid) {
        this(guid, null, null);
    }

    public AlsoKnownAsReference(String guid, String relatedEndType) {
        this(guid, relatedEndType, null);
    }

    public AlsoKnownAsReference(String relatedEndType, Map<String, Object> uniqueAttributes) {
        this(null, relatedEndType, uniqueAttributes);
    }

    public AlsoKnownAsReference(String relatedEndType, final String attrName, final Object attrValue) {
        this(null, relatedEndType, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(attrName, attrValue);
            }
        });
    }

    public AlsoKnownAsReference(String guid, String relatedEndType, Map<String, Object> uniqueAttributes) {
        this.setRelationshipGuid(guid);
        this.setRelatedEndType(relatedEndType);
        this.setUniqueAttributes(uniqueAttributes);
    }

    public AlsoKnownAsReference(Reference other) {
        if (other != null) {
            this.setRelationshipGuid(other.getRelationshipGuid());
            this.setRelatedEndGuid(other.getRelatedEndGuid());
            this.setRelatedEndType(other.getRelatedEndType());
            this.setUniqueAttributes(other.getUniqueAttributes());
        }
    }

    public AlsoKnownAsReference(String entityGuid, Line line) {
        this.setRelationshipGuid(line.getGuid());
        if (entityGuid.equals(line.getEntity1Guid())) {
            this.setRelatedEndGuid(line.getEntity2Guid());
            this.setRelatedEndType(line.getEntity2Type());
        } else {
            this.setRelatedEndGuid(line.getEntity1Guid());
            this.setRelatedEndType(line.getEntity1Type());
        }
    }

    public AlsoKnownAsReference(Map objIdMap) {
        if (objIdMap != null) {
            Object reg = objIdMap.get("relatedEndGuid");
            Object rg = objIdMap.get("RelationshipGuid");
            Object t = objIdMap.get("relatedEndType");
            Object u = objIdMap.get("uniqueAttributes");
            if (reg != null) {
                this.setRelatedEndGuid(reg.toString());
            }
            if (rg != null) {
                this.setRelationshipGuid(rg.toString());
            }
            if (t != null) {
                this.setRelatedEndType(t.toString());
            }
            if (u != null && u instanceof Map) {
                this.setUniqueAttributes((Map)u);
            }
        }
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("Reference{");
        sb.append("relatedEndGuid='").append(this.getRelatedEndGuid()).append('\'');
        sb.append("relationshipGuid='").append(this.getRelationshipGuid()).append('\'');
        sb.append("relatedEndType='").append(this.getRelatedEndType()).append('\'');
        sb.append(", uniqueAttributes={");
        sb.append("}");
        sb.append("{");
        sb.append("this.description ");
        sb.append("this.usage ");
        sb.append("this.source ");
        sb.append('}');
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reference that = (Reference)o;
        if (this.relatedEndGuid != null && !Objects.equals(this.relatedEndGuid, that.getRelatedEndGuid())) {
            return false;
        }
        if (this.relationshipGuid != null && !Objects.equals(this.relationshipGuid, that.getRelationshipGuid())) {
            return false;
        }
        AlsoKnownAsReference typedThat = (AlsoKnownAsReference)that;
        if (this.description != null && !Objects.equals(this.description, typedThat.getDescription())) {
            return false;
        }
        if (this.usage != null && !Objects.equals(this.usage, typedThat.getUsage())) {
            return false;
        }
        if (this.source != null && !Objects.equals(this.source, typedThat.getSource())) {
            return false;
        }
        return Objects.equals(this.relatedEndType, that.getRelatedEndType()) && Objects.equals(this.uniqueAttributes, that.getUniqueAttributes());
    }

    public int hashCode() {
        return this.relatedEndGuid != null ? Objects.hash(this.relatedEndGuid) : Objects.hash(this.relatedEndType, this.uniqueAttributes, this.description, this.usage, this.source);
    }
}

