/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.references.SoftwareServerToHost;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Host.Host;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.Reference;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.line.Line;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class HostReference
extends Reference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(HostReference.class);
    private static final String className = HostReference.class.getName();
    protected String relationship_Type = "ServerDeployment";
    protected String name = "host";
    protected Host host = null;
    private String deploymentTime;
    private String deployer;
    private String serverCapabilityStatus;

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String getDeploymentTime() {
        return this.deploymentTime;
    }

    public void setDeploymentTime(String deploymentTime) {
        this.deploymentTime = deploymentTime;
    }

    public String getDeployer() {
        return this.deployer;
    }

    public void setDeployer(String deployer) {
        this.deployer = deployer;
    }

    public String getServerCapabilityStatus() {
        return this.serverCapabilityStatus;
    }

    public void setServerCapabilityStatus(String serverCapabilityStatus) {
        this.serverCapabilityStatus = serverCapabilityStatus;
    }

    public HostReference() {
        this(null, null, null);
    }

    public HostReference(String guid) {
        this(guid, null, null);
    }

    public HostReference(String guid, String relatedEndType) {
        this(guid, relatedEndType, null);
    }

    public HostReference(String relatedEndType, Map<String, Object> uniqueAttributes) {
        this(null, relatedEndType, uniqueAttributes);
    }

    public HostReference(String relatedEndType, final String attrName, final Object attrValue) {
        this(null, relatedEndType, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(attrName, attrValue);
            }
        });
    }

    public HostReference(String guid, String relatedEndType, Map<String, Object> uniqueAttributes) {
        this.setRelationshipGuid(guid);
        this.setRelatedEndType(relatedEndType);
        this.setUniqueAttributes(uniqueAttributes);
    }

    public HostReference(Reference other) {
        if (other != null) {
            this.setRelationshipGuid(other.getRelationshipGuid());
            this.setRelatedEndGuid(other.getRelatedEndGuid());
            this.setRelatedEndType(other.getRelatedEndType());
            this.setUniqueAttributes(other.getUniqueAttributes());
        }
    }

    public HostReference(String entityGuid, Line line) {
        this.setRelationshipGuid(line.getGuid());
        if (entityGuid.equals(line.getEntity1Guid())) {
            this.setRelatedEndGuid(line.getEntity2Guid());
            this.setRelatedEndType(line.getEntity2Type());
        } else {
            this.setRelatedEndGuid(line.getEntity1Guid());
            this.setRelatedEndType(line.getEntity1Type());
        }
    }

    public HostReference(Map objIdMap) {
        if (objIdMap != null) {
            Object reg = objIdMap.get("relatedEndGuid");
            Object rg = objIdMap.get("RelationshipGuid");
            Object t = objIdMap.get("relatedEndType");
            Object u = objIdMap.get("uniqueAttributes");
            if (reg != null) {
                this.setRelatedEndGuid(reg.toString());
            }
            if (rg != null) {
                this.setRelationshipGuid(rg.toString());
            }
            if (t != null) {
                this.setRelatedEndType(t.toString());
            }
            if (u != null && u instanceof Map) {
                this.setUniqueAttributes((Map)u);
            }
        }
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("Reference{");
        sb.append("relatedEndGuid='").append(this.getRelatedEndGuid()).append('\'');
        sb.append("relationshipGuid='").append(this.getRelationshipGuid()).append('\'');
        sb.append("relatedEndType='").append(this.getRelatedEndType()).append('\'');
        sb.append(", uniqueAttributes={");
        sb.append("}");
        sb.append("{");
        sb.append("this.deploymentTime ");
        sb.append("this.deployer ");
        sb.append("this.serverCapabilityStatus ");
        sb.append('}');
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reference that = (Reference)o;
        if (this.relatedEndGuid != null && !Objects.equals(this.relatedEndGuid, that.getRelatedEndGuid())) {
            return false;
        }
        if (this.relationshipGuid != null && !Objects.equals(this.relationshipGuid, that.getRelationshipGuid())) {
            return false;
        }
        HostReference typedThat = (HostReference)that;
        if (this.deploymentTime != null && !Objects.equals(this.deploymentTime, typedThat.getDeploymentTime())) {
            return false;
        }
        if (this.deployer != null && !Objects.equals(this.deployer, typedThat.getDeployer())) {
            return false;
        }
        if (this.serverCapabilityStatus != null && !Objects.equals(this.serverCapabilityStatus, typedThat.getServerCapabilityStatus())) {
            return false;
        }
        return Objects.equals(this.relatedEndType, that.getRelatedEndType()) && Objects.equals(this.uniqueAttributes, that.getUniqueAttributes());
    }

    public int hashCode() {
        return this.relatedEndGuid != null ? Objects.hash(this.relatedEndGuid) : Objects.hash(this.relatedEndType, this.uniqueAttributes, this.deploymentTime, this.deployer, this.serverCapabilityStatus);
    }
}

