/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MediaReference;

import java.util.HashMap;
import java.util.Iterator;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MediaReference.MediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.line.Line;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaReferenceMapper {
    private static final Logger log = LoggerFactory.getLogger(MediaReferenceMapper.class);
    private static final String className = MediaReferenceMapper.class.getName();

    public static MediaReference mapOmrsRelationshipToMediaReference(Relationship omrsRelationship) throws InvalidParameterException {
        if ("MediaReference".equals(omrsRelationship.getType().getTypeDefName())) {
            MediaReference mediaReference = new MediaReference(omrsRelationship);
            SystemAttributes systemAttributes = new SystemAttributes();
            InstanceStatus instanceStatus = omrsRelationship.getStatus();
            Status omrsBeanStatus = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
            systemAttributes.setStatus(omrsBeanStatus);
            systemAttributes.setCreatedBy(omrsRelationship.getCreatedBy());
            systemAttributes.setUpdatedBy(omrsRelationship.getUpdatedBy());
            systemAttributes.setCreateTime(omrsRelationship.getCreateTime());
            systemAttributes.setUpdateTime(omrsRelationship.getUpdateTime());
            systemAttributes.setVersion(Long.valueOf(omrsRelationship.getVersion()));
            systemAttributes.setGUID(omrsRelationship.getGUID());
            mediaReference.setSystemAttributes(systemAttributes);
            InstanceProperties omrsRelationshipProperties = omrsRelationship.getProperties();
            Iterator omrsPropertyIterator = omrsRelationshipProperties.getPropertyNames();
            while (omrsPropertyIterator.hasNext()) {
                String name = (String)omrsPropertyIterator.next();
                InstancePropertyValue value = omrsRelationshipProperties.getPropertyValue(name);
                switch (value.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                        Object actualValue = primitivePropertyValue.getPrimitiveValue();
                        if (MediaReference.ATTRIBUTE_NAMES_SET.contains(name)) {
                            if (name.equals("mediaId")) {
                                mediaReference.setMediaId((String)actualValue);
                            }
                            if (!name.equals("description")) break;
                            mediaReference.setDescription((String)actualValue);
                            break;
                        }
                        if (mediaReference.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            mediaReference.setExtraAttributes(extraAttributes);
                        }
                        mediaReference.getExtraAttributes().put(name, primitivePropertyValue);
                        break;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                        String symbolicName = enumPropertyValue.getSymbolicName();
                        if (MediaReference.ENUM_NAMES_SET.contains(name)) break;
                        if (mediaReference.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            mediaReference.setExtraAttributes(extraAttributes);
                        }
                        mediaReference.getExtraAttributes().put(name, enumPropertyValue);
                        break;
                    }
                    case MAP: {
                        if (!MediaReference.MAP_NAMES_SET.contains(name)) break;
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                        InstanceProperties instanceProperties = mapPropertyValue.getMapValues();
                        break;
                    }
                }
            }
            return mediaReference;
        }
        return null;
    }

    public static Relationship mapMediaReferenceToOmrsRelationship(MediaReference mediaReference) {
        PrimitivePropertyValue primitivePropertyValue;
        Relationship omrsRelationship = Line.createOmrsRelationship((Line)mediaReference);
        SystemAttributes systemAttributes = mediaReference.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsRelationship.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsRelationship.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsRelationship.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsRelationship.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsRelationship.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToStatusInstance(systemAttributes.getStatus());
                omrsRelationship.setStatus(instanceStatus);
            }
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        if (mediaReference.getMediaId() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)mediaReference.getMediaId());
            instanceProperties.setProperty("mediaId", (InstancePropertyValue)primitivePropertyValue);
        }
        if (mediaReference.getDescription() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)mediaReference.getDescription());
            instanceProperties.setProperty("description", (InstancePropertyValue)primitivePropertyValue);
        }
        omrsRelationship.setProperties(instanceProperties);
        return omrsRelationship;
    }
}

