/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.PreferredTerm;

import java.util.HashMap;
import java.util.Iterator;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.PreferredTerm.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.TermRelationshipStatus;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.line.Line;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferredTermMapper {
    private static final Logger log = LoggerFactory.getLogger(PreferredTermMapper.class);
    private static final String className = PreferredTermMapper.class.getName();

    public static PreferredTerm mapOmrsRelationshipToPreferredTerm(Relationship omrsRelationship) throws InvalidParameterException {
        if ("PreferredTerm".equals(omrsRelationship.getType().getTypeDefName())) {
            PreferredTerm preferredTerm = new PreferredTerm(omrsRelationship);
            SystemAttributes systemAttributes = new SystemAttributes();
            InstanceStatus instanceStatus = omrsRelationship.getStatus();
            Status omrsBeanStatus = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
            systemAttributes.setStatus(omrsBeanStatus);
            systemAttributes.setCreatedBy(omrsRelationship.getCreatedBy());
            systemAttributes.setUpdatedBy(omrsRelationship.getUpdatedBy());
            systemAttributes.setCreateTime(omrsRelationship.getCreateTime());
            systemAttributes.setUpdateTime(omrsRelationship.getUpdateTime());
            systemAttributes.setVersion(Long.valueOf(omrsRelationship.getVersion()));
            systemAttributes.setGUID(omrsRelationship.getGUID());
            preferredTerm.setSystemAttributes(systemAttributes);
            InstanceProperties omrsRelationshipProperties = omrsRelationship.getProperties();
            Iterator omrsPropertyIterator = omrsRelationshipProperties.getPropertyNames();
            while (omrsPropertyIterator.hasNext()) {
                String name = (String)omrsPropertyIterator.next();
                InstancePropertyValue value = omrsRelationshipProperties.getPropertyValue(name);
                switch (value.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                        Object actualValue = primitivePropertyValue.getPrimitiveValue();
                        if (PreferredTerm.ATTRIBUTE_NAMES_SET.contains(name)) {
                            if (name.equals("description")) {
                                preferredTerm.setDescription((String)actualValue);
                            }
                            if (name.equals("expression")) {
                                preferredTerm.setExpression((String)actualValue);
                            }
                            if (name.equals("steward")) {
                                preferredTerm.setSteward((String)actualValue);
                            }
                            if (!name.equals("source")) break;
                            preferredTerm.setSource((String)actualValue);
                            break;
                        }
                        if (preferredTerm.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            preferredTerm.setExtraAttributes(extraAttributes);
                        }
                        preferredTerm.getExtraAttributes().put(name, primitivePropertyValue);
                        break;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                        String symbolicName = enumPropertyValue.getSymbolicName();
                        if (PreferredTerm.ENUM_NAMES_SET.contains(name)) {
                            if (!name.equals("status")) break;
                            TermRelationshipStatus status = TermRelationshipStatus.valueOf((String)symbolicName);
                            preferredTerm.setStatus(status);
                            break;
                        }
                        if (preferredTerm.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            preferredTerm.setExtraAttributes(extraAttributes);
                        }
                        preferredTerm.getExtraAttributes().put(name, enumPropertyValue);
                        break;
                    }
                    case MAP: {
                        if (!PreferredTerm.MAP_NAMES_SET.contains(name)) break;
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                        InstanceProperties instanceProperties = mapPropertyValue.getMapValues();
                        break;
                    }
                }
            }
            return preferredTerm;
        }
        return null;
    }

    public static Relationship mapPreferredTermToOmrsRelationship(PreferredTerm preferredTerm) {
        PrimitivePropertyValue primitivePropertyValue;
        Relationship omrsRelationship = Line.createOmrsRelationship((Line)preferredTerm);
        SystemAttributes systemAttributes = preferredTerm.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsRelationship.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsRelationship.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsRelationship.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsRelationship.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsRelationship.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToStatusInstance(systemAttributes.getStatus());
                omrsRelationship.setStatus(instanceStatus);
            }
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        if (preferredTerm.getDescription() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)preferredTerm.getDescription());
            instanceProperties.setProperty("description", (InstancePropertyValue)primitivePropertyValue);
        }
        if (preferredTerm.getExpression() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)preferredTerm.getExpression());
            instanceProperties.setProperty("expression", (InstancePropertyValue)primitivePropertyValue);
        }
        if (preferredTerm.getSteward() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)preferredTerm.getSteward());
            instanceProperties.setProperty("steward", (InstancePropertyValue)primitivePropertyValue);
        }
        if (preferredTerm.getSource() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)preferredTerm.getSource());
            instanceProperties.setProperty("source", (InstancePropertyValue)primitivePropertyValue);
        }
        if (preferredTerm.getStatus() != null) {
            TermRelationshipStatus enumType = preferredTerm.getStatus();
            EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(enumType.ordinal());
            enumPropertyValue.setSymbolicName(enumType.name());
            instanceProperties.setProperty("status", (InstancePropertyValue)enumPropertyValue);
        }
        omrsRelationship.setProperties(instanceProperties);
        return omrsRelationship;
    }
}

