/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.listener;

import org.odpi.openmetadata.accessservices.subjectarea.outtopic.SubjectAreaPublisher;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaOMRSTopicListener
implements OMRSTopicListener {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaOMRSTopicListener.class);
    private SubjectAreaPublisher publisher;

    public SubjectAreaOMRSTopicListener(Connection assetConsumerOutTopic, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String componentName) {
        this.publisher = new SubjectAreaPublisher(assetConsumerOutTopic, repositoryHelper, repositoryValidator, componentName);
    }

    public void processRegistryEvent(OMRSRegistryEvent event) {
        log.debug("Ignoring registry event: " + event.toString());
    }

    public void processTypeDefEvent(OMRSTypeDefEvent event) {
        log.debug("Ignoring type event: " + event.toString());
    }

    public void processInstanceEvent(OMRSInstanceEvent instanceEvent) {
        log.debug("Processing instance event: " + instanceEvent);
        if (instanceEvent == null) {
            log.debug("Null instance event - ignoring event");
        } else {
            OMRSInstanceEventType instanceEventType = instanceEvent.getInstanceEventType();
            OMRSEventOriginator instanceEventOriginator = instanceEvent.getEventOriginator();
            if (instanceEventType != null && instanceEventOriginator != null) {
                switch (instanceEventType) {
                    case NEW_ENTITY_EVENT: {
                        this.publisher.processNewEntity(instanceEvent.getEntity());
                        break;
                    }
                    case UPDATED_ENTITY_EVENT: {
                        this.publisher.processUpdatedEntity(instanceEvent.getOriginalEntity(), instanceEvent.getEntity());
                        break;
                    }
                    case CLASSIFIED_ENTITY_EVENT: {
                        this.publisher.processUpdatedEntity(instanceEvent.getEntity());
                        break;
                    }
                    case RECLASSIFIED_ENTITY_EVENT: {
                        this.publisher.processUpdatedEntity(instanceEvent.getEntity());
                        break;
                    }
                    case DECLASSIFIED_ENTITY_EVENT: {
                        this.publisher.processUpdatedEntity(instanceEvent.getEntity());
                        break;
                    }
                    case DELETED_ENTITY_EVENT: {
                        this.publisher.processDeletedEntity(instanceEvent.getEntity());
                        break;
                    }
                    case PURGED_ENTITY_EVENT: {
                        if (!log.isDebugEnabled()) break;
                        log.debug("Ignoring entity purge org.odpi.openmetadata.accessservices.subjectarea.common.events");
                        break;
                    }
                    case UNDONE_ENTITY_EVENT: {
                        this.publisher.processUpdatedEntity(instanceEvent.getEntity());
                        break;
                    }
                    case RESTORED_ENTITY_EVENT: {
                        this.publisher.processRestoredEntity(instanceEvent.getEntity());
                        break;
                    }
                    case REFRESH_ENTITY_REQUEST: 
                    case REFRESHED_ENTITY_EVENT: 
                    case RE_HOMED_ENTITY_EVENT: 
                    case RETYPED_ENTITY_EVENT: 
                    case RE_IDENTIFIED_ENTITY_EVENT: {
                        if (!log.isDebugEnabled()) break;
                        log.debug("Ignoring entity repository maintenance org.odpi.openmetadata.accessservices.subjectarea.common.events");
                        break;
                    }
                    case NEW_RELATIONSHIP_EVENT: {
                        this.publisher.processNewRelationship(instanceEvent.getRelationship());
                        break;
                    }
                    case UPDATED_RELATIONSHIP_EVENT: {
                        this.publisher.processUpdatedRelationship(instanceEvent.getOriginalRelationship(), instanceEvent.getRelationship());
                        break;
                    }
                    case UNDONE_RELATIONSHIP_EVENT: {
                        this.publisher.processUpdatedRelationship(instanceEvent.getRelationship());
                        break;
                    }
                    case DELETED_RELATIONSHIP_EVENT: {
                        this.publisher.processDeletedRelationship(instanceEvent.getRelationship());
                        break;
                    }
                    case PURGED_RELATIONSHIP_EVENT: {
                        if (!log.isDebugEnabled()) break;
                        log.debug("Ignoring relationship purge org.odpi.openmetadata.accessservices.subjectarea.common.events");
                        break;
                    }
                    case RESTORED_RELATIONSHIP_EVENT: {
                        this.publisher.processRestoredRelationship(instanceEvent.getRelationship());
                        break;
                    }
                    case REFRESH_RELATIONSHIP_REQUEST: 
                    case REFRESHED_RELATIONSHIP_EVENT: 
                    case RE_IDENTIFIED_RELATIONSHIP_EVENT: 
                    case RE_HOMED_RELATIONSHIP_EVENT: 
                    case RETYPED_RELATIONSHIP_EVENT: {
                        if (!log.isDebugEnabled()) break;
                        log.debug("Ignoring relationship repository maintenance org.odpi.openmetadata.accessservices.subjectarea.common.events");
                        break;
                    }
                    case INSTANCE_ERROR_EVENT: {
                        if (!log.isDebugEnabled()) break;
                        log.debug("Ignoring instance error org.odpi.openmetadata.accessservices.subjectarea.common.events");
                    }
                }
            } else {
                log.debug("Ignored instance event - null type");
            }
        }
    }
}

