/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers;

import java.util.ArrayList;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Confidence.Confidence;
import org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Confidentiality.Confidentiality;
import org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Criticality.Criticality;
import org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Retention.Retention;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryCategory.GlossaryCategory;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.GovernanceActions;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.node.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryMapper {
    private static final Logger log = LoggerFactory.getLogger(CategoryMapper.class);
    private static final String className = CategoryMapper.class.getName();

    public static GlossaryCategory mapCategoryToOMRSBean(Category category) throws InvalidParameterException {
        GlossaryCategory omrsBean = new GlossaryCategory();
        if (category.getSystemAttributes() != null) {
            omrsBean.setSystemAttributes(category.getSystemAttributes());
        }
        omrsBean.setQualifiedName(category.getQualifiedName());
        omrsBean.setDescription(category.getDescription());
        omrsBean.setDisplayName(category.getName());
        ArrayList<Classification> classifications = category.getClassifications();
        if (classifications == null) {
            classifications = new ArrayList<Classification>();
        }
        for (Classification classification : classifications) {
            String classificationName = classification.getClassificationName();
            if (classificationName.equals(new Confidentiality().getClassificationName())) {
                NodeUtils.foundGovernanceClassifications((String)classificationName);
                continue;
            }
            if (classificationName.equals(new Confidence().getClassificationName())) {
                NodeUtils.foundGovernanceClassifications((String)classificationName);
                continue;
            }
            if (classificationName.equals(new Criticality().getClassificationName())) {
                NodeUtils.foundGovernanceClassifications((String)classificationName);
                continue;
            }
            if (!classificationName.equals(new Retention().getClassificationName())) continue;
            NodeUtils.foundGovernanceClassifications((String)classificationName);
        }
        GovernanceActions governanceActions = category.getGovernanceActions();
        if (governanceActions != null) {
            if (governanceActions.getRetention() != null) {
                classifications.add((Classification)governanceActions.getRetention());
            }
            if (governanceActions.getConfidence() != null) {
                classifications.add((Classification)governanceActions.getConfidence());
            }
            if (governanceActions.getConfidentiality() != null) {
                classifications.add((Classification)governanceActions.getConfidentiality());
            }
            if (governanceActions.getCriticality() != null) {
                classifications.add((Classification)governanceActions.getCriticality());
            }
        }
        omrsBean.setClassifications(classifications);
        return omrsBean;
    }

    public static Category mapOMRSBeantoCategory(GlossaryCategory omrsBean) {
        Category category = new Category();
        category.setClassifications(omrsBean.getClassifications());
        category.setDescription(omrsBean.getDescription());
        if (omrsBean.getSystemAttributes() != null) {
            category.setSystemAttributes(omrsBean.getSystemAttributes());
        }
        category.setName(omrsBean.getDisplayName());
        category.setQualifiedName(omrsBean.getQualifiedName());
        return category;
    }
}

