/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryCategory.GlossaryCategory;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryCategory.GlossaryCategoryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryCategory.GlossaryCategoryReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.GlossaryCategoryToGlossary.AnchorReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRelatedMedia.RelatedMediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CategoryAnchor.CategoryAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CategoryHierarchyLink.CategoryHierarchyLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.server.SubjectAreaBeansToAccessOMRS;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.line.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.node.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.IconSummary;
import org.odpi.openmetadata.accessservices.subjectarea.responses.CategoryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.InvalidParameterExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.CategoryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaGlossaryRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.accessservices.subjectarea.validators.RestValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaCategoryRESTServices
extends SubjectAreaRESTServices {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaCategoryRESTServices.class);
    private static final String className = SubjectAreaCategoryRESTServices.class.getName();

    public SubjectAreaOMASAPIResponse createCategory(String userid, Category suppliedCategory) {
        InvalidParameterException e;
        String errorMessage;
        SubjectAreaErrorCode errorCode;
        String methodName = "createCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createCategory,userid=" + userid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            InputValidator.validateUserIdNotNull((String)className, (String)"createCategory", (String)userid);
            InputValidator.validateNodeType((Object[])new Object[]{className, "createCategory", suppliedCategory.getNodeType(), NodeType.Category, NodeType.SubjectArea});
        }
        catch (InvalidParameterException e2) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e2);
        }
        GlossaryCategory glossaryCategory = null;
        Glossary associatedGlossary = null;
        String suppliedCategoryParentGuid = null;
        SubjectAreaBeansToAccessOMRS service = new SubjectAreaBeansToAccessOMRS();
        SubjectAreaGlossaryRESTServices glossaryRESTServices = new SubjectAreaGlossaryRESTServices();
        if (response == null) {
            service.setOMRSAPIHelper(this.oMRSAPIHelper);
            SubjectAreaCategoryRESTServices categoryRESTServices = new SubjectAreaCategoryRESTServices();
            categoryRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
            glossaryRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
            if (suppliedCategory.getParentCategory() != null) {
                suppliedCategoryParentGuid = suppliedCategory.getParentCategory().getGuid();
            }
            try {
                glossaryCategory = CategoryMapper.mapCategoryToOMRSBean(suppliedCategory);
            }
            catch (InvalidParameterException e3) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e3);
            }
        }
        String suppliedCategoryName = suppliedCategory.getName();
        if (response == null && (suppliedCategoryName == null || suppliedCategoryName.equals(""))) {
            errorCode = SubjectAreaErrorCode.GLOSSARY_CATEGORY_CREATE_WITHOUT_NAME;
            errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "createCategory"});
            log.error(errorMessage);
            e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "createCategory", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (response == null && suppliedCategory.getProjects() != null && !suppliedCategory.getProjects().isEmpty()) {
            errorCode = SubjectAreaErrorCode.GLOSSARY_CATEGORY_CREATE_WITH_PROJECTS;
            errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "createCategory", suppliedCategoryName});
            log.error(errorMessage);
            e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "createCategory", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        GlossarySummary suppliedGlossary = suppliedCategory.getGlossary();
        if (response == null) {
            SubjectAreaOMASAPIResponse glossaryResponse = RestValidator.validateGlossarySummaryDuringCreation("createCategory", suppliedGlossary, glossaryRESTServices, userid);
            if (glossaryResponse.getResponseCategory().equals((Object)ResponseCategory.Glossary)) {
                associatedGlossary = ((GlossaryResponse)glossaryResponse).getGlossary();
            } else {
                response = glossaryResponse;
            }
        }
        GlossaryCategory newGlossaryCategory = null;
        ArrayList classifications = new ArrayList();
        String categoryGuid = null;
        if (response == null) {
            response = this.checkSiblingCategoryNames(userid, "createCategory", suppliedCategoryName, suppliedCategoryParentGuid, SubjectAreaErrorCode.GLOSSARY_CATEGORY_CREATE_FAILED_CATEGORY_NAME_ALREADY_USED);
        }
        if (response == null) {
            try {
                newGlossaryCategory = service.createGlossaryCategory(userid, glossaryCategory);
                categoryGuid = newGlossaryCategory.getSystemAttributes().getGUID();
            }
            catch (InvalidParameterException e4) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e4);
            }
            catch (UserNotAuthorizedException e5) {
                response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e5);
            }
            catch (MetadataServerUncontactableException e6) {
                response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e6);
            }
            catch (ClassificationException e7) {
                response = OMASExceptionToResponse.convertClassificationException((ClassificationException)e7);
            }
            catch (StatusNotSupportedException e8) {
                response = OMASExceptionToResponse.convertStatusNotsupportedException((StatusNotSupportedException)e8);
            }
        }
        if (response == null) {
            String glossaryGuid = associatedGlossary.getSystemAttributes().getGUID();
            CategoryAnchor categoryAnchor = new CategoryAnchor();
            categoryAnchor.setEntity1Guid(glossaryGuid);
            categoryAnchor.setEntity2Guid(categoryGuid);
            try {
                service.createCategoryAnchorRelationship(userid, categoryAnchor);
            }
            catch (InvalidParameterException e9) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e9);
            }
            catch (UserNotAuthorizedException e10) {
                response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e10);
            }
            catch (MetadataServerUncontactableException e11) {
                response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e11);
            }
            catch (UnrecognizedGUIDException e12) {
                response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e12);
            }
            catch (StatusNotSupportedException e13) {
                response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e13);
            }
        }
        if (response == null && suppliedCategoryParentGuid != null) {
            CategoryHierarchyLink categoryHierarchyLink = new CategoryHierarchyLink();
            categoryHierarchyLink.setEntity1Guid(suppliedCategoryParentGuid);
            categoryHierarchyLink.setEntity2Guid(categoryGuid);
            try {
                service.createCategoryHierarchyLinkRelationship(userid, categoryHierarchyLink);
            }
            catch (InvalidParameterException e14) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e14);
            }
            catch (UserNotAuthorizedException e15) {
                response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e15);
            }
            catch (MetadataServerUncontactableException e16) {
                response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e16);
            }
            catch (UnrecognizedGUIDException e17) {
                response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e17);
            }
            catch (StatusNotSupportedException e18) {
                response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e18);
            }
        }
        if (response == null) {
            response = this.getCategory(userid, categoryGuid);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createCategory,userid=" + userid + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getCategory(String userid, String guid) {
        String methodName = "getCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCategory,userid=" + userid + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = new SubjectAreaBeansToAccessOMRS();
        subjectAreaOmasREST.setOMRSAPIHelper(this.oMRSAPIHelper);
        GlossaryCategory glossaryCategory = null;
        try {
            InputValidator.validateUserIdNotNull((String)className, (String)"getCategory", (String)userid);
            InputValidator.validateGUIDNotNull((String)className, (String)"getCategory", (String)guid, (String)"guid");
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (response == null) {
            try {
                glossaryCategory = subjectAreaOmasREST.getGlossaryCategoryById(userid, guid);
                Category gotCategory = CategoryMapper.mapOMRSBeantoCategory(glossaryCategory);
                List<Classification> classifications = glossaryCategory.getClassifications();
                gotCategory.setClassifications(classifications);
                Set<Line> categoryRelationships = subjectAreaOmasREST.getGlossaryCategoryRelationships(userid, guid);
                GlossaryCategoryReferences glossaryCategoryReferences = new GlossaryCategoryReferences(guid, categoryRelationships);
                if (response == null) {
                    AnchorReference anchorReference;
                    Set<RelatedMediaReference> relatedMediaReferenceSet = glossaryCategoryReferences.getRelatedMediaReferences();
                    Set<IconSummary> icons = SubjectAreaUtils.getIconSummaries(userid, relatedMediaReferenceSet);
                    if (icons != null) {
                        gotCategory.setIcons(icons);
                    }
                    if ((anchorReference = glossaryCategoryReferences.getAnchorReference()) != null) {
                        org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary glossary = subjectAreaOmasREST.getGlossaryById(userid, anchorReference.getRelatedEndGuid());
                        GlossarySummary glossarySummary = new GlossarySummary();
                        glossarySummary.setName(glossary.getDisplayName());
                        glossarySummary.setQualifiedName(glossary.getQualifiedName());
                        glossarySummary.setGuid(anchorReference.getRelatedEndGuid());
                        glossarySummary.setRelationshipguid(anchorReference.getRelationshipGuid());
                        glossarySummary.setRelationshipType(anchorReference.getRelationship_Type());
                        gotCategory.setGlossary(glossarySummary);
                    }
                    response = new CategoryResponse(gotCategory);
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
            catch (UserNotAuthorizedException e) {
                response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
            }
            catch (MetadataServerUncontactableException e) {
                response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
            }
            catch (UnrecognizedGUIDException e) {
                response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
            }
            catch (FunctionNotSupportedException e) {
                response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCategory,userid=" + userid + ", Response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateCategory(String userid, String guid, Category suppliedCategory, boolean isReplace) {
        String methodName = "updateCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateCategory,userid=" + userid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            InputValidator.validateUserIdNotNull((String)className, (String)"updateCategory", (String)userid);
            InputValidator.validateNodeType((Object[])new Object[]{className, "updateCategory", suppliedCategory.getNodeType(), NodeType.Category, NodeType.SubjectArea});
            InputValidator.validateGUIDNotNull((String)className, (String)"updateCategory", (String)guid, (String)"guid");
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (response == null) {
            SubjectAreaBeansToAccessOMRS service = new SubjectAreaBeansToAccessOMRS();
            service.setOMRSAPIHelper(this.oMRSAPIHelper);
            response = this.getCategory(userid, guid);
            if (response.getResponseCategory().equals((Object)ResponseCategory.Category)) {
                Status status;
                SubjectAreaOMASAPIResponse deleteCheckResponse;
                Category originalCategory = ((CategoryResponse)response).getCategory();
                if (originalCategory.getSystemAttributes() != null && (deleteCheckResponse = SubjectAreaUtils.checkStatusNotDeleted(status = originalCategory.getSystemAttributes().getStatus(), SubjectAreaErrorCode.GLOSSARY_UPDATE_FAILED_ON_DELETED_GLOSSARY)) != null) {
                    response = deleteCheckResponse;
                }
                if (suppliedCategory.getSystemAttributes() != null && (deleteCheckResponse = SubjectAreaUtils.checkStatusNotDeleted(status = suppliedCategory.getSystemAttributes().getStatus(), SubjectAreaErrorCode.STATUS_UPDATE_TO_DELETED_NOT_ALLOWED)) != null) {
                    response = deleteCheckResponse;
                }
                if (response != null) {
                    Category updateCategory = originalCategory;
                    if (isReplace) {
                        updateCategory.setName(suppliedCategory.getName());
                        updateCategory.setQualifiedName(suppliedCategory.getQualifiedName());
                        updateCategory.setDescription(suppliedCategory.getDescription());
                        updateCategory.setAdditionalProperties(suppliedCategory.getAdditionalProperties());
                    } else {
                        if (suppliedCategory.getName() != null) {
                            updateCategory.setName(suppliedCategory.getName());
                        }
                        if (suppliedCategory.getQualifiedName() != null) {
                            updateCategory.setQualifiedName(suppliedCategory.getQualifiedName());
                        }
                        if (suppliedCategory.getDescription() != null) {
                            updateCategory.setDescription(suppliedCategory.getDescription());
                        }
                        if (suppliedCategory.getAdditionalProperties() != null) {
                            updateCategory.setAdditionalProperties(suppliedCategory.getAdditionalProperties());
                        }
                    }
                    GlossaryCategory generatedCategory = null;
                    try {
                        generatedCategory = CategoryMapper.mapCategoryToOMRSBean(updateCategory);
                        GlossaryCategory updatedGeneratedCategory = null;
                        try {
                            updatedGeneratedCategory = service.updateGlossaryCategory(userid, generatedCategory);
                        }
                        catch (MetadataServerUncontactableException e) {
                            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
                        }
                        catch (UserNotAuthorizedException e) {
                            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
                        }
                        catch (UnrecognizedGUIDException e) {
                            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
                        }
                        Category updatedCategory = CategoryMapper.mapOMRSBeantoCategory(updatedGeneratedCategory);
                        response = new CategoryResponse(updatedCategory);
                    }
                    catch (InvalidParameterException e) {
                        response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateCategory,userid=" + userid + ",response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteCategory(String userid, String guid, Boolean isPurge) {
        String methodName = "deleteCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteCategory,userid=" + userid + ", guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            InputValidator.validateUserIdNotNull((String)className, (String)"deleteCategory", (String)userid);
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteCategory", (String)guid, (String)"guid");
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (response == null) {
            SubjectAreaBeansToAccessOMRS service = new SubjectAreaBeansToAccessOMRS();
            service.setOMRSAPIHelper(this.oMRSAPIHelper);
            if (isPurge.booleanValue()) {
                try {
                    service.purgeGlossaryCategoryByGuid(userid, guid);
                    response = new VoidResponse();
                }
                catch (MetadataServerUncontactableException e) {
                    response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
                }
                catch (UserNotAuthorizedException e) {
                    response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
                }
                catch (InvalidParameterException e) {
                    response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
                }
                catch (UnrecognizedGUIDException e) {
                    response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
                }
                catch (EntityNotDeletedException e) {
                    response = OMASExceptionToResponse.convertEntityNotDeletedException((EntityNotDeletedException)e);
                }
                catch (GUIDNotPurgedException e) {
                    response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
                }
            } else {
                GlossaryCategory deletedGeneratedCategory = null;
                try {
                    EntityDetail entityDetail = service.deleteGlossaryCategoryByGuid(userid, guid);
                    deletedGeneratedCategory = GlossaryCategoryMapper.mapOmrsEntityDetailToGlossaryCategory(entityDetail);
                    Category deletedCategory = CategoryMapper.mapOMRSBeantoCategory(deletedGeneratedCategory);
                    response = new CategoryResponse(deletedCategory);
                }
                catch (MetadataServerUncontactableException e) {
                    response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
                }
                catch (UserNotAuthorizedException e) {
                    response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
                }
                catch (FunctionNotSupportedException e) {
                    response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
                }
                catch (InvalidParameterException e) {
                    response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
                }
                catch (UnrecognizedGUIDException e) {
                    response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteCategory,userid=" + userid);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse checkSiblingCategoryNames(String userid, String methodName, String suppliedCategoryName, String suppliedCategoryParentGuid, SubjectAreaErrorCode errorCode) {
        SubjectAreaOMASAPIResponse response = null;
        List<Relationship> omrsRelationships = null;
        if (suppliedCategoryParentGuid != null) {
            try {
                omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userid, suppliedCategoryParentGuid, "71e4b6fb-3412-4193-aff3-a16eccd87e8e", 0, null, null, null, null, 0);
                if (omrsRelationships != null) {
                    for (Relationship omrsRelationship : omrsRelationships) {
                        String siblingCategoryName;
                        EntityDetail siblingEntityDetail;
                        InstanceProperties siblingProperties;
                        PrimitivePropertyValue primitivePropertyValue;
                        CategoryHierarchyLink link;
                        if (!omrsRelationship.getType().getTypeDefName().equals("CategoryHierarchyLink") || !(link = new CategoryHierarchyLink(omrsRelationship)).getEntity1Guid().equals(suppliedCategoryParentGuid) || (primitivePropertyValue = (PrimitivePropertyValue)(siblingProperties = (siblingEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userid, link.getEntity2Guid())).getProperties()).getPropertyValue("displayName")) == null || !(siblingCategoryName = (String)primitivePropertyValue.getPrimitiveValue()).equals(suppliedCategoryName)) continue;
                        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName, suppliedCategoryName});
                        log.error(errorMessage);
                        InvalidParameterException e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                        response = new InvalidParameterExceptionResponse((SubjectAreaCheckedExceptionBase)e);
                    }
                }
            }
            catch (MetadataServerUncontactableException e) {
                response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
            }
            catch (UserNotAuthorizedException e) {
                response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
            catch (FunctionNotSupportedException e) {
                response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
            }
            catch (UnrecognizedGUIDException e) {
                response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
            }
        }
        return response;
    }
}

