/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.HashSet;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.admin.SubjectAreaAdmin;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.PossibleClassificationsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.PossibleRelationshipsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.adminservices.OMAGAccessServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistration;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaRESTServices {
    private static String accessServiceName = null;
    private static OMRSRepositoryConnector repositoryConnector = null;
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaRESTServices.class);
    private static final String className = SubjectAreaRESTServices.class.getName();
    protected OMRSAPIHelper oMRSAPIHelper = new OMRSAPIHelper();

    public void setOMRSAPIHelper(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
    }

    public static void setRepositoryConnector(String accessServiceName, OMRSRepositoryConnector repositoryConnector) {
        SubjectAreaRESTServices.accessServiceName = accessServiceName;
        SubjectAreaRESTServices.repositoryConnector = repositoryConnector;
    }

    public static OMRSRepositoryConnector getRepositoryConnector() {
        return repositoryConnector;
    }

    public SubjectAreaRESTServices() {
        boolean initialized = false;
        List registeredServices = OMAGAccessServiceRegistration.getAccessServiceRegistrationList();
        for (AccessServiceRegistration accessServiceRegistration : registeredServices) {
            if (AccessServiceDescription.SUBJECT_AREA_OMAS.getAccessServiceCode() != accessServiceRegistration.getAccessServiceCode()) continue;
            initialized = true;
        }
        if (!initialized) {
            AccessServiceDescription myDescription = AccessServiceDescription.SUBJECT_AREA_OMAS;
            AccessServiceRegistration myRegistration = new AccessServiceRegistration(myDescription.getAccessServiceCode(), myDescription.getAccessServiceName(), myDescription.getAccessServiceDescription(), myDescription.getAccessServiceWiki(), AccessServiceOperationalStatus.ENABLED, SubjectAreaAdmin.class.getName());
            OMAGAccessServiceRegistration.registerAccessService((AccessServiceRegistration)myRegistration);
        }
    }

    public SubjectAreaOMASAPIResponse getPossibleClassificationsForTerm(String userId, String guid) {
        String methodName = "getPossibleClassificationsForTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getPossibleClassificationsForTerm,userId=" + userId + ", guid" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            InputValidator.validateUserIdNotNull((String)className, (String)"getPossibleClassificationsForTerm", (String)userId);
            InputValidator.validateGUIDNotNull((String)className, (String)"getPossibleClassificationsForTerm", (String)guid, (String)"guid");
        }
        catch (InvalidParameterException invalidParameterException) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)invalidParameterException);
        }
        if (response == null) {
            EntityDetail entityDetail = null;
            try {
                entityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, guid);
            }
            catch (MetadataServerUncontactableException e) {
                response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
            }
            catch (UserNotAuthorizedException e) {
                response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
            catch (UnrecognizedGUIDException e) {
                response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
            }
            String typeName = entityDetail.getType().getTypeDefName();
            if (response == null) {
                if (SubjectAreaUtils.isTerm(typeName)) {
                    response = this.getPossibleClassificationsForEntity(userId, typeName);
                } else {
                    SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.WRONG_TYPE_FOR_ENTITY_GUID;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, "GlossaryTerm", typeName});
                    InvalidParameterException invalidParameterException = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "getPossibleClassificationsForTerm", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                    response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)invalidParameterException);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: getPossibleClassificationsForTerm,userId=" + userId + ", guid" + guid);
        }
        return response;
    }

    private SubjectAreaOMASAPIResponse getPossibleClassificationsForEntity(String userId, String typeName) {
        String methodName = "getPossibleClassificationsForEntityType";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getPossibleClassificationsForEntityType,userId=" + userId + ", typeName" + typeName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            HashSet<String> classifications = new HashSet<String>();
            TypeDef typeDef = this.oMRSAPIHelper.callGetTypeDefByName(userId, typeName);
            if (typeDef.getCategory().getName() == TypeDefCategory.ENTITY_DEF.getName()) {
                EntityDef entityDef = (EntityDef)typeDef;
                HashSet<EntityDef> entityDefs = new HashSet<EntityDef>();
                entityDefs.add(entityDef);
                while (entityDef.getSuperType() != null) {
                    entityDef = (EntityDef)entityDef.getSuperType();
                    entityDefs.add(entityDef);
                }
                TypeDefGallery gallery = this.oMRSAPIHelper.callGetAllTypes(userId);
                for (TypeDef def : gallery.getTypeDefs()) {
                    if (def.getCategory().getName() != TypeDefCategory.CLASSIFICATION_DEF.getName()) continue;
                    ClassificationDef classificationDef = (ClassificationDef)def;
                    for (TypeDefLink validTypeDefLink : classificationDef.getValidEntityDefs()) {
                        for (EntityDef loopEntityDef : entityDefs) {
                            if (!validTypeDefLink.getName().equals(loopEntityDef.getName())) continue;
                            classifications.add(classificationDef.getName());
                        }
                    }
                }
                response = new PossibleClassificationsResponse(classifications);
            } else {
                SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.WRONG_TYPENAME;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{typeDef.getCategory().getName(), typeName});
                InvalidParameterException invalidParameterException = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "getPossibleClassificationsForEntityType", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)invalidParameterException);
            }
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: getPossibleClassificationsForEntityType,userId=" + userId + ", typeName=" + typeName + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getPossibleRelationshipsForTerm(String userId, String guid) {
        String typeName;
        String methodName = "getPossibleRelationshipsForTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getPossibleRelationshipsForTerm,userId=" + userId + ", guid" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        EntityDetail entityDetail = null;
        try {
            entityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, guid);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (response == null && SubjectAreaUtils.isTerm(typeName = entityDetail.getType().getTypeDefName())) {
            response = this.getPossibleRelationshipsForEntity(userId, typeName);
        }
        return response;
    }

    private SubjectAreaOMASAPIResponse getPossibleRelationshipsForEntity(String userId, String typeName) {
        String methodName = "getPossibleRelationshipsForEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getPossibleRelationshipsForEntity,userId=" + userId + ", typeName" + typeName);
        }
        SubjectAreaOMASAPIResponse response = null;
        HashSet<String> relationships = new HashSet<String>();
        TypeDef typeDef = null;
        try {
            typeDef = this.oMRSAPIHelper.callGetTypeDefByName(userId, typeName);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (response == null) {
            if (typeDef.getCategory().getName() == TypeDefCategory.ENTITY_DEF.getName()) {
                EntityDef entityDef = (EntityDef)typeDef;
                TypeDefGallery gallery = null;
                try {
                    gallery = this.oMRSAPIHelper.callGetAllTypes(userId);
                }
                catch (MetadataServerUncontactableException e) {
                    response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
                }
                catch (UserNotAuthorizedException e) {
                    response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
                }
                for (TypeDef def : gallery.getTypeDefs()) {
                    if (def.getCategory().getName() != TypeDefCategory.RELATIONSHIP_DEF.getName()) continue;
                    RelationshipDef relationshipDef = (RelationshipDef)def;
                    String end1Name = relationshipDef.getEndDef1().getEntityType().getName();
                    String end2Name = relationshipDef.getEndDef2().getEntityType().getName();
                    if (!end1Name.equals(typeName) && !end2Name.equals(typeName)) continue;
                    relationships.add(relationshipDef.getName());
                }
                response = new PossibleRelationshipsResponse(relationships);
            } else {
                SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.WRONG_TYPENAME;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{typeDef.getCategory().getName(), typeName});
                InvalidParameterException invalidParameterException = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "getPossibleRelationshipsForEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)invalidParameterException);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: getPossibleRelationshipsForEntity,userId=" + userId + ", typeName=" + typeName + "relationships=" + relationships);
        }
        return response;
    }
}

