/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryTerm.GlossaryTerm;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryTerm.GlossaryTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryTerm.GlossaryTermReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Referenceable.Referenceable;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.GlossaryTermToGlossary.AnchorReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.GlossaryTermToGlossaryCategory.CategoriesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.GlossaryTermToReferenceable.AssignedElementsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRelatedMedia.RelatedMediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermAnchor.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.generated.server.SubjectAreaBeansToAccessOMRS;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.line.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.node.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.AssetSummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.IconSummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.TermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaGlossaryRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.accessservices.subjectarea.validators.RestValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaTermRESTServices
extends SubjectAreaRESTServices {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaTermRESTServices.class);
    private static final String className = SubjectAreaTermRESTServices.class.getName();

    public SubjectAreaOMASAPIResponse createTerm(String userid, Term suppliedTerm) {
        InvalidParameterException e;
        String errorMessage;
        SubjectAreaErrorCode errorCode;
        String methodName = "createTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createTerm,userid=" + userid);
        }
        SubjectAreaOMASAPIResponse response = null;
        GlossaryTerm glossaryTerm = null;
        Glossary associatedGlossary = null;
        try {
            InputValidator.validateUserIdNotNull((String)className, (String)"createTerm", (String)userid);
            InputValidator.validateNodeType((Object[])new Object[]{className, "createTerm", suppliedTerm.getNodeType(), NodeType.Term});
        }
        catch (InvalidParameterException e2) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e2);
        }
        SubjectAreaBeansToAccessOMRS service = new SubjectAreaBeansToAccessOMRS();
        SubjectAreaGlossaryRESTServices glossaryRESTServices = new SubjectAreaGlossaryRESTServices();
        if (response == null) {
            service.setOMRSAPIHelper(this.oMRSAPIHelper);
            SubjectAreaTermRESTServices termRESTServices = new SubjectAreaTermRESTServices();
            termRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
            glossaryRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
            try {
                glossaryTerm = TermMapper.mapTermToOMRSBean(suppliedTerm);
            }
            catch (InvalidParameterException e3) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e3);
            }
        }
        String suppliedTermName = suppliedTerm.getName();
        if (response == null && (suppliedTermName == null || suppliedTermName.equals(""))) {
            errorCode = SubjectAreaErrorCode.GLOSSARY_TERM_CREATE_WITHOUT_NAME;
            errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "createTerm"});
            log.error(errorMessage);
            e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "createTerm", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (response == null && suppliedTerm.getCategories() != null && !suppliedTerm.getCategories().isEmpty()) {
            errorCode = SubjectAreaErrorCode.GLOSSARY_TERM_CREATE_WITH_CATEGORIES;
            errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "createTerm", suppliedTermName});
            log.error(errorMessage);
            e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "createTerm", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (response == null && suppliedTerm.getProjects() != null && !suppliedTerm.getProjects().isEmpty()) {
            errorCode = SubjectAreaErrorCode.GLOSSARY_TERM_CREATE_WITH_PROJECTS;
            errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "createTerm", suppliedTermName});
            log.error(errorMessage);
            e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "createTerm", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (response == null && suppliedTerm.getAssets() != null && !suppliedTerm.getAssets().isEmpty()) {
            errorCode = SubjectAreaErrorCode.GLOSSARY_TERM_CREATE_WITH_ASSETS;
            errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "createTerm", suppliedTermName});
            log.error(errorMessage);
            e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "createTerm", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        GlossarySummary suppliedGlossary = suppliedTerm.getGlossary();
        if (response == null) {
            SubjectAreaOMASAPIResponse glossaryResponse = RestValidator.validateGlossarySummaryDuringCreation("createTerm", suppliedGlossary, glossaryRESTServices, userid);
            if (glossaryResponse.getResponseCategory().equals((Object)ResponseCategory.Glossary)) {
                associatedGlossary = ((GlossaryResponse)glossaryResponse).getGlossary();
            } else {
                response = glossaryResponse;
            }
        }
        GlossaryTerm newGlossaryTerm = null;
        ArrayList classifications = new ArrayList();
        String termGuid = null;
        if (response == null) {
            try {
                newGlossaryTerm = service.createGlossaryTerm(userid, glossaryTerm);
                termGuid = newGlossaryTerm.getSystemAttributes().getGUID();
            }
            catch (InvalidParameterException e4) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e4);
            }
            catch (UserNotAuthorizedException e5) {
                response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e5);
            }
            catch (MetadataServerUncontactableException e6) {
                response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e6);
            }
            catch (ClassificationException e7) {
                response = OMASExceptionToResponse.convertClassificationException((ClassificationException)e7);
            }
            catch (StatusNotSupportedException e8) {
                response = OMASExceptionToResponse.convertStatusNotsupportedException((StatusNotSupportedException)e8);
            }
        }
        if (response == null) {
            String glossaryGuid = associatedGlossary.getSystemAttributes().getGUID();
            TermAnchor termAnchor = new TermAnchor();
            termAnchor.setEntity1Guid(glossaryGuid);
            termAnchor.setEntity2Guid(termGuid);
            try {
                service.createTermAnchorRelationship(userid, termAnchor);
            }
            catch (InvalidParameterException e9) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e9);
            }
            catch (UserNotAuthorizedException e10) {
                response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e10);
            }
            catch (MetadataServerUncontactableException e11) {
                response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e11);
            }
            catch (UnrecognizedGUIDException e12) {
                response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e12);
            }
            catch (StatusNotSupportedException e13) {
                response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e13);
            }
        }
        if (response == null) {
            response = this.getTermByGuid(userid, termGuid);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createTerm,userid=" + userid + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getTermByGuid(String userid, String guid) {
        String methodName = "getTermByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getTermByGuid,userid=" + userid + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            InputValidator.validateUserIdNotNull((String)className, (String)"getTermByGuid", (String)userid);
            InputValidator.validateGUIDNotNull((String)className, (String)"getTermByGuid", (String)guid, (String)"guid");
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (response == null) {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = new SubjectAreaBeansToAccessOMRS();
            subjectAreaOmasREST.setOMRSAPIHelper(this.oMRSAPIHelper);
            GlossaryTerm glossaryTerm = null;
            try {
                glossaryTerm = subjectAreaOmasREST.getGlossaryTermById(userid, guid);
                Term gotTerm = TermMapper.mapOMRSBeantoTerm(glossaryTerm);
                List<Classification> classifications = glossaryTerm.getClassifications();
                gotTerm.setClassifications(classifications);
                Set<Line> termRelationships = subjectAreaOmasREST.getGlossaryTermRelationships(userid, guid);
                GlossaryTermReferences glossaryTermReferences = new GlossaryTermReferences(guid, termRelationships);
                if (response == null) {
                    AnchorReference anchorReference;
                    Set<RelatedMediaReference> relatedMediaReferenceSet = glossaryTermReferences.getRelatedMediaReferences();
                    Set<IconSummary> icons = SubjectAreaUtils.getIconSummaries(userid, relatedMediaReferenceSet);
                    if (icons != null) {
                        gotTerm.setIcons(icons);
                    }
                    HashSet<AssetSummary> assets = new HashSet<AssetSummary>();
                    Set<AssignedElementsReference> assignedElementsReferences = glossaryTermReferences.getAssignedElementsReferences();
                    if (assignedElementsReferences != null && !assignedElementsReferences.isEmpty()) {
                        for (AssignedElementsReference assignedElementsReference : assignedElementsReferences) {
                            Referenceable referenceable = assignedElementsReference.getReferenceable();
                            AssetSummary asset = new AssetSummary();
                            asset.setGuid(referenceable.getSystemAttributes().getGUID());
                            asset.setQualifiedName(referenceable.getQualifiedName());
                            assets.add(asset);
                        }
                        gotTerm.setAssets(assets);
                    }
                    HashSet<CategorySummary> categories = new HashSet<CategorySummary>();
                    Set<CategoriesReference> categoriesReferences = glossaryTermReferences.getCategoriesReferences();
                    if (categoriesReferences != null && !categoriesReferences.isEmpty()) {
                        for (CategoriesReference categoryReference : categoriesReferences) {
                            CategorySummary category = new CategorySummary();
                            category.setGuid(categoryReference.getRelatedEndGuid());
                            category.setRelationshipguid(categoryReference.getRelationshipGuid());
                            category.setQualifiedName(categoryReference.getGlossaryCategory().getQualifiedName());
                            category.setName(categoryReference.getGlossaryCategory().getDisplayName());
                            categories.add(category);
                        }
                        gotTerm.setCategories(categories);
                    }
                    if ((anchorReference = glossaryTermReferences.getAnchorReference()) != null) {
                        org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary glossary = subjectAreaOmasREST.getGlossaryById(userid, anchorReference.getRelatedEndGuid());
                        GlossarySummary glossarySummary = new GlossarySummary();
                        glossarySummary.setName(glossary.getDisplayName());
                        glossarySummary.setQualifiedName(glossary.getQualifiedName());
                        glossarySummary.setGuid(anchorReference.getRelatedEndGuid());
                        glossarySummary.setRelationshipguid(anchorReference.getRelationshipGuid());
                        glossarySummary.setRelationshipType(anchorReference.getRelationship_Type());
                        gotTerm.setGlossary(glossarySummary);
                    }
                    response = new TermResponse(gotTerm);
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
            catch (UserNotAuthorizedException e) {
                response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
            }
            catch (MetadataServerUncontactableException e) {
                response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
            }
            catch (UnrecognizedGUIDException e) {
                response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
            }
            catch (FunctionNotSupportedException e) {
                response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTermByGuid,userid=" + userid + ", Response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateTerm(String userid, String guid, Term suppliedTerm, boolean isReplace) {
        String methodName = "updateTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateTerm,userid=" + userid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            InputValidator.validateUserIdNotNull((String)className, (String)"updateTerm", (String)userid);
            InputValidator.validateNodeType((Object[])new Object[]{className, "updateTerm", suppliedTerm.getNodeType(), NodeType.Term});
            InputValidator.validateGUIDNotNull((String)className, (String)"updateTerm", (String)guid, (String)"guid");
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (response == null) {
            SubjectAreaBeansToAccessOMRS service = new SubjectAreaBeansToAccessOMRS();
            service.setOMRSAPIHelper(this.oMRSAPIHelper);
            response = this.getTermByGuid(userid, guid);
            if (response.getResponseCategory().equals((Object)ResponseCategory.Term)) {
                Status status;
                SubjectAreaOMASAPIResponse deleteCheckResponse;
                Term originalTerm = ((TermResponse)response).getTerm();
                if (originalTerm.getSystemAttributes() != null && (deleteCheckResponse = SubjectAreaUtils.checkStatusNotDeleted(status = originalTerm.getSystemAttributes().getStatus(), SubjectAreaErrorCode.GLOSSARY_UPDATE_FAILED_ON_DELETED_GLOSSARY)) != null) {
                    response = deleteCheckResponse;
                }
                if (suppliedTerm.getSystemAttributes() != null && (deleteCheckResponse = SubjectAreaUtils.checkStatusNotDeleted(status = suppliedTerm.getSystemAttributes().getStatus(), SubjectAreaErrorCode.STATUS_UPDATE_TO_DELETED_NOT_ALLOWED)) != null) {
                    response = deleteCheckResponse;
                }
                if (response != null) {
                    Term updateTerm = originalTerm;
                    if (isReplace) {
                        updateTerm.setName(suppliedTerm.getName());
                        updateTerm.setQualifiedName(suppliedTerm.getQualifiedName());
                        updateTerm.setDescription(suppliedTerm.getDescription());
                        updateTerm.setUsage(suppliedTerm.getUsage());
                        updateTerm.setAdditionalProperties(suppliedTerm.getAdditionalProperties());
                    } else {
                        if (suppliedTerm.getName() != null) {
                            updateTerm.setName(suppliedTerm.getName());
                        }
                        if (suppliedTerm.getQualifiedName() != null) {
                            updateTerm.setQualifiedName(suppliedTerm.getQualifiedName());
                        }
                        if (suppliedTerm.getDescription() != null) {
                            updateTerm.setDescription(suppliedTerm.getDescription());
                        }
                        if (suppliedTerm.getUsage() != null) {
                            updateTerm.setUsage(suppliedTerm.getUsage());
                        }
                        if (suppliedTerm.getAdditionalProperties() != null) {
                            updateTerm.setAdditionalProperties(suppliedTerm.getAdditionalProperties());
                        }
                    }
                    GlossaryTerm generatedTerm = null;
                    try {
                        generatedTerm = TermMapper.mapTermToOMRSBean(updateTerm);
                        GlossaryTerm updatedGeneratedTerm = null;
                        try {
                            updatedGeneratedTerm = service.updateGlossaryTerm(userid, generatedTerm);
                        }
                        catch (MetadataServerUncontactableException e) {
                            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
                        }
                        catch (UserNotAuthorizedException e) {
                            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
                        }
                        catch (UnrecognizedGUIDException e) {
                            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
                        }
                        Term updatedTerm = TermMapper.mapOMRSBeantoTerm(updatedGeneratedTerm);
                        response = new TermResponse(updatedTerm);
                    }
                    catch (InvalidParameterException e) {
                        response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTerm,userid=" + userid + ",response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteTerm(String userid, String guid, Boolean isPurge) {
        String methodName = "deleteTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteTerm,userid=" + userid + ", guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            InputValidator.validateUserIdNotNull((String)className, (String)"deleteTerm", (String)userid);
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteTerm", (String)guid, (String)"guid");
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (response == null) {
            SubjectAreaBeansToAccessOMRS service = new SubjectAreaBeansToAccessOMRS();
            service.setOMRSAPIHelper(this.oMRSAPIHelper);
            if (isPurge.booleanValue()) {
                try {
                    service.purgeGlossaryTermByGuid(userid, guid);
                    response = new VoidResponse();
                }
                catch (MetadataServerUncontactableException e) {
                    response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
                }
                catch (UserNotAuthorizedException e) {
                    response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
                }
                catch (InvalidParameterException e) {
                    response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
                }
                catch (UnrecognizedGUIDException e) {
                    response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
                }
                catch (EntityNotDeletedException e) {
                    response = OMASExceptionToResponse.convertEntityNotDeletedException((EntityNotDeletedException)e);
                }
                catch (GUIDNotPurgedException e) {
                    response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
                }
            } else {
                GlossaryTerm deletedGeneratedTerm = null;
                try {
                    EntityDetail entityDetail = service.deleteGlossaryTermByGuid(userid, guid);
                    deletedGeneratedTerm = GlossaryTermMapper.mapOmrsEntityDetailToGlossaryTerm(entityDetail);
                    Term deletedTerm = TermMapper.mapOMRSBeantoTerm(deletedGeneratedTerm);
                    response = new TermResponse(deletedTerm);
                }
                catch (MetadataServerUncontactableException e) {
                    response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
                }
                catch (UserNotAuthorizedException e) {
                    response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
                }
                catch (FunctionNotSupportedException e) {
                    response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
                }
                catch (InvalidParameterException e) {
                    response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
                }
                catch (UnrecognizedGUIDException e) {
                    response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteTerm,userid=" + userid);
        }
        return response;
    }
}

