/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.validators;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaCategoryRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaGlossaryRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaTermRESTServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestValidator {
    private static final Logger log = LoggerFactory.getLogger(RestValidator.class);
    private static final String className = SubjectAreaTermRESTServices.class.getName();

    public static void validateOMASServerURLNotNull(String className, String methodName, String omasServerURL) throws MetadataServerUncontactableException {
        if (omasServerURL == null) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.SERVER_URL_NOT_SPECIFIED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public static SubjectAreaOMASAPIResponse validateGlossarySummaryDuringCreation(String methodName, GlossarySummary suppliedGlossary, SubjectAreaGlossaryRESTServices glossaryRESTServices, String userId) {
        SubjectAreaOMASAPIResponse response = null;
        String guid = null;
        String relationshipGuid = null;
        if (suppliedGlossary == null) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.CREATE_WITHOUT_GLOSSARY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName});
            log.error(errorMessage);
            InvalidParameterException e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        } else {
            InvalidParameterException e;
            String errorMessage;
            SubjectAreaErrorCode errorCode;
            SubjectAreaOMASAPIResponse glossaryResponse;
            InvalidParameterException e2;
            String errorMessage2;
            SubjectAreaErrorCode errorCode2;
            guid = suppliedGlossary.getGuid();
            relationshipGuid = suppliedGlossary.getRelationshipguid();
            String glossaryName = suppliedGlossary.getName();
            if (relationshipGuid != null) {
                errorCode2 = SubjectAreaErrorCode.CREATE_WITH_GLOSSARY_RELATIONSHIP;
                errorMessage2 = errorCode2.getErrorMessageId() + errorCode2.getFormattedErrorMessage(new String[]{className, methodName, relationshipGuid});
                log.error(errorMessage2);
                e2 = new InvalidParameterException(errorCode2.getHTTPErrorCode(), className, methodName, errorMessage2, errorCode2.getSystemAction(), errorCode2.getUserAction());
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e2);
            }
            if (guid == null && glossaryName == null) {
                errorCode2 = SubjectAreaErrorCode.CREATE_WITHOUT_GLOSSARY;
                errorMessage2 = errorCode2.getErrorMessageId() + errorCode2.getFormattedErrorMessage(new String[]{className, methodName});
                log.error(errorMessage2);
                e2 = new InvalidParameterException(errorCode2.getHTTPErrorCode(), className, methodName, errorMessage2, errorCode2.getSystemAction(), errorCode2.getUserAction());
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e2);
            }
            if (response == null && guid != null) {
                glossaryResponse = glossaryRESTServices.getGlossaryByGuid(userId, guid);
                if (glossaryResponse.getResponseCategory().equals((Object)ResponseCategory.Glossary)) {
                    return glossaryResponse;
                }
                errorCode = SubjectAreaErrorCode.CREATE_WITH_NON_EXISTANT_GLOSSARY_GUID;
                errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName, glossaryName});
                log.error(errorMessage);
                e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
            if (response == null && guid == null && glossaryName != null) {
                glossaryResponse = glossaryRESTServices.getGlossaryByName(userId, glossaryName);
                if (glossaryResponse.getResponseCategory().equals((Object)ResponseCategory.Glossary)) {
                    response = glossaryResponse;
                } else {
                    errorCode = SubjectAreaErrorCode.CREATE_WITH_NON_EXISTANT_GLOSSARY_NAME;
                    errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName, glossaryName});
                    log.error(errorMessage);
                    e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                    response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
                }
            }
        }
        return response;
    }

    public static SubjectAreaOMASAPIResponse validateCategorySummaryDuringCreation(String methodName, CategorySummary suppliedCategory, SubjectAreaCategoryRESTServices categoryRESTServices, String userId) {
        SubjectAreaOMASAPIResponse response = null;
        String guid = null;
        String relationshipGuid = null;
        String name = null;
        if (suppliedCategory != null) {
            InvalidParameterException e;
            String errorMessage;
            SubjectAreaErrorCode errorCode;
            guid = suppliedCategory.getGuid();
            relationshipGuid = suppliedCategory.getRelationshipguid();
            name = suppliedCategory.getName();
            if (relationshipGuid != null) {
                errorCode = SubjectAreaErrorCode.CREATE_WITH_CATEGORY_RELATIONSHIP;
                errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName, relationshipGuid});
                log.error(errorMessage);
                e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
            if (guid == null) {
                errorCode = SubjectAreaErrorCode.CREATE_WITH_NON_EXISTANT_CATEGORY_GUID;
                errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName});
                log.error(errorMessage);
                e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
            if (response == null && guid != null) {
                SubjectAreaOMASAPIResponse glossaryResponse = categoryRESTServices.getCategory(userId, guid);
                if (glossaryResponse.getResponseCategory().equals((Object)ResponseCategory.Category)) {
                    GlossaryResponse typedGlossaryResponse = (GlossaryResponse)glossaryResponse;
                    guid = typedGlossaryResponse.getGlossary().getSystemAttributes().getGUID();
                } else {
                    SubjectAreaErrorCode errorCode2 = SubjectAreaErrorCode.CREATE_WITH_NON_EXISTANT_GLOSSARY_GUID;
                    String errorMessage2 = errorCode2.getErrorMessageId() + errorCode2.getFormattedErrorMessage(new String[]{className, methodName, name});
                    log.error(errorMessage2);
                    InvalidParameterException e2 = new InvalidParameterException(errorCode2.getHTTPErrorCode(), className, methodName, errorMessage2, errorCode2.getSystemAction(), errorCode2.getUserAction());
                    response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e2);
                }
            }
        }
        return response;
    }
}

