/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright Contributors to the ODPi Egeria project. */

// This is a generated file - do not edit - changes should be made to the templates amd/or generator to generate this file with changes.

package org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.LocationToLocation.LocalAssetsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetLocation.AssetLocation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetLocation.AssetLocationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.LocationToLocation.KnownLocationsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetLocation.AssetLocation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetLocation.AssetLocationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.LocationToLocation.NestedLocationsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.NestedLocation.NestedLocation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.NestedLocation.NestedLocationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.LocationToLocation.GroupingLocationsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.NestedLocation.NestedLocation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.NestedLocation.NestedLocationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.LocationToLocation.PeerLocationsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AdjacentLocation.AdjacentLocation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AdjacentLocation.AdjacentLocationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.LocationToHost.LocalHostsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostLocation.HostLocation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostLocation.HostLocationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToComment.CommentsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedComment.AttachedComment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedComment.AttachedCommentMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToInformalTag.TagsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedTag.AttachedTag;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedTag.AttachedTagMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToGlossaryTerm.MeaningReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SemanticAssignment.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SemanticAssignment.SemanticAssignmentMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToProject.ImpactingProjectsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectScope.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectScope.ProjectScopeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToPropertyFacet.FacetsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReferenceableFacet.ReferenceableFacet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReferenceableFacet.ReferenceableFacetMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToLicenseType.LicensesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.License.License;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.License.LicenseMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalId.AlsoKnownAsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdLink.ExternalIdLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdLink.ExternalIdLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToLike.LikesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedLike.AttachedLike;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedLike.AttachedLikeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToNoteLog.NoteLogsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedNoteLog.AttachedNoteLog;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedNoteLog.AttachedNoteLogMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToCertificationType.CertificationsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Certification.Certification;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Certification.CertificationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalId.ManagedResourcesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdScope.ExternalIdScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdScope.ExternalIdScopeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRelatedMedia.RelatedMediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MediaReference.MediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MediaReference.MediaReferenceMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRating.StarRatingsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedRating.AttachedRating;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedRating.AttachedRatingMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalReference.ExternalReferenceReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalReferenceLink.ExternalReferenceLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalReferenceLink.ExternalReferenceLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToToDo.ActionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoSource.ToDoSource;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoSource.ToDoSourceMapper;

import java.io.Serializable;
import java.util.*;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.NONE;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.PUBLIC_ONLY;

/**
 * References for entity  Location. References are relationships represented as an attribute. Exposing relationship information
 * as references can make the relationship information more digestable.
 */
@JsonAutoDetect(getterVisibility=PUBLIC_ONLY, setterVisibility=PUBLIC_ONLY, fieldVisibility=NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class LocationReferences implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(LocationReferences.class);
    private static final String className = LocationReferences.class.getName();

    public static final String[] REFERENCE_NAMES_SET_VALUES = new String[] {
             "localAssets",
             "knownLocations",
             "nestedLocations",
             "groupingLocations",
             "peerLocations",
             "localHosts",
             "comments",
             "tags",
             "meaning",
             "impactingProjects",
             "facets",
             "licenses",
             "alsoKnownAs",
             "likes",
             "noteLogs",
             "certifications",
             "managedResources",
             "relatedMedia",
             "starRatings",
             "externalReference",
             "actions",
             // Terminate the list
             null
    };

     public static final String[] RELATIONSHIP_NAMES_SET_VALUES = new String[] {
             "AssetLocation",
             "AssetLocation",
             "NestedLocation",
             "NestedLocation",
             "AdjacentLocation",
             "HostLocation",
             "AttachedComment",
             "AttachedTag",
             "SemanticAssignment",
             "ProjectScope",
             "ReferenceableFacet",
             "License",
             "ExternalIdLink",
             "AttachedLike",
             "AttachedNoteLog",
             "Certification",
             "ExternalIdScope",
             "MediaReference",
             "AttachedRating",
             "ExternalReferenceLink",
             "ToDoSource",
              // Terminate the list
              null
     };
     /**
       * We are passed a set of omrs relationships that are associated with a entity Location
       * Each of these relationships should map to a reference (a uniquely named attribute in Location).
       *
       * Relationships have cardinality. There are 2 sorts of cardinality relevant here, whether the relationship can be related to one or many
       * entities.
       *
       * @param lines the relationship lines.
       * @param entityGuid The GUID of the entity.
       * @throws InvalidParameterException null or invalid parameter
       */
     public LocationReferences(String entityGuid, Set<Line> lines) throws InvalidParameterException {

        if (lines !=null) {
         for (Line relationship: lines) {
            for (int i=0;i< RELATIONSHIP_NAMES_SET_VALUES.length; i++) {
               if (relationship.getName().equals(RELATIONSHIP_NAMES_SET_VALUES[i])) {
                    String referenceName = REFERENCE_NAMES_SET_VALUES[i];

                    if ("localAssets".equals(referenceName)) {
                         AssetLocation assetLocation_relationship = (AssetLocation)relationship;
                         LocalAssetsReference localAssetsReference = new LocalAssetsReference(entityGuid,assetLocation_relationship);
                         if ( localAssets== null ) {
                              localAssets = new HashSet();
                         }
                          localAssets.add(localAssetsReference);
                    }
                    if ("knownLocations".equals(referenceName)) {
                         AssetLocation assetLocation_relationship = (AssetLocation)relationship;
                         KnownLocationsReference knownLocationsReference = new KnownLocationsReference(entityGuid,assetLocation_relationship);
                         if ( knownLocations== null ) {
                              knownLocations = new HashSet();
                         }
                          knownLocations.add(knownLocationsReference);
                    }
                    if ("nestedLocations".equals(referenceName)) {
                         NestedLocation nestedLocation_relationship = (NestedLocation)relationship;
                         NestedLocationsReference nestedLocationsReference = new NestedLocationsReference(entityGuid,nestedLocation_relationship);
                         if ( nestedLocations== null ) {
                              nestedLocations = new HashSet();
                         }
                          nestedLocations.add(nestedLocationsReference);
                    }
                    if ("groupingLocations".equals(referenceName)) {
                         NestedLocation nestedLocation_relationship = (NestedLocation)relationship;
                         GroupingLocationsReference groupingLocationsReference = new GroupingLocationsReference(entityGuid,nestedLocation_relationship);
                         if ( groupingLocations== null ) {
                              groupingLocations = new HashSet();
                         }
                          groupingLocations.add(groupingLocationsReference);
                    }
                    if ("peerLocations".equals(referenceName)) {
                         AdjacentLocation adjacentLocation_relationship = (AdjacentLocation)relationship;
                         PeerLocationsReference peerLocationsReference = new PeerLocationsReference(entityGuid,adjacentLocation_relationship);
                         if ( peerLocations== null ) {
                              peerLocations = new HashSet();
                         }
                          peerLocations.add(peerLocationsReference);
                    }
                    if ("localHosts".equals(referenceName)) {
                         HostLocation hostLocation_relationship = (HostLocation)relationship;
                         LocalHostsReference localHostsReference = new LocalHostsReference(entityGuid,hostLocation_relationship);
                         if ( localHosts== null ) {
                              localHosts = new HashSet();
                         }
                          localHosts.add(localHostsReference);
                    }
                    if ("comments".equals(referenceName)) {
                         AttachedComment attachedComment_relationship = (AttachedComment)relationship;
                         CommentsReference commentsReference = new CommentsReference(entityGuid,attachedComment_relationship);
                         if ( comments== null ) {
                              comments = new HashSet();
                         }
                          comments.add(commentsReference);
                    }
                    if ("tags".equals(referenceName)) {
                         AttachedTag attachedTag_relationship = (AttachedTag)relationship;
                         TagsReference tagsReference = new TagsReference(entityGuid,attachedTag_relationship);
                         if ( tags== null ) {
                              tags = new HashSet();
                         }
                          tags.add(tagsReference);
                    }
                    if ("meaning".equals(referenceName)) {
                         SemanticAssignment semanticAssignment_relationship = (SemanticAssignment)relationship;
                         MeaningReference meaningReference = new MeaningReference(entityGuid,semanticAssignment_relationship);
                         if ( meaning== null ) {
                              meaning = new HashSet();
                         }
                          meaning.add(meaningReference);
                    }
                    if ("impactingProjects".equals(referenceName)) {
                         ProjectScope projectScope_relationship = (ProjectScope)relationship;
                         ImpactingProjectsReference impactingProjectsReference = new ImpactingProjectsReference(entityGuid,projectScope_relationship);
                         if ( impactingProjects== null ) {
                              impactingProjects = new HashSet();
                         }
                          impactingProjects.add(impactingProjectsReference);
                    }
                    if ("facets".equals(referenceName)) {
                         ReferenceableFacet referenceableFacet_relationship = (ReferenceableFacet)relationship;
                         FacetsReference facetsReference = new FacetsReference(entityGuid,referenceableFacet_relationship);
                         if ( facets== null ) {
                              facets = new HashSet();
                         }
                          facets.add(facetsReference);
                    }
                    if ("licenses".equals(referenceName)) {
                         License license_relationship = (License)relationship;
                         LicensesReference licensesReference = new LicensesReference(entityGuid,license_relationship);
                         if ( licenses== null ) {
                              licenses = new HashSet();
                         }
                          licenses.add(licensesReference);
                    }
                    if ("alsoKnownAs".equals(referenceName)) {
                         ExternalIdLink externalIdLink_relationship = (ExternalIdLink)relationship;
                         AlsoKnownAsReference alsoKnownAsReference = new AlsoKnownAsReference(entityGuid,externalIdLink_relationship);
                         if ( alsoKnownAs== null ) {
                              alsoKnownAs = new HashSet();
                         }
                          alsoKnownAs.add(alsoKnownAsReference);
                    }
                    if ("likes".equals(referenceName)) {
                         AttachedLike attachedLike_relationship = (AttachedLike)relationship;
                         LikesReference likesReference = new LikesReference(entityGuid,attachedLike_relationship);
                         if ( likes== null ) {
                              likes = new HashSet();
                         }
                          likes.add(likesReference);
                    }
                    if ("noteLogs".equals(referenceName)) {
                         AttachedNoteLog attachedNoteLog_relationship = (AttachedNoteLog)relationship;
                         NoteLogsReference noteLogsReference = new NoteLogsReference(entityGuid,attachedNoteLog_relationship);
                         if ( noteLogs== null ) {
                              noteLogs = new HashSet();
                         }
                          noteLogs.add(noteLogsReference);
                    }
                    if ("certifications".equals(referenceName)) {
                         Certification certification_relationship = (Certification)relationship;
                         CertificationsReference certificationsReference = new CertificationsReference(entityGuid,certification_relationship);
                         if ( certifications== null ) {
                              certifications = new HashSet();
                         }
                          certifications.add(certificationsReference);
                    }
                    if ("managedResources".equals(referenceName)) {
                         ExternalIdScope externalIdScope_relationship = (ExternalIdScope)relationship;
                         ManagedResourcesReference managedResourcesReference = new ManagedResourcesReference(entityGuid,externalIdScope_relationship);
                         if ( managedResources== null ) {
                              managedResources = new HashSet();
                         }
                          managedResources.add(managedResourcesReference);
                    }
                    if ("relatedMedia".equals(referenceName)) {
                         MediaReference mediaReference_relationship = (MediaReference)relationship;
                         RelatedMediaReference relatedMediaReference = new RelatedMediaReference(entityGuid,mediaReference_relationship);
                         if ( relatedMedia== null ) {
                              relatedMedia = new HashSet();
                         }
                          relatedMedia.add(relatedMediaReference);
                    }
                    if ("starRatings".equals(referenceName)) {
                         AttachedRating attachedRating_relationship = (AttachedRating)relationship;
                         StarRatingsReference starRatingsReference = new StarRatingsReference(entityGuid,attachedRating_relationship);
                         if ( starRatings== null ) {
                              starRatings = new HashSet();
                         }
                          starRatings.add(starRatingsReference);
                    }
                    if ("externalReference".equals(referenceName)) {
                         ExternalReferenceLink externalReferenceLink_relationship = (ExternalReferenceLink)relationship;
                         ExternalReferenceReference externalReferenceReference = new ExternalReferenceReference(entityGuid,externalReferenceLink_relationship);
                         if ( externalReference== null ) {
                              externalReference = new HashSet();
                         }
                          externalReference.add(externalReferenceReference);
                    }
                    if ("actions".equals(referenceName)) {
                         ToDoSource toDoSource_relationship = (ToDoSource)relationship;
                         ActionsReference actionsReference = new ActionsReference(entityGuid,toDoSource_relationship);
                         if ( actions== null ) {
                              actions = new HashSet();
                         }
                          actions.add(actionsReference);
                    }

                 }
             }
         }
        }
     }

    public static final Set<String> REFERENCE_NAMES_SET = new HashSet(new HashSet<>(Arrays.asList(REFERENCE_NAMES_SET_VALUES)));
    // there may be duplicate strings in RELATIONSHIP_NAMES_SET_VALUES, the following line deduplicates the Strings into a Set.
    public static final Set<String> RELATIONSHIP_NAMES_SET = new HashSet(new HashSet<>(Arrays.asList(RELATIONSHIP_NAMES_SET_VALUES)));
// Singular properties
// Set properties

    private Set<LocalAssetsReference> localAssets;
    private Set<KnownLocationsReference> knownLocations;
    private Set<NestedLocationsReference> nestedLocations;
    private Set<GroupingLocationsReference> groupingLocations;
    private Set<PeerLocationsReference> peerLocations;
    private Set<LocalHostsReference> localHosts;
    private Set<CommentsReference> comments;
    private Set<TagsReference> tags;
    private Set<MeaningReference> meaning;
    private Set<ImpactingProjectsReference> impactingProjects;
    private Set<FacetsReference> facets;
    private Set<LicensesReference> licenses;
    private Set<AlsoKnownAsReference> alsoKnownAs;
    private Set<LikesReference> likes;
    private Set<NoteLogsReference> noteLogs;
    private Set<CertificationsReference> certifications;
    private Set<ManagedResourcesReference> managedResources;
    private Set<RelatedMediaReference> relatedMedia;
    private Set<StarRatingsReference> starRatings;
    private Set<ExternalReferenceReference> externalReference;
    private Set<ActionsReference> actions;

// List properties

    // setters and setters

// Sets
    public Set<LocalAssetsReference> getLocalAssetsReferences() {
        return localAssets;
    }

    public void setLocalAssetsReferences(Set<LocalAssetsReference> localAssets) {
        this.localAssets =localAssets;
    }
    public Set<KnownLocationsReference> getKnownLocationsReferences() {
        return knownLocations;
    }

    public void setKnownLocationsReferences(Set<KnownLocationsReference> knownLocations) {
        this.knownLocations =knownLocations;
    }
    public Set<NestedLocationsReference> getNestedLocationsReferences() {
        return nestedLocations;
    }

    public void setNestedLocationsReferences(Set<NestedLocationsReference> nestedLocations) {
        this.nestedLocations =nestedLocations;
    }
    public Set<GroupingLocationsReference> getGroupingLocationsReferences() {
        return groupingLocations;
    }

    public void setGroupingLocationsReferences(Set<GroupingLocationsReference> groupingLocations) {
        this.groupingLocations =groupingLocations;
    }
    public Set<PeerLocationsReference> getPeerLocationsReferences() {
        return peerLocations;
    }

    public void setPeerLocationsReferences(Set<PeerLocationsReference> peerLocations) {
        this.peerLocations =peerLocations;
    }
    public Set<LocalHostsReference> getLocalHostsReferences() {
        return localHosts;
    }

    public void setLocalHostsReferences(Set<LocalHostsReference> localHosts) {
        this.localHosts =localHosts;
    }
    public Set<CommentsReference> getCommentsReferences() {
        return comments;
    }

    public void setCommentsReferences(Set<CommentsReference> comments) {
        this.comments =comments;
    }
    public Set<TagsReference> getTagsReferences() {
        return tags;
    }

    public void setTagsReferences(Set<TagsReference> tags) {
        this.tags =tags;
    }
    public Set<MeaningReference> getMeaningReferences() {
        return meaning;
    }

    public void setMeaningReferences(Set<MeaningReference> meaning) {
        this.meaning =meaning;
    }
    public Set<ImpactingProjectsReference> getImpactingProjectsReferences() {
        return impactingProjects;
    }

    public void setImpactingProjectsReferences(Set<ImpactingProjectsReference> impactingProjects) {
        this.impactingProjects =impactingProjects;
    }
    public Set<FacetsReference> getFacetsReferences() {
        return facets;
    }

    public void setFacetsReferences(Set<FacetsReference> facets) {
        this.facets =facets;
    }
    public Set<LicensesReference> getLicensesReferences() {
        return licenses;
    }

    public void setLicensesReferences(Set<LicensesReference> licenses) {
        this.licenses =licenses;
    }
    public Set<AlsoKnownAsReference> getAlsoKnownAsReferences() {
        return alsoKnownAs;
    }

    public void setAlsoKnownAsReferences(Set<AlsoKnownAsReference> alsoKnownAs) {
        this.alsoKnownAs =alsoKnownAs;
    }
    public Set<LikesReference> getLikesReferences() {
        return likes;
    }

    public void setLikesReferences(Set<LikesReference> likes) {
        this.likes =likes;
    }
    public Set<NoteLogsReference> getNoteLogsReferences() {
        return noteLogs;
    }

    public void setNoteLogsReferences(Set<NoteLogsReference> noteLogs) {
        this.noteLogs =noteLogs;
    }
    public Set<CertificationsReference> getCertificationsReferences() {
        return certifications;
    }

    public void setCertificationsReferences(Set<CertificationsReference> certifications) {
        this.certifications =certifications;
    }
    public Set<ManagedResourcesReference> getManagedResourcesReferences() {
        return managedResources;
    }

    public void setManagedResourcesReferences(Set<ManagedResourcesReference> managedResources) {
        this.managedResources =managedResources;
    }
    public Set<RelatedMediaReference> getRelatedMediaReferences() {
        return relatedMedia;
    }

    public void setRelatedMediaReferences(Set<RelatedMediaReference> relatedMedia) {
        this.relatedMedia =relatedMedia;
    }
    public Set<StarRatingsReference> getStarRatingsReferences() {
        return starRatings;
    }

    public void setStarRatingsReferences(Set<StarRatingsReference> starRatings) {
        this.starRatings =starRatings;
    }
    public Set<ExternalReferenceReference> getExternalReferenceReferences() {
        return externalReference;
    }

    public void setExternalReferenceReferences(Set<ExternalReferenceReference> externalReference) {
        this.externalReference =externalReference;
    }
    public Set<ActionsReference> getActionsReferences() {
        return actions;
    }

    public void setActionsReferences(Set<ActionsReference> actions) {
        this.actions =actions;
    }

// Lists

 public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }

        sb.append("LocationReferences{");
        sb.append("localAssetsReference='").append(localAssets.toString());
        sb.append("knownLocationsReference='").append(knownLocations.toString());
        sb.append("nestedLocationsReference='").append(nestedLocations.toString());
        sb.append("groupingLocationsReference='").append(groupingLocations.toString());
        sb.append("peerLocationsReference='").append(peerLocations.toString());
        sb.append("localHostsReference='").append(localHosts.toString());
        sb.append("commentsReference='").append(comments.toString());
        sb.append("tagsReference='").append(tags.toString());
        sb.append("meaningReference='").append(meaning.toString());
        sb.append("impactingProjectsReference='").append(impactingProjects.toString());
        sb.append("facetsReference='").append(facets.toString());
        sb.append("licensesReference='").append(licenses.toString());
        sb.append("alsoKnownAsReference='").append(alsoKnownAs.toString());
        sb.append("likesReference='").append(likes.toString());
        sb.append("noteLogsReference='").append(noteLogs.toString());
        sb.append("certificationsReference='").append(certifications.toString());
        sb.append("managedResourcesReference='").append(managedResources.toString());
        sb.append("relatedMediaReference='").append(relatedMedia.toString());
        sb.append("starRatingsReference='").append(starRatings.toString());
        sb.append("externalReferenceReference='").append(externalReference.toString());
        sb.append("actionsReference='").append(actions.toString());

        sb.append('}');

        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) { return true; }
        if (o == null || getClass() != o.getClass()) { return false; }
        if (!super.equals(o)) { return false; }
         LocationReferences typedThat = (LocationReferences) o;
      // compare single cardinality attributes
         if (this.localAssets != null && !Objects.equals(this.localAssets,typedThat.localAssets)) {
                            return false;
                 }
         if (this.knownLocations != null && !Objects.equals(this.knownLocations,typedThat.knownLocations)) {
                            return false;
                 }
         if (this.nestedLocations != null && !Objects.equals(this.nestedLocations,typedThat.nestedLocations)) {
                            return false;
                 }
         if (this.groupingLocations != null && !Objects.equals(this.groupingLocations,typedThat.groupingLocations)) {
                            return false;
                 }
         if (this.peerLocations != null && !Objects.equals(this.peerLocations,typedThat.peerLocations)) {
                            return false;
                 }
         if (this.localHosts != null && !Objects.equals(this.localHosts,typedThat.localHosts)) {
                            return false;
                 }
         if (this.comments != null && !Objects.equals(this.comments,typedThat.comments)) {
                            return false;
                 }
         if (this.tags != null && !Objects.equals(this.tags,typedThat.tags)) {
                            return false;
                 }
         if (this.meaning != null && !Objects.equals(this.meaning,typedThat.meaning)) {
                            return false;
                 }
         if (this.impactingProjects != null && !Objects.equals(this.impactingProjects,typedThat.impactingProjects)) {
                            return false;
                 }
         if (this.facets != null && !Objects.equals(this.facets,typedThat.facets)) {
                            return false;
                 }
         if (this.licenses != null && !Objects.equals(this.licenses,typedThat.licenses)) {
                            return false;
                 }
         if (this.alsoKnownAs != null && !Objects.equals(this.alsoKnownAs,typedThat.alsoKnownAs)) {
                            return false;
                 }
         if (this.likes != null && !Objects.equals(this.likes,typedThat.likes)) {
                            return false;
                 }
         if (this.noteLogs != null && !Objects.equals(this.noteLogs,typedThat.noteLogs)) {
                            return false;
                 }
         if (this.certifications != null && !Objects.equals(this.certifications,typedThat.certifications)) {
                            return false;
                 }
         if (this.managedResources != null && !Objects.equals(this.managedResources,typedThat.managedResources)) {
                            return false;
                 }
         if (this.relatedMedia != null && !Objects.equals(this.relatedMedia,typedThat.relatedMedia)) {
                            return false;
                 }
         if (this.starRatings != null && !Objects.equals(this.starRatings,typedThat.starRatings)) {
                            return false;
                 }
         if (this.externalReference != null && !Objects.equals(this.externalReference,typedThat.externalReference)) {
                            return false;
                 }
         if (this.actions != null && !Objects.equals(this.actions,typedThat.actions)) {
                            return false;
                 }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode()
    ,this.localAssets
    ,this.knownLocations
    ,this.nestedLocations
    ,this.groupingLocations
    ,this.peerLocations
    ,this.localHosts
    ,this.comments
    ,this.tags
    ,this.meaning
    ,this.impactingProjects
    ,this.facets
    ,this.licenses
    ,this.alsoKnownAs
    ,this.likes
    ,this.noteLogs
    ,this.certifications
    ,this.managedResources
    ,this.relatedMedia
    ,this.starRatings
    ,this.externalReference
    ,this.actions
       );
    }

    @Override
    public String toString() {
        return toString(new StringBuilder()).toString();
    }
}
