/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright Contributors to the ODPi Egeria project. */

// This is a generated file - do not edit - changes should be made to the templates amd/or generator to generate this file with changes.

package org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ContactThrough;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.*;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.*;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;

import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ContactThrough.ContactThrough;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.*;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;

import java.util.*;

/**
 * Static mapping methods to map between ContactThrough and the omrs Relationship.
 */
public class ContactThroughMapper {
       private static final Logger log = LoggerFactory.getLogger(ContactThroughMapper.class);
       private static final String className = ContactThroughMapper.class.getName();

       public static ContactThrough mapOmrsRelationshipToContactThrough(Relationship omrsRelationship)  throws InvalidParameterException {
                String methodName = "mapOmrsRelationshipToContactThrough";

               if (!"ContactThrough".equals(omrsRelationship.getType().getTypeDefName())) {
                      SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.INVALID_RELATIOMSHIP_GUID_WRONG_TYPE;
                      String errorMessage = errorCode.getErrorMessageId()
                          + errorCode.getFormattedErrorMessage(className,
                          methodName,omrsRelationship.getGUID(),"TermHASARelationship");
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                className,
                                methodName,
                                errorMessage,
                                errorCode.getSystemAction(),
                                errorCode.getUserAction());
               }
               ContactThrough contactThrough = new ContactThrough(omrsRelationship);

               SystemAttributes systemAttributes = new SystemAttributes();
               InstanceStatus instanceStatus =  omrsRelationship.getStatus();
               Status omrsBeanStatus = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
               systemAttributes.setStatus(omrsBeanStatus);
               systemAttributes.setCreatedBy(omrsRelationship.getCreatedBy());
               systemAttributes.setUpdatedBy(omrsRelationship.getUpdatedBy());
               systemAttributes.setCreateTime(omrsRelationship.getCreateTime());
               systemAttributes.setUpdateTime(omrsRelationship.getUpdateTime());
               systemAttributes.setVersion(omrsRelationship.getVersion());
               systemAttributes.setGUID(omrsRelationship.getGUID());
               contactThrough.setGuid(omrsRelationship.getGUID());
               contactThrough.setSystemAttributes(systemAttributes);

               InstanceProperties omrsRelationshipProperties = omrsRelationship.getProperties();
               if (omrsRelationshipProperties !=null) {
                 omrsRelationshipProperties.setEffectiveFromTime(contactThrough.getEffectiveFromTime());
                 omrsRelationshipProperties.setEffectiveToTime(contactThrough.getEffectiveToTime());
                 Iterator omrsPropertyIterator = omrsRelationshipProperties.getPropertyNames();
                 while (omrsPropertyIterator.hasNext()) {
                    String name = (String) omrsPropertyIterator.next();
                    //TODO check if this is a property we expect or whether the type has been added to.
                    // this is a property we expect
                    InstancePropertyValue value = omrsRelationshipProperties.getPropertyValue(name);
                    // supplied guid matches the expected type
                    Object actualValue;
                    switch (value.getInstancePropertyCategory()) {
                                               case PRIMITIVE:
                                                   PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue) value;
                                                   actualValue = primitivePropertyValue.getPrimitiveValue();
                                                   if (ContactThrough.ATTRIBUTE_NAMES_SET.contains(name)) {
                                                      if (name.equals("contactMethodValue")) {
                                                           contactThrough.setContactMethodValue((String)actualValue);
                                                      }
                                                   } else {
                                                       // put out the omrs value object
                                                       if (contactThrough.getExtraAttributes() ==null) {
                                                            Map<String, Object> extraAttributes = new HashMap();
                                                            contactThrough.setExtraAttributes(extraAttributes);
                                                        }
                                                      contactThrough.getExtraAttributes().put(name, primitivePropertyValue);
                                                   }
                                                   break;
                                               case ENUM:
                                                   EnumPropertyValue enumPropertyValue = (EnumPropertyValue) value;
                                                   String symbolicName = enumPropertyValue.getSymbolicName();
                                                   if (ContactThrough.ENUM_NAMES_SET.contains(name)) {
                                                        if (name.equals("contactMethodType")) {
                                                              org.odpi.openmetadata.accessservices.subjectarea.properties.enums.ContactMethodType contactMethodType = org.odpi.openmetadata.accessservices.subjectarea.properties.enums.ContactMethodType.valueOf(symbolicName);
                                                             contactThrough.setContactMethodType(contactMethodType);
                                                        }
                                                   } else {
                                                       // put out the omrs value object
                                                        if (contactThrough.getExtraAttributes() ==null) {
                                                            Map<String, Object> extraAttributes = new HashMap();
                                                            contactThrough.setExtraAttributes(extraAttributes);
                                                        }

                                                        contactThrough.getExtraAttributes().put(name, enumPropertyValue);
                                                    }
                       
                                                   break;
                                               case MAP:
                                                    if (contactThrough.MAP_NAMES_SET.contains(name)) {
                                                        MapPropertyValue mapPropertyValue = (MapPropertyValue) value;
                                                        InstanceProperties instancePropertyForMap = (InstanceProperties) mapPropertyValue.getMapValues();

                                                    }
                                                    break;
                                               case ARRAY:
                                               case STRUCT:
                                               case UNKNOWN:
                                                   // error
                                                   break;
                    }
                 }   // end while
               }
               return contactThrough;
       }
       public static Relationship mapContactThroughToOmrsRelationship(ContactThrough contactThrough) {
           Relationship omrsRelationship = Line.createOmrsRelationship(contactThrough);

           SystemAttributes systemAttributes = contactThrough.getSystemAttributes();
           if (systemAttributes!=null) {
               if (systemAttributes.getCreatedBy()!=null)
                   omrsRelationship.setCreatedBy(systemAttributes.getCreatedBy());
               if (systemAttributes.getUpdatedBy()!=null)
                   omrsRelationship.setUpdatedBy(systemAttributes.getUpdatedBy());
               if (systemAttributes.getCreateTime()!=null)
                   omrsRelationship.setCreateTime(systemAttributes.getCreateTime());
               if (systemAttributes.getUpdateTime()!=null)
                   omrsRelationship.setUpdateTime(systemAttributes.getUpdateTime());
               if (systemAttributes.getVersion()!=null)
                   omrsRelationship.setVersion(systemAttributes.getVersion());
                if (systemAttributes.getGUID()!=null)
                   omrsRelationship.setGUID(systemAttributes.getGUID());
               if (systemAttributes.getStatus()!=null) {
                   InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToInstanceStatus(systemAttributes.getStatus());
                   omrsRelationship.setStatus(instanceStatus);
               }
           }
           //set proxy 1
           EntityProxy entityOne = new EntityProxy();
           entityOne.setGUID(contactThrough.getEntity1Guid());
           String type1 = contactThrough.getEntity1Type();
           InstanceType instancetype1 = new InstanceType();
           instancetype1.setTypeDefName(type1);
           entityOne.setType(instancetype1);
           //set proxy 2
           EntityProxy entityTwo = new EntityProxy();
           entityTwo.setGUID(contactThrough.getEntity2Guid());
           String type2 = contactThrough.getEntity2Type();
           InstanceType instancetype2 = new InstanceType();
           instancetype2.setTypeDefName(type2);
           entityTwo.setType(instancetype2);
           // set relationshipType
           InstanceType relationshipType = new InstanceType();
           relationshipType.setTypeDefGUID(contactThrough.getTypeDefGuid());
           relationshipType.setTypeDefName("ContactThrough");
           omrsRelationship.setType(relationshipType);           
   
           omrsRelationship.setEntityOneProxy(entityOne);
           omrsRelationship.setEntityTwoProxy(entityTwo);           
           if (omrsRelationship.getGUID() == null) {
               omrsRelationship.setGUID(contactThrough.getGuid());
           }

           InstanceProperties instanceProperties = new InstanceProperties();
           // primitives

            if (contactThrough.getContactMethodValue()!=null) {
                PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue.setPrimitiveValue(contactThrough.getContactMethodValue());
                instanceProperties.setProperty("contactMethodValue", primitivePropertyValue);
            }
            if (contactThrough.getContactMethodType()!=null) {
                ContactMethodType enumType = contactThrough.getContactMethodType();
                EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
                enumPropertyValue.setOrdinal(enumType.ordinal());
                enumPropertyValue.setSymbolicName(enumType.name());
                instanceProperties.setProperty("contactMethodType", enumPropertyValue);
            }
            omrsRelationship.setProperties(instanceProperties);

           return omrsRelationship;
       }
}
