/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright Contributors to the ODPi Egeria project. */

// This is a generated file - do not edit - changes should be made to the templates amd/or generator to generate this file with changes.

package org.odpi.openmetadata.accessservices.subjectarea.generated.server;

import java.util.*;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
//omrs
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.repositoryservices.rest.properties.*;
import org.odpi.openmetadata.repositoryservices.archivemanager.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.archivemanager.OMRSArchiveAccessor;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
//omrs bean
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.accessservices.subjectarea.responses.*;
import org.odpi.openmetadata.accessservices.subjectarea.constraints.SubjectAreaConstraintsFactory;
import org.odpi.openmetadata.accessservices.subjectarea.constraints.SubjectAreaConstraint;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.*;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;

// omrs bean entity specific imports
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.CertificationType.CertificationType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.CertificationType.CertificationTypeReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.CertificationType.CertificationTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.APISchemaType.APISchemaType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.APISchemaType.APISchemaTypeReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.APISchemaType.APISchemaTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DataSet.DataSet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DataSet.DataSetReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DataSet.DataSetMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.OperatingPlatform.OperatingPlatform;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.OperatingPlatform.OperatingPlatformReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.OperatingPlatform.OperatingPlatformMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernancePolicy.GovernancePolicy;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernancePolicy.GovernancePolicyReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernancePolicy.GovernancePolicyMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DerivedSchemaAttribute.DerivedSchemaAttribute;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DerivedSchemaAttribute.DerivedSchemaAttributeReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DerivedSchemaAttribute.DerivedSchemaAttributeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Process.Process;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Process.ProcessReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Process.ProcessMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MapSchemaType.MapSchemaType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MapSchemaType.MapSchemaTypeReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MapSchemaType.MapSchemaTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DeployedSoftwareComponent.DeployedSoftwareComponent;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DeployedSoftwareComponent.DeployedSoftwareComponentReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DeployedSoftwareComponent.DeployedSoftwareComponentMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SchemaType.SchemaType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SchemaType.SchemaTypeReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SchemaType.SchemaTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DataFile.DataFile;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DataFile.DataFileReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DataFile.DataFileMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Like.Like;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Like.LikeReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Like.LikeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Referenceable.Referenceable;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Referenceable.ReferenceableReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Referenceable.ReferenceableMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ExternalReference.ExternalReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ExternalReference.ExternalReferenceReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ExternalReference.ExternalReferenceMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Endpoint.Endpoint;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Endpoint.EndpointReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Endpoint.EndpointMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ContactDetails.ContactDetails;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ContactDetails.ContactDetailsReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ContactDetails.ContactDetailsMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceDefinition.GovernanceDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceDefinition.GovernanceDefinitionReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceDefinition.GovernanceDefinitionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.FileFolder.FileFolder;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.FileFolder.FileFolderReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.FileFolder.FileFolderMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Network.Network;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Network.NetworkReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Network.NetworkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ActorProfile.ActorProfile;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ActorProfile.ActorProfileReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ActorProfile.ActorProfileMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Asset.Asset;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Asset.AssetReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Asset.AssetMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.APIOperation.APIOperation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.APIOperation.APIOperationReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.APIOperation.APIOperationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ToDo.ToDo;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ToDo.ToDoReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ToDo.ToDoMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.NetworkGateway.NetworkGateway;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.NetworkGateway.NetworkGatewayReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.NetworkGateway.NetworkGatewayMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceResponsibility.GovernanceResponsibility;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceResponsibility.GovernanceResponsibilityReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceResponsibility.GovernanceResponsibilityMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ImplementationSnippet.ImplementationSnippet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ImplementationSnippet.ImplementationSnippetReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ImplementationSnippet.ImplementationSnippetMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.UserIdentity.UserIdentity;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.UserIdentity.UserIdentityReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.UserIdentity.UserIdentityMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.NoteEntry.NoteEntry;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.NoteEntry.NoteEntryReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.NoteEntry.NoteEntryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.PropertyFacet.PropertyFacet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.PropertyFacet.PropertyFacetReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.PropertyFacet.PropertyFacetMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Project.ProjectReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Project.ProjectMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.HostCluster.HostCluster;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.HostCluster.HostClusterReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.HostCluster.HostClusterMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.GlossaryReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.GlossaryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryCategory.GlossaryCategory;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryCategory.GlossaryCategoryReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryCategory.GlossaryCategoryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MediaCollection.MediaCollection;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MediaCollection.MediaCollectionReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MediaCollection.MediaCollectionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Collection.Collection;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Collection.CollectionReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Collection.CollectionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.InformalTag.InformalTag;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.InformalTag.InformalTagReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.InformalTag.InformalTagMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceZone.GovernanceZone;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceZone.GovernanceZoneReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceZone.GovernanceZoneMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Application.Application;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Application.ApplicationReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Application.ApplicationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Person.Person;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Person.PersonReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Person.PersonMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.VirtualContainer.VirtualContainer;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.VirtualContainer.VirtualContainerReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.VirtualContainer.VirtualContainerMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceDriver.GovernanceDriver;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceDriver.GovernanceDriverReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceDriver.GovernanceDriverMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Meeting.Meeting;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Meeting.MeetingReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Meeting.MeetingMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SoftwareServerPlatform.SoftwareServerPlatform;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SoftwareServerPlatform.SoftwareServerPlatformReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SoftwareServerPlatform.SoftwareServerPlatformMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Rating.Rating;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Rating.RatingReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Rating.RatingMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ProjectCharter.ProjectCharter;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ProjectCharter.ProjectCharterReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ProjectCharter.ProjectCharterMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SoftwareServerCapability.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SoftwareServerCapability.SoftwareServerCapabilityReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SoftwareServerCapability.SoftwareServerCapabilityMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.LicenseType.LicenseType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.LicenseType.LicenseTypeReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.LicenseType.LicenseTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GraphVertex.GraphVertex;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GraphVertex.GraphVertexReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GraphVertex.GraphVertexMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryTerm.GlossaryTerm;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryTerm.GlossaryTermReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryTerm.GlossaryTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Team.Team;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Team.TeamReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Team.TeamMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MetadataCollection.MetadataCollection;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MetadataCollection.MetadataCollectionReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MetadataCollection.MetadataCollectionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceControl.GovernanceControl;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceControl.GovernanceControlReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceControl.GovernanceControlMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Topic.Topic;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Topic.TopicReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Topic.TopicMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SoftwareServer.SoftwareServer;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SoftwareServer.SoftwareServerReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SoftwareServer.SoftwareServerMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DeployedAPI.DeployedAPI;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DeployedAPI.DeployedAPIReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DeployedAPI.DeployedAPIMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MediaFile.MediaFile;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MediaFile.MediaFileReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MediaFile.MediaFileMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Comment.Comment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Comment.CommentReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Comment.CommentMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.RelatedMedia.RelatedMedia;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.RelatedMedia.RelatedMediaReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.RelatedMedia.RelatedMediaMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ConnectorType.ConnectorType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ConnectorType.ConnectorTypeReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ConnectorType.ConnectorTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.CohortMember.CohortMember;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.CohortMember.CohortMemberReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.CohortMember.CohortMemberMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ComplexSchemaType.ComplexSchemaType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ComplexSchemaType.ComplexSchemaTypeReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ComplexSchemaType.ComplexSchemaTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceMetric.GovernanceMetric;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceMetric.GovernanceMetricReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceMetric.GovernanceMetricMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ExternalId.ExternalId;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ExternalId.ExternalIdReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ExternalId.ExternalIdMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Connection.Connection;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Connection.ConnectionReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Connection.ConnectionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Host.Host;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Host.HostReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Host.HostMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SubscriberList.SubscriberList;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SubscriberList.SubscriberListReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SubscriberList.SubscriberListMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.CommunityMember.CommunityMember;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.CommunityMember.CommunityMemberReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.CommunityMember.CommunityMemberMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceRule.GovernanceRule;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceRule.GovernanceRuleReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceRule.GovernanceRuleMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MetadataRepositoryCohort.MetadataRepositoryCohort;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MetadataRepositoryCohort.MetadataRepositoryCohortReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MetadataRepositoryCohort.MetadataRepositoryCohortMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.NoteLog.NoteLog;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.NoteLog.NoteLogReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.NoteLog.NoteLogMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ExternalGlossaryLink.ExternalGlossaryLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ExternalGlossaryLink.ExternalGlossaryLinkReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ExternalGlossaryLink.ExternalGlossaryLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.VirtualConnection.VirtualConnection;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.VirtualConnection.VirtualConnectionReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.VirtualConnection.VirtualConnectionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Regulation.Regulation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Regulation.RegulationReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Regulation.RegulationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceProcess.GovernanceProcess;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceProcess.GovernanceProcessReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceProcess.GovernanceProcessMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SchemaAttribute.SchemaAttribute;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SchemaAttribute.SchemaAttributeReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SchemaAttribute.SchemaAttributeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GraphEdge.GraphEdge;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GraphEdge.GraphEdgeReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GraphEdge.GraphEdgeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Community.Community;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Community.CommunityReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Community.CommunityMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Location.Location;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Location.LocationReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Location.LocationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.BusinessCapability.BusinessCapability;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.BusinessCapability.BusinessCapabilityReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.BusinessCapability.BusinessCapabilityMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SchemaLinkElement.SchemaLinkElement;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SchemaLinkElement.SchemaLinkElementReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SchemaLinkElement.SchemaLinkElementMapper;
// omrs bean relationship specific imports
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.OMRSRelationshipToLines;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.UsedInContext.UsedInContext;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.UsedInContext.UsedInContextMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedComment.AttachedComment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedComment.AttachedCommentMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ContactThrough.ContactThrough;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ContactThrough.ContactThroughMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.License.License;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.License.LicenseMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ZoneGovernance.ZoneGovernance;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ZoneGovernance.ZoneGovernanceMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.FolderHierarchy.FolderHierarchy;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.FolderHierarchy.FolderHierarchyMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostClusterMember.HostClusterMember;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostClusterMember.HostClusterMemberMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LibraryCategoryReference.LibraryCategoryReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LibraryCategoryReference.LibraryCategoryReferenceMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectCharterLink.ProjectCharterLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectCharterLink.ProjectCharterLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProfileIdentity.ProfileIdentity;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProfileIdentity.ProfileIdentityMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoSource.ToDoSource;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoSource.ToDoSourceMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Translation.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Translation.TranslationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaLinkToType.SchemaLinkToType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaLinkToType.SchemaLinkToTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.DataContentForDataSet.DataContentForDataSet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.DataContentForDataSet.DataContentForDataSetMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ServerEndpoint.ServerEndpoint;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ServerEndpoint.ServerEndpointMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdLink.ExternalIdLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdLink.ExternalIdLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CategoryHierarchyLink.CategoryHierarchyLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CategoryHierarchyLink.CategoryHierarchyLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.PreferredTerm.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.PreferredTerm.PreferredTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectHierarchy.ProjectHierarchy;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectHierarchy.ProjectHierarchyMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.DeployedVirtualContainer.DeployedVirtualContainer;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.DeployedVirtualContainer.DeployedVirtualContainerMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceResults.GovernanceResults;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceResults.GovernanceResultsMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIResponse.APIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIResponse.APIResponseMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostNetwork.HostNetwork;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostNetwork.HostNetworkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttributeForSchema.AttributeForSchema;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttributeForSchema.AttributeForSchemaMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetLocation.AssetLocation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetLocation.AssetLocationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaAttributeType.SchemaAttributeType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaAttributeType.SchemaAttributeTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceImplementation.GovernanceImplementation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceImplementation.GovernanceImplementationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LinkedMedia.LinkedMedia;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LinkedMedia.LinkedMediaMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MapToElementType.MapToElementType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MapToElementType.MapToElementTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternallySourcedGlossary.ExternallySourcedGlossary;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternallySourcedGlossary.ExternallySourcedGlossaryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalReferenceLink.ExternalReferenceLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalReferenceLink.ExternalReferenceLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MediaReference.MediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MediaReference.MediaReferenceMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CommunityMembership.CommunityMembership;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CommunityMembership.CommunityMembershipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdScope.ExternalIdScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdScope.ExternalIdScopeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ValidValue.ValidValue;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ValidValue.ValidValueMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AcceptedAnswer.AcceptedAnswer;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AcceptedAnswer.AcceptedAnswerMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceDefinitionMetric.GovernanceDefinitionMetric;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceDefinitionMetric.GovernanceDefinitionMetricMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaQueryImplementation.SchemaQueryImplementation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaQueryImplementation.SchemaQueryImplementationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetSchemaType.AssetSchemaType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetSchemaType.AssetSchemaTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectDependency.ProjectDependency;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectDependency.ProjectDependencyMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TopicSubscribers.TopicSubscribers;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TopicSubscribers.TopicSubscribersMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReplacementTerm.ReplacementTerm;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReplacementTerm.ReplacementTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.OrganizationalCapability.OrganizationalCapability;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.OrganizationalCapability.OrganizationalCapabilityMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MetadataCohortPeer.MetadataCohortPeer;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MetadataCohortPeer.MetadataCohortPeerMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedNoteLogEntry.AttachedNoteLogEntry;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedNoteLogEntry.AttachedNoteLogEntryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetServerUse.AssetServerUse;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetServerUse.AssetServerUseMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RuntimeForProcess.RuntimeForProcess;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RuntimeForProcess.RuntimeForProcessMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.NestedLocation.NestedLocation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.NestedLocation.NestedLocationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LinkedFile.LinkedFile;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LinkedFile.LinkedFileMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermCategorization.TermCategorization;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermCategorization.TermCategorizationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIEndpoint.APIEndpoint;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIEndpoint.APIEndpointMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionEndpoint.ConnectionEndpoint;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionEndpoint.ConnectionEndpointMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CategoryAnchor.CategoryAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CategoryAnchor.CategoryAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectTeam.ProjectTeam;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectTeam.ProjectTeamMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProcessOutput.ProcessOutput;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProcessOutput.ProcessOutputMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIOperations.APIOperations;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIOperations.APIOperationsMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernancePolicyLink.GovernancePolicyLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernancePolicyLink.GovernancePolicyLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ResponsibilityStaffContact.ResponsibilityStaffContact;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ResponsibilityStaffContact.ResponsibilityStaffContactMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Peer.Peer;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Peer.PeerMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermTYPEDBYRelationship.TermTYPEDBYRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermTYPEDBYRelationship.TermTYPEDBYRelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MapFromElementType.MapFromElementType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MapFromElementType.MapFromElementTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Certification.Certification;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Certification.CertificationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.NetworkGatewayLink.NetworkGatewayLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.NetworkGatewayLink.NetworkGatewayLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionConnectorType.ConnectionConnectorType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionConnectorType.ConnectionConnectorTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Synonym.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Synonym.SynonymMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Antonym.Antonym;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Antonym.AntonymMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GraphEdgeLink.GraphEdgeLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GraphEdgeLink.GraphEdgeLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectScope.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectScope.ProjectScopeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ISARelationship.ISARelationship;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ISARelationship.ISARelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermISATypeOFRelationship.TermISATypeOFRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermISATypeOFRelationship.TermISATypeOFRelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.EmbeddedConnection.EmbeddedConnection;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.EmbeddedConnection.EmbeddedConnectionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceControlLink.GovernanceControlLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceControlLink.GovernanceControlLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedRating.AttachedRating;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedRating.AttachedRatingMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedNoteLog.AttachedNoteLog;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedNoteLog.AttachedNoteLogMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionToAsset.ConnectionToAsset;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionToAsset.ConnectionToAssetMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RegulationCertificationType.RegulationCertificationType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RegulationCertificationType.RegulationCertificationTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LinkedType.LinkedType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LinkedType.LinkedTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceRuleImplementation.GovernanceRuleImplementation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceRuleImplementation.GovernanceRuleImplementationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AdjacentLocation.AdjacentLocation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AdjacentLocation.AdjacentLocationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SemanticAssignment.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SemanticAssignment.SemanticAssignmentMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostLocation.HostLocation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostLocation.HostLocationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RelatedTerm.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RelatedTerm.RelatedTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaTypeImplementation.SchemaTypeImplementation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaTypeImplementation.SchemaTypeImplementationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProcessInput.ProcessInput;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProcessInput.ProcessInputMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIHeader.APIHeader;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIHeader.APIHeaderMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LibraryTermReference.LibraryTermReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LibraryTermReference.LibraryTermReferenceMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedTag.AttachedTag;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedTag.AttachedTagMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermHASARelationship.TermHASARelationship;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermHASARelationship.TermHASARelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceProcessImplementation.GovernanceProcessImplementation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceProcessImplementation.GovernanceProcessImplementationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GroupedMedia.GroupedMedia;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GroupedMedia.GroupedMediaMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceResponse.GovernanceResponse;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceResponse.GovernanceResponseMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.NestedFile.NestedFile;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.NestedFile.NestedFileMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostOperatingPlatform.HostOperatingPlatform;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostOperatingPlatform.HostOperatingPlatformMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermAnchor.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermAnchor.TermAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIRequest.APIRequest;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIRequest.APIRequestMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CohortMemberMetadataCollection.CohortMemberMetadataCollection;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CohortMemberMetadataCollection.CohortMemberMetadataCollectionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReferenceableFacet.ReferenceableFacet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReferenceableFacet.ReferenceableFacetMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedLike.AttachedLike;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedLike.AttachedLikeMapper;

/**
 * The OMRS API exposes concepts like Entities Relationships and Classifications, all of which have properties.
 * So the Subject Area OMAS can more easily consume this content, a subset of the OMRS content is exposed as java beans.
 * These java beans are accessed using this class.
 */

public class SubjectAreaBeansToAccessOMRS  {

    private static final Logger log = LoggerFactory.getLogger(SubjectAreaBeansToAccessOMRS.class);
    private static final String className = SubjectAreaBeansToAccessOMRS.class.getName();

    // The OMRSAPIHelper allows the junits to mock out the omrs layer.
    private OMRSAPIHelper oMRSAPIHelper =new OMRSAPIHelper();

    public SubjectAreaBeansToAccessOMRS() {
    }
    public void setOMRSAPIHelper(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper=oMRSAPIHelper;
    }

    /**
     * Fetch complete definition of an certificationType given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the certificationTypes relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return CertificationType the CertificationType entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public CertificationType getCertificationTypeById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getCertificationTypeById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        CertificationType gotcertificationType = CertificationTypeMapper.mapOmrsEntityDetailToCertificationType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotcertificationType );
        }
        return gotcertificationType;

    }
    /**
     * Create new certificationType.
     * @param userId user identity
     * @param certificationType the input entity with values.
     * @return CertificationType the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public CertificationType createCertificationType(String userId,CertificationType certificationType)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createCertificationTypeById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("CertificationType");
        if (constraint!=null) {
             constraint.preCreate(certificationType);
        }

        EntityDetail entityDetail = CertificationTypeMapper.mapCertificationTypeToOmrsEntityDetail(certificationType);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        CertificationType createdCertificationType =  CertificationTypeMapper.mapOmrsEntityDetailToCertificationType(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created CertificationType="+ createdCertificationType );
        }
        return createdCertificationType;
    }
    /**
     * Update certificationType
     * @param userId user identity
     * @param certificationType   certificationType to update
     * @return CertificationType the updated certificationType entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public CertificationType updateCertificationType(String userId, CertificationType certificationType)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateCertificationTypeById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = CertificationTypeMapper.mapCertificationTypeToOmrsEntityDetail(certificationType);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            CertificationType updatedCertificationType =  CertificationTypeMapper.mapOmrsEntityDetailToCertificationType(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated CertificationType="+ updatedCertificationType );
            }
            return updatedCertificationType;
        }

    /**
     * Delete an certificationType identified by its GUID. Delete is a soft delete, this means that the certificationType has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the certificationType
     * @return CertificationType the deleted CertificationType entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteCertificationTypeByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteCertificationTypeByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the CertificationType type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("CertificationType");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"CertificationType",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an certificationType identified by its GUID. Delete is a hard delete, this means that the certificationType is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the certificationType
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeCertificationTypeByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeCertificationTypeByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the CertificationType type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("CertificationType");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"CertificationType",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an CertificationType identified by its GUID. Restore resurrects a soft deleted CertificationType. When a CertificationType was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the CertificationType
     * @return  CertificationType the restored CertificationType
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the CertificationType is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public CertificationType restoreCertificationType(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreCertificationTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        CertificationType restoredCertificationType =  CertificationTypeMapper.mapOmrsEntityDetailToCertificationType(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredCertificationType;
    }    

    /**
     * Add classifications to the supplied certificationType
     * @param userId user identity
     * @param entityGuid the GUID value for certificationType
     * @param classifications the classifications to apply.
     * @return the certificationType entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public CertificationType addCertificationTypeClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addCertificationTypeClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         CertificationType certificationTypeClassifications = CertificationTypeMapper.mapOmrsEntityDetailToCertificationType(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified CertificationType=" +  certificationTypeClassifications);
         }
         return  certificationTypeClassifications;
    }

    /**
     * Updates classifications to an existing certificationType represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the certificationType
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given certificationType guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public CertificationType updateCertificationTypeClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateCertificationTypeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           CertificationType  certificationTypeClassifications = CertificationTypeMapper.mapOmrsEntityDetailToCertificationType(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  certificationTypeClassifications;
    }

    /**
     * Deletes a given classification from an existing certificationType represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the certificationType
     * @param name name of the classification
     * @return deleted CertificationType  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public CertificationType deleteCertificationTypeClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteCertificationTypeClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       CertificationType declassifiedCertificationType =  CertificationTypeMapper.mapOmrsEntityDetailToCertificationType(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedCertificationType;
    }

    /**
      * Get the relationships associated with entity certificationType represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the certificationType
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getCertificationTypeRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getCertificationTypeRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an aPISchemaType given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the aPISchemaTypes relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return APISchemaType the APISchemaType entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public APISchemaType getAPISchemaTypeById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getAPISchemaTypeById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        APISchemaType gotaPISchemaType = APISchemaTypeMapper.mapOmrsEntityDetailToAPISchemaType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotaPISchemaType );
        }
        return gotaPISchemaType;

    }
    /**
     * Create new aPISchemaType.
     * @param userId user identity
     * @param aPISchemaType the input entity with values.
     * @return APISchemaType the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public APISchemaType createAPISchemaType(String userId,APISchemaType aPISchemaType)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createAPISchemaTypeById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("APISchemaType");
        if (constraint!=null) {
             constraint.preCreate(aPISchemaType);
        }

        EntityDetail entityDetail = APISchemaTypeMapper.mapAPISchemaTypeToOmrsEntityDetail(aPISchemaType);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        APISchemaType createdAPISchemaType =  APISchemaTypeMapper.mapOmrsEntityDetailToAPISchemaType(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created APISchemaType="+ createdAPISchemaType );
        }
        return createdAPISchemaType;
    }
    /**
     * Update aPISchemaType
     * @param userId user identity
     * @param aPISchemaType   aPISchemaType to update
     * @return APISchemaType the updated aPISchemaType entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public APISchemaType updateAPISchemaType(String userId, APISchemaType aPISchemaType)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateAPISchemaTypeById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = APISchemaTypeMapper.mapAPISchemaTypeToOmrsEntityDetail(aPISchemaType);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            APISchemaType updatedAPISchemaType =  APISchemaTypeMapper.mapOmrsEntityDetailToAPISchemaType(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated APISchemaType="+ updatedAPISchemaType );
            }
            return updatedAPISchemaType;
        }

    /**
     * Delete an aPISchemaType identified by its GUID. Delete is a soft delete, this means that the aPISchemaType has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the aPISchemaType
     * @return APISchemaType the deleted APISchemaType entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteAPISchemaTypeByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteAPISchemaTypeByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the APISchemaType type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("APISchemaType");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"APISchemaType",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an aPISchemaType identified by its GUID. Delete is a hard delete, this means that the aPISchemaType is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the aPISchemaType
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeAPISchemaTypeByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeAPISchemaTypeByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the APISchemaType type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("APISchemaType");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"APISchemaType",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an APISchemaType identified by its GUID. Restore resurrects a soft deleted APISchemaType. When a APISchemaType was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the APISchemaType
     * @return  APISchemaType the restored APISchemaType
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the APISchemaType is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public APISchemaType restoreAPISchemaType(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreAPISchemaTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        APISchemaType restoredAPISchemaType =  APISchemaTypeMapper.mapOmrsEntityDetailToAPISchemaType(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredAPISchemaType;
    }    

    /**
     * Add classifications to the supplied aPISchemaType
     * @param userId user identity
     * @param entityGuid the GUID value for aPISchemaType
     * @param classifications the classifications to apply.
     * @return the aPISchemaType entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public APISchemaType addAPISchemaTypeClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addAPISchemaTypeClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         APISchemaType aPISchemaTypeClassifications = APISchemaTypeMapper.mapOmrsEntityDetailToAPISchemaType(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified APISchemaType=" +  aPISchemaTypeClassifications);
         }
         return  aPISchemaTypeClassifications;
    }

    /**
     * Updates classifications to an existing aPISchemaType represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the aPISchemaType
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given aPISchemaType guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public APISchemaType updateAPISchemaTypeClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateAPISchemaTypeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           APISchemaType  aPISchemaTypeClassifications = APISchemaTypeMapper.mapOmrsEntityDetailToAPISchemaType(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  aPISchemaTypeClassifications;
    }

    /**
     * Deletes a given classification from an existing aPISchemaType represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the aPISchemaType
     * @param name name of the classification
     * @return deleted APISchemaType  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public APISchemaType deleteAPISchemaTypeClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteAPISchemaTypeClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       APISchemaType declassifiedAPISchemaType =  APISchemaTypeMapper.mapOmrsEntityDetailToAPISchemaType(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedAPISchemaType;
    }

    /**
      * Get the relationships associated with entity aPISchemaType represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the aPISchemaType
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getAPISchemaTypeRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getAPISchemaTypeRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an dataSet given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the dataSets relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return DataSet the DataSet entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public DataSet getDataSetById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getDataSetById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        DataSet gotdataSet = DataSetMapper.mapOmrsEntityDetailToDataSet(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotdataSet );
        }
        return gotdataSet;

    }
    /**
     * Create new dataSet.
     * @param userId user identity
     * @param dataSet the input entity with values.
     * @return DataSet the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public DataSet createDataSet(String userId,DataSet dataSet)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createDataSetById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("DataSet");
        if (constraint!=null) {
             constraint.preCreate(dataSet);
        }

        EntityDetail entityDetail = DataSetMapper.mapDataSetToOmrsEntityDetail(dataSet);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        DataSet createdDataSet =  DataSetMapper.mapOmrsEntityDetailToDataSet(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created DataSet="+ createdDataSet );
        }
        return createdDataSet;
    }
    /**
     * Update dataSet
     * @param userId user identity
     * @param dataSet   dataSet to update
     * @return DataSet the updated dataSet entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public DataSet updateDataSet(String userId, DataSet dataSet)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateDataSetById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = DataSetMapper.mapDataSetToOmrsEntityDetail(dataSet);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            DataSet updatedDataSet =  DataSetMapper.mapOmrsEntityDetailToDataSet(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated DataSet="+ updatedDataSet );
            }
            return updatedDataSet;
        }

    /**
     * Delete an dataSet identified by its GUID. Delete is a soft delete, this means that the dataSet has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the dataSet
     * @return DataSet the deleted DataSet entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteDataSetByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteDataSetByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the DataSet type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("DataSet");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"DataSet",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an dataSet identified by its GUID. Delete is a hard delete, this means that the dataSet is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the dataSet
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeDataSetByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeDataSetByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the DataSet type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("DataSet");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"DataSet",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an DataSet identified by its GUID. Restore resurrects a soft deleted DataSet. When a DataSet was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the DataSet
     * @return  DataSet the restored DataSet
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the DataSet is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public DataSet restoreDataSet(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreDataSetByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        DataSet restoredDataSet =  DataSetMapper.mapOmrsEntityDetailToDataSet(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredDataSet;
    }    

    /**
     * Add classifications to the supplied dataSet
     * @param userId user identity
     * @param entityGuid the GUID value for dataSet
     * @param classifications the classifications to apply.
     * @return the dataSet entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public DataSet addDataSetClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addDataSetClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         DataSet dataSetClassifications = DataSetMapper.mapOmrsEntityDetailToDataSet(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified DataSet=" +  dataSetClassifications);
         }
         return  dataSetClassifications;
    }

    /**
     * Updates classifications to an existing dataSet represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the dataSet
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given dataSet guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public DataSet updateDataSetClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateDataSetClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           DataSet  dataSetClassifications = DataSetMapper.mapOmrsEntityDetailToDataSet(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  dataSetClassifications;
    }

    /**
     * Deletes a given classification from an existing dataSet represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the dataSet
     * @param name name of the classification
     * @return deleted DataSet  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public DataSet deleteDataSetClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteDataSetClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       DataSet declassifiedDataSet =  DataSetMapper.mapOmrsEntityDetailToDataSet(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedDataSet;
    }

    /**
      * Get the relationships associated with entity dataSet represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the dataSet
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getDataSetRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getDataSetRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an operatingPlatform given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the operatingPlatforms relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return OperatingPlatform the OperatingPlatform entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public OperatingPlatform getOperatingPlatformById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getOperatingPlatformById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        OperatingPlatform gotoperatingPlatform = OperatingPlatformMapper.mapOmrsEntityDetailToOperatingPlatform(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotoperatingPlatform );
        }
        return gotoperatingPlatform;

    }
    /**
     * Create new operatingPlatform.
     * @param userId user identity
     * @param operatingPlatform the input entity with values.
     * @return OperatingPlatform the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public OperatingPlatform createOperatingPlatform(String userId,OperatingPlatform operatingPlatform)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createOperatingPlatformById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("OperatingPlatform");
        if (constraint!=null) {
             constraint.preCreate(operatingPlatform);
        }

        EntityDetail entityDetail = OperatingPlatformMapper.mapOperatingPlatformToOmrsEntityDetail(operatingPlatform);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        OperatingPlatform createdOperatingPlatform =  OperatingPlatformMapper.mapOmrsEntityDetailToOperatingPlatform(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created OperatingPlatform="+ createdOperatingPlatform );
        }
        return createdOperatingPlatform;
    }
    /**
     * Update operatingPlatform
     * @param userId user identity
     * @param operatingPlatform   operatingPlatform to update
     * @return OperatingPlatform the updated operatingPlatform entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public OperatingPlatform updateOperatingPlatform(String userId, OperatingPlatform operatingPlatform)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateOperatingPlatformById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = OperatingPlatformMapper.mapOperatingPlatformToOmrsEntityDetail(operatingPlatform);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            OperatingPlatform updatedOperatingPlatform =  OperatingPlatformMapper.mapOmrsEntityDetailToOperatingPlatform(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated OperatingPlatform="+ updatedOperatingPlatform );
            }
            return updatedOperatingPlatform;
        }

    /**
     * Delete an operatingPlatform identified by its GUID. Delete is a soft delete, this means that the operatingPlatform has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the operatingPlatform
     * @return OperatingPlatform the deleted OperatingPlatform entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteOperatingPlatformByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteOperatingPlatformByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the OperatingPlatform type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("OperatingPlatform");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"OperatingPlatform",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an operatingPlatform identified by its GUID. Delete is a hard delete, this means that the operatingPlatform is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the operatingPlatform
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeOperatingPlatformByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeOperatingPlatformByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the OperatingPlatform type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("OperatingPlatform");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"OperatingPlatform",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an OperatingPlatform identified by its GUID. Restore resurrects a soft deleted OperatingPlatform. When a OperatingPlatform was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the OperatingPlatform
     * @return  OperatingPlatform the restored OperatingPlatform
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the OperatingPlatform is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public OperatingPlatform restoreOperatingPlatform(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreOperatingPlatformByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        OperatingPlatform restoredOperatingPlatform =  OperatingPlatformMapper.mapOmrsEntityDetailToOperatingPlatform(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredOperatingPlatform;
    }    

    /**
     * Add classifications to the supplied operatingPlatform
     * @param userId user identity
     * @param entityGuid the GUID value for operatingPlatform
     * @param classifications the classifications to apply.
     * @return the operatingPlatform entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public OperatingPlatform addOperatingPlatformClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addOperatingPlatformClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         OperatingPlatform operatingPlatformClassifications = OperatingPlatformMapper.mapOmrsEntityDetailToOperatingPlatform(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified OperatingPlatform=" +  operatingPlatformClassifications);
         }
         return  operatingPlatformClassifications;
    }

    /**
     * Updates classifications to an existing operatingPlatform represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the operatingPlatform
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given operatingPlatform guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public OperatingPlatform updateOperatingPlatformClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateOperatingPlatformClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           OperatingPlatform  operatingPlatformClassifications = OperatingPlatformMapper.mapOmrsEntityDetailToOperatingPlatform(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  operatingPlatformClassifications;
    }

    /**
     * Deletes a given classification from an existing operatingPlatform represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the operatingPlatform
     * @param name name of the classification
     * @return deleted OperatingPlatform  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public OperatingPlatform deleteOperatingPlatformClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteOperatingPlatformClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       OperatingPlatform declassifiedOperatingPlatform =  OperatingPlatformMapper.mapOmrsEntityDetailToOperatingPlatform(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedOperatingPlatform;
    }

    /**
      * Get the relationships associated with entity operatingPlatform represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the operatingPlatform
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getOperatingPlatformRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getOperatingPlatformRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an governancePolicy given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the governancePolicies relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return GovernancePolicy the GovernancePolicy entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public GovernancePolicy getGovernancePolicyById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getGovernancePolicyById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        GovernancePolicy gotgovernancePolicy = GovernancePolicyMapper.mapOmrsEntityDetailToGovernancePolicy(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotgovernancePolicy );
        }
        return gotgovernancePolicy;

    }
    /**
     * Create new governancePolicy.
     * @param userId user identity
     * @param governancePolicy the input entity with values.
     * @return GovernancePolicy the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public GovernancePolicy createGovernancePolicy(String userId,GovernancePolicy governancePolicy)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createGovernancePolicyById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("GovernancePolicy");
        if (constraint!=null) {
             constraint.preCreate(governancePolicy);
        }

        EntityDetail entityDetail = GovernancePolicyMapper.mapGovernancePolicyToOmrsEntityDetail(governancePolicy);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        GovernancePolicy createdGovernancePolicy =  GovernancePolicyMapper.mapOmrsEntityDetailToGovernancePolicy(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created GovernancePolicy="+ createdGovernancePolicy );
        }
        return createdGovernancePolicy;
    }
    /**
     * Update governancePolicy
     * @param userId user identity
     * @param governancePolicy   governancePolicy to update
     * @return GovernancePolicy the updated governancePolicy entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public GovernancePolicy updateGovernancePolicy(String userId, GovernancePolicy governancePolicy)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateGovernancePolicyById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = GovernancePolicyMapper.mapGovernancePolicyToOmrsEntityDetail(governancePolicy);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            GovernancePolicy updatedGovernancePolicy =  GovernancePolicyMapper.mapOmrsEntityDetailToGovernancePolicy(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated GovernancePolicy="+ updatedGovernancePolicy );
            }
            return updatedGovernancePolicy;
        }

    /**
     * Delete an governancePolicy identified by its GUID. Delete is a soft delete, this means that the governancePolicy has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the governancePolicy
     * @return GovernancePolicy the deleted GovernancePolicy entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteGovernancePolicyByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteGovernancePolicyByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the GovernancePolicy type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernancePolicy");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"GovernancePolicy",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an governancePolicy identified by its GUID. Delete is a hard delete, this means that the governancePolicy is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the governancePolicy
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeGovernancePolicyByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeGovernancePolicyByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the GovernancePolicy type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernancePolicy");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"GovernancePolicy",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an GovernancePolicy identified by its GUID. Restore resurrects a soft deleted GovernancePolicy. When a GovernancePolicy was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the GovernancePolicy
     * @return  GovernancePolicy the restored GovernancePolicy
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the GovernancePolicy is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public GovernancePolicy restoreGovernancePolicy(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreGovernancePolicyByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        GovernancePolicy restoredGovernancePolicy =  GovernancePolicyMapper.mapOmrsEntityDetailToGovernancePolicy(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredGovernancePolicy;
    }    

    /**
     * Add classifications to the supplied governancePolicy
     * @param userId user identity
     * @param entityGuid the GUID value for governancePolicy
     * @param classifications the classifications to apply.
     * @return the governancePolicy entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public GovernancePolicy addGovernancePolicyClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addGovernancePolicyClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         GovernancePolicy governancePolicyClassifications = GovernancePolicyMapper.mapOmrsEntityDetailToGovernancePolicy(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified GovernancePolicy=" +  governancePolicyClassifications);
         }
         return  governancePolicyClassifications;
    }

    /**
     * Updates classifications to an existing governancePolicy represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the governancePolicy
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given governancePolicy guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public GovernancePolicy updateGovernancePolicyClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateGovernancePolicyClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           GovernancePolicy  governancePolicyClassifications = GovernancePolicyMapper.mapOmrsEntityDetailToGovernancePolicy(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  governancePolicyClassifications;
    }

    /**
     * Deletes a given classification from an existing governancePolicy represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the governancePolicy
     * @param name name of the classification
     * @return deleted GovernancePolicy  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public GovernancePolicy deleteGovernancePolicyClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteGovernancePolicyClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       GovernancePolicy declassifiedGovernancePolicy =  GovernancePolicyMapper.mapOmrsEntityDetailToGovernancePolicy(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedGovernancePolicy;
    }

    /**
      * Get the relationships associated with entity governancePolicy represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the governancePolicy
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getGovernancePolicyRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getGovernancePolicyRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an derivedSchemaAttribute given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the derivedSchemaAttributes relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return DerivedSchemaAttribute the DerivedSchemaAttribute entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public DerivedSchemaAttribute getDerivedSchemaAttributeById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getDerivedSchemaAttributeById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        DerivedSchemaAttribute gotderivedSchemaAttribute = DerivedSchemaAttributeMapper.mapOmrsEntityDetailToDerivedSchemaAttribute(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotderivedSchemaAttribute );
        }
        return gotderivedSchemaAttribute;

    }
    /**
     * Create new derivedSchemaAttribute.
     * @param userId user identity
     * @param derivedSchemaAttribute the input entity with values.
     * @return DerivedSchemaAttribute the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public DerivedSchemaAttribute createDerivedSchemaAttribute(String userId,DerivedSchemaAttribute derivedSchemaAttribute)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createDerivedSchemaAttributeById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("DerivedSchemaAttribute");
        if (constraint!=null) {
             constraint.preCreate(derivedSchemaAttribute);
        }

        EntityDetail entityDetail = DerivedSchemaAttributeMapper.mapDerivedSchemaAttributeToOmrsEntityDetail(derivedSchemaAttribute);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        DerivedSchemaAttribute createdDerivedSchemaAttribute =  DerivedSchemaAttributeMapper.mapOmrsEntityDetailToDerivedSchemaAttribute(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created DerivedSchemaAttribute="+ createdDerivedSchemaAttribute );
        }
        return createdDerivedSchemaAttribute;
    }
    /**
     * Update derivedSchemaAttribute
     * @param userId user identity
     * @param derivedSchemaAttribute   derivedSchemaAttribute to update
     * @return DerivedSchemaAttribute the updated derivedSchemaAttribute entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public DerivedSchemaAttribute updateDerivedSchemaAttribute(String userId, DerivedSchemaAttribute derivedSchemaAttribute)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateDerivedSchemaAttributeById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = DerivedSchemaAttributeMapper.mapDerivedSchemaAttributeToOmrsEntityDetail(derivedSchemaAttribute);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            DerivedSchemaAttribute updatedDerivedSchemaAttribute =  DerivedSchemaAttributeMapper.mapOmrsEntityDetailToDerivedSchemaAttribute(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated DerivedSchemaAttribute="+ updatedDerivedSchemaAttribute );
            }
            return updatedDerivedSchemaAttribute;
        }

    /**
     * Delete an derivedSchemaAttribute identified by its GUID. Delete is a soft delete, this means that the derivedSchemaAttribute has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the derivedSchemaAttribute
     * @return DerivedSchemaAttribute the deleted DerivedSchemaAttribute entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteDerivedSchemaAttributeByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteDerivedSchemaAttributeByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the DerivedSchemaAttribute type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("DerivedSchemaAttribute");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"DerivedSchemaAttribute",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an derivedSchemaAttribute identified by its GUID. Delete is a hard delete, this means that the derivedSchemaAttribute is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the derivedSchemaAttribute
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeDerivedSchemaAttributeByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeDerivedSchemaAttributeByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the DerivedSchemaAttribute type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("DerivedSchemaAttribute");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"DerivedSchemaAttribute",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an DerivedSchemaAttribute identified by its GUID. Restore resurrects a soft deleted DerivedSchemaAttribute. When a DerivedSchemaAttribute was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the DerivedSchemaAttribute
     * @return  DerivedSchemaAttribute the restored DerivedSchemaAttribute
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the DerivedSchemaAttribute is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public DerivedSchemaAttribute restoreDerivedSchemaAttribute(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreDerivedSchemaAttributeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        DerivedSchemaAttribute restoredDerivedSchemaAttribute =  DerivedSchemaAttributeMapper.mapOmrsEntityDetailToDerivedSchemaAttribute(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredDerivedSchemaAttribute;
    }    

    /**
     * Add classifications to the supplied derivedSchemaAttribute
     * @param userId user identity
     * @param entityGuid the GUID value for derivedSchemaAttribute
     * @param classifications the classifications to apply.
     * @return the derivedSchemaAttribute entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public DerivedSchemaAttribute addDerivedSchemaAttributeClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addDerivedSchemaAttributeClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         DerivedSchemaAttribute derivedSchemaAttributeClassifications = DerivedSchemaAttributeMapper.mapOmrsEntityDetailToDerivedSchemaAttribute(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified DerivedSchemaAttribute=" +  derivedSchemaAttributeClassifications);
         }
         return  derivedSchemaAttributeClassifications;
    }

    /**
     * Updates classifications to an existing derivedSchemaAttribute represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the derivedSchemaAttribute
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given derivedSchemaAttribute guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public DerivedSchemaAttribute updateDerivedSchemaAttributeClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateDerivedSchemaAttributeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           DerivedSchemaAttribute  derivedSchemaAttributeClassifications = DerivedSchemaAttributeMapper.mapOmrsEntityDetailToDerivedSchemaAttribute(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  derivedSchemaAttributeClassifications;
    }

    /**
     * Deletes a given classification from an existing derivedSchemaAttribute represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the derivedSchemaAttribute
     * @param name name of the classification
     * @return deleted DerivedSchemaAttribute  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public DerivedSchemaAttribute deleteDerivedSchemaAttributeClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteDerivedSchemaAttributeClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       DerivedSchemaAttribute declassifiedDerivedSchemaAttribute =  DerivedSchemaAttributeMapper.mapOmrsEntityDetailToDerivedSchemaAttribute(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedDerivedSchemaAttribute;
    }

    /**
      * Get the relationships associated with entity derivedSchemaAttribute represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the derivedSchemaAttribute
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getDerivedSchemaAttributeRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getDerivedSchemaAttributeRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an process given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the processes relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return Process the Process entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Process getProcessById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getProcessById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        Process gotprocess = ProcessMapper.mapOmrsEntityDetailToProcess(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotprocess );
        }
        return gotprocess;

    }
    /**
     * Create new process.
     * @param userId user identity
     * @param process the input entity with values.
     * @return Process the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public Process createProcess(String userId,Process process)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createProcessById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Process");
        if (constraint!=null) {
             constraint.preCreate(process);
        }

        EntityDetail entityDetail = ProcessMapper.mapProcessToOmrsEntityDetail(process);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        Process createdProcess =  ProcessMapper.mapOmrsEntityDetailToProcess(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created Process="+ createdProcess );
        }
        return createdProcess;
    }
    /**
     * Update process
     * @param userId user identity
     * @param process   process to update
     * @return Process the updated process entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Process updateProcess(String userId, Process process)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateProcessById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = ProcessMapper.mapProcessToOmrsEntityDetail(process);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            Process updatedProcess =  ProcessMapper.mapOmrsEntityDetailToProcess(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated Process="+ updatedProcess );
            }
            return updatedProcess;
        }

    /**
     * Delete an process identified by its GUID. Delete is a soft delete, this means that the process has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the process
     * @return Process the deleted Process entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteProcessByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteProcessByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Process type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Process");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"Process",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an process identified by its GUID. Delete is a hard delete, this means that the process is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the process
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeProcessByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeProcessByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Process type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Process");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"Process",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an Process identified by its GUID. Restore resurrects a soft deleted Process. When a Process was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the Process
     * @return  Process the restored Process
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the Process is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public Process restoreProcess(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreProcessByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        Process restoredProcess =  ProcessMapper.mapOmrsEntityDetailToProcess(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredProcess;
    }    

    /**
     * Add classifications to the supplied process
     * @param userId user identity
     * @param entityGuid the GUID value for process
     * @param classifications the classifications to apply.
     * @return the process entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public Process addProcessClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addProcessClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         Process processClassifications = ProcessMapper.mapOmrsEntityDetailToProcess(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified Process=" +  processClassifications);
         }
         return  processClassifications;
    }

    /**
     * Updates classifications to an existing process represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the process
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given process guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Process updateProcessClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateProcessClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           Process  processClassifications = ProcessMapper.mapOmrsEntityDetailToProcess(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  processClassifications;
    }

    /**
     * Deletes a given classification from an existing process represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the process
     * @param name name of the classification
     * @return deleted Process  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Process deleteProcessClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteProcessClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       Process declassifiedProcess =  ProcessMapper.mapOmrsEntityDetailToProcess(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedProcess;
    }

    /**
      * Get the relationships associated with entity process represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the process
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getProcessRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getProcessRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an mapSchemaType given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the mapSchemaTypes relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return MapSchemaType the MapSchemaType entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public MapSchemaType getMapSchemaTypeById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getMapSchemaTypeById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        MapSchemaType gotmapSchemaType = MapSchemaTypeMapper.mapOmrsEntityDetailToMapSchemaType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotmapSchemaType );
        }
        return gotmapSchemaType;

    }
    /**
     * Create new mapSchemaType.
     * @param userId user identity
     * @param mapSchemaType the input entity with values.
     * @return MapSchemaType the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public MapSchemaType createMapSchemaType(String userId,MapSchemaType mapSchemaType)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createMapSchemaTypeById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("MapSchemaType");
        if (constraint!=null) {
             constraint.preCreate(mapSchemaType);
        }

        EntityDetail entityDetail = MapSchemaTypeMapper.mapMapSchemaTypeToOmrsEntityDetail(mapSchemaType);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        MapSchemaType createdMapSchemaType =  MapSchemaTypeMapper.mapOmrsEntityDetailToMapSchemaType(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created MapSchemaType="+ createdMapSchemaType );
        }
        return createdMapSchemaType;
    }
    /**
     * Update mapSchemaType
     * @param userId user identity
     * @param mapSchemaType   mapSchemaType to update
     * @return MapSchemaType the updated mapSchemaType entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public MapSchemaType updateMapSchemaType(String userId, MapSchemaType mapSchemaType)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateMapSchemaTypeById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = MapSchemaTypeMapper.mapMapSchemaTypeToOmrsEntityDetail(mapSchemaType);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            MapSchemaType updatedMapSchemaType =  MapSchemaTypeMapper.mapOmrsEntityDetailToMapSchemaType(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated MapSchemaType="+ updatedMapSchemaType );
            }
            return updatedMapSchemaType;
        }

    /**
     * Delete an mapSchemaType identified by its GUID. Delete is a soft delete, this means that the mapSchemaType has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the mapSchemaType
     * @return MapSchemaType the deleted MapSchemaType entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteMapSchemaTypeByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteMapSchemaTypeByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the MapSchemaType type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("MapSchemaType");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"MapSchemaType",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an mapSchemaType identified by its GUID. Delete is a hard delete, this means that the mapSchemaType is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the mapSchemaType
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeMapSchemaTypeByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeMapSchemaTypeByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the MapSchemaType type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("MapSchemaType");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"MapSchemaType",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an MapSchemaType identified by its GUID. Restore resurrects a soft deleted MapSchemaType. When a MapSchemaType was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the MapSchemaType
     * @return  MapSchemaType the restored MapSchemaType
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the MapSchemaType is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public MapSchemaType restoreMapSchemaType(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreMapSchemaTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        MapSchemaType restoredMapSchemaType =  MapSchemaTypeMapper.mapOmrsEntityDetailToMapSchemaType(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredMapSchemaType;
    }    

    /**
     * Add classifications to the supplied mapSchemaType
     * @param userId user identity
     * @param entityGuid the GUID value for mapSchemaType
     * @param classifications the classifications to apply.
     * @return the mapSchemaType entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public MapSchemaType addMapSchemaTypeClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addMapSchemaTypeClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         MapSchemaType mapSchemaTypeClassifications = MapSchemaTypeMapper.mapOmrsEntityDetailToMapSchemaType(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified MapSchemaType=" +  mapSchemaTypeClassifications);
         }
         return  mapSchemaTypeClassifications;
    }

    /**
     * Updates classifications to an existing mapSchemaType represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the mapSchemaType
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given mapSchemaType guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public MapSchemaType updateMapSchemaTypeClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateMapSchemaTypeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           MapSchemaType  mapSchemaTypeClassifications = MapSchemaTypeMapper.mapOmrsEntityDetailToMapSchemaType(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  mapSchemaTypeClassifications;
    }

    /**
     * Deletes a given classification from an existing mapSchemaType represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the mapSchemaType
     * @param name name of the classification
     * @return deleted MapSchemaType  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public MapSchemaType deleteMapSchemaTypeClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteMapSchemaTypeClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       MapSchemaType declassifiedMapSchemaType =  MapSchemaTypeMapper.mapOmrsEntityDetailToMapSchemaType(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedMapSchemaType;
    }

    /**
      * Get the relationships associated with entity mapSchemaType represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the mapSchemaType
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getMapSchemaTypeRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getMapSchemaTypeRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an deployedSoftwareComponent given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the deployedSoftwareComponents relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return DeployedSoftwareComponent the DeployedSoftwareComponent entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public DeployedSoftwareComponent getDeployedSoftwareComponentById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getDeployedSoftwareComponentById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        DeployedSoftwareComponent gotdeployedSoftwareComponent = DeployedSoftwareComponentMapper.mapOmrsEntityDetailToDeployedSoftwareComponent(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotdeployedSoftwareComponent );
        }
        return gotdeployedSoftwareComponent;

    }
    /**
     * Create new deployedSoftwareComponent.
     * @param userId user identity
     * @param deployedSoftwareComponent the input entity with values.
     * @return DeployedSoftwareComponent the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public DeployedSoftwareComponent createDeployedSoftwareComponent(String userId,DeployedSoftwareComponent deployedSoftwareComponent)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createDeployedSoftwareComponentById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("DeployedSoftwareComponent");
        if (constraint!=null) {
             constraint.preCreate(deployedSoftwareComponent);
        }

        EntityDetail entityDetail = DeployedSoftwareComponentMapper.mapDeployedSoftwareComponentToOmrsEntityDetail(deployedSoftwareComponent);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        DeployedSoftwareComponent createdDeployedSoftwareComponent =  DeployedSoftwareComponentMapper.mapOmrsEntityDetailToDeployedSoftwareComponent(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created DeployedSoftwareComponent="+ createdDeployedSoftwareComponent );
        }
        return createdDeployedSoftwareComponent;
    }
    /**
     * Update deployedSoftwareComponent
     * @param userId user identity
     * @param deployedSoftwareComponent   deployedSoftwareComponent to update
     * @return DeployedSoftwareComponent the updated deployedSoftwareComponent entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public DeployedSoftwareComponent updateDeployedSoftwareComponent(String userId, DeployedSoftwareComponent deployedSoftwareComponent)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateDeployedSoftwareComponentById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = DeployedSoftwareComponentMapper.mapDeployedSoftwareComponentToOmrsEntityDetail(deployedSoftwareComponent);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            DeployedSoftwareComponent updatedDeployedSoftwareComponent =  DeployedSoftwareComponentMapper.mapOmrsEntityDetailToDeployedSoftwareComponent(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated DeployedSoftwareComponent="+ updatedDeployedSoftwareComponent );
            }
            return updatedDeployedSoftwareComponent;
        }

    /**
     * Delete an deployedSoftwareComponent identified by its GUID. Delete is a soft delete, this means that the deployedSoftwareComponent has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the deployedSoftwareComponent
     * @return DeployedSoftwareComponent the deleted DeployedSoftwareComponent entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteDeployedSoftwareComponentByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteDeployedSoftwareComponentByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the DeployedSoftwareComponent type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("DeployedSoftwareComponent");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"DeployedSoftwareComponent",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an deployedSoftwareComponent identified by its GUID. Delete is a hard delete, this means that the deployedSoftwareComponent is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the deployedSoftwareComponent
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeDeployedSoftwareComponentByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeDeployedSoftwareComponentByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the DeployedSoftwareComponent type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("DeployedSoftwareComponent");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"DeployedSoftwareComponent",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an DeployedSoftwareComponent identified by its GUID. Restore resurrects a soft deleted DeployedSoftwareComponent. When a DeployedSoftwareComponent was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the DeployedSoftwareComponent
     * @return  DeployedSoftwareComponent the restored DeployedSoftwareComponent
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the DeployedSoftwareComponent is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public DeployedSoftwareComponent restoreDeployedSoftwareComponent(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreDeployedSoftwareComponentByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        DeployedSoftwareComponent restoredDeployedSoftwareComponent =  DeployedSoftwareComponentMapper.mapOmrsEntityDetailToDeployedSoftwareComponent(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredDeployedSoftwareComponent;
    }    

    /**
     * Add classifications to the supplied deployedSoftwareComponent
     * @param userId user identity
     * @param entityGuid the GUID value for deployedSoftwareComponent
     * @param classifications the classifications to apply.
     * @return the deployedSoftwareComponent entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public DeployedSoftwareComponent addDeployedSoftwareComponentClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addDeployedSoftwareComponentClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         DeployedSoftwareComponent deployedSoftwareComponentClassifications = DeployedSoftwareComponentMapper.mapOmrsEntityDetailToDeployedSoftwareComponent(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified DeployedSoftwareComponent=" +  deployedSoftwareComponentClassifications);
         }
         return  deployedSoftwareComponentClassifications;
    }

    /**
     * Updates classifications to an existing deployedSoftwareComponent represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the deployedSoftwareComponent
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given deployedSoftwareComponent guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public DeployedSoftwareComponent updateDeployedSoftwareComponentClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateDeployedSoftwareComponentClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           DeployedSoftwareComponent  deployedSoftwareComponentClassifications = DeployedSoftwareComponentMapper.mapOmrsEntityDetailToDeployedSoftwareComponent(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  deployedSoftwareComponentClassifications;
    }

    /**
     * Deletes a given classification from an existing deployedSoftwareComponent represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the deployedSoftwareComponent
     * @param name name of the classification
     * @return deleted DeployedSoftwareComponent  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public DeployedSoftwareComponent deleteDeployedSoftwareComponentClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteDeployedSoftwareComponentClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       DeployedSoftwareComponent declassifiedDeployedSoftwareComponent =  DeployedSoftwareComponentMapper.mapOmrsEntityDetailToDeployedSoftwareComponent(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedDeployedSoftwareComponent;
    }

    /**
      * Get the relationships associated with entity deployedSoftwareComponent represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the deployedSoftwareComponent
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getDeployedSoftwareComponentRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getDeployedSoftwareComponentRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an schemaType given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the schemaTypes relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return SchemaType the SchemaType entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public SchemaType getSchemaTypeById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getSchemaTypeById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        SchemaType gotschemaType = SchemaTypeMapper.mapOmrsEntityDetailToSchemaType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotschemaType );
        }
        return gotschemaType;

    }
    /**
     * Create new schemaType.
     * @param userId user identity
     * @param schemaType the input entity with values.
     * @return SchemaType the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public SchemaType createSchemaType(String userId,SchemaType schemaType)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createSchemaTypeById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("SchemaType");
        if (constraint!=null) {
             constraint.preCreate(schemaType);
        }

        EntityDetail entityDetail = SchemaTypeMapper.mapSchemaTypeToOmrsEntityDetail(schemaType);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        SchemaType createdSchemaType =  SchemaTypeMapper.mapOmrsEntityDetailToSchemaType(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created SchemaType="+ createdSchemaType );
        }
        return createdSchemaType;
    }
    /**
     * Update schemaType
     * @param userId user identity
     * @param schemaType   schemaType to update
     * @return SchemaType the updated schemaType entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public SchemaType updateSchemaType(String userId, SchemaType schemaType)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateSchemaTypeById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = SchemaTypeMapper.mapSchemaTypeToOmrsEntityDetail(schemaType);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            SchemaType updatedSchemaType =  SchemaTypeMapper.mapOmrsEntityDetailToSchemaType(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated SchemaType="+ updatedSchemaType );
            }
            return updatedSchemaType;
        }

    /**
     * Delete an schemaType identified by its GUID. Delete is a soft delete, this means that the schemaType has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the schemaType
     * @return SchemaType the deleted SchemaType entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteSchemaTypeByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteSchemaTypeByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the SchemaType type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("SchemaType");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"SchemaType",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an schemaType identified by its GUID. Delete is a hard delete, this means that the schemaType is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the schemaType
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeSchemaTypeByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeSchemaTypeByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the SchemaType type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("SchemaType");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"SchemaType",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an SchemaType identified by its GUID. Restore resurrects a soft deleted SchemaType. When a SchemaType was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the SchemaType
     * @return  SchemaType the restored SchemaType
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the SchemaType is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public SchemaType restoreSchemaType(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreSchemaTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        SchemaType restoredSchemaType =  SchemaTypeMapper.mapOmrsEntityDetailToSchemaType(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredSchemaType;
    }    

    /**
     * Add classifications to the supplied schemaType
     * @param userId user identity
     * @param entityGuid the GUID value for schemaType
     * @param classifications the classifications to apply.
     * @return the schemaType entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public SchemaType addSchemaTypeClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addSchemaTypeClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         SchemaType schemaTypeClassifications = SchemaTypeMapper.mapOmrsEntityDetailToSchemaType(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified SchemaType=" +  schemaTypeClassifications);
         }
         return  schemaTypeClassifications;
    }

    /**
     * Updates classifications to an existing schemaType represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the schemaType
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given schemaType guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public SchemaType updateSchemaTypeClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateSchemaTypeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           SchemaType  schemaTypeClassifications = SchemaTypeMapper.mapOmrsEntityDetailToSchemaType(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  schemaTypeClassifications;
    }

    /**
     * Deletes a given classification from an existing schemaType represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the schemaType
     * @param name name of the classification
     * @return deleted SchemaType  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public SchemaType deleteSchemaTypeClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteSchemaTypeClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       SchemaType declassifiedSchemaType =  SchemaTypeMapper.mapOmrsEntityDetailToSchemaType(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedSchemaType;
    }

    /**
      * Get the relationships associated with entity schemaType represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the schemaType
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getSchemaTypeRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getSchemaTypeRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an dataFile given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the dataFiles relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return DataFile the DataFile entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public DataFile getDataFileById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getDataFileById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        DataFile gotdataFile = DataFileMapper.mapOmrsEntityDetailToDataFile(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotdataFile );
        }
        return gotdataFile;

    }
    /**
     * Create new dataFile.
     * @param userId user identity
     * @param dataFile the input entity with values.
     * @return DataFile the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public DataFile createDataFile(String userId,DataFile dataFile)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createDataFileById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("DataFile");
        if (constraint!=null) {
             constraint.preCreate(dataFile);
        }

        EntityDetail entityDetail = DataFileMapper.mapDataFileToOmrsEntityDetail(dataFile);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        DataFile createdDataFile =  DataFileMapper.mapOmrsEntityDetailToDataFile(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created DataFile="+ createdDataFile );
        }
        return createdDataFile;
    }
    /**
     * Update dataFile
     * @param userId user identity
     * @param dataFile   dataFile to update
     * @return DataFile the updated dataFile entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public DataFile updateDataFile(String userId, DataFile dataFile)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateDataFileById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = DataFileMapper.mapDataFileToOmrsEntityDetail(dataFile);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            DataFile updatedDataFile =  DataFileMapper.mapOmrsEntityDetailToDataFile(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated DataFile="+ updatedDataFile );
            }
            return updatedDataFile;
        }

    /**
     * Delete an dataFile identified by its GUID. Delete is a soft delete, this means that the dataFile has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the dataFile
     * @return DataFile the deleted DataFile entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteDataFileByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteDataFileByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the DataFile type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("DataFile");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"DataFile",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an dataFile identified by its GUID. Delete is a hard delete, this means that the dataFile is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the dataFile
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeDataFileByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeDataFileByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the DataFile type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("DataFile");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"DataFile",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an DataFile identified by its GUID. Restore resurrects a soft deleted DataFile. When a DataFile was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the DataFile
     * @return  DataFile the restored DataFile
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the DataFile is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public DataFile restoreDataFile(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreDataFileByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        DataFile restoredDataFile =  DataFileMapper.mapOmrsEntityDetailToDataFile(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredDataFile;
    }    

    /**
     * Add classifications to the supplied dataFile
     * @param userId user identity
     * @param entityGuid the GUID value for dataFile
     * @param classifications the classifications to apply.
     * @return the dataFile entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public DataFile addDataFileClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addDataFileClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         DataFile dataFileClassifications = DataFileMapper.mapOmrsEntityDetailToDataFile(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified DataFile=" +  dataFileClassifications);
         }
         return  dataFileClassifications;
    }

    /**
     * Updates classifications to an existing dataFile represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the dataFile
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given dataFile guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public DataFile updateDataFileClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateDataFileClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           DataFile  dataFileClassifications = DataFileMapper.mapOmrsEntityDetailToDataFile(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  dataFileClassifications;
    }

    /**
     * Deletes a given classification from an existing dataFile represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the dataFile
     * @param name name of the classification
     * @return deleted DataFile  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public DataFile deleteDataFileClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteDataFileClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       DataFile declassifiedDataFile =  DataFileMapper.mapOmrsEntityDetailToDataFile(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedDataFile;
    }

    /**
      * Get the relationships associated with entity dataFile represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the dataFile
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getDataFileRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getDataFileRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an like given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the likes relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return Like the Like entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Like getLikeById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getLikeById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        Like gotlike = LikeMapper.mapOmrsEntityDetailToLike(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotlike );
        }
        return gotlike;

    }
    /**
     * Create new like.
     * @param userId user identity
     * @param like the input entity with values.
     * @return Like the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public Like createLike(String userId,Like like)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createLikeById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Like");
        if (constraint!=null) {
             constraint.preCreate(like);
        }

        EntityDetail entityDetail = LikeMapper.mapLikeToOmrsEntityDetail(like);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        Like createdLike =  LikeMapper.mapOmrsEntityDetailToLike(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created Like="+ createdLike );
        }
        return createdLike;
    }
    /**
     * Update like
     * @param userId user identity
     * @param like   like to update
     * @return Like the updated like entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Like updateLike(String userId, Like like)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateLikeById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = LikeMapper.mapLikeToOmrsEntityDetail(like);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            Like updatedLike =  LikeMapper.mapOmrsEntityDetailToLike(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated Like="+ updatedLike );
            }
            return updatedLike;
        }

    /**
     * Delete an like identified by its GUID. Delete is a soft delete, this means that the like has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the like
     * @return Like the deleted Like entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteLikeByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteLikeByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Like type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Like");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"Like",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an like identified by its GUID. Delete is a hard delete, this means that the like is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the like
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeLikeByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeLikeByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Like type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Like");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"Like",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an Like identified by its GUID. Restore resurrects a soft deleted Like. When a Like was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the Like
     * @return  Like the restored Like
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the Like is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public Like restoreLike(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreLikeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        Like restoredLike =  LikeMapper.mapOmrsEntityDetailToLike(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredLike;
    }    

    /**
     * Add classifications to the supplied like
     * @param userId user identity
     * @param entityGuid the GUID value for like
     * @param classifications the classifications to apply.
     * @return the like entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public Like addLikeClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addLikeClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         Like likeClassifications = LikeMapper.mapOmrsEntityDetailToLike(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified Like=" +  likeClassifications);
         }
         return  likeClassifications;
    }

    /**
     * Updates classifications to an existing like represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the like
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given like guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Like updateLikeClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateLikeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           Like  likeClassifications = LikeMapper.mapOmrsEntityDetailToLike(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  likeClassifications;
    }

    /**
     * Deletes a given classification from an existing like represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the like
     * @param name name of the classification
     * @return deleted Like  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Like deleteLikeClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteLikeClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       Like declassifiedLike =  LikeMapper.mapOmrsEntityDetailToLike(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedLike;
    }

    /**
      * Get the relationships associated with entity like represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the like
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getLikeRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getLikeRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an referenceable given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the referenceables relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return Referenceable the Referenceable entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Referenceable getReferenceableById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getReferenceableById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        Referenceable gotreferenceable = ReferenceableMapper.mapOmrsEntityDetailToReferenceable(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotreferenceable );
        }
        return gotreferenceable;

    }
    /**
     * Create new referenceable.
     * @param userId user identity
     * @param referenceable the input entity with values.
     * @return Referenceable the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public Referenceable createReferenceable(String userId,Referenceable referenceable)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createReferenceableById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Referenceable");
        if (constraint!=null) {
             constraint.preCreate(referenceable);
        }

        EntityDetail entityDetail = ReferenceableMapper.mapReferenceableToOmrsEntityDetail(referenceable);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        Referenceable createdReferenceable =  ReferenceableMapper.mapOmrsEntityDetailToReferenceable(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created Referenceable="+ createdReferenceable );
        }
        return createdReferenceable;
    }
    /**
     * Update referenceable
     * @param userId user identity
     * @param referenceable   referenceable to update
     * @return Referenceable the updated referenceable entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Referenceable updateReferenceable(String userId, Referenceable referenceable)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateReferenceableById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = ReferenceableMapper.mapReferenceableToOmrsEntityDetail(referenceable);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            Referenceable updatedReferenceable =  ReferenceableMapper.mapOmrsEntityDetailToReferenceable(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated Referenceable="+ updatedReferenceable );
            }
            return updatedReferenceable;
        }

    /**
     * Delete an referenceable identified by its GUID. Delete is a soft delete, this means that the referenceable has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the referenceable
     * @return Referenceable the deleted Referenceable entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteReferenceableByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteReferenceableByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Referenceable type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Referenceable");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"Referenceable",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an referenceable identified by its GUID. Delete is a hard delete, this means that the referenceable is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the referenceable
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeReferenceableByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeReferenceableByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Referenceable type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Referenceable");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"Referenceable",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an Referenceable identified by its GUID. Restore resurrects a soft deleted Referenceable. When a Referenceable was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the Referenceable
     * @return  Referenceable the restored Referenceable
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the Referenceable is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public Referenceable restoreReferenceable(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreReferenceableByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        Referenceable restoredReferenceable =  ReferenceableMapper.mapOmrsEntityDetailToReferenceable(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredReferenceable;
    }    

    /**
     * Add classifications to the supplied referenceable
     * @param userId user identity
     * @param entityGuid the GUID value for referenceable
     * @param classifications the classifications to apply.
     * @return the referenceable entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public Referenceable addReferenceableClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addReferenceableClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         Referenceable referenceableClassifications = ReferenceableMapper.mapOmrsEntityDetailToReferenceable(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified Referenceable=" +  referenceableClassifications);
         }
         return  referenceableClassifications;
    }

    /**
     * Updates classifications to an existing referenceable represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the referenceable
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given referenceable guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Referenceable updateReferenceableClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateReferenceableClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           Referenceable  referenceableClassifications = ReferenceableMapper.mapOmrsEntityDetailToReferenceable(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  referenceableClassifications;
    }

    /**
     * Deletes a given classification from an existing referenceable represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the referenceable
     * @param name name of the classification
     * @return deleted Referenceable  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Referenceable deleteReferenceableClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteReferenceableClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       Referenceable declassifiedReferenceable =  ReferenceableMapper.mapOmrsEntityDetailToReferenceable(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedReferenceable;
    }

    /**
      * Get the relationships associated with entity referenceable represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the referenceable
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getReferenceableRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getReferenceableRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an externalReference given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the externalReferences relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return ExternalReference the ExternalReference entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public ExternalReference getExternalReferenceById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getExternalReferenceById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        ExternalReference gotexternalReference = ExternalReferenceMapper.mapOmrsEntityDetailToExternalReference(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotexternalReference );
        }
        return gotexternalReference;

    }
    /**
     * Create new externalReference.
     * @param userId user identity
     * @param externalReference the input entity with values.
     * @return ExternalReference the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public ExternalReference createExternalReference(String userId,ExternalReference externalReference)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createExternalReferenceById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("ExternalReference");
        if (constraint!=null) {
             constraint.preCreate(externalReference);
        }

        EntityDetail entityDetail = ExternalReferenceMapper.mapExternalReferenceToOmrsEntityDetail(externalReference);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        ExternalReference createdExternalReference =  ExternalReferenceMapper.mapOmrsEntityDetailToExternalReference(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created ExternalReference="+ createdExternalReference );
        }
        return createdExternalReference;
    }
    /**
     * Update externalReference
     * @param userId user identity
     * @param externalReference   externalReference to update
     * @return ExternalReference the updated externalReference entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public ExternalReference updateExternalReference(String userId, ExternalReference externalReference)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateExternalReferenceById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = ExternalReferenceMapper.mapExternalReferenceToOmrsEntityDetail(externalReference);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            ExternalReference updatedExternalReference =  ExternalReferenceMapper.mapOmrsEntityDetailToExternalReference(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated ExternalReference="+ updatedExternalReference );
            }
            return updatedExternalReference;
        }

    /**
     * Delete an externalReference identified by its GUID. Delete is a soft delete, this means that the externalReference has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the externalReference
     * @return ExternalReference the deleted ExternalReference entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteExternalReferenceByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteExternalReferenceByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the ExternalReference type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("ExternalReference");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"ExternalReference",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an externalReference identified by its GUID. Delete is a hard delete, this means that the externalReference is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the externalReference
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeExternalReferenceByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeExternalReferenceByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the ExternalReference type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("ExternalReference");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"ExternalReference",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an ExternalReference identified by its GUID. Restore resurrects a soft deleted ExternalReference. When a ExternalReference was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the ExternalReference
     * @return  ExternalReference the restored ExternalReference
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the ExternalReference is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public ExternalReference restoreExternalReference(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreExternalReferenceByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        ExternalReference restoredExternalReference =  ExternalReferenceMapper.mapOmrsEntityDetailToExternalReference(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredExternalReference;
    }    

    /**
     * Add classifications to the supplied externalReference
     * @param userId user identity
     * @param entityGuid the GUID value for externalReference
     * @param classifications the classifications to apply.
     * @return the externalReference entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public ExternalReference addExternalReferenceClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addExternalReferenceClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         ExternalReference externalReferenceClassifications = ExternalReferenceMapper.mapOmrsEntityDetailToExternalReference(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified ExternalReference=" +  externalReferenceClassifications);
         }
         return  externalReferenceClassifications;
    }

    /**
     * Updates classifications to an existing externalReference represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the externalReference
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given externalReference guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public ExternalReference updateExternalReferenceClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateExternalReferenceClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           ExternalReference  externalReferenceClassifications = ExternalReferenceMapper.mapOmrsEntityDetailToExternalReference(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  externalReferenceClassifications;
    }

    /**
     * Deletes a given classification from an existing externalReference represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the externalReference
     * @param name name of the classification
     * @return deleted ExternalReference  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public ExternalReference deleteExternalReferenceClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteExternalReferenceClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       ExternalReference declassifiedExternalReference =  ExternalReferenceMapper.mapOmrsEntityDetailToExternalReference(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedExternalReference;
    }

    /**
      * Get the relationships associated with entity externalReference represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the externalReference
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getExternalReferenceRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getExternalReferenceRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an endpoint given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the endpoints relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return Endpoint the Endpoint entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Endpoint getEndpointById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getEndpointById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        Endpoint gotendpoint = EndpointMapper.mapOmrsEntityDetailToEndpoint(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotendpoint );
        }
        return gotendpoint;

    }
    /**
     * Create new endpoint.
     * @param userId user identity
     * @param endpoint the input entity with values.
     * @return Endpoint the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public Endpoint createEndpoint(String userId,Endpoint endpoint)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createEndpointById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Endpoint");
        if (constraint!=null) {
             constraint.preCreate(endpoint);
        }

        EntityDetail entityDetail = EndpointMapper.mapEndpointToOmrsEntityDetail(endpoint);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        Endpoint createdEndpoint =  EndpointMapper.mapOmrsEntityDetailToEndpoint(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created Endpoint="+ createdEndpoint );
        }
        return createdEndpoint;
    }
    /**
     * Update endpoint
     * @param userId user identity
     * @param endpoint   endpoint to update
     * @return Endpoint the updated endpoint entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Endpoint updateEndpoint(String userId, Endpoint endpoint)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateEndpointById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = EndpointMapper.mapEndpointToOmrsEntityDetail(endpoint);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            Endpoint updatedEndpoint =  EndpointMapper.mapOmrsEntityDetailToEndpoint(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated Endpoint="+ updatedEndpoint );
            }
            return updatedEndpoint;
        }

    /**
     * Delete an endpoint identified by its GUID. Delete is a soft delete, this means that the endpoint has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the endpoint
     * @return Endpoint the deleted Endpoint entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteEndpointByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteEndpointByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Endpoint type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Endpoint");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"Endpoint",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an endpoint identified by its GUID. Delete is a hard delete, this means that the endpoint is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the endpoint
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeEndpointByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeEndpointByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Endpoint type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Endpoint");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"Endpoint",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an Endpoint identified by its GUID. Restore resurrects a soft deleted Endpoint. When a Endpoint was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the Endpoint
     * @return  Endpoint the restored Endpoint
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the Endpoint is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public Endpoint restoreEndpoint(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreEndpointByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        Endpoint restoredEndpoint =  EndpointMapper.mapOmrsEntityDetailToEndpoint(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredEndpoint;
    }    

    /**
     * Add classifications to the supplied endpoint
     * @param userId user identity
     * @param entityGuid the GUID value for endpoint
     * @param classifications the classifications to apply.
     * @return the endpoint entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public Endpoint addEndpointClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addEndpointClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         Endpoint endpointClassifications = EndpointMapper.mapOmrsEntityDetailToEndpoint(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified Endpoint=" +  endpointClassifications);
         }
         return  endpointClassifications;
    }

    /**
     * Updates classifications to an existing endpoint represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the endpoint
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given endpoint guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Endpoint updateEndpointClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateEndpointClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           Endpoint  endpointClassifications = EndpointMapper.mapOmrsEntityDetailToEndpoint(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  endpointClassifications;
    }

    /**
     * Deletes a given classification from an existing endpoint represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the endpoint
     * @param name name of the classification
     * @return deleted Endpoint  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Endpoint deleteEndpointClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteEndpointClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       Endpoint declassifiedEndpoint =  EndpointMapper.mapOmrsEntityDetailToEndpoint(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedEndpoint;
    }

    /**
      * Get the relationships associated with entity endpoint represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the endpoint
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getEndpointRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getEndpointRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an contactDetails given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the contactDetailses relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return ContactDetails the ContactDetails entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public ContactDetails getContactDetailsById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getContactDetailsById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        ContactDetails gotcontactDetails = ContactDetailsMapper.mapOmrsEntityDetailToContactDetails(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotcontactDetails );
        }
        return gotcontactDetails;

    }
    /**
     * Create new contactDetails.
     * @param userId user identity
     * @param contactDetails the input entity with values.
     * @return ContactDetails the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public ContactDetails createContactDetails(String userId,ContactDetails contactDetails)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createContactDetailsById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("ContactDetails");
        if (constraint!=null) {
             constraint.preCreate(contactDetails);
        }

        EntityDetail entityDetail = ContactDetailsMapper.mapContactDetailsToOmrsEntityDetail(contactDetails);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        ContactDetails createdContactDetails =  ContactDetailsMapper.mapOmrsEntityDetailToContactDetails(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created ContactDetails="+ createdContactDetails );
        }
        return createdContactDetails;
    }
    /**
     * Update contactDetails
     * @param userId user identity
     * @param contactDetails   contactDetails to update
     * @return ContactDetails the updated contactDetails entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public ContactDetails updateContactDetails(String userId, ContactDetails contactDetails)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateContactDetailsById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = ContactDetailsMapper.mapContactDetailsToOmrsEntityDetail(contactDetails);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            ContactDetails updatedContactDetails =  ContactDetailsMapper.mapOmrsEntityDetailToContactDetails(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated ContactDetails="+ updatedContactDetails );
            }
            return updatedContactDetails;
        }

    /**
     * Delete an contactDetails identified by its GUID. Delete is a soft delete, this means that the contactDetails has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the contactDetails
     * @return ContactDetails the deleted ContactDetails entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteContactDetailsByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteContactDetailsByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the ContactDetails type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("ContactDetails");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"ContactDetails",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an contactDetails identified by its GUID. Delete is a hard delete, this means that the contactDetails is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the contactDetails
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeContactDetailsByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeContactDetailsByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the ContactDetails type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("ContactDetails");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"ContactDetails",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an ContactDetails identified by its GUID. Restore resurrects a soft deleted ContactDetails. When a ContactDetails was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the ContactDetails
     * @return  ContactDetails the restored ContactDetails
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the ContactDetails is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public ContactDetails restoreContactDetails(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreContactDetailsByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        ContactDetails restoredContactDetails =  ContactDetailsMapper.mapOmrsEntityDetailToContactDetails(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredContactDetails;
    }    

    /**
     * Add classifications to the supplied contactDetails
     * @param userId user identity
     * @param entityGuid the GUID value for contactDetails
     * @param classifications the classifications to apply.
     * @return the contactDetails entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public ContactDetails addContactDetailsClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addContactDetailsClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         ContactDetails contactDetailsClassifications = ContactDetailsMapper.mapOmrsEntityDetailToContactDetails(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified ContactDetails=" +  contactDetailsClassifications);
         }
         return  contactDetailsClassifications;
    }

    /**
     * Updates classifications to an existing contactDetails represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the contactDetails
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given contactDetails guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public ContactDetails updateContactDetailsClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateContactDetailsClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           ContactDetails  contactDetailsClassifications = ContactDetailsMapper.mapOmrsEntityDetailToContactDetails(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  contactDetailsClassifications;
    }

    /**
     * Deletes a given classification from an existing contactDetails represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the contactDetails
     * @param name name of the classification
     * @return deleted ContactDetails  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public ContactDetails deleteContactDetailsClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteContactDetailsClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       ContactDetails declassifiedContactDetails =  ContactDetailsMapper.mapOmrsEntityDetailToContactDetails(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedContactDetails;
    }

    /**
      * Get the relationships associated with entity contactDetails represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the contactDetails
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getContactDetailsRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getContactDetailsRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an governanceDefinition given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the governanceDefinitions relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return GovernanceDefinition the GovernanceDefinition entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public GovernanceDefinition getGovernanceDefinitionById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getGovernanceDefinitionById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        GovernanceDefinition gotgovernanceDefinition = GovernanceDefinitionMapper.mapOmrsEntityDetailToGovernanceDefinition(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotgovernanceDefinition );
        }
        return gotgovernanceDefinition;

    }
    /**
     * Create new governanceDefinition.
     * @param userId user identity
     * @param governanceDefinition the input entity with values.
     * @return GovernanceDefinition the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public GovernanceDefinition createGovernanceDefinition(String userId,GovernanceDefinition governanceDefinition)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createGovernanceDefinitionById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("GovernanceDefinition");
        if (constraint!=null) {
             constraint.preCreate(governanceDefinition);
        }

        EntityDetail entityDetail = GovernanceDefinitionMapper.mapGovernanceDefinitionToOmrsEntityDetail(governanceDefinition);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        GovernanceDefinition createdGovernanceDefinition =  GovernanceDefinitionMapper.mapOmrsEntityDetailToGovernanceDefinition(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created GovernanceDefinition="+ createdGovernanceDefinition );
        }
        return createdGovernanceDefinition;
    }
    /**
     * Update governanceDefinition
     * @param userId user identity
     * @param governanceDefinition   governanceDefinition to update
     * @return GovernanceDefinition the updated governanceDefinition entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public GovernanceDefinition updateGovernanceDefinition(String userId, GovernanceDefinition governanceDefinition)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateGovernanceDefinitionById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = GovernanceDefinitionMapper.mapGovernanceDefinitionToOmrsEntityDetail(governanceDefinition);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            GovernanceDefinition updatedGovernanceDefinition =  GovernanceDefinitionMapper.mapOmrsEntityDetailToGovernanceDefinition(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated GovernanceDefinition="+ updatedGovernanceDefinition );
            }
            return updatedGovernanceDefinition;
        }

    /**
     * Delete an governanceDefinition identified by its GUID. Delete is a soft delete, this means that the governanceDefinition has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the governanceDefinition
     * @return GovernanceDefinition the deleted GovernanceDefinition entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteGovernanceDefinitionByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteGovernanceDefinitionByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the GovernanceDefinition type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernanceDefinition");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"GovernanceDefinition",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an governanceDefinition identified by its GUID. Delete is a hard delete, this means that the governanceDefinition is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the governanceDefinition
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeGovernanceDefinitionByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeGovernanceDefinitionByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the GovernanceDefinition type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernanceDefinition");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"GovernanceDefinition",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an GovernanceDefinition identified by its GUID. Restore resurrects a soft deleted GovernanceDefinition. When a GovernanceDefinition was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the GovernanceDefinition
     * @return  GovernanceDefinition the restored GovernanceDefinition
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the GovernanceDefinition is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public GovernanceDefinition restoreGovernanceDefinition(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreGovernanceDefinitionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        GovernanceDefinition restoredGovernanceDefinition =  GovernanceDefinitionMapper.mapOmrsEntityDetailToGovernanceDefinition(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredGovernanceDefinition;
    }    

    /**
     * Add classifications to the supplied governanceDefinition
     * @param userId user identity
     * @param entityGuid the GUID value for governanceDefinition
     * @param classifications the classifications to apply.
     * @return the governanceDefinition entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public GovernanceDefinition addGovernanceDefinitionClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addGovernanceDefinitionClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         GovernanceDefinition governanceDefinitionClassifications = GovernanceDefinitionMapper.mapOmrsEntityDetailToGovernanceDefinition(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified GovernanceDefinition=" +  governanceDefinitionClassifications);
         }
         return  governanceDefinitionClassifications;
    }

    /**
     * Updates classifications to an existing governanceDefinition represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the governanceDefinition
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given governanceDefinition guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public GovernanceDefinition updateGovernanceDefinitionClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateGovernanceDefinitionClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           GovernanceDefinition  governanceDefinitionClassifications = GovernanceDefinitionMapper.mapOmrsEntityDetailToGovernanceDefinition(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  governanceDefinitionClassifications;
    }

    /**
     * Deletes a given classification from an existing governanceDefinition represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the governanceDefinition
     * @param name name of the classification
     * @return deleted GovernanceDefinition  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public GovernanceDefinition deleteGovernanceDefinitionClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteGovernanceDefinitionClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       GovernanceDefinition declassifiedGovernanceDefinition =  GovernanceDefinitionMapper.mapOmrsEntityDetailToGovernanceDefinition(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedGovernanceDefinition;
    }

    /**
      * Get the relationships associated with entity governanceDefinition represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the governanceDefinition
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getGovernanceDefinitionRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getGovernanceDefinitionRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an fileFolder given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the fileFolders relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return FileFolder the FileFolder entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public FileFolder getFileFolderById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getFileFolderById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        FileFolder gotfileFolder = FileFolderMapper.mapOmrsEntityDetailToFileFolder(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotfileFolder );
        }
        return gotfileFolder;

    }
    /**
     * Create new fileFolder.
     * @param userId user identity
     * @param fileFolder the input entity with values.
     * @return FileFolder the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public FileFolder createFileFolder(String userId,FileFolder fileFolder)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createFileFolderById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("FileFolder");
        if (constraint!=null) {
             constraint.preCreate(fileFolder);
        }

        EntityDetail entityDetail = FileFolderMapper.mapFileFolderToOmrsEntityDetail(fileFolder);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        FileFolder createdFileFolder =  FileFolderMapper.mapOmrsEntityDetailToFileFolder(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created FileFolder="+ createdFileFolder );
        }
        return createdFileFolder;
    }
    /**
     * Update fileFolder
     * @param userId user identity
     * @param fileFolder   fileFolder to update
     * @return FileFolder the updated fileFolder entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public FileFolder updateFileFolder(String userId, FileFolder fileFolder)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateFileFolderById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = FileFolderMapper.mapFileFolderToOmrsEntityDetail(fileFolder);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            FileFolder updatedFileFolder =  FileFolderMapper.mapOmrsEntityDetailToFileFolder(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated FileFolder="+ updatedFileFolder );
            }
            return updatedFileFolder;
        }

    /**
     * Delete an fileFolder identified by its GUID. Delete is a soft delete, this means that the fileFolder has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the fileFolder
     * @return FileFolder the deleted FileFolder entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteFileFolderByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteFileFolderByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the FileFolder type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("FileFolder");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"FileFolder",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an fileFolder identified by its GUID. Delete is a hard delete, this means that the fileFolder is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the fileFolder
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeFileFolderByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeFileFolderByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the FileFolder type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("FileFolder");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"FileFolder",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an FileFolder identified by its GUID. Restore resurrects a soft deleted FileFolder. When a FileFolder was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the FileFolder
     * @return  FileFolder the restored FileFolder
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the FileFolder is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public FileFolder restoreFileFolder(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreFileFolderByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        FileFolder restoredFileFolder =  FileFolderMapper.mapOmrsEntityDetailToFileFolder(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredFileFolder;
    }    

    /**
     * Add classifications to the supplied fileFolder
     * @param userId user identity
     * @param entityGuid the GUID value for fileFolder
     * @param classifications the classifications to apply.
     * @return the fileFolder entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public FileFolder addFileFolderClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addFileFolderClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         FileFolder fileFolderClassifications = FileFolderMapper.mapOmrsEntityDetailToFileFolder(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified FileFolder=" +  fileFolderClassifications);
         }
         return  fileFolderClassifications;
    }

    /**
     * Updates classifications to an existing fileFolder represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the fileFolder
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given fileFolder guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public FileFolder updateFileFolderClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateFileFolderClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           FileFolder  fileFolderClassifications = FileFolderMapper.mapOmrsEntityDetailToFileFolder(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  fileFolderClassifications;
    }

    /**
     * Deletes a given classification from an existing fileFolder represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the fileFolder
     * @param name name of the classification
     * @return deleted FileFolder  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public FileFolder deleteFileFolderClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteFileFolderClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       FileFolder declassifiedFileFolder =  FileFolderMapper.mapOmrsEntityDetailToFileFolder(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedFileFolder;
    }

    /**
      * Get the relationships associated with entity fileFolder represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the fileFolder
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getFileFolderRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getFileFolderRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an network given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the networks relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return Network the Network entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Network getNetworkById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getNetworkById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        Network gotnetwork = NetworkMapper.mapOmrsEntityDetailToNetwork(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotnetwork );
        }
        return gotnetwork;

    }
    /**
     * Create new network.
     * @param userId user identity
     * @param network the input entity with values.
     * @return Network the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public Network createNetwork(String userId,Network network)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createNetworkById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Network");
        if (constraint!=null) {
             constraint.preCreate(network);
        }

        EntityDetail entityDetail = NetworkMapper.mapNetworkToOmrsEntityDetail(network);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        Network createdNetwork =  NetworkMapper.mapOmrsEntityDetailToNetwork(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created Network="+ createdNetwork );
        }
        return createdNetwork;
    }
    /**
     * Update network
     * @param userId user identity
     * @param network   network to update
     * @return Network the updated network entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Network updateNetwork(String userId, Network network)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateNetworkById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = NetworkMapper.mapNetworkToOmrsEntityDetail(network);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            Network updatedNetwork =  NetworkMapper.mapOmrsEntityDetailToNetwork(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated Network="+ updatedNetwork );
            }
            return updatedNetwork;
        }

    /**
     * Delete an network identified by its GUID. Delete is a soft delete, this means that the network has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the network
     * @return Network the deleted Network entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteNetworkByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteNetworkByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Network type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Network");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"Network",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an network identified by its GUID. Delete is a hard delete, this means that the network is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the network
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeNetworkByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeNetworkByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Network type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Network");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"Network",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an Network identified by its GUID. Restore resurrects a soft deleted Network. When a Network was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the Network
     * @return  Network the restored Network
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the Network is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public Network restoreNetwork(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreNetworkByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        Network restoredNetwork =  NetworkMapper.mapOmrsEntityDetailToNetwork(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredNetwork;
    }    

    /**
     * Add classifications to the supplied network
     * @param userId user identity
     * @param entityGuid the GUID value for network
     * @param classifications the classifications to apply.
     * @return the network entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public Network addNetworkClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addNetworkClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         Network networkClassifications = NetworkMapper.mapOmrsEntityDetailToNetwork(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified Network=" +  networkClassifications);
         }
         return  networkClassifications;
    }

    /**
     * Updates classifications to an existing network represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the network
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given network guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Network updateNetworkClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateNetworkClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           Network  networkClassifications = NetworkMapper.mapOmrsEntityDetailToNetwork(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  networkClassifications;
    }

    /**
     * Deletes a given classification from an existing network represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the network
     * @param name name of the classification
     * @return deleted Network  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Network deleteNetworkClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteNetworkClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       Network declassifiedNetwork =  NetworkMapper.mapOmrsEntityDetailToNetwork(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedNetwork;
    }

    /**
      * Get the relationships associated with entity network represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the network
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getNetworkRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getNetworkRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an actorProfile given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the actorProfiles relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return ActorProfile the ActorProfile entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public ActorProfile getActorProfileById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getActorProfileById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        ActorProfile gotactorProfile = ActorProfileMapper.mapOmrsEntityDetailToActorProfile(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotactorProfile );
        }
        return gotactorProfile;

    }
    /**
     * Create new actorProfile.
     * @param userId user identity
     * @param actorProfile the input entity with values.
     * @return ActorProfile the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public ActorProfile createActorProfile(String userId,ActorProfile actorProfile)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createActorProfileById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("ActorProfile");
        if (constraint!=null) {
             constraint.preCreate(actorProfile);
        }

        EntityDetail entityDetail = ActorProfileMapper.mapActorProfileToOmrsEntityDetail(actorProfile);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        ActorProfile createdActorProfile =  ActorProfileMapper.mapOmrsEntityDetailToActorProfile(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created ActorProfile="+ createdActorProfile );
        }
        return createdActorProfile;
    }
    /**
     * Update actorProfile
     * @param userId user identity
     * @param actorProfile   actorProfile to update
     * @return ActorProfile the updated actorProfile entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public ActorProfile updateActorProfile(String userId, ActorProfile actorProfile)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateActorProfileById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = ActorProfileMapper.mapActorProfileToOmrsEntityDetail(actorProfile);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            ActorProfile updatedActorProfile =  ActorProfileMapper.mapOmrsEntityDetailToActorProfile(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated ActorProfile="+ updatedActorProfile );
            }
            return updatedActorProfile;
        }

    /**
     * Delete an actorProfile identified by its GUID. Delete is a soft delete, this means that the actorProfile has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the actorProfile
     * @return ActorProfile the deleted ActorProfile entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteActorProfileByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteActorProfileByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the ActorProfile type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("ActorProfile");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"ActorProfile",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an actorProfile identified by its GUID. Delete is a hard delete, this means that the actorProfile is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the actorProfile
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeActorProfileByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeActorProfileByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the ActorProfile type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("ActorProfile");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"ActorProfile",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an ActorProfile identified by its GUID. Restore resurrects a soft deleted ActorProfile. When a ActorProfile was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the ActorProfile
     * @return  ActorProfile the restored ActorProfile
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the ActorProfile is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public ActorProfile restoreActorProfile(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreActorProfileByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        ActorProfile restoredActorProfile =  ActorProfileMapper.mapOmrsEntityDetailToActorProfile(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredActorProfile;
    }    

    /**
     * Add classifications to the supplied actorProfile
     * @param userId user identity
     * @param entityGuid the GUID value for actorProfile
     * @param classifications the classifications to apply.
     * @return the actorProfile entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public ActorProfile addActorProfileClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addActorProfileClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         ActorProfile actorProfileClassifications = ActorProfileMapper.mapOmrsEntityDetailToActorProfile(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified ActorProfile=" +  actorProfileClassifications);
         }
         return  actorProfileClassifications;
    }

    /**
     * Updates classifications to an existing actorProfile represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the actorProfile
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given actorProfile guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public ActorProfile updateActorProfileClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateActorProfileClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           ActorProfile  actorProfileClassifications = ActorProfileMapper.mapOmrsEntityDetailToActorProfile(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  actorProfileClassifications;
    }

    /**
     * Deletes a given classification from an existing actorProfile represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the actorProfile
     * @param name name of the classification
     * @return deleted ActorProfile  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public ActorProfile deleteActorProfileClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteActorProfileClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       ActorProfile declassifiedActorProfile =  ActorProfileMapper.mapOmrsEntityDetailToActorProfile(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedActorProfile;
    }

    /**
      * Get the relationships associated with entity actorProfile represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the actorProfile
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getActorProfileRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getActorProfileRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an asset given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the assets relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return Asset the Asset entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Asset getAssetById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getAssetById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        Asset gotasset = AssetMapper.mapOmrsEntityDetailToAsset(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotasset );
        }
        return gotasset;

    }
    /**
     * Create new asset.
     * @param userId user identity
     * @param asset the input entity with values.
     * @return Asset the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public Asset createAsset(String userId,Asset asset)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createAssetById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Asset");
        if (constraint!=null) {
             constraint.preCreate(asset);
        }

        EntityDetail entityDetail = AssetMapper.mapAssetToOmrsEntityDetail(asset);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        Asset createdAsset =  AssetMapper.mapOmrsEntityDetailToAsset(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created Asset="+ createdAsset );
        }
        return createdAsset;
    }
    /**
     * Update asset
     * @param userId user identity
     * @param asset   asset to update
     * @return Asset the updated asset entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Asset updateAsset(String userId, Asset asset)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateAssetById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = AssetMapper.mapAssetToOmrsEntityDetail(asset);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            Asset updatedAsset =  AssetMapper.mapOmrsEntityDetailToAsset(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated Asset="+ updatedAsset );
            }
            return updatedAsset;
        }

    /**
     * Delete an asset identified by its GUID. Delete is a soft delete, this means that the asset has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the asset
     * @return Asset the deleted Asset entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteAssetByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteAssetByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Asset type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Asset");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"Asset",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an asset identified by its GUID. Delete is a hard delete, this means that the asset is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the asset
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeAssetByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeAssetByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Asset type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Asset");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"Asset",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an Asset identified by its GUID. Restore resurrects a soft deleted Asset. When a Asset was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the Asset
     * @return  Asset the restored Asset
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the Asset is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public Asset restoreAsset(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreAssetByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        Asset restoredAsset =  AssetMapper.mapOmrsEntityDetailToAsset(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredAsset;
    }    

    /**
     * Add classifications to the supplied asset
     * @param userId user identity
     * @param entityGuid the GUID value for asset
     * @param classifications the classifications to apply.
     * @return the asset entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public Asset addAssetClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addAssetClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         Asset assetClassifications = AssetMapper.mapOmrsEntityDetailToAsset(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified Asset=" +  assetClassifications);
         }
         return  assetClassifications;
    }

    /**
     * Updates classifications to an existing asset represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the asset
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given asset guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Asset updateAssetClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateAssetClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           Asset  assetClassifications = AssetMapper.mapOmrsEntityDetailToAsset(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  assetClassifications;
    }

    /**
     * Deletes a given classification from an existing asset represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the asset
     * @param name name of the classification
     * @return deleted Asset  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Asset deleteAssetClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteAssetClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       Asset declassifiedAsset =  AssetMapper.mapOmrsEntityDetailToAsset(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedAsset;
    }

    /**
      * Get the relationships associated with entity asset represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the asset
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getAssetRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getAssetRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an aPIOperation given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the aPIOperations relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return APIOperation the APIOperation entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public APIOperation getAPIOperationById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getAPIOperationById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        APIOperation gotaPIOperation = APIOperationMapper.mapOmrsEntityDetailToAPIOperation(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotaPIOperation );
        }
        return gotaPIOperation;

    }
    /**
     * Create new aPIOperation.
     * @param userId user identity
     * @param aPIOperation the input entity with values.
     * @return APIOperation the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public APIOperation createAPIOperation(String userId,APIOperation aPIOperation)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createAPIOperationById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("APIOperation");
        if (constraint!=null) {
             constraint.preCreate(aPIOperation);
        }

        EntityDetail entityDetail = APIOperationMapper.mapAPIOperationToOmrsEntityDetail(aPIOperation);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        APIOperation createdAPIOperation =  APIOperationMapper.mapOmrsEntityDetailToAPIOperation(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created APIOperation="+ createdAPIOperation );
        }
        return createdAPIOperation;
    }
    /**
     * Update aPIOperation
     * @param userId user identity
     * @param aPIOperation   aPIOperation to update
     * @return APIOperation the updated aPIOperation entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public APIOperation updateAPIOperation(String userId, APIOperation aPIOperation)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateAPIOperationById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = APIOperationMapper.mapAPIOperationToOmrsEntityDetail(aPIOperation);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            APIOperation updatedAPIOperation =  APIOperationMapper.mapOmrsEntityDetailToAPIOperation(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated APIOperation="+ updatedAPIOperation );
            }
            return updatedAPIOperation;
        }

    /**
     * Delete an aPIOperation identified by its GUID. Delete is a soft delete, this means that the aPIOperation has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the aPIOperation
     * @return APIOperation the deleted APIOperation entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteAPIOperationByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteAPIOperationByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the APIOperation type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("APIOperation");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"APIOperation",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an aPIOperation identified by its GUID. Delete is a hard delete, this means that the aPIOperation is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the aPIOperation
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeAPIOperationByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeAPIOperationByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the APIOperation type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("APIOperation");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"APIOperation",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an APIOperation identified by its GUID. Restore resurrects a soft deleted APIOperation. When a APIOperation was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the APIOperation
     * @return  APIOperation the restored APIOperation
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the APIOperation is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public APIOperation restoreAPIOperation(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreAPIOperationByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        APIOperation restoredAPIOperation =  APIOperationMapper.mapOmrsEntityDetailToAPIOperation(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredAPIOperation;
    }    

    /**
     * Add classifications to the supplied aPIOperation
     * @param userId user identity
     * @param entityGuid the GUID value for aPIOperation
     * @param classifications the classifications to apply.
     * @return the aPIOperation entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public APIOperation addAPIOperationClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addAPIOperationClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         APIOperation aPIOperationClassifications = APIOperationMapper.mapOmrsEntityDetailToAPIOperation(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified APIOperation=" +  aPIOperationClassifications);
         }
         return  aPIOperationClassifications;
    }

    /**
     * Updates classifications to an existing aPIOperation represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the aPIOperation
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given aPIOperation guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public APIOperation updateAPIOperationClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateAPIOperationClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           APIOperation  aPIOperationClassifications = APIOperationMapper.mapOmrsEntityDetailToAPIOperation(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  aPIOperationClassifications;
    }

    /**
     * Deletes a given classification from an existing aPIOperation represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the aPIOperation
     * @param name name of the classification
     * @return deleted APIOperation  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public APIOperation deleteAPIOperationClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteAPIOperationClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       APIOperation declassifiedAPIOperation =  APIOperationMapper.mapOmrsEntityDetailToAPIOperation(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedAPIOperation;
    }

    /**
      * Get the relationships associated with entity aPIOperation represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the aPIOperation
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getAPIOperationRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getAPIOperationRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an toDo given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the toDos relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return ToDo the ToDo entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public ToDo getToDoById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getToDoById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        ToDo gottoDo = ToDoMapper.mapOmrsEntityDetailToToDo(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gottoDo );
        }
        return gottoDo;

    }
    /**
     * Create new toDo.
     * @param userId user identity
     * @param toDo the input entity with values.
     * @return ToDo the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public ToDo createToDo(String userId,ToDo toDo)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createToDoById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("ToDo");
        if (constraint!=null) {
             constraint.preCreate(toDo);
        }

        EntityDetail entityDetail = ToDoMapper.mapToDoToOmrsEntityDetail(toDo);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        ToDo createdToDo =  ToDoMapper.mapOmrsEntityDetailToToDo(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created ToDo="+ createdToDo );
        }
        return createdToDo;
    }
    /**
     * Update toDo
     * @param userId user identity
     * @param toDo   toDo to update
     * @return ToDo the updated toDo entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public ToDo updateToDo(String userId, ToDo toDo)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateToDoById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = ToDoMapper.mapToDoToOmrsEntityDetail(toDo);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            ToDo updatedToDo =  ToDoMapper.mapOmrsEntityDetailToToDo(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated ToDo="+ updatedToDo );
            }
            return updatedToDo;
        }

    /**
     * Delete an toDo identified by its GUID. Delete is a soft delete, this means that the toDo has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the toDo
     * @return ToDo the deleted ToDo entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteToDoByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteToDoByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the ToDo type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("ToDo");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"ToDo",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an toDo identified by its GUID. Delete is a hard delete, this means that the toDo is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the toDo
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeToDoByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeToDoByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the ToDo type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("ToDo");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"ToDo",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an ToDo identified by its GUID. Restore resurrects a soft deleted ToDo. When a ToDo was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the ToDo
     * @return  ToDo the restored ToDo
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the ToDo is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public ToDo restoreToDo(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreToDoByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        ToDo restoredToDo =  ToDoMapper.mapOmrsEntityDetailToToDo(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredToDo;
    }    

    /**
     * Add classifications to the supplied toDo
     * @param userId user identity
     * @param entityGuid the GUID value for toDo
     * @param classifications the classifications to apply.
     * @return the toDo entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public ToDo addToDoClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addToDoClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         ToDo toDoClassifications = ToDoMapper.mapOmrsEntityDetailToToDo(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified ToDo=" +  toDoClassifications);
         }
         return  toDoClassifications;
    }

    /**
     * Updates classifications to an existing toDo represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the toDo
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given toDo guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public ToDo updateToDoClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateToDoClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           ToDo  toDoClassifications = ToDoMapper.mapOmrsEntityDetailToToDo(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  toDoClassifications;
    }

    /**
     * Deletes a given classification from an existing toDo represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the toDo
     * @param name name of the classification
     * @return deleted ToDo  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public ToDo deleteToDoClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteToDoClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       ToDo declassifiedToDo =  ToDoMapper.mapOmrsEntityDetailToToDo(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedToDo;
    }

    /**
      * Get the relationships associated with entity toDo represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the toDo
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getToDoRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getToDoRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an networkGateway given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the networkGatewaies relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return NetworkGateway the NetworkGateway entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public NetworkGateway getNetworkGatewayById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getNetworkGatewayById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        NetworkGateway gotnetworkGateway = NetworkGatewayMapper.mapOmrsEntityDetailToNetworkGateway(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotnetworkGateway );
        }
        return gotnetworkGateway;

    }
    /**
     * Create new networkGateway.
     * @param userId user identity
     * @param networkGateway the input entity with values.
     * @return NetworkGateway the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public NetworkGateway createNetworkGateway(String userId,NetworkGateway networkGateway)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createNetworkGatewayById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("NetworkGateway");
        if (constraint!=null) {
             constraint.preCreate(networkGateway);
        }

        EntityDetail entityDetail = NetworkGatewayMapper.mapNetworkGatewayToOmrsEntityDetail(networkGateway);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        NetworkGateway createdNetworkGateway =  NetworkGatewayMapper.mapOmrsEntityDetailToNetworkGateway(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created NetworkGateway="+ createdNetworkGateway );
        }
        return createdNetworkGateway;
    }
    /**
     * Update networkGateway
     * @param userId user identity
     * @param networkGateway   networkGateway to update
     * @return NetworkGateway the updated networkGateway entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public NetworkGateway updateNetworkGateway(String userId, NetworkGateway networkGateway)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateNetworkGatewayById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = NetworkGatewayMapper.mapNetworkGatewayToOmrsEntityDetail(networkGateway);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            NetworkGateway updatedNetworkGateway =  NetworkGatewayMapper.mapOmrsEntityDetailToNetworkGateway(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated NetworkGateway="+ updatedNetworkGateway );
            }
            return updatedNetworkGateway;
        }

    /**
     * Delete an networkGateway identified by its GUID. Delete is a soft delete, this means that the networkGateway has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the networkGateway
     * @return NetworkGateway the deleted NetworkGateway entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteNetworkGatewayByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteNetworkGatewayByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the NetworkGateway type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("NetworkGateway");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"NetworkGateway",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an networkGateway identified by its GUID. Delete is a hard delete, this means that the networkGateway is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the networkGateway
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeNetworkGatewayByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeNetworkGatewayByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the NetworkGateway type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("NetworkGateway");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"NetworkGateway",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an NetworkGateway identified by its GUID. Restore resurrects a soft deleted NetworkGateway. When a NetworkGateway was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the NetworkGateway
     * @return  NetworkGateway the restored NetworkGateway
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the NetworkGateway is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public NetworkGateway restoreNetworkGateway(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreNetworkGatewayByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        NetworkGateway restoredNetworkGateway =  NetworkGatewayMapper.mapOmrsEntityDetailToNetworkGateway(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredNetworkGateway;
    }    

    /**
     * Add classifications to the supplied networkGateway
     * @param userId user identity
     * @param entityGuid the GUID value for networkGateway
     * @param classifications the classifications to apply.
     * @return the networkGateway entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public NetworkGateway addNetworkGatewayClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addNetworkGatewayClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         NetworkGateway networkGatewayClassifications = NetworkGatewayMapper.mapOmrsEntityDetailToNetworkGateway(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified NetworkGateway=" +  networkGatewayClassifications);
         }
         return  networkGatewayClassifications;
    }

    /**
     * Updates classifications to an existing networkGateway represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the networkGateway
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given networkGateway guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public NetworkGateway updateNetworkGatewayClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateNetworkGatewayClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           NetworkGateway  networkGatewayClassifications = NetworkGatewayMapper.mapOmrsEntityDetailToNetworkGateway(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  networkGatewayClassifications;
    }

    /**
     * Deletes a given classification from an existing networkGateway represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the networkGateway
     * @param name name of the classification
     * @return deleted NetworkGateway  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public NetworkGateway deleteNetworkGatewayClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteNetworkGatewayClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       NetworkGateway declassifiedNetworkGateway =  NetworkGatewayMapper.mapOmrsEntityDetailToNetworkGateway(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedNetworkGateway;
    }

    /**
      * Get the relationships associated with entity networkGateway represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the networkGateway
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getNetworkGatewayRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getNetworkGatewayRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an governanceResponsibility given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the governanceResponsibilities relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return GovernanceResponsibility the GovernanceResponsibility entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public GovernanceResponsibility getGovernanceResponsibilityById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getGovernanceResponsibilityById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        GovernanceResponsibility gotgovernanceResponsibility = GovernanceResponsibilityMapper.mapOmrsEntityDetailToGovernanceResponsibility(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotgovernanceResponsibility );
        }
        return gotgovernanceResponsibility;

    }
    /**
     * Create new governanceResponsibility.
     * @param userId user identity
     * @param governanceResponsibility the input entity with values.
     * @return GovernanceResponsibility the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public GovernanceResponsibility createGovernanceResponsibility(String userId,GovernanceResponsibility governanceResponsibility)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createGovernanceResponsibilityById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("GovernanceResponsibility");
        if (constraint!=null) {
             constraint.preCreate(governanceResponsibility);
        }

        EntityDetail entityDetail = GovernanceResponsibilityMapper.mapGovernanceResponsibilityToOmrsEntityDetail(governanceResponsibility);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        GovernanceResponsibility createdGovernanceResponsibility =  GovernanceResponsibilityMapper.mapOmrsEntityDetailToGovernanceResponsibility(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created GovernanceResponsibility="+ createdGovernanceResponsibility );
        }
        return createdGovernanceResponsibility;
    }
    /**
     * Update governanceResponsibility
     * @param userId user identity
     * @param governanceResponsibility   governanceResponsibility to update
     * @return GovernanceResponsibility the updated governanceResponsibility entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public GovernanceResponsibility updateGovernanceResponsibility(String userId, GovernanceResponsibility governanceResponsibility)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateGovernanceResponsibilityById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = GovernanceResponsibilityMapper.mapGovernanceResponsibilityToOmrsEntityDetail(governanceResponsibility);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            GovernanceResponsibility updatedGovernanceResponsibility =  GovernanceResponsibilityMapper.mapOmrsEntityDetailToGovernanceResponsibility(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated GovernanceResponsibility="+ updatedGovernanceResponsibility );
            }
            return updatedGovernanceResponsibility;
        }

    /**
     * Delete an governanceResponsibility identified by its GUID. Delete is a soft delete, this means that the governanceResponsibility has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the governanceResponsibility
     * @return GovernanceResponsibility the deleted GovernanceResponsibility entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteGovernanceResponsibilityByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteGovernanceResponsibilityByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the GovernanceResponsibility type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernanceResponsibility");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"GovernanceResponsibility",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an governanceResponsibility identified by its GUID. Delete is a hard delete, this means that the governanceResponsibility is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the governanceResponsibility
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeGovernanceResponsibilityByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeGovernanceResponsibilityByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the GovernanceResponsibility type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernanceResponsibility");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"GovernanceResponsibility",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an GovernanceResponsibility identified by its GUID. Restore resurrects a soft deleted GovernanceResponsibility. When a GovernanceResponsibility was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the GovernanceResponsibility
     * @return  GovernanceResponsibility the restored GovernanceResponsibility
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the GovernanceResponsibility is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public GovernanceResponsibility restoreGovernanceResponsibility(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreGovernanceResponsibilityByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        GovernanceResponsibility restoredGovernanceResponsibility =  GovernanceResponsibilityMapper.mapOmrsEntityDetailToGovernanceResponsibility(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredGovernanceResponsibility;
    }    

    /**
     * Add classifications to the supplied governanceResponsibility
     * @param userId user identity
     * @param entityGuid the GUID value for governanceResponsibility
     * @param classifications the classifications to apply.
     * @return the governanceResponsibility entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public GovernanceResponsibility addGovernanceResponsibilityClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addGovernanceResponsibilityClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         GovernanceResponsibility governanceResponsibilityClassifications = GovernanceResponsibilityMapper.mapOmrsEntityDetailToGovernanceResponsibility(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified GovernanceResponsibility=" +  governanceResponsibilityClassifications);
         }
         return  governanceResponsibilityClassifications;
    }

    /**
     * Updates classifications to an existing governanceResponsibility represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the governanceResponsibility
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given governanceResponsibility guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public GovernanceResponsibility updateGovernanceResponsibilityClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateGovernanceResponsibilityClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           GovernanceResponsibility  governanceResponsibilityClassifications = GovernanceResponsibilityMapper.mapOmrsEntityDetailToGovernanceResponsibility(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  governanceResponsibilityClassifications;
    }

    /**
     * Deletes a given classification from an existing governanceResponsibility represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the governanceResponsibility
     * @param name name of the classification
     * @return deleted GovernanceResponsibility  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public GovernanceResponsibility deleteGovernanceResponsibilityClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteGovernanceResponsibilityClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       GovernanceResponsibility declassifiedGovernanceResponsibility =  GovernanceResponsibilityMapper.mapOmrsEntityDetailToGovernanceResponsibility(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedGovernanceResponsibility;
    }

    /**
      * Get the relationships associated with entity governanceResponsibility represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the governanceResponsibility
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getGovernanceResponsibilityRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getGovernanceResponsibilityRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an implementationSnippet given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the implementationSnippets relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return ImplementationSnippet the ImplementationSnippet entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public ImplementationSnippet getImplementationSnippetById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getImplementationSnippetById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        ImplementationSnippet gotimplementationSnippet = ImplementationSnippetMapper.mapOmrsEntityDetailToImplementationSnippet(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotimplementationSnippet );
        }
        return gotimplementationSnippet;

    }
    /**
     * Create new implementationSnippet.
     * @param userId user identity
     * @param implementationSnippet the input entity with values.
     * @return ImplementationSnippet the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public ImplementationSnippet createImplementationSnippet(String userId,ImplementationSnippet implementationSnippet)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createImplementationSnippetById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("ImplementationSnippet");
        if (constraint!=null) {
             constraint.preCreate(implementationSnippet);
        }

        EntityDetail entityDetail = ImplementationSnippetMapper.mapImplementationSnippetToOmrsEntityDetail(implementationSnippet);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        ImplementationSnippet createdImplementationSnippet =  ImplementationSnippetMapper.mapOmrsEntityDetailToImplementationSnippet(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created ImplementationSnippet="+ createdImplementationSnippet );
        }
        return createdImplementationSnippet;
    }
    /**
     * Update implementationSnippet
     * @param userId user identity
     * @param implementationSnippet   implementationSnippet to update
     * @return ImplementationSnippet the updated implementationSnippet entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public ImplementationSnippet updateImplementationSnippet(String userId, ImplementationSnippet implementationSnippet)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateImplementationSnippetById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = ImplementationSnippetMapper.mapImplementationSnippetToOmrsEntityDetail(implementationSnippet);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            ImplementationSnippet updatedImplementationSnippet =  ImplementationSnippetMapper.mapOmrsEntityDetailToImplementationSnippet(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated ImplementationSnippet="+ updatedImplementationSnippet );
            }
            return updatedImplementationSnippet;
        }

    /**
     * Delete an implementationSnippet identified by its GUID. Delete is a soft delete, this means that the implementationSnippet has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the implementationSnippet
     * @return ImplementationSnippet the deleted ImplementationSnippet entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteImplementationSnippetByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteImplementationSnippetByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the ImplementationSnippet type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("ImplementationSnippet");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"ImplementationSnippet",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an implementationSnippet identified by its GUID. Delete is a hard delete, this means that the implementationSnippet is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the implementationSnippet
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeImplementationSnippetByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeImplementationSnippetByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the ImplementationSnippet type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("ImplementationSnippet");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"ImplementationSnippet",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an ImplementationSnippet identified by its GUID. Restore resurrects a soft deleted ImplementationSnippet. When a ImplementationSnippet was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the ImplementationSnippet
     * @return  ImplementationSnippet the restored ImplementationSnippet
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the ImplementationSnippet is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public ImplementationSnippet restoreImplementationSnippet(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreImplementationSnippetByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        ImplementationSnippet restoredImplementationSnippet =  ImplementationSnippetMapper.mapOmrsEntityDetailToImplementationSnippet(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredImplementationSnippet;
    }    

    /**
     * Add classifications to the supplied implementationSnippet
     * @param userId user identity
     * @param entityGuid the GUID value for implementationSnippet
     * @param classifications the classifications to apply.
     * @return the implementationSnippet entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public ImplementationSnippet addImplementationSnippetClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addImplementationSnippetClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         ImplementationSnippet implementationSnippetClassifications = ImplementationSnippetMapper.mapOmrsEntityDetailToImplementationSnippet(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified ImplementationSnippet=" +  implementationSnippetClassifications);
         }
         return  implementationSnippetClassifications;
    }

    /**
     * Updates classifications to an existing implementationSnippet represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the implementationSnippet
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given implementationSnippet guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public ImplementationSnippet updateImplementationSnippetClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateImplementationSnippetClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           ImplementationSnippet  implementationSnippetClassifications = ImplementationSnippetMapper.mapOmrsEntityDetailToImplementationSnippet(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  implementationSnippetClassifications;
    }

    /**
     * Deletes a given classification from an existing implementationSnippet represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the implementationSnippet
     * @param name name of the classification
     * @return deleted ImplementationSnippet  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public ImplementationSnippet deleteImplementationSnippetClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteImplementationSnippetClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       ImplementationSnippet declassifiedImplementationSnippet =  ImplementationSnippetMapper.mapOmrsEntityDetailToImplementationSnippet(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedImplementationSnippet;
    }

    /**
      * Get the relationships associated with entity implementationSnippet represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the implementationSnippet
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getImplementationSnippetRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getImplementationSnippetRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an userIdentity given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the userIdentities relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return UserIdentity the UserIdentity entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public UserIdentity getUserIdentityById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getUserIdentityById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        UserIdentity gotuserIdentity = UserIdentityMapper.mapOmrsEntityDetailToUserIdentity(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotuserIdentity );
        }
        return gotuserIdentity;

    }
    /**
     * Create new userIdentity.
     * @param userId user identity
     * @param userIdentity the input entity with values.
     * @return UserIdentity the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public UserIdentity createUserIdentity(String userId,UserIdentity userIdentity)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createUserIdentityById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("UserIdentity");
        if (constraint!=null) {
             constraint.preCreate(userIdentity);
        }

        EntityDetail entityDetail = UserIdentityMapper.mapUserIdentityToOmrsEntityDetail(userIdentity);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        UserIdentity createdUserIdentity =  UserIdentityMapper.mapOmrsEntityDetailToUserIdentity(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created UserIdentity="+ createdUserIdentity );
        }
        return createdUserIdentity;
    }
    /**
     * Update userIdentity
     * @param userId user identity
     * @param userIdentity   userIdentity to update
     * @return UserIdentity the updated userIdentity entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public UserIdentity updateUserIdentity(String userId, UserIdentity userIdentity)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateUserIdentityById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = UserIdentityMapper.mapUserIdentityToOmrsEntityDetail(userIdentity);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            UserIdentity updatedUserIdentity =  UserIdentityMapper.mapOmrsEntityDetailToUserIdentity(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated UserIdentity="+ updatedUserIdentity );
            }
            return updatedUserIdentity;
        }

    /**
     * Delete an userIdentity identified by its GUID. Delete is a soft delete, this means that the userIdentity has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the userIdentity
     * @return UserIdentity the deleted UserIdentity entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteUserIdentityByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteUserIdentityByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the UserIdentity type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("UserIdentity");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"UserIdentity",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an userIdentity identified by its GUID. Delete is a hard delete, this means that the userIdentity is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the userIdentity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeUserIdentityByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeUserIdentityByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the UserIdentity type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("UserIdentity");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"UserIdentity",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an UserIdentity identified by its GUID. Restore resurrects a soft deleted UserIdentity. When a UserIdentity was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the UserIdentity
     * @return  UserIdentity the restored UserIdentity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the UserIdentity is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public UserIdentity restoreUserIdentity(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreUserIdentityByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        UserIdentity restoredUserIdentity =  UserIdentityMapper.mapOmrsEntityDetailToUserIdentity(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredUserIdentity;
    }    

    /**
     * Add classifications to the supplied userIdentity
     * @param userId user identity
     * @param entityGuid the GUID value for userIdentity
     * @param classifications the classifications to apply.
     * @return the userIdentity entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public UserIdentity addUserIdentityClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addUserIdentityClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         UserIdentity userIdentityClassifications = UserIdentityMapper.mapOmrsEntityDetailToUserIdentity(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified UserIdentity=" +  userIdentityClassifications);
         }
         return  userIdentityClassifications;
    }

    /**
     * Updates classifications to an existing userIdentity represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the userIdentity
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given userIdentity guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public UserIdentity updateUserIdentityClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateUserIdentityClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           UserIdentity  userIdentityClassifications = UserIdentityMapper.mapOmrsEntityDetailToUserIdentity(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  userIdentityClassifications;
    }

    /**
     * Deletes a given classification from an existing userIdentity represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the userIdentity
     * @param name name of the classification
     * @return deleted UserIdentity  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public UserIdentity deleteUserIdentityClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteUserIdentityClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       UserIdentity declassifiedUserIdentity =  UserIdentityMapper.mapOmrsEntityDetailToUserIdentity(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedUserIdentity;
    }

    /**
      * Get the relationships associated with entity userIdentity represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the userIdentity
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getUserIdentityRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getUserIdentityRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an noteEntry given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the noteEntries relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return NoteEntry the NoteEntry entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public NoteEntry getNoteEntryById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getNoteEntryById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        NoteEntry gotnoteEntry = NoteEntryMapper.mapOmrsEntityDetailToNoteEntry(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotnoteEntry );
        }
        return gotnoteEntry;

    }
    /**
     * Create new noteEntry.
     * @param userId user identity
     * @param noteEntry the input entity with values.
     * @return NoteEntry the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public NoteEntry createNoteEntry(String userId,NoteEntry noteEntry)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createNoteEntryById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("NoteEntry");
        if (constraint!=null) {
             constraint.preCreate(noteEntry);
        }

        EntityDetail entityDetail = NoteEntryMapper.mapNoteEntryToOmrsEntityDetail(noteEntry);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        NoteEntry createdNoteEntry =  NoteEntryMapper.mapOmrsEntityDetailToNoteEntry(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created NoteEntry="+ createdNoteEntry );
        }
        return createdNoteEntry;
    }
    /**
     * Update noteEntry
     * @param userId user identity
     * @param noteEntry   noteEntry to update
     * @return NoteEntry the updated noteEntry entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public NoteEntry updateNoteEntry(String userId, NoteEntry noteEntry)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateNoteEntryById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = NoteEntryMapper.mapNoteEntryToOmrsEntityDetail(noteEntry);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            NoteEntry updatedNoteEntry =  NoteEntryMapper.mapOmrsEntityDetailToNoteEntry(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated NoteEntry="+ updatedNoteEntry );
            }
            return updatedNoteEntry;
        }

    /**
     * Delete an noteEntry identified by its GUID. Delete is a soft delete, this means that the noteEntry has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the noteEntry
     * @return NoteEntry the deleted NoteEntry entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteNoteEntryByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteNoteEntryByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the NoteEntry type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("NoteEntry");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"NoteEntry",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an noteEntry identified by its GUID. Delete is a hard delete, this means that the noteEntry is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the noteEntry
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeNoteEntryByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeNoteEntryByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the NoteEntry type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("NoteEntry");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"NoteEntry",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an NoteEntry identified by its GUID. Restore resurrects a soft deleted NoteEntry. When a NoteEntry was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the NoteEntry
     * @return  NoteEntry the restored NoteEntry
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the NoteEntry is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public NoteEntry restoreNoteEntry(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreNoteEntryByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        NoteEntry restoredNoteEntry =  NoteEntryMapper.mapOmrsEntityDetailToNoteEntry(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredNoteEntry;
    }    

    /**
     * Add classifications to the supplied noteEntry
     * @param userId user identity
     * @param entityGuid the GUID value for noteEntry
     * @param classifications the classifications to apply.
     * @return the noteEntry entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public NoteEntry addNoteEntryClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addNoteEntryClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         NoteEntry noteEntryClassifications = NoteEntryMapper.mapOmrsEntityDetailToNoteEntry(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified NoteEntry=" +  noteEntryClassifications);
         }
         return  noteEntryClassifications;
    }

    /**
     * Updates classifications to an existing noteEntry represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the noteEntry
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given noteEntry guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public NoteEntry updateNoteEntryClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateNoteEntryClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           NoteEntry  noteEntryClassifications = NoteEntryMapper.mapOmrsEntityDetailToNoteEntry(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  noteEntryClassifications;
    }

    /**
     * Deletes a given classification from an existing noteEntry represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the noteEntry
     * @param name name of the classification
     * @return deleted NoteEntry  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public NoteEntry deleteNoteEntryClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteNoteEntryClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       NoteEntry declassifiedNoteEntry =  NoteEntryMapper.mapOmrsEntityDetailToNoteEntry(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedNoteEntry;
    }

    /**
      * Get the relationships associated with entity noteEntry represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the noteEntry
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getNoteEntryRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getNoteEntryRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an propertyFacet given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the propertyFacets relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return PropertyFacet the PropertyFacet entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public PropertyFacet getPropertyFacetById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getPropertyFacetById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        PropertyFacet gotpropertyFacet = PropertyFacetMapper.mapOmrsEntityDetailToPropertyFacet(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotpropertyFacet );
        }
        return gotpropertyFacet;

    }
    /**
     * Create new propertyFacet.
     * @param userId user identity
     * @param propertyFacet the input entity with values.
     * @return PropertyFacet the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public PropertyFacet createPropertyFacet(String userId,PropertyFacet propertyFacet)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createPropertyFacetById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("PropertyFacet");
        if (constraint!=null) {
             constraint.preCreate(propertyFacet);
        }

        EntityDetail entityDetail = PropertyFacetMapper.mapPropertyFacetToOmrsEntityDetail(propertyFacet);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        PropertyFacet createdPropertyFacet =  PropertyFacetMapper.mapOmrsEntityDetailToPropertyFacet(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created PropertyFacet="+ createdPropertyFacet );
        }
        return createdPropertyFacet;
    }
    /**
     * Update propertyFacet
     * @param userId user identity
     * @param propertyFacet   propertyFacet to update
     * @return PropertyFacet the updated propertyFacet entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public PropertyFacet updatePropertyFacet(String userId, PropertyFacet propertyFacet)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updatePropertyFacetById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = PropertyFacetMapper.mapPropertyFacetToOmrsEntityDetail(propertyFacet);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            PropertyFacet updatedPropertyFacet =  PropertyFacetMapper.mapOmrsEntityDetailToPropertyFacet(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated PropertyFacet="+ updatedPropertyFacet );
            }
            return updatedPropertyFacet;
        }

    /**
     * Delete an propertyFacet identified by its GUID. Delete is a soft delete, this means that the propertyFacet has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the propertyFacet
     * @return PropertyFacet the deleted PropertyFacet entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deletePropertyFacetByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deletePropertyFacetByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the PropertyFacet type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("PropertyFacet");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"PropertyFacet",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an propertyFacet identified by its GUID. Delete is a hard delete, this means that the propertyFacet is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the propertyFacet
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgePropertyFacetByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgePropertyFacetByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the PropertyFacet type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("PropertyFacet");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"PropertyFacet",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an PropertyFacet identified by its GUID. Restore resurrects a soft deleted PropertyFacet. When a PropertyFacet was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the PropertyFacet
     * @return  PropertyFacet the restored PropertyFacet
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the PropertyFacet is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public PropertyFacet restorePropertyFacet(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restorePropertyFacetByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        PropertyFacet restoredPropertyFacet =  PropertyFacetMapper.mapOmrsEntityDetailToPropertyFacet(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredPropertyFacet;
    }    

    /**
     * Add classifications to the supplied propertyFacet
     * @param userId user identity
     * @param entityGuid the GUID value for propertyFacet
     * @param classifications the classifications to apply.
     * @return the propertyFacet entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public PropertyFacet addPropertyFacetClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addPropertyFacetClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         PropertyFacet propertyFacetClassifications = PropertyFacetMapper.mapOmrsEntityDetailToPropertyFacet(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified PropertyFacet=" +  propertyFacetClassifications);
         }
         return  propertyFacetClassifications;
    }

    /**
     * Updates classifications to an existing propertyFacet represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the propertyFacet
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given propertyFacet guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public PropertyFacet updatePropertyFacetClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updatePropertyFacetClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           PropertyFacet  propertyFacetClassifications = PropertyFacetMapper.mapOmrsEntityDetailToPropertyFacet(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  propertyFacetClassifications;
    }

    /**
     * Deletes a given classification from an existing propertyFacet represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the propertyFacet
     * @param name name of the classification
     * @return deleted PropertyFacet  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public PropertyFacet deletePropertyFacetClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deletePropertyFacetClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       PropertyFacet declassifiedPropertyFacet =  PropertyFacetMapper.mapOmrsEntityDetailToPropertyFacet(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedPropertyFacet;
    }

    /**
      * Get the relationships associated with entity propertyFacet represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the propertyFacet
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getPropertyFacetRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getPropertyFacetRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an project given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the projects relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return Project the Project entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Project getProjectById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getProjectById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        Project gotproject = ProjectMapper.mapOmrsEntityDetailToProject(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotproject );
        }
        return gotproject;

    }
    /**
     * Create new project.
     * @param userId user identity
     * @param project the input entity with values.
     * @return Project the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public Project createProject(String userId,Project project)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createProjectById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Project");
        if (constraint!=null) {
             constraint.preCreate(project);
        }

        EntityDetail entityDetail = ProjectMapper.mapProjectToOmrsEntityDetail(project);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        Project createdProject =  ProjectMapper.mapOmrsEntityDetailToProject(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created Project="+ createdProject );
        }
        return createdProject;
    }
    /**
     * Update project
     * @param userId user identity
     * @param project   project to update
     * @return Project the updated project entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Project updateProject(String userId, Project project)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateProjectById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = ProjectMapper.mapProjectToOmrsEntityDetail(project);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            Project updatedProject =  ProjectMapper.mapOmrsEntityDetailToProject(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated Project="+ updatedProject );
            }
            return updatedProject;
        }

    /**
     * Delete an project identified by its GUID. Delete is a soft delete, this means that the project has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the project
     * @return Project the deleted Project entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteProjectByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteProjectByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Project type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Project");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"Project",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an project identified by its GUID. Delete is a hard delete, this means that the project is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the project
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeProjectByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeProjectByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Project type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Project");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"Project",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an Project identified by its GUID. Restore resurrects a soft deleted Project. When a Project was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the Project
     * @return  Project the restored Project
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the Project is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public Project restoreProject(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreProjectByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        Project restoredProject =  ProjectMapper.mapOmrsEntityDetailToProject(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredProject;
    }    

    /**
     * Add classifications to the supplied project
     * @param userId user identity
     * @param entityGuid the GUID value for project
     * @param classifications the classifications to apply.
     * @return the project entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public Project addProjectClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addProjectClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         Project projectClassifications = ProjectMapper.mapOmrsEntityDetailToProject(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified Project=" +  projectClassifications);
         }
         return  projectClassifications;
    }

    /**
     * Updates classifications to an existing project represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the project
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given project guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Project updateProjectClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateProjectClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           Project  projectClassifications = ProjectMapper.mapOmrsEntityDetailToProject(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  projectClassifications;
    }

    /**
     * Deletes a given classification from an existing project represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the project
     * @param name name of the classification
     * @return deleted Project  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Project deleteProjectClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteProjectClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       Project declassifiedProject =  ProjectMapper.mapOmrsEntityDetailToProject(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedProject;
    }

    /**
      * Get the relationships associated with entity project represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the project
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getProjectRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getProjectRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an hostCluster given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the hostClusters relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return HostCluster the HostCluster entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public HostCluster getHostClusterById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getHostClusterById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        HostCluster gothostCluster = HostClusterMapper.mapOmrsEntityDetailToHostCluster(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gothostCluster );
        }
        return gothostCluster;

    }
    /**
     * Create new hostCluster.
     * @param userId user identity
     * @param hostCluster the input entity with values.
     * @return HostCluster the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public HostCluster createHostCluster(String userId,HostCluster hostCluster)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createHostClusterById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("HostCluster");
        if (constraint!=null) {
             constraint.preCreate(hostCluster);
        }

        EntityDetail entityDetail = HostClusterMapper.mapHostClusterToOmrsEntityDetail(hostCluster);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        HostCluster createdHostCluster =  HostClusterMapper.mapOmrsEntityDetailToHostCluster(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created HostCluster="+ createdHostCluster );
        }
        return createdHostCluster;
    }
    /**
     * Update hostCluster
     * @param userId user identity
     * @param hostCluster   hostCluster to update
     * @return HostCluster the updated hostCluster entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public HostCluster updateHostCluster(String userId, HostCluster hostCluster)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateHostClusterById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = HostClusterMapper.mapHostClusterToOmrsEntityDetail(hostCluster);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            HostCluster updatedHostCluster =  HostClusterMapper.mapOmrsEntityDetailToHostCluster(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated HostCluster="+ updatedHostCluster );
            }
            return updatedHostCluster;
        }

    /**
     * Delete an hostCluster identified by its GUID. Delete is a soft delete, this means that the hostCluster has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the hostCluster
     * @return HostCluster the deleted HostCluster entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteHostClusterByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteHostClusterByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the HostCluster type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("HostCluster");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"HostCluster",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an hostCluster identified by its GUID. Delete is a hard delete, this means that the hostCluster is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the hostCluster
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeHostClusterByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeHostClusterByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the HostCluster type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("HostCluster");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"HostCluster",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an HostCluster identified by its GUID. Restore resurrects a soft deleted HostCluster. When a HostCluster was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the HostCluster
     * @return  HostCluster the restored HostCluster
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the HostCluster is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public HostCluster restoreHostCluster(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreHostClusterByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        HostCluster restoredHostCluster =  HostClusterMapper.mapOmrsEntityDetailToHostCluster(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredHostCluster;
    }    

    /**
     * Add classifications to the supplied hostCluster
     * @param userId user identity
     * @param entityGuid the GUID value for hostCluster
     * @param classifications the classifications to apply.
     * @return the hostCluster entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public HostCluster addHostClusterClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addHostClusterClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         HostCluster hostClusterClassifications = HostClusterMapper.mapOmrsEntityDetailToHostCluster(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified HostCluster=" +  hostClusterClassifications);
         }
         return  hostClusterClassifications;
    }

    /**
     * Updates classifications to an existing hostCluster represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the hostCluster
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given hostCluster guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public HostCluster updateHostClusterClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateHostClusterClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           HostCluster  hostClusterClassifications = HostClusterMapper.mapOmrsEntityDetailToHostCluster(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  hostClusterClassifications;
    }

    /**
     * Deletes a given classification from an existing hostCluster represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the hostCluster
     * @param name name of the classification
     * @return deleted HostCluster  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public HostCluster deleteHostClusterClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteHostClusterClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       HostCluster declassifiedHostCluster =  HostClusterMapper.mapOmrsEntityDetailToHostCluster(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedHostCluster;
    }

    /**
      * Get the relationships associated with entity hostCluster represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the hostCluster
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getHostClusterRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getHostClusterRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an glossary given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the glossaries relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return Glossary the Glossary entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Glossary getGlossaryById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getGlossaryById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        Glossary gotglossary = GlossaryMapper.mapOmrsEntityDetailToGlossary(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotglossary );
        }
        return gotglossary;

    }
    /**
     * Create new glossary.
     * @param userId user identity
     * @param glossary the input entity with values.
     * @return Glossary the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public Glossary createGlossary(String userId,Glossary glossary)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createGlossaryById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Glossary");
        if (constraint!=null) {
             constraint.preCreate(glossary);
        }

        EntityDetail entityDetail = GlossaryMapper.mapGlossaryToOmrsEntityDetail(glossary);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        Glossary createdGlossary =  GlossaryMapper.mapOmrsEntityDetailToGlossary(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created Glossary="+ createdGlossary );
        }
        return createdGlossary;
    }
    /**
     * Update glossary
     * @param userId user identity
     * @param glossary   glossary to update
     * @return Glossary the updated glossary entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Glossary updateGlossary(String userId, Glossary glossary)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateGlossaryById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = GlossaryMapper.mapGlossaryToOmrsEntityDetail(glossary);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            Glossary updatedGlossary =  GlossaryMapper.mapOmrsEntityDetailToGlossary(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated Glossary="+ updatedGlossary );
            }
            return updatedGlossary;
        }

    /**
     * Delete an glossary identified by its GUID. Delete is a soft delete, this means that the glossary has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the glossary
     * @return Glossary the deleted Glossary entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteGlossaryByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteGlossaryByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Glossary type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Glossary");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"Glossary",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an glossary identified by its GUID. Delete is a hard delete, this means that the glossary is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the glossary
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeGlossaryByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeGlossaryByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Glossary type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Glossary");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"Glossary",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an Glossary identified by its GUID. Restore resurrects a soft deleted Glossary. When a Glossary was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the Glossary
     * @return  Glossary the restored Glossary
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the Glossary is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public Glossary restoreGlossary(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreGlossaryByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        Glossary restoredGlossary =  GlossaryMapper.mapOmrsEntityDetailToGlossary(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredGlossary;
    }    

    /**
     * Add classifications to the supplied glossary
     * @param userId user identity
     * @param entityGuid the GUID value for glossary
     * @param classifications the classifications to apply.
     * @return the glossary entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public Glossary addGlossaryClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addGlossaryClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         Glossary glossaryClassifications = GlossaryMapper.mapOmrsEntityDetailToGlossary(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified Glossary=" +  glossaryClassifications);
         }
         return  glossaryClassifications;
    }

    /**
     * Updates classifications to an existing glossary represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the glossary
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given glossary guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Glossary updateGlossaryClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateGlossaryClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           Glossary  glossaryClassifications = GlossaryMapper.mapOmrsEntityDetailToGlossary(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  glossaryClassifications;
    }

    /**
     * Deletes a given classification from an existing glossary represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the glossary
     * @param name name of the classification
     * @return deleted Glossary  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Glossary deleteGlossaryClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteGlossaryClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       Glossary declassifiedGlossary =  GlossaryMapper.mapOmrsEntityDetailToGlossary(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedGlossary;
    }

    /**
      * Get the relationships associated with entity glossary represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the glossary
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getGlossaryRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getGlossaryRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an glossaryCategory given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the glossaryCategories relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return GlossaryCategory the GlossaryCategory entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public GlossaryCategory getGlossaryCategoryById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getGlossaryCategoryById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        GlossaryCategory gotglossaryCategory = GlossaryCategoryMapper.mapOmrsEntityDetailToGlossaryCategory(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotglossaryCategory );
        }
        return gotglossaryCategory;

    }
    /**
     * Create new glossaryCategory.
     * @param userId user identity
     * @param glossaryCategory the input entity with values.
     * @return GlossaryCategory the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public GlossaryCategory createGlossaryCategory(String userId,GlossaryCategory glossaryCategory)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createGlossaryCategoryById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("GlossaryCategory");
        if (constraint!=null) {
             constraint.preCreate(glossaryCategory);
        }

        EntityDetail entityDetail = GlossaryCategoryMapper.mapGlossaryCategoryToOmrsEntityDetail(glossaryCategory);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        GlossaryCategory createdGlossaryCategory =  GlossaryCategoryMapper.mapOmrsEntityDetailToGlossaryCategory(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created GlossaryCategory="+ createdGlossaryCategory );
        }
        return createdGlossaryCategory;
    }
    /**
     * Update glossaryCategory
     * @param userId user identity
     * @param glossaryCategory   glossaryCategory to update
     * @return GlossaryCategory the updated glossaryCategory entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public GlossaryCategory updateGlossaryCategory(String userId, GlossaryCategory glossaryCategory)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateGlossaryCategoryById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = GlossaryCategoryMapper.mapGlossaryCategoryToOmrsEntityDetail(glossaryCategory);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            GlossaryCategory updatedGlossaryCategory =  GlossaryCategoryMapper.mapOmrsEntityDetailToGlossaryCategory(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated GlossaryCategory="+ updatedGlossaryCategory );
            }
            return updatedGlossaryCategory;
        }

    /**
     * Delete an glossaryCategory identified by its GUID. Delete is a soft delete, this means that the glossaryCategory has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the glossaryCategory
     * @return GlossaryCategory the deleted GlossaryCategory entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteGlossaryCategoryByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteGlossaryCategoryByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the GlossaryCategory type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("GlossaryCategory");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"GlossaryCategory",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an glossaryCategory identified by its GUID. Delete is a hard delete, this means that the glossaryCategory is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the glossaryCategory
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeGlossaryCategoryByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeGlossaryCategoryByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the GlossaryCategory type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("GlossaryCategory");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"GlossaryCategory",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an GlossaryCategory identified by its GUID. Restore resurrects a soft deleted GlossaryCategory. When a GlossaryCategory was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the GlossaryCategory
     * @return  GlossaryCategory the restored GlossaryCategory
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the GlossaryCategory is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public GlossaryCategory restoreGlossaryCategory(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreGlossaryCategoryByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        GlossaryCategory restoredGlossaryCategory =  GlossaryCategoryMapper.mapOmrsEntityDetailToGlossaryCategory(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredGlossaryCategory;
    }    

    /**
     * Add classifications to the supplied glossaryCategory
     * @param userId user identity
     * @param entityGuid the GUID value for glossaryCategory
     * @param classifications the classifications to apply.
     * @return the glossaryCategory entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public GlossaryCategory addGlossaryCategoryClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addGlossaryCategoryClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         GlossaryCategory glossaryCategoryClassifications = GlossaryCategoryMapper.mapOmrsEntityDetailToGlossaryCategory(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified GlossaryCategory=" +  glossaryCategoryClassifications);
         }
         return  glossaryCategoryClassifications;
    }

    /**
     * Updates classifications to an existing glossaryCategory represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the glossaryCategory
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given glossaryCategory guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public GlossaryCategory updateGlossaryCategoryClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateGlossaryCategoryClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           GlossaryCategory  glossaryCategoryClassifications = GlossaryCategoryMapper.mapOmrsEntityDetailToGlossaryCategory(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  glossaryCategoryClassifications;
    }

    /**
     * Deletes a given classification from an existing glossaryCategory represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the glossaryCategory
     * @param name name of the classification
     * @return deleted GlossaryCategory  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public GlossaryCategory deleteGlossaryCategoryClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteGlossaryCategoryClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       GlossaryCategory declassifiedGlossaryCategory =  GlossaryCategoryMapper.mapOmrsEntityDetailToGlossaryCategory(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedGlossaryCategory;
    }

    /**
      * Get the relationships associated with entity glossaryCategory represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the glossaryCategory
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getGlossaryCategoryRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getGlossaryCategoryRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an mediaCollection given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the mediaCollections relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return MediaCollection the MediaCollection entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public MediaCollection getMediaCollectionById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getMediaCollectionById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        MediaCollection gotmediaCollection = MediaCollectionMapper.mapOmrsEntityDetailToMediaCollection(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotmediaCollection );
        }
        return gotmediaCollection;

    }
    /**
     * Create new mediaCollection.
     * @param userId user identity
     * @param mediaCollection the input entity with values.
     * @return MediaCollection the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public MediaCollection createMediaCollection(String userId,MediaCollection mediaCollection)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createMediaCollectionById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("MediaCollection");
        if (constraint!=null) {
             constraint.preCreate(mediaCollection);
        }

        EntityDetail entityDetail = MediaCollectionMapper.mapMediaCollectionToOmrsEntityDetail(mediaCollection);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        MediaCollection createdMediaCollection =  MediaCollectionMapper.mapOmrsEntityDetailToMediaCollection(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created MediaCollection="+ createdMediaCollection );
        }
        return createdMediaCollection;
    }
    /**
     * Update mediaCollection
     * @param userId user identity
     * @param mediaCollection   mediaCollection to update
     * @return MediaCollection the updated mediaCollection entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public MediaCollection updateMediaCollection(String userId, MediaCollection mediaCollection)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateMediaCollectionById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = MediaCollectionMapper.mapMediaCollectionToOmrsEntityDetail(mediaCollection);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            MediaCollection updatedMediaCollection =  MediaCollectionMapper.mapOmrsEntityDetailToMediaCollection(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated MediaCollection="+ updatedMediaCollection );
            }
            return updatedMediaCollection;
        }

    /**
     * Delete an mediaCollection identified by its GUID. Delete is a soft delete, this means that the mediaCollection has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the mediaCollection
     * @return MediaCollection the deleted MediaCollection entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteMediaCollectionByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteMediaCollectionByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the MediaCollection type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("MediaCollection");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"MediaCollection",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an mediaCollection identified by its GUID. Delete is a hard delete, this means that the mediaCollection is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the mediaCollection
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeMediaCollectionByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeMediaCollectionByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the MediaCollection type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("MediaCollection");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"MediaCollection",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an MediaCollection identified by its GUID. Restore resurrects a soft deleted MediaCollection. When a MediaCollection was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the MediaCollection
     * @return  MediaCollection the restored MediaCollection
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the MediaCollection is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public MediaCollection restoreMediaCollection(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreMediaCollectionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        MediaCollection restoredMediaCollection =  MediaCollectionMapper.mapOmrsEntityDetailToMediaCollection(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredMediaCollection;
    }    

    /**
     * Add classifications to the supplied mediaCollection
     * @param userId user identity
     * @param entityGuid the GUID value for mediaCollection
     * @param classifications the classifications to apply.
     * @return the mediaCollection entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public MediaCollection addMediaCollectionClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addMediaCollectionClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         MediaCollection mediaCollectionClassifications = MediaCollectionMapper.mapOmrsEntityDetailToMediaCollection(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified MediaCollection=" +  mediaCollectionClassifications);
         }
         return  mediaCollectionClassifications;
    }

    /**
     * Updates classifications to an existing mediaCollection represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the mediaCollection
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given mediaCollection guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public MediaCollection updateMediaCollectionClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateMediaCollectionClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           MediaCollection  mediaCollectionClassifications = MediaCollectionMapper.mapOmrsEntityDetailToMediaCollection(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  mediaCollectionClassifications;
    }

    /**
     * Deletes a given classification from an existing mediaCollection represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the mediaCollection
     * @param name name of the classification
     * @return deleted MediaCollection  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public MediaCollection deleteMediaCollectionClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteMediaCollectionClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       MediaCollection declassifiedMediaCollection =  MediaCollectionMapper.mapOmrsEntityDetailToMediaCollection(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedMediaCollection;
    }

    /**
      * Get the relationships associated with entity mediaCollection represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the mediaCollection
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getMediaCollectionRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getMediaCollectionRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an collection given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the collections relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return Collection the Collection entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Collection getCollectionById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getCollectionById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        Collection gotcollection = CollectionMapper.mapOmrsEntityDetailToCollection(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotcollection );
        }
        return gotcollection;

    }
    /**
     * Create new collection.
     * @param userId user identity
     * @param collection the input entity with values.
     * @return Collection the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public Collection createCollection(String userId,Collection collection)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createCollectionById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Collection");
        if (constraint!=null) {
             constraint.preCreate(collection);
        }

        EntityDetail entityDetail = CollectionMapper.mapCollectionToOmrsEntityDetail(collection);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        Collection createdCollection =  CollectionMapper.mapOmrsEntityDetailToCollection(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created Collection="+ createdCollection );
        }
        return createdCollection;
    }
    /**
     * Update collection
     * @param userId user identity
     * @param collection   collection to update
     * @return Collection the updated collection entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Collection updateCollection(String userId, Collection collection)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateCollectionById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = CollectionMapper.mapCollectionToOmrsEntityDetail(collection);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            Collection updatedCollection =  CollectionMapper.mapOmrsEntityDetailToCollection(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated Collection="+ updatedCollection );
            }
            return updatedCollection;
        }

    /**
     * Delete an collection identified by its GUID. Delete is a soft delete, this means that the collection has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the collection
     * @return Collection the deleted Collection entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteCollectionByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteCollectionByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Collection type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Collection");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"Collection",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an collection identified by its GUID. Delete is a hard delete, this means that the collection is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the collection
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeCollectionByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeCollectionByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Collection type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Collection");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"Collection",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an Collection identified by its GUID. Restore resurrects a soft deleted Collection. When a Collection was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the Collection
     * @return  Collection the restored Collection
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the Collection is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public Collection restoreCollection(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreCollectionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        Collection restoredCollection =  CollectionMapper.mapOmrsEntityDetailToCollection(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredCollection;
    }    

    /**
     * Add classifications to the supplied collection
     * @param userId user identity
     * @param entityGuid the GUID value for collection
     * @param classifications the classifications to apply.
     * @return the collection entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public Collection addCollectionClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addCollectionClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         Collection collectionClassifications = CollectionMapper.mapOmrsEntityDetailToCollection(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified Collection=" +  collectionClassifications);
         }
         return  collectionClassifications;
    }

    /**
     * Updates classifications to an existing collection represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the collection
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given collection guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Collection updateCollectionClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateCollectionClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           Collection  collectionClassifications = CollectionMapper.mapOmrsEntityDetailToCollection(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  collectionClassifications;
    }

    /**
     * Deletes a given classification from an existing collection represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the collection
     * @param name name of the classification
     * @return deleted Collection  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Collection deleteCollectionClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteCollectionClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       Collection declassifiedCollection =  CollectionMapper.mapOmrsEntityDetailToCollection(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedCollection;
    }

    /**
      * Get the relationships associated with entity collection represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the collection
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getCollectionRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getCollectionRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an informalTag given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the informalTags relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return InformalTag the InformalTag entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public InformalTag getInformalTagById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getInformalTagById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        InformalTag gotinformalTag = InformalTagMapper.mapOmrsEntityDetailToInformalTag(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotinformalTag );
        }
        return gotinformalTag;

    }
    /**
     * Create new informalTag.
     * @param userId user identity
     * @param informalTag the input entity with values.
     * @return InformalTag the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public InformalTag createInformalTag(String userId,InformalTag informalTag)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createInformalTagById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("InformalTag");
        if (constraint!=null) {
             constraint.preCreate(informalTag);
        }

        EntityDetail entityDetail = InformalTagMapper.mapInformalTagToOmrsEntityDetail(informalTag);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        InformalTag createdInformalTag =  InformalTagMapper.mapOmrsEntityDetailToInformalTag(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created InformalTag="+ createdInformalTag );
        }
        return createdInformalTag;
    }
    /**
     * Update informalTag
     * @param userId user identity
     * @param informalTag   informalTag to update
     * @return InformalTag the updated informalTag entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public InformalTag updateInformalTag(String userId, InformalTag informalTag)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateInformalTagById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = InformalTagMapper.mapInformalTagToOmrsEntityDetail(informalTag);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            InformalTag updatedInformalTag =  InformalTagMapper.mapOmrsEntityDetailToInformalTag(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated InformalTag="+ updatedInformalTag );
            }
            return updatedInformalTag;
        }

    /**
     * Delete an informalTag identified by its GUID. Delete is a soft delete, this means that the informalTag has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the informalTag
     * @return InformalTag the deleted InformalTag entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteInformalTagByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteInformalTagByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the InformalTag type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("InformalTag");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"InformalTag",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an informalTag identified by its GUID. Delete is a hard delete, this means that the informalTag is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the informalTag
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeInformalTagByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeInformalTagByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the InformalTag type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("InformalTag");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"InformalTag",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an InformalTag identified by its GUID. Restore resurrects a soft deleted InformalTag. When a InformalTag was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the InformalTag
     * @return  InformalTag the restored InformalTag
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the InformalTag is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public InformalTag restoreInformalTag(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreInformalTagByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        InformalTag restoredInformalTag =  InformalTagMapper.mapOmrsEntityDetailToInformalTag(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredInformalTag;
    }    

    /**
     * Add classifications to the supplied informalTag
     * @param userId user identity
     * @param entityGuid the GUID value for informalTag
     * @param classifications the classifications to apply.
     * @return the informalTag entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public InformalTag addInformalTagClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addInformalTagClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         InformalTag informalTagClassifications = InformalTagMapper.mapOmrsEntityDetailToInformalTag(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified InformalTag=" +  informalTagClassifications);
         }
         return  informalTagClassifications;
    }

    /**
     * Updates classifications to an existing informalTag represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the informalTag
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given informalTag guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public InformalTag updateInformalTagClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateInformalTagClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           InformalTag  informalTagClassifications = InformalTagMapper.mapOmrsEntityDetailToInformalTag(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  informalTagClassifications;
    }

    /**
     * Deletes a given classification from an existing informalTag represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the informalTag
     * @param name name of the classification
     * @return deleted InformalTag  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public InformalTag deleteInformalTagClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteInformalTagClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       InformalTag declassifiedInformalTag =  InformalTagMapper.mapOmrsEntityDetailToInformalTag(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedInformalTag;
    }

    /**
      * Get the relationships associated with entity informalTag represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the informalTag
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getInformalTagRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getInformalTagRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an governanceZone given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the governanceZones relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return GovernanceZone the GovernanceZone entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public GovernanceZone getGovernanceZoneById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getGovernanceZoneById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        GovernanceZone gotgovernanceZone = GovernanceZoneMapper.mapOmrsEntityDetailToGovernanceZone(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotgovernanceZone );
        }
        return gotgovernanceZone;

    }
    /**
     * Create new governanceZone.
     * @param userId user identity
     * @param governanceZone the input entity with values.
     * @return GovernanceZone the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public GovernanceZone createGovernanceZone(String userId,GovernanceZone governanceZone)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createGovernanceZoneById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("GovernanceZone");
        if (constraint!=null) {
             constraint.preCreate(governanceZone);
        }

        EntityDetail entityDetail = GovernanceZoneMapper.mapGovernanceZoneToOmrsEntityDetail(governanceZone);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        GovernanceZone createdGovernanceZone =  GovernanceZoneMapper.mapOmrsEntityDetailToGovernanceZone(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created GovernanceZone="+ createdGovernanceZone );
        }
        return createdGovernanceZone;
    }
    /**
     * Update governanceZone
     * @param userId user identity
     * @param governanceZone   governanceZone to update
     * @return GovernanceZone the updated governanceZone entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public GovernanceZone updateGovernanceZone(String userId, GovernanceZone governanceZone)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateGovernanceZoneById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = GovernanceZoneMapper.mapGovernanceZoneToOmrsEntityDetail(governanceZone);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            GovernanceZone updatedGovernanceZone =  GovernanceZoneMapper.mapOmrsEntityDetailToGovernanceZone(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated GovernanceZone="+ updatedGovernanceZone );
            }
            return updatedGovernanceZone;
        }

    /**
     * Delete an governanceZone identified by its GUID. Delete is a soft delete, this means that the governanceZone has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the governanceZone
     * @return GovernanceZone the deleted GovernanceZone entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteGovernanceZoneByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteGovernanceZoneByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the GovernanceZone type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernanceZone");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"GovernanceZone",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an governanceZone identified by its GUID. Delete is a hard delete, this means that the governanceZone is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the governanceZone
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeGovernanceZoneByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeGovernanceZoneByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the GovernanceZone type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernanceZone");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"GovernanceZone",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an GovernanceZone identified by its GUID. Restore resurrects a soft deleted GovernanceZone. When a GovernanceZone was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the GovernanceZone
     * @return  GovernanceZone the restored GovernanceZone
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the GovernanceZone is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public GovernanceZone restoreGovernanceZone(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreGovernanceZoneByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        GovernanceZone restoredGovernanceZone =  GovernanceZoneMapper.mapOmrsEntityDetailToGovernanceZone(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredGovernanceZone;
    }    

    /**
     * Add classifications to the supplied governanceZone
     * @param userId user identity
     * @param entityGuid the GUID value for governanceZone
     * @param classifications the classifications to apply.
     * @return the governanceZone entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public GovernanceZone addGovernanceZoneClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addGovernanceZoneClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         GovernanceZone governanceZoneClassifications = GovernanceZoneMapper.mapOmrsEntityDetailToGovernanceZone(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified GovernanceZone=" +  governanceZoneClassifications);
         }
         return  governanceZoneClassifications;
    }

    /**
     * Updates classifications to an existing governanceZone represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the governanceZone
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given governanceZone guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public GovernanceZone updateGovernanceZoneClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateGovernanceZoneClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
                     entityGuid,
                     name);
                 // re-add with the new properties.
                 oMRSAPIHelper.callOMRSClassifyEntity(userId,
                     entityGuid,
                     name,
                     instanceProperties);
            }

            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
           GovernanceZone  governanceZoneClassifications = GovernanceZoneMapper.mapOmrsEntityDetailToGovernanceZone(updatedOMRSEntityDetail);

            if (log.isDebugEnabled()) {
                   log.debug("<== Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
            }
             return  governanceZoneClassifications;
    }

    /**
     * Deletes a given classification from an existing governanceZone represented by a guid.
     * @param userId user identity
     * @param entityGuid  globally unique identifier for the governanceZone
     * @param name name of the classification
     * @return deleted GovernanceZone  classification
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public GovernanceZone deleteGovernanceZoneClassification(String userId,String entityGuid, final String name)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

       final String methodName = "deleteGovernanceZoneClassification";
       if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       InputValidator.validateUserIdNotNull(className,methodName,userId);
       InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");


       oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid,name);
       EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
       GovernanceZone declassifiedGovernanceZone =  GovernanceZoneMapper.mapOmrsEntityDetailToGovernanceZone(omrsEntityDetail);
       if (log.isDebugEnabled()) {
           log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",name="+name);
       }
       return declassifiedGovernanceZone;
    }

    /**
      * Get the relationships associated with entity governanceZone represented by a guid.
      * @param userId user identity
      * @param entityGuid  globally unique identifier for the governanceZone
      * @param relationshipTypeGuid the guid of the relationship type to restrict the relationships returned to this type. null means return all relationship types.
      * @param fromRelationshipElement the starting element number of the relationships to return.
      *                                This is used when retrieving elements
      *                                beyond the first page of results. Zero means start from the first element.
      * @param asOfTime Date return relationships as they were at some time in the past. null indicates to return relationships as they are now.
      * @param sequencingProperty String name of the property that is to be used to sequence the results.
      *                           Null means do not sequence on a property name (see SequencingOrder).
      * @param sequencingOrder Enum defining how the results should be ordered.
      * @param pageSize  the maximum number of result classifications that can be returned on this request.  Zero means
      *                 unrestricted return results size.
      * @return {@code List<Line> }
      * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
      * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
      * @throws InvalidParameterException a parameter is null or an invalid value.
      * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
      * @throws FunctionNotSupportedException a function is not supported.
      */
     public Set<Line> getGovernanceZoneRelationships(
                        String                     userId,
                        String                     entityGuid,
                        String                     relationshipTypeGuid,
                        int                        fromRelationshipElement,
                        Date                       asOfTime,
                        String                     sequencingProperty,
                        SequencingOrder            sequencingOrder,
                        int                        pageSize)
         throws MetadataServerUncontactableException,
          UserNotAuthorizedException,
          InvalidParameterException,
          FunctionNotSupportedException,
          UnrecognizedGUIDException {
        final String methodName = "getGovernanceZoneRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",entity guid="+entityGuid + ",relationship Type Guid="+relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        Set<Line> lines = null;

        List<Relationship> omrsRelationships = oMRSAPIHelper.callGetRelationshipsForEntity( userId,
                    entityGuid,
                    relationshipTypeGuid,
                    fromRelationshipElement,
                    asOfTime,
                    sequencingProperty,
                    sequencingOrder,
                    pageSize);
        if (omrsRelationships !=null) {
            lines =  OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return lines;
    }
    /**
     * Fetch complete definition of an application given its GUID.
     * The limit and offset paging parameters limit the number elements returned in each of the applications relationships.
     * @param userId user identity
     * @param entityGuid GUID for the entity
     * @return Application the Application entity with the requested GUID
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object. the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Application getApplicationById(String userId,String entityGuid)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException
    {
        final String methodName = "getApplicationById";
        if (log.isDebugEnabled()) {
          log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

        EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);
            
        Application gotapplication = ApplicationMapper.mapOmrsEntityDetailToApplication(omrsEntityDetail);
        if (log.isDebugEnabled()) {
         
             log.debug("<== successful method : " + methodName + ",userId="+userId+",guid="+entityGuid+",entity="+ gotapplication );
        }
        return gotapplication;

    }
    /**
     * Create new application.
     * @param userId user identity
     * @param application the input entity with values.
     * @return Application the created entity.
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws ClassificationException a classification does not match constraints.
     * @throws StatusNotSupportedException  status is not supported
     */

    public Application createApplication(String userId,Application application)
          throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException
    {

        final String methodName = "createApplicationById";
        if (log.isDebugEnabled()) {
           log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);

        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Application");
        if (constraint!=null) {
             constraint.preCreate(application);
        }

        EntityDetail entityDetail = ApplicationMapper.mapApplicationToOmrsEntityDetail(application);
        EntityDetail addedOMRSEntityDetail = oMRSAPIHelper.callOMRSAddEntity(userId,entityDetail);

        Application createdApplication =  ApplicationMapper.mapOmrsEntityDetailToApplication(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
              log.debug("<== successful method : " + methodName + ",userId="+userId+", created Application="+ createdApplication );
        }
        return createdApplication;
    }
    /**
     * Update application
     * @param userId user identity
     * @param application   application to update
     * @return Application the updated application entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */
    public Application updateApplication(String userId, Application application)
         throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException,UnrecognizedGUIDException
    {

            final String methodName = "updateApplicationById";
            if (log.isDebugEnabled()) {
                log.debug("==> Method: " + methodName + ",userId=" + userId);
            }
            InputValidator.validateUserIdNotNull(className,methodName,userId);
            EntityDetail entityDetail = ApplicationMapper.mapApplicationToOmrsEntityDetail(application);
            InputValidator.validateGUIDNotNull(className,methodName,entityDetail.getGUID(),"guid");
            EntityDetail updatedOMRSEntityDetail = oMRSAPIHelper.callOMRSUpdateEntity(userId,entityDetail);

            Application updatedApplication =  ApplicationMapper.mapOmrsEntityDetailToApplication(updatedOMRSEntityDetail);
            if (log.isDebugEnabled()) {
                    log.debug("<== successful method: " + methodName + ",userId=" + userId + ",updated Application="+ updatedApplication );
            }
            return updatedApplication;
        }

    /**
     * Delete an application identified by its GUID. Delete is a soft delete, this means that the application has its status changed to
     * deleted. Soft deletion support os optional, so this call may fail. Soft deletes can be undone using the restore call.
     * If it is required that an entity is really deleted (a hard delete) then the purge call should be used.
     *
     * @param userId user identity
     * @param  entityGuid GUID for the application
     * @return Application the deleted Application entity
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws FunctionNotSupportedException a function is not supported.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     */

    public EntityDetail deleteApplicationByGuid(String userId,final String entityGuid)
         throws MetadataServerUncontactableException, UserNotAuthorizedException,  FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException
    {
         final String methodName = "deleteApplicationByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Application type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Application");
         EntityDetail deletedOmrsEntityDetail = oMRSAPIHelper.callOMRSDeleteEntity(userId,"Application",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         return deletedOmrsEntityDetail;

    }
    /**
     * Purge an application identified by its GUID. Delete is a hard delete, this means that the application is really
     * deleted .
     * @param userId user identity
     * @param  entityGuid GUID for the application
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws EntityNotDeletedException the entity was not deleted
     * @throws GUIDNotPurgedException the unique identifier (guid) used to purge an object did not result in the object being purged.
     */
    public void purgeApplicationByGuid(String userId,final String entityGuid)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {

        final String methodName = "purgeApplicationByGuid";
         if (log.isDebugEnabled()) {
              log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);
         InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

         // get the Application type guid
         OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
         EntityDef entityDef = archiveAccessor.getEntityDefByName("Application");
         oMRSAPIHelper.callOMRSPurgeEntity(userId,"Application",entityDef.getGUID(),entityGuid);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
    }
    /**
     * Restore an Application identified by its GUID. Restore resurrects a soft deleted Application. When a Application was incorrectly deleted, the delete can be undone using the restore..
     * @param userId user identity
     * @param entityGuid GUID for the Application
     * @return  Application the restored Application
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action.
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws GUIDNotDeletedException the guid of the Application is not deleted, so cannot be restored
     * @throws FunctionNotSupportedException Function not supported
     */
    public Application restoreApplication(String userId,final String entityGuid) throws MetadataServerUncontactableException,
                                                                                          UserNotAuthorizedException,
                                                                                          InvalidParameterException,
                                                                                          UnrecognizedGUIDException,
                                                                                          GUIDNotDeletedException,
                                                                                          FunctionNotSupportedException
    {

        final String methodName = "restoreApplicationByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");
        EntityDetail omrsEntity =  oMRSAPIHelper.callOMRSRestoreEntity(userId,entityGuid);
        Application restoredApplication =  ApplicationMapper.mapOmrsEntityDetailToApplication(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        return restoredApplication;
    }    

    /**
     * Add classifications to the supplied application
     * @param userId user identity
     * @param entityGuid the GUID value for application
     * @param classifications the classifications to apply.
     * @return the application entity that has been classified
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
     public Application addApplicationClassifications(String userId,final String entityGuid, List<Classification> classifications)
           throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {

        final String methodName = "addApplicationClassifications";
         if (log.isDebugEnabled()) {
             log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
         }
         InputValidator.validateUserIdNotNull(className,methodName,userId);


         for (Classification classification:classifications) {
             InstanceProperties instanceProperties = classification.obtainInstanceProperties();
             String name =classification.getClassificationName();
             InputValidator.validateNameNotNull(className,methodName,name,"classifications");
             oMRSAPIHelper.callOMRSClassifyEntity(userId,
                 entityGuid,
                 name,
                 instanceProperties);
         }

         EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

         Application applicationClassifications = ApplicationMapper.mapOmrsEntityDetailToApplication(omrsEntityDetail);
         if (log.isDebugEnabled()) {
             log.debug("<== successful Method: " + methodName + ",userId="+userId+",guid="+entityGuid+",classified Application=" +  applicationClassifications);
         }
         return  applicationClassifications;
    }

    /**
     * Updates classifications to an existing application represented by a guid.
     * @param userId user identity
     * @param  entityGuid globally unique identifier for the application
     * @param classificationsToUpdate List of classifications to update entity with
     * @return classification for the given application guid
     * @throws MetadataServerUncontactableException not able to communicate with the metadata server.
     * @throws UserNotAuthorizedException the userId passed on the request is not authorized to perform the requested action. 
     * @throws InvalidParameterException a parameter is null or an invalid value.
     * @throws UnrecognizedGUIDException the unique identifier (guid) used to request an object is either unrecognized, or is the identifier for a different type of object.
     * @throws ClassificationException a classification does not match constraints.
     */
    public Application updateApplicationClassification(String userId, final String entityGuid, List<Classification> classificationsToUpdate)
        throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException,  UnrecognizedGUIDException {

        final String methodName = "updateApplicationClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId="+userId+",guid="+entityGuid);
        }
        InputValidator.validateUserIdNotNull(className,methodName,userId);
        InputValidator.validateGUIDNotNull(className,methodName,entityGuid,"entityGuid");

            EntityDetail omrsEntityDetail = oMRSAPIHelper.callOMRSGetEntityByGuid(userId,entityGuid);

            List<String> existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
            for (Classification classification:classificationsToUpdate) {
                 String name = classification.getClassificationName();
                 // Only allow updates of classifications that already exist.
                 if (!existingClassificationNames.contains(name)) {
                     SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
                     String errorMessage = errorCode.getErrorMessageId()
                            + errorCode.getFormattedErrorMessage(
                               name,
                              "classificationsToUpdate",
                              methodName,
                             entityGuid
                             );
                      log.error(errorMessage);
                      throw new InvalidParameterException(errorCode.getHTTPErrorCode(),
                                          className,
                                          methodName,
                                          errorMessage,
                                          errorCode.getSystemAction(),
                                          errorCode.getUserAction());
                 }
            }
            for (Classification classification:classificationsToUpdate) {
                 InstanceProperties instanceProperties = classification.obtainInstanceProperties();
                 String name =classification.getClassificationName();
                 //remove existing classification
                 oMRSAPIHelper.callOMRSDeClassifyEntity(userId,
   