/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.constraints;

import org.odpi.openmetadata.accessservices.subjectarea.constraints.SubjectAreaConstraint;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryTerm.GlossaryTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryTermConstraint
implements SubjectAreaConstraint {
    private static final Logger log = LoggerFactory.getLogger(GlossaryTermConstraint.class);
    private static final String className = GlossaryTermConstraint.class.getName();

    @Override
    public void preCreate(Object artifact) throws InvalidParameterException {
        GlossaryTerm glossaryTerm;
        String displayName;
        String methodName = "preCreate";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: preCreate");
        }
        if ((displayName = (glossaryTerm = (GlossaryTerm)artifact).getDisplayName()) == null) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GLOSSARY_TERM_CREATE_WITHOUT_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "preCreate"});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "preCreate", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: preCreate");
        }
    }

    @Override
    public void postCreate(Object artifact) throws InvalidParameterException {
        GlossaryTerm glossaryTerm = (GlossaryTerm)artifact;
        String guid = glossaryTerm.getSystemAttributes().getGUID();
        glossaryTerm.setQualifiedName("GlossaryTerm." + guid);
    }

    @Override
    public void preUpdate(Object artifact, Object proposedArtifact) throws InvalidParameterException {
    }

    @Override
    public void postUpdate(Object artifact) throws InvalidParameterException {
    }

    @Override
    public void preDelete(Object artifact) throws InvalidParameterException {
    }

    @Override
    public void postDelete(Object artifact) throws InvalidParameterException {
    }
}

