/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Criticality;

import java.util.HashMap;
import java.util.Iterator;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Criticality;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.CriticalityLevel;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.GovernanceClassificationStatus;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.archivemanager.OMRSArchiveAccessor;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriticalityMapper {
    private static final Logger log = LoggerFactory.getLogger(CriticalityMapper.class);
    private static final String className = CriticalityMapper.class.getName();

    public static Criticality mapOmrsToOmas(Classification omrsClassification) throws InvalidParameterException {
        String classificationTypeName = omrsClassification.getName();
        if ("Criticality".equals(classificationTypeName)) {
            Criticality criticality = new Criticality();
            SystemAttributes systemAttributes = new SystemAttributes();
            InstanceStatus instanceStatus = omrsClassification.getStatus();
            Status omrsBeanStatus = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
            systemAttributes.setStatus(omrsBeanStatus);
            systemAttributes.setCreatedBy(omrsClassification.getCreatedBy());
            systemAttributes.setUpdatedBy(omrsClassification.getUpdatedBy());
            systemAttributes.setCreateTime(omrsClassification.getCreateTime());
            systemAttributes.setUpdateTime(omrsClassification.getUpdateTime());
            systemAttributes.setVersion(Long.valueOf(omrsClassification.getVersion()));
            criticality.setSystemAttributes(systemAttributes);
            InstanceProperties omrsClassificationProperties = omrsClassification.getProperties();
            if (omrsClassificationProperties != null) {
                omrsClassificationProperties.setEffectiveFromTime(criticality.getEffectiveFromTime());
                omrsClassificationProperties.setEffectiveToTime(criticality.getEffectiveToTime());
                Iterator omrsPropertyIterator = omrsClassificationProperties.getPropertyNames();
                while (omrsPropertyIterator.hasNext()) {
                    String name = (String)omrsPropertyIterator.next();
                    InstancePropertyValue value = omrsClassificationProperties.getPropertyValue(name);
                    switch (value.getInstancePropertyCategory()) {
                        case PRIMITIVE: {
                            PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                            Object actualValue = primitivePropertyValue.getPrimitiveValue();
                            if (Criticality.ATTRIBUTE_NAMES_SET.contains(name)) {
                                if (name.equals("confidence")) {
                                    criticality.setConfidence((Integer)actualValue);
                                }
                                if (name.equals("steward")) {
                                    criticality.setSteward((String)actualValue);
                                }
                                if (name.equals("source")) {
                                    criticality.setSource((String)actualValue);
                                }
                                if (!name.equals("notes")) break;
                                criticality.setNotes((String)actualValue);
                                break;
                            }
                            if (null == criticality.getExtraAttributes()) {
                                criticality.setExtraAttributes(new HashMap());
                            }
                            criticality.getExtraAttributes().put(name, primitivePropertyValue);
                            break;
                        }
                        case ENUM: {
                            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                            String symbolicName = enumPropertyValue.getSymbolicName();
                            if (Criticality.ENUM_NAMES_SET.contains(name)) {
                                if (name.equals("status")) {
                                    GovernanceClassificationStatus status = GovernanceClassificationStatus.valueOf((String)symbolicName);
                                    criticality.setStatus(status);
                                }
                                if (!name.equals("level")) break;
                                CriticalityLevel level = CriticalityLevel.valueOf((String)symbolicName);
                                criticality.setLevel(level);
                                break;
                            }
                            if (null == criticality.getExtraAttributes()) {
                                criticality.setExtraAttributes(new HashMap());
                            }
                            criticality.getExtraAttributes().put(name, enumPropertyValue);
                            break;
                        }
                        case MAP: {
                            if (!Criticality.MAP_NAMES_SET.contains(name)) break;
                            MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                            InstanceProperties instanceProperties = mapPropertyValue.getMapValues();
                            break;
                        }
                    }
                }
            }
            return criticality;
        }
        return null;
    }

    public static Classification mapBeanToOmrs(Criticality criticality) {
        EnumPropertyValue enumPropertyValue;
        GovernanceClassificationStatus enumType;
        PrimitivePropertyValue primitivePropertyValue;
        Classification omrsClassification = new Classification();
        SystemAttributes systemAttributes = criticality.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsClassification.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsClassification.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsClassification.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsClassification.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsClassification.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToInstanceStatus(systemAttributes.getStatus());
                omrsClassification.setStatus(instanceStatus);
            }
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        if (criticality.getConfidence() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
            primitivePropertyValue.setPrimitiveValue((Object)criticality.getConfidence());
            instanceProperties.setProperty("confidence", (InstancePropertyValue)primitivePropertyValue);
        }
        if (criticality.getSteward() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)criticality.getSteward());
            instanceProperties.setProperty("steward", (InstancePropertyValue)primitivePropertyValue);
        }
        if (criticality.getSource() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)criticality.getSource());
            instanceProperties.setProperty("source", (InstancePropertyValue)primitivePropertyValue);
        }
        if (criticality.getNotes() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)criticality.getNotes());
            instanceProperties.setProperty("notes", (InstancePropertyValue)primitivePropertyValue);
        }
        if (criticality.getStatus() != null) {
            enumType = criticality.getStatus();
            enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(enumType.ordinal());
            enumPropertyValue.setSymbolicName(enumType.name());
            instanceProperties.setProperty("status", (InstancePropertyValue)enumPropertyValue);
        }
        if (criticality.getLevel() != null) {
            enumType = criticality.getLevel();
            enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(enumType.ordinal());
            enumPropertyValue.setSymbolicName(enumType.name());
            instanceProperties.setProperty("level", (InstancePropertyValue)enumPropertyValue);
        }
        omrsClassification.setProperties(instanceProperties);
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef typeDef = archiveAccessor.getEntityDefByName("Criticality");
        InstanceType template = SubjectAreaUtils.createTemplateFromTypeDef((TypeDef)typeDef);
        InstanceType instanceType = new InstanceType(template);
        omrsClassification.setType(instanceType);
        return omrsClassification;
    }
}

