/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.DataStoreEncoding;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.DataStoreEncoding;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.archivemanager.OMRSArchiveAccessor;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreEncodingMapper {
    private static final Logger log = LoggerFactory.getLogger(DataStoreEncodingMapper.class);
    private static final String className = DataStoreEncodingMapper.class.getName();

    public static DataStoreEncoding mapOmrsToOmas(Classification omrsClassification) throws InvalidParameterException {
        String classificationTypeName = omrsClassification.getName();
        if ("DataStoreEncoding".equals(classificationTypeName)) {
            DataStoreEncoding dataStoreEncoding = new DataStoreEncoding();
            SystemAttributes systemAttributes = new SystemAttributes();
            InstanceStatus instanceStatus = omrsClassification.getStatus();
            Status omrsBeanStatus = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
            systemAttributes.setStatus(omrsBeanStatus);
            systemAttributes.setCreatedBy(omrsClassification.getCreatedBy());
            systemAttributes.setUpdatedBy(omrsClassification.getUpdatedBy());
            systemAttributes.setCreateTime(omrsClassification.getCreateTime());
            systemAttributes.setUpdateTime(omrsClassification.getUpdateTime());
            systemAttributes.setVersion(Long.valueOf(omrsClassification.getVersion()));
            dataStoreEncoding.setSystemAttributes(systemAttributes);
            InstanceProperties omrsClassificationProperties = omrsClassification.getProperties();
            if (omrsClassificationProperties != null) {
                omrsClassificationProperties.setEffectiveFromTime(dataStoreEncoding.getEffectiveFromTime());
                omrsClassificationProperties.setEffectiveToTime(dataStoreEncoding.getEffectiveToTime());
                Iterator omrsPropertyIterator = omrsClassificationProperties.getPropertyNames();
                block5: while (omrsPropertyIterator.hasNext()) {
                    String name = (String)omrsPropertyIterator.next();
                    InstancePropertyValue value = omrsClassificationProperties.getPropertyValue(name);
                    switch (value.getInstancePropertyCategory()) {
                        case PRIMITIVE: {
                            PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                            Object actualValue = primitivePropertyValue.getPrimitiveValue();
                            if (DataStoreEncoding.ATTRIBUTE_NAMES_SET.contains(name)) {
                                if (name.equals("encoding")) {
                                    dataStoreEncoding.setEncoding((String)actualValue);
                                }
                                if (name.equals("language")) {
                                    dataStoreEncoding.setLanguage((String)actualValue);
                                }
                                if (!name.equals("description")) break;
                                dataStoreEncoding.setDescription((String)actualValue);
                                break;
                            }
                            if (null == dataStoreEncoding.getExtraAttributes()) {
                                dataStoreEncoding.setExtraAttributes(new HashMap());
                            }
                            dataStoreEncoding.getExtraAttributes().put(name, primitivePropertyValue);
                            break;
                        }
                        case ENUM: {
                            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                            String symbolicName = enumPropertyValue.getSymbolicName();
                            if (DataStoreEncoding.ENUM_NAMES_SET.contains(name)) break;
                            if (null == dataStoreEncoding.getExtraAttributes()) {
                                dataStoreEncoding.setExtraAttributes(new HashMap());
                            }
                            dataStoreEncoding.getExtraAttributes().put(name, enumPropertyValue);
                            break;
                        }
                        case MAP: {
                            if (!DataStoreEncoding.MAP_NAMES_SET.contains(name)) break;
                            MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                            InstanceProperties instancePropertyForMap = mapPropertyValue.getMapValues();
                            if (!name.equals("properties")) continue block5;
                            HashMap<String, String> actualMap = new HashMap<String, String>();
                            Iterator iter = instancePropertyForMap.getPropertyNames();
                            while (iter.hasNext()) {
                                String mapkey = (String)iter.next();
                                PrimitivePropertyValue primitivePropertyMapValue = (PrimitivePropertyValue)instancePropertyForMap.getPropertyValue(mapkey);
                                String mapvalue = (String)primitivePropertyMapValue.getPrimitiveValue();
                                actualMap.put(mapkey, mapvalue);
                            }
                            dataStoreEncoding.setProperties(actualMap);
                            break;
                        }
                    }
                }
            }
            return dataStoreEncoding;
        }
        return null;
    }

    public static Classification mapBeanToOmrs(DataStoreEncoding dataStoreEncoding) {
        PrimitivePropertyValue primitivePropertyValue;
        Classification omrsClassification = new Classification();
        SystemAttributes systemAttributes = dataStoreEncoding.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsClassification.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsClassification.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsClassification.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsClassification.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsClassification.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToInstanceStatus(systemAttributes.getStatus());
                omrsClassification.setStatus(instanceStatus);
            }
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        if (dataStoreEncoding.getEncoding() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)dataStoreEncoding.getEncoding());
            instanceProperties.setProperty("encoding", (InstancePropertyValue)primitivePropertyValue);
        }
        if (dataStoreEncoding.getLanguage() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)dataStoreEncoding.getLanguage());
            instanceProperties.setProperty("language", (InstancePropertyValue)primitivePropertyValue);
        }
        if (dataStoreEncoding.getDescription() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)dataStoreEncoding.getDescription());
            instanceProperties.setProperty("description", (InstancePropertyValue)primitivePropertyValue);
        }
        if (dataStoreEncoding.getProperties() != null) {
            Map map = dataStoreEncoding.getProperties();
            MapPropertyValue mapPropertyValue = new MapPropertyValue();
            for (String key : map.keySet()) {
                PrimitivePropertyValue primitivePropertyValue2 = new PrimitivePropertyValue();
                primitivePropertyValue2.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue2.setPrimitiveValue(map.get(key));
                mapPropertyValue.setMapValue(key, (InstancePropertyValue)primitivePropertyValue2);
            }
            instanceProperties.setProperty("properties", (InstancePropertyValue)mapPropertyValue);
        }
        omrsClassification.setProperties(instanceProperties);
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef typeDef = archiveAccessor.getEntityDefByName("DataStoreEncoding");
        InstanceType template = SubjectAreaUtils.createTemplateFromTypeDef((TypeDef)typeDef);
        InstanceType instanceType = new InstanceType(template);
        omrsClassification.setType(instanceType);
        return omrsClassification;
    }
}

