/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.ExceptionBacklog;

import java.util.HashMap;
import java.util.Iterator;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.ExceptionBacklog;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.archivemanager.OMRSArchiveAccessor;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionBacklogMapper {
    private static final Logger log = LoggerFactory.getLogger(ExceptionBacklogMapper.class);
    private static final String className = ExceptionBacklogMapper.class.getName();

    public static ExceptionBacklog mapOmrsToOmas(Classification omrsClassification) throws InvalidParameterException {
        String classificationTypeName = omrsClassification.getName();
        if ("ExceptionBacklog".equals(classificationTypeName)) {
            ExceptionBacklog exceptionBacklog = new ExceptionBacklog();
            SystemAttributes systemAttributes = new SystemAttributes();
            InstanceStatus instanceStatus = omrsClassification.getStatus();
            Status omrsBeanStatus = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
            systemAttributes.setStatus(omrsBeanStatus);
            systemAttributes.setCreatedBy(omrsClassification.getCreatedBy());
            systemAttributes.setUpdatedBy(omrsClassification.getUpdatedBy());
            systemAttributes.setCreateTime(omrsClassification.getCreateTime());
            systemAttributes.setUpdateTime(omrsClassification.getUpdateTime());
            systemAttributes.setVersion(Long.valueOf(omrsClassification.getVersion()));
            exceptionBacklog.setSystemAttributes(systemAttributes);
            InstanceProperties omrsClassificationProperties = omrsClassification.getProperties();
            if (omrsClassificationProperties != null) {
                omrsClassificationProperties.setEffectiveFromTime(exceptionBacklog.getEffectiveFromTime());
                omrsClassificationProperties.setEffectiveToTime(exceptionBacklog.getEffectiveToTime());
                Iterator omrsPropertyIterator = omrsClassificationProperties.getPropertyNames();
                while (omrsPropertyIterator.hasNext()) {
                    String name = (String)omrsPropertyIterator.next();
                    InstancePropertyValue value = omrsClassificationProperties.getPropertyValue(name);
                    switch (value.getInstancePropertyCategory()) {
                        case PRIMITIVE: {
                            PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                            Object actualValue = primitivePropertyValue.getPrimitiveValue();
                            if (ExceptionBacklog.ATTRIBUTE_NAMES_SET.contains(name)) {
                                if (name.equals("notes")) {
                                    exceptionBacklog.setNotes((String)actualValue);
                                }
                                if (name.equals("steward")) {
                                    exceptionBacklog.setSteward((String)actualValue);
                                }
                                if (name.equals("process")) {
                                    exceptionBacklog.setProcess((String)actualValue);
                                }
                                if (!name.equals("source")) break;
                                exceptionBacklog.setSource((String)actualValue);
                                break;
                            }
                            if (null == exceptionBacklog.getExtraAttributes()) {
                                exceptionBacklog.setExtraAttributes(new HashMap());
                            }
                            exceptionBacklog.getExtraAttributes().put(name, primitivePropertyValue);
                            break;
                        }
                        case ENUM: {
                            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                            String symbolicName = enumPropertyValue.getSymbolicName();
                            if (ExceptionBacklog.ENUM_NAMES_SET.contains(name)) break;
                            if (null == exceptionBacklog.getExtraAttributes()) {
                                exceptionBacklog.setExtraAttributes(new HashMap());
                            }
                            exceptionBacklog.getExtraAttributes().put(name, enumPropertyValue);
                            break;
                        }
                        case MAP: {
                            if (!ExceptionBacklog.MAP_NAMES_SET.contains(name)) break;
                            MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                            InstanceProperties instanceProperties = mapPropertyValue.getMapValues();
                            break;
                        }
                    }
                }
            }
            return exceptionBacklog;
        }
        return null;
    }

    public static Classification mapBeanToOmrs(ExceptionBacklog exceptionBacklog) {
        PrimitivePropertyValue primitivePropertyValue;
        Classification omrsClassification = new Classification();
        SystemAttributes systemAttributes = exceptionBacklog.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsClassification.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsClassification.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsClassification.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsClassification.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsClassification.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToInstanceStatus(systemAttributes.getStatus());
                omrsClassification.setStatus(instanceStatus);
            }
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        if (exceptionBacklog.getNotes() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)exceptionBacklog.getNotes());
            instanceProperties.setProperty("notes", (InstancePropertyValue)primitivePropertyValue);
        }
        if (exceptionBacklog.getSteward() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)exceptionBacklog.getSteward());
            instanceProperties.setProperty("steward", (InstancePropertyValue)primitivePropertyValue);
        }
        if (exceptionBacklog.getProcess() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)exceptionBacklog.getProcess());
            instanceProperties.setProperty("process", (InstancePropertyValue)primitivePropertyValue);
        }
        if (exceptionBacklog.getSource() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)exceptionBacklog.getSource());
            instanceProperties.setProperty("source", (InstancePropertyValue)primitivePropertyValue);
        }
        omrsClassification.setProperties(instanceProperties);
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef typeDef = archiveAccessor.getEntityDefByName("ExceptionBacklog");
        InstanceType template = SubjectAreaUtils.createTemplateFromTypeDef((TypeDef)typeDef);
        InstanceType instanceType = new InstanceType(template);
        omrsClassification.setType(instanceType);
        return omrsClassification;
    }
}

