/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Retention;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Retention;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.GovernanceClassificationStatus;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.RetentionBasis;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.archivemanager.OMRSArchiveAccessor;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetentionMapper {
    private static final Logger log = LoggerFactory.getLogger(RetentionMapper.class);
    private static final String className = RetentionMapper.class.getName();

    public static Retention mapOmrsToOmas(Classification omrsClassification) throws InvalidParameterException {
        String classificationTypeName = omrsClassification.getName();
        if ("Retention".equals(classificationTypeName)) {
            Retention retention = new Retention();
            SystemAttributes systemAttributes = new SystemAttributes();
            InstanceStatus instanceStatus = omrsClassification.getStatus();
            Status omrsBeanStatus = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
            systemAttributes.setStatus(omrsBeanStatus);
            systemAttributes.setCreatedBy(omrsClassification.getCreatedBy());
            systemAttributes.setUpdatedBy(omrsClassification.getUpdatedBy());
            systemAttributes.setCreateTime(omrsClassification.getCreateTime());
            systemAttributes.setUpdateTime(omrsClassification.getUpdateTime());
            systemAttributes.setVersion(Long.valueOf(omrsClassification.getVersion()));
            retention.setSystemAttributes(systemAttributes);
            InstanceProperties omrsClassificationProperties = omrsClassification.getProperties();
            if (omrsClassificationProperties != null) {
                omrsClassificationProperties.setEffectiveFromTime(retention.getEffectiveFromTime());
                omrsClassificationProperties.setEffectiveToTime(retention.getEffectiveToTime());
                Iterator omrsPropertyIterator = omrsClassificationProperties.getPropertyNames();
                while (omrsPropertyIterator.hasNext()) {
                    String name = (String)omrsPropertyIterator.next();
                    InstancePropertyValue value = omrsClassificationProperties.getPropertyValue(name);
                    switch (value.getInstancePropertyCategory()) {
                        case PRIMITIVE: {
                            PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                            Object actualValue = primitivePropertyValue.getPrimitiveValue();
                            if (Retention.ATTRIBUTE_NAMES_SET.contains(name)) {
                                if (name.equals("confidence")) {
                                    retention.setConfidence((Integer)actualValue);
                                }
                                if (name.equals("steward")) {
                                    retention.setSteward((String)actualValue);
                                }
                                if (name.equals("source")) {
                                    retention.setSource((String)actualValue);
                                }
                                if (name.equals("notes")) {
                                    retention.setNotes((String)actualValue);
                                }
                                if (name.equals("associatedGUID")) {
                                    retention.setAssociatedGUID((String)actualValue);
                                }
                                if (name.equals("archiveAfter")) {
                                    retention.setArchiveAfter((Date)actualValue);
                                }
                                if (!name.equals("deleteAfter")) break;
                                retention.setDeleteAfter((Date)actualValue);
                                break;
                            }
                            if (null == retention.getExtraAttributes()) {
                                retention.setExtraAttributes(new HashMap());
                            }
                            retention.getExtraAttributes().put(name, primitivePropertyValue);
                            break;
                        }
                        case ENUM: {
                            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                            String symbolicName = enumPropertyValue.getSymbolicName();
                            if (Retention.ENUM_NAMES_SET.contains(name)) {
                                if (name.equals("status")) {
                                    GovernanceClassificationStatus status = GovernanceClassificationStatus.valueOf((String)symbolicName);
                                    retention.setStatus(status);
                                }
                                if (!name.equals("basis")) break;
                                RetentionBasis basis = RetentionBasis.valueOf((String)symbolicName);
                                retention.setBasis(basis);
                                break;
                            }
                            if (null == retention.getExtraAttributes()) {
                                retention.setExtraAttributes(new HashMap());
                            }
                            retention.getExtraAttributes().put(name, enumPropertyValue);
                            break;
                        }
                        case MAP: {
                            if (!Retention.MAP_NAMES_SET.contains(name)) break;
                            MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                            InstanceProperties instanceProperties = mapPropertyValue.getMapValues();
                            break;
                        }
                    }
                }
            }
            return retention;
        }
        return null;
    }

    public static Classification mapBeanToOmrs(Retention retention) {
        EnumPropertyValue enumPropertyValue;
        GovernanceClassificationStatus enumType;
        PrimitivePropertyValue primitivePropertyValue;
        Classification omrsClassification = new Classification();
        SystemAttributes systemAttributes = retention.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsClassification.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsClassification.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsClassification.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsClassification.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsClassification.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToInstanceStatus(systemAttributes.getStatus());
                omrsClassification.setStatus(instanceStatus);
            }
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        if (retention.getConfidence() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
            primitivePropertyValue.setPrimitiveValue((Object)retention.getConfidence());
            instanceProperties.setProperty("confidence", (InstancePropertyValue)primitivePropertyValue);
        }
        if (retention.getSteward() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)retention.getSteward());
            instanceProperties.setProperty("steward", (InstancePropertyValue)primitivePropertyValue);
        }
        if (retention.getSource() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)retention.getSource());
            instanceProperties.setProperty("source", (InstancePropertyValue)primitivePropertyValue);
        }
        if (retention.getNotes() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)retention.getNotes());
            instanceProperties.setProperty("notes", (InstancePropertyValue)primitivePropertyValue);
        }
        if (retention.getAssociatedGUID() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)retention.getAssociatedGUID());
            instanceProperties.setProperty("associatedGUID", (InstancePropertyValue)primitivePropertyValue);
        }
        if (retention.getArchiveAfter() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
            primitivePropertyValue.setPrimitiveValue((Object)retention.getArchiveAfter());
            instanceProperties.setProperty("archiveAfter", (InstancePropertyValue)primitivePropertyValue);
        }
        if (retention.getDeleteAfter() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
            primitivePropertyValue.setPrimitiveValue((Object)retention.getDeleteAfter());
            instanceProperties.setProperty("deleteAfter", (InstancePropertyValue)primitivePropertyValue);
        }
        if (retention.getStatus() != null) {
            enumType = retention.getStatus();
            enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(enumType.ordinal());
            enumPropertyValue.setSymbolicName(enumType.name());
            instanceProperties.setProperty("status", (InstancePropertyValue)enumPropertyValue);
        }
        if (retention.getBasis() != null) {
            enumType = retention.getBasis();
            enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(enumType.ordinal());
            enumPropertyValue.setSymbolicName(enumType.name());
            instanceProperties.setProperty("basis", (InstancePropertyValue)enumPropertyValue);
        }
        omrsClassification.setProperties(instanceProperties);
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef typeDef = archiveAccessor.getEntityDefByName("Retention");
        InstanceType template = SubjectAreaUtils.createTemplateFromTypeDef((TypeDef)typeDef);
        InstanceType instanceType = new InstanceType(template);
        omrsClassification.setType(instanceType);
        return omrsClassification;
    }
}

