/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.entities.CohortMember;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.CohortMember.CohortMember;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.server.properties.classifications.ClassificationFactory;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.archivemanager.OMRSArchiveAccessor;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CohortMemberMapper {
    private static final Logger log = LoggerFactory.getLogger(CohortMemberMapper.class);
    private static final String className = CohortMemberMapper.class.getName();

    public static CohortMember mapOmrsEntityDetailToCohortMember(EntityDetail omrsEntityDetail) throws InvalidParameterException {
        String entityTypeName = omrsEntityDetail.getType().getTypeDefName();
        if ("CohortMember".equals(entityTypeName)) {
            List omrsclassifications;
            CohortMember cohortMember = new CohortMember();
            SystemAttributes systemAttributes = new SystemAttributes();
            InstanceStatus instanceStatus = omrsEntityDetail.getStatus();
            Status omas_status = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
            systemAttributes.setStatus(omas_status);
            systemAttributes.setCreatedBy(omrsEntityDetail.getCreatedBy());
            systemAttributes.setUpdatedBy(omrsEntityDetail.getUpdatedBy());
            systemAttributes.setCreateTime(omrsEntityDetail.getCreateTime());
            systemAttributes.setUpdateTime(omrsEntityDetail.getUpdateTime());
            systemAttributes.setVersion(Long.valueOf(omrsEntityDetail.getVersion()));
            systemAttributes.setGUID(omrsEntityDetail.getGUID());
            cohortMember.setSystemAttributes(systemAttributes);
            InstanceProperties omrsEntityDetailProperties = omrsEntityDetail.getProperties();
            if (omrsEntityDetailProperties != null) {
                omrsEntityDetailProperties.setEffectiveFromTime(cohortMember.getEffectiveFromTime());
                omrsEntityDetailProperties.setEffectiveToTime(cohortMember.getEffectiveToTime());
                Iterator omrsPropertyIterator = omrsEntityDetailProperties.getPropertyNames();
                block5: while (omrsPropertyIterator.hasNext()) {
                    String name = (String)omrsPropertyIterator.next();
                    InstancePropertyValue value = omrsEntityDetailProperties.getPropertyValue(name);
                    switch (value.getInstancePropertyCategory()) {
                        case PRIMITIVE: {
                            PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                            Object actualValue = primitivePropertyValue.getPrimitiveValue();
                            if (CohortMember.ATTRIBUTE_NAMES_SET.contains(name)) {
                                if (name.equals("version")) {
                                    cohortMember.setVersion((String)actualValue);
                                }
                                if (name.equals("name")) {
                                    cohortMember.setName((String)actualValue);
                                }
                                if (name.equals("description")) {
                                    cohortMember.setDescription((String)actualValue);
                                }
                                if (name.equals("type")) {
                                    cohortMember.setType((String)actualValue);
                                }
                                if (name.equals("patchLevel")) {
                                    cohortMember.setPatchLevel((String)actualValue);
                                }
                                if (name.equals("source")) {
                                    cohortMember.setSource((String)actualValue);
                                }
                                if (!name.equals("qualifiedName")) break;
                                cohortMember.setQualifiedName((String)actualValue);
                                break;
                            }
                            if (null == cohortMember.getExtraAttributes()) {
                                cohortMember.setExtraAttributes(new HashMap<String, Object>());
                            }
                            cohortMember.getExtraAttributes().put(name, primitivePropertyValue);
                            break;
                        }
                        case ENUM: {
                            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                            String symbolicName = enumPropertyValue.getSymbolicName();
                            if (CohortMember.ENUM_NAMES_SET.contains(name)) break;
                            if (null == cohortMember.getExtraAttributes()) {
                                cohortMember.setExtraAttributes(new HashMap<String, Object>());
                            }
                            cohortMember.getExtraAttributes().put(name, enumPropertyValue);
                            break;
                        }
                        case MAP: {
                            if (!CohortMember.MAP_NAMES_SET.contains(name)) break;
                            MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                            InstanceProperties instancePropertyForMap = mapPropertyValue.getMapValues();
                            if (!name.equals("additionalProperties")) continue block5;
                            HashMap<String, String> actualMap = new HashMap<String, String>();
                            Iterator iter = instancePropertyForMap.getPropertyNames();
                            while (iter.hasNext()) {
                                String mapkey = (String)iter.next();
                                PrimitivePropertyValue primitivePropertyMapValue = (PrimitivePropertyValue)instancePropertyForMap.getPropertyValue(mapkey);
                                String mapvalue = (String)primitivePropertyMapValue.getPrimitiveValue();
                                actualMap.put(mapkey, mapvalue);
                            }
                            cohortMember.setAdditionalProperties(actualMap);
                            break;
                        }
                    }
                }
            }
            if ((omrsclassifications = omrsEntityDetail.getClassifications()) != null && !omrsclassifications.isEmpty()) {
                for (Classification omrsClassification : omrsclassifications) {
                    String omrsClassificationName = omrsClassification.getName();
                    org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification omasClassification = ClassificationFactory.getClassification(omrsClassificationName, omrsClassification);
                    if (omasClassification != null) {
                        if (cohortMember.classifications == null) {
                            cohortMember.classifications = new ArrayList<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification>();
                        }
                        cohortMember.classifications.add(omasClassification);
                        continue;
                    }
                    if (null == cohortMember.getExtraClassifications()) {
                        cohortMember.setExtraClassifications(new HashMap<String, Classification>());
                    }
                    cohortMember.getExtraClassifications().put(omrsClassificationName, omrsClassification);
                }
            }
            return cohortMember;
        }
        return null;
    }

    public static EntityDetail mapCohortMemberToOmrsEntityDetail(CohortMember cohortMember) {
        PrimitivePropertyValue primitivePropertyValue;
        EntityDetail omrsEntityDetail = new EntityDetail();
        SystemAttributes systemAttributes = cohortMember.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsEntityDetail.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsEntityDetail.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsEntityDetail.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsEntityDetail.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsEntityDetail.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getGUID() != null) {
                omrsEntityDetail.setGUID(systemAttributes.getGUID());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToInstanceStatus(systemAttributes.getStatus());
                omrsEntityDetail.setStatus(instanceStatus);
            }
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        instanceProperties.setEffectiveFromTime(cohortMember.getEffectiveFromTime());
        instanceProperties.setEffectiveToTime(cohortMember.getEffectiveToTime());
        if (cohortMember.getVersion() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)cohortMember.getVersion());
            instanceProperties.setProperty("version", (InstancePropertyValue)primitivePropertyValue);
        }
        if (cohortMember.getName() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)cohortMember.getName());
            instanceProperties.setProperty("name", (InstancePropertyValue)primitivePropertyValue);
        }
        if (cohortMember.getDescription() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)cohortMember.getDescription());
            instanceProperties.setProperty("description", (InstancePropertyValue)primitivePropertyValue);
        }
        if (cohortMember.getType() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)cohortMember.getType());
            instanceProperties.setProperty("type", (InstancePropertyValue)primitivePropertyValue);
        }
        if (cohortMember.getPatchLevel() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)cohortMember.getPatchLevel());
            instanceProperties.setProperty("patchLevel", (InstancePropertyValue)primitivePropertyValue);
        }
        if (cohortMember.getSource() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)cohortMember.getSource());
            instanceProperties.setProperty("source", (InstancePropertyValue)primitivePropertyValue);
        }
        if (cohortMember.getQualifiedName() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)cohortMember.getQualifiedName());
            instanceProperties.setProperty("qualifiedName", (InstancePropertyValue)primitivePropertyValue);
        }
        if (cohortMember.getAdditionalProperties() != null) {
            Map<String, String> map = cohortMember.getAdditionalProperties();
            MapPropertyValue mapPropertyValue = new MapPropertyValue();
            for (String key : map.keySet()) {
                PrimitivePropertyValue primitivePropertyValue2 = new PrimitivePropertyValue();
                primitivePropertyValue2.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue2.setPrimitiveValue((Object)map.get(key));
                mapPropertyValue.setMapValue(key, (InstancePropertyValue)primitivePropertyValue2);
            }
            instanceProperties.setProperty("additionalProperties", (InstancePropertyValue)mapPropertyValue);
        }
        omrsEntityDetail.setProperties(instanceProperties);
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef typeDef = archiveAccessor.getEntityDefByName("CohortMember");
        InstanceType template = SubjectAreaUtils.createTemplateFromTypeDef((TypeDef)typeDef);
        InstanceType instanceType = new InstanceType(template);
        omrsEntityDetail.setType(instanceType);
        CohortMemberMapper.populateOmrsEntityWithBeanClassifications(omrsEntityDetail, cohortMember.getClassifications());
        return omrsEntityDetail;
    }

    private static void populateOmrsEntityWithBeanClassifications(EntityDetail omrsEntityDetail, List<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification> beanClassifications) {
        if (beanClassifications != null && beanClassifications.size() > 0) {
            ArrayList<Classification> omrsClassifications = new ArrayList<Classification>();
            for (org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification beanClassification : beanClassifications) {
                SystemAttributes systemAttributes = beanClassification.getSystemAttributes();
                Classification omrsClassification = new Classification();
                if (systemAttributes != null) {
                    if (systemAttributes.getCreatedBy() != null) {
                        omrsClassification.setCreatedBy(systemAttributes.getCreatedBy());
                    }
                    if (systemAttributes.getUpdatedBy() != null) {
                        omrsClassification.setUpdatedBy(systemAttributes.getUpdatedBy());
                    }
                    if (systemAttributes.getCreateTime() != null) {
                        omrsClassification.setCreateTime(systemAttributes.getCreateTime());
                    }
                    if (systemAttributes.getUpdateTime() != null) {
                        omrsClassification.setUpdateTime(systemAttributes.getUpdateTime());
                    }
                    if (systemAttributes.getVersion() != null) {
                        omrsClassification.setVersion(systemAttributes.getVersion().longValue());
                    }
                }
                omrsClassification.setName(beanClassification.getClassificationName());
                omrsClassification.setProperties(beanClassification.obtainInstanceProperties());
                omrsClassifications.add(omrsClassification);
            }
            omrsEntityDetail.setClassifications(omrsClassifications);
        }
    }
}

