/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceResponsibility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceResponsibility.GovernanceResponsibility;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.GovernanceDomain;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.server.properties.classifications.ClassificationFactory;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.archivemanager.OMRSArchiveAccessor;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceResponsibilityMapper {
    private static final Logger log = LoggerFactory.getLogger(GovernanceResponsibilityMapper.class);
    private static final String className = GovernanceResponsibilityMapper.class.getName();

    public static GovernanceResponsibility mapOmrsEntityDetailToGovernanceResponsibility(EntityDetail omrsEntityDetail) throws InvalidParameterException {
        String entityTypeName = omrsEntityDetail.getType().getTypeDefName();
        if ("GovernanceResponsibility".equals(entityTypeName)) {
            List omrsclassifications;
            GovernanceResponsibility governanceResponsibility = new GovernanceResponsibility();
            SystemAttributes systemAttributes = new SystemAttributes();
            InstanceStatus instanceStatus = omrsEntityDetail.getStatus();
            Status omas_status = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
            systemAttributes.setStatus(omas_status);
            systemAttributes.setCreatedBy(omrsEntityDetail.getCreatedBy());
            systemAttributes.setUpdatedBy(omrsEntityDetail.getUpdatedBy());
            systemAttributes.setCreateTime(omrsEntityDetail.getCreateTime());
            systemAttributes.setUpdateTime(omrsEntityDetail.getUpdateTime());
            systemAttributes.setVersion(Long.valueOf(omrsEntityDetail.getVersion()));
            systemAttributes.setGUID(omrsEntityDetail.getGUID());
            governanceResponsibility.setSystemAttributes(systemAttributes);
            InstanceProperties omrsEntityDetailProperties = omrsEntityDetail.getProperties();
            if (omrsEntityDetailProperties != null) {
                omrsEntityDetailProperties.setEffectiveFromTime(governanceResponsibility.getEffectiveFromTime());
                omrsEntityDetailProperties.setEffectiveToTime(governanceResponsibility.getEffectiveToTime());
                Iterator omrsPropertyIterator = omrsEntityDetailProperties.getPropertyNames();
                block5: while (omrsPropertyIterator.hasNext()) {
                    String name = (String)omrsPropertyIterator.next();
                    InstancePropertyValue value = omrsEntityDetailProperties.getPropertyValue(name);
                    switch (value.getInstancePropertyCategory()) {
                        case PRIMITIVE: {
                            PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                            Object actualValue = primitivePropertyValue.getPrimitiveValue();
                            if (GovernanceResponsibility.ATTRIBUTE_NAMES_SET.contains(name)) {
                                if (name.equals("implementationDescription")) {
                                    governanceResponsibility.setImplementationDescription((String)actualValue);
                                }
                                if (name.equals("title")) {
                                    governanceResponsibility.setTitle((String)actualValue);
                                }
                                if (name.equals("summary")) {
                                    governanceResponsibility.setSummary((String)actualValue);
                                }
                                if (name.equals("description")) {
                                    governanceResponsibility.setDescription((String)actualValue);
                                }
                                if (name.equals("scope")) {
                                    governanceResponsibility.setScope((String)actualValue);
                                }
                                if (name.equals("priority")) {
                                    governanceResponsibility.setPriority((String)actualValue);
                                }
                                if (!name.equals("qualifiedName")) break;
                                governanceResponsibility.setQualifiedName((String)actualValue);
                                break;
                            }
                            if (null == governanceResponsibility.getExtraAttributes()) {
                                governanceResponsibility.setExtraAttributes(new HashMap<String, Object>());
                            }
                            governanceResponsibility.getExtraAttributes().put(name, primitivePropertyValue);
                            break;
                        }
                        case ENUM: {
                            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                            String symbolicName = enumPropertyValue.getSymbolicName();
                            if (GovernanceResponsibility.ENUM_NAMES_SET.contains(name)) {
                                if (!name.equals("domain")) break;
                                GovernanceDomain domain = GovernanceDomain.valueOf((String)symbolicName);
                                governanceResponsibility.setDomain(domain);
                                break;
                            }
                            if (null == governanceResponsibility.getExtraAttributes()) {
                                governanceResponsibility.setExtraAttributes(new HashMap<String, Object>());
                            }
                            governanceResponsibility.getExtraAttributes().put(name, enumPropertyValue);
                            break;
                        }
                        case MAP: {
                            if (!GovernanceResponsibility.MAP_NAMES_SET.contains(name)) break;
                            MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                            InstanceProperties instancePropertyForMap = mapPropertyValue.getMapValues();
                            if (!name.equals("additionalProperties")) continue block5;
                            HashMap<String, String> actualMap = new HashMap<String, String>();
                            Iterator iter = instancePropertyForMap.getPropertyNames();
                            while (iter.hasNext()) {
                                String mapkey = (String)iter.next();
                                PrimitivePropertyValue primitivePropertyMapValue = (PrimitivePropertyValue)instancePropertyForMap.getPropertyValue(mapkey);
                                String mapvalue = (String)primitivePropertyMapValue.getPrimitiveValue();
                                actualMap.put(mapkey, mapvalue);
                            }
                            governanceResponsibility.setAdditionalProperties(actualMap);
                            break;
                        }
                    }
                }
            }
            if ((omrsclassifications = omrsEntityDetail.getClassifications()) != null && !omrsclassifications.isEmpty()) {
                for (Classification omrsClassification : omrsclassifications) {
                    String omrsClassificationName = omrsClassification.getName();
                    org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification omasClassification = ClassificationFactory.getClassification(omrsClassificationName, omrsClassification);
                    if (omasClassification != null) {
                        if (governanceResponsibility.classifications == null) {
                            governanceResponsibility.classifications = new ArrayList<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification>();
                        }
                        governanceResponsibility.classifications.add(omasClassification);
                        continue;
                    }
                    if (null == governanceResponsibility.getExtraClassifications()) {
                        governanceResponsibility.setExtraClassifications(new HashMap<String, Classification>());
                    }
                    governanceResponsibility.getExtraClassifications().put(omrsClassificationName, omrsClassification);
                }
            }
            return governanceResponsibility;
        }
        return null;
    }

    public static EntityDetail mapGovernanceResponsibilityToOmrsEntityDetail(GovernanceResponsibility governanceResponsibility) {
        PrimitivePropertyValue primitivePropertyValue;
        EntityDetail omrsEntityDetail = new EntityDetail();
        SystemAttributes systemAttributes = governanceResponsibility.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsEntityDetail.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsEntityDetail.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsEntityDetail.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsEntityDetail.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsEntityDetail.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getGUID() != null) {
                omrsEntityDetail.setGUID(systemAttributes.getGUID());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToInstanceStatus(systemAttributes.getStatus());
                omrsEntityDetail.setStatus(instanceStatus);
            }
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        instanceProperties.setEffectiveFromTime(governanceResponsibility.getEffectiveFromTime());
        instanceProperties.setEffectiveToTime(governanceResponsibility.getEffectiveToTime());
        if (governanceResponsibility.getImplementationDescription() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)governanceResponsibility.getImplementationDescription());
            instanceProperties.setProperty("implementationDescription", (InstancePropertyValue)primitivePropertyValue);
        }
        if (governanceResponsibility.getTitle() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)governanceResponsibility.getTitle());
            instanceProperties.setProperty("title", (InstancePropertyValue)primitivePropertyValue);
        }
        if (governanceResponsibility.getSummary() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)governanceResponsibility.getSummary());
            instanceProperties.setProperty("summary", (InstancePropertyValue)primitivePropertyValue);
        }
        if (governanceResponsibility.getDescription() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)governanceResponsibility.getDescription());
            instanceProperties.setProperty("description", (InstancePropertyValue)primitivePropertyValue);
        }
        if (governanceResponsibility.getScope() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)governanceResponsibility.getScope());
            instanceProperties.setProperty("scope", (InstancePropertyValue)primitivePropertyValue);
        }
        if (governanceResponsibility.getPriority() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)governanceResponsibility.getPriority());
            instanceProperties.setProperty("priority", (InstancePropertyValue)primitivePropertyValue);
        }
        if (governanceResponsibility.getQualifiedName() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)governanceResponsibility.getQualifiedName());
            instanceProperties.setProperty("qualifiedName", (InstancePropertyValue)primitivePropertyValue);
        }
        if (governanceResponsibility.getDomain() != null) {
            GovernanceDomain enumType = governanceResponsibility.getDomain();
            EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(enumType.ordinal());
            enumPropertyValue.setSymbolicName(enumType.name());
            instanceProperties.setProperty("domain", (InstancePropertyValue)enumPropertyValue);
        }
        if (governanceResponsibility.getAdditionalProperties() != null) {
            Map<String, String> map = governanceResponsibility.getAdditionalProperties();
            MapPropertyValue mapPropertyValue = new MapPropertyValue();
            for (String key : map.keySet()) {
                PrimitivePropertyValue primitivePropertyValue2 = new PrimitivePropertyValue();
                primitivePropertyValue2.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue2.setPrimitiveValue((Object)map.get(key));
                mapPropertyValue.setMapValue(key, (InstancePropertyValue)primitivePropertyValue2);
            }
            instanceProperties.setProperty("additionalProperties", (InstancePropertyValue)mapPropertyValue);
        }
        omrsEntityDetail.setProperties(instanceProperties);
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef typeDef = archiveAccessor.getEntityDefByName("GovernanceResponsibility");
        InstanceType template = SubjectAreaUtils.createTemplateFromTypeDef((TypeDef)typeDef);
        InstanceType instanceType = new InstanceType(template);
        omrsEntityDetail.setType(instanceType);
        GovernanceResponsibilityMapper.populateOmrsEntityWithBeanClassifications(omrsEntityDetail, governanceResponsibility.getClassifications());
        return omrsEntityDetail;
    }

    private static void populateOmrsEntityWithBeanClassifications(EntityDetail omrsEntityDetail, List<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification> beanClassifications) {
        if (beanClassifications != null && beanClassifications.size() > 0) {
            ArrayList<Classification> omrsClassifications = new ArrayList<Classification>();
            for (org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification beanClassification : beanClassifications) {
                SystemAttributes systemAttributes = beanClassification.getSystemAttributes();
                Classification omrsClassification = new Classification();
                if (systemAttributes != null) {
                    if (systemAttributes.getCreatedBy() != null) {
                        omrsClassification.setCreatedBy(systemAttributes.getCreatedBy());
                    }
                    if (systemAttributes.getUpdatedBy() != null) {
                        omrsClassification.setUpdatedBy(systemAttributes.getUpdatedBy());
                    }
                    if (systemAttributes.getCreateTime() != null) {
                        omrsClassification.setCreateTime(systemAttributes.getCreateTime());
                    }
                    if (systemAttributes.getUpdateTime() != null) {
                        omrsClassification.setUpdateTime(systemAttributes.getUpdateTime());
                    }
                    if (systemAttributes.getVersion() != null) {
                        omrsClassification.setVersion(systemAttributes.getVersion().longValue());
                    }
                }
                omrsClassification.setName(beanClassification.getClassificationName());
                omrsClassification.setProperties(beanClassification.obtainInstanceProperties());
                omrsClassifications.add(omrsClassification);
            }
            omrsEntityDetail.setClassifications(omrsClassifications);
        }
    }
}

