/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GraphEdge;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.GraphEdgeToGraphVertex.VerticesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToCertificationType.CertificationsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToComment.CommentsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalId.AlsoKnownAsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalId.ManagedResourcesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalReference.ExternalReferenceReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToGlossaryTerm.MeaningReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToInformalTag.TagsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToLicenseType.LicensesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToLike.LikesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToNoteLog.NoteLogsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToProject.ImpactingProjectsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToPropertyFacet.FacetsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRating.StarRatingsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRelatedMedia.RelatedMediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToToDo.ActionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.SchemaAttributeToComplexSchemaType.ParentSchemasReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.SchemaAttributeToDerivedSchemaAttribute.UsedByReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.SchemaAttributeToSchemaLinkElement.ExternalTypeReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.SchemaAttributeToSchemaType.TypeReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedComment.AttachedComment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedLike.AttachedLike;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedNoteLog.AttachedNoteLog;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedRating.AttachedRating;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedTag.AttachedTag;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttributeForSchema.AttributeForSchema;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Certification.Certification;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdLink.ExternalIdLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdScope.ExternalIdScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalReferenceLink.ExternalReferenceLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GraphEdgeLink.GraphEdgeLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.License.License;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MediaReference.MediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectScope.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReferenceableFacet.ReferenceableFacet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaAttributeType.SchemaAttributeType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaLinkToType.SchemaLinkToType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaQueryImplementation.SchemaQueryImplementation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SemanticAssignment.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoSource.ToDoSource;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GraphEdgeReferences
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(GraphEdgeReferences.class);
    private static final String className = GraphEdgeReferences.class.getName();
    public static final String[] REFERENCE_NAMES_SET_VALUES = new String[]{"vertices", "comments", "tags", "meaning", "impactingProjects", "facets", "licenses", "parentSchemas", "alsoKnownAs", "likes", "noteLogs", "certifications", "usedBy", "type", "managedResources", "relatedMedia", "externalType", "starRatings", "externalReference", "actions", null};
    public static final String[] RELATIONSHIP_NAMES_SET_VALUES = new String[]{"GraphEdgeLink", "AttachedComment", "AttachedTag", "SemanticAssignment", "ProjectScope", "ReferenceableFacet", "License", "AttributeForSchema", "ExternalIdLink", "AttachedLike", "AttachedNoteLog", "Certification", "SchemaQueryImplementation", "SchemaAttributeType", "ExternalIdScope", "MediaReference", "SchemaLinkToType", "AttachedRating", "ExternalReferenceLink", "ToDoSource", null};
    public static final Set<String> REFERENCE_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(REFERENCE_NAMES_SET_VALUES)));
    public static final Set<String> RELATIONSHIP_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(RELATIONSHIP_NAMES_SET_VALUES)));
    private TypeReference type;
    private ExternalTypeReference externalType;
    private Set<VerticesReference> vertices;
    private Set<CommentsReference> comments;
    private Set<TagsReference> tags;
    private Set<MeaningReference> meaning;
    private Set<ImpactingProjectsReference> impactingProjects;
    private Set<FacetsReference> facets;
    private Set<LicensesReference> licenses;
    private Set<ParentSchemasReference> parentSchemas;
    private Set<AlsoKnownAsReference> alsoKnownAs;
    private Set<LikesReference> likes;
    private Set<NoteLogsReference> noteLogs;
    private Set<CertificationsReference> certifications;
    private Set<UsedByReference> usedBy;
    private Set<ManagedResourcesReference> managedResources;
    private Set<RelatedMediaReference> relatedMedia;
    private Set<StarRatingsReference> starRatings;
    private Set<ExternalReferenceReference> externalReference;
    private Set<ActionsReference> actions;

    public GraphEdgeReferences(String entityGuid, Set<Line> lines) throws InvalidParameterException {
        if (lines != null) {
            for (Line relationship : lines) {
                for (int i = 0; i < RELATIONSHIP_NAMES_SET_VALUES.length; ++i) {
                    if (!relationship.getName().equals(RELATIONSHIP_NAMES_SET_VALUES[i])) continue;
                    String referenceName = REFERENCE_NAMES_SET_VALUES[i];
                    if ("vertices".equals(referenceName)) {
                        GraphEdgeLink graphEdgeLink_relationship = (GraphEdgeLink)relationship;
                        VerticesReference verticesReference = new VerticesReference(entityGuid, graphEdgeLink_relationship);
                        if (this.vertices == null) {
                            this.vertices = new HashSet<VerticesReference>();
                        }
                        this.vertices.add(verticesReference);
                    }
                    if ("comments".equals(referenceName)) {
                        AttachedComment attachedComment_relationship = (AttachedComment)relationship;
                        CommentsReference commentsReference = new CommentsReference(entityGuid, attachedComment_relationship);
                        if (this.comments == null) {
                            this.comments = new HashSet<CommentsReference>();
                        }
                        this.comments.add(commentsReference);
                    }
                    if ("tags".equals(referenceName)) {
                        AttachedTag attachedTag_relationship = (AttachedTag)relationship;
                        TagsReference tagsReference = new TagsReference(entityGuid, attachedTag_relationship);
                        if (this.tags == null) {
                            this.tags = new HashSet<TagsReference>();
                        }
                        this.tags.add(tagsReference);
                    }
                    if ("meaning".equals(referenceName)) {
                        SemanticAssignment semanticAssignment_relationship = (SemanticAssignment)relationship;
                        MeaningReference meaningReference = new MeaningReference(entityGuid, semanticAssignment_relationship);
                        if (this.meaning == null) {
                            this.meaning = new HashSet<MeaningReference>();
                        }
                        this.meaning.add(meaningReference);
                    }
                    if ("impactingProjects".equals(referenceName)) {
                        ProjectScope projectScope_relationship = (ProjectScope)relationship;
                        ImpactingProjectsReference impactingProjectsReference = new ImpactingProjectsReference(entityGuid, projectScope_relationship);
                        if (this.impactingProjects == null) {
                            this.impactingProjects = new HashSet<ImpactingProjectsReference>();
                        }
                        this.impactingProjects.add(impactingProjectsReference);
                    }
                    if ("facets".equals(referenceName)) {
                        ReferenceableFacet referenceableFacet_relationship = (ReferenceableFacet)relationship;
                        FacetsReference facetsReference = new FacetsReference(entityGuid, referenceableFacet_relationship);
                        if (this.facets == null) {
                            this.facets = new HashSet<FacetsReference>();
                        }
                        this.facets.add(facetsReference);
                    }
                    if ("licenses".equals(referenceName)) {
                        License license_relationship = (License)relationship;
                        LicensesReference licensesReference = new LicensesReference(entityGuid, license_relationship);
                        if (this.licenses == null) {
                            this.licenses = new HashSet<LicensesReference>();
                        }
                        this.licenses.add(licensesReference);
                    }
                    if ("parentSchemas".equals(referenceName)) {
                        AttributeForSchema attributeForSchema_relationship = (AttributeForSchema)relationship;
                        ParentSchemasReference parentSchemasReference = new ParentSchemasReference(entityGuid, attributeForSchema_relationship);
                        if (this.parentSchemas == null) {
                            this.parentSchemas = new HashSet<ParentSchemasReference>();
                        }
                        this.parentSchemas.add(parentSchemasReference);
                    }
                    if ("alsoKnownAs".equals(referenceName)) {
                        ExternalIdLink externalIdLink_relationship = (ExternalIdLink)relationship;
                        AlsoKnownAsReference alsoKnownAsReference = new AlsoKnownAsReference(entityGuid, externalIdLink_relationship);
                        if (this.alsoKnownAs == null) {
                            this.alsoKnownAs = new HashSet<AlsoKnownAsReference>();
                        }
                        this.alsoKnownAs.add(alsoKnownAsReference);
                    }
                    if ("likes".equals(referenceName)) {
                        AttachedLike attachedLike_relationship = (AttachedLike)relationship;
                        LikesReference likesReference = new LikesReference(entityGuid, attachedLike_relationship);
                        if (this.likes == null) {
                            this.likes = new HashSet<LikesReference>();
                        }
                        this.likes.add(likesReference);
                    }
                    if ("noteLogs".equals(referenceName)) {
                        AttachedNoteLog attachedNoteLog_relationship = (AttachedNoteLog)relationship;
                        NoteLogsReference noteLogsReference = new NoteLogsReference(entityGuid, attachedNoteLog_relationship);
                        if (this.noteLogs == null) {
                            this.noteLogs = new HashSet<NoteLogsReference>();
                        }
                        this.noteLogs.add(noteLogsReference);
                    }
                    if ("certifications".equals(referenceName)) {
                        Certification certification_relationship = (Certification)relationship;
                        CertificationsReference certificationsReference = new CertificationsReference(entityGuid, certification_relationship);
                        if (this.certifications == null) {
                            this.certifications = new HashSet<CertificationsReference>();
                        }
                        this.certifications.add(certificationsReference);
                    }
                    if ("usedBy".equals(referenceName)) {
                        SchemaQueryImplementation schemaQueryImplementation_relationship = (SchemaQueryImplementation)relationship;
                        UsedByReference usedByReference = new UsedByReference(entityGuid, schemaQueryImplementation_relationship);
                        if (this.usedBy == null) {
                            this.usedBy = new HashSet<UsedByReference>();
                        }
                        this.usedBy.add(usedByReference);
                    }
                    if ("managedResources".equals(referenceName)) {
                        ExternalIdScope externalIdScope_relationship = (ExternalIdScope)relationship;
                        ManagedResourcesReference managedResourcesReference = new ManagedResourcesReference(entityGuid, externalIdScope_relationship);
                        if (this.managedResources == null) {
                            this.managedResources = new HashSet<ManagedResourcesReference>();
                        }
                        this.managedResources.add(managedResourcesReference);
                    }
                    if ("relatedMedia".equals(referenceName)) {
                        MediaReference mediaReference_relationship = (MediaReference)relationship;
                        RelatedMediaReference relatedMediaReference = new RelatedMediaReference(entityGuid, mediaReference_relationship);
                        if (this.relatedMedia == null) {
                            this.relatedMedia = new HashSet<RelatedMediaReference>();
                        }
                        this.relatedMedia.add(relatedMediaReference);
                    }
                    if ("starRatings".equals(referenceName)) {
                        AttachedRating attachedRating_relationship = (AttachedRating)relationship;
                        StarRatingsReference starRatingsReference = new StarRatingsReference(entityGuid, attachedRating_relationship);
                        if (this.starRatings == null) {
                            this.starRatings = new HashSet<StarRatingsReference>();
                        }
                        this.starRatings.add(starRatingsReference);
                    }
                    if ("externalReference".equals(referenceName)) {
                        ExternalReferenceLink externalReferenceLink_relationship = (ExternalReferenceLink)relationship;
                        ExternalReferenceReference externalReferenceReference = new ExternalReferenceReference(entityGuid, externalReferenceLink_relationship);
                        if (this.externalReference == null) {
                            this.externalReference = new HashSet<ExternalReferenceReference>();
                        }
                        this.externalReference.add(externalReferenceReference);
                    }
                    if ("actions".equals(referenceName)) {
                        ToDoSource toDoSource_relationship = (ToDoSource)relationship;
                        ActionsReference actionsReference = new ActionsReference(entityGuid, toDoSource_relationship);
                        if (this.actions == null) {
                            this.actions = new HashSet<ActionsReference>();
                        }
                        this.actions.add(actionsReference);
                    }
                    if ("type".equals(referenceName)) {
                        SchemaAttributeType schemaAttributeType_relationship = (SchemaAttributeType)relationship;
                        this.type = new TypeReference(entityGuid, schemaAttributeType_relationship);
                    }
                    if (!"externalType".equals(referenceName)) continue;
                    SchemaLinkToType schemaLinkToType_relationship = (SchemaLinkToType)relationship;
                    this.externalType = new ExternalTypeReference(entityGuid, schemaLinkToType_relationship);
                }
            }
        }
    }

    public TypeReference getTypeReference() {
        return this.type;
    }

    public void setTypeReference(TypeReference type) {
        this.type = type;
    }

    public ExternalTypeReference getExternalTypeReference() {
        return this.externalType;
    }

    public void setExternalTypeReference(ExternalTypeReference externalType) {
        this.externalType = externalType;
    }

    public Set<VerticesReference> getVerticesReferences() {
        return this.vertices;
    }

    public void setVerticesReferences(Set<VerticesReference> vertices) {
        this.vertices = vertices;
    }

    public Set<CommentsReference> getCommentsReferences() {
        return this.comments;
    }

    public void setCommentsReferences(Set<CommentsReference> comments) {
        this.comments = comments;
    }

    public Set<TagsReference> getTagsReferences() {
        return this.tags;
    }

    public void setTagsReferences(Set<TagsReference> tags) {
        this.tags = tags;
    }

    public Set<MeaningReference> getMeaningReferences() {
        return this.meaning;
    }

    public void setMeaningReferences(Set<MeaningReference> meaning) {
        this.meaning = meaning;
    }

    public Set<ImpactingProjectsReference> getImpactingProjectsReferences() {
        return this.impactingProjects;
    }

    public void setImpactingProjectsReferences(Set<ImpactingProjectsReference> impactingProjects) {
        this.impactingProjects = impactingProjects;
    }

    public Set<FacetsReference> getFacetsReferences() {
        return this.facets;
    }

    public void setFacetsReferences(Set<FacetsReference> facets) {
        this.facets = facets;
    }

    public Set<LicensesReference> getLicensesReferences() {
        return this.licenses;
    }

    public void setLicensesReferences(Set<LicensesReference> licenses) {
        this.licenses = licenses;
    }

    public Set<ParentSchemasReference> getParentSchemasReferences() {
        return this.parentSchemas;
    }

    public void setParentSchemasReferences(Set<ParentSchemasReference> parentSchemas) {
        this.parentSchemas = parentSchemas;
    }

    public Set<AlsoKnownAsReference> getAlsoKnownAsReferences() {
        return this.alsoKnownAs;
    }

    public void setAlsoKnownAsReferences(Set<AlsoKnownAsReference> alsoKnownAs) {
        this.alsoKnownAs = alsoKnownAs;
    }

    public Set<LikesReference> getLikesReferences() {
        return this.likes;
    }

    public void setLikesReferences(Set<LikesReference> likes) {
        this.likes = likes;
    }

    public Set<NoteLogsReference> getNoteLogsReferences() {
        return this.noteLogs;
    }

    public void setNoteLogsReferences(Set<NoteLogsReference> noteLogs) {
        this.noteLogs = noteLogs;
    }

    public Set<CertificationsReference> getCertificationsReferences() {
        return this.certifications;
    }

    public void setCertificationsReferences(Set<CertificationsReference> certifications) {
        this.certifications = certifications;
    }

    public Set<UsedByReference> getUsedByReferences() {
        return this.usedBy;
    }

    public void setUsedByReferences(Set<UsedByReference> usedBy) {
        this.usedBy = usedBy;
    }

    public Set<ManagedResourcesReference> getManagedResourcesReferences() {
        return this.managedResources;
    }

    public void setManagedResourcesReferences(Set<ManagedResourcesReference> managedResources) {
        this.managedResources = managedResources;
    }

    public Set<RelatedMediaReference> getRelatedMediaReferences() {
        return this.relatedMedia;
    }

    public void setRelatedMediaReferences(Set<RelatedMediaReference> relatedMedia) {
        this.relatedMedia = relatedMedia;
    }

    public Set<StarRatingsReference> getStarRatingsReferences() {
        return this.starRatings;
    }

    public void setStarRatingsReferences(Set<StarRatingsReference> starRatings) {
        this.starRatings = starRatings;
    }

    public Set<ExternalReferenceReference> getExternalReferenceReferences() {
        return this.externalReference;
    }

    public void setExternalReferenceReferences(Set<ExternalReferenceReference> externalReference) {
        this.externalReference = externalReference;
    }

    public Set<ActionsReference> getActionsReferences() {
        return this.actions;
    }

    public void setActionsReferences(Set<ActionsReference> actions) {
        this.actions = actions;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("GraphEdgeReferences{");
        sb.append("verticesReference='").append(this.vertices.toString());
        sb.append("commentsReference='").append(this.comments.toString());
        sb.append("tagsReference='").append(this.tags.toString());
        sb.append("meaningReference='").append(this.meaning.toString());
        sb.append("impactingProjectsReference='").append(this.impactingProjects.toString());
        sb.append("facetsReference='").append(this.facets.toString());
        sb.append("licensesReference='").append(this.licenses.toString());
        sb.append("parentSchemasReference='").append(this.parentSchemas.toString());
        sb.append("alsoKnownAsReference='").append(this.alsoKnownAs.toString());
        sb.append("likesReference='").append(this.likes.toString());
        sb.append("noteLogsReference='").append(this.noteLogs.toString());
        sb.append("certificationsReference='").append(this.certifications.toString());
        sb.append("usedByReference='").append(this.usedBy.toString());
        sb.append("managedResourcesReference='").append(this.managedResources.toString());
        sb.append("relatedMediaReference='").append(this.relatedMedia.toString());
        sb.append("starRatingsReference='").append(this.starRatings.toString());
        sb.append("externalReferenceReference='").append(this.externalReference.toString());
        sb.append("actionsReference='").append(this.actions.toString());
        sb.append("typeReference='").append(this.type.toString());
        sb.append("externalTypeReference='").append(this.externalType.toString());
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GraphEdgeReferences typedThat = (GraphEdgeReferences)o;
        if (this.vertices != null && !Objects.equals(this.vertices, typedThat.vertices)) {
            return false;
        }
        if (this.comments != null && !Objects.equals(this.comments, typedThat.comments)) {
            return false;
        }
        if (this.tags != null && !Objects.equals(this.tags, typedThat.tags)) {
            return false;
        }
        if (this.meaning != null && !Objects.equals(this.meaning, typedThat.meaning)) {
            return false;
        }
        if (this.impactingProjects != null && !Objects.equals(this.impactingProjects, typedThat.impactingProjects)) {
            return false;
        }
        if (this.facets != null && !Objects.equals(this.facets, typedThat.facets)) {
            return false;
        }
        if (this.licenses != null && !Objects.equals(this.licenses, typedThat.licenses)) {
            return false;
        }
        if (this.parentSchemas != null && !Objects.equals(this.parentSchemas, typedThat.parentSchemas)) {
            return false;
        }
        if (this.alsoKnownAs != null && !Objects.equals(this.alsoKnownAs, typedThat.alsoKnownAs)) {
            return false;
        }
        if (this.likes != null && !Objects.equals(this.likes, typedThat.likes)) {
            return false;
        }
        if (this.noteLogs != null && !Objects.equals(this.noteLogs, typedThat.noteLogs)) {
            return false;
        }
        if (this.certifications != null && !Objects.equals(this.certifications, typedThat.certifications)) {
            return false;
        }
        if (this.usedBy != null && !Objects.equals(this.usedBy, typedThat.usedBy)) {
            return false;
        }
        if (this.type != null && !Objects.equals(this.type, typedThat.type)) {
            return false;
        }
        if (this.managedResources != null && !Objects.equals(this.managedResources, typedThat.managedResources)) {
            return false;
        }
        if (this.relatedMedia != null && !Objects.equals(this.relatedMedia, typedThat.relatedMedia)) {
            return false;
        }
        if (this.externalType != null && !Objects.equals(this.externalType, typedThat.externalType)) {
            return false;
        }
        if (this.starRatings != null && !Objects.equals(this.starRatings, typedThat.starRatings)) {
            return false;
        }
        if (this.externalReference != null && !Objects.equals(this.externalReference, typedThat.externalReference)) {
            return false;
        }
        if (this.actions != null && !Objects.equals(this.actions, typedThat.actions)) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.vertices, this.comments, this.tags, this.meaning, this.impactingProjects, this.facets, this.licenses, this.parentSchemas, this.alsoKnownAs, this.likes, this.noteLogs, this.certifications, this.usedBy, this.type, this.managedResources, this.relatedMedia, this.externalType, this.starRatings, this.externalReference, this.actions);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

