/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.entities.InformalTag;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.InformalTagToReferenceable.TaggedElementReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedTag.AttachedTag;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class InformalTagReferences
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(InformalTagReferences.class);
    private static final String className = InformalTagReferences.class.getName();
    public static final String[] REFERENCE_NAMES_SET_VALUES = new String[]{"taggedElement", null};
    public static final String[] RELATIONSHIP_NAMES_SET_VALUES = new String[]{"AttachedTag", null};
    public static final Set<String> REFERENCE_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(REFERENCE_NAMES_SET_VALUES)));
    public static final Set<String> RELATIONSHIP_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(RELATIONSHIP_NAMES_SET_VALUES)));
    private Set<TaggedElementReference> taggedElement;

    public InformalTagReferences(String entityGuid, Set<Line> lines) throws InvalidParameterException {
        if (lines != null) {
            for (Line relationship : lines) {
                for (int i = 0; i < RELATIONSHIP_NAMES_SET_VALUES.length; ++i) {
                    String referenceName;
                    if (!relationship.getName().equals(RELATIONSHIP_NAMES_SET_VALUES[i]) || !"taggedElement".equals(referenceName = REFERENCE_NAMES_SET_VALUES[i])) continue;
                    AttachedTag attachedTag_relationship = (AttachedTag)relationship;
                    TaggedElementReference taggedElementReference = new TaggedElementReference(entityGuid, attachedTag_relationship);
                    if (this.taggedElement == null) {
                        this.taggedElement = new HashSet<TaggedElementReference>();
                    }
                    this.taggedElement.add(taggedElementReference);
                }
            }
        }
    }

    public Set<TaggedElementReference> getTaggedElementReferences() {
        return this.taggedElement;
    }

    public void setTaggedElementReferences(Set<TaggedElementReference> taggedElement) {
        this.taggedElement = taggedElement;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("InformalTagReferences{");
        sb.append("taggedElementReference='").append(this.taggedElement.toString());
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InformalTagReferences typedThat = (InformalTagReferences)o;
        if (this.taggedElement != null && !Objects.equals(this.taggedElement, typedThat.taggedElement)) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.taggedElement);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

