/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Like;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.LikeToReferenceable.LikeAnchorReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedLike.AttachedLike;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class LikeReferences
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(LikeReferences.class);
    private static final String className = LikeReferences.class.getName();
    public static final String[] REFERENCE_NAMES_SET_VALUES = new String[]{"likeAnchor", null};
    public static final String[] RELATIONSHIP_NAMES_SET_VALUES = new String[]{"AttachedLike", null};
    public static final Set<String> REFERENCE_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(REFERENCE_NAMES_SET_VALUES)));
    public static final Set<String> RELATIONSHIP_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(RELATIONSHIP_NAMES_SET_VALUES)));
    private LikeAnchorReference likeAnchor;

    public LikeReferences(String entityGuid, Set<Line> lines) throws InvalidParameterException {
        if (lines != null) {
            for (Line relationship : lines) {
                for (int i = 0; i < RELATIONSHIP_NAMES_SET_VALUES.length; ++i) {
                    String referenceName;
                    if (!relationship.getName().equals(RELATIONSHIP_NAMES_SET_VALUES[i]) || !"likeAnchor".equals(referenceName = REFERENCE_NAMES_SET_VALUES[i])) continue;
                    AttachedLike attachedLike_relationship = (AttachedLike)relationship;
                    this.likeAnchor = new LikeAnchorReference(entityGuid, attachedLike_relationship);
                }
            }
        }
    }

    public LikeAnchorReference getLikeAnchorReference() {
        return this.likeAnchor;
    }

    public void setLikeAnchorReference(LikeAnchorReference likeAnchor) {
        this.likeAnchor = likeAnchor;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("LikeReferences{");
        sb.append("likeAnchorReference='").append(this.likeAnchor.toString());
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LikeReferences typedThat = (LikeReferences)o;
        if (this.likeAnchor != null && !Objects.equals(this.likeAnchor, typedThat.likeAnchor)) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.likeAnchor);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

