/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Network;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.AssetToConnection.ConnectionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.AssetToDataSet.SupportedDataSetsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.AssetToSchemaType.SchemaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.AssetToSoftwareServerCapability.ConsumedByReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.NetworkToHost.ConnectedHostsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.NetworkToNetworkGateway.GatewaysReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToCertificationType.CertificationsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToComment.CommentsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalId.AlsoKnownAsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalId.ManagedResourcesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalReference.ExternalReferenceReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToGlossaryTerm.MeaningReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToInformalTag.TagsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToLicenseType.LicensesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToLike.LikesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToNoteLog.NoteLogsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToProject.ImpactingProjectsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToPropertyFacet.FacetsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRating.StarRatingsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRelatedMedia.RelatedMediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToToDo.ActionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetSchemaType.AssetSchemaType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetServerUse.AssetServerUse;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedComment.AttachedComment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedLike.AttachedLike;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedNoteLog.AttachedNoteLog;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedRating.AttachedRating;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedTag.AttachedTag;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Certification.Certification;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionToAsset.ConnectionToAsset;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.DataContentForDataSet.DataContentForDataSet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdLink.ExternalIdLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdScope.ExternalIdScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalReferenceLink.ExternalReferenceLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostNetwork.HostNetwork;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.License.License;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MediaReference.MediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.NetworkGatewayLink.NetworkGatewayLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectScope.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReferenceableFacet.ReferenceableFacet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SemanticAssignment.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoSource.ToDoSource;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class NetworkReferences
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(NetworkReferences.class);
    private static final String className = NetworkReferences.class.getName();
    public static final String[] REFERENCE_NAMES_SET_VALUES = new String[]{"connectedHosts", "gateways", "consumedBy", "supportedDataSets", "schema", "connections", "comments", "tags", "meaning", "impactingProjects", "facets", "licenses", "alsoKnownAs", "likes", "noteLogs", "certifications", "managedResources", "relatedMedia", "starRatings", "externalReference", "actions", null};
    public static final String[] RELATIONSHIP_NAMES_SET_VALUES = new String[]{"HostNetwork", "NetworkGatewayLink", "AssetServerUse", "DataContentForDataSet", "AssetSchemaType", "ConnectionToAsset", "AttachedComment", "AttachedTag", "SemanticAssignment", "ProjectScope", "ReferenceableFacet", "License", "ExternalIdLink", "AttachedLike", "AttachedNoteLog", "Certification", "ExternalIdScope", "MediaReference", "AttachedRating", "ExternalReferenceLink", "ToDoSource", null};
    public static final Set<String> REFERENCE_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(REFERENCE_NAMES_SET_VALUES)));
    public static final Set<String> RELATIONSHIP_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(RELATIONSHIP_NAMES_SET_VALUES)));
    private SchemaReference schema;
    private Set<ConnectedHostsReference> connectedHosts;
    private Set<GatewaysReference> gateways;
    private Set<ConsumedByReference> consumedBy;
    private Set<SupportedDataSetsReference> supportedDataSets;
    private Set<ConnectionsReference> connections;
    private Set<CommentsReference> comments;
    private Set<TagsReference> tags;
    private Set<MeaningReference> meaning;
    private Set<ImpactingProjectsReference> impactingProjects;
    private Set<FacetsReference> facets;
    private Set<LicensesReference> licenses;
    private Set<AlsoKnownAsReference> alsoKnownAs;
    private Set<LikesReference> likes;
    private Set<NoteLogsReference> noteLogs;
    private Set<CertificationsReference> certifications;
    private Set<ManagedResourcesReference> managedResources;
    private Set<RelatedMediaReference> relatedMedia;
    private Set<StarRatingsReference> starRatings;
    private Set<ExternalReferenceReference> externalReference;
    private Set<ActionsReference> actions;

    public NetworkReferences(String entityGuid, Set<Line> lines) throws InvalidParameterException {
        if (lines != null) {
            for (Line relationship : lines) {
                for (int i = 0; i < RELATIONSHIP_NAMES_SET_VALUES.length; ++i) {
                    if (!relationship.getName().equals(RELATIONSHIP_NAMES_SET_VALUES[i])) continue;
                    String referenceName = REFERENCE_NAMES_SET_VALUES[i];
                    if ("connectedHosts".equals(referenceName)) {
                        HostNetwork hostNetwork_relationship = (HostNetwork)relationship;
                        ConnectedHostsReference connectedHostsReference = new ConnectedHostsReference(entityGuid, hostNetwork_relationship);
                        if (this.connectedHosts == null) {
                            this.connectedHosts = new HashSet<ConnectedHostsReference>();
                        }
                        this.connectedHosts.add(connectedHostsReference);
                    }
                    if ("gateways".equals(referenceName)) {
                        NetworkGatewayLink networkGatewayLink_relationship = (NetworkGatewayLink)relationship;
                        GatewaysReference gatewaysReference = new GatewaysReference(entityGuid, networkGatewayLink_relationship);
                        if (this.gateways == null) {
                            this.gateways = new HashSet<GatewaysReference>();
                        }
                        this.gateways.add(gatewaysReference);
                    }
                    if ("consumedBy".equals(referenceName)) {
                        AssetServerUse assetServerUse_relationship = (AssetServerUse)relationship;
                        ConsumedByReference consumedByReference = new ConsumedByReference(entityGuid, assetServerUse_relationship);
                        if (this.consumedBy == null) {
                            this.consumedBy = new HashSet<ConsumedByReference>();
                        }
                        this.consumedBy.add(consumedByReference);
                    }
                    if ("supportedDataSets".equals(referenceName)) {
                        DataContentForDataSet dataContentForDataSet_relationship = (DataContentForDataSet)relationship;
                        SupportedDataSetsReference supportedDataSetsReference = new SupportedDataSetsReference(entityGuid, dataContentForDataSet_relationship);
                        if (this.supportedDataSets == null) {
                            this.supportedDataSets = new HashSet<SupportedDataSetsReference>();
                        }
                        this.supportedDataSets.add(supportedDataSetsReference);
                    }
                    if ("connections".equals(referenceName)) {
                        ConnectionToAsset connectionToAsset_relationship = (ConnectionToAsset)relationship;
                        ConnectionsReference connectionsReference = new ConnectionsReference(entityGuid, connectionToAsset_relationship);
                        if (this.connections == null) {
                            this.connections = new HashSet<ConnectionsReference>();
                        }
                        this.connections.add(connectionsReference);
                    }
                    if ("comments".equals(referenceName)) {
                        AttachedComment attachedComment_relationship = (AttachedComment)relationship;
                        CommentsReference commentsReference = new CommentsReference(entityGuid, attachedComment_relationship);
                        if (this.comments == null) {
                            this.comments = new HashSet<CommentsReference>();
                        }
                        this.comments.add(commentsReference);
                    }
                    if ("tags".equals(referenceName)) {
                        AttachedTag attachedTag_relationship = (AttachedTag)relationship;
                        TagsReference tagsReference = new TagsReference(entityGuid, attachedTag_relationship);
                        if (this.tags == null) {
                            this.tags = new HashSet<TagsReference>();
                        }
                        this.tags.add(tagsReference);
                    }
                    if ("meaning".equals(referenceName)) {
                        SemanticAssignment semanticAssignment_relationship = (SemanticAssignment)relationship;
                        MeaningReference meaningReference = new MeaningReference(entityGuid, semanticAssignment_relationship);
                        if (this.meaning == null) {
                            this.meaning = new HashSet<MeaningReference>();
                        }
                        this.meaning.add(meaningReference);
                    }
                    if ("impactingProjects".equals(referenceName)) {
                        ProjectScope projectScope_relationship = (ProjectScope)relationship;
                        ImpactingProjectsReference impactingProjectsReference = new ImpactingProjectsReference(entityGuid, projectScope_relationship);
                        if (this.impactingProjects == null) {
                            this.impactingProjects = new HashSet<ImpactingProjectsReference>();
                        }
                        this.impactingProjects.add(impactingProjectsReference);
                    }
                    if ("facets".equals(referenceName)) {
                        ReferenceableFacet referenceableFacet_relationship = (ReferenceableFacet)relationship;
                        FacetsReference facetsReference = new FacetsReference(entityGuid, referenceableFacet_relationship);
                        if (this.facets == null) {
                            this.facets = new HashSet<FacetsReference>();
                        }
                        this.facets.add(facetsReference);
                    }
                    if ("licenses".equals(referenceName)) {
                        License license_relationship = (License)relationship;
                        LicensesReference licensesReference = new LicensesReference(entityGuid, license_relationship);
                        if (this.licenses == null) {
                            this.licenses = new HashSet<LicensesReference>();
                        }
                        this.licenses.add(licensesReference);
                    }
                    if ("alsoKnownAs".equals(referenceName)) {
                        ExternalIdLink externalIdLink_relationship = (ExternalIdLink)relationship;
                        AlsoKnownAsReference alsoKnownAsReference = new AlsoKnownAsReference(entityGuid, externalIdLink_relationship);
                        if (this.alsoKnownAs == null) {
                            this.alsoKnownAs = new HashSet<AlsoKnownAsReference>();
                        }
                        this.alsoKnownAs.add(alsoKnownAsReference);
                    }
                    if ("likes".equals(referenceName)) {
                        AttachedLike attachedLike_relationship = (AttachedLike)relationship;
                        LikesReference likesReference = new LikesReference(entityGuid, attachedLike_relationship);
                        if (this.likes == null) {
                            this.likes = new HashSet<LikesReference>();
                        }
                        this.likes.add(likesReference);
                    }
                    if ("noteLogs".equals(referenceName)) {
                        AttachedNoteLog attachedNoteLog_relationship = (AttachedNoteLog)relationship;
                        NoteLogsReference noteLogsReference = new NoteLogsReference(entityGuid, attachedNoteLog_relationship);
                        if (this.noteLogs == null) {
                            this.noteLogs = new HashSet<NoteLogsReference>();
                        }
                        this.noteLogs.add(noteLogsReference);
                    }
                    if ("certifications".equals(referenceName)) {
                        Certification certification_relationship = (Certification)relationship;
                        CertificationsReference certificationsReference = new CertificationsReference(entityGuid, certification_relationship);
                        if (this.certifications == null) {
                            this.certifications = new HashSet<CertificationsReference>();
                        }
                        this.certifications.add(certificationsReference);
                    }
                    if ("managedResources".equals(referenceName)) {
                        ExternalIdScope externalIdScope_relationship = (ExternalIdScope)relationship;
                        ManagedResourcesReference managedResourcesReference = new ManagedResourcesReference(entityGuid, externalIdScope_relationship);
                        if (this.managedResources == null) {
                            this.managedResources = new HashSet<ManagedResourcesReference>();
                        }
                        this.managedResources.add(managedResourcesReference);
                    }
                    if ("relatedMedia".equals(referenceName)) {
                        MediaReference mediaReference_relationship = (MediaReference)relationship;
                        RelatedMediaReference relatedMediaReference = new RelatedMediaReference(entityGuid, mediaReference_relationship);
                        if (this.relatedMedia == null) {
                            this.relatedMedia = new HashSet<RelatedMediaReference>();
                        }
                        this.relatedMedia.add(relatedMediaReference);
                    }
                    if ("starRatings".equals(referenceName)) {
                        AttachedRating attachedRating_relationship = (AttachedRating)relationship;
                        StarRatingsReference starRatingsReference = new StarRatingsReference(entityGuid, attachedRating_relationship);
                        if (this.starRatings == null) {
                            this.starRatings = new HashSet<StarRatingsReference>();
                        }
                        this.starRatings.add(starRatingsReference);
                    }
                    if ("externalReference".equals(referenceName)) {
                        ExternalReferenceLink externalReferenceLink_relationship = (ExternalReferenceLink)relationship;
                        ExternalReferenceReference externalReferenceReference = new ExternalReferenceReference(entityGuid, externalReferenceLink_relationship);
                        if (this.externalReference == null) {
                            this.externalReference = new HashSet<ExternalReferenceReference>();
                        }
                        this.externalReference.add(externalReferenceReference);
                    }
                    if ("actions".equals(referenceName)) {
                        ToDoSource toDoSource_relationship = (ToDoSource)relationship;
                        ActionsReference actionsReference = new ActionsReference(entityGuid, toDoSource_relationship);
                        if (this.actions == null) {
                            this.actions = new HashSet<ActionsReference>();
                        }
                        this.actions.add(actionsReference);
                    }
                    if (!"schema".equals(referenceName)) continue;
                    AssetSchemaType assetSchemaType_relationship = (AssetSchemaType)relationship;
                    this.schema = new SchemaReference(entityGuid, assetSchemaType_relationship);
                }
            }
        }
    }

    public SchemaReference getSchemaReference() {
        return this.schema;
    }

    public void setSchemaReference(SchemaReference schema) {
        this.schema = schema;
    }

    public Set<ConnectedHostsReference> getConnectedHostsReferences() {
        return this.connectedHosts;
    }

    public void setConnectedHostsReferences(Set<ConnectedHostsReference> connectedHosts) {
        this.connectedHosts = connectedHosts;
    }

    public Set<GatewaysReference> getGatewaysReferences() {
        return this.gateways;
    }

    public void setGatewaysReferences(Set<GatewaysReference> gateways) {
        this.gateways = gateways;
    }

    public Set<ConsumedByReference> getConsumedByReferences() {
        return this.consumedBy;
    }

    public void setConsumedByReferences(Set<ConsumedByReference> consumedBy) {
        this.consumedBy = consumedBy;
    }

    public Set<SupportedDataSetsReference> getSupportedDataSetsReferences() {
        return this.supportedDataSets;
    }

    public void setSupportedDataSetsReferences(Set<SupportedDataSetsReference> supportedDataSets) {
        this.supportedDataSets = supportedDataSets;
    }

    public Set<ConnectionsReference> getConnectionsReferences() {
        return this.connections;
    }

    public void setConnectionsReferences(Set<ConnectionsReference> connections) {
        this.connections = connections;
    }

    public Set<CommentsReference> getCommentsReferences() {
        return this.comments;
    }

    public void setCommentsReferences(Set<CommentsReference> comments) {
        this.comments = comments;
    }

    public Set<TagsReference> getTagsReferences() {
        return this.tags;
    }

    public void setTagsReferences(Set<TagsReference> tags) {
        this.tags = tags;
    }

    public Set<MeaningReference> getMeaningReferences() {
        return this.meaning;
    }

    public void setMeaningReferences(Set<MeaningReference> meaning) {
        this.meaning = meaning;
    }

    public Set<ImpactingProjectsReference> getImpactingProjectsReferences() {
        return this.impactingProjects;
    }

    public void setImpactingProjectsReferences(Set<ImpactingProjectsReference> impactingProjects) {
        this.impactingProjects = impactingProjects;
    }

    public Set<FacetsReference> getFacetsReferences() {
        return this.facets;
    }

    public void setFacetsReferences(Set<FacetsReference> facets) {
        this.facets = facets;
    }

    public Set<LicensesReference> getLicensesReferences() {
        return this.licenses;
    }

    public void setLicensesReferences(Set<LicensesReference> licenses) {
        this.licenses = licenses;
    }

    public Set<AlsoKnownAsReference> getAlsoKnownAsReferences() {
        return this.alsoKnownAs;
    }

    public void setAlsoKnownAsReferences(Set<AlsoKnownAsReference> alsoKnownAs) {
        this.alsoKnownAs = alsoKnownAs;
    }

    public Set<LikesReference> getLikesReferences() {
        return this.likes;
    }

    public void setLikesReferences(Set<LikesReference> likes) {
        this.likes = likes;
    }

    public Set<NoteLogsReference> getNoteLogsReferences() {
        return this.noteLogs;
    }

    public void setNoteLogsReferences(Set<NoteLogsReference> noteLogs) {
        this.noteLogs = noteLogs;
    }

    public Set<CertificationsReference> getCertificationsReferences() {
        return this.certifications;
    }

    public void setCertificationsReferences(Set<CertificationsReference> certifications) {
        this.certifications = certifications;
    }

    public Set<ManagedResourcesReference> getManagedResourcesReferences() {
        return this.managedResources;
    }

    public void setManagedResourcesReferences(Set<ManagedResourcesReference> managedResources) {
        this.managedResources = managedResources;
    }

    public Set<RelatedMediaReference> getRelatedMediaReferences() {
        return this.relatedMedia;
    }

    public void setRelatedMediaReferences(Set<RelatedMediaReference> relatedMedia) {
        this.relatedMedia = relatedMedia;
    }

    public Set<StarRatingsReference> getStarRatingsReferences() {
        return this.starRatings;
    }

    public void setStarRatingsReferences(Set<StarRatingsReference> starRatings) {
        this.starRatings = starRatings;
    }

    public Set<ExternalReferenceReference> getExternalReferenceReferences() {
        return this.externalReference;
    }

    public void setExternalReferenceReferences(Set<ExternalReferenceReference> externalReference) {
        this.externalReference = externalReference;
    }

    public Set<ActionsReference> getActionsReferences() {
        return this.actions;
    }

    public void setActionsReferences(Set<ActionsReference> actions) {
        this.actions = actions;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("NetworkReferences{");
        sb.append("connectedHostsReference='").append(this.connectedHosts.toString());
        sb.append("gatewaysReference='").append(this.gateways.toString());
        sb.append("consumedByReference='").append(this.consumedBy.toString());
        sb.append("supportedDataSetsReference='").append(this.supportedDataSets.toString());
        sb.append("connectionsReference='").append(this.connections.toString());
        sb.append("commentsReference='").append(this.comments.toString());
        sb.append("tagsReference='").append(this.tags.toString());
        sb.append("meaningReference='").append(this.meaning.toString());
        sb.append("impactingProjectsReference='").append(this.impactingProjects.toString());
        sb.append("facetsReference='").append(this.facets.toString());
        sb.append("licensesReference='").append(this.licenses.toString());
        sb.append("alsoKnownAsReference='").append(this.alsoKnownAs.toString());
        sb.append("likesReference='").append(this.likes.toString());
        sb.append("noteLogsReference='").append(this.noteLogs.toString());
        sb.append("certificationsReference='").append(this.certifications.toString());
        sb.append("managedResourcesReference='").append(this.managedResources.toString());
        sb.append("relatedMediaReference='").append(this.relatedMedia.toString());
        sb.append("starRatingsReference='").append(this.starRatings.toString());
        sb.append("externalReferenceReference='").append(this.externalReference.toString());
        sb.append("actionsReference='").append(this.actions.toString());
        sb.append("schemaReference='").append(this.schema.toString());
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkReferences typedThat = (NetworkReferences)o;
        if (this.connectedHosts != null && !Objects.equals(this.connectedHosts, typedThat.connectedHosts)) {
            return false;
        }
        if (this.gateways != null && !Objects.equals(this.gateways, typedThat.gateways)) {
            return false;
        }
        if (this.consumedBy != null && !Objects.equals(this.consumedBy, typedThat.consumedBy)) {
            return false;
        }
        if (this.supportedDataSets != null && !Objects.equals(this.supportedDataSets, typedThat.supportedDataSets)) {
            return false;
        }
        if (this.schema != null && !Objects.equals(this.schema, typedThat.schema)) {
            return false;
        }
        if (this.connections != null && !Objects.equals(this.connections, typedThat.connections)) {
            return false;
        }
        if (this.comments != null && !Objects.equals(this.comments, typedThat.comments)) {
            return false;
        }
        if (this.tags != null && !Objects.equals(this.tags, typedThat.tags)) {
            return false;
        }
        if (this.meaning != null && !Objects.equals(this.meaning, typedThat.meaning)) {
            return false;
        }
        if (this.impactingProjects != null && !Objects.equals(this.impactingProjects, typedThat.impactingProjects)) {
            return false;
        }
        if (this.facets != null && !Objects.equals(this.facets, typedThat.facets)) {
            return false;
        }
        if (this.licenses != null && !Objects.equals(this.licenses, typedThat.licenses)) {
            return false;
        }
        if (this.alsoKnownAs != null && !Objects.equals(this.alsoKnownAs, typedThat.alsoKnownAs)) {
            return false;
        }
        if (this.likes != null && !Objects.equals(this.likes, typedThat.likes)) {
            return false;
        }
        if (this.noteLogs != null && !Objects.equals(this.noteLogs, typedThat.noteLogs)) {
            return false;
        }
        if (this.certifications != null && !Objects.equals(this.certifications, typedThat.certifications)) {
            return false;
        }
        if (this.managedResources != null && !Objects.equals(this.managedResources, typedThat.managedResources)) {
            return false;
        }
        if (this.relatedMedia != null && !Objects.equals(this.relatedMedia, typedThat.relatedMedia)) {
            return false;
        }
        if (this.starRatings != null && !Objects.equals(this.starRatings, typedThat.starRatings)) {
            return false;
        }
        if (this.externalReference != null && !Objects.equals(this.externalReference, typedThat.externalReference)) {
            return false;
        }
        if (this.actions != null && !Objects.equals(this.actions, typedThat.actions)) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.connectedHosts, this.gateways, this.consumedBy, this.supportedDataSets, this.schema, this.connections, this.comments, this.tags, this.meaning, this.impactingProjects, this.facets, this.licenses, this.alsoKnownAs, this.likes, this.noteLogs, this.certifications, this.managedResources, this.relatedMedia, this.starRatings, this.externalReference, this.actions);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

