/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SchemaType;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SchemaType.SchemaType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.server.properties.classifications.ClassificationFactory;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.archivemanager.OMRSArchiveAccessor;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(SchemaTypeMapper.class);
    private static final String className = SchemaTypeMapper.class.getName();

    public static SchemaType mapOmrsEntityDetailToSchemaType(EntityDetail omrsEntityDetail) throws InvalidParameterException {
        String entityTypeName = omrsEntityDetail.getType().getTypeDefName();
        if ("SchemaType".equals(entityTypeName)) {
            List omrsclassifications;
            SchemaType schemaType = new SchemaType();
            SystemAttributes systemAttributes = new SystemAttributes();
            InstanceStatus instanceStatus = omrsEntityDetail.getStatus();
            Status omas_status = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
            systemAttributes.setStatus(omas_status);
            systemAttributes.setCreatedBy(omrsEntityDetail.getCreatedBy());
            systemAttributes.setUpdatedBy(omrsEntityDetail.getUpdatedBy());
            systemAttributes.setCreateTime(omrsEntityDetail.getCreateTime());
            systemAttributes.setUpdateTime(omrsEntityDetail.getUpdateTime());
            systemAttributes.setVersion(Long.valueOf(omrsEntityDetail.getVersion()));
            systemAttributes.setGUID(omrsEntityDetail.getGUID());
            schemaType.setSystemAttributes(systemAttributes);
            InstanceProperties omrsEntityDetailProperties = omrsEntityDetail.getProperties();
            if (omrsEntityDetailProperties != null) {
                omrsEntityDetailProperties.setEffectiveFromTime(schemaType.getEffectiveFromTime());
                omrsEntityDetailProperties.setEffectiveToTime(schemaType.getEffectiveToTime());
                Iterator omrsPropertyIterator = omrsEntityDetailProperties.getPropertyNames();
                block5: while (omrsPropertyIterator.hasNext()) {
                    String name = (String)omrsPropertyIterator.next();
                    InstancePropertyValue value = omrsEntityDetailProperties.getPropertyValue(name);
                    switch (value.getInstancePropertyCategory()) {
                        case PRIMITIVE: {
                            PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                            Object actualValue = primitivePropertyValue.getPrimitiveValue();
                            if (SchemaType.ATTRIBUTE_NAMES_SET.contains(name)) {
                                if (name.equals("displayName")) {
                                    schemaType.setDisplayName((String)actualValue);
                                }
                                if (name.equals("versionNumber")) {
                                    schemaType.setVersionNumber((String)actualValue);
                                }
                                if (name.equals("author")) {
                                    schemaType.setAuthor((String)actualValue);
                                }
                                if (name.equals("usage")) {
                                    schemaType.setUsage((String)actualValue);
                                }
                                if (name.equals("encodingStandard")) {
                                    schemaType.setEncodingStandard((String)actualValue);
                                }
                                if (!name.equals("qualifiedName")) break;
                                schemaType.setQualifiedName((String)actualValue);
                                break;
                            }
                            if (null == schemaType.getExtraAttributes()) {
                                schemaType.setExtraAttributes(new HashMap<String, Object>());
                            }
                            schemaType.getExtraAttributes().put(name, primitivePropertyValue);
                            break;
                        }
                        case ENUM: {
                            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                            String symbolicName = enumPropertyValue.getSymbolicName();
                            if (SchemaType.ENUM_NAMES_SET.contains(name)) break;
                            if (null == schemaType.getExtraAttributes()) {
                                schemaType.setExtraAttributes(new HashMap<String, Object>());
                            }
                            schemaType.getExtraAttributes().put(name, enumPropertyValue);
                            break;
                        }
                        case MAP: {
                            if (!SchemaType.MAP_NAMES_SET.contains(name)) break;
                            MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                            InstanceProperties instancePropertyForMap = mapPropertyValue.getMapValues();
                            if (!name.equals("additionalProperties")) continue block5;
                            HashMap<String, String> actualMap = new HashMap<String, String>();
                            Iterator iter = instancePropertyForMap.getPropertyNames();
                            while (iter.hasNext()) {
                                String mapkey = (String)iter.next();
                                PrimitivePropertyValue primitivePropertyMapValue = (PrimitivePropertyValue)instancePropertyForMap.getPropertyValue(mapkey);
                                String mapvalue = (String)primitivePropertyMapValue.getPrimitiveValue();
                                actualMap.put(mapkey, mapvalue);
                            }
                            schemaType.setAdditionalProperties(actualMap);
                            break;
                        }
                    }
                }
            }
            if ((omrsclassifications = omrsEntityDetail.getClassifications()) != null && !omrsclassifications.isEmpty()) {
                for (Classification omrsClassification : omrsclassifications) {
                    String omrsClassificationName = omrsClassification.getName();
                    org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification omasClassification = ClassificationFactory.getClassification(omrsClassificationName, omrsClassification);
                    if (omasClassification != null) {
                        if (schemaType.classifications == null) {
                            schemaType.classifications = new ArrayList<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification>();
                        }
                        schemaType.classifications.add(omasClassification);
                        continue;
                    }
                    if (null == schemaType.getExtraClassifications()) {
                        schemaType.setExtraClassifications(new HashMap<String, Classification>());
                    }
                    schemaType.getExtraClassifications().put(omrsClassificationName, omrsClassification);
                }
            }
            return schemaType;
        }
        return null;
    }

    public static EntityDetail mapSchemaTypeToOmrsEntityDetail(SchemaType schemaType) {
        PrimitivePropertyValue primitivePropertyValue;
        EntityDetail omrsEntityDetail = new EntityDetail();
        SystemAttributes systemAttributes = schemaType.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsEntityDetail.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsEntityDetail.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsEntityDetail.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsEntityDetail.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsEntityDetail.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getGUID() != null) {
                omrsEntityDetail.setGUID(systemAttributes.getGUID());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToInstanceStatus(systemAttributes.getStatus());
                omrsEntityDetail.setStatus(instanceStatus);
            }
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        instanceProperties.setEffectiveFromTime(schemaType.getEffectiveFromTime());
        instanceProperties.setEffectiveToTime(schemaType.getEffectiveToTime());
        if (schemaType.getDisplayName() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)schemaType.getDisplayName());
            instanceProperties.setProperty("displayName", (InstancePropertyValue)primitivePropertyValue);
        }
        if (schemaType.getVersionNumber() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)schemaType.getVersionNumber());
            instanceProperties.setProperty("versionNumber", (InstancePropertyValue)primitivePropertyValue);
        }
        if (schemaType.getAuthor() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)schemaType.getAuthor());
            instanceProperties.setProperty("author", (InstancePropertyValue)primitivePropertyValue);
        }
        if (schemaType.getUsage() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)schemaType.getUsage());
            instanceProperties.setProperty("usage", (InstancePropertyValue)primitivePropertyValue);
        }
        if (schemaType.getEncodingStandard() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)schemaType.getEncodingStandard());
            instanceProperties.setProperty("encodingStandard", (InstancePropertyValue)primitivePropertyValue);
        }
        if (schemaType.getQualifiedName() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)schemaType.getQualifiedName());
            instanceProperties.setProperty("qualifiedName", (InstancePropertyValue)primitivePropertyValue);
        }
        if (schemaType.getAdditionalProperties() != null) {
            Map<String, String> map = schemaType.getAdditionalProperties();
            MapPropertyValue mapPropertyValue = new MapPropertyValue();
            for (String key : map.keySet()) {
                PrimitivePropertyValue primitivePropertyValue2 = new PrimitivePropertyValue();
                primitivePropertyValue2.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue2.setPrimitiveValue((Object)map.get(key));
                mapPropertyValue.setMapValue(key, (InstancePropertyValue)primitivePropertyValue2);
            }
            instanceProperties.setProperty("additionalProperties", (InstancePropertyValue)mapPropertyValue);
        }
        omrsEntityDetail.setProperties(instanceProperties);
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef typeDef = archiveAccessor.getEntityDefByName("SchemaType");
        InstanceType template = SubjectAreaUtils.createTemplateFromTypeDef((TypeDef)typeDef);
        InstanceType instanceType = new InstanceType(template);
        omrsEntityDetail.setType(instanceType);
        SchemaTypeMapper.populateOmrsEntityWithBeanClassifications(omrsEntityDetail, schemaType.getClassifications());
        return omrsEntityDetail;
    }

    private static void populateOmrsEntityWithBeanClassifications(EntityDetail omrsEntityDetail, List<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification> beanClassifications) {
        if (beanClassifications != null && beanClassifications.size() > 0) {
            ArrayList<Classification> omrsClassifications = new ArrayList<Classification>();
            for (org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification beanClassification : beanClassifications) {
                SystemAttributes systemAttributes = beanClassification.getSystemAttributes();
                Classification omrsClassification = new Classification();
                if (systemAttributes != null) {
                    if (systemAttributes.getCreatedBy() != null) {
                        omrsClassification.setCreatedBy(systemAttributes.getCreatedBy());
                    }
                    if (systemAttributes.getUpdatedBy() != null) {
                        omrsClassification.setUpdatedBy(systemAttributes.getUpdatedBy());
                    }
                    if (systemAttributes.getCreateTime() != null) {
                        omrsClassification.setCreateTime(systemAttributes.getCreateTime());
                    }
                    if (systemAttributes.getUpdateTime() != null) {
                        omrsClassification.setUpdateTime(systemAttributes.getUpdateTime());
                    }
                    if (systemAttributes.getVersion() != null) {
                        omrsClassification.setVersion(systemAttributes.getVersion().longValue());
                    }
                }
                omrsClassification.setName(beanClassification.getClassificationName());
                omrsClassification.setProperties(beanClassification.obtainInstanceProperties());
                omrsClassifications.add(omrsClassification);
            }
            omrsEntityDetail.setClassifications(omrsClassifications);
        }
    }
}

