/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.entities.VirtualContainer;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.AssetToConnection.ConnectionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.AssetToDataSet.SupportedDataSetsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.AssetToSchemaType.SchemaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.AssetToSoftwareServerCapability.ConsumedByReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.HostToHostCluster.HostClusterReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.HostToLocation.LocationsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.HostToNetwork.NetworkConnectionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.HostToOperatingPlatform.OperatingPlatformReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.HostToVirtualContainer.HostedContainersReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToCertificationType.CertificationsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToComment.CommentsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalId.AlsoKnownAsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalId.ManagedResourcesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalReference.ExternalReferenceReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToGlossaryTerm.MeaningReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToInformalTag.TagsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToLicenseType.LicensesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToLike.LikesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToNoteLog.NoteLogsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToProject.ImpactingProjectsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToPropertyFacet.FacetsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRating.StarRatingsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRelatedMedia.RelatedMediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToToDo.ActionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.VirtualContainerToHost.HostsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetSchemaType.AssetSchemaType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetServerUse.AssetServerUse;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedComment.AttachedComment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedLike.AttachedLike;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedNoteLog.AttachedNoteLog;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedRating.AttachedRating;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedTag.AttachedTag;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Certification.Certification;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionToAsset.ConnectionToAsset;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.DataContentForDataSet.DataContentForDataSet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.DeployedVirtualContainer.DeployedVirtualContainer;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdLink.ExternalIdLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdScope.ExternalIdScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalReferenceLink.ExternalReferenceLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostClusterMember.HostClusterMember;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostLocation.HostLocation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostNetwork.HostNetwork;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostOperatingPlatform.HostOperatingPlatform;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.License.License;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MediaReference.MediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectScope.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReferenceableFacet.ReferenceableFacet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SemanticAssignment.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoSource.ToDoSource;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class VirtualContainerReferences
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(VirtualContainerReferences.class);
    private static final String className = VirtualContainerReferences.class.getName();
    public static final String[] REFERENCE_NAMES_SET_VALUES = new String[]{"hosts", "networkConnections", "hostCluster", "locations", "operatingPlatform", "hostedContainers", "comments", "tags", "meaning", "impactingProjects", "facets", "licenses", "connections", "alsoKnownAs", "likes", "consumedBy", "noteLogs", "certifications", "supportedDataSets", "schema", "managedResources", "relatedMedia", "starRatings", "externalReference", "actions", null};
    public static final String[] RELATIONSHIP_NAMES_SET_VALUES = new String[]{"DeployedVirtualContainer", "HostNetwork", "HostClusterMember", "HostLocation", "HostOperatingPlatform", "DeployedVirtualContainer", "AttachedComment", "AttachedTag", "SemanticAssignment", "ProjectScope", "ReferenceableFacet", "License", "ConnectionToAsset", "ExternalIdLink", "AttachedLike", "AssetServerUse", "AttachedNoteLog", "Certification", "DataContentForDataSet", "AssetSchemaType", "ExternalIdScope", "MediaReference", "AttachedRating", "ExternalReferenceLink", "ToDoSource", null};
    public static final Set<String> REFERENCE_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(REFERENCE_NAMES_SET_VALUES)));
    public static final Set<String> RELATIONSHIP_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(RELATIONSHIP_NAMES_SET_VALUES)));
    private OperatingPlatformReference operatingPlatform;
    private SchemaReference schema;
    private Set<HostsReference> hosts;
    private Set<NetworkConnectionsReference> networkConnections;
    private Set<HostClusterReference> hostCluster;
    private Set<LocationsReference> locations;
    private Set<HostedContainersReference> hostedContainers;
    private Set<CommentsReference> comments;
    private Set<TagsReference> tags;
    private Set<MeaningReference> meaning;
    private Set<ImpactingProjectsReference> impactingProjects;
    private Set<FacetsReference> facets;
    private Set<LicensesReference> licenses;
    private Set<ConnectionsReference> connections;
    private Set<AlsoKnownAsReference> alsoKnownAs;
    private Set<LikesReference> likes;
    private Set<ConsumedByReference> consumedBy;
    private Set<NoteLogsReference> noteLogs;
    private Set<CertificationsReference> certifications;
    private Set<SupportedDataSetsReference> supportedDataSets;
    private Set<ManagedResourcesReference> managedResources;
    private Set<RelatedMediaReference> relatedMedia;
    private Set<StarRatingsReference> starRatings;
    private Set<ExternalReferenceReference> externalReference;
    private Set<ActionsReference> actions;

    public VirtualContainerReferences(String entityGuid, Set<Line> lines) throws InvalidParameterException {
        if (lines != null) {
            for (Line relationship : lines) {
                for (int i = 0; i < RELATIONSHIP_NAMES_SET_VALUES.length; ++i) {
                    DeployedVirtualContainer deployedVirtualContainer_relationship;
                    if (!relationship.getName().equals(RELATIONSHIP_NAMES_SET_VALUES[i])) continue;
                    String referenceName = REFERENCE_NAMES_SET_VALUES[i];
                    if ("hosts".equals(referenceName)) {
                        deployedVirtualContainer_relationship = (DeployedVirtualContainer)relationship;
                        HostsReference hostsReference = new HostsReference(entityGuid, deployedVirtualContainer_relationship);
                        if (this.hosts == null) {
                            this.hosts = new HashSet<HostsReference>();
                        }
                        this.hosts.add(hostsReference);
                    }
                    if ("networkConnections".equals(referenceName)) {
                        HostNetwork hostNetwork_relationship = (HostNetwork)relationship;
                        NetworkConnectionsReference networkConnectionsReference = new NetworkConnectionsReference(entityGuid, hostNetwork_relationship);
                        if (this.networkConnections == null) {
                            this.networkConnections = new HashSet<NetworkConnectionsReference>();
                        }
                        this.networkConnections.add(networkConnectionsReference);
                    }
                    if ("hostCluster".equals(referenceName)) {
                        HostClusterMember hostClusterMember_relationship = (HostClusterMember)relationship;
                        HostClusterReference hostClusterReference = new HostClusterReference(entityGuid, hostClusterMember_relationship);
                        if (this.hostCluster == null) {
                            this.hostCluster = new HashSet<HostClusterReference>();
                        }
                        this.hostCluster.add(hostClusterReference);
                    }
                    if ("locations".equals(referenceName)) {
                        HostLocation hostLocation_relationship = (HostLocation)relationship;
                        LocationsReference locationsReference = new LocationsReference(entityGuid, hostLocation_relationship);
                        if (this.locations == null) {
                            this.locations = new HashSet<LocationsReference>();
                        }
                        this.locations.add(locationsReference);
                    }
                    if ("hostedContainers".equals(referenceName)) {
                        deployedVirtualContainer_relationship = (DeployedVirtualContainer)relationship;
                        HostedContainersReference hostedContainersReference = new HostedContainersReference(entityGuid, deployedVirtualContainer_relationship);
                        if (this.hostedContainers == null) {
                            this.hostedContainers = new HashSet<HostedContainersReference>();
                        }
                        this.hostedContainers.add(hostedContainersReference);
                    }
                    if ("comments".equals(referenceName)) {
                        AttachedComment attachedComment_relationship = (AttachedComment)relationship;
                        CommentsReference commentsReference = new CommentsReference(entityGuid, attachedComment_relationship);
                        if (this.comments == null) {
                            this.comments = new HashSet<CommentsReference>();
                        }
                        this.comments.add(commentsReference);
                    }
                    if ("tags".equals(referenceName)) {
                        AttachedTag attachedTag_relationship = (AttachedTag)relationship;
                        TagsReference tagsReference = new TagsReference(entityGuid, attachedTag_relationship);
                        if (this.tags == null) {
                            this.tags = new HashSet<TagsReference>();
                        }
                        this.tags.add(tagsReference);
                    }
                    if ("meaning".equals(referenceName)) {
                        SemanticAssignment semanticAssignment_relationship = (SemanticAssignment)relationship;
                        MeaningReference meaningReference = new MeaningReference(entityGuid, semanticAssignment_relationship);
                        if (this.meaning == null) {
                            this.meaning = new HashSet<MeaningReference>();
                        }
                        this.meaning.add(meaningReference);
                    }
                    if ("impactingProjects".equals(referenceName)) {
                        ProjectScope projectScope_relationship = (ProjectScope)relationship;
                        ImpactingProjectsReference impactingProjectsReference = new ImpactingProjectsReference(entityGuid, projectScope_relationship);
                        if (this.impactingProjects == null) {
                            this.impactingProjects = new HashSet<ImpactingProjectsReference>();
                        }
                        this.impactingProjects.add(impactingProjectsReference);
                    }
                    if ("facets".equals(referenceName)) {
                        ReferenceableFacet referenceableFacet_relationship = (ReferenceableFacet)relationship;
                        FacetsReference facetsReference = new FacetsReference(entityGuid, referenceableFacet_relationship);
                        if (this.facets == null) {
                            this.facets = new HashSet<FacetsReference>();
                        }
                        this.facets.add(facetsReference);
                    }
                    if ("licenses".equals(referenceName)) {
                        License license_relationship = (License)relationship;
                        LicensesReference licensesReference = new LicensesReference(entityGuid, license_relationship);
                        if (this.licenses == null) {
                            this.licenses = new HashSet<LicensesReference>();
                        }
                        this.licenses.add(licensesReference);
                    }
                    if ("connections".equals(referenceName)) {
                        ConnectionToAsset connectionToAsset_relationship = (ConnectionToAsset)relationship;
                        ConnectionsReference connectionsReference = new ConnectionsReference(entityGuid, connectionToAsset_relationship);
                        if (this.connections == null) {
                            this.connections = new HashSet<ConnectionsReference>();
                        }
                        this.connections.add(connectionsReference);
                    }
                    if ("alsoKnownAs".equals(referenceName)) {
                        ExternalIdLink externalIdLink_relationship = (ExternalIdLink)relationship;
                        AlsoKnownAsReference alsoKnownAsReference = new AlsoKnownAsReference(entityGuid, externalIdLink_relationship);
                        if (this.alsoKnownAs == null) {
                            this.alsoKnownAs = new HashSet<AlsoKnownAsReference>();
                        }
                        this.alsoKnownAs.add(alsoKnownAsReference);
                    }
                    if ("likes".equals(referenceName)) {
                        AttachedLike attachedLike_relationship = (AttachedLike)relationship;
                        LikesReference likesReference = new LikesReference(entityGuid, attachedLike_relationship);
                        if (this.likes == null) {
                            this.likes = new HashSet<LikesReference>();
                        }
                        this.likes.add(likesReference);
                    }
                    if ("consumedBy".equals(referenceName)) {
                        AssetServerUse assetServerUse_relationship = (AssetServerUse)relationship;
                        ConsumedByReference consumedByReference = new ConsumedByReference(entityGuid, assetServerUse_relationship);
                        if (this.consumedBy == null) {
                            this.consumedBy = new HashSet<ConsumedByReference>();
                        }
                        this.consumedBy.add(consumedByReference);
                    }
                    if ("noteLogs".equals(referenceName)) {
                        AttachedNoteLog attachedNoteLog_relationship = (AttachedNoteLog)relationship;
                        NoteLogsReference noteLogsReference = new NoteLogsReference(entityGuid, attachedNoteLog_relationship);
                        if (this.noteLogs == null) {
                            this.noteLogs = new HashSet<NoteLogsReference>();
                        }
                        this.noteLogs.add(noteLogsReference);
                    }
                    if ("certifications".equals(referenceName)) {
                        Certification certification_relationship = (Certification)relationship;
                        CertificationsReference certificationsReference = new CertificationsReference(entityGuid, certification_relationship);
                        if (this.certifications == null) {
                            this.certifications = new HashSet<CertificationsReference>();
                        }
                        this.certifications.add(certificationsReference);
                    }
                    if ("supportedDataSets".equals(referenceName)) {
                        DataContentForDataSet dataContentForDataSet_relationship = (DataContentForDataSet)relationship;
                        SupportedDataSetsReference supportedDataSetsReference = new SupportedDataSetsReference(entityGuid, dataContentForDataSet_relationship);
                        if (this.supportedDataSets == null) {
                            this.supportedDataSets = new HashSet<SupportedDataSetsReference>();
                        }
                        this.supportedDataSets.add(supportedDataSetsReference);
                    }
                    if ("managedResources".equals(referenceName)) {
                        ExternalIdScope externalIdScope_relationship = (ExternalIdScope)relationship;
                        ManagedResourcesReference managedResourcesReference = new ManagedResourcesReference(entityGuid, externalIdScope_relationship);
                        if (this.managedResources == null) {
                            this.managedResources = new HashSet<ManagedResourcesReference>();
                        }
                        this.managedResources.add(managedResourcesReference);
                    }
                    if ("relatedMedia".equals(referenceName)) {
                        MediaReference mediaReference_relationship = (MediaReference)relationship;
                        RelatedMediaReference relatedMediaReference = new RelatedMediaReference(entityGuid, mediaReference_relationship);
                        if (this.relatedMedia == null) {
                            this.relatedMedia = new HashSet<RelatedMediaReference>();
                        }
                        this.relatedMedia.add(relatedMediaReference);
                    }
                    if ("starRatings".equals(referenceName)) {
                        AttachedRating attachedRating_relationship = (AttachedRating)relationship;
                        StarRatingsReference starRatingsReference = new StarRatingsReference(entityGuid, attachedRating_relationship);
                        if (this.starRatings == null) {
                            this.starRatings = new HashSet<StarRatingsReference>();
                        }
                        this.starRatings.add(starRatingsReference);
                    }
                    if ("externalReference".equals(referenceName)) {
                        ExternalReferenceLink externalReferenceLink_relationship = (ExternalReferenceLink)relationship;
                        ExternalReferenceReference externalReferenceReference = new ExternalReferenceReference(entityGuid, externalReferenceLink_relationship);
                        if (this.externalReference == null) {
                            this.externalReference = new HashSet<ExternalReferenceReference>();
                        }
                        this.externalReference.add(externalReferenceReference);
                    }
                    if ("actions".equals(referenceName)) {
                        ToDoSource toDoSource_relationship = (ToDoSource)relationship;
                        ActionsReference actionsReference = new ActionsReference(entityGuid, toDoSource_relationship);
                        if (this.actions == null) {
                            this.actions = new HashSet<ActionsReference>();
                        }
                        this.actions.add(actionsReference);
                    }
                    if ("operatingPlatform".equals(referenceName)) {
                        HostOperatingPlatform hostOperatingPlatform_relationship = (HostOperatingPlatform)relationship;
                        this.operatingPlatform = new OperatingPlatformReference(entityGuid, hostOperatingPlatform_relationship);
                    }
                    if (!"schema".equals(referenceName)) continue;
                    AssetSchemaType assetSchemaType_relationship = (AssetSchemaType)relationship;
                    this.schema = new SchemaReference(entityGuid, assetSchemaType_relationship);
                }
            }
        }
    }

    public OperatingPlatformReference getOperatingPlatformReference() {
        return this.operatingPlatform;
    }

    public void setOperatingPlatformReference(OperatingPlatformReference operatingPlatform) {
        this.operatingPlatform = operatingPlatform;
    }

    public SchemaReference getSchemaReference() {
        return this.schema;
    }

    public void setSchemaReference(SchemaReference schema) {
        this.schema = schema;
    }

    public Set<HostsReference> getHostsReferences() {
        return this.hosts;
    }

    public void setHostsReferences(Set<HostsReference> hosts) {
        this.hosts = hosts;
    }

    public Set<NetworkConnectionsReference> getNetworkConnectionsReferences() {
        return this.networkConnections;
    }

    public void setNetworkConnectionsReferences(Set<NetworkConnectionsReference> networkConnections) {
        this.networkConnections = networkConnections;
    }

    public Set<HostClusterReference> getHostClusterReferences() {
        return this.hostCluster;
    }

    public void setHostClusterReferences(Set<HostClusterReference> hostCluster) {
        this.hostCluster = hostCluster;
    }

    public Set<LocationsReference> getLocationsReferences() {
        return this.locations;
    }

    public void setLocationsReferences(Set<LocationsReference> locations) {
        this.locations = locations;
    }

    public Set<HostedContainersReference> getHostedContainersReferences() {
        return this.hostedContainers;
    }

    public void setHostedContainersReferences(Set<HostedContainersReference> hostedContainers) {
        this.hostedContainers = hostedContainers;
    }

    public Set<CommentsReference> getCommentsReferences() {
        return this.comments;
    }

    public void setCommentsReferences(Set<CommentsReference> comments) {
        this.comments = comments;
    }

    public Set<TagsReference> getTagsReferences() {
        return this.tags;
    }

    public void setTagsReferences(Set<TagsReference> tags) {
        this.tags = tags;
    }

    public Set<MeaningReference> getMeaningReferences() {
        return this.meaning;
    }

    public void setMeaningReferences(Set<MeaningReference> meaning) {
        this.meaning = meaning;
    }

    public Set<ImpactingProjectsReference> getImpactingProjectsReferences() {
        return this.impactingProjects;
    }

    public void setImpactingProjectsReferences(Set<ImpactingProjectsReference> impactingProjects) {
        this.impactingProjects = impactingProjects;
    }

    public Set<FacetsReference> getFacetsReferences() {
        return this.facets;
    }

    public void setFacetsReferences(Set<FacetsReference> facets) {
        this.facets = facets;
    }

    public Set<LicensesReference> getLicensesReferences() {
        return this.licenses;
    }

    public void setLicensesReferences(Set<LicensesReference> licenses) {
        this.licenses = licenses;
    }

    public Set<ConnectionsReference> getConnectionsReferences() {
        return this.connections;
    }

    public void setConnectionsReferences(Set<ConnectionsReference> connections) {
        this.connections = connections;
    }

    public Set<AlsoKnownAsReference> getAlsoKnownAsReferences() {
        return this.alsoKnownAs;
    }

    public void setAlsoKnownAsReferences(Set<AlsoKnownAsReference> alsoKnownAs) {
        this.alsoKnownAs = alsoKnownAs;
    }

    public Set<LikesReference> getLikesReferences() {
        return this.likes;
    }

    public void setLikesReferences(Set<LikesReference> likes) {
        this.likes = likes;
    }

    public Set<ConsumedByReference> getConsumedByReferences() {
        return this.consumedBy;
    }

    public void setConsumedByReferences(Set<ConsumedByReference> consumedBy) {
        this.consumedBy = consumedBy;
    }

    public Set<NoteLogsReference> getNoteLogsReferences() {
        return this.noteLogs;
    }

    public void setNoteLogsReferences(Set<NoteLogsReference> noteLogs) {
        this.noteLogs = noteLogs;
    }

    public Set<CertificationsReference> getCertificationsReferences() {
        return this.certifications;
    }

    public void setCertificationsReferences(Set<CertificationsReference> certifications) {
        this.certifications = certifications;
    }

    public Set<SupportedDataSetsReference> getSupportedDataSetsReferences() {
        return this.supportedDataSets;
    }

    public void setSupportedDataSetsReferences(Set<SupportedDataSetsReference> supportedDataSets) {
        this.supportedDataSets = supportedDataSets;
    }

    public Set<ManagedResourcesReference> getManagedResourcesReferences() {
        return this.managedResources;
    }

    public void setManagedResourcesReferences(Set<ManagedResourcesReference> managedResources) {
        this.managedResources = managedResources;
    }

    public Set<RelatedMediaReference> getRelatedMediaReferences() {
        return this.relatedMedia;
    }

    public void setRelatedMediaReferences(Set<RelatedMediaReference> relatedMedia) {
        this.relatedMedia = relatedMedia;
    }

    public Set<StarRatingsReference> getStarRatingsReferences() {
        return this.starRatings;
    }

    public void setStarRatingsReferences(Set<StarRatingsReference> starRatings) {
        this.starRatings = starRatings;
    }

    public Set<ExternalReferenceReference> getExternalReferenceReferences() {
        return this.externalReference;
    }

    public void setExternalReferenceReferences(Set<ExternalReferenceReference> externalReference) {
        this.externalReference = externalReference;
    }

    public Set<ActionsReference> getActionsReferences() {
        return this.actions;
    }

    public void setActionsReferences(Set<ActionsReference> actions) {
        this.actions = actions;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("VirtualContainerReferences{");
        sb.append("hostsReference='").append(this.hosts.toString());
        sb.append("networkConnectionsReference='").append(this.networkConnections.toString());
        sb.append("hostClusterReference='").append(this.hostCluster.toString());
        sb.append("locationsReference='").append(this.locations.toString());
        sb.append("hostedContainersReference='").append(this.hostedContainers.toString());
        sb.append("commentsReference='").append(this.comments.toString());
        sb.append("tagsReference='").append(this.tags.toString());
        sb.append("meaningReference='").append(this.meaning.toString());
        sb.append("impactingProjectsReference='").append(this.impactingProjects.toString());
        sb.append("facetsReference='").append(this.facets.toString());
        sb.append("licensesReference='").append(this.licenses.toString());
        sb.append("connectionsReference='").append(this.connections.toString());
        sb.append("alsoKnownAsReference='").append(this.alsoKnownAs.toString());
        sb.append("likesReference='").append(this.likes.toString());
        sb.append("consumedByReference='").append(this.consumedBy.toString());
        sb.append("noteLogsReference='").append(this.noteLogs.toString());
        sb.append("certificationsReference='").append(this.certifications.toString());
        sb.append("supportedDataSetsReference='").append(this.supportedDataSets.toString());
        sb.append("managedResourcesReference='").append(this.managedResources.toString());
        sb.append("relatedMediaReference='").append(this.relatedMedia.toString());
        sb.append("starRatingsReference='").append(this.starRatings.toString());
        sb.append("externalReferenceReference='").append(this.externalReference.toString());
        sb.append("actionsReference='").append(this.actions.toString());
        sb.append("operatingPlatformReference='").append(this.operatingPlatform.toString());
        sb.append("schemaReference='").append(this.schema.toString());
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VirtualContainerReferences typedThat = (VirtualContainerReferences)o;
        if (this.hosts != null && !Objects.equals(this.hosts, typedThat.hosts)) {
            return false;
        }
        if (this.networkConnections != null && !Objects.equals(this.networkConnections, typedThat.networkConnections)) {
            return false;
        }
        if (this.hostCluster != null && !Objects.equals(this.hostCluster, typedThat.hostCluster)) {
            return false;
        }
        if (this.locations != null && !Objects.equals(this.locations, typedThat.locations)) {
            return false;
        }
        if (this.operatingPlatform != null && !Objects.equals(this.operatingPlatform, typedThat.operatingPlatform)) {
            return false;
        }
        if (this.hostedContainers != null && !Objects.equals(this.hostedContainers, typedThat.hostedContainers)) {
            return false;
        }
        if (this.comments != null && !Objects.equals(this.comments, typedThat.comments)) {
            return false;
        }
        if (this.tags != null && !Objects.equals(this.tags, typedThat.tags)) {
            return false;
        }
        if (this.meaning != null && !Objects.equals(this.meaning, typedThat.meaning)) {
            return false;
        }
        if (this.impactingProjects != null && !Objects.equals(this.impactingProjects, typedThat.impactingProjects)) {
            return false;
        }
        if (this.facets != null && !Objects.equals(this.facets, typedThat.facets)) {
            return false;
        }
        if (this.licenses != null && !Objects.equals(this.licenses, typedThat.licenses)) {
            return false;
        }
        if (this.connections != null && !Objects.equals(this.connections, typedThat.connections)) {
            return false;
        }
        if (this.alsoKnownAs != null && !Objects.equals(this.alsoKnownAs, typedThat.alsoKnownAs)) {
            return false;
        }
        if (this.likes != null && !Objects.equals(this.likes, typedThat.likes)) {
            return false;
        }
        if (this.consumedBy != null && !Objects.equals(this.consumedBy, typedThat.consumedBy)) {
            return false;
        }
        if (this.noteLogs != null && !Objects.equals(this.noteLogs, typedThat.noteLogs)) {
            return false;
        }
        if (this.certifications != null && !Objects.equals(this.certifications, typedThat.certifications)) {
            return false;
        }
        if (this.supportedDataSets != null && !Objects.equals(this.supportedDataSets, typedThat.supportedDataSets)) {
            return false;
        }
        if (this.schema != null && !Objects.equals(this.schema, typedThat.schema)) {
            return false;
        }
        if (this.managedResources != null && !Objects.equals(this.managedResources, typedThat.managedResources)) {
            return false;
        }
        if (this.relatedMedia != null && !Objects.equals(this.relatedMedia, typedThat.relatedMedia)) {
            return false;
        }
        if (this.starRatings != null && !Objects.equals(this.starRatings, typedThat.starRatings)) {
            return false;
        }
        if (this.externalReference != null && !Objects.equals(this.externalReference, typedThat.externalReference)) {
            return false;
        }
        if (this.actions != null && !Objects.equals(this.actions, typedThat.actions)) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.hosts, this.networkConnections, this.hostCluster, this.locations, this.operatingPlatform, this.hostedContainers, this.comments, this.tags, this.meaning, this.impactingProjects, this.facets, this.licenses, this.connections, this.alsoKnownAs, this.likes, this.consumedBy, this.noteLogs, this.certifications, this.supportedDataSets, this.schema, this.managedResources, this.relatedMedia, this.starRatings, this.externalReference, this.actions);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

