/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ISARelationship;

import java.util.HashMap;
import java.util.Iterator;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ISARelationship.ISARelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.TermRelationshipStatus;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISARelationshipMapper {
    private static final Logger log = LoggerFactory.getLogger(ISARelationshipMapper.class);
    private static final String className = ISARelationshipMapper.class.getName();

    public static ISARelationship mapOmrsRelationshipToISARelationship(Relationship omrsRelationship) throws InvalidParameterException {
        String methodName = "mapOmrsRelationshipToISARelationship";
        if (!"ISARelationship".equals(omrsRelationship.getType().getTypeDefName())) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.INVALID_RELATIOMSHIP_GUID_WRONG_TYPE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName, omrsRelationship.getGUID(), "TermHASARelationship"});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        ISARelationship iSARelationship = new ISARelationship(omrsRelationship);
        SystemAttributes systemAttributes = new SystemAttributes();
        InstanceStatus instanceStatus = omrsRelationship.getStatus();
        Status omrsBeanStatus = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
        systemAttributes.setStatus(omrsBeanStatus);
        systemAttributes.setCreatedBy(omrsRelationship.getCreatedBy());
        systemAttributes.setUpdatedBy(omrsRelationship.getUpdatedBy());
        systemAttributes.setCreateTime(omrsRelationship.getCreateTime());
        systemAttributes.setUpdateTime(omrsRelationship.getUpdateTime());
        systemAttributes.setVersion(Long.valueOf(omrsRelationship.getVersion()));
        systemAttributes.setGUID(omrsRelationship.getGUID());
        iSARelationship.setGuid(omrsRelationship.getGUID());
        iSARelationship.setSystemAttributes(systemAttributes);
        InstanceProperties omrsRelationshipProperties = omrsRelationship.getProperties();
        if (omrsRelationshipProperties != null) {
            omrsRelationshipProperties.setEffectiveFromTime(iSARelationship.getEffectiveFromTime());
            omrsRelationshipProperties.setEffectiveToTime(iSARelationship.getEffectiveToTime());
            Iterator omrsPropertyIterator = omrsRelationshipProperties.getPropertyNames();
            while (omrsPropertyIterator.hasNext()) {
                String name = (String)omrsPropertyIterator.next();
                InstancePropertyValue value = omrsRelationshipProperties.getPropertyValue(name);
                switch (value.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                        Object actualValue = primitivePropertyValue.getPrimitiveValue();
                        if (ISARelationship.ATTRIBUTE_NAMES_SET.contains(name)) {
                            if (name.equals("description")) {
                                iSARelationship.setDescription((String)actualValue);
                            }
                            if (name.equals("expression")) {
                                iSARelationship.setExpression((String)actualValue);
                            }
                            if (name.equals("steward")) {
                                iSARelationship.setSteward((String)actualValue);
                            }
                            if (!name.equals("source")) break;
                            iSARelationship.setSource((String)actualValue);
                            break;
                        }
                        if (iSARelationship.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            iSARelationship.setExtraAttributes(extraAttributes);
                        }
                        iSARelationship.getExtraAttributes().put(name, primitivePropertyValue);
                        break;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                        String symbolicName = enumPropertyValue.getSymbolicName();
                        if (ISARelationship.ENUM_NAMES_SET.contains(name)) {
                            if (!name.equals("status")) break;
                            TermRelationshipStatus status = TermRelationshipStatus.valueOf((String)symbolicName);
                            iSARelationship.setStatus(status);
                            break;
                        }
                        if (iSARelationship.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            iSARelationship.setExtraAttributes(extraAttributes);
                        }
                        iSARelationship.getExtraAttributes().put(name, enumPropertyValue);
                        break;
                    }
                    case MAP: {
                        if (!ISARelationship.MAP_NAMES_SET.contains(name)) break;
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                        InstanceProperties instanceProperties = mapPropertyValue.getMapValues();
                        break;
                    }
                }
            }
        }
        return iSARelationship;
    }

    public static Relationship mapISARelationshipToOmrsRelationship(ISARelationship iSARelationship) {
        PrimitivePropertyValue primitivePropertyValue;
        Relationship omrsRelationship = Line.createOmrsRelationship((Line)iSARelationship);
        SystemAttributes systemAttributes = iSARelationship.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsRelationship.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsRelationship.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsRelationship.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsRelationship.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsRelationship.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getGUID() != null) {
                omrsRelationship.setGUID(systemAttributes.getGUID());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToInstanceStatus(systemAttributes.getStatus());
                omrsRelationship.setStatus(instanceStatus);
            }
        }
        EntityProxy entityOne = new EntityProxy();
        entityOne.setGUID(iSARelationship.getEntity1Guid());
        String type1 = iSARelationship.getEntity1Type();
        InstanceType instancetype1 = new InstanceType();
        instancetype1.setTypeDefName(type1);
        entityOne.setType(instancetype1);
        EntityProxy entityTwo = new EntityProxy();
        entityTwo.setGUID(iSARelationship.getEntity2Guid());
        String type2 = iSARelationship.getEntity2Type();
        InstanceType instancetype2 = new InstanceType();
        instancetype2.setTypeDefName(type2);
        entityTwo.setType(instancetype2);
        InstanceType relationshipType = new InstanceType();
        relationshipType.setTypeDefGUID(iSARelationship.getTypeDefGuid());
        relationshipType.setTypeDefName("ISARelationship");
        omrsRelationship.setType(relationshipType);
        omrsRelationship.setEntityOneProxy(entityOne);
        omrsRelationship.setEntityTwoProxy(entityTwo);
        if (omrsRelationship.getGUID() == null) {
            omrsRelationship.setGUID(iSARelationship.getGuid());
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        if (iSARelationship.getDescription() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)iSARelationship.getDescription());
            instanceProperties.setProperty("description", (InstancePropertyValue)primitivePropertyValue);
        }
        if (iSARelationship.getExpression() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)iSARelationship.getExpression());
            instanceProperties.setProperty("expression", (InstancePropertyValue)primitivePropertyValue);
        }
        if (iSARelationship.getSteward() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)iSARelationship.getSteward());
            instanceProperties.setProperty("steward", (InstancePropertyValue)primitivePropertyValue);
        }
        if (iSARelationship.getSource() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)iSARelationship.getSource());
            instanceProperties.setProperty("source", (InstancePropertyValue)primitivePropertyValue);
        }
        if (iSARelationship.getStatus() != null) {
            TermRelationshipStatus enumType = iSARelationship.getStatus();
            EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(enumType.ordinal());
            enumPropertyValue.setSymbolicName(enumType.name());
            instanceProperties.setProperty("status", (InstancePropertyValue)enumPropertyValue);
        }
        omrsRelationship.setProperties(instanceProperties);
        return omrsRelationship;
    }
}

