/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LibraryTermReference;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LibraryTermReference.LibraryTermReference;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryTermReferenceMapper {
    private static final Logger log = LoggerFactory.getLogger(LibraryTermReferenceMapper.class);
    private static final String className = LibraryTermReferenceMapper.class.getName();

    public static LibraryTermReference mapOmrsRelationshipToLibraryTermReference(Relationship omrsRelationship) throws InvalidParameterException {
        String methodName = "mapOmrsRelationshipToLibraryTermReference";
        if (!"LibraryTermReference".equals(omrsRelationship.getType().getTypeDefName())) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.INVALID_RELATIOMSHIP_GUID_WRONG_TYPE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName, omrsRelationship.getGUID(), "TermHASARelationship"});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        LibraryTermReference libraryTermReference = new LibraryTermReference(omrsRelationship);
        SystemAttributes systemAttributes = new SystemAttributes();
        InstanceStatus instanceStatus = omrsRelationship.getStatus();
        Status omrsBeanStatus = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
        systemAttributes.setStatus(omrsBeanStatus);
        systemAttributes.setCreatedBy(omrsRelationship.getCreatedBy());
        systemAttributes.setUpdatedBy(omrsRelationship.getUpdatedBy());
        systemAttributes.setCreateTime(omrsRelationship.getCreateTime());
        systemAttributes.setUpdateTime(omrsRelationship.getUpdateTime());
        systemAttributes.setVersion(Long.valueOf(omrsRelationship.getVersion()));
        systemAttributes.setGUID(omrsRelationship.getGUID());
        libraryTermReference.setGuid(omrsRelationship.getGUID());
        libraryTermReference.setSystemAttributes(systemAttributes);
        InstanceProperties omrsRelationshipProperties = omrsRelationship.getProperties();
        if (omrsRelationshipProperties != null) {
            omrsRelationshipProperties.setEffectiveFromTime(libraryTermReference.getEffectiveFromTime());
            omrsRelationshipProperties.setEffectiveToTime(libraryTermReference.getEffectiveToTime());
            Iterator omrsPropertyIterator = omrsRelationshipProperties.getPropertyNames();
            while (omrsPropertyIterator.hasNext()) {
                String name = (String)omrsPropertyIterator.next();
                InstancePropertyValue value = omrsRelationshipProperties.getPropertyValue(name);
                switch (value.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                        Object actualValue = primitivePropertyValue.getPrimitiveValue();
                        if (LibraryTermReference.ATTRIBUTE_NAMES_SET.contains(name)) {
                            if (name.equals("identifier")) {
                                libraryTermReference.setIdentifier((String)actualValue);
                            }
                            if (name.equals("description")) {
                                libraryTermReference.setDescription((String)actualValue);
                            }
                            if (name.equals("steward")) {
                                libraryTermReference.setSteward((String)actualValue);
                            }
                            if (!name.equals("lastVerified")) break;
                            libraryTermReference.setLastVerified((Date)actualValue);
                            break;
                        }
                        if (libraryTermReference.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            libraryTermReference.setExtraAttributes(extraAttributes);
                        }
                        libraryTermReference.getExtraAttributes().put(name, primitivePropertyValue);
                        break;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                        String symbolicName = enumPropertyValue.getSymbolicName();
                        if (LibraryTermReference.ENUM_NAMES_SET.contains(name)) break;
                        if (libraryTermReference.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            libraryTermReference.setExtraAttributes(extraAttributes);
                        }
                        libraryTermReference.getExtraAttributes().put(name, enumPropertyValue);
                        break;
                    }
                    case MAP: {
                        if (!LibraryTermReference.MAP_NAMES_SET.contains(name)) break;
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                        InstanceProperties instanceProperties = mapPropertyValue.getMapValues();
                        break;
                    }
                }
            }
        }
        return libraryTermReference;
    }

    public static Relationship mapLibraryTermReferenceToOmrsRelationship(LibraryTermReference libraryTermReference) {
        PrimitivePropertyValue primitivePropertyValue;
        Relationship omrsRelationship = Line.createOmrsRelationship((Line)libraryTermReference);
        SystemAttributes systemAttributes = libraryTermReference.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsRelationship.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsRelationship.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsRelationship.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsRelationship.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsRelationship.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getGUID() != null) {
                omrsRelationship.setGUID(systemAttributes.getGUID());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToInstanceStatus(systemAttributes.getStatus());
                omrsRelationship.setStatus(instanceStatus);
            }
        }
        EntityProxy entityOne = new EntityProxy();
        entityOne.setGUID(libraryTermReference.getEntity1Guid());
        String type1 = libraryTermReference.getEntity1Type();
        InstanceType instancetype1 = new InstanceType();
        instancetype1.setTypeDefName(type1);
        entityOne.setType(instancetype1);
        EntityProxy entityTwo = new EntityProxy();
        entityTwo.setGUID(libraryTermReference.getEntity2Guid());
        String type2 = libraryTermReference.getEntity2Type();
        InstanceType instancetype2 = new InstanceType();
        instancetype2.setTypeDefName(type2);
        entityTwo.setType(instancetype2);
        InstanceType relationshipType = new InstanceType();
        relationshipType.setTypeDefGUID(libraryTermReference.getTypeDefGuid());
        relationshipType.setTypeDefName("LibraryTermReference");
        omrsRelationship.setType(relationshipType);
        omrsRelationship.setEntityOneProxy(entityOne);
        omrsRelationship.setEntityTwoProxy(entityTwo);
        if (omrsRelationship.getGUID() == null) {
            omrsRelationship.setGUID(libraryTermReference.getGuid());
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        if (libraryTermReference.getIdentifier() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)libraryTermReference.getIdentifier());
            instanceProperties.setProperty("identifier", (InstancePropertyValue)primitivePropertyValue);
        }
        if (libraryTermReference.getDescription() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)libraryTermReference.getDescription());
            instanceProperties.setProperty("description", (InstancePropertyValue)primitivePropertyValue);
        }
        if (libraryTermReference.getSteward() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)libraryTermReference.getSteward());
            instanceProperties.setProperty("steward", (InstancePropertyValue)primitivePropertyValue);
        }
        if (libraryTermReference.getLastVerified() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
            primitivePropertyValue.setPrimitiveValue((Object)libraryTermReference.getLastVerified());
            instanceProperties.setProperty("lastVerified", (InstancePropertyValue)primitivePropertyValue);
        }
        omrsRelationship.setProperties(instanceProperties);
        return omrsRelationship;
    }
}

