/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.License;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.License.License;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseMapper {
    private static final Logger log = LoggerFactory.getLogger(LicenseMapper.class);
    private static final String className = LicenseMapper.class.getName();

    public static License mapOmrsRelationshipToLicense(Relationship omrsRelationship) throws InvalidParameterException {
        String methodName = "mapOmrsRelationshipToLicense";
        if (!"License".equals(omrsRelationship.getType().getTypeDefName())) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.INVALID_RELATIOMSHIP_GUID_WRONG_TYPE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName, omrsRelationship.getGUID(), "TermHASARelationship"});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        License license = new License(omrsRelationship);
        SystemAttributes systemAttributes = new SystemAttributes();
        InstanceStatus instanceStatus = omrsRelationship.getStatus();
        Status omrsBeanStatus = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
        systemAttributes.setStatus(omrsBeanStatus);
        systemAttributes.setCreatedBy(omrsRelationship.getCreatedBy());
        systemAttributes.setUpdatedBy(omrsRelationship.getUpdatedBy());
        systemAttributes.setCreateTime(omrsRelationship.getCreateTime());
        systemAttributes.setUpdateTime(omrsRelationship.getUpdateTime());
        systemAttributes.setVersion(Long.valueOf(omrsRelationship.getVersion()));
        systemAttributes.setGUID(omrsRelationship.getGUID());
        license.setGuid(omrsRelationship.getGUID());
        license.setSystemAttributes(systemAttributes);
        InstanceProperties omrsRelationshipProperties = omrsRelationship.getProperties();
        if (omrsRelationshipProperties != null) {
            omrsRelationshipProperties.setEffectiveFromTime(license.getEffectiveFromTime());
            omrsRelationshipProperties.setEffectiveToTime(license.getEffectiveToTime());
            Iterator omrsPropertyIterator = omrsRelationshipProperties.getPropertyNames();
            while (omrsPropertyIterator.hasNext()) {
                String name = (String)omrsPropertyIterator.next();
                InstancePropertyValue value = omrsRelationshipProperties.getPropertyValue(name);
                switch (value.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                        Object actualValue = primitivePropertyValue.getPrimitiveValue();
                        if (License.ATTRIBUTE_NAMES_SET.contains(name)) {
                            if (name.equals("licenseGUID")) {
                                license.setLicenseGUID((String)actualValue);
                            }
                            if (name.equals("start")) {
                                license.setStart((Date)actualValue);
                            }
                            if (name.equals("end")) {
                                license.setEnd((Date)actualValue);
                            }
                            if (name.equals("conditions")) {
                                license.setConditions((String)actualValue);
                            }
                            if (name.equals("licensedBy")) {
                                license.setLicensedBy((String)actualValue);
                            }
                            if (name.equals("custodian")) {
                                license.setCustodian((String)actualValue);
                            }
                            if (name.equals("licensee")) {
                                license.setLicensee((String)actualValue);
                            }
                            if (!name.equals("notes")) break;
                            license.setNotes((String)actualValue);
                            break;
                        }
                        if (license.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            license.setExtraAttributes(extraAttributes);
                        }
                        license.getExtraAttributes().put(name, primitivePropertyValue);
                        break;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                        String symbolicName = enumPropertyValue.getSymbolicName();
                        if (License.ENUM_NAMES_SET.contains(name)) break;
                        if (license.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            license.setExtraAttributes(extraAttributes);
                        }
                        license.getExtraAttributes().put(name, enumPropertyValue);
                        break;
                    }
                    case MAP: {
                        if (!License.MAP_NAMES_SET.contains(name)) break;
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                        InstanceProperties instanceProperties = mapPropertyValue.getMapValues();
                        break;
                    }
                }
            }
        }
        return license;
    }

    public static Relationship mapLicenseToOmrsRelationship(License license) {
        PrimitivePropertyValue primitivePropertyValue;
        Relationship omrsRelationship = Line.createOmrsRelationship((Line)license);
        SystemAttributes systemAttributes = license.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsRelationship.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsRelationship.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsRelationship.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsRelationship.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsRelationship.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getGUID() != null) {
                omrsRelationship.setGUID(systemAttributes.getGUID());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToInstanceStatus(systemAttributes.getStatus());
                omrsRelationship.setStatus(instanceStatus);
            }
        }
        EntityProxy entityOne = new EntityProxy();
        entityOne.setGUID(license.getEntity1Guid());
        String type1 = license.getEntity1Type();
        InstanceType instancetype1 = new InstanceType();
        instancetype1.setTypeDefName(type1);
        entityOne.setType(instancetype1);
        EntityProxy entityTwo = new EntityProxy();
        entityTwo.setGUID(license.getEntity2Guid());
        String type2 = license.getEntity2Type();
        InstanceType instancetype2 = new InstanceType();
        instancetype2.setTypeDefName(type2);
        entityTwo.setType(instancetype2);
        InstanceType relationshipType = new InstanceType();
        relationshipType.setTypeDefGUID(license.getTypeDefGuid());
        relationshipType.setTypeDefName("License");
        omrsRelationship.setType(relationshipType);
        omrsRelationship.setEntityOneProxy(entityOne);
        omrsRelationship.setEntityTwoProxy(entityTwo);
        if (omrsRelationship.getGUID() == null) {
            omrsRelationship.setGUID(license.getGuid());
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        if (license.getLicenseGUID() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)license.getLicenseGUID());
            instanceProperties.setProperty("licenseGUID", (InstancePropertyValue)primitivePropertyValue);
        }
        if (license.getStart() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
            primitivePropertyValue.setPrimitiveValue((Object)license.getStart());
            instanceProperties.setProperty("start", (InstancePropertyValue)primitivePropertyValue);
        }
        if (license.getEnd() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
            primitivePropertyValue.setPrimitiveValue((Object)license.getEnd());
            instanceProperties.setProperty("end", (InstancePropertyValue)primitivePropertyValue);
        }
        if (license.getConditions() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)license.getConditions());
            instanceProperties.setProperty("conditions", (InstancePropertyValue)primitivePropertyValue);
        }
        if (license.getLicensedBy() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)license.getLicensedBy());
            instanceProperties.setProperty("licensedBy", (InstancePropertyValue)primitivePropertyValue);
        }
        if (license.getCustodian() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)license.getCustodian());
            instanceProperties.setProperty("custodian", (InstancePropertyValue)primitivePropertyValue);
        }
        if (license.getLicensee() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)license.getLicensee());
            instanceProperties.setProperty("licensee", (InstancePropertyValue)primitivePropertyValue);
        }
        if (license.getNotes() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)license.getNotes());
            instanceProperties.setProperty("notes", (InstancePropertyValue)primitivePropertyValue);
        }
        omrsRelationship.setProperties(instanceProperties);
        return omrsRelationship;
    }
}

