/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermISATypeOFRelationship;

import java.util.HashMap;
import java.util.Iterator;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermISATypeOFRelationship.TermISATypeOFRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.TermRelationshipStatus;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermISATypeOFRelationshipMapper {
    private static final Logger log = LoggerFactory.getLogger(TermISATypeOFRelationshipMapper.class);
    private static final String className = TermISATypeOFRelationshipMapper.class.getName();

    public static TermISATypeOFRelationship mapOmrsRelationshipToTermISATypeOFRelationship(Relationship omrsRelationship) throws InvalidParameterException {
        String methodName = "mapOmrsRelationshipToTermISATypeOFRelationship";
        if (!"TermISATypeOFRelationship".equals(omrsRelationship.getType().getTypeDefName())) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.INVALID_RELATIOMSHIP_GUID_WRONG_TYPE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName, omrsRelationship.getGUID(), "TermHASARelationship"});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        TermISATypeOFRelationship termISATypeOFRelationship = new TermISATypeOFRelationship(omrsRelationship);
        SystemAttributes systemAttributes = new SystemAttributes();
        InstanceStatus instanceStatus = omrsRelationship.getStatus();
        Status omrsBeanStatus = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
        systemAttributes.setStatus(omrsBeanStatus);
        systemAttributes.setCreatedBy(omrsRelationship.getCreatedBy());
        systemAttributes.setUpdatedBy(omrsRelationship.getUpdatedBy());
        systemAttributes.setCreateTime(omrsRelationship.getCreateTime());
        systemAttributes.setUpdateTime(omrsRelationship.getUpdateTime());
        systemAttributes.setVersion(Long.valueOf(omrsRelationship.getVersion()));
        systemAttributes.setGUID(omrsRelationship.getGUID());
        termISATypeOFRelationship.setGuid(omrsRelationship.getGUID());
        termISATypeOFRelationship.setSystemAttributes(systemAttributes);
        InstanceProperties omrsRelationshipProperties = omrsRelationship.getProperties();
        if (omrsRelationshipProperties != null) {
            omrsRelationshipProperties.setEffectiveFromTime(termISATypeOFRelationship.getEffectiveFromTime());
            omrsRelationshipProperties.setEffectiveToTime(termISATypeOFRelationship.getEffectiveToTime());
            Iterator omrsPropertyIterator = omrsRelationshipProperties.getPropertyNames();
            while (omrsPropertyIterator.hasNext()) {
                String name = (String)omrsPropertyIterator.next();
                InstancePropertyValue value = omrsRelationshipProperties.getPropertyValue(name);
                switch (value.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                        Object actualValue = primitivePropertyValue.getPrimitiveValue();
                        if (TermISATypeOFRelationship.ATTRIBUTE_NAMES_SET.contains(name)) {
                            if (name.equals("description")) {
                                termISATypeOFRelationship.setDescription((String)actualValue);
                            }
                            if (name.equals("steward")) {
                                termISATypeOFRelationship.setSteward((String)actualValue);
                            }
                            if (!name.equals("source")) break;
                            termISATypeOFRelationship.setSource((String)actualValue);
                            break;
                        }
                        if (termISATypeOFRelationship.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            termISATypeOFRelationship.setExtraAttributes(extraAttributes);
                        }
                        termISATypeOFRelationship.getExtraAttributes().put(name, primitivePropertyValue);
                        break;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                        String symbolicName = enumPropertyValue.getSymbolicName();
                        if (TermISATypeOFRelationship.ENUM_NAMES_SET.contains(name)) {
                            if (!name.equals("status")) break;
                            TermRelationshipStatus status = TermRelationshipStatus.valueOf((String)symbolicName);
                            termISATypeOFRelationship.setStatus(status);
                            break;
                        }
                        if (termISATypeOFRelationship.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            termISATypeOFRelationship.setExtraAttributes(extraAttributes);
                        }
                        termISATypeOFRelationship.getExtraAttributes().put(name, enumPropertyValue);
                        break;
                    }
                    case MAP: {
                        if (!TermISATypeOFRelationship.MAP_NAMES_SET.contains(name)) break;
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                        InstanceProperties instanceProperties = mapPropertyValue.getMapValues();
                        break;
                    }
                }
            }
        }
        return termISATypeOFRelationship;
    }

    public static Relationship mapTermISATypeOFRelationshipToOmrsRelationship(TermISATypeOFRelationship termISATypeOFRelationship) {
        PrimitivePropertyValue primitivePropertyValue;
        Relationship omrsRelationship = Line.createOmrsRelationship((Line)termISATypeOFRelationship);
        SystemAttributes systemAttributes = termISATypeOFRelationship.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsRelationship.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsRelationship.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsRelationship.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsRelationship.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsRelationship.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getGUID() != null) {
                omrsRelationship.setGUID(systemAttributes.getGUID());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToInstanceStatus(systemAttributes.getStatus());
                omrsRelationship.setStatus(instanceStatus);
            }
        }
        EntityProxy entityOne = new EntityProxy();
        entityOne.setGUID(termISATypeOFRelationship.getEntity1Guid());
        String type1 = termISATypeOFRelationship.getEntity1Type();
        InstanceType instancetype1 = new InstanceType();
        instancetype1.setTypeDefName(type1);
        entityOne.setType(instancetype1);
        EntityProxy entityTwo = new EntityProxy();
        entityTwo.setGUID(termISATypeOFRelationship.getEntity2Guid());
        String type2 = termISATypeOFRelationship.getEntity2Type();
        InstanceType instancetype2 = new InstanceType();
        instancetype2.setTypeDefName(type2);
        entityTwo.setType(instancetype2);
        InstanceType relationshipType = new InstanceType();
        relationshipType.setTypeDefGUID(termISATypeOFRelationship.getTypeDefGuid());
        relationshipType.setTypeDefName("TermISATypeOFRelationship");
        omrsRelationship.setType(relationshipType);
        omrsRelationship.setEntityOneProxy(entityOne);
        omrsRelationship.setEntityTwoProxy(entityTwo);
        if (omrsRelationship.getGUID() == null) {
            omrsRelationship.setGUID(termISATypeOFRelationship.getGuid());
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        if (termISATypeOFRelationship.getDescription() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)termISATypeOFRelationship.getDescription());
            instanceProperties.setProperty("description", (InstancePropertyValue)primitivePropertyValue);
        }
        if (termISATypeOFRelationship.getSteward() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)termISATypeOFRelationship.getSteward());
            instanceProperties.setProperty("steward", (InstancePropertyValue)primitivePropertyValue);
        }
        if (termISATypeOFRelationship.getSource() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)termISATypeOFRelationship.getSource());
            instanceProperties.setProperty("source", (InstancePropertyValue)primitivePropertyValue);
        }
        if (termISATypeOFRelationship.getStatus() != null) {
            TermRelationshipStatus enumType = termISATypeOFRelationship.getStatus();
            EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(enumType.ordinal());
            enumPropertyValue.setSymbolicName(enumType.name());
            instanceProperties.setProperty("status", (InstancePropertyValue)enumPropertyValue);
        }
        omrsRelationship.setProperties(instanceProperties);
        return omrsRelationship;
    }
}

