/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoSource;

import java.util.HashMap;
import java.util.Iterator;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoSource.ToDoSource;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToDoSourceMapper {
    private static final Logger log = LoggerFactory.getLogger(ToDoSourceMapper.class);
    private static final String className = ToDoSourceMapper.class.getName();

    public static ToDoSource mapOmrsRelationshipToToDoSource(Relationship omrsRelationship) throws InvalidParameterException {
        String methodName = "mapOmrsRelationshipToToDoSource";
        if (!"ToDoSource".equals(omrsRelationship.getType().getTypeDefName())) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.INVALID_RELATIOMSHIP_GUID_WRONG_TYPE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName, omrsRelationship.getGUID(), "TermHASARelationship"});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        ToDoSource toDoSource = new ToDoSource(omrsRelationship);
        SystemAttributes systemAttributes = new SystemAttributes();
        InstanceStatus instanceStatus = omrsRelationship.getStatus();
        Status omrsBeanStatus = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
        systemAttributes.setStatus(omrsBeanStatus);
        systemAttributes.setCreatedBy(omrsRelationship.getCreatedBy());
        systemAttributes.setUpdatedBy(omrsRelationship.getUpdatedBy());
        systemAttributes.setCreateTime(omrsRelationship.getCreateTime());
        systemAttributes.setUpdateTime(omrsRelationship.getUpdateTime());
        systemAttributes.setVersion(Long.valueOf(omrsRelationship.getVersion()));
        systemAttributes.setGUID(omrsRelationship.getGUID());
        toDoSource.setGuid(omrsRelationship.getGUID());
        toDoSource.setSystemAttributes(systemAttributes);
        InstanceProperties omrsRelationshipProperties = omrsRelationship.getProperties();
        if (omrsRelationshipProperties != null) {
            omrsRelationshipProperties.setEffectiveFromTime(toDoSource.getEffectiveFromTime());
            omrsRelationshipProperties.setEffectiveToTime(toDoSource.getEffectiveToTime());
            Iterator omrsPropertyIterator = omrsRelationshipProperties.getPropertyNames();
            while (omrsPropertyIterator.hasNext()) {
                String name = (String)omrsPropertyIterator.next();
                InstancePropertyValue value = omrsRelationshipProperties.getPropertyValue(name);
                switch (value.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                        Object actualValue = primitivePropertyValue.getPrimitiveValue();
                        if (ToDoSource.ATTRIBUTE_NAMES_SET.contains(name)) break;
                        if (toDoSource.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            toDoSource.setExtraAttributes(extraAttributes);
                        }
                        toDoSource.getExtraAttributes().put(name, primitivePropertyValue);
                        break;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                        String symbolicName = enumPropertyValue.getSymbolicName();
                        if (ToDoSource.ENUM_NAMES_SET.contains(name)) break;
                        if (toDoSource.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            toDoSource.setExtraAttributes(extraAttributes);
                        }
                        toDoSource.getExtraAttributes().put(name, enumPropertyValue);
                        break;
                    }
                    case MAP: {
                        if (!ToDoSource.MAP_NAMES_SET.contains(name)) break;
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                        InstanceProperties instanceProperties = mapPropertyValue.getMapValues();
                        break;
                    }
                }
            }
        }
        return toDoSource;
    }

    public static Relationship mapToDoSourceToOmrsRelationship(ToDoSource toDoSource) {
        Relationship omrsRelationship = Line.createOmrsRelationship((Line)toDoSource);
        SystemAttributes systemAttributes = toDoSource.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsRelationship.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsRelationship.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsRelationship.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsRelationship.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsRelationship.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getGUID() != null) {
                omrsRelationship.setGUID(systemAttributes.getGUID());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToInstanceStatus(systemAttributes.getStatus());
                omrsRelationship.setStatus(instanceStatus);
            }
        }
        EntityProxy entityOne = new EntityProxy();
        entityOne.setGUID(toDoSource.getEntity1Guid());
        String type1 = toDoSource.getEntity1Type();
        InstanceType instancetype1 = new InstanceType();
        instancetype1.setTypeDefName(type1);
        entityOne.setType(instancetype1);
        EntityProxy entityTwo = new EntityProxy();
        entityTwo.setGUID(toDoSource.getEntity2Guid());
        String type2 = toDoSource.getEntity2Type();
        InstanceType instancetype2 = new InstanceType();
        instancetype2.setTypeDefName(type2);
        entityTwo.setType(instancetype2);
        InstanceType relationshipType = new InstanceType();
        relationshipType.setTypeDefGUID(toDoSource.getTypeDefGuid());
        relationshipType.setTypeDefName("ToDoSource");
        omrsRelationship.setType(relationshipType);
        omrsRelationship.setEntityOneProxy(entityOne);
        omrsRelationship.setEntityTwoProxy(entityTwo);
        if (omrsRelationship.getGUID() == null) {
            omrsRelationship.setGUID(toDoSource.getGuid());
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        omrsRelationship.setProperties(instanceProperties);
        return omrsRelationship;
    }
}

