/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.server;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.subjectarea.constraints.SubjectAreaConstraint;
import org.odpi.openmetadata.accessservices.subjectarea.constraints.SubjectAreaConstraintsFactory;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.RelationshipNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.APIOperation.APIOperation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.APIOperation.APIOperationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.APISchemaType.APISchemaType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.APISchemaType.APISchemaTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ActorProfile.ActorProfile;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ActorProfile.ActorProfileMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Application.Application;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Application.ApplicationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Asset.Asset;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Asset.AssetMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.BusinessCapability.BusinessCapability;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.BusinessCapability.BusinessCapabilityMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.CertificationType.CertificationType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.CertificationType.CertificationTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.CohortMember.CohortMember;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.CohortMember.CohortMemberMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Collection.Collection;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Collection.CollectionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Comment.Comment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Comment.CommentMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Community.Community;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Community.CommunityMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.CommunityMember.CommunityMember;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.CommunityMember.CommunityMemberMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ComplexSchemaType.ComplexSchemaType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ComplexSchemaType.ComplexSchemaTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Connection.Connection;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Connection.ConnectionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ConnectorType.ConnectorType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ConnectorType.ConnectorTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ContactDetails.ContactDetails;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ContactDetails.ContactDetailsMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DataFile.DataFile;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DataFile.DataFileMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DataSet.DataSet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DataSet.DataSetMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DeployedAPI.DeployedAPI;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DeployedAPI.DeployedAPIMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DeployedSoftwareComponent.DeployedSoftwareComponent;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DeployedSoftwareComponent.DeployedSoftwareComponentMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DerivedSchemaAttribute.DerivedSchemaAttribute;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.DerivedSchemaAttribute.DerivedSchemaAttributeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Endpoint.Endpoint;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Endpoint.EndpointMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ExternalGlossaryLink.ExternalGlossaryLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ExternalGlossaryLink.ExternalGlossaryLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ExternalId.ExternalId;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ExternalId.ExternalIdMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ExternalReference.ExternalReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ExternalReference.ExternalReferenceMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.FileFolder.FileFolder;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.FileFolder.FileFolderMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.GlossaryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryCategory.GlossaryCategory;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryCategory.GlossaryCategoryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryTerm.GlossaryTerm;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryTerm.GlossaryTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceControl.GovernanceControl;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceControl.GovernanceControlMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceDefinition.GovernanceDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceDefinition.GovernanceDefinitionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceDriver.GovernanceDriver;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceDriver.GovernanceDriverMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceMetric.GovernanceMetric;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceMetric.GovernanceMetricMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernancePolicy.GovernancePolicy;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernancePolicy.GovernancePolicyMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceProcess.GovernanceProcess;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceProcess.GovernanceProcessMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceResponsibility.GovernanceResponsibility;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceResponsibility.GovernanceResponsibilityMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceRule.GovernanceRule;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceRule.GovernanceRuleMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceZone.GovernanceZone;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceZone.GovernanceZoneMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GraphEdge.GraphEdge;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GraphEdge.GraphEdgeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GraphVertex.GraphVertex;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GraphVertex.GraphVertexMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Host.Host;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Host.HostMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.HostCluster.HostCluster;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.HostCluster.HostClusterMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ImplementationSnippet.ImplementationSnippet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ImplementationSnippet.ImplementationSnippetMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.InformalTag.InformalTag;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.InformalTag.InformalTagMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.LicenseType.LicenseType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.LicenseType.LicenseTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Like.Like;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Like.LikeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Location.Location;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Location.LocationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MapSchemaType.MapSchemaType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MapSchemaType.MapSchemaTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MediaCollection.MediaCollection;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MediaCollection.MediaCollectionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MediaFile.MediaFile;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MediaFile.MediaFileMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Meeting.Meeting;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Meeting.MeetingMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MetadataCollection.MetadataCollection;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MetadataCollection.MetadataCollectionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MetadataRepositoryCohort.MetadataRepositoryCohort;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MetadataRepositoryCohort.MetadataRepositoryCohortMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Network.Network;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Network.NetworkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.NetworkGateway.NetworkGateway;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.NetworkGateway.NetworkGatewayMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.NoteEntry.NoteEntry;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.NoteEntry.NoteEntryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.NoteLog.NoteLog;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.NoteLog.NoteLogMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.OperatingPlatform.OperatingPlatform;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.OperatingPlatform.OperatingPlatformMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Person.Person;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Person.PersonMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Process.Process;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Process.ProcessMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Project.ProjectMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ProjectCharter.ProjectCharter;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ProjectCharter.ProjectCharterMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.PropertyFacet.PropertyFacet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.PropertyFacet.PropertyFacetMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Rating.Rating;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Rating.RatingMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Referenceable.Referenceable;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Referenceable.ReferenceableMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Regulation.Regulation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Regulation.RegulationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.RelatedMedia.RelatedMedia;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.RelatedMedia.RelatedMediaMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SchemaAttribute.SchemaAttribute;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SchemaAttribute.SchemaAttributeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SchemaLinkElement.SchemaLinkElement;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SchemaLinkElement.SchemaLinkElementMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SchemaType.SchemaType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SchemaType.SchemaTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SoftwareServer.SoftwareServer;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SoftwareServer.SoftwareServerMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SoftwareServerCapability.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SoftwareServerCapability.SoftwareServerCapabilityMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SoftwareServerPlatform.SoftwareServerPlatform;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SoftwareServerPlatform.SoftwareServerPlatformMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SubscriberList.SubscriberList;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.SubscriberList.SubscriberListMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Team.Team;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Team.TeamMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ToDo.ToDo;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.ToDo.ToDoMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Topic.Topic;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Topic.TopicMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.UserIdentity.UserIdentity;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.UserIdentity.UserIdentityMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.VirtualConnection.VirtualConnection;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.VirtualConnection.VirtualConnectionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.VirtualContainer.VirtualContainer;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.VirtualContainer.VirtualContainerMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIEndpoint.APIEndpoint;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIEndpoint.APIEndpointMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIHeader.APIHeader;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIHeader.APIHeaderMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIOperations.APIOperations;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIOperations.APIOperationsMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIRequest.APIRequest;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIRequest.APIRequestMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIResponse.APIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.APIResponse.APIResponseMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AcceptedAnswer.AcceptedAnswer;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AcceptedAnswer.AcceptedAnswerMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AdjacentLocation.AdjacentLocation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AdjacentLocation.AdjacentLocationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Antonym.Antonym;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Antonym.AntonymMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetLocation.AssetLocation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetLocation.AssetLocationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetSchemaType.AssetSchemaType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetSchemaType.AssetSchemaTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetServerUse.AssetServerUse;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetServerUse.AssetServerUseMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedComment.AttachedComment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedComment.AttachedCommentMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedLike.AttachedLike;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedLike.AttachedLikeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedNoteLog.AttachedNoteLog;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedNoteLog.AttachedNoteLogMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedNoteLogEntry.AttachedNoteLogEntry;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedNoteLogEntry.AttachedNoteLogEntryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedRating.AttachedRating;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedRating.AttachedRatingMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedTag.AttachedTag;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedTag.AttachedTagMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttributeForSchema.AttributeForSchema;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttributeForSchema.AttributeForSchemaMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CategoryAnchor.CategoryAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CategoryAnchor.CategoryAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CategoryHierarchyLink.CategoryHierarchyLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CategoryHierarchyLink.CategoryHierarchyLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Certification.Certification;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Certification.CertificationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CohortMemberMetadataCollection.CohortMemberMetadataCollection;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CohortMemberMetadataCollection.CohortMemberMetadataCollectionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CommunityMembership.CommunityMembership;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CommunityMembership.CommunityMembershipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionConnectorType.ConnectionConnectorType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionConnectorType.ConnectionConnectorTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionEndpoint.ConnectionEndpoint;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionEndpoint.ConnectionEndpointMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionToAsset.ConnectionToAsset;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionToAsset.ConnectionToAssetMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ContactThrough.ContactThrough;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ContactThrough.ContactThroughMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.DataContentForDataSet.DataContentForDataSet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.DataContentForDataSet.DataContentForDataSetMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.DeployedVirtualContainer.DeployedVirtualContainer;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.DeployedVirtualContainer.DeployedVirtualContainerMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.EmbeddedConnection.EmbeddedConnection;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.EmbeddedConnection.EmbeddedConnectionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdLink.ExternalIdLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdLink.ExternalIdLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdScope.ExternalIdScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdScope.ExternalIdScopeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalReferenceLink.ExternalReferenceLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalReferenceLink.ExternalReferenceLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternallySourcedGlossary.ExternallySourcedGlossary;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternallySourcedGlossary.ExternallySourcedGlossaryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.FolderHierarchy.FolderHierarchy;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.FolderHierarchy.FolderHierarchyMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceControlLink.GovernanceControlLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceControlLink.GovernanceControlLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceDefinitionMetric.GovernanceDefinitionMetric;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceDefinitionMetric.GovernanceDefinitionMetricMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceImplementation.GovernanceImplementation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceImplementation.GovernanceImplementationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernancePolicyLink.GovernancePolicyLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernancePolicyLink.GovernancePolicyLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceProcessImplementation.GovernanceProcessImplementation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceProcessImplementation.GovernanceProcessImplementationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceResponse.GovernanceResponse;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceResponse.GovernanceResponseMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceResults.GovernanceResults;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceResults.GovernanceResultsMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceRuleImplementation.GovernanceRuleImplementation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceRuleImplementation.GovernanceRuleImplementationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GraphEdgeLink.GraphEdgeLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GraphEdgeLink.GraphEdgeLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GroupedMedia.GroupedMedia;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GroupedMedia.GroupedMediaMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostClusterMember.HostClusterMember;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostClusterMember.HostClusterMemberMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostLocation.HostLocation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostLocation.HostLocationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostNetwork.HostNetwork;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostNetwork.HostNetworkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostOperatingPlatform.HostOperatingPlatform;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostOperatingPlatform.HostOperatingPlatformMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ISARelationship.ISARelationship;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ISARelationship.ISARelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LibraryCategoryReference.LibraryCategoryReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LibraryCategoryReference.LibraryCategoryReferenceMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LibraryTermReference.LibraryTermReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LibraryTermReference.LibraryTermReferenceMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.License.License;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.License.LicenseMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LinkedFile.LinkedFile;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LinkedFile.LinkedFileMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LinkedMedia.LinkedMedia;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LinkedMedia.LinkedMediaMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LinkedType.LinkedType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.LinkedType.LinkedTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MapFromElementType.MapFromElementType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MapFromElementType.MapFromElementTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MapToElementType.MapToElementType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MapToElementType.MapToElementTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MediaReference.MediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MediaReference.MediaReferenceMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MetadataCohortPeer.MetadataCohortPeer;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MetadataCohortPeer.MetadataCohortPeerMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.NestedFile.NestedFile;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.NestedFile.NestedFileMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.NestedLocation.NestedLocation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.NestedLocation.NestedLocationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.NetworkGatewayLink.NetworkGatewayLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.NetworkGatewayLink.NetworkGatewayLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.OMRSRelationshipToLines;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.OrganizationalCapability.OrganizationalCapability;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.OrganizationalCapability.OrganizationalCapabilityMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Peer.Peer;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Peer.PeerMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.PreferredTerm.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.PreferredTerm.PreferredTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProcessInput.ProcessInput;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProcessInput.ProcessInputMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProcessOutput.ProcessOutput;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProcessOutput.ProcessOutputMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProfileIdentity.ProfileIdentity;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProfileIdentity.ProfileIdentityMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectCharterLink.ProjectCharterLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectCharterLink.ProjectCharterLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectDependency.ProjectDependency;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectDependency.ProjectDependencyMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectHierarchy.ProjectHierarchy;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectHierarchy.ProjectHierarchyMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectScope.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectScope.ProjectScopeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectTeam.ProjectTeam;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectTeam.ProjectTeamMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReferenceableFacet.ReferenceableFacet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReferenceableFacet.ReferenceableFacetMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RegulationCertificationType.RegulationCertificationType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RegulationCertificationType.RegulationCertificationTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RelatedTerm.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RelatedTerm.RelatedTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReplacementTerm.ReplacementTerm;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReplacementTerm.ReplacementTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ResponsibilityStaffContact.ResponsibilityStaffContact;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ResponsibilityStaffContact.ResponsibilityStaffContactMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RuntimeForProcess.RuntimeForProcess;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RuntimeForProcess.RuntimeForProcessMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaAttributeType.SchemaAttributeType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaAttributeType.SchemaAttributeTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaLinkToType.SchemaLinkToType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaLinkToType.SchemaLinkToTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaQueryImplementation.SchemaQueryImplementation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaQueryImplementation.SchemaQueryImplementationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaTypeImplementation.SchemaTypeImplementation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SchemaTypeImplementation.SchemaTypeImplementationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SemanticAssignment.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SemanticAssignment.SemanticAssignmentMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ServerEndpoint.ServerEndpoint;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ServerEndpoint.ServerEndpointMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Synonym.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Synonym.SynonymMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermAnchor.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermAnchor.TermAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermCategorization.TermCategorization;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermCategorization.TermCategorizationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermHASARelationship.TermHASARelationship;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermHASARelationship.TermHASARelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermISATypeOFRelationship.TermISATypeOFRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermISATypeOFRelationship.TermISATypeOFRelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermTYPEDBYRelationship.TermTYPEDBYRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermTYPEDBYRelationship.TermTYPEDBYRelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoSource.ToDoSource;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoSource.ToDoSourceMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TopicSubscribers.TopicSubscribers;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TopicSubscribers.TopicSubscribersMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Translation.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Translation.TranslationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.UsedInContext.UsedInContext;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.UsedInContext.UsedInContextMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ValidValue.ValidValue;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ValidValue.ValidValueMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ZoneGovernance.ZoneGovernance;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ZoneGovernance.ZoneGovernanceMapper;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.repositoryservices.archivemanager.OMRSArchiveAccessor;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaBeansToAccessOMRS {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaBeansToAccessOMRS.class);
    private static final String className = SubjectAreaBeansToAccessOMRS.class.getName();
    private OMRSAPIHelper oMRSAPIHelper = new OMRSAPIHelper();

    public void setOMRSAPIHelper(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
    }

    public CertificationType getCertificationTypeById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getCertificationTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCertificationTypeById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getCertificationTypeById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getCertificationTypeById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        CertificationType gotcertificationType = CertificationTypeMapper.mapOmrsEntityDetailToCertificationType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCertificationTypeById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotcertificationType);
        }
        return gotcertificationType;
    }

    public CertificationType createCertificationType(String userId, CertificationType certificationType) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createCertificationTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createCertificationTypeById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createCertificationTypeById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("CertificationType");
        if (constraint != null) {
            constraint.preCreate(certificationType);
        }
        EntityDetail entityDetail = CertificationTypeMapper.mapCertificationTypeToOmrsEntityDetail(certificationType);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        CertificationType createdCertificationType = CertificationTypeMapper.mapOmrsEntityDetailToCertificationType(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createCertificationTypeById,userId=" + userId + ", created CertificationType=" + createdCertificationType);
        }
        return createdCertificationType;
    }

    public CertificationType updateCertificationType(String userId, CertificationType certificationType) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateCertificationTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateCertificationTypeById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateCertificationTypeById", (String)userId);
        EntityDetail entityDetail = CertificationTypeMapper.mapCertificationTypeToOmrsEntityDetail(certificationType);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateCertificationTypeById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        CertificationType updatedCertificationType = CertificationTypeMapper.mapOmrsEntityDetailToCertificationType(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateCertificationTypeById,userId=" + userId + ",updated CertificationType=" + updatedCertificationType);
        }
        return updatedCertificationType;
    }

    public EntityDetail deleteCertificationTypeByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteCertificationTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteCertificationTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteCertificationTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteCertificationTypeByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("CertificationType");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "CertificationType", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteCertificationTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeCertificationTypeByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeCertificationTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeCertificationTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeCertificationTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeCertificationTypeByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("CertificationType");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "CertificationType", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeCertificationTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public CertificationType restoreCertificationType(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreCertificationTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreCertificationTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreCertificationTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreCertificationTypeByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        CertificationType restoredCertificationType = CertificationTypeMapper.mapOmrsEntityDetailToCertificationType(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreCertificationTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredCertificationType;
    }

    public CertificationType addCertificationTypeClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addCertificationTypeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addCertificationTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addCertificationTypeClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addCertificationTypeClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        CertificationType certificationTypeClassifications = CertificationTypeMapper.mapOmrsEntityDetailToCertificationType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addCertificationTypeClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified CertificationType=" + certificationTypeClassifications);
        }
        return certificationTypeClassifications;
    }

    public CertificationType updateCertificationTypeClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateCertificationTypeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateCertificationTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateCertificationTypeClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateCertificationTypeClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateCertificationTypeClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateCertificationTypeClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        CertificationType certificationTypeClassifications = CertificationTypeMapper.mapOmrsEntityDetailToCertificationType(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateCertificationTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return certificationTypeClassifications;
    }

    public CertificationType deleteCertificationTypeClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteCertificationTypeClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteCertificationTypeClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteCertificationTypeClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteCertificationTypeClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        CertificationType declassifiedCertificationType = CertificationTypeMapper.mapOmrsEntityDetailToCertificationType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteCertificationTypeClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedCertificationType;
    }

    public Set<Line> getCertificationTypeRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getCertificationTypeRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCertificationTypeRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getCertificationTypeRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getCertificationTypeRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCertificationTypeRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public APISchemaType getAPISchemaTypeById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getAPISchemaTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getAPISchemaTypeById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getAPISchemaTypeById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getAPISchemaTypeById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        APISchemaType gotaPISchemaType = APISchemaTypeMapper.mapOmrsEntityDetailToAPISchemaType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getAPISchemaTypeById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotaPISchemaType);
        }
        return gotaPISchemaType;
    }

    public APISchemaType createAPISchemaType(String userId, APISchemaType aPISchemaType) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createAPISchemaTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createAPISchemaTypeById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createAPISchemaTypeById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("APISchemaType");
        if (constraint != null) {
            constraint.preCreate(aPISchemaType);
        }
        EntityDetail entityDetail = APISchemaTypeMapper.mapAPISchemaTypeToOmrsEntityDetail(aPISchemaType);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        APISchemaType createdAPISchemaType = APISchemaTypeMapper.mapOmrsEntityDetailToAPISchemaType(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createAPISchemaTypeById,userId=" + userId + ", created APISchemaType=" + createdAPISchemaType);
        }
        return createdAPISchemaType;
    }

    public APISchemaType updateAPISchemaType(String userId, APISchemaType aPISchemaType) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateAPISchemaTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateAPISchemaTypeById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateAPISchemaTypeById", (String)userId);
        EntityDetail entityDetail = APISchemaTypeMapper.mapAPISchemaTypeToOmrsEntityDetail(aPISchemaType);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateAPISchemaTypeById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        APISchemaType updatedAPISchemaType = APISchemaTypeMapper.mapOmrsEntityDetailToAPISchemaType(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateAPISchemaTypeById,userId=" + userId + ",updated APISchemaType=" + updatedAPISchemaType);
        }
        return updatedAPISchemaType;
    }

    public EntityDetail deleteAPISchemaTypeByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteAPISchemaTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteAPISchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteAPISchemaTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteAPISchemaTypeByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("APISchemaType");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "APISchemaType", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteAPISchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeAPISchemaTypeByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeAPISchemaTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeAPISchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeAPISchemaTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeAPISchemaTypeByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("APISchemaType");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "APISchemaType", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeAPISchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public APISchemaType restoreAPISchemaType(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreAPISchemaTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreAPISchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreAPISchemaTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreAPISchemaTypeByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        APISchemaType restoredAPISchemaType = APISchemaTypeMapper.mapOmrsEntityDetailToAPISchemaType(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreAPISchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredAPISchemaType;
    }

    public APISchemaType addAPISchemaTypeClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addAPISchemaTypeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addAPISchemaTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addAPISchemaTypeClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addAPISchemaTypeClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        APISchemaType aPISchemaTypeClassifications = APISchemaTypeMapper.mapOmrsEntityDetailToAPISchemaType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addAPISchemaTypeClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified APISchemaType=" + aPISchemaTypeClassifications);
        }
        return aPISchemaTypeClassifications;
    }

    public APISchemaType updateAPISchemaTypeClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateAPISchemaTypeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateAPISchemaTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateAPISchemaTypeClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateAPISchemaTypeClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateAPISchemaTypeClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateAPISchemaTypeClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        APISchemaType aPISchemaTypeClassifications = APISchemaTypeMapper.mapOmrsEntityDetailToAPISchemaType(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateAPISchemaTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return aPISchemaTypeClassifications;
    }

    public APISchemaType deleteAPISchemaTypeClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteAPISchemaTypeClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteAPISchemaTypeClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteAPISchemaTypeClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteAPISchemaTypeClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        APISchemaType declassifiedAPISchemaType = APISchemaTypeMapper.mapOmrsEntityDetailToAPISchemaType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteAPISchemaTypeClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedAPISchemaType;
    }

    public Set<Line> getAPISchemaTypeRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getAPISchemaTypeRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getAPISchemaTypeRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getAPISchemaTypeRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getAPISchemaTypeRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getAPISchemaTypeRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public DataSet getDataSetById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getDataSetById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getDataSetById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getDataSetById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getDataSetById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DataSet gotdataSet = DataSetMapper.mapOmrsEntityDetailToDataSet(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getDataSetById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotdataSet);
        }
        return gotdataSet;
    }

    public DataSet createDataSet(String userId, DataSet dataSet) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createDataSetById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createDataSetById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createDataSetById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("DataSet");
        if (constraint != null) {
            constraint.preCreate(dataSet);
        }
        EntityDetail entityDetail = DataSetMapper.mapDataSetToOmrsEntityDetail(dataSet);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        DataSet createdDataSet = DataSetMapper.mapOmrsEntityDetailToDataSet(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createDataSetById,userId=" + userId + ", created DataSet=" + createdDataSet);
        }
        return createdDataSet;
    }

    public DataSet updateDataSet(String userId, DataSet dataSet) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateDataSetById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateDataSetById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateDataSetById", (String)userId);
        EntityDetail entityDetail = DataSetMapper.mapDataSetToOmrsEntityDetail(dataSet);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateDataSetById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        DataSet updatedDataSet = DataSetMapper.mapOmrsEntityDetailToDataSet(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateDataSetById,userId=" + userId + ",updated DataSet=" + updatedDataSet);
        }
        return updatedDataSet;
    }

    public EntityDetail deleteDataSetByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteDataSetByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteDataSetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteDataSetByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteDataSetByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("DataSet");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "DataSet", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteDataSetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeDataSetByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeDataSetByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeDataSetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeDataSetByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeDataSetByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("DataSet");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "DataSet", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeDataSetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public DataSet restoreDataSet(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreDataSetByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreDataSetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreDataSetByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreDataSetByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        DataSet restoredDataSet = DataSetMapper.mapOmrsEntityDetailToDataSet(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreDataSetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredDataSet;
    }

    public DataSet addDataSetClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addDataSetClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addDataSetClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addDataSetClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addDataSetClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DataSet dataSetClassifications = DataSetMapper.mapOmrsEntityDetailToDataSet(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addDataSetClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified DataSet=" + dataSetClassifications);
        }
        return dataSetClassifications;
    }

    public DataSet updateDataSetClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateDataSetClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateDataSetClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateDataSetClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateDataSetClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateDataSetClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateDataSetClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DataSet dataSetClassifications = DataSetMapper.mapOmrsEntityDetailToDataSet(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateDataSetClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return dataSetClassifications;
    }

    public DataSet deleteDataSetClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteDataSetClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteDataSetClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteDataSetClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteDataSetClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DataSet declassifiedDataSet = DataSetMapper.mapOmrsEntityDetailToDataSet(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteDataSetClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedDataSet;
    }

    public Set<Line> getDataSetRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getDataSetRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getDataSetRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getDataSetRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getDataSetRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getDataSetRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public OperatingPlatform getOperatingPlatformById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getOperatingPlatformById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getOperatingPlatformById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getOperatingPlatformById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getOperatingPlatformById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        OperatingPlatform gotoperatingPlatform = OperatingPlatformMapper.mapOmrsEntityDetailToOperatingPlatform(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getOperatingPlatformById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotoperatingPlatform);
        }
        return gotoperatingPlatform;
    }

    public OperatingPlatform createOperatingPlatform(String userId, OperatingPlatform operatingPlatform) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createOperatingPlatformById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createOperatingPlatformById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createOperatingPlatformById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("OperatingPlatform");
        if (constraint != null) {
            constraint.preCreate(operatingPlatform);
        }
        EntityDetail entityDetail = OperatingPlatformMapper.mapOperatingPlatformToOmrsEntityDetail(operatingPlatform);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        OperatingPlatform createdOperatingPlatform = OperatingPlatformMapper.mapOmrsEntityDetailToOperatingPlatform(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createOperatingPlatformById,userId=" + userId + ", created OperatingPlatform=" + createdOperatingPlatform);
        }
        return createdOperatingPlatform;
    }

    public OperatingPlatform updateOperatingPlatform(String userId, OperatingPlatform operatingPlatform) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateOperatingPlatformById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateOperatingPlatformById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateOperatingPlatformById", (String)userId);
        EntityDetail entityDetail = OperatingPlatformMapper.mapOperatingPlatformToOmrsEntityDetail(operatingPlatform);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateOperatingPlatformById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        OperatingPlatform updatedOperatingPlatform = OperatingPlatformMapper.mapOmrsEntityDetailToOperatingPlatform(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateOperatingPlatformById,userId=" + userId + ",updated OperatingPlatform=" + updatedOperatingPlatform);
        }
        return updatedOperatingPlatform;
    }

    public EntityDetail deleteOperatingPlatformByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteOperatingPlatformByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteOperatingPlatformByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteOperatingPlatformByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteOperatingPlatformByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("OperatingPlatform");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "OperatingPlatform", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteOperatingPlatformByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeOperatingPlatformByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeOperatingPlatformByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeOperatingPlatformByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeOperatingPlatformByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeOperatingPlatformByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("OperatingPlatform");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "OperatingPlatform", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeOperatingPlatformByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public OperatingPlatform restoreOperatingPlatform(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreOperatingPlatformByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreOperatingPlatformByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreOperatingPlatformByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreOperatingPlatformByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        OperatingPlatform restoredOperatingPlatform = OperatingPlatformMapper.mapOmrsEntityDetailToOperatingPlatform(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreOperatingPlatformByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredOperatingPlatform;
    }

    public OperatingPlatform addOperatingPlatformClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addOperatingPlatformClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addOperatingPlatformClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addOperatingPlatformClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addOperatingPlatformClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        OperatingPlatform operatingPlatformClassifications = OperatingPlatformMapper.mapOmrsEntityDetailToOperatingPlatform(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addOperatingPlatformClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified OperatingPlatform=" + operatingPlatformClassifications);
        }
        return operatingPlatformClassifications;
    }

    public OperatingPlatform updateOperatingPlatformClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateOperatingPlatformClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateOperatingPlatformClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateOperatingPlatformClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateOperatingPlatformClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateOperatingPlatformClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateOperatingPlatformClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        OperatingPlatform operatingPlatformClassifications = OperatingPlatformMapper.mapOmrsEntityDetailToOperatingPlatform(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateOperatingPlatformClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return operatingPlatformClassifications;
    }

    public OperatingPlatform deleteOperatingPlatformClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteOperatingPlatformClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteOperatingPlatformClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteOperatingPlatformClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteOperatingPlatformClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        OperatingPlatform declassifiedOperatingPlatform = OperatingPlatformMapper.mapOmrsEntityDetailToOperatingPlatform(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteOperatingPlatformClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedOperatingPlatform;
    }

    public Set<Line> getOperatingPlatformRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getOperatingPlatformRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getOperatingPlatformRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getOperatingPlatformRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getOperatingPlatformRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getOperatingPlatformRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public GovernancePolicy getGovernancePolicyById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getGovernancePolicyById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGovernancePolicyById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGovernancePolicyById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGovernancePolicyById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernancePolicy gotgovernancePolicy = GovernancePolicyMapper.mapOmrsEntityDetailToGovernancePolicy(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGovernancePolicyById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotgovernancePolicy);
        }
        return gotgovernancePolicy;
    }

    public GovernancePolicy createGovernancePolicy(String userId, GovernancePolicy governancePolicy) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createGovernancePolicyById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createGovernancePolicyById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createGovernancePolicyById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("GovernancePolicy");
        if (constraint != null) {
            constraint.preCreate(governancePolicy);
        }
        EntityDetail entityDetail = GovernancePolicyMapper.mapGovernancePolicyToOmrsEntityDetail(governancePolicy);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        GovernancePolicy createdGovernancePolicy = GovernancePolicyMapper.mapOmrsEntityDetailToGovernancePolicy(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createGovernancePolicyById,userId=" + userId + ", created GovernancePolicy=" + createdGovernancePolicy);
        }
        return createdGovernancePolicy;
    }

    public GovernancePolicy updateGovernancePolicy(String userId, GovernancePolicy governancePolicy) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateGovernancePolicyById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGovernancePolicyById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGovernancePolicyById", (String)userId);
        EntityDetail entityDetail = GovernancePolicyMapper.mapGovernancePolicyToOmrsEntityDetail(governancePolicy);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGovernancePolicyById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        GovernancePolicy updatedGovernancePolicy = GovernancePolicyMapper.mapOmrsEntityDetailToGovernancePolicy(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateGovernancePolicyById,userId=" + userId + ",updated GovernancePolicy=" + updatedGovernancePolicy);
        }
        return updatedGovernancePolicy;
    }

    public EntityDetail deleteGovernancePolicyByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteGovernancePolicyByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGovernancePolicyByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGovernancePolicyByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGovernancePolicyByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernancePolicy");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "GovernancePolicy", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGovernancePolicyByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeGovernancePolicyByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeGovernancePolicyByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeGovernancePolicyByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeGovernancePolicyByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeGovernancePolicyByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernancePolicy");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "GovernancePolicy", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeGovernancePolicyByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public GovernancePolicy restoreGovernancePolicy(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreGovernancePolicyByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreGovernancePolicyByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreGovernancePolicyByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreGovernancePolicyByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        GovernancePolicy restoredGovernancePolicy = GovernancePolicyMapper.mapOmrsEntityDetailToGovernancePolicy(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreGovernancePolicyByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredGovernancePolicy;
    }

    public GovernancePolicy addGovernancePolicyClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addGovernancePolicyClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addGovernancePolicyClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addGovernancePolicyClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addGovernancePolicyClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernancePolicy governancePolicyClassifications = GovernancePolicyMapper.mapOmrsEntityDetailToGovernancePolicy(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addGovernancePolicyClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified GovernancePolicy=" + governancePolicyClassifications);
        }
        return governancePolicyClassifications;
    }

    public GovernancePolicy updateGovernancePolicyClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateGovernancePolicyClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGovernancePolicyClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGovernancePolicyClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGovernancePolicyClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateGovernancePolicyClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateGovernancePolicyClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernancePolicy governancePolicyClassifications = GovernancePolicyMapper.mapOmrsEntityDetailToGovernancePolicy(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateGovernancePolicyClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return governancePolicyClassifications;
    }

    public GovernancePolicy deleteGovernancePolicyClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteGovernancePolicyClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGovernancePolicyClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGovernancePolicyClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGovernancePolicyClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernancePolicy declassifiedGovernancePolicy = GovernancePolicyMapper.mapOmrsEntityDetailToGovernancePolicy(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGovernancePolicyClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedGovernancePolicy;
    }

    public Set<Line> getGovernancePolicyRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getGovernancePolicyRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGovernancePolicyRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGovernancePolicyRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGovernancePolicyRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGovernancePolicyRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public DerivedSchemaAttribute getDerivedSchemaAttributeById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getDerivedSchemaAttributeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getDerivedSchemaAttributeById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getDerivedSchemaAttributeById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getDerivedSchemaAttributeById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DerivedSchemaAttribute gotderivedSchemaAttribute = DerivedSchemaAttributeMapper.mapOmrsEntityDetailToDerivedSchemaAttribute(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getDerivedSchemaAttributeById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotderivedSchemaAttribute);
        }
        return gotderivedSchemaAttribute;
    }

    public DerivedSchemaAttribute createDerivedSchemaAttribute(String userId, DerivedSchemaAttribute derivedSchemaAttribute) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createDerivedSchemaAttributeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createDerivedSchemaAttributeById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createDerivedSchemaAttributeById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("DerivedSchemaAttribute");
        if (constraint != null) {
            constraint.preCreate(derivedSchemaAttribute);
        }
        EntityDetail entityDetail = DerivedSchemaAttributeMapper.mapDerivedSchemaAttributeToOmrsEntityDetail(derivedSchemaAttribute);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        DerivedSchemaAttribute createdDerivedSchemaAttribute = DerivedSchemaAttributeMapper.mapOmrsEntityDetailToDerivedSchemaAttribute(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createDerivedSchemaAttributeById,userId=" + userId + ", created DerivedSchemaAttribute=" + createdDerivedSchemaAttribute);
        }
        return createdDerivedSchemaAttribute;
    }

    public DerivedSchemaAttribute updateDerivedSchemaAttribute(String userId, DerivedSchemaAttribute derivedSchemaAttribute) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateDerivedSchemaAttributeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateDerivedSchemaAttributeById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateDerivedSchemaAttributeById", (String)userId);
        EntityDetail entityDetail = DerivedSchemaAttributeMapper.mapDerivedSchemaAttributeToOmrsEntityDetail(derivedSchemaAttribute);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateDerivedSchemaAttributeById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        DerivedSchemaAttribute updatedDerivedSchemaAttribute = DerivedSchemaAttributeMapper.mapOmrsEntityDetailToDerivedSchemaAttribute(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateDerivedSchemaAttributeById,userId=" + userId + ",updated DerivedSchemaAttribute=" + updatedDerivedSchemaAttribute);
        }
        return updatedDerivedSchemaAttribute;
    }

    public EntityDetail deleteDerivedSchemaAttributeByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteDerivedSchemaAttributeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteDerivedSchemaAttributeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteDerivedSchemaAttributeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteDerivedSchemaAttributeByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("DerivedSchemaAttribute");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "DerivedSchemaAttribute", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteDerivedSchemaAttributeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeDerivedSchemaAttributeByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeDerivedSchemaAttributeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeDerivedSchemaAttributeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeDerivedSchemaAttributeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeDerivedSchemaAttributeByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("DerivedSchemaAttribute");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "DerivedSchemaAttribute", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeDerivedSchemaAttributeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public DerivedSchemaAttribute restoreDerivedSchemaAttribute(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreDerivedSchemaAttributeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreDerivedSchemaAttributeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreDerivedSchemaAttributeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreDerivedSchemaAttributeByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        DerivedSchemaAttribute restoredDerivedSchemaAttribute = DerivedSchemaAttributeMapper.mapOmrsEntityDetailToDerivedSchemaAttribute(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreDerivedSchemaAttributeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredDerivedSchemaAttribute;
    }

    public DerivedSchemaAttribute addDerivedSchemaAttributeClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addDerivedSchemaAttributeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addDerivedSchemaAttributeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addDerivedSchemaAttributeClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addDerivedSchemaAttributeClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DerivedSchemaAttribute derivedSchemaAttributeClassifications = DerivedSchemaAttributeMapper.mapOmrsEntityDetailToDerivedSchemaAttribute(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addDerivedSchemaAttributeClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified DerivedSchemaAttribute=" + derivedSchemaAttributeClassifications);
        }
        return derivedSchemaAttributeClassifications;
    }

    public DerivedSchemaAttribute updateDerivedSchemaAttributeClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateDerivedSchemaAttributeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateDerivedSchemaAttributeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateDerivedSchemaAttributeClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateDerivedSchemaAttributeClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateDerivedSchemaAttributeClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateDerivedSchemaAttributeClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DerivedSchemaAttribute derivedSchemaAttributeClassifications = DerivedSchemaAttributeMapper.mapOmrsEntityDetailToDerivedSchemaAttribute(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateDerivedSchemaAttributeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return derivedSchemaAttributeClassifications;
    }

    public DerivedSchemaAttribute deleteDerivedSchemaAttributeClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteDerivedSchemaAttributeClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteDerivedSchemaAttributeClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteDerivedSchemaAttributeClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteDerivedSchemaAttributeClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DerivedSchemaAttribute declassifiedDerivedSchemaAttribute = DerivedSchemaAttributeMapper.mapOmrsEntityDetailToDerivedSchemaAttribute(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteDerivedSchemaAttributeClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedDerivedSchemaAttribute;
    }

    public Set<Line> getDerivedSchemaAttributeRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getDerivedSchemaAttributeRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getDerivedSchemaAttributeRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getDerivedSchemaAttributeRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getDerivedSchemaAttributeRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getDerivedSchemaAttributeRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public Process getProcessById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getProcessById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getProcessById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getProcessById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getProcessById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Process gotprocess = ProcessMapper.mapOmrsEntityDetailToProcess(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getProcessById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotprocess);
        }
        return gotprocess;
    }

    public Process createProcess(String userId, Process process) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createProcessById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createProcessById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createProcessById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Process");
        if (constraint != null) {
            constraint.preCreate(process);
        }
        EntityDetail entityDetail = ProcessMapper.mapProcessToOmrsEntityDetail(process);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        Process createdProcess = ProcessMapper.mapOmrsEntityDetailToProcess(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createProcessById,userId=" + userId + ", created Process=" + createdProcess);
        }
        return createdProcess;
    }

    public Process updateProcess(String userId, Process process) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateProcessById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateProcessById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateProcessById", (String)userId);
        EntityDetail entityDetail = ProcessMapper.mapProcessToOmrsEntityDetail(process);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateProcessById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        Process updatedProcess = ProcessMapper.mapOmrsEntityDetailToProcess(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateProcessById,userId=" + userId + ",updated Process=" + updatedProcess);
        }
        return updatedProcess;
    }

    public EntityDetail deleteProcessByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteProcessByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteProcessByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteProcessByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteProcessByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Process");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "Process", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteProcessByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeProcessByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeProcessByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeProcessByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeProcessByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeProcessByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Process");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "Process", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeProcessByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public Process restoreProcess(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreProcessByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreProcessByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreProcessByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreProcessByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        Process restoredProcess = ProcessMapper.mapOmrsEntityDetailToProcess(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreProcessByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredProcess;
    }

    public Process addProcessClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addProcessClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addProcessClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addProcessClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addProcessClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Process processClassifications = ProcessMapper.mapOmrsEntityDetailToProcess(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addProcessClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified Process=" + processClassifications);
        }
        return processClassifications;
    }

    public Process updateProcessClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateProcessClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateProcessClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateProcessClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateProcessClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateProcessClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateProcessClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Process processClassifications = ProcessMapper.mapOmrsEntityDetailToProcess(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateProcessClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return processClassifications;
    }

    public Process deleteProcessClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteProcessClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteProcessClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteProcessClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteProcessClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Process declassifiedProcess = ProcessMapper.mapOmrsEntityDetailToProcess(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteProcessClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedProcess;
    }

    public Set<Line> getProcessRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getProcessRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getProcessRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getProcessRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getProcessRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getProcessRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public MapSchemaType getMapSchemaTypeById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getMapSchemaTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getMapSchemaTypeById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getMapSchemaTypeById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getMapSchemaTypeById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        MapSchemaType gotmapSchemaType = MapSchemaTypeMapper.mapOmrsEntityDetailToMapSchemaType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getMapSchemaTypeById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotmapSchemaType);
        }
        return gotmapSchemaType;
    }

    public MapSchemaType createMapSchemaType(String userId, MapSchemaType mapSchemaType) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createMapSchemaTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createMapSchemaTypeById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createMapSchemaTypeById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("MapSchemaType");
        if (constraint != null) {
            constraint.preCreate(mapSchemaType);
        }
        EntityDetail entityDetail = MapSchemaTypeMapper.mapMapSchemaTypeToOmrsEntityDetail(mapSchemaType);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        MapSchemaType createdMapSchemaType = MapSchemaTypeMapper.mapOmrsEntityDetailToMapSchemaType(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createMapSchemaTypeById,userId=" + userId + ", created MapSchemaType=" + createdMapSchemaType);
        }
        return createdMapSchemaType;
    }

    public MapSchemaType updateMapSchemaType(String userId, MapSchemaType mapSchemaType) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateMapSchemaTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateMapSchemaTypeById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateMapSchemaTypeById", (String)userId);
        EntityDetail entityDetail = MapSchemaTypeMapper.mapMapSchemaTypeToOmrsEntityDetail(mapSchemaType);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateMapSchemaTypeById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        MapSchemaType updatedMapSchemaType = MapSchemaTypeMapper.mapOmrsEntityDetailToMapSchemaType(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateMapSchemaTypeById,userId=" + userId + ",updated MapSchemaType=" + updatedMapSchemaType);
        }
        return updatedMapSchemaType;
    }

    public EntityDetail deleteMapSchemaTypeByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteMapSchemaTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteMapSchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteMapSchemaTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteMapSchemaTypeByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("MapSchemaType");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "MapSchemaType", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteMapSchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeMapSchemaTypeByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeMapSchemaTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeMapSchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeMapSchemaTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeMapSchemaTypeByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("MapSchemaType");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "MapSchemaType", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeMapSchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public MapSchemaType restoreMapSchemaType(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreMapSchemaTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreMapSchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreMapSchemaTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreMapSchemaTypeByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        MapSchemaType restoredMapSchemaType = MapSchemaTypeMapper.mapOmrsEntityDetailToMapSchemaType(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreMapSchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredMapSchemaType;
    }

    public MapSchemaType addMapSchemaTypeClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addMapSchemaTypeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addMapSchemaTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addMapSchemaTypeClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addMapSchemaTypeClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        MapSchemaType mapSchemaTypeClassifications = MapSchemaTypeMapper.mapOmrsEntityDetailToMapSchemaType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addMapSchemaTypeClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified MapSchemaType=" + mapSchemaTypeClassifications);
        }
        return mapSchemaTypeClassifications;
    }

    public MapSchemaType updateMapSchemaTypeClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateMapSchemaTypeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateMapSchemaTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateMapSchemaTypeClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateMapSchemaTypeClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateMapSchemaTypeClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateMapSchemaTypeClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        MapSchemaType mapSchemaTypeClassifications = MapSchemaTypeMapper.mapOmrsEntityDetailToMapSchemaType(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateMapSchemaTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return mapSchemaTypeClassifications;
    }

    public MapSchemaType deleteMapSchemaTypeClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteMapSchemaTypeClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteMapSchemaTypeClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteMapSchemaTypeClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteMapSchemaTypeClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        MapSchemaType declassifiedMapSchemaType = MapSchemaTypeMapper.mapOmrsEntityDetailToMapSchemaType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteMapSchemaTypeClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedMapSchemaType;
    }

    public Set<Line> getMapSchemaTypeRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getMapSchemaTypeRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getMapSchemaTypeRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getMapSchemaTypeRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getMapSchemaTypeRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getMapSchemaTypeRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public DeployedSoftwareComponent getDeployedSoftwareComponentById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getDeployedSoftwareComponentById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getDeployedSoftwareComponentById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getDeployedSoftwareComponentById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getDeployedSoftwareComponentById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DeployedSoftwareComponent gotdeployedSoftwareComponent = DeployedSoftwareComponentMapper.mapOmrsEntityDetailToDeployedSoftwareComponent(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getDeployedSoftwareComponentById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotdeployedSoftwareComponent);
        }
        return gotdeployedSoftwareComponent;
    }

    public DeployedSoftwareComponent createDeployedSoftwareComponent(String userId, DeployedSoftwareComponent deployedSoftwareComponent) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createDeployedSoftwareComponentById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createDeployedSoftwareComponentById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createDeployedSoftwareComponentById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("DeployedSoftwareComponent");
        if (constraint != null) {
            constraint.preCreate(deployedSoftwareComponent);
        }
        EntityDetail entityDetail = DeployedSoftwareComponentMapper.mapDeployedSoftwareComponentToOmrsEntityDetail(deployedSoftwareComponent);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        DeployedSoftwareComponent createdDeployedSoftwareComponent = DeployedSoftwareComponentMapper.mapOmrsEntityDetailToDeployedSoftwareComponent(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createDeployedSoftwareComponentById,userId=" + userId + ", created DeployedSoftwareComponent=" + createdDeployedSoftwareComponent);
        }
        return createdDeployedSoftwareComponent;
    }

    public DeployedSoftwareComponent updateDeployedSoftwareComponent(String userId, DeployedSoftwareComponent deployedSoftwareComponent) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateDeployedSoftwareComponentById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateDeployedSoftwareComponentById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateDeployedSoftwareComponentById", (String)userId);
        EntityDetail entityDetail = DeployedSoftwareComponentMapper.mapDeployedSoftwareComponentToOmrsEntityDetail(deployedSoftwareComponent);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateDeployedSoftwareComponentById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        DeployedSoftwareComponent updatedDeployedSoftwareComponent = DeployedSoftwareComponentMapper.mapOmrsEntityDetailToDeployedSoftwareComponent(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateDeployedSoftwareComponentById,userId=" + userId + ",updated DeployedSoftwareComponent=" + updatedDeployedSoftwareComponent);
        }
        return updatedDeployedSoftwareComponent;
    }

    public EntityDetail deleteDeployedSoftwareComponentByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteDeployedSoftwareComponentByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteDeployedSoftwareComponentByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteDeployedSoftwareComponentByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteDeployedSoftwareComponentByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("DeployedSoftwareComponent");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "DeployedSoftwareComponent", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteDeployedSoftwareComponentByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeDeployedSoftwareComponentByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeDeployedSoftwareComponentByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeDeployedSoftwareComponentByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeDeployedSoftwareComponentByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeDeployedSoftwareComponentByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("DeployedSoftwareComponent");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "DeployedSoftwareComponent", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeDeployedSoftwareComponentByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public DeployedSoftwareComponent restoreDeployedSoftwareComponent(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreDeployedSoftwareComponentByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreDeployedSoftwareComponentByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreDeployedSoftwareComponentByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreDeployedSoftwareComponentByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        DeployedSoftwareComponent restoredDeployedSoftwareComponent = DeployedSoftwareComponentMapper.mapOmrsEntityDetailToDeployedSoftwareComponent(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreDeployedSoftwareComponentByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredDeployedSoftwareComponent;
    }

    public DeployedSoftwareComponent addDeployedSoftwareComponentClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addDeployedSoftwareComponentClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addDeployedSoftwareComponentClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addDeployedSoftwareComponentClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addDeployedSoftwareComponentClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DeployedSoftwareComponent deployedSoftwareComponentClassifications = DeployedSoftwareComponentMapper.mapOmrsEntityDetailToDeployedSoftwareComponent(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addDeployedSoftwareComponentClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified DeployedSoftwareComponent=" + deployedSoftwareComponentClassifications);
        }
        return deployedSoftwareComponentClassifications;
    }

    public DeployedSoftwareComponent updateDeployedSoftwareComponentClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateDeployedSoftwareComponentClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateDeployedSoftwareComponentClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateDeployedSoftwareComponentClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateDeployedSoftwareComponentClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateDeployedSoftwareComponentClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateDeployedSoftwareComponentClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DeployedSoftwareComponent deployedSoftwareComponentClassifications = DeployedSoftwareComponentMapper.mapOmrsEntityDetailToDeployedSoftwareComponent(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateDeployedSoftwareComponentClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return deployedSoftwareComponentClassifications;
    }

    public DeployedSoftwareComponent deleteDeployedSoftwareComponentClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteDeployedSoftwareComponentClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteDeployedSoftwareComponentClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteDeployedSoftwareComponentClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteDeployedSoftwareComponentClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DeployedSoftwareComponent declassifiedDeployedSoftwareComponent = DeployedSoftwareComponentMapper.mapOmrsEntityDetailToDeployedSoftwareComponent(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteDeployedSoftwareComponentClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedDeployedSoftwareComponent;
    }

    public Set<Line> getDeployedSoftwareComponentRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getDeployedSoftwareComponentRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getDeployedSoftwareComponentRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getDeployedSoftwareComponentRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getDeployedSoftwareComponentRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getDeployedSoftwareComponentRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public SchemaType getSchemaTypeById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getSchemaTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getSchemaTypeById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getSchemaTypeById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getSchemaTypeById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SchemaType gotschemaType = SchemaTypeMapper.mapOmrsEntityDetailToSchemaType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getSchemaTypeById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotschemaType);
        }
        return gotschemaType;
    }

    public SchemaType createSchemaType(String userId, SchemaType schemaType) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createSchemaTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createSchemaTypeById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createSchemaTypeById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("SchemaType");
        if (constraint != null) {
            constraint.preCreate(schemaType);
        }
        EntityDetail entityDetail = SchemaTypeMapper.mapSchemaTypeToOmrsEntityDetail(schemaType);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        SchemaType createdSchemaType = SchemaTypeMapper.mapOmrsEntityDetailToSchemaType(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createSchemaTypeById,userId=" + userId + ", created SchemaType=" + createdSchemaType);
        }
        return createdSchemaType;
    }

    public SchemaType updateSchemaType(String userId, SchemaType schemaType) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateSchemaTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateSchemaTypeById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateSchemaTypeById", (String)userId);
        EntityDetail entityDetail = SchemaTypeMapper.mapSchemaTypeToOmrsEntityDetail(schemaType);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateSchemaTypeById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        SchemaType updatedSchemaType = SchemaTypeMapper.mapOmrsEntityDetailToSchemaType(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateSchemaTypeById,userId=" + userId + ",updated SchemaType=" + updatedSchemaType);
        }
        return updatedSchemaType;
    }

    public EntityDetail deleteSchemaTypeByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteSchemaTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteSchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteSchemaTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteSchemaTypeByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("SchemaType");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "SchemaType", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteSchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeSchemaTypeByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeSchemaTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeSchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeSchemaTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeSchemaTypeByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("SchemaType");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "SchemaType", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeSchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public SchemaType restoreSchemaType(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreSchemaTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreSchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreSchemaTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreSchemaTypeByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        SchemaType restoredSchemaType = SchemaTypeMapper.mapOmrsEntityDetailToSchemaType(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreSchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredSchemaType;
    }

    public SchemaType addSchemaTypeClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addSchemaTypeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addSchemaTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addSchemaTypeClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addSchemaTypeClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SchemaType schemaTypeClassifications = SchemaTypeMapper.mapOmrsEntityDetailToSchemaType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addSchemaTypeClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified SchemaType=" + schemaTypeClassifications);
        }
        return schemaTypeClassifications;
    }

    public SchemaType updateSchemaTypeClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateSchemaTypeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateSchemaTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateSchemaTypeClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateSchemaTypeClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateSchemaTypeClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateSchemaTypeClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SchemaType schemaTypeClassifications = SchemaTypeMapper.mapOmrsEntityDetailToSchemaType(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateSchemaTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return schemaTypeClassifications;
    }

    public SchemaType deleteSchemaTypeClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteSchemaTypeClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteSchemaTypeClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteSchemaTypeClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteSchemaTypeClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SchemaType declassifiedSchemaType = SchemaTypeMapper.mapOmrsEntityDetailToSchemaType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteSchemaTypeClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedSchemaType;
    }

    public Set<Line> getSchemaTypeRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getSchemaTypeRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getSchemaTypeRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getSchemaTypeRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getSchemaTypeRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getSchemaTypeRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public DataFile getDataFileById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getDataFileById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getDataFileById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getDataFileById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getDataFileById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DataFile gotdataFile = DataFileMapper.mapOmrsEntityDetailToDataFile(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getDataFileById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotdataFile);
        }
        return gotdataFile;
    }

    public DataFile createDataFile(String userId, DataFile dataFile) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createDataFileById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createDataFileById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createDataFileById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("DataFile");
        if (constraint != null) {
            constraint.preCreate(dataFile);
        }
        EntityDetail entityDetail = DataFileMapper.mapDataFileToOmrsEntityDetail(dataFile);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        DataFile createdDataFile = DataFileMapper.mapOmrsEntityDetailToDataFile(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createDataFileById,userId=" + userId + ", created DataFile=" + createdDataFile);
        }
        return createdDataFile;
    }

    public DataFile updateDataFile(String userId, DataFile dataFile) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateDataFileById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateDataFileById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateDataFileById", (String)userId);
        EntityDetail entityDetail = DataFileMapper.mapDataFileToOmrsEntityDetail(dataFile);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateDataFileById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        DataFile updatedDataFile = DataFileMapper.mapOmrsEntityDetailToDataFile(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateDataFileById,userId=" + userId + ",updated DataFile=" + updatedDataFile);
        }
        return updatedDataFile;
    }

    public EntityDetail deleteDataFileByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteDataFileByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteDataFileByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteDataFileByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteDataFileByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("DataFile");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "DataFile", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteDataFileByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeDataFileByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeDataFileByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeDataFileByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeDataFileByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeDataFileByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("DataFile");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "DataFile", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeDataFileByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public DataFile restoreDataFile(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreDataFileByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreDataFileByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreDataFileByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreDataFileByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        DataFile restoredDataFile = DataFileMapper.mapOmrsEntityDetailToDataFile(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreDataFileByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredDataFile;
    }

    public DataFile addDataFileClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addDataFileClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addDataFileClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addDataFileClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addDataFileClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DataFile dataFileClassifications = DataFileMapper.mapOmrsEntityDetailToDataFile(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addDataFileClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified DataFile=" + dataFileClassifications);
        }
        return dataFileClassifications;
    }

    public DataFile updateDataFileClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateDataFileClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateDataFileClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateDataFileClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateDataFileClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateDataFileClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateDataFileClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DataFile dataFileClassifications = DataFileMapper.mapOmrsEntityDetailToDataFile(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateDataFileClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return dataFileClassifications;
    }

    public DataFile deleteDataFileClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteDataFileClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteDataFileClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteDataFileClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteDataFileClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DataFile declassifiedDataFile = DataFileMapper.mapOmrsEntityDetailToDataFile(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteDataFileClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedDataFile;
    }

    public Set<Line> getDataFileRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getDataFileRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getDataFileRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getDataFileRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getDataFileRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getDataFileRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public Like getLikeById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getLikeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getLikeById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getLikeById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getLikeById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Like gotlike = LikeMapper.mapOmrsEntityDetailToLike(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getLikeById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotlike);
        }
        return gotlike;
    }

    public Like createLike(String userId, Like like) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createLikeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createLikeById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createLikeById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Like");
        if (constraint != null) {
            constraint.preCreate(like);
        }
        EntityDetail entityDetail = LikeMapper.mapLikeToOmrsEntityDetail(like);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        Like createdLike = LikeMapper.mapOmrsEntityDetailToLike(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createLikeById,userId=" + userId + ", created Like=" + createdLike);
        }
        return createdLike;
    }

    public Like updateLike(String userId, Like like) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateLikeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateLikeById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateLikeById", (String)userId);
        EntityDetail entityDetail = LikeMapper.mapLikeToOmrsEntityDetail(like);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateLikeById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        Like updatedLike = LikeMapper.mapOmrsEntityDetailToLike(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateLikeById,userId=" + userId + ",updated Like=" + updatedLike);
        }
        return updatedLike;
    }

    public EntityDetail deleteLikeByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteLikeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteLikeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteLikeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteLikeByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Like");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "Like", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteLikeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeLikeByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeLikeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeLikeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeLikeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeLikeByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Like");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "Like", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeLikeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public Like restoreLike(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreLikeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreLikeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreLikeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreLikeByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        Like restoredLike = LikeMapper.mapOmrsEntityDetailToLike(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreLikeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredLike;
    }

    public Like addLikeClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addLikeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addLikeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addLikeClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addLikeClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Like likeClassifications = LikeMapper.mapOmrsEntityDetailToLike(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addLikeClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified Like=" + likeClassifications);
        }
        return likeClassifications;
    }

    public Like updateLikeClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateLikeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateLikeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateLikeClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateLikeClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateLikeClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateLikeClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Like likeClassifications = LikeMapper.mapOmrsEntityDetailToLike(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateLikeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return likeClassifications;
    }

    public Like deleteLikeClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteLikeClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteLikeClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteLikeClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteLikeClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Like declassifiedLike = LikeMapper.mapOmrsEntityDetailToLike(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteLikeClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedLike;
    }

    public Set<Line> getLikeRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getLikeRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getLikeRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getLikeRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getLikeRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getLikeRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public Referenceable getReferenceableById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getReferenceableById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getReferenceableById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getReferenceableById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getReferenceableById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Referenceable gotreferenceable = ReferenceableMapper.mapOmrsEntityDetailToReferenceable(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getReferenceableById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotreferenceable);
        }
        return gotreferenceable;
    }

    public Referenceable createReferenceable(String userId, Referenceable referenceable) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createReferenceableById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createReferenceableById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createReferenceableById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Referenceable");
        if (constraint != null) {
            constraint.preCreate(referenceable);
        }
        EntityDetail entityDetail = ReferenceableMapper.mapReferenceableToOmrsEntityDetail(referenceable);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        Referenceable createdReferenceable = ReferenceableMapper.mapOmrsEntityDetailToReferenceable(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createReferenceableById,userId=" + userId + ", created Referenceable=" + createdReferenceable);
        }
        return createdReferenceable;
    }

    public Referenceable updateReferenceable(String userId, Referenceable referenceable) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateReferenceableById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateReferenceableById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateReferenceableById", (String)userId);
        EntityDetail entityDetail = ReferenceableMapper.mapReferenceableToOmrsEntityDetail(referenceable);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateReferenceableById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        Referenceable updatedReferenceable = ReferenceableMapper.mapOmrsEntityDetailToReferenceable(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateReferenceableById,userId=" + userId + ",updated Referenceable=" + updatedReferenceable);
        }
        return updatedReferenceable;
    }

    public EntityDetail deleteReferenceableByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteReferenceableByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteReferenceableByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteReferenceableByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteReferenceableByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Referenceable");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "Referenceable", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteReferenceableByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeReferenceableByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeReferenceableByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeReferenceableByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeReferenceableByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeReferenceableByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Referenceable");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "Referenceable", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeReferenceableByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public Referenceable restoreReferenceable(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreReferenceableByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreReferenceableByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreReferenceableByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreReferenceableByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        Referenceable restoredReferenceable = ReferenceableMapper.mapOmrsEntityDetailToReferenceable(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreReferenceableByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredReferenceable;
    }

    public Referenceable addReferenceableClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addReferenceableClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addReferenceableClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addReferenceableClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addReferenceableClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Referenceable referenceableClassifications = ReferenceableMapper.mapOmrsEntityDetailToReferenceable(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addReferenceableClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified Referenceable=" + referenceableClassifications);
        }
        return referenceableClassifications;
    }

    public Referenceable updateReferenceableClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateReferenceableClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateReferenceableClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateReferenceableClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateReferenceableClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateReferenceableClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateReferenceableClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Referenceable referenceableClassifications = ReferenceableMapper.mapOmrsEntityDetailToReferenceable(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateReferenceableClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return referenceableClassifications;
    }

    public Referenceable deleteReferenceableClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteReferenceableClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteReferenceableClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteReferenceableClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteReferenceableClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Referenceable declassifiedReferenceable = ReferenceableMapper.mapOmrsEntityDetailToReferenceable(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteReferenceableClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedReferenceable;
    }

    public Set<Line> getReferenceableRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getReferenceableRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getReferenceableRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getReferenceableRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getReferenceableRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getReferenceableRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public ExternalReference getExternalReferenceById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getExternalReferenceById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getExternalReferenceById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getExternalReferenceById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getExternalReferenceById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ExternalReference gotexternalReference = ExternalReferenceMapper.mapOmrsEntityDetailToExternalReference(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getExternalReferenceById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotexternalReference);
        }
        return gotexternalReference;
    }

    public ExternalReference createExternalReference(String userId, ExternalReference externalReference) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createExternalReferenceById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createExternalReferenceById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createExternalReferenceById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("ExternalReference");
        if (constraint != null) {
            constraint.preCreate(externalReference);
        }
        EntityDetail entityDetail = ExternalReferenceMapper.mapExternalReferenceToOmrsEntityDetail(externalReference);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        ExternalReference createdExternalReference = ExternalReferenceMapper.mapOmrsEntityDetailToExternalReference(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createExternalReferenceById,userId=" + userId + ", created ExternalReference=" + createdExternalReference);
        }
        return createdExternalReference;
    }

    public ExternalReference updateExternalReference(String userId, ExternalReference externalReference) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateExternalReferenceById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateExternalReferenceById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateExternalReferenceById", (String)userId);
        EntityDetail entityDetail = ExternalReferenceMapper.mapExternalReferenceToOmrsEntityDetail(externalReference);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateExternalReferenceById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        ExternalReference updatedExternalReference = ExternalReferenceMapper.mapOmrsEntityDetailToExternalReference(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateExternalReferenceById,userId=" + userId + ",updated ExternalReference=" + updatedExternalReference);
        }
        return updatedExternalReference;
    }

    public EntityDetail deleteExternalReferenceByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteExternalReferenceByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteExternalReferenceByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteExternalReferenceByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteExternalReferenceByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("ExternalReference");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "ExternalReference", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteExternalReferenceByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeExternalReferenceByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeExternalReferenceByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeExternalReferenceByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeExternalReferenceByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeExternalReferenceByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("ExternalReference");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "ExternalReference", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeExternalReferenceByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public ExternalReference restoreExternalReference(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreExternalReferenceByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreExternalReferenceByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreExternalReferenceByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreExternalReferenceByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        ExternalReference restoredExternalReference = ExternalReferenceMapper.mapOmrsEntityDetailToExternalReference(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreExternalReferenceByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredExternalReference;
    }

    public ExternalReference addExternalReferenceClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addExternalReferenceClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addExternalReferenceClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addExternalReferenceClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addExternalReferenceClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ExternalReference externalReferenceClassifications = ExternalReferenceMapper.mapOmrsEntityDetailToExternalReference(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addExternalReferenceClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified ExternalReference=" + externalReferenceClassifications);
        }
        return externalReferenceClassifications;
    }

    public ExternalReference updateExternalReferenceClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateExternalReferenceClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateExternalReferenceClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateExternalReferenceClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateExternalReferenceClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateExternalReferenceClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateExternalReferenceClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ExternalReference externalReferenceClassifications = ExternalReferenceMapper.mapOmrsEntityDetailToExternalReference(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateExternalReferenceClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return externalReferenceClassifications;
    }

    public ExternalReference deleteExternalReferenceClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteExternalReferenceClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteExternalReferenceClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteExternalReferenceClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteExternalReferenceClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ExternalReference declassifiedExternalReference = ExternalReferenceMapper.mapOmrsEntityDetailToExternalReference(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteExternalReferenceClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedExternalReference;
    }

    public Set<Line> getExternalReferenceRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getExternalReferenceRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getExternalReferenceRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getExternalReferenceRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getExternalReferenceRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getExternalReferenceRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public Endpoint getEndpointById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getEndpointById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getEndpointById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getEndpointById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getEndpointById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Endpoint gotendpoint = EndpointMapper.mapOmrsEntityDetailToEndpoint(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getEndpointById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotendpoint);
        }
        return gotendpoint;
    }

    public Endpoint createEndpoint(String userId, Endpoint endpoint) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createEndpointById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createEndpointById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createEndpointById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Endpoint");
        if (constraint != null) {
            constraint.preCreate(endpoint);
        }
        EntityDetail entityDetail = EndpointMapper.mapEndpointToOmrsEntityDetail(endpoint);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        Endpoint createdEndpoint = EndpointMapper.mapOmrsEntityDetailToEndpoint(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createEndpointById,userId=" + userId + ", created Endpoint=" + createdEndpoint);
        }
        return createdEndpoint;
    }

    public Endpoint updateEndpoint(String userId, Endpoint endpoint) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateEndpointById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateEndpointById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateEndpointById", (String)userId);
        EntityDetail entityDetail = EndpointMapper.mapEndpointToOmrsEntityDetail(endpoint);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateEndpointById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        Endpoint updatedEndpoint = EndpointMapper.mapOmrsEntityDetailToEndpoint(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateEndpointById,userId=" + userId + ",updated Endpoint=" + updatedEndpoint);
        }
        return updatedEndpoint;
    }

    public EntityDetail deleteEndpointByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteEndpointByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteEndpointByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteEndpointByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteEndpointByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Endpoint");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "Endpoint", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteEndpointByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeEndpointByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeEndpointByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeEndpointByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeEndpointByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeEndpointByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Endpoint");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "Endpoint", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeEndpointByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public Endpoint restoreEndpoint(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreEndpointByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreEndpointByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreEndpointByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreEndpointByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        Endpoint restoredEndpoint = EndpointMapper.mapOmrsEntityDetailToEndpoint(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreEndpointByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredEndpoint;
    }

    public Endpoint addEndpointClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addEndpointClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addEndpointClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addEndpointClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addEndpointClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Endpoint endpointClassifications = EndpointMapper.mapOmrsEntityDetailToEndpoint(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addEndpointClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified Endpoint=" + endpointClassifications);
        }
        return endpointClassifications;
    }

    public Endpoint updateEndpointClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateEndpointClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateEndpointClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateEndpointClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateEndpointClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateEndpointClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateEndpointClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Endpoint endpointClassifications = EndpointMapper.mapOmrsEntityDetailToEndpoint(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateEndpointClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return endpointClassifications;
    }

    public Endpoint deleteEndpointClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteEndpointClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteEndpointClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteEndpointClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteEndpointClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Endpoint declassifiedEndpoint = EndpointMapper.mapOmrsEntityDetailToEndpoint(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteEndpointClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedEndpoint;
    }

    public Set<Line> getEndpointRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getEndpointRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getEndpointRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getEndpointRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getEndpointRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getEndpointRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public ContactDetails getContactDetailsById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getContactDetailsById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getContactDetailsById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getContactDetailsById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getContactDetailsById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ContactDetails gotcontactDetails = ContactDetailsMapper.mapOmrsEntityDetailToContactDetails(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getContactDetailsById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotcontactDetails);
        }
        return gotcontactDetails;
    }

    public ContactDetails createContactDetails(String userId, ContactDetails contactDetails) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createContactDetailsById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createContactDetailsById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createContactDetailsById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("ContactDetails");
        if (constraint != null) {
            constraint.preCreate(contactDetails);
        }
        EntityDetail entityDetail = ContactDetailsMapper.mapContactDetailsToOmrsEntityDetail(contactDetails);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        ContactDetails createdContactDetails = ContactDetailsMapper.mapOmrsEntityDetailToContactDetails(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createContactDetailsById,userId=" + userId + ", created ContactDetails=" + createdContactDetails);
        }
        return createdContactDetails;
    }

    public ContactDetails updateContactDetails(String userId, ContactDetails contactDetails) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateContactDetailsById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateContactDetailsById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateContactDetailsById", (String)userId);
        EntityDetail entityDetail = ContactDetailsMapper.mapContactDetailsToOmrsEntityDetail(contactDetails);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateContactDetailsById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        ContactDetails updatedContactDetails = ContactDetailsMapper.mapOmrsEntityDetailToContactDetails(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateContactDetailsById,userId=" + userId + ",updated ContactDetails=" + updatedContactDetails);
        }
        return updatedContactDetails;
    }

    public EntityDetail deleteContactDetailsByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteContactDetailsByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteContactDetailsByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteContactDetailsByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteContactDetailsByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("ContactDetails");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "ContactDetails", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteContactDetailsByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeContactDetailsByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeContactDetailsByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeContactDetailsByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeContactDetailsByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeContactDetailsByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("ContactDetails");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "ContactDetails", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeContactDetailsByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public ContactDetails restoreContactDetails(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreContactDetailsByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreContactDetailsByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreContactDetailsByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreContactDetailsByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        ContactDetails restoredContactDetails = ContactDetailsMapper.mapOmrsEntityDetailToContactDetails(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreContactDetailsByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredContactDetails;
    }

    public ContactDetails addContactDetailsClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addContactDetailsClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addContactDetailsClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addContactDetailsClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addContactDetailsClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ContactDetails contactDetailsClassifications = ContactDetailsMapper.mapOmrsEntityDetailToContactDetails(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addContactDetailsClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified ContactDetails=" + contactDetailsClassifications);
        }
        return contactDetailsClassifications;
    }

    public ContactDetails updateContactDetailsClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateContactDetailsClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateContactDetailsClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateContactDetailsClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateContactDetailsClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateContactDetailsClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateContactDetailsClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ContactDetails contactDetailsClassifications = ContactDetailsMapper.mapOmrsEntityDetailToContactDetails(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateContactDetailsClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return contactDetailsClassifications;
    }

    public ContactDetails deleteContactDetailsClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteContactDetailsClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteContactDetailsClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteContactDetailsClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteContactDetailsClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ContactDetails declassifiedContactDetails = ContactDetailsMapper.mapOmrsEntityDetailToContactDetails(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteContactDetailsClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedContactDetails;
    }

    public Set<Line> getContactDetailsRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getContactDetailsRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getContactDetailsRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getContactDetailsRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getContactDetailsRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getContactDetailsRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public GovernanceDefinition getGovernanceDefinitionById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getGovernanceDefinitionById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGovernanceDefinitionById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGovernanceDefinitionById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGovernanceDefinitionById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceDefinition gotgovernanceDefinition = GovernanceDefinitionMapper.mapOmrsEntityDetailToGovernanceDefinition(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGovernanceDefinitionById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotgovernanceDefinition);
        }
        return gotgovernanceDefinition;
    }

    public GovernanceDefinition createGovernanceDefinition(String userId, GovernanceDefinition governanceDefinition) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createGovernanceDefinitionById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createGovernanceDefinitionById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createGovernanceDefinitionById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("GovernanceDefinition");
        if (constraint != null) {
            constraint.preCreate(governanceDefinition);
        }
        EntityDetail entityDetail = GovernanceDefinitionMapper.mapGovernanceDefinitionToOmrsEntityDetail(governanceDefinition);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        GovernanceDefinition createdGovernanceDefinition = GovernanceDefinitionMapper.mapOmrsEntityDetailToGovernanceDefinition(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createGovernanceDefinitionById,userId=" + userId + ", created GovernanceDefinition=" + createdGovernanceDefinition);
        }
        return createdGovernanceDefinition;
    }

    public GovernanceDefinition updateGovernanceDefinition(String userId, GovernanceDefinition governanceDefinition) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateGovernanceDefinitionById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGovernanceDefinitionById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGovernanceDefinitionById", (String)userId);
        EntityDetail entityDetail = GovernanceDefinitionMapper.mapGovernanceDefinitionToOmrsEntityDetail(governanceDefinition);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGovernanceDefinitionById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        GovernanceDefinition updatedGovernanceDefinition = GovernanceDefinitionMapper.mapOmrsEntityDetailToGovernanceDefinition(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateGovernanceDefinitionById,userId=" + userId + ",updated GovernanceDefinition=" + updatedGovernanceDefinition);
        }
        return updatedGovernanceDefinition;
    }

    public EntityDetail deleteGovernanceDefinitionByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteGovernanceDefinitionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGovernanceDefinitionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGovernanceDefinitionByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGovernanceDefinitionByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernanceDefinition");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "GovernanceDefinition", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGovernanceDefinitionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeGovernanceDefinitionByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeGovernanceDefinitionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeGovernanceDefinitionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeGovernanceDefinitionByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeGovernanceDefinitionByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernanceDefinition");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "GovernanceDefinition", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeGovernanceDefinitionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public GovernanceDefinition restoreGovernanceDefinition(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreGovernanceDefinitionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreGovernanceDefinitionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreGovernanceDefinitionByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreGovernanceDefinitionByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        GovernanceDefinition restoredGovernanceDefinition = GovernanceDefinitionMapper.mapOmrsEntityDetailToGovernanceDefinition(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreGovernanceDefinitionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredGovernanceDefinition;
    }

    public GovernanceDefinition addGovernanceDefinitionClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addGovernanceDefinitionClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addGovernanceDefinitionClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addGovernanceDefinitionClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addGovernanceDefinitionClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceDefinition governanceDefinitionClassifications = GovernanceDefinitionMapper.mapOmrsEntityDetailToGovernanceDefinition(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addGovernanceDefinitionClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified GovernanceDefinition=" + governanceDefinitionClassifications);
        }
        return governanceDefinitionClassifications;
    }

    public GovernanceDefinition updateGovernanceDefinitionClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateGovernanceDefinitionClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGovernanceDefinitionClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGovernanceDefinitionClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGovernanceDefinitionClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateGovernanceDefinitionClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateGovernanceDefinitionClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceDefinition governanceDefinitionClassifications = GovernanceDefinitionMapper.mapOmrsEntityDetailToGovernanceDefinition(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateGovernanceDefinitionClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return governanceDefinitionClassifications;
    }

    public GovernanceDefinition deleteGovernanceDefinitionClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteGovernanceDefinitionClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGovernanceDefinitionClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGovernanceDefinitionClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGovernanceDefinitionClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceDefinition declassifiedGovernanceDefinition = GovernanceDefinitionMapper.mapOmrsEntityDetailToGovernanceDefinition(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGovernanceDefinitionClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedGovernanceDefinition;
    }

    public Set<Line> getGovernanceDefinitionRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getGovernanceDefinitionRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGovernanceDefinitionRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGovernanceDefinitionRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGovernanceDefinitionRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGovernanceDefinitionRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public FileFolder getFileFolderById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getFileFolderById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getFileFolderById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getFileFolderById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getFileFolderById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        FileFolder gotfileFolder = FileFolderMapper.mapOmrsEntityDetailToFileFolder(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getFileFolderById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotfileFolder);
        }
        return gotfileFolder;
    }

    public FileFolder createFileFolder(String userId, FileFolder fileFolder) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createFileFolderById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createFileFolderById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createFileFolderById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("FileFolder");
        if (constraint != null) {
            constraint.preCreate(fileFolder);
        }
        EntityDetail entityDetail = FileFolderMapper.mapFileFolderToOmrsEntityDetail(fileFolder);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        FileFolder createdFileFolder = FileFolderMapper.mapOmrsEntityDetailToFileFolder(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createFileFolderById,userId=" + userId + ", created FileFolder=" + createdFileFolder);
        }
        return createdFileFolder;
    }

    public FileFolder updateFileFolder(String userId, FileFolder fileFolder) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateFileFolderById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateFileFolderById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateFileFolderById", (String)userId);
        EntityDetail entityDetail = FileFolderMapper.mapFileFolderToOmrsEntityDetail(fileFolder);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateFileFolderById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        FileFolder updatedFileFolder = FileFolderMapper.mapOmrsEntityDetailToFileFolder(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateFileFolderById,userId=" + userId + ",updated FileFolder=" + updatedFileFolder);
        }
        return updatedFileFolder;
    }

    public EntityDetail deleteFileFolderByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteFileFolderByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteFileFolderByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteFileFolderByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteFileFolderByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("FileFolder");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "FileFolder", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteFileFolderByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeFileFolderByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeFileFolderByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeFileFolderByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeFileFolderByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeFileFolderByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("FileFolder");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "FileFolder", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeFileFolderByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public FileFolder restoreFileFolder(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreFileFolderByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreFileFolderByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreFileFolderByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreFileFolderByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        FileFolder restoredFileFolder = FileFolderMapper.mapOmrsEntityDetailToFileFolder(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreFileFolderByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredFileFolder;
    }

    public FileFolder addFileFolderClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addFileFolderClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addFileFolderClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addFileFolderClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addFileFolderClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        FileFolder fileFolderClassifications = FileFolderMapper.mapOmrsEntityDetailToFileFolder(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addFileFolderClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified FileFolder=" + fileFolderClassifications);
        }
        return fileFolderClassifications;
    }

    public FileFolder updateFileFolderClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateFileFolderClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateFileFolderClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateFileFolderClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateFileFolderClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateFileFolderClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateFileFolderClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        FileFolder fileFolderClassifications = FileFolderMapper.mapOmrsEntityDetailToFileFolder(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateFileFolderClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return fileFolderClassifications;
    }

    public FileFolder deleteFileFolderClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteFileFolderClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteFileFolderClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteFileFolderClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteFileFolderClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        FileFolder declassifiedFileFolder = FileFolderMapper.mapOmrsEntityDetailToFileFolder(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteFileFolderClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedFileFolder;
    }

    public Set<Line> getFileFolderRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getFileFolderRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getFileFolderRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getFileFolderRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getFileFolderRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getFileFolderRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public Network getNetworkById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getNetworkById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getNetworkById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getNetworkById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getNetworkById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Network gotnetwork = NetworkMapper.mapOmrsEntityDetailToNetwork(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getNetworkById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotnetwork);
        }
        return gotnetwork;
    }

    public Network createNetwork(String userId, Network network) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createNetworkById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createNetworkById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createNetworkById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Network");
        if (constraint != null) {
            constraint.preCreate(network);
        }
        EntityDetail entityDetail = NetworkMapper.mapNetworkToOmrsEntityDetail(network);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        Network createdNetwork = NetworkMapper.mapOmrsEntityDetailToNetwork(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createNetworkById,userId=" + userId + ", created Network=" + createdNetwork);
        }
        return createdNetwork;
    }

    public Network updateNetwork(String userId, Network network) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateNetworkById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateNetworkById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateNetworkById", (String)userId);
        EntityDetail entityDetail = NetworkMapper.mapNetworkToOmrsEntityDetail(network);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateNetworkById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        Network updatedNetwork = NetworkMapper.mapOmrsEntityDetailToNetwork(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateNetworkById,userId=" + userId + ",updated Network=" + updatedNetwork);
        }
        return updatedNetwork;
    }

    public EntityDetail deleteNetworkByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteNetworkByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteNetworkByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteNetworkByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteNetworkByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Network");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "Network", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteNetworkByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeNetworkByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeNetworkByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeNetworkByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeNetworkByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeNetworkByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Network");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "Network", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeNetworkByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public Network restoreNetwork(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreNetworkByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreNetworkByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreNetworkByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreNetworkByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        Network restoredNetwork = NetworkMapper.mapOmrsEntityDetailToNetwork(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreNetworkByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredNetwork;
    }

    public Network addNetworkClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addNetworkClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addNetworkClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addNetworkClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addNetworkClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Network networkClassifications = NetworkMapper.mapOmrsEntityDetailToNetwork(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addNetworkClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified Network=" + networkClassifications);
        }
        return networkClassifications;
    }

    public Network updateNetworkClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateNetworkClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateNetworkClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateNetworkClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateNetworkClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateNetworkClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateNetworkClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Network networkClassifications = NetworkMapper.mapOmrsEntityDetailToNetwork(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateNetworkClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return networkClassifications;
    }

    public Network deleteNetworkClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteNetworkClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteNetworkClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteNetworkClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteNetworkClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Network declassifiedNetwork = NetworkMapper.mapOmrsEntityDetailToNetwork(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteNetworkClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedNetwork;
    }

    public Set<Line> getNetworkRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getNetworkRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getNetworkRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getNetworkRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getNetworkRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getNetworkRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public ActorProfile getActorProfileById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getActorProfileById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getActorProfileById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getActorProfileById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getActorProfileById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ActorProfile gotactorProfile = ActorProfileMapper.mapOmrsEntityDetailToActorProfile(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getActorProfileById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotactorProfile);
        }
        return gotactorProfile;
    }

    public ActorProfile createActorProfile(String userId, ActorProfile actorProfile) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createActorProfileById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createActorProfileById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createActorProfileById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("ActorProfile");
        if (constraint != null) {
            constraint.preCreate(actorProfile);
        }
        EntityDetail entityDetail = ActorProfileMapper.mapActorProfileToOmrsEntityDetail(actorProfile);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        ActorProfile createdActorProfile = ActorProfileMapper.mapOmrsEntityDetailToActorProfile(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createActorProfileById,userId=" + userId + ", created ActorProfile=" + createdActorProfile);
        }
        return createdActorProfile;
    }

    public ActorProfile updateActorProfile(String userId, ActorProfile actorProfile) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateActorProfileById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateActorProfileById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateActorProfileById", (String)userId);
        EntityDetail entityDetail = ActorProfileMapper.mapActorProfileToOmrsEntityDetail(actorProfile);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateActorProfileById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        ActorProfile updatedActorProfile = ActorProfileMapper.mapOmrsEntityDetailToActorProfile(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateActorProfileById,userId=" + userId + ",updated ActorProfile=" + updatedActorProfile);
        }
        return updatedActorProfile;
    }

    public EntityDetail deleteActorProfileByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteActorProfileByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteActorProfileByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteActorProfileByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteActorProfileByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("ActorProfile");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "ActorProfile", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteActorProfileByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeActorProfileByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeActorProfileByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeActorProfileByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeActorProfileByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeActorProfileByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("ActorProfile");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "ActorProfile", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeActorProfileByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public ActorProfile restoreActorProfile(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreActorProfileByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreActorProfileByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreActorProfileByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreActorProfileByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        ActorProfile restoredActorProfile = ActorProfileMapper.mapOmrsEntityDetailToActorProfile(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreActorProfileByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredActorProfile;
    }

    public ActorProfile addActorProfileClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addActorProfileClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addActorProfileClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addActorProfileClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addActorProfileClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ActorProfile actorProfileClassifications = ActorProfileMapper.mapOmrsEntityDetailToActorProfile(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addActorProfileClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified ActorProfile=" + actorProfileClassifications);
        }
        return actorProfileClassifications;
    }

    public ActorProfile updateActorProfileClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateActorProfileClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateActorProfileClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateActorProfileClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateActorProfileClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateActorProfileClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateActorProfileClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ActorProfile actorProfileClassifications = ActorProfileMapper.mapOmrsEntityDetailToActorProfile(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateActorProfileClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return actorProfileClassifications;
    }

    public ActorProfile deleteActorProfileClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteActorProfileClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteActorProfileClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteActorProfileClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteActorProfileClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ActorProfile declassifiedActorProfile = ActorProfileMapper.mapOmrsEntityDetailToActorProfile(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteActorProfileClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedActorProfile;
    }

    public Set<Line> getActorProfileRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getActorProfileRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getActorProfileRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getActorProfileRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getActorProfileRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getActorProfileRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public Asset getAssetById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getAssetById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getAssetById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getAssetById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getAssetById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Asset gotasset = AssetMapper.mapOmrsEntityDetailToAsset(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getAssetById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotasset);
        }
        return gotasset;
    }

    public Asset createAsset(String userId, Asset asset) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createAssetById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createAssetById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createAssetById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Asset");
        if (constraint != null) {
            constraint.preCreate(asset);
        }
        EntityDetail entityDetail = AssetMapper.mapAssetToOmrsEntityDetail(asset);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        Asset createdAsset = AssetMapper.mapOmrsEntityDetailToAsset(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createAssetById,userId=" + userId + ", created Asset=" + createdAsset);
        }
        return createdAsset;
    }

    public Asset updateAsset(String userId, Asset asset) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateAssetById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateAssetById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateAssetById", (String)userId);
        EntityDetail entityDetail = AssetMapper.mapAssetToOmrsEntityDetail(asset);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateAssetById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        Asset updatedAsset = AssetMapper.mapOmrsEntityDetailToAsset(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateAssetById,userId=" + userId + ",updated Asset=" + updatedAsset);
        }
        return updatedAsset;
    }

    public EntityDetail deleteAssetByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteAssetByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteAssetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteAssetByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteAssetByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Asset");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "Asset", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteAssetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeAssetByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeAssetByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeAssetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeAssetByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeAssetByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Asset");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "Asset", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeAssetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public Asset restoreAsset(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreAssetByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreAssetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreAssetByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreAssetByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        Asset restoredAsset = AssetMapper.mapOmrsEntityDetailToAsset(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreAssetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredAsset;
    }

    public Asset addAssetClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addAssetClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addAssetClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addAssetClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addAssetClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Asset assetClassifications = AssetMapper.mapOmrsEntityDetailToAsset(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addAssetClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified Asset=" + assetClassifications);
        }
        return assetClassifications;
    }

    public Asset updateAssetClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateAssetClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateAssetClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateAssetClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateAssetClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateAssetClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateAssetClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Asset assetClassifications = AssetMapper.mapOmrsEntityDetailToAsset(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateAssetClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return assetClassifications;
    }

    public Asset deleteAssetClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteAssetClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteAssetClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteAssetClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteAssetClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Asset declassifiedAsset = AssetMapper.mapOmrsEntityDetailToAsset(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteAssetClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedAsset;
    }

    public Set<Line> getAssetRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getAssetRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getAssetRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getAssetRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getAssetRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getAssetRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public APIOperation getAPIOperationById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getAPIOperationById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getAPIOperationById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getAPIOperationById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getAPIOperationById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        APIOperation gotaPIOperation = APIOperationMapper.mapOmrsEntityDetailToAPIOperation(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getAPIOperationById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotaPIOperation);
        }
        return gotaPIOperation;
    }

    public APIOperation createAPIOperation(String userId, APIOperation aPIOperation) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createAPIOperationById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createAPIOperationById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createAPIOperationById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("APIOperation");
        if (constraint != null) {
            constraint.preCreate(aPIOperation);
        }
        EntityDetail entityDetail = APIOperationMapper.mapAPIOperationToOmrsEntityDetail(aPIOperation);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        APIOperation createdAPIOperation = APIOperationMapper.mapOmrsEntityDetailToAPIOperation(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createAPIOperationById,userId=" + userId + ", created APIOperation=" + createdAPIOperation);
        }
        return createdAPIOperation;
    }

    public APIOperation updateAPIOperation(String userId, APIOperation aPIOperation) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateAPIOperationById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateAPIOperationById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateAPIOperationById", (String)userId);
        EntityDetail entityDetail = APIOperationMapper.mapAPIOperationToOmrsEntityDetail(aPIOperation);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateAPIOperationById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        APIOperation updatedAPIOperation = APIOperationMapper.mapOmrsEntityDetailToAPIOperation(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateAPIOperationById,userId=" + userId + ",updated APIOperation=" + updatedAPIOperation);
        }
        return updatedAPIOperation;
    }

    public EntityDetail deleteAPIOperationByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteAPIOperationByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteAPIOperationByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteAPIOperationByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteAPIOperationByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("APIOperation");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "APIOperation", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteAPIOperationByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeAPIOperationByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeAPIOperationByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeAPIOperationByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeAPIOperationByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeAPIOperationByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("APIOperation");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "APIOperation", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeAPIOperationByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public APIOperation restoreAPIOperation(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreAPIOperationByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreAPIOperationByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreAPIOperationByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreAPIOperationByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        APIOperation restoredAPIOperation = APIOperationMapper.mapOmrsEntityDetailToAPIOperation(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreAPIOperationByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredAPIOperation;
    }

    public APIOperation addAPIOperationClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addAPIOperationClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addAPIOperationClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addAPIOperationClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addAPIOperationClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        APIOperation aPIOperationClassifications = APIOperationMapper.mapOmrsEntityDetailToAPIOperation(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addAPIOperationClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified APIOperation=" + aPIOperationClassifications);
        }
        return aPIOperationClassifications;
    }

    public APIOperation updateAPIOperationClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateAPIOperationClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateAPIOperationClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateAPIOperationClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateAPIOperationClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateAPIOperationClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateAPIOperationClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        APIOperation aPIOperationClassifications = APIOperationMapper.mapOmrsEntityDetailToAPIOperation(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateAPIOperationClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return aPIOperationClassifications;
    }

    public APIOperation deleteAPIOperationClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteAPIOperationClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteAPIOperationClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteAPIOperationClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteAPIOperationClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        APIOperation declassifiedAPIOperation = APIOperationMapper.mapOmrsEntityDetailToAPIOperation(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteAPIOperationClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedAPIOperation;
    }

    public Set<Line> getAPIOperationRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getAPIOperationRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getAPIOperationRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getAPIOperationRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getAPIOperationRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getAPIOperationRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public ToDo getToDoById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getToDoById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getToDoById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getToDoById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getToDoById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ToDo gottoDo = ToDoMapper.mapOmrsEntityDetailToToDo(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getToDoById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gottoDo);
        }
        return gottoDo;
    }

    public ToDo createToDo(String userId, ToDo toDo) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createToDoById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createToDoById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createToDoById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("ToDo");
        if (constraint != null) {
            constraint.preCreate(toDo);
        }
        EntityDetail entityDetail = ToDoMapper.mapToDoToOmrsEntityDetail(toDo);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        ToDo createdToDo = ToDoMapper.mapOmrsEntityDetailToToDo(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createToDoById,userId=" + userId + ", created ToDo=" + createdToDo);
        }
        return createdToDo;
    }

    public ToDo updateToDo(String userId, ToDo toDo) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateToDoById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateToDoById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateToDoById", (String)userId);
        EntityDetail entityDetail = ToDoMapper.mapToDoToOmrsEntityDetail(toDo);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateToDoById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        ToDo updatedToDo = ToDoMapper.mapOmrsEntityDetailToToDo(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateToDoById,userId=" + userId + ",updated ToDo=" + updatedToDo);
        }
        return updatedToDo;
    }

    public EntityDetail deleteToDoByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteToDoByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteToDoByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteToDoByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteToDoByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("ToDo");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "ToDo", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteToDoByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeToDoByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeToDoByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeToDoByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeToDoByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeToDoByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("ToDo");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "ToDo", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeToDoByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public ToDo restoreToDo(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreToDoByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreToDoByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreToDoByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreToDoByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        ToDo restoredToDo = ToDoMapper.mapOmrsEntityDetailToToDo(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreToDoByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredToDo;
    }

    public ToDo addToDoClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addToDoClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addToDoClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addToDoClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addToDoClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ToDo toDoClassifications = ToDoMapper.mapOmrsEntityDetailToToDo(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addToDoClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified ToDo=" + toDoClassifications);
        }
        return toDoClassifications;
    }

    public ToDo updateToDoClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateToDoClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateToDoClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateToDoClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateToDoClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateToDoClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateToDoClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ToDo toDoClassifications = ToDoMapper.mapOmrsEntityDetailToToDo(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateToDoClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return toDoClassifications;
    }

    public ToDo deleteToDoClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteToDoClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteToDoClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteToDoClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteToDoClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ToDo declassifiedToDo = ToDoMapper.mapOmrsEntityDetailToToDo(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteToDoClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedToDo;
    }

    public Set<Line> getToDoRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getToDoRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getToDoRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getToDoRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getToDoRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getToDoRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public NetworkGateway getNetworkGatewayById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getNetworkGatewayById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getNetworkGatewayById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getNetworkGatewayById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getNetworkGatewayById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        NetworkGateway gotnetworkGateway = NetworkGatewayMapper.mapOmrsEntityDetailToNetworkGateway(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getNetworkGatewayById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotnetworkGateway);
        }
        return gotnetworkGateway;
    }

    public NetworkGateway createNetworkGateway(String userId, NetworkGateway networkGateway) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createNetworkGatewayById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createNetworkGatewayById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createNetworkGatewayById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("NetworkGateway");
        if (constraint != null) {
            constraint.preCreate(networkGateway);
        }
        EntityDetail entityDetail = NetworkGatewayMapper.mapNetworkGatewayToOmrsEntityDetail(networkGateway);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        NetworkGateway createdNetworkGateway = NetworkGatewayMapper.mapOmrsEntityDetailToNetworkGateway(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createNetworkGatewayById,userId=" + userId + ", created NetworkGateway=" + createdNetworkGateway);
        }
        return createdNetworkGateway;
    }

    public NetworkGateway updateNetworkGateway(String userId, NetworkGateway networkGateway) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateNetworkGatewayById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateNetworkGatewayById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateNetworkGatewayById", (String)userId);
        EntityDetail entityDetail = NetworkGatewayMapper.mapNetworkGatewayToOmrsEntityDetail(networkGateway);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateNetworkGatewayById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        NetworkGateway updatedNetworkGateway = NetworkGatewayMapper.mapOmrsEntityDetailToNetworkGateway(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateNetworkGatewayById,userId=" + userId + ",updated NetworkGateway=" + updatedNetworkGateway);
        }
        return updatedNetworkGateway;
    }

    public EntityDetail deleteNetworkGatewayByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteNetworkGatewayByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteNetworkGatewayByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteNetworkGatewayByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteNetworkGatewayByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("NetworkGateway");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "NetworkGateway", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteNetworkGatewayByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeNetworkGatewayByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeNetworkGatewayByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeNetworkGatewayByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeNetworkGatewayByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeNetworkGatewayByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("NetworkGateway");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "NetworkGateway", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeNetworkGatewayByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public NetworkGateway restoreNetworkGateway(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreNetworkGatewayByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreNetworkGatewayByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreNetworkGatewayByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreNetworkGatewayByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        NetworkGateway restoredNetworkGateway = NetworkGatewayMapper.mapOmrsEntityDetailToNetworkGateway(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreNetworkGatewayByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredNetworkGateway;
    }

    public NetworkGateway addNetworkGatewayClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addNetworkGatewayClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addNetworkGatewayClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addNetworkGatewayClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addNetworkGatewayClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        NetworkGateway networkGatewayClassifications = NetworkGatewayMapper.mapOmrsEntityDetailToNetworkGateway(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addNetworkGatewayClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified NetworkGateway=" + networkGatewayClassifications);
        }
        return networkGatewayClassifications;
    }

    public NetworkGateway updateNetworkGatewayClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateNetworkGatewayClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateNetworkGatewayClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateNetworkGatewayClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateNetworkGatewayClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateNetworkGatewayClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateNetworkGatewayClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        NetworkGateway networkGatewayClassifications = NetworkGatewayMapper.mapOmrsEntityDetailToNetworkGateway(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateNetworkGatewayClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return networkGatewayClassifications;
    }

    public NetworkGateway deleteNetworkGatewayClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteNetworkGatewayClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteNetworkGatewayClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteNetworkGatewayClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteNetworkGatewayClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        NetworkGateway declassifiedNetworkGateway = NetworkGatewayMapper.mapOmrsEntityDetailToNetworkGateway(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteNetworkGatewayClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedNetworkGateway;
    }

    public Set<Line> getNetworkGatewayRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getNetworkGatewayRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getNetworkGatewayRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getNetworkGatewayRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getNetworkGatewayRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getNetworkGatewayRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public GovernanceResponsibility getGovernanceResponsibilityById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getGovernanceResponsibilityById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGovernanceResponsibilityById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGovernanceResponsibilityById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGovernanceResponsibilityById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceResponsibility gotgovernanceResponsibility = GovernanceResponsibilityMapper.mapOmrsEntityDetailToGovernanceResponsibility(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGovernanceResponsibilityById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotgovernanceResponsibility);
        }
        return gotgovernanceResponsibility;
    }

    public GovernanceResponsibility createGovernanceResponsibility(String userId, GovernanceResponsibility governanceResponsibility) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createGovernanceResponsibilityById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createGovernanceResponsibilityById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createGovernanceResponsibilityById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("GovernanceResponsibility");
        if (constraint != null) {
            constraint.preCreate(governanceResponsibility);
        }
        EntityDetail entityDetail = GovernanceResponsibilityMapper.mapGovernanceResponsibilityToOmrsEntityDetail(governanceResponsibility);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        GovernanceResponsibility createdGovernanceResponsibility = GovernanceResponsibilityMapper.mapOmrsEntityDetailToGovernanceResponsibility(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createGovernanceResponsibilityById,userId=" + userId + ", created GovernanceResponsibility=" + createdGovernanceResponsibility);
        }
        return createdGovernanceResponsibility;
    }

    public GovernanceResponsibility updateGovernanceResponsibility(String userId, GovernanceResponsibility governanceResponsibility) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateGovernanceResponsibilityById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGovernanceResponsibilityById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGovernanceResponsibilityById", (String)userId);
        EntityDetail entityDetail = GovernanceResponsibilityMapper.mapGovernanceResponsibilityToOmrsEntityDetail(governanceResponsibility);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGovernanceResponsibilityById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        GovernanceResponsibility updatedGovernanceResponsibility = GovernanceResponsibilityMapper.mapOmrsEntityDetailToGovernanceResponsibility(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateGovernanceResponsibilityById,userId=" + userId + ",updated GovernanceResponsibility=" + updatedGovernanceResponsibility);
        }
        return updatedGovernanceResponsibility;
    }

    public EntityDetail deleteGovernanceResponsibilityByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteGovernanceResponsibilityByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGovernanceResponsibilityByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGovernanceResponsibilityByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGovernanceResponsibilityByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernanceResponsibility");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "GovernanceResponsibility", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGovernanceResponsibilityByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeGovernanceResponsibilityByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeGovernanceResponsibilityByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeGovernanceResponsibilityByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeGovernanceResponsibilityByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeGovernanceResponsibilityByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernanceResponsibility");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "GovernanceResponsibility", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeGovernanceResponsibilityByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public GovernanceResponsibility restoreGovernanceResponsibility(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreGovernanceResponsibilityByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreGovernanceResponsibilityByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreGovernanceResponsibilityByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreGovernanceResponsibilityByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        GovernanceResponsibility restoredGovernanceResponsibility = GovernanceResponsibilityMapper.mapOmrsEntityDetailToGovernanceResponsibility(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreGovernanceResponsibilityByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredGovernanceResponsibility;
    }

    public GovernanceResponsibility addGovernanceResponsibilityClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addGovernanceResponsibilityClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addGovernanceResponsibilityClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addGovernanceResponsibilityClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addGovernanceResponsibilityClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceResponsibility governanceResponsibilityClassifications = GovernanceResponsibilityMapper.mapOmrsEntityDetailToGovernanceResponsibility(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addGovernanceResponsibilityClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified GovernanceResponsibility=" + governanceResponsibilityClassifications);
        }
        return governanceResponsibilityClassifications;
    }

    public GovernanceResponsibility updateGovernanceResponsibilityClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateGovernanceResponsibilityClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGovernanceResponsibilityClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGovernanceResponsibilityClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGovernanceResponsibilityClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateGovernanceResponsibilityClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateGovernanceResponsibilityClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceResponsibility governanceResponsibilityClassifications = GovernanceResponsibilityMapper.mapOmrsEntityDetailToGovernanceResponsibility(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateGovernanceResponsibilityClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return governanceResponsibilityClassifications;
    }

    public GovernanceResponsibility deleteGovernanceResponsibilityClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteGovernanceResponsibilityClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGovernanceResponsibilityClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGovernanceResponsibilityClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGovernanceResponsibilityClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceResponsibility declassifiedGovernanceResponsibility = GovernanceResponsibilityMapper.mapOmrsEntityDetailToGovernanceResponsibility(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGovernanceResponsibilityClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedGovernanceResponsibility;
    }

    public Set<Line> getGovernanceResponsibilityRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getGovernanceResponsibilityRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGovernanceResponsibilityRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGovernanceResponsibilityRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGovernanceResponsibilityRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGovernanceResponsibilityRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public ImplementationSnippet getImplementationSnippetById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getImplementationSnippetById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getImplementationSnippetById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getImplementationSnippetById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getImplementationSnippetById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ImplementationSnippet gotimplementationSnippet = ImplementationSnippetMapper.mapOmrsEntityDetailToImplementationSnippet(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getImplementationSnippetById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotimplementationSnippet);
        }
        return gotimplementationSnippet;
    }

    public ImplementationSnippet createImplementationSnippet(String userId, ImplementationSnippet implementationSnippet) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createImplementationSnippetById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createImplementationSnippetById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createImplementationSnippetById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("ImplementationSnippet");
        if (constraint != null) {
            constraint.preCreate(implementationSnippet);
        }
        EntityDetail entityDetail = ImplementationSnippetMapper.mapImplementationSnippetToOmrsEntityDetail(implementationSnippet);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        ImplementationSnippet createdImplementationSnippet = ImplementationSnippetMapper.mapOmrsEntityDetailToImplementationSnippet(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createImplementationSnippetById,userId=" + userId + ", created ImplementationSnippet=" + createdImplementationSnippet);
        }
        return createdImplementationSnippet;
    }

    public ImplementationSnippet updateImplementationSnippet(String userId, ImplementationSnippet implementationSnippet) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateImplementationSnippetById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateImplementationSnippetById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateImplementationSnippetById", (String)userId);
        EntityDetail entityDetail = ImplementationSnippetMapper.mapImplementationSnippetToOmrsEntityDetail(implementationSnippet);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateImplementationSnippetById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        ImplementationSnippet updatedImplementationSnippet = ImplementationSnippetMapper.mapOmrsEntityDetailToImplementationSnippet(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateImplementationSnippetById,userId=" + userId + ",updated ImplementationSnippet=" + updatedImplementationSnippet);
        }
        return updatedImplementationSnippet;
    }

    public EntityDetail deleteImplementationSnippetByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteImplementationSnippetByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteImplementationSnippetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteImplementationSnippetByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteImplementationSnippetByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("ImplementationSnippet");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "ImplementationSnippet", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteImplementationSnippetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeImplementationSnippetByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeImplementationSnippetByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeImplementationSnippetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeImplementationSnippetByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeImplementationSnippetByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("ImplementationSnippet");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "ImplementationSnippet", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeImplementationSnippetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public ImplementationSnippet restoreImplementationSnippet(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreImplementationSnippetByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreImplementationSnippetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreImplementationSnippetByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreImplementationSnippetByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        ImplementationSnippet restoredImplementationSnippet = ImplementationSnippetMapper.mapOmrsEntityDetailToImplementationSnippet(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreImplementationSnippetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredImplementationSnippet;
    }

    public ImplementationSnippet addImplementationSnippetClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addImplementationSnippetClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addImplementationSnippetClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addImplementationSnippetClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addImplementationSnippetClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ImplementationSnippet implementationSnippetClassifications = ImplementationSnippetMapper.mapOmrsEntityDetailToImplementationSnippet(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addImplementationSnippetClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified ImplementationSnippet=" + implementationSnippetClassifications);
        }
        return implementationSnippetClassifications;
    }

    public ImplementationSnippet updateImplementationSnippetClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateImplementationSnippetClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateImplementationSnippetClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateImplementationSnippetClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateImplementationSnippetClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateImplementationSnippetClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateImplementationSnippetClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ImplementationSnippet implementationSnippetClassifications = ImplementationSnippetMapper.mapOmrsEntityDetailToImplementationSnippet(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateImplementationSnippetClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return implementationSnippetClassifications;
    }

    public ImplementationSnippet deleteImplementationSnippetClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteImplementationSnippetClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteImplementationSnippetClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteImplementationSnippetClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteImplementationSnippetClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ImplementationSnippet declassifiedImplementationSnippet = ImplementationSnippetMapper.mapOmrsEntityDetailToImplementationSnippet(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteImplementationSnippetClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedImplementationSnippet;
    }

    public Set<Line> getImplementationSnippetRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getImplementationSnippetRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getImplementationSnippetRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getImplementationSnippetRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getImplementationSnippetRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getImplementationSnippetRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public UserIdentity getUserIdentityById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getUserIdentityById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getUserIdentityById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getUserIdentityById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getUserIdentityById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        UserIdentity gotuserIdentity = UserIdentityMapper.mapOmrsEntityDetailToUserIdentity(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getUserIdentityById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotuserIdentity);
        }
        return gotuserIdentity;
    }

    public UserIdentity createUserIdentity(String userId, UserIdentity userIdentity) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createUserIdentityById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createUserIdentityById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createUserIdentityById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("UserIdentity");
        if (constraint != null) {
            constraint.preCreate(userIdentity);
        }
        EntityDetail entityDetail = UserIdentityMapper.mapUserIdentityToOmrsEntityDetail(userIdentity);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        UserIdentity createdUserIdentity = UserIdentityMapper.mapOmrsEntityDetailToUserIdentity(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createUserIdentityById,userId=" + userId + ", created UserIdentity=" + createdUserIdentity);
        }
        return createdUserIdentity;
    }

    public UserIdentity updateUserIdentity(String userId, UserIdentity userIdentity) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateUserIdentityById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateUserIdentityById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateUserIdentityById", (String)userId);
        EntityDetail entityDetail = UserIdentityMapper.mapUserIdentityToOmrsEntityDetail(userIdentity);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateUserIdentityById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        UserIdentity updatedUserIdentity = UserIdentityMapper.mapOmrsEntityDetailToUserIdentity(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateUserIdentityById,userId=" + userId + ",updated UserIdentity=" + updatedUserIdentity);
        }
        return updatedUserIdentity;
    }

    public EntityDetail deleteUserIdentityByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteUserIdentityByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteUserIdentityByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteUserIdentityByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteUserIdentityByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("UserIdentity");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "UserIdentity", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteUserIdentityByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeUserIdentityByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeUserIdentityByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeUserIdentityByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeUserIdentityByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeUserIdentityByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("UserIdentity");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "UserIdentity", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeUserIdentityByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public UserIdentity restoreUserIdentity(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreUserIdentityByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreUserIdentityByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreUserIdentityByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreUserIdentityByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        UserIdentity restoredUserIdentity = UserIdentityMapper.mapOmrsEntityDetailToUserIdentity(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreUserIdentityByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredUserIdentity;
    }

    public UserIdentity addUserIdentityClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addUserIdentityClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addUserIdentityClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addUserIdentityClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addUserIdentityClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        UserIdentity userIdentityClassifications = UserIdentityMapper.mapOmrsEntityDetailToUserIdentity(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addUserIdentityClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified UserIdentity=" + userIdentityClassifications);
        }
        return userIdentityClassifications;
    }

    public UserIdentity updateUserIdentityClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateUserIdentityClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateUserIdentityClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateUserIdentityClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateUserIdentityClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateUserIdentityClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateUserIdentityClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        UserIdentity userIdentityClassifications = UserIdentityMapper.mapOmrsEntityDetailToUserIdentity(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateUserIdentityClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return userIdentityClassifications;
    }

    public UserIdentity deleteUserIdentityClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteUserIdentityClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteUserIdentityClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteUserIdentityClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteUserIdentityClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        UserIdentity declassifiedUserIdentity = UserIdentityMapper.mapOmrsEntityDetailToUserIdentity(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteUserIdentityClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedUserIdentity;
    }

    public Set<Line> getUserIdentityRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getUserIdentityRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getUserIdentityRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getUserIdentityRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getUserIdentityRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getUserIdentityRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public NoteEntry getNoteEntryById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getNoteEntryById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getNoteEntryById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getNoteEntryById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getNoteEntryById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        NoteEntry gotnoteEntry = NoteEntryMapper.mapOmrsEntityDetailToNoteEntry(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getNoteEntryById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotnoteEntry);
        }
        return gotnoteEntry;
    }

    public NoteEntry createNoteEntry(String userId, NoteEntry noteEntry) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createNoteEntryById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createNoteEntryById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createNoteEntryById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("NoteEntry");
        if (constraint != null) {
            constraint.preCreate(noteEntry);
        }
        EntityDetail entityDetail = NoteEntryMapper.mapNoteEntryToOmrsEntityDetail(noteEntry);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        NoteEntry createdNoteEntry = NoteEntryMapper.mapOmrsEntityDetailToNoteEntry(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createNoteEntryById,userId=" + userId + ", created NoteEntry=" + createdNoteEntry);
        }
        return createdNoteEntry;
    }

    public NoteEntry updateNoteEntry(String userId, NoteEntry noteEntry) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateNoteEntryById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateNoteEntryById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateNoteEntryById", (String)userId);
        EntityDetail entityDetail = NoteEntryMapper.mapNoteEntryToOmrsEntityDetail(noteEntry);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateNoteEntryById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        NoteEntry updatedNoteEntry = NoteEntryMapper.mapOmrsEntityDetailToNoteEntry(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateNoteEntryById,userId=" + userId + ",updated NoteEntry=" + updatedNoteEntry);
        }
        return updatedNoteEntry;
    }

    public EntityDetail deleteNoteEntryByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteNoteEntryByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteNoteEntryByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteNoteEntryByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteNoteEntryByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("NoteEntry");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "NoteEntry", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteNoteEntryByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeNoteEntryByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeNoteEntryByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeNoteEntryByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeNoteEntryByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeNoteEntryByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("NoteEntry");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "NoteEntry", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeNoteEntryByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public NoteEntry restoreNoteEntry(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreNoteEntryByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreNoteEntryByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreNoteEntryByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreNoteEntryByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        NoteEntry restoredNoteEntry = NoteEntryMapper.mapOmrsEntityDetailToNoteEntry(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreNoteEntryByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredNoteEntry;
    }

    public NoteEntry addNoteEntryClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addNoteEntryClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addNoteEntryClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addNoteEntryClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addNoteEntryClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        NoteEntry noteEntryClassifications = NoteEntryMapper.mapOmrsEntityDetailToNoteEntry(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addNoteEntryClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified NoteEntry=" + noteEntryClassifications);
        }
        return noteEntryClassifications;
    }

    public NoteEntry updateNoteEntryClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateNoteEntryClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateNoteEntryClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateNoteEntryClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateNoteEntryClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateNoteEntryClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateNoteEntryClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        NoteEntry noteEntryClassifications = NoteEntryMapper.mapOmrsEntityDetailToNoteEntry(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateNoteEntryClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return noteEntryClassifications;
    }

    public NoteEntry deleteNoteEntryClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteNoteEntryClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteNoteEntryClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteNoteEntryClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteNoteEntryClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        NoteEntry declassifiedNoteEntry = NoteEntryMapper.mapOmrsEntityDetailToNoteEntry(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteNoteEntryClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedNoteEntry;
    }

    public Set<Line> getNoteEntryRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getNoteEntryRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getNoteEntryRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getNoteEntryRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getNoteEntryRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getNoteEntryRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public PropertyFacet getPropertyFacetById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getPropertyFacetById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getPropertyFacetById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getPropertyFacetById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getPropertyFacetById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        PropertyFacet gotpropertyFacet = PropertyFacetMapper.mapOmrsEntityDetailToPropertyFacet(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getPropertyFacetById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotpropertyFacet);
        }
        return gotpropertyFacet;
    }

    public PropertyFacet createPropertyFacet(String userId, PropertyFacet propertyFacet) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createPropertyFacetById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createPropertyFacetById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createPropertyFacetById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("PropertyFacet");
        if (constraint != null) {
            constraint.preCreate(propertyFacet);
        }
        EntityDetail entityDetail = PropertyFacetMapper.mapPropertyFacetToOmrsEntityDetail(propertyFacet);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        PropertyFacet createdPropertyFacet = PropertyFacetMapper.mapOmrsEntityDetailToPropertyFacet(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createPropertyFacetById,userId=" + userId + ", created PropertyFacet=" + createdPropertyFacet);
        }
        return createdPropertyFacet;
    }

    public PropertyFacet updatePropertyFacet(String userId, PropertyFacet propertyFacet) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updatePropertyFacetById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updatePropertyFacetById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updatePropertyFacetById", (String)userId);
        EntityDetail entityDetail = PropertyFacetMapper.mapPropertyFacetToOmrsEntityDetail(propertyFacet);
        InputValidator.validateGUIDNotNull((String)className, (String)"updatePropertyFacetById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        PropertyFacet updatedPropertyFacet = PropertyFacetMapper.mapOmrsEntityDetailToPropertyFacet(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updatePropertyFacetById,userId=" + userId + ",updated PropertyFacet=" + updatedPropertyFacet);
        }
        return updatedPropertyFacet;
    }

    public EntityDetail deletePropertyFacetByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deletePropertyFacetByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deletePropertyFacetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deletePropertyFacetByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deletePropertyFacetByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("PropertyFacet");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "PropertyFacet", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deletePropertyFacetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgePropertyFacetByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgePropertyFacetByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgePropertyFacetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgePropertyFacetByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgePropertyFacetByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("PropertyFacet");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "PropertyFacet", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgePropertyFacetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public PropertyFacet restorePropertyFacet(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restorePropertyFacetByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restorePropertyFacetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restorePropertyFacetByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restorePropertyFacetByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        PropertyFacet restoredPropertyFacet = PropertyFacetMapper.mapOmrsEntityDetailToPropertyFacet(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restorePropertyFacetByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredPropertyFacet;
    }

    public PropertyFacet addPropertyFacetClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addPropertyFacetClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addPropertyFacetClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addPropertyFacetClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addPropertyFacetClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        PropertyFacet propertyFacetClassifications = PropertyFacetMapper.mapOmrsEntityDetailToPropertyFacet(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addPropertyFacetClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified PropertyFacet=" + propertyFacetClassifications);
        }
        return propertyFacetClassifications;
    }

    public PropertyFacet updatePropertyFacetClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updatePropertyFacetClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updatePropertyFacetClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updatePropertyFacetClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updatePropertyFacetClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updatePropertyFacetClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updatePropertyFacetClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        PropertyFacet propertyFacetClassifications = PropertyFacetMapper.mapOmrsEntityDetailToPropertyFacet(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updatePropertyFacetClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return propertyFacetClassifications;
    }

    public PropertyFacet deletePropertyFacetClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deletePropertyFacetClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deletePropertyFacetClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deletePropertyFacetClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deletePropertyFacetClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        PropertyFacet declassifiedPropertyFacet = PropertyFacetMapper.mapOmrsEntityDetailToPropertyFacet(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deletePropertyFacetClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedPropertyFacet;
    }

    public Set<Line> getPropertyFacetRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getPropertyFacetRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getPropertyFacetRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getPropertyFacetRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getPropertyFacetRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getPropertyFacetRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public Project getProjectById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getProjectById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getProjectById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getProjectById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getProjectById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Project gotproject = ProjectMapper.mapOmrsEntityDetailToProject(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getProjectById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotproject);
        }
        return gotproject;
    }

    public Project createProject(String userId, Project project) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createProjectById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createProjectById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createProjectById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Project");
        if (constraint != null) {
            constraint.preCreate(project);
        }
        EntityDetail entityDetail = ProjectMapper.mapProjectToOmrsEntityDetail(project);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        Project createdProject = ProjectMapper.mapOmrsEntityDetailToProject(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createProjectById,userId=" + userId + ", created Project=" + createdProject);
        }
        return createdProject;
    }

    public Project updateProject(String userId, Project project) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateProjectById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateProjectById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateProjectById", (String)userId);
        EntityDetail entityDetail = ProjectMapper.mapProjectToOmrsEntityDetail(project);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateProjectById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        Project updatedProject = ProjectMapper.mapOmrsEntityDetailToProject(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateProjectById,userId=" + userId + ",updated Project=" + updatedProject);
        }
        return updatedProject;
    }

    public EntityDetail deleteProjectByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteProjectByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteProjectByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteProjectByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteProjectByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Project");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "Project", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteProjectByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeProjectByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeProjectByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeProjectByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeProjectByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeProjectByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Project");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "Project", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeProjectByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public Project restoreProject(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreProjectByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreProjectByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreProjectByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreProjectByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        Project restoredProject = ProjectMapper.mapOmrsEntityDetailToProject(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreProjectByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredProject;
    }

    public Project addProjectClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addProjectClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addProjectClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addProjectClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addProjectClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Project projectClassifications = ProjectMapper.mapOmrsEntityDetailToProject(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addProjectClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified Project=" + projectClassifications);
        }
        return projectClassifications;
    }

    public Project updateProjectClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateProjectClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateProjectClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateProjectClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateProjectClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateProjectClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateProjectClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Project projectClassifications = ProjectMapper.mapOmrsEntityDetailToProject(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateProjectClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return projectClassifications;
    }

    public Project deleteProjectClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteProjectClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteProjectClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteProjectClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteProjectClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Project declassifiedProject = ProjectMapper.mapOmrsEntityDetailToProject(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteProjectClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedProject;
    }

    public Set<Line> getProjectRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getProjectRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getProjectRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getProjectRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getProjectRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getProjectRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public HostCluster getHostClusterById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getHostClusterById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getHostClusterById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getHostClusterById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getHostClusterById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        HostCluster gothostCluster = HostClusterMapper.mapOmrsEntityDetailToHostCluster(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getHostClusterById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gothostCluster);
        }
        return gothostCluster;
    }

    public HostCluster createHostCluster(String userId, HostCluster hostCluster) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createHostClusterById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createHostClusterById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createHostClusterById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("HostCluster");
        if (constraint != null) {
            constraint.preCreate(hostCluster);
        }
        EntityDetail entityDetail = HostClusterMapper.mapHostClusterToOmrsEntityDetail(hostCluster);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        HostCluster createdHostCluster = HostClusterMapper.mapOmrsEntityDetailToHostCluster(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createHostClusterById,userId=" + userId + ", created HostCluster=" + createdHostCluster);
        }
        return createdHostCluster;
    }

    public HostCluster updateHostCluster(String userId, HostCluster hostCluster) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateHostClusterById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateHostClusterById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateHostClusterById", (String)userId);
        EntityDetail entityDetail = HostClusterMapper.mapHostClusterToOmrsEntityDetail(hostCluster);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateHostClusterById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        HostCluster updatedHostCluster = HostClusterMapper.mapOmrsEntityDetailToHostCluster(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateHostClusterById,userId=" + userId + ",updated HostCluster=" + updatedHostCluster);
        }
        return updatedHostCluster;
    }

    public EntityDetail deleteHostClusterByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteHostClusterByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteHostClusterByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteHostClusterByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteHostClusterByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("HostCluster");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "HostCluster", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteHostClusterByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeHostClusterByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeHostClusterByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeHostClusterByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeHostClusterByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeHostClusterByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("HostCluster");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "HostCluster", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeHostClusterByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public HostCluster restoreHostCluster(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreHostClusterByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreHostClusterByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreHostClusterByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreHostClusterByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        HostCluster restoredHostCluster = HostClusterMapper.mapOmrsEntityDetailToHostCluster(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreHostClusterByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredHostCluster;
    }

    public HostCluster addHostClusterClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addHostClusterClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addHostClusterClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addHostClusterClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addHostClusterClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        HostCluster hostClusterClassifications = HostClusterMapper.mapOmrsEntityDetailToHostCluster(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addHostClusterClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified HostCluster=" + hostClusterClassifications);
        }
        return hostClusterClassifications;
    }

    public HostCluster updateHostClusterClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateHostClusterClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateHostClusterClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateHostClusterClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateHostClusterClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateHostClusterClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateHostClusterClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        HostCluster hostClusterClassifications = HostClusterMapper.mapOmrsEntityDetailToHostCluster(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateHostClusterClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return hostClusterClassifications;
    }

    public HostCluster deleteHostClusterClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteHostClusterClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteHostClusterClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteHostClusterClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteHostClusterClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        HostCluster declassifiedHostCluster = HostClusterMapper.mapOmrsEntityDetailToHostCluster(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteHostClusterClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedHostCluster;
    }

    public Set<Line> getHostClusterRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getHostClusterRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getHostClusterRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getHostClusterRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getHostClusterRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getHostClusterRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public Glossary getGlossaryById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getGlossaryById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGlossaryById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGlossaryById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGlossaryById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Glossary gotglossary = GlossaryMapper.mapOmrsEntityDetailToGlossary(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGlossaryById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotglossary);
        }
        return gotglossary;
    }

    public Glossary createGlossary(String userId, Glossary glossary) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createGlossaryById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createGlossaryById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createGlossaryById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Glossary");
        if (constraint != null) {
            constraint.preCreate(glossary);
        }
        EntityDetail entityDetail = GlossaryMapper.mapGlossaryToOmrsEntityDetail(glossary);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        Glossary createdGlossary = GlossaryMapper.mapOmrsEntityDetailToGlossary(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createGlossaryById,userId=" + userId + ", created Glossary=" + createdGlossary);
        }
        return createdGlossary;
    }

    public Glossary updateGlossary(String userId, Glossary glossary) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateGlossaryById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGlossaryById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGlossaryById", (String)userId);
        EntityDetail entityDetail = GlossaryMapper.mapGlossaryToOmrsEntityDetail(glossary);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGlossaryById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        Glossary updatedGlossary = GlossaryMapper.mapOmrsEntityDetailToGlossary(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateGlossaryById,userId=" + userId + ",updated Glossary=" + updatedGlossary);
        }
        return updatedGlossary;
    }

    public EntityDetail deleteGlossaryByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteGlossaryByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGlossaryByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGlossaryByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGlossaryByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Glossary");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "Glossary", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGlossaryByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeGlossaryByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeGlossaryByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeGlossaryByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeGlossaryByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeGlossaryByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Glossary");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "Glossary", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeGlossaryByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public Glossary restoreGlossary(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreGlossaryByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreGlossaryByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreGlossaryByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreGlossaryByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        Glossary restoredGlossary = GlossaryMapper.mapOmrsEntityDetailToGlossary(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreGlossaryByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredGlossary;
    }

    public Glossary addGlossaryClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addGlossaryClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addGlossaryClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addGlossaryClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addGlossaryClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Glossary glossaryClassifications = GlossaryMapper.mapOmrsEntityDetailToGlossary(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addGlossaryClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified Glossary=" + glossaryClassifications);
        }
        return glossaryClassifications;
    }

    public Glossary updateGlossaryClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateGlossaryClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGlossaryClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGlossaryClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGlossaryClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateGlossaryClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateGlossaryClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Glossary glossaryClassifications = GlossaryMapper.mapOmrsEntityDetailToGlossary(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateGlossaryClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return glossaryClassifications;
    }

    public Glossary deleteGlossaryClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteGlossaryClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGlossaryClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGlossaryClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGlossaryClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Glossary declassifiedGlossary = GlossaryMapper.mapOmrsEntityDetailToGlossary(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGlossaryClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedGlossary;
    }

    public Set<Line> getGlossaryRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getGlossaryRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGlossaryRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGlossaryRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGlossaryRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGlossaryRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public GlossaryCategory getGlossaryCategoryById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getGlossaryCategoryById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGlossaryCategoryById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGlossaryCategoryById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGlossaryCategoryById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GlossaryCategory gotglossaryCategory = GlossaryCategoryMapper.mapOmrsEntityDetailToGlossaryCategory(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGlossaryCategoryById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotglossaryCategory);
        }
        return gotglossaryCategory;
    }

    public GlossaryCategory createGlossaryCategory(String userId, GlossaryCategory glossaryCategory) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createGlossaryCategoryById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createGlossaryCategoryById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createGlossaryCategoryById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("GlossaryCategory");
        if (constraint != null) {
            constraint.preCreate(glossaryCategory);
        }
        EntityDetail entityDetail = GlossaryCategoryMapper.mapGlossaryCategoryToOmrsEntityDetail(glossaryCategory);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        GlossaryCategory createdGlossaryCategory = GlossaryCategoryMapper.mapOmrsEntityDetailToGlossaryCategory(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createGlossaryCategoryById,userId=" + userId + ", created GlossaryCategory=" + createdGlossaryCategory);
        }
        return createdGlossaryCategory;
    }

    public GlossaryCategory updateGlossaryCategory(String userId, GlossaryCategory glossaryCategory) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateGlossaryCategoryById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGlossaryCategoryById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGlossaryCategoryById", (String)userId);
        EntityDetail entityDetail = GlossaryCategoryMapper.mapGlossaryCategoryToOmrsEntityDetail(glossaryCategory);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGlossaryCategoryById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        GlossaryCategory updatedGlossaryCategory = GlossaryCategoryMapper.mapOmrsEntityDetailToGlossaryCategory(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateGlossaryCategoryById,userId=" + userId + ",updated GlossaryCategory=" + updatedGlossaryCategory);
        }
        return updatedGlossaryCategory;
    }

    public EntityDetail deleteGlossaryCategoryByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteGlossaryCategoryByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGlossaryCategoryByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGlossaryCategoryByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGlossaryCategoryByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GlossaryCategory");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "GlossaryCategory", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGlossaryCategoryByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeGlossaryCategoryByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeGlossaryCategoryByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeGlossaryCategoryByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeGlossaryCategoryByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeGlossaryCategoryByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GlossaryCategory");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "GlossaryCategory", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeGlossaryCategoryByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public GlossaryCategory restoreGlossaryCategory(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreGlossaryCategoryByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreGlossaryCategoryByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreGlossaryCategoryByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreGlossaryCategoryByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        GlossaryCategory restoredGlossaryCategory = GlossaryCategoryMapper.mapOmrsEntityDetailToGlossaryCategory(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreGlossaryCategoryByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredGlossaryCategory;
    }

    public GlossaryCategory addGlossaryCategoryClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addGlossaryCategoryClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addGlossaryCategoryClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addGlossaryCategoryClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addGlossaryCategoryClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GlossaryCategory glossaryCategoryClassifications = GlossaryCategoryMapper.mapOmrsEntityDetailToGlossaryCategory(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addGlossaryCategoryClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified GlossaryCategory=" + glossaryCategoryClassifications);
        }
        return glossaryCategoryClassifications;
    }

    public GlossaryCategory updateGlossaryCategoryClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateGlossaryCategoryClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGlossaryCategoryClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGlossaryCategoryClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGlossaryCategoryClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateGlossaryCategoryClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateGlossaryCategoryClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GlossaryCategory glossaryCategoryClassifications = GlossaryCategoryMapper.mapOmrsEntityDetailToGlossaryCategory(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateGlossaryCategoryClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return glossaryCategoryClassifications;
    }

    public GlossaryCategory deleteGlossaryCategoryClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteGlossaryCategoryClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGlossaryCategoryClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGlossaryCategoryClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGlossaryCategoryClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GlossaryCategory declassifiedGlossaryCategory = GlossaryCategoryMapper.mapOmrsEntityDetailToGlossaryCategory(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGlossaryCategoryClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedGlossaryCategory;
    }

    public Set<Line> getGlossaryCategoryRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getGlossaryCategoryRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGlossaryCategoryRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGlossaryCategoryRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGlossaryCategoryRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGlossaryCategoryRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public MediaCollection getMediaCollectionById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getMediaCollectionById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getMediaCollectionById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getMediaCollectionById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getMediaCollectionById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        MediaCollection gotmediaCollection = MediaCollectionMapper.mapOmrsEntityDetailToMediaCollection(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getMediaCollectionById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotmediaCollection);
        }
        return gotmediaCollection;
    }

    public MediaCollection createMediaCollection(String userId, MediaCollection mediaCollection) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createMediaCollectionById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createMediaCollectionById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createMediaCollectionById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("MediaCollection");
        if (constraint != null) {
            constraint.preCreate(mediaCollection);
        }
        EntityDetail entityDetail = MediaCollectionMapper.mapMediaCollectionToOmrsEntityDetail(mediaCollection);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        MediaCollection createdMediaCollection = MediaCollectionMapper.mapOmrsEntityDetailToMediaCollection(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createMediaCollectionById,userId=" + userId + ", created MediaCollection=" + createdMediaCollection);
        }
        return createdMediaCollection;
    }

    public MediaCollection updateMediaCollection(String userId, MediaCollection mediaCollection) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateMediaCollectionById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateMediaCollectionById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateMediaCollectionById", (String)userId);
        EntityDetail entityDetail = MediaCollectionMapper.mapMediaCollectionToOmrsEntityDetail(mediaCollection);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateMediaCollectionById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        MediaCollection updatedMediaCollection = MediaCollectionMapper.mapOmrsEntityDetailToMediaCollection(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateMediaCollectionById,userId=" + userId + ",updated MediaCollection=" + updatedMediaCollection);
        }
        return updatedMediaCollection;
    }

    public EntityDetail deleteMediaCollectionByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteMediaCollectionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteMediaCollectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteMediaCollectionByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteMediaCollectionByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("MediaCollection");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "MediaCollection", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteMediaCollectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeMediaCollectionByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeMediaCollectionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeMediaCollectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeMediaCollectionByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeMediaCollectionByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("MediaCollection");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "MediaCollection", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeMediaCollectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public MediaCollection restoreMediaCollection(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreMediaCollectionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreMediaCollectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreMediaCollectionByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreMediaCollectionByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        MediaCollection restoredMediaCollection = MediaCollectionMapper.mapOmrsEntityDetailToMediaCollection(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreMediaCollectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredMediaCollection;
    }

    public MediaCollection addMediaCollectionClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addMediaCollectionClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addMediaCollectionClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addMediaCollectionClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addMediaCollectionClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        MediaCollection mediaCollectionClassifications = MediaCollectionMapper.mapOmrsEntityDetailToMediaCollection(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addMediaCollectionClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified MediaCollection=" + mediaCollectionClassifications);
        }
        return mediaCollectionClassifications;
    }

    public MediaCollection updateMediaCollectionClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateMediaCollectionClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateMediaCollectionClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateMediaCollectionClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateMediaCollectionClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateMediaCollectionClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateMediaCollectionClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        MediaCollection mediaCollectionClassifications = MediaCollectionMapper.mapOmrsEntityDetailToMediaCollection(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateMediaCollectionClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return mediaCollectionClassifications;
    }

    public MediaCollection deleteMediaCollectionClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteMediaCollectionClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteMediaCollectionClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteMediaCollectionClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteMediaCollectionClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        MediaCollection declassifiedMediaCollection = MediaCollectionMapper.mapOmrsEntityDetailToMediaCollection(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteMediaCollectionClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedMediaCollection;
    }

    public Set<Line> getMediaCollectionRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getMediaCollectionRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getMediaCollectionRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getMediaCollectionRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getMediaCollectionRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getMediaCollectionRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public Collection getCollectionById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getCollectionById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCollectionById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getCollectionById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getCollectionById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Collection gotcollection = CollectionMapper.mapOmrsEntityDetailToCollection(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCollectionById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotcollection);
        }
        return gotcollection;
    }

    public Collection createCollection(String userId, Collection collection) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createCollectionById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createCollectionById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createCollectionById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Collection");
        if (constraint != null) {
            constraint.preCreate(collection);
        }
        EntityDetail entityDetail = CollectionMapper.mapCollectionToOmrsEntityDetail(collection);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        Collection createdCollection = CollectionMapper.mapOmrsEntityDetailToCollection(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createCollectionById,userId=" + userId + ", created Collection=" + createdCollection);
        }
        return createdCollection;
    }

    public Collection updateCollection(String userId, Collection collection) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateCollectionById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateCollectionById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateCollectionById", (String)userId);
        EntityDetail entityDetail = CollectionMapper.mapCollectionToOmrsEntityDetail(collection);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateCollectionById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        Collection updatedCollection = CollectionMapper.mapOmrsEntityDetailToCollection(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateCollectionById,userId=" + userId + ",updated Collection=" + updatedCollection);
        }
        return updatedCollection;
    }

    public EntityDetail deleteCollectionByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteCollectionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteCollectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteCollectionByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteCollectionByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Collection");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "Collection", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteCollectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeCollectionByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeCollectionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeCollectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeCollectionByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeCollectionByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Collection");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "Collection", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeCollectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public Collection restoreCollection(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreCollectionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreCollectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreCollectionByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreCollectionByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        Collection restoredCollection = CollectionMapper.mapOmrsEntityDetailToCollection(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreCollectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredCollection;
    }

    public Collection addCollectionClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addCollectionClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addCollectionClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addCollectionClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addCollectionClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Collection collectionClassifications = CollectionMapper.mapOmrsEntityDetailToCollection(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addCollectionClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified Collection=" + collectionClassifications);
        }
        return collectionClassifications;
    }

    public Collection updateCollectionClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateCollectionClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateCollectionClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateCollectionClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateCollectionClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateCollectionClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateCollectionClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Collection collectionClassifications = CollectionMapper.mapOmrsEntityDetailToCollection(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateCollectionClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return collectionClassifications;
    }

    public Collection deleteCollectionClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteCollectionClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteCollectionClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteCollectionClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteCollectionClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Collection declassifiedCollection = CollectionMapper.mapOmrsEntityDetailToCollection(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteCollectionClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedCollection;
    }

    public Set<Line> getCollectionRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getCollectionRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCollectionRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getCollectionRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getCollectionRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCollectionRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public InformalTag getInformalTagById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getInformalTagById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getInformalTagById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getInformalTagById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getInformalTagById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        InformalTag gotinformalTag = InformalTagMapper.mapOmrsEntityDetailToInformalTag(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getInformalTagById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotinformalTag);
        }
        return gotinformalTag;
    }

    public InformalTag createInformalTag(String userId, InformalTag informalTag) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createInformalTagById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createInformalTagById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createInformalTagById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("InformalTag");
        if (constraint != null) {
            constraint.preCreate(informalTag);
        }
        EntityDetail entityDetail = InformalTagMapper.mapInformalTagToOmrsEntityDetail(informalTag);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        InformalTag createdInformalTag = InformalTagMapper.mapOmrsEntityDetailToInformalTag(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createInformalTagById,userId=" + userId + ", created InformalTag=" + createdInformalTag);
        }
        return createdInformalTag;
    }

    public InformalTag updateInformalTag(String userId, InformalTag informalTag) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateInformalTagById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateInformalTagById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateInformalTagById", (String)userId);
        EntityDetail entityDetail = InformalTagMapper.mapInformalTagToOmrsEntityDetail(informalTag);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateInformalTagById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        InformalTag updatedInformalTag = InformalTagMapper.mapOmrsEntityDetailToInformalTag(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateInformalTagById,userId=" + userId + ",updated InformalTag=" + updatedInformalTag);
        }
        return updatedInformalTag;
    }

    public EntityDetail deleteInformalTagByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteInformalTagByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteInformalTagByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteInformalTagByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteInformalTagByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("InformalTag");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "InformalTag", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteInformalTagByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeInformalTagByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeInformalTagByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeInformalTagByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeInformalTagByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeInformalTagByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("InformalTag");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "InformalTag", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeInformalTagByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public InformalTag restoreInformalTag(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreInformalTagByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreInformalTagByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreInformalTagByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreInformalTagByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        InformalTag restoredInformalTag = InformalTagMapper.mapOmrsEntityDetailToInformalTag(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreInformalTagByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredInformalTag;
    }

    public InformalTag addInformalTagClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addInformalTagClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addInformalTagClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addInformalTagClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addInformalTagClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        InformalTag informalTagClassifications = InformalTagMapper.mapOmrsEntityDetailToInformalTag(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addInformalTagClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified InformalTag=" + informalTagClassifications);
        }
        return informalTagClassifications;
    }

    public InformalTag updateInformalTagClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateInformalTagClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateInformalTagClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateInformalTagClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateInformalTagClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateInformalTagClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateInformalTagClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        InformalTag informalTagClassifications = InformalTagMapper.mapOmrsEntityDetailToInformalTag(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateInformalTagClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return informalTagClassifications;
    }

    public InformalTag deleteInformalTagClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteInformalTagClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteInformalTagClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteInformalTagClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteInformalTagClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        InformalTag declassifiedInformalTag = InformalTagMapper.mapOmrsEntityDetailToInformalTag(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteInformalTagClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedInformalTag;
    }

    public Set<Line> getInformalTagRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getInformalTagRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getInformalTagRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getInformalTagRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getInformalTagRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getInformalTagRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public GovernanceZone getGovernanceZoneById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getGovernanceZoneById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGovernanceZoneById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGovernanceZoneById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGovernanceZoneById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceZone gotgovernanceZone = GovernanceZoneMapper.mapOmrsEntityDetailToGovernanceZone(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGovernanceZoneById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotgovernanceZone);
        }
        return gotgovernanceZone;
    }

    public GovernanceZone createGovernanceZone(String userId, GovernanceZone governanceZone) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createGovernanceZoneById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createGovernanceZoneById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createGovernanceZoneById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("GovernanceZone");
        if (constraint != null) {
            constraint.preCreate(governanceZone);
        }
        EntityDetail entityDetail = GovernanceZoneMapper.mapGovernanceZoneToOmrsEntityDetail(governanceZone);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        GovernanceZone createdGovernanceZone = GovernanceZoneMapper.mapOmrsEntityDetailToGovernanceZone(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createGovernanceZoneById,userId=" + userId + ", created GovernanceZone=" + createdGovernanceZone);
        }
        return createdGovernanceZone;
    }

    public GovernanceZone updateGovernanceZone(String userId, GovernanceZone governanceZone) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateGovernanceZoneById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGovernanceZoneById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGovernanceZoneById", (String)userId);
        EntityDetail entityDetail = GovernanceZoneMapper.mapGovernanceZoneToOmrsEntityDetail(governanceZone);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGovernanceZoneById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        GovernanceZone updatedGovernanceZone = GovernanceZoneMapper.mapOmrsEntityDetailToGovernanceZone(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateGovernanceZoneById,userId=" + userId + ",updated GovernanceZone=" + updatedGovernanceZone);
        }
        return updatedGovernanceZone;
    }

    public EntityDetail deleteGovernanceZoneByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteGovernanceZoneByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGovernanceZoneByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGovernanceZoneByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGovernanceZoneByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernanceZone");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "GovernanceZone", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGovernanceZoneByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeGovernanceZoneByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeGovernanceZoneByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeGovernanceZoneByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeGovernanceZoneByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeGovernanceZoneByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernanceZone");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "GovernanceZone", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeGovernanceZoneByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public GovernanceZone restoreGovernanceZone(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreGovernanceZoneByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreGovernanceZoneByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreGovernanceZoneByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreGovernanceZoneByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        GovernanceZone restoredGovernanceZone = GovernanceZoneMapper.mapOmrsEntityDetailToGovernanceZone(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreGovernanceZoneByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredGovernanceZone;
    }

    public GovernanceZone addGovernanceZoneClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addGovernanceZoneClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addGovernanceZoneClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addGovernanceZoneClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addGovernanceZoneClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceZone governanceZoneClassifications = GovernanceZoneMapper.mapOmrsEntityDetailToGovernanceZone(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addGovernanceZoneClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified GovernanceZone=" + governanceZoneClassifications);
        }
        return governanceZoneClassifications;
    }

    public GovernanceZone updateGovernanceZoneClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateGovernanceZoneClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGovernanceZoneClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGovernanceZoneClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGovernanceZoneClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateGovernanceZoneClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateGovernanceZoneClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceZone governanceZoneClassifications = GovernanceZoneMapper.mapOmrsEntityDetailToGovernanceZone(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateGovernanceZoneClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return governanceZoneClassifications;
    }

    public GovernanceZone deleteGovernanceZoneClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteGovernanceZoneClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGovernanceZoneClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGovernanceZoneClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGovernanceZoneClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceZone declassifiedGovernanceZone = GovernanceZoneMapper.mapOmrsEntityDetailToGovernanceZone(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGovernanceZoneClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedGovernanceZone;
    }

    public Set<Line> getGovernanceZoneRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getGovernanceZoneRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGovernanceZoneRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGovernanceZoneRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGovernanceZoneRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGovernanceZoneRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public Application getApplicationById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getApplicationById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getApplicationById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getApplicationById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getApplicationById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Application gotapplication = ApplicationMapper.mapOmrsEntityDetailToApplication(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getApplicationById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotapplication);
        }
        return gotapplication;
    }

    public Application createApplication(String userId, Application application) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createApplicationById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createApplicationById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createApplicationById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Application");
        if (constraint != null) {
            constraint.preCreate(application);
        }
        EntityDetail entityDetail = ApplicationMapper.mapApplicationToOmrsEntityDetail(application);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        Application createdApplication = ApplicationMapper.mapOmrsEntityDetailToApplication(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createApplicationById,userId=" + userId + ", created Application=" + createdApplication);
        }
        return createdApplication;
    }

    public Application updateApplication(String userId, Application application) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateApplicationById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateApplicationById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateApplicationById", (String)userId);
        EntityDetail entityDetail = ApplicationMapper.mapApplicationToOmrsEntityDetail(application);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateApplicationById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        Application updatedApplication = ApplicationMapper.mapOmrsEntityDetailToApplication(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateApplicationById,userId=" + userId + ",updated Application=" + updatedApplication);
        }
        return updatedApplication;
    }

    public EntityDetail deleteApplicationByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteApplicationByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteApplicationByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteApplicationByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteApplicationByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Application");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "Application", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteApplicationByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeApplicationByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeApplicationByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeApplicationByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeApplicationByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeApplicationByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Application");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "Application", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeApplicationByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public Application restoreApplication(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreApplicationByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreApplicationByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreApplicationByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreApplicationByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        Application restoredApplication = ApplicationMapper.mapOmrsEntityDetailToApplication(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreApplicationByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredApplication;
    }

    public Application addApplicationClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addApplicationClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addApplicationClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addApplicationClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addApplicationClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Application applicationClassifications = ApplicationMapper.mapOmrsEntityDetailToApplication(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addApplicationClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified Application=" + applicationClassifications);
        }
        return applicationClassifications;
    }

    public Application updateApplicationClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateApplicationClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateApplicationClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateApplicationClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateApplicationClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateApplicationClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateApplicationClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Application applicationClassifications = ApplicationMapper.mapOmrsEntityDetailToApplication(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateApplicationClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return applicationClassifications;
    }

    public Application deleteApplicationClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteApplicationClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteApplicationClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteApplicationClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteApplicationClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Application declassifiedApplication = ApplicationMapper.mapOmrsEntityDetailToApplication(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteApplicationClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedApplication;
    }

    public Set<Line> getApplicationRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getApplicationRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getApplicationRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getApplicationRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getApplicationRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getApplicationRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public Person getPersonById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getPersonById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getPersonById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getPersonById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getPersonById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Person gotperson = PersonMapper.mapOmrsEntityDetailToPerson(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getPersonById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotperson);
        }
        return gotperson;
    }

    public Person createPerson(String userId, Person person) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createPersonById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createPersonById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createPersonById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Person");
        if (constraint != null) {
            constraint.preCreate(person);
        }
        EntityDetail entityDetail = PersonMapper.mapPersonToOmrsEntityDetail(person);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        Person createdPerson = PersonMapper.mapOmrsEntityDetailToPerson(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createPersonById,userId=" + userId + ", created Person=" + createdPerson);
        }
        return createdPerson;
    }

    public Person updatePerson(String userId, Person person) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updatePersonById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updatePersonById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updatePersonById", (String)userId);
        EntityDetail entityDetail = PersonMapper.mapPersonToOmrsEntityDetail(person);
        InputValidator.validateGUIDNotNull((String)className, (String)"updatePersonById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        Person updatedPerson = PersonMapper.mapOmrsEntityDetailToPerson(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updatePersonById,userId=" + userId + ",updated Person=" + updatedPerson);
        }
        return updatedPerson;
    }

    public EntityDetail deletePersonByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deletePersonByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deletePersonByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deletePersonByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deletePersonByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Person");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "Person", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deletePersonByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgePersonByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgePersonByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgePersonByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgePersonByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgePersonByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Person");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "Person", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgePersonByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public Person restorePerson(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restorePersonByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restorePersonByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restorePersonByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restorePersonByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        Person restoredPerson = PersonMapper.mapOmrsEntityDetailToPerson(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restorePersonByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredPerson;
    }

    public Person addPersonClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addPersonClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addPersonClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addPersonClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addPersonClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Person personClassifications = PersonMapper.mapOmrsEntityDetailToPerson(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addPersonClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified Person=" + personClassifications);
        }
        return personClassifications;
    }

    public Person updatePersonClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updatePersonClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updatePersonClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updatePersonClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updatePersonClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updatePersonClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updatePersonClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Person personClassifications = PersonMapper.mapOmrsEntityDetailToPerson(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updatePersonClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return personClassifications;
    }

    public Person deletePersonClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deletePersonClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deletePersonClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deletePersonClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deletePersonClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Person declassifiedPerson = PersonMapper.mapOmrsEntityDetailToPerson(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deletePersonClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedPerson;
    }

    public Set<Line> getPersonRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getPersonRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getPersonRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getPersonRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getPersonRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getPersonRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public VirtualContainer getVirtualContainerById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getVirtualContainerById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getVirtualContainerById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getVirtualContainerById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getVirtualContainerById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        VirtualContainer gotvirtualContainer = VirtualContainerMapper.mapOmrsEntityDetailToVirtualContainer(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getVirtualContainerById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotvirtualContainer);
        }
        return gotvirtualContainer;
    }

    public VirtualContainer createVirtualContainer(String userId, VirtualContainer virtualContainer) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createVirtualContainerById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createVirtualContainerById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createVirtualContainerById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("VirtualContainer");
        if (constraint != null) {
            constraint.preCreate(virtualContainer);
        }
        EntityDetail entityDetail = VirtualContainerMapper.mapVirtualContainerToOmrsEntityDetail(virtualContainer);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        VirtualContainer createdVirtualContainer = VirtualContainerMapper.mapOmrsEntityDetailToVirtualContainer(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createVirtualContainerById,userId=" + userId + ", created VirtualContainer=" + createdVirtualContainer);
        }
        return createdVirtualContainer;
    }

    public VirtualContainer updateVirtualContainer(String userId, VirtualContainer virtualContainer) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateVirtualContainerById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateVirtualContainerById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateVirtualContainerById", (String)userId);
        EntityDetail entityDetail = VirtualContainerMapper.mapVirtualContainerToOmrsEntityDetail(virtualContainer);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateVirtualContainerById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        VirtualContainer updatedVirtualContainer = VirtualContainerMapper.mapOmrsEntityDetailToVirtualContainer(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateVirtualContainerById,userId=" + userId + ",updated VirtualContainer=" + updatedVirtualContainer);
        }
        return updatedVirtualContainer;
    }

    public EntityDetail deleteVirtualContainerByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteVirtualContainerByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteVirtualContainerByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteVirtualContainerByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteVirtualContainerByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("VirtualContainer");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "VirtualContainer", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteVirtualContainerByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeVirtualContainerByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeVirtualContainerByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeVirtualContainerByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeVirtualContainerByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeVirtualContainerByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("VirtualContainer");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "VirtualContainer", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeVirtualContainerByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public VirtualContainer restoreVirtualContainer(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreVirtualContainerByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreVirtualContainerByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreVirtualContainerByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreVirtualContainerByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        VirtualContainer restoredVirtualContainer = VirtualContainerMapper.mapOmrsEntityDetailToVirtualContainer(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreVirtualContainerByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredVirtualContainer;
    }

    public VirtualContainer addVirtualContainerClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addVirtualContainerClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addVirtualContainerClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addVirtualContainerClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addVirtualContainerClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        VirtualContainer virtualContainerClassifications = VirtualContainerMapper.mapOmrsEntityDetailToVirtualContainer(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addVirtualContainerClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified VirtualContainer=" + virtualContainerClassifications);
        }
        return virtualContainerClassifications;
    }

    public VirtualContainer updateVirtualContainerClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateVirtualContainerClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateVirtualContainerClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateVirtualContainerClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateVirtualContainerClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateVirtualContainerClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateVirtualContainerClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        VirtualContainer virtualContainerClassifications = VirtualContainerMapper.mapOmrsEntityDetailToVirtualContainer(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateVirtualContainerClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return virtualContainerClassifications;
    }

    public VirtualContainer deleteVirtualContainerClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteVirtualContainerClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteVirtualContainerClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteVirtualContainerClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteVirtualContainerClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        VirtualContainer declassifiedVirtualContainer = VirtualContainerMapper.mapOmrsEntityDetailToVirtualContainer(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteVirtualContainerClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedVirtualContainer;
    }

    public Set<Line> getVirtualContainerRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getVirtualContainerRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getVirtualContainerRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getVirtualContainerRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getVirtualContainerRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getVirtualContainerRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public GovernanceDriver getGovernanceDriverById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getGovernanceDriverById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGovernanceDriverById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGovernanceDriverById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGovernanceDriverById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceDriver gotgovernanceDriver = GovernanceDriverMapper.mapOmrsEntityDetailToGovernanceDriver(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGovernanceDriverById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotgovernanceDriver);
        }
        return gotgovernanceDriver;
    }

    public GovernanceDriver createGovernanceDriver(String userId, GovernanceDriver governanceDriver) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createGovernanceDriverById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createGovernanceDriverById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createGovernanceDriverById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("GovernanceDriver");
        if (constraint != null) {
            constraint.preCreate(governanceDriver);
        }
        EntityDetail entityDetail = GovernanceDriverMapper.mapGovernanceDriverToOmrsEntityDetail(governanceDriver);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        GovernanceDriver createdGovernanceDriver = GovernanceDriverMapper.mapOmrsEntityDetailToGovernanceDriver(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createGovernanceDriverById,userId=" + userId + ", created GovernanceDriver=" + createdGovernanceDriver);
        }
        return createdGovernanceDriver;
    }

    public GovernanceDriver updateGovernanceDriver(String userId, GovernanceDriver governanceDriver) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateGovernanceDriverById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGovernanceDriverById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGovernanceDriverById", (String)userId);
        EntityDetail entityDetail = GovernanceDriverMapper.mapGovernanceDriverToOmrsEntityDetail(governanceDriver);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGovernanceDriverById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        GovernanceDriver updatedGovernanceDriver = GovernanceDriverMapper.mapOmrsEntityDetailToGovernanceDriver(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateGovernanceDriverById,userId=" + userId + ",updated GovernanceDriver=" + updatedGovernanceDriver);
        }
        return updatedGovernanceDriver;
    }

    public EntityDetail deleteGovernanceDriverByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteGovernanceDriverByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGovernanceDriverByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGovernanceDriverByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGovernanceDriverByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernanceDriver");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "GovernanceDriver", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGovernanceDriverByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeGovernanceDriverByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeGovernanceDriverByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeGovernanceDriverByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeGovernanceDriverByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeGovernanceDriverByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernanceDriver");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "GovernanceDriver", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeGovernanceDriverByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public GovernanceDriver restoreGovernanceDriver(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreGovernanceDriverByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreGovernanceDriverByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreGovernanceDriverByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreGovernanceDriverByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        GovernanceDriver restoredGovernanceDriver = GovernanceDriverMapper.mapOmrsEntityDetailToGovernanceDriver(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreGovernanceDriverByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredGovernanceDriver;
    }

    public GovernanceDriver addGovernanceDriverClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addGovernanceDriverClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addGovernanceDriverClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addGovernanceDriverClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addGovernanceDriverClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceDriver governanceDriverClassifications = GovernanceDriverMapper.mapOmrsEntityDetailToGovernanceDriver(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addGovernanceDriverClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified GovernanceDriver=" + governanceDriverClassifications);
        }
        return governanceDriverClassifications;
    }

    public GovernanceDriver updateGovernanceDriverClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateGovernanceDriverClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGovernanceDriverClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGovernanceDriverClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGovernanceDriverClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateGovernanceDriverClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateGovernanceDriverClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceDriver governanceDriverClassifications = GovernanceDriverMapper.mapOmrsEntityDetailToGovernanceDriver(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateGovernanceDriverClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return governanceDriverClassifications;
    }

    public GovernanceDriver deleteGovernanceDriverClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteGovernanceDriverClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGovernanceDriverClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGovernanceDriverClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGovernanceDriverClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceDriver declassifiedGovernanceDriver = GovernanceDriverMapper.mapOmrsEntityDetailToGovernanceDriver(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGovernanceDriverClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedGovernanceDriver;
    }

    public Set<Line> getGovernanceDriverRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getGovernanceDriverRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGovernanceDriverRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGovernanceDriverRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGovernanceDriverRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGovernanceDriverRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public Meeting getMeetingById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getMeetingById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getMeetingById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getMeetingById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getMeetingById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Meeting gotmeeting = MeetingMapper.mapOmrsEntityDetailToMeeting(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getMeetingById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotmeeting);
        }
        return gotmeeting;
    }

    public Meeting createMeeting(String userId, Meeting meeting) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createMeetingById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createMeetingById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createMeetingById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Meeting");
        if (constraint != null) {
            constraint.preCreate(meeting);
        }
        EntityDetail entityDetail = MeetingMapper.mapMeetingToOmrsEntityDetail(meeting);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        Meeting createdMeeting = MeetingMapper.mapOmrsEntityDetailToMeeting(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createMeetingById,userId=" + userId + ", created Meeting=" + createdMeeting);
        }
        return createdMeeting;
    }

    public Meeting updateMeeting(String userId, Meeting meeting) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateMeetingById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateMeetingById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateMeetingById", (String)userId);
        EntityDetail entityDetail = MeetingMapper.mapMeetingToOmrsEntityDetail(meeting);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateMeetingById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        Meeting updatedMeeting = MeetingMapper.mapOmrsEntityDetailToMeeting(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateMeetingById,userId=" + userId + ",updated Meeting=" + updatedMeeting);
        }
        return updatedMeeting;
    }

    public EntityDetail deleteMeetingByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteMeetingByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteMeetingByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteMeetingByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteMeetingByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Meeting");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "Meeting", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteMeetingByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeMeetingByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeMeetingByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeMeetingByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeMeetingByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeMeetingByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Meeting");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "Meeting", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeMeetingByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public Meeting restoreMeeting(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreMeetingByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreMeetingByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreMeetingByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreMeetingByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        Meeting restoredMeeting = MeetingMapper.mapOmrsEntityDetailToMeeting(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreMeetingByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredMeeting;
    }

    public Meeting addMeetingClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addMeetingClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addMeetingClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addMeetingClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addMeetingClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Meeting meetingClassifications = MeetingMapper.mapOmrsEntityDetailToMeeting(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addMeetingClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified Meeting=" + meetingClassifications);
        }
        return meetingClassifications;
    }

    public Meeting updateMeetingClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateMeetingClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateMeetingClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateMeetingClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateMeetingClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateMeetingClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateMeetingClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Meeting meetingClassifications = MeetingMapper.mapOmrsEntityDetailToMeeting(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateMeetingClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return meetingClassifications;
    }

    public Meeting deleteMeetingClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteMeetingClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteMeetingClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteMeetingClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteMeetingClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Meeting declassifiedMeeting = MeetingMapper.mapOmrsEntityDetailToMeeting(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteMeetingClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedMeeting;
    }

    public Set<Line> getMeetingRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getMeetingRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getMeetingRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getMeetingRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getMeetingRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getMeetingRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public SoftwareServerPlatform getSoftwareServerPlatformById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getSoftwareServerPlatformById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getSoftwareServerPlatformById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getSoftwareServerPlatformById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getSoftwareServerPlatformById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SoftwareServerPlatform gotsoftwareServerPlatform = SoftwareServerPlatformMapper.mapOmrsEntityDetailToSoftwareServerPlatform(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getSoftwareServerPlatformById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotsoftwareServerPlatform);
        }
        return gotsoftwareServerPlatform;
    }

    public SoftwareServerPlatform createSoftwareServerPlatform(String userId, SoftwareServerPlatform softwareServerPlatform) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createSoftwareServerPlatformById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createSoftwareServerPlatformById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createSoftwareServerPlatformById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("SoftwareServerPlatform");
        if (constraint != null) {
            constraint.preCreate(softwareServerPlatform);
        }
        EntityDetail entityDetail = SoftwareServerPlatformMapper.mapSoftwareServerPlatformToOmrsEntityDetail(softwareServerPlatform);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        SoftwareServerPlatform createdSoftwareServerPlatform = SoftwareServerPlatformMapper.mapOmrsEntityDetailToSoftwareServerPlatform(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createSoftwareServerPlatformById,userId=" + userId + ", created SoftwareServerPlatform=" + createdSoftwareServerPlatform);
        }
        return createdSoftwareServerPlatform;
    }

    public SoftwareServerPlatform updateSoftwareServerPlatform(String userId, SoftwareServerPlatform softwareServerPlatform) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateSoftwareServerPlatformById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateSoftwareServerPlatformById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateSoftwareServerPlatformById", (String)userId);
        EntityDetail entityDetail = SoftwareServerPlatformMapper.mapSoftwareServerPlatformToOmrsEntityDetail(softwareServerPlatform);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateSoftwareServerPlatformById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        SoftwareServerPlatform updatedSoftwareServerPlatform = SoftwareServerPlatformMapper.mapOmrsEntityDetailToSoftwareServerPlatform(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateSoftwareServerPlatformById,userId=" + userId + ",updated SoftwareServerPlatform=" + updatedSoftwareServerPlatform);
        }
        return updatedSoftwareServerPlatform;
    }

    public EntityDetail deleteSoftwareServerPlatformByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteSoftwareServerPlatformByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteSoftwareServerPlatformByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteSoftwareServerPlatformByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteSoftwareServerPlatformByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("SoftwareServerPlatform");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "SoftwareServerPlatform", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteSoftwareServerPlatformByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeSoftwareServerPlatformByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeSoftwareServerPlatformByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeSoftwareServerPlatformByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeSoftwareServerPlatformByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeSoftwareServerPlatformByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("SoftwareServerPlatform");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "SoftwareServerPlatform", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeSoftwareServerPlatformByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public SoftwareServerPlatform restoreSoftwareServerPlatform(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreSoftwareServerPlatformByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreSoftwareServerPlatformByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreSoftwareServerPlatformByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreSoftwareServerPlatformByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        SoftwareServerPlatform restoredSoftwareServerPlatform = SoftwareServerPlatformMapper.mapOmrsEntityDetailToSoftwareServerPlatform(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreSoftwareServerPlatformByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredSoftwareServerPlatform;
    }

    public SoftwareServerPlatform addSoftwareServerPlatformClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addSoftwareServerPlatformClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addSoftwareServerPlatformClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addSoftwareServerPlatformClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addSoftwareServerPlatformClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SoftwareServerPlatform softwareServerPlatformClassifications = SoftwareServerPlatformMapper.mapOmrsEntityDetailToSoftwareServerPlatform(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addSoftwareServerPlatformClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified SoftwareServerPlatform=" + softwareServerPlatformClassifications);
        }
        return softwareServerPlatformClassifications;
    }

    public SoftwareServerPlatform updateSoftwareServerPlatformClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateSoftwareServerPlatformClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateSoftwareServerPlatformClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateSoftwareServerPlatformClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateSoftwareServerPlatformClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateSoftwareServerPlatformClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateSoftwareServerPlatformClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SoftwareServerPlatform softwareServerPlatformClassifications = SoftwareServerPlatformMapper.mapOmrsEntityDetailToSoftwareServerPlatform(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateSoftwareServerPlatformClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return softwareServerPlatformClassifications;
    }

    public SoftwareServerPlatform deleteSoftwareServerPlatformClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteSoftwareServerPlatformClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteSoftwareServerPlatformClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteSoftwareServerPlatformClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteSoftwareServerPlatformClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SoftwareServerPlatform declassifiedSoftwareServerPlatform = SoftwareServerPlatformMapper.mapOmrsEntityDetailToSoftwareServerPlatform(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteSoftwareServerPlatformClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedSoftwareServerPlatform;
    }

    public Set<Line> getSoftwareServerPlatformRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getSoftwareServerPlatformRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getSoftwareServerPlatformRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getSoftwareServerPlatformRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getSoftwareServerPlatformRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getSoftwareServerPlatformRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public Rating getRatingById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getRatingById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getRatingById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getRatingById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getRatingById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Rating gotrating = RatingMapper.mapOmrsEntityDetailToRating(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getRatingById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotrating);
        }
        return gotrating;
    }

    public Rating createRating(String userId, Rating rating) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createRatingById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createRatingById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createRatingById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Rating");
        if (constraint != null) {
            constraint.preCreate(rating);
        }
        EntityDetail entityDetail = RatingMapper.mapRatingToOmrsEntityDetail(rating);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        Rating createdRating = RatingMapper.mapOmrsEntityDetailToRating(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createRatingById,userId=" + userId + ", created Rating=" + createdRating);
        }
        return createdRating;
    }

    public Rating updateRating(String userId, Rating rating) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateRatingById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateRatingById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateRatingById", (String)userId);
        EntityDetail entityDetail = RatingMapper.mapRatingToOmrsEntityDetail(rating);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateRatingById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        Rating updatedRating = RatingMapper.mapOmrsEntityDetailToRating(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateRatingById,userId=" + userId + ",updated Rating=" + updatedRating);
        }
        return updatedRating;
    }

    public EntityDetail deleteRatingByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteRatingByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteRatingByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteRatingByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteRatingByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Rating");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "Rating", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteRatingByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeRatingByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeRatingByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeRatingByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeRatingByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeRatingByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Rating");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "Rating", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeRatingByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public Rating restoreRating(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreRatingByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreRatingByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreRatingByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreRatingByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        Rating restoredRating = RatingMapper.mapOmrsEntityDetailToRating(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreRatingByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredRating;
    }

    public Rating addRatingClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addRatingClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addRatingClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addRatingClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addRatingClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Rating ratingClassifications = RatingMapper.mapOmrsEntityDetailToRating(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addRatingClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified Rating=" + ratingClassifications);
        }
        return ratingClassifications;
    }

    public Rating updateRatingClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateRatingClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateRatingClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateRatingClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateRatingClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateRatingClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateRatingClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Rating ratingClassifications = RatingMapper.mapOmrsEntityDetailToRating(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateRatingClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return ratingClassifications;
    }

    public Rating deleteRatingClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteRatingClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteRatingClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteRatingClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteRatingClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Rating declassifiedRating = RatingMapper.mapOmrsEntityDetailToRating(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteRatingClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedRating;
    }

    public Set<Line> getRatingRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getRatingRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getRatingRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getRatingRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getRatingRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getRatingRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public ProjectCharter getProjectCharterById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getProjectCharterById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getProjectCharterById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getProjectCharterById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getProjectCharterById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ProjectCharter gotprojectCharter = ProjectCharterMapper.mapOmrsEntityDetailToProjectCharter(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getProjectCharterById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotprojectCharter);
        }
        return gotprojectCharter;
    }

    public ProjectCharter createProjectCharter(String userId, ProjectCharter projectCharter) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createProjectCharterById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createProjectCharterById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createProjectCharterById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("ProjectCharter");
        if (constraint != null) {
            constraint.preCreate(projectCharter);
        }
        EntityDetail entityDetail = ProjectCharterMapper.mapProjectCharterToOmrsEntityDetail(projectCharter);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        ProjectCharter createdProjectCharter = ProjectCharterMapper.mapOmrsEntityDetailToProjectCharter(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createProjectCharterById,userId=" + userId + ", created ProjectCharter=" + createdProjectCharter);
        }
        return createdProjectCharter;
    }

    public ProjectCharter updateProjectCharter(String userId, ProjectCharter projectCharter) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateProjectCharterById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateProjectCharterById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateProjectCharterById", (String)userId);
        EntityDetail entityDetail = ProjectCharterMapper.mapProjectCharterToOmrsEntityDetail(projectCharter);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateProjectCharterById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        ProjectCharter updatedProjectCharter = ProjectCharterMapper.mapOmrsEntityDetailToProjectCharter(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateProjectCharterById,userId=" + userId + ",updated ProjectCharter=" + updatedProjectCharter);
        }
        return updatedProjectCharter;
    }

    public EntityDetail deleteProjectCharterByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteProjectCharterByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteProjectCharterByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteProjectCharterByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteProjectCharterByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("ProjectCharter");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "ProjectCharter", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteProjectCharterByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeProjectCharterByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeProjectCharterByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeProjectCharterByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeProjectCharterByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeProjectCharterByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("ProjectCharter");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "ProjectCharter", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeProjectCharterByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public ProjectCharter restoreProjectCharter(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreProjectCharterByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreProjectCharterByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreProjectCharterByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreProjectCharterByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        ProjectCharter restoredProjectCharter = ProjectCharterMapper.mapOmrsEntityDetailToProjectCharter(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreProjectCharterByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredProjectCharter;
    }

    public ProjectCharter addProjectCharterClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addProjectCharterClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addProjectCharterClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addProjectCharterClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addProjectCharterClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ProjectCharter projectCharterClassifications = ProjectCharterMapper.mapOmrsEntityDetailToProjectCharter(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addProjectCharterClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified ProjectCharter=" + projectCharterClassifications);
        }
        return projectCharterClassifications;
    }

    public ProjectCharter updateProjectCharterClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateProjectCharterClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateProjectCharterClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateProjectCharterClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateProjectCharterClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateProjectCharterClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateProjectCharterClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ProjectCharter projectCharterClassifications = ProjectCharterMapper.mapOmrsEntityDetailToProjectCharter(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateProjectCharterClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return projectCharterClassifications;
    }

    public ProjectCharter deleteProjectCharterClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteProjectCharterClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteProjectCharterClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteProjectCharterClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteProjectCharterClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ProjectCharter declassifiedProjectCharter = ProjectCharterMapper.mapOmrsEntityDetailToProjectCharter(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteProjectCharterClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedProjectCharter;
    }

    public Set<Line> getProjectCharterRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getProjectCharterRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getProjectCharterRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getProjectCharterRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getProjectCharterRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getProjectCharterRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public SoftwareServerCapability getSoftwareServerCapabilityById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getSoftwareServerCapabilityById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getSoftwareServerCapabilityById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getSoftwareServerCapabilityById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getSoftwareServerCapabilityById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SoftwareServerCapability gotsoftwareServerCapability = SoftwareServerCapabilityMapper.mapOmrsEntityDetailToSoftwareServerCapability(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getSoftwareServerCapabilityById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotsoftwareServerCapability);
        }
        return gotsoftwareServerCapability;
    }

    public SoftwareServerCapability createSoftwareServerCapability(String userId, SoftwareServerCapability softwareServerCapability) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createSoftwareServerCapabilityById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createSoftwareServerCapabilityById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createSoftwareServerCapabilityById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("SoftwareServerCapability");
        if (constraint != null) {
            constraint.preCreate(softwareServerCapability);
        }
        EntityDetail entityDetail = SoftwareServerCapabilityMapper.mapSoftwareServerCapabilityToOmrsEntityDetail(softwareServerCapability);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        SoftwareServerCapability createdSoftwareServerCapability = SoftwareServerCapabilityMapper.mapOmrsEntityDetailToSoftwareServerCapability(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createSoftwareServerCapabilityById,userId=" + userId + ", created SoftwareServerCapability=" + createdSoftwareServerCapability);
        }
        return createdSoftwareServerCapability;
    }

    public SoftwareServerCapability updateSoftwareServerCapability(String userId, SoftwareServerCapability softwareServerCapability) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateSoftwareServerCapabilityById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateSoftwareServerCapabilityById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateSoftwareServerCapabilityById", (String)userId);
        EntityDetail entityDetail = SoftwareServerCapabilityMapper.mapSoftwareServerCapabilityToOmrsEntityDetail(softwareServerCapability);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateSoftwareServerCapabilityById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        SoftwareServerCapability updatedSoftwareServerCapability = SoftwareServerCapabilityMapper.mapOmrsEntityDetailToSoftwareServerCapability(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateSoftwareServerCapabilityById,userId=" + userId + ",updated SoftwareServerCapability=" + updatedSoftwareServerCapability);
        }
        return updatedSoftwareServerCapability;
    }

    public EntityDetail deleteSoftwareServerCapabilityByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteSoftwareServerCapabilityByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteSoftwareServerCapabilityByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteSoftwareServerCapabilityByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteSoftwareServerCapabilityByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("SoftwareServerCapability");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "SoftwareServerCapability", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteSoftwareServerCapabilityByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeSoftwareServerCapabilityByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeSoftwareServerCapabilityByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeSoftwareServerCapabilityByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeSoftwareServerCapabilityByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeSoftwareServerCapabilityByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("SoftwareServerCapability");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "SoftwareServerCapability", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeSoftwareServerCapabilityByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public SoftwareServerCapability restoreSoftwareServerCapability(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreSoftwareServerCapabilityByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreSoftwareServerCapabilityByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreSoftwareServerCapabilityByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreSoftwareServerCapabilityByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        SoftwareServerCapability restoredSoftwareServerCapability = SoftwareServerCapabilityMapper.mapOmrsEntityDetailToSoftwareServerCapability(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreSoftwareServerCapabilityByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredSoftwareServerCapability;
    }

    public SoftwareServerCapability addSoftwareServerCapabilityClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addSoftwareServerCapabilityClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addSoftwareServerCapabilityClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addSoftwareServerCapabilityClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addSoftwareServerCapabilityClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SoftwareServerCapability softwareServerCapabilityClassifications = SoftwareServerCapabilityMapper.mapOmrsEntityDetailToSoftwareServerCapability(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addSoftwareServerCapabilityClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified SoftwareServerCapability=" + softwareServerCapabilityClassifications);
        }
        return softwareServerCapabilityClassifications;
    }

    public SoftwareServerCapability updateSoftwareServerCapabilityClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateSoftwareServerCapabilityClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateSoftwareServerCapabilityClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateSoftwareServerCapabilityClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateSoftwareServerCapabilityClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateSoftwareServerCapabilityClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateSoftwareServerCapabilityClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SoftwareServerCapability softwareServerCapabilityClassifications = SoftwareServerCapabilityMapper.mapOmrsEntityDetailToSoftwareServerCapability(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateSoftwareServerCapabilityClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return softwareServerCapabilityClassifications;
    }

    public SoftwareServerCapability deleteSoftwareServerCapabilityClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteSoftwareServerCapabilityClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteSoftwareServerCapabilityClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteSoftwareServerCapabilityClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteSoftwareServerCapabilityClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SoftwareServerCapability declassifiedSoftwareServerCapability = SoftwareServerCapabilityMapper.mapOmrsEntityDetailToSoftwareServerCapability(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteSoftwareServerCapabilityClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedSoftwareServerCapability;
    }

    public Set<Line> getSoftwareServerCapabilityRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getSoftwareServerCapabilityRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getSoftwareServerCapabilityRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getSoftwareServerCapabilityRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getSoftwareServerCapabilityRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getSoftwareServerCapabilityRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public LicenseType getLicenseTypeById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getLicenseTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getLicenseTypeById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getLicenseTypeById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getLicenseTypeById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        LicenseType gotlicenseType = LicenseTypeMapper.mapOmrsEntityDetailToLicenseType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getLicenseTypeById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotlicenseType);
        }
        return gotlicenseType;
    }

    public LicenseType createLicenseType(String userId, LicenseType licenseType) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createLicenseTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createLicenseTypeById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createLicenseTypeById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("LicenseType");
        if (constraint != null) {
            constraint.preCreate(licenseType);
        }
        EntityDetail entityDetail = LicenseTypeMapper.mapLicenseTypeToOmrsEntityDetail(licenseType);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        LicenseType createdLicenseType = LicenseTypeMapper.mapOmrsEntityDetailToLicenseType(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createLicenseTypeById,userId=" + userId + ", created LicenseType=" + createdLicenseType);
        }
        return createdLicenseType;
    }

    public LicenseType updateLicenseType(String userId, LicenseType licenseType) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateLicenseTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateLicenseTypeById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateLicenseTypeById", (String)userId);
        EntityDetail entityDetail = LicenseTypeMapper.mapLicenseTypeToOmrsEntityDetail(licenseType);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateLicenseTypeById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        LicenseType updatedLicenseType = LicenseTypeMapper.mapOmrsEntityDetailToLicenseType(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateLicenseTypeById,userId=" + userId + ",updated LicenseType=" + updatedLicenseType);
        }
        return updatedLicenseType;
    }

    public EntityDetail deleteLicenseTypeByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteLicenseTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteLicenseTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteLicenseTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteLicenseTypeByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("LicenseType");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "LicenseType", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteLicenseTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeLicenseTypeByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeLicenseTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeLicenseTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeLicenseTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeLicenseTypeByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("LicenseType");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "LicenseType", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeLicenseTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public LicenseType restoreLicenseType(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreLicenseTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreLicenseTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreLicenseTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreLicenseTypeByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        LicenseType restoredLicenseType = LicenseTypeMapper.mapOmrsEntityDetailToLicenseType(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreLicenseTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredLicenseType;
    }

    public LicenseType addLicenseTypeClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addLicenseTypeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addLicenseTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addLicenseTypeClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addLicenseTypeClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        LicenseType licenseTypeClassifications = LicenseTypeMapper.mapOmrsEntityDetailToLicenseType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addLicenseTypeClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified LicenseType=" + licenseTypeClassifications);
        }
        return licenseTypeClassifications;
    }

    public LicenseType updateLicenseTypeClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateLicenseTypeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateLicenseTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateLicenseTypeClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateLicenseTypeClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateLicenseTypeClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateLicenseTypeClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        LicenseType licenseTypeClassifications = LicenseTypeMapper.mapOmrsEntityDetailToLicenseType(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateLicenseTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return licenseTypeClassifications;
    }

    public LicenseType deleteLicenseTypeClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteLicenseTypeClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteLicenseTypeClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteLicenseTypeClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteLicenseTypeClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        LicenseType declassifiedLicenseType = LicenseTypeMapper.mapOmrsEntityDetailToLicenseType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteLicenseTypeClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedLicenseType;
    }

    public Set<Line> getLicenseTypeRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getLicenseTypeRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getLicenseTypeRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getLicenseTypeRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getLicenseTypeRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getLicenseTypeRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public GraphVertex getGraphVertexById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getGraphVertexById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGraphVertexById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGraphVertexById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGraphVertexById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GraphVertex gotgraphVertex = GraphVertexMapper.mapOmrsEntityDetailToGraphVertex(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGraphVertexById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotgraphVertex);
        }
        return gotgraphVertex;
    }

    public GraphVertex createGraphVertex(String userId, GraphVertex graphVertex) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createGraphVertexById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createGraphVertexById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createGraphVertexById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("GraphVertex");
        if (constraint != null) {
            constraint.preCreate(graphVertex);
        }
        EntityDetail entityDetail = GraphVertexMapper.mapGraphVertexToOmrsEntityDetail(graphVertex);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        GraphVertex createdGraphVertex = GraphVertexMapper.mapOmrsEntityDetailToGraphVertex(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createGraphVertexById,userId=" + userId + ", created GraphVertex=" + createdGraphVertex);
        }
        return createdGraphVertex;
    }

    public GraphVertex updateGraphVertex(String userId, GraphVertex graphVertex) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateGraphVertexById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGraphVertexById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGraphVertexById", (String)userId);
        EntityDetail entityDetail = GraphVertexMapper.mapGraphVertexToOmrsEntityDetail(graphVertex);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGraphVertexById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        GraphVertex updatedGraphVertex = GraphVertexMapper.mapOmrsEntityDetailToGraphVertex(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateGraphVertexById,userId=" + userId + ",updated GraphVertex=" + updatedGraphVertex);
        }
        return updatedGraphVertex;
    }

    public EntityDetail deleteGraphVertexByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteGraphVertexByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGraphVertexByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGraphVertexByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGraphVertexByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GraphVertex");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "GraphVertex", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGraphVertexByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeGraphVertexByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeGraphVertexByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeGraphVertexByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeGraphVertexByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeGraphVertexByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GraphVertex");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "GraphVertex", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeGraphVertexByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public GraphVertex restoreGraphVertex(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreGraphVertexByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreGraphVertexByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreGraphVertexByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreGraphVertexByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        GraphVertex restoredGraphVertex = GraphVertexMapper.mapOmrsEntityDetailToGraphVertex(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreGraphVertexByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredGraphVertex;
    }

    public GraphVertex addGraphVertexClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addGraphVertexClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addGraphVertexClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addGraphVertexClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addGraphVertexClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GraphVertex graphVertexClassifications = GraphVertexMapper.mapOmrsEntityDetailToGraphVertex(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addGraphVertexClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified GraphVertex=" + graphVertexClassifications);
        }
        return graphVertexClassifications;
    }

    public GraphVertex updateGraphVertexClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateGraphVertexClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGraphVertexClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGraphVertexClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGraphVertexClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateGraphVertexClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateGraphVertexClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GraphVertex graphVertexClassifications = GraphVertexMapper.mapOmrsEntityDetailToGraphVertex(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateGraphVertexClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return graphVertexClassifications;
    }

    public GraphVertex deleteGraphVertexClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteGraphVertexClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGraphVertexClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGraphVertexClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGraphVertexClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GraphVertex declassifiedGraphVertex = GraphVertexMapper.mapOmrsEntityDetailToGraphVertex(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGraphVertexClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedGraphVertex;
    }

    public Set<Line> getGraphVertexRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getGraphVertexRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGraphVertexRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGraphVertexRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGraphVertexRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGraphVertexRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public GlossaryTerm getGlossaryTermById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getGlossaryTermById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGlossaryTermById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGlossaryTermById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGlossaryTermById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GlossaryTerm gotglossaryTerm = GlossaryTermMapper.mapOmrsEntityDetailToGlossaryTerm(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGlossaryTermById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotglossaryTerm);
        }
        return gotglossaryTerm;
    }

    public GlossaryTerm createGlossaryTerm(String userId, GlossaryTerm glossaryTerm) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createGlossaryTermById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createGlossaryTermById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createGlossaryTermById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("GlossaryTerm");
        if (constraint != null) {
            constraint.preCreate(glossaryTerm);
        }
        EntityDetail entityDetail = GlossaryTermMapper.mapGlossaryTermToOmrsEntityDetail(glossaryTerm);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        GlossaryTerm createdGlossaryTerm = GlossaryTermMapper.mapOmrsEntityDetailToGlossaryTerm(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createGlossaryTermById,userId=" + userId + ", created GlossaryTerm=" + createdGlossaryTerm);
        }
        return createdGlossaryTerm;
    }

    public GlossaryTerm updateGlossaryTerm(String userId, GlossaryTerm glossaryTerm) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateGlossaryTermById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGlossaryTermById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGlossaryTermById", (String)userId);
        EntityDetail entityDetail = GlossaryTermMapper.mapGlossaryTermToOmrsEntityDetail(glossaryTerm);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGlossaryTermById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        GlossaryTerm updatedGlossaryTerm = GlossaryTermMapper.mapOmrsEntityDetailToGlossaryTerm(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateGlossaryTermById,userId=" + userId + ",updated GlossaryTerm=" + updatedGlossaryTerm);
        }
        return updatedGlossaryTerm;
    }

    public EntityDetail deleteGlossaryTermByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteGlossaryTermByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGlossaryTermByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGlossaryTermByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGlossaryTermByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GlossaryTerm");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "GlossaryTerm", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGlossaryTermByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeGlossaryTermByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeGlossaryTermByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeGlossaryTermByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeGlossaryTermByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeGlossaryTermByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GlossaryTerm");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "GlossaryTerm", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeGlossaryTermByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public GlossaryTerm restoreGlossaryTerm(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreGlossaryTermByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreGlossaryTermByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreGlossaryTermByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreGlossaryTermByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        GlossaryTerm restoredGlossaryTerm = GlossaryTermMapper.mapOmrsEntityDetailToGlossaryTerm(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreGlossaryTermByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredGlossaryTerm;
    }

    public GlossaryTerm addGlossaryTermClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addGlossaryTermClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addGlossaryTermClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addGlossaryTermClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addGlossaryTermClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GlossaryTerm glossaryTermClassifications = GlossaryTermMapper.mapOmrsEntityDetailToGlossaryTerm(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addGlossaryTermClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified GlossaryTerm=" + glossaryTermClassifications);
        }
        return glossaryTermClassifications;
    }

    public GlossaryTerm updateGlossaryTermClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateGlossaryTermClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGlossaryTermClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGlossaryTermClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGlossaryTermClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateGlossaryTermClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateGlossaryTermClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GlossaryTerm glossaryTermClassifications = GlossaryTermMapper.mapOmrsEntityDetailToGlossaryTerm(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateGlossaryTermClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return glossaryTermClassifications;
    }

    public GlossaryTerm deleteGlossaryTermClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteGlossaryTermClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGlossaryTermClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGlossaryTermClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGlossaryTermClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GlossaryTerm declassifiedGlossaryTerm = GlossaryTermMapper.mapOmrsEntityDetailToGlossaryTerm(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGlossaryTermClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedGlossaryTerm;
    }

    public Set<Line> getGlossaryTermRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getGlossaryTermRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGlossaryTermRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGlossaryTermRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGlossaryTermRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGlossaryTermRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public Team getTeamById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getTeamById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getTeamById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getTeamById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getTeamById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Team gotteam = TeamMapper.mapOmrsEntityDetailToTeam(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTeamById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotteam);
        }
        return gotteam;
    }

    public Team createTeam(String userId, Team team) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createTeamById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createTeamById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createTeamById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Team");
        if (constraint != null) {
            constraint.preCreate(team);
        }
        EntityDetail entityDetail = TeamMapper.mapTeamToOmrsEntityDetail(team);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        Team createdTeam = TeamMapper.mapOmrsEntityDetailToTeam(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createTeamById,userId=" + userId + ", created Team=" + createdTeam);
        }
        return createdTeam;
    }

    public Team updateTeam(String userId, Team team) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateTeamById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateTeamById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateTeamById", (String)userId);
        EntityDetail entityDetail = TeamMapper.mapTeamToOmrsEntityDetail(team);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateTeamById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        Team updatedTeam = TeamMapper.mapOmrsEntityDetailToTeam(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateTeamById,userId=" + userId + ",updated Team=" + updatedTeam);
        }
        return updatedTeam;
    }

    public EntityDetail deleteTeamByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteTeamByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteTeamByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteTeamByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteTeamByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Team");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "Team", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteTeamByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeTeamByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeTeamByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeTeamByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeTeamByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeTeamByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Team");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "Team", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeTeamByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public Team restoreTeam(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreTeamByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreTeamByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreTeamByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreTeamByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        Team restoredTeam = TeamMapper.mapOmrsEntityDetailToTeam(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreTeamByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredTeam;
    }

    public Team addTeamClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addTeamClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addTeamClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addTeamClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addTeamClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Team teamClassifications = TeamMapper.mapOmrsEntityDetailToTeam(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addTeamClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified Team=" + teamClassifications);
        }
        return teamClassifications;
    }

    public Team updateTeamClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateTeamClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateTeamClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateTeamClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateTeamClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateTeamClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateTeamClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Team teamClassifications = TeamMapper.mapOmrsEntityDetailToTeam(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateTeamClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return teamClassifications;
    }

    public Team deleteTeamClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteTeamClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteTeamClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteTeamClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteTeamClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Team declassifiedTeam = TeamMapper.mapOmrsEntityDetailToTeam(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteTeamClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedTeam;
    }

    public Set<Line> getTeamRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getTeamRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getTeamRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getTeamRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getTeamRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTeamRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public MetadataCollection getMetadataCollectionById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getMetadataCollectionById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getMetadataCollectionById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getMetadataCollectionById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getMetadataCollectionById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        MetadataCollection gotmetadataCollection = MetadataCollectionMapper.mapOmrsEntityDetailToMetadataCollection(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getMetadataCollectionById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotmetadataCollection);
        }
        return gotmetadataCollection;
    }

    public MetadataCollection createMetadataCollection(String userId, MetadataCollection metadataCollection) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createMetadataCollectionById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createMetadataCollectionById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createMetadataCollectionById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("MetadataCollection");
        if (constraint != null) {
            constraint.preCreate(metadataCollection);
        }
        EntityDetail entityDetail = MetadataCollectionMapper.mapMetadataCollectionToOmrsEntityDetail(metadataCollection);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        MetadataCollection createdMetadataCollection = MetadataCollectionMapper.mapOmrsEntityDetailToMetadataCollection(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createMetadataCollectionById,userId=" + userId + ", created MetadataCollection=" + createdMetadataCollection);
        }
        return createdMetadataCollection;
    }

    public MetadataCollection updateMetadataCollection(String userId, MetadataCollection metadataCollection) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateMetadataCollectionById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateMetadataCollectionById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateMetadataCollectionById", (String)userId);
        EntityDetail entityDetail = MetadataCollectionMapper.mapMetadataCollectionToOmrsEntityDetail(metadataCollection);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateMetadataCollectionById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        MetadataCollection updatedMetadataCollection = MetadataCollectionMapper.mapOmrsEntityDetailToMetadataCollection(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateMetadataCollectionById,userId=" + userId + ",updated MetadataCollection=" + updatedMetadataCollection);
        }
        return updatedMetadataCollection;
    }

    public EntityDetail deleteMetadataCollectionByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteMetadataCollectionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteMetadataCollectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteMetadataCollectionByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteMetadataCollectionByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("MetadataCollection");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "MetadataCollection", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteMetadataCollectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeMetadataCollectionByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeMetadataCollectionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeMetadataCollectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeMetadataCollectionByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeMetadataCollectionByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("MetadataCollection");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "MetadataCollection", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeMetadataCollectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public MetadataCollection restoreMetadataCollection(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreMetadataCollectionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreMetadataCollectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreMetadataCollectionByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreMetadataCollectionByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        MetadataCollection restoredMetadataCollection = MetadataCollectionMapper.mapOmrsEntityDetailToMetadataCollection(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreMetadataCollectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredMetadataCollection;
    }

    public MetadataCollection addMetadataCollectionClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addMetadataCollectionClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addMetadataCollectionClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addMetadataCollectionClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addMetadataCollectionClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        MetadataCollection metadataCollectionClassifications = MetadataCollectionMapper.mapOmrsEntityDetailToMetadataCollection(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addMetadataCollectionClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified MetadataCollection=" + metadataCollectionClassifications);
        }
        return metadataCollectionClassifications;
    }

    public MetadataCollection updateMetadataCollectionClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateMetadataCollectionClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateMetadataCollectionClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateMetadataCollectionClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateMetadataCollectionClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateMetadataCollectionClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateMetadataCollectionClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        MetadataCollection metadataCollectionClassifications = MetadataCollectionMapper.mapOmrsEntityDetailToMetadataCollection(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateMetadataCollectionClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return metadataCollectionClassifications;
    }

    public MetadataCollection deleteMetadataCollectionClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteMetadataCollectionClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteMetadataCollectionClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteMetadataCollectionClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteMetadataCollectionClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        MetadataCollection declassifiedMetadataCollection = MetadataCollectionMapper.mapOmrsEntityDetailToMetadataCollection(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteMetadataCollectionClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedMetadataCollection;
    }

    public Set<Line> getMetadataCollectionRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getMetadataCollectionRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getMetadataCollectionRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getMetadataCollectionRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getMetadataCollectionRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getMetadataCollectionRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public GovernanceControl getGovernanceControlById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getGovernanceControlById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGovernanceControlById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGovernanceControlById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGovernanceControlById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceControl gotgovernanceControl = GovernanceControlMapper.mapOmrsEntityDetailToGovernanceControl(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGovernanceControlById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotgovernanceControl);
        }
        return gotgovernanceControl;
    }

    public GovernanceControl createGovernanceControl(String userId, GovernanceControl governanceControl) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createGovernanceControlById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createGovernanceControlById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createGovernanceControlById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("GovernanceControl");
        if (constraint != null) {
            constraint.preCreate(governanceControl);
        }
        EntityDetail entityDetail = GovernanceControlMapper.mapGovernanceControlToOmrsEntityDetail(governanceControl);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        GovernanceControl createdGovernanceControl = GovernanceControlMapper.mapOmrsEntityDetailToGovernanceControl(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createGovernanceControlById,userId=" + userId + ", created GovernanceControl=" + createdGovernanceControl);
        }
        return createdGovernanceControl;
    }

    public GovernanceControl updateGovernanceControl(String userId, GovernanceControl governanceControl) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateGovernanceControlById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGovernanceControlById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGovernanceControlById", (String)userId);
        EntityDetail entityDetail = GovernanceControlMapper.mapGovernanceControlToOmrsEntityDetail(governanceControl);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGovernanceControlById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        GovernanceControl updatedGovernanceControl = GovernanceControlMapper.mapOmrsEntityDetailToGovernanceControl(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateGovernanceControlById,userId=" + userId + ",updated GovernanceControl=" + updatedGovernanceControl);
        }
        return updatedGovernanceControl;
    }

    public EntityDetail deleteGovernanceControlByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteGovernanceControlByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGovernanceControlByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGovernanceControlByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGovernanceControlByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernanceControl");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "GovernanceControl", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGovernanceControlByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeGovernanceControlByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeGovernanceControlByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeGovernanceControlByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeGovernanceControlByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeGovernanceControlByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernanceControl");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "GovernanceControl", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeGovernanceControlByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public GovernanceControl restoreGovernanceControl(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreGovernanceControlByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreGovernanceControlByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreGovernanceControlByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreGovernanceControlByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        GovernanceControl restoredGovernanceControl = GovernanceControlMapper.mapOmrsEntityDetailToGovernanceControl(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreGovernanceControlByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredGovernanceControl;
    }

    public GovernanceControl addGovernanceControlClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addGovernanceControlClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addGovernanceControlClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addGovernanceControlClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addGovernanceControlClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceControl governanceControlClassifications = GovernanceControlMapper.mapOmrsEntityDetailToGovernanceControl(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addGovernanceControlClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified GovernanceControl=" + governanceControlClassifications);
        }
        return governanceControlClassifications;
    }

    public GovernanceControl updateGovernanceControlClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateGovernanceControlClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGovernanceControlClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGovernanceControlClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGovernanceControlClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateGovernanceControlClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateGovernanceControlClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceControl governanceControlClassifications = GovernanceControlMapper.mapOmrsEntityDetailToGovernanceControl(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateGovernanceControlClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return governanceControlClassifications;
    }

    public GovernanceControl deleteGovernanceControlClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteGovernanceControlClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGovernanceControlClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGovernanceControlClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGovernanceControlClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceControl declassifiedGovernanceControl = GovernanceControlMapper.mapOmrsEntityDetailToGovernanceControl(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGovernanceControlClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedGovernanceControl;
    }

    public Set<Line> getGovernanceControlRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getGovernanceControlRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGovernanceControlRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGovernanceControlRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGovernanceControlRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGovernanceControlRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public Topic getTopicById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getTopicById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getTopicById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getTopicById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getTopicById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Topic gottopic = TopicMapper.mapOmrsEntityDetailToTopic(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTopicById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gottopic);
        }
        return gottopic;
    }

    public Topic createTopic(String userId, Topic topic) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createTopicById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createTopicById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createTopicById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Topic");
        if (constraint != null) {
            constraint.preCreate(topic);
        }
        EntityDetail entityDetail = TopicMapper.mapTopicToOmrsEntityDetail(topic);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        Topic createdTopic = TopicMapper.mapOmrsEntityDetailToTopic(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createTopicById,userId=" + userId + ", created Topic=" + createdTopic);
        }
        return createdTopic;
    }

    public Topic updateTopic(String userId, Topic topic) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateTopicById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateTopicById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateTopicById", (String)userId);
        EntityDetail entityDetail = TopicMapper.mapTopicToOmrsEntityDetail(topic);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateTopicById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        Topic updatedTopic = TopicMapper.mapOmrsEntityDetailToTopic(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateTopicById,userId=" + userId + ",updated Topic=" + updatedTopic);
        }
        return updatedTopic;
    }

    public EntityDetail deleteTopicByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteTopicByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteTopicByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteTopicByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteTopicByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Topic");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "Topic", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteTopicByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeTopicByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeTopicByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeTopicByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeTopicByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeTopicByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Topic");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "Topic", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeTopicByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public Topic restoreTopic(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreTopicByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreTopicByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreTopicByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreTopicByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        Topic restoredTopic = TopicMapper.mapOmrsEntityDetailToTopic(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreTopicByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredTopic;
    }

    public Topic addTopicClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addTopicClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addTopicClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addTopicClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addTopicClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Topic topicClassifications = TopicMapper.mapOmrsEntityDetailToTopic(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addTopicClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified Topic=" + topicClassifications);
        }
        return topicClassifications;
    }

    public Topic updateTopicClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateTopicClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateTopicClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateTopicClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateTopicClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateTopicClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateTopicClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Topic topicClassifications = TopicMapper.mapOmrsEntityDetailToTopic(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateTopicClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return topicClassifications;
    }

    public Topic deleteTopicClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteTopicClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteTopicClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteTopicClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteTopicClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Topic declassifiedTopic = TopicMapper.mapOmrsEntityDetailToTopic(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteTopicClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedTopic;
    }

    public Set<Line> getTopicRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getTopicRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getTopicRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getTopicRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getTopicRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTopicRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public SoftwareServer getSoftwareServerById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getSoftwareServerById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getSoftwareServerById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getSoftwareServerById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getSoftwareServerById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SoftwareServer gotsoftwareServer = SoftwareServerMapper.mapOmrsEntityDetailToSoftwareServer(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getSoftwareServerById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotsoftwareServer);
        }
        return gotsoftwareServer;
    }

    public SoftwareServer createSoftwareServer(String userId, SoftwareServer softwareServer) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createSoftwareServerById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createSoftwareServerById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createSoftwareServerById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("SoftwareServer");
        if (constraint != null) {
            constraint.preCreate(softwareServer);
        }
        EntityDetail entityDetail = SoftwareServerMapper.mapSoftwareServerToOmrsEntityDetail(softwareServer);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        SoftwareServer createdSoftwareServer = SoftwareServerMapper.mapOmrsEntityDetailToSoftwareServer(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createSoftwareServerById,userId=" + userId + ", created SoftwareServer=" + createdSoftwareServer);
        }
        return createdSoftwareServer;
    }

    public SoftwareServer updateSoftwareServer(String userId, SoftwareServer softwareServer) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateSoftwareServerById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateSoftwareServerById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateSoftwareServerById", (String)userId);
        EntityDetail entityDetail = SoftwareServerMapper.mapSoftwareServerToOmrsEntityDetail(softwareServer);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateSoftwareServerById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        SoftwareServer updatedSoftwareServer = SoftwareServerMapper.mapOmrsEntityDetailToSoftwareServer(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateSoftwareServerById,userId=" + userId + ",updated SoftwareServer=" + updatedSoftwareServer);
        }
        return updatedSoftwareServer;
    }

    public EntityDetail deleteSoftwareServerByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteSoftwareServerByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteSoftwareServerByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteSoftwareServerByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteSoftwareServerByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("SoftwareServer");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "SoftwareServer", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteSoftwareServerByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeSoftwareServerByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeSoftwareServerByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeSoftwareServerByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeSoftwareServerByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeSoftwareServerByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("SoftwareServer");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "SoftwareServer", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeSoftwareServerByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public SoftwareServer restoreSoftwareServer(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreSoftwareServerByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreSoftwareServerByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreSoftwareServerByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreSoftwareServerByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        SoftwareServer restoredSoftwareServer = SoftwareServerMapper.mapOmrsEntityDetailToSoftwareServer(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreSoftwareServerByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredSoftwareServer;
    }

    public SoftwareServer addSoftwareServerClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addSoftwareServerClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addSoftwareServerClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addSoftwareServerClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addSoftwareServerClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SoftwareServer softwareServerClassifications = SoftwareServerMapper.mapOmrsEntityDetailToSoftwareServer(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addSoftwareServerClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified SoftwareServer=" + softwareServerClassifications);
        }
        return softwareServerClassifications;
    }

    public SoftwareServer updateSoftwareServerClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateSoftwareServerClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateSoftwareServerClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateSoftwareServerClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateSoftwareServerClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateSoftwareServerClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateSoftwareServerClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SoftwareServer softwareServerClassifications = SoftwareServerMapper.mapOmrsEntityDetailToSoftwareServer(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateSoftwareServerClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return softwareServerClassifications;
    }

    public SoftwareServer deleteSoftwareServerClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteSoftwareServerClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteSoftwareServerClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteSoftwareServerClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteSoftwareServerClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SoftwareServer declassifiedSoftwareServer = SoftwareServerMapper.mapOmrsEntityDetailToSoftwareServer(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteSoftwareServerClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedSoftwareServer;
    }

    public Set<Line> getSoftwareServerRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getSoftwareServerRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getSoftwareServerRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getSoftwareServerRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getSoftwareServerRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getSoftwareServerRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public DeployedAPI getDeployedAPIById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getDeployedAPIById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getDeployedAPIById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getDeployedAPIById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getDeployedAPIById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DeployedAPI gotdeployedAPI = DeployedAPIMapper.mapOmrsEntityDetailToDeployedAPI(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getDeployedAPIById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotdeployedAPI);
        }
        return gotdeployedAPI;
    }

    public DeployedAPI createDeployedAPI(String userId, DeployedAPI deployedAPI) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createDeployedAPIById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createDeployedAPIById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createDeployedAPIById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("DeployedAPI");
        if (constraint != null) {
            constraint.preCreate(deployedAPI);
        }
        EntityDetail entityDetail = DeployedAPIMapper.mapDeployedAPIToOmrsEntityDetail(deployedAPI);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        DeployedAPI createdDeployedAPI = DeployedAPIMapper.mapOmrsEntityDetailToDeployedAPI(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createDeployedAPIById,userId=" + userId + ", created DeployedAPI=" + createdDeployedAPI);
        }
        return createdDeployedAPI;
    }

    public DeployedAPI updateDeployedAPI(String userId, DeployedAPI deployedAPI) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateDeployedAPIById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateDeployedAPIById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateDeployedAPIById", (String)userId);
        EntityDetail entityDetail = DeployedAPIMapper.mapDeployedAPIToOmrsEntityDetail(deployedAPI);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateDeployedAPIById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        DeployedAPI updatedDeployedAPI = DeployedAPIMapper.mapOmrsEntityDetailToDeployedAPI(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateDeployedAPIById,userId=" + userId + ",updated DeployedAPI=" + updatedDeployedAPI);
        }
        return updatedDeployedAPI;
    }

    public EntityDetail deleteDeployedAPIByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteDeployedAPIByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteDeployedAPIByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteDeployedAPIByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteDeployedAPIByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("DeployedAPI");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "DeployedAPI", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteDeployedAPIByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeDeployedAPIByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeDeployedAPIByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeDeployedAPIByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeDeployedAPIByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeDeployedAPIByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("DeployedAPI");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "DeployedAPI", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeDeployedAPIByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public DeployedAPI restoreDeployedAPI(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreDeployedAPIByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreDeployedAPIByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreDeployedAPIByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreDeployedAPIByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        DeployedAPI restoredDeployedAPI = DeployedAPIMapper.mapOmrsEntityDetailToDeployedAPI(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreDeployedAPIByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredDeployedAPI;
    }

    public DeployedAPI addDeployedAPIClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addDeployedAPIClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addDeployedAPIClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addDeployedAPIClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addDeployedAPIClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DeployedAPI deployedAPIClassifications = DeployedAPIMapper.mapOmrsEntityDetailToDeployedAPI(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addDeployedAPIClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified DeployedAPI=" + deployedAPIClassifications);
        }
        return deployedAPIClassifications;
    }

    public DeployedAPI updateDeployedAPIClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateDeployedAPIClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateDeployedAPIClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateDeployedAPIClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateDeployedAPIClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateDeployedAPIClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateDeployedAPIClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DeployedAPI deployedAPIClassifications = DeployedAPIMapper.mapOmrsEntityDetailToDeployedAPI(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateDeployedAPIClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return deployedAPIClassifications;
    }

    public DeployedAPI deleteDeployedAPIClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteDeployedAPIClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteDeployedAPIClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteDeployedAPIClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteDeployedAPIClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        DeployedAPI declassifiedDeployedAPI = DeployedAPIMapper.mapOmrsEntityDetailToDeployedAPI(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteDeployedAPIClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedDeployedAPI;
    }

    public Set<Line> getDeployedAPIRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getDeployedAPIRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getDeployedAPIRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getDeployedAPIRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getDeployedAPIRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getDeployedAPIRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public MediaFile getMediaFileById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getMediaFileById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getMediaFileById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getMediaFileById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getMediaFileById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        MediaFile gotmediaFile = MediaFileMapper.mapOmrsEntityDetailToMediaFile(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getMediaFileById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotmediaFile);
        }
        return gotmediaFile;
    }

    public MediaFile createMediaFile(String userId, MediaFile mediaFile) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createMediaFileById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createMediaFileById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createMediaFileById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("MediaFile");
        if (constraint != null) {
            constraint.preCreate(mediaFile);
        }
        EntityDetail entityDetail = MediaFileMapper.mapMediaFileToOmrsEntityDetail(mediaFile);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        MediaFile createdMediaFile = MediaFileMapper.mapOmrsEntityDetailToMediaFile(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createMediaFileById,userId=" + userId + ", created MediaFile=" + createdMediaFile);
        }
        return createdMediaFile;
    }

    public MediaFile updateMediaFile(String userId, MediaFile mediaFile) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateMediaFileById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateMediaFileById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateMediaFileById", (String)userId);
        EntityDetail entityDetail = MediaFileMapper.mapMediaFileToOmrsEntityDetail(mediaFile);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateMediaFileById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        MediaFile updatedMediaFile = MediaFileMapper.mapOmrsEntityDetailToMediaFile(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateMediaFileById,userId=" + userId + ",updated MediaFile=" + updatedMediaFile);
        }
        return updatedMediaFile;
    }

    public EntityDetail deleteMediaFileByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteMediaFileByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteMediaFileByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteMediaFileByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteMediaFileByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("MediaFile");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "MediaFile", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteMediaFileByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeMediaFileByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeMediaFileByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeMediaFileByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeMediaFileByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeMediaFileByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("MediaFile");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "MediaFile", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeMediaFileByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public MediaFile restoreMediaFile(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreMediaFileByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreMediaFileByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreMediaFileByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreMediaFileByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        MediaFile restoredMediaFile = MediaFileMapper.mapOmrsEntityDetailToMediaFile(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreMediaFileByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredMediaFile;
    }

    public MediaFile addMediaFileClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addMediaFileClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addMediaFileClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addMediaFileClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addMediaFileClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        MediaFile mediaFileClassifications = MediaFileMapper.mapOmrsEntityDetailToMediaFile(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addMediaFileClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified MediaFile=" + mediaFileClassifications);
        }
        return mediaFileClassifications;
    }

    public MediaFile updateMediaFileClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateMediaFileClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateMediaFileClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateMediaFileClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateMediaFileClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateMediaFileClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateMediaFileClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        MediaFile mediaFileClassifications = MediaFileMapper.mapOmrsEntityDetailToMediaFile(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateMediaFileClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return mediaFileClassifications;
    }

    public MediaFile deleteMediaFileClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteMediaFileClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteMediaFileClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteMediaFileClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteMediaFileClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        MediaFile declassifiedMediaFile = MediaFileMapper.mapOmrsEntityDetailToMediaFile(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteMediaFileClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedMediaFile;
    }

    public Set<Line> getMediaFileRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getMediaFileRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getMediaFileRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getMediaFileRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getMediaFileRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getMediaFileRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public Comment getCommentById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getCommentById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCommentById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getCommentById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getCommentById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Comment gotcomment = CommentMapper.mapOmrsEntityDetailToComment(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCommentById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotcomment);
        }
        return gotcomment;
    }

    public Comment createComment(String userId, Comment comment) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createCommentById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createCommentById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createCommentById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Comment");
        if (constraint != null) {
            constraint.preCreate(comment);
        }
        EntityDetail entityDetail = CommentMapper.mapCommentToOmrsEntityDetail(comment);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        Comment createdComment = CommentMapper.mapOmrsEntityDetailToComment(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createCommentById,userId=" + userId + ", created Comment=" + createdComment);
        }
        return createdComment;
    }

    public Comment updateComment(String userId, Comment comment) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateCommentById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateCommentById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateCommentById", (String)userId);
        EntityDetail entityDetail = CommentMapper.mapCommentToOmrsEntityDetail(comment);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateCommentById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        Comment updatedComment = CommentMapper.mapOmrsEntityDetailToComment(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateCommentById,userId=" + userId + ",updated Comment=" + updatedComment);
        }
        return updatedComment;
    }

    public EntityDetail deleteCommentByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteCommentByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteCommentByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteCommentByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteCommentByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Comment");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "Comment", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteCommentByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeCommentByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeCommentByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeCommentByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeCommentByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeCommentByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Comment");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "Comment", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeCommentByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public Comment restoreComment(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreCommentByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreCommentByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreCommentByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreCommentByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        Comment restoredComment = CommentMapper.mapOmrsEntityDetailToComment(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreCommentByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredComment;
    }

    public Comment addCommentClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addCommentClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addCommentClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addCommentClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addCommentClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Comment commentClassifications = CommentMapper.mapOmrsEntityDetailToComment(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addCommentClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified Comment=" + commentClassifications);
        }
        return commentClassifications;
    }

    public Comment updateCommentClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateCommentClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateCommentClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateCommentClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateCommentClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateCommentClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateCommentClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Comment commentClassifications = CommentMapper.mapOmrsEntityDetailToComment(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateCommentClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return commentClassifications;
    }

    public Comment deleteCommentClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteCommentClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteCommentClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteCommentClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteCommentClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Comment declassifiedComment = CommentMapper.mapOmrsEntityDetailToComment(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteCommentClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedComment;
    }

    public Set<Line> getCommentRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getCommentRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCommentRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getCommentRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getCommentRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCommentRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public RelatedMedia getRelatedMediaById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getRelatedMediaById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getRelatedMediaById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getRelatedMediaById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getRelatedMediaById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        RelatedMedia gotrelatedMedia = RelatedMediaMapper.mapOmrsEntityDetailToRelatedMedia(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getRelatedMediaById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotrelatedMedia);
        }
        return gotrelatedMedia;
    }

    public RelatedMedia createRelatedMedia(String userId, RelatedMedia relatedMedia) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createRelatedMediaById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createRelatedMediaById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createRelatedMediaById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("RelatedMedia");
        if (constraint != null) {
            constraint.preCreate(relatedMedia);
        }
        EntityDetail entityDetail = RelatedMediaMapper.mapRelatedMediaToOmrsEntityDetail(relatedMedia);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        RelatedMedia createdRelatedMedia = RelatedMediaMapper.mapOmrsEntityDetailToRelatedMedia(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createRelatedMediaById,userId=" + userId + ", created RelatedMedia=" + createdRelatedMedia);
        }
        return createdRelatedMedia;
    }

    public RelatedMedia updateRelatedMedia(String userId, RelatedMedia relatedMedia) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateRelatedMediaById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateRelatedMediaById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateRelatedMediaById", (String)userId);
        EntityDetail entityDetail = RelatedMediaMapper.mapRelatedMediaToOmrsEntityDetail(relatedMedia);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateRelatedMediaById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        RelatedMedia updatedRelatedMedia = RelatedMediaMapper.mapOmrsEntityDetailToRelatedMedia(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateRelatedMediaById,userId=" + userId + ",updated RelatedMedia=" + updatedRelatedMedia);
        }
        return updatedRelatedMedia;
    }

    public EntityDetail deleteRelatedMediaByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteRelatedMediaByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteRelatedMediaByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteRelatedMediaByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteRelatedMediaByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("RelatedMedia");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "RelatedMedia", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteRelatedMediaByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeRelatedMediaByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeRelatedMediaByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeRelatedMediaByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeRelatedMediaByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeRelatedMediaByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("RelatedMedia");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "RelatedMedia", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeRelatedMediaByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public RelatedMedia restoreRelatedMedia(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreRelatedMediaByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreRelatedMediaByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreRelatedMediaByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreRelatedMediaByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        RelatedMedia restoredRelatedMedia = RelatedMediaMapper.mapOmrsEntityDetailToRelatedMedia(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreRelatedMediaByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredRelatedMedia;
    }

    public RelatedMedia addRelatedMediaClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addRelatedMediaClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addRelatedMediaClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addRelatedMediaClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addRelatedMediaClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        RelatedMedia relatedMediaClassifications = RelatedMediaMapper.mapOmrsEntityDetailToRelatedMedia(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addRelatedMediaClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified RelatedMedia=" + relatedMediaClassifications);
        }
        return relatedMediaClassifications;
    }

    public RelatedMedia updateRelatedMediaClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateRelatedMediaClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateRelatedMediaClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateRelatedMediaClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateRelatedMediaClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateRelatedMediaClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateRelatedMediaClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        RelatedMedia relatedMediaClassifications = RelatedMediaMapper.mapOmrsEntityDetailToRelatedMedia(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateRelatedMediaClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return relatedMediaClassifications;
    }

    public RelatedMedia deleteRelatedMediaClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteRelatedMediaClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteRelatedMediaClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteRelatedMediaClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteRelatedMediaClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        RelatedMedia declassifiedRelatedMedia = RelatedMediaMapper.mapOmrsEntityDetailToRelatedMedia(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteRelatedMediaClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedRelatedMedia;
    }

    public Set<Line> getRelatedMediaRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getRelatedMediaRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getRelatedMediaRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getRelatedMediaRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getRelatedMediaRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getRelatedMediaRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public ConnectorType getConnectorTypeById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getConnectorTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getConnectorTypeById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getConnectorTypeById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getConnectorTypeById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ConnectorType gotconnectorType = ConnectorTypeMapper.mapOmrsEntityDetailToConnectorType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getConnectorTypeById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotconnectorType);
        }
        return gotconnectorType;
    }

    public ConnectorType createConnectorType(String userId, ConnectorType connectorType) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createConnectorTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createConnectorTypeById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createConnectorTypeById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("ConnectorType");
        if (constraint != null) {
            constraint.preCreate(connectorType);
        }
        EntityDetail entityDetail = ConnectorTypeMapper.mapConnectorTypeToOmrsEntityDetail(connectorType);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        ConnectorType createdConnectorType = ConnectorTypeMapper.mapOmrsEntityDetailToConnectorType(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createConnectorTypeById,userId=" + userId + ", created ConnectorType=" + createdConnectorType);
        }
        return createdConnectorType;
    }

    public ConnectorType updateConnectorType(String userId, ConnectorType connectorType) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateConnectorTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateConnectorTypeById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateConnectorTypeById", (String)userId);
        EntityDetail entityDetail = ConnectorTypeMapper.mapConnectorTypeToOmrsEntityDetail(connectorType);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateConnectorTypeById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        ConnectorType updatedConnectorType = ConnectorTypeMapper.mapOmrsEntityDetailToConnectorType(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateConnectorTypeById,userId=" + userId + ",updated ConnectorType=" + updatedConnectorType);
        }
        return updatedConnectorType;
    }

    public EntityDetail deleteConnectorTypeByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteConnectorTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteConnectorTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteConnectorTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteConnectorTypeByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("ConnectorType");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "ConnectorType", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteConnectorTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeConnectorTypeByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeConnectorTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeConnectorTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeConnectorTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeConnectorTypeByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("ConnectorType");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "ConnectorType", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeConnectorTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public ConnectorType restoreConnectorType(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreConnectorTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreConnectorTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreConnectorTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreConnectorTypeByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        ConnectorType restoredConnectorType = ConnectorTypeMapper.mapOmrsEntityDetailToConnectorType(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreConnectorTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredConnectorType;
    }

    public ConnectorType addConnectorTypeClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addConnectorTypeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addConnectorTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addConnectorTypeClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addConnectorTypeClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ConnectorType connectorTypeClassifications = ConnectorTypeMapper.mapOmrsEntityDetailToConnectorType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addConnectorTypeClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified ConnectorType=" + connectorTypeClassifications);
        }
        return connectorTypeClassifications;
    }

    public ConnectorType updateConnectorTypeClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateConnectorTypeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateConnectorTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateConnectorTypeClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateConnectorTypeClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateConnectorTypeClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateConnectorTypeClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ConnectorType connectorTypeClassifications = ConnectorTypeMapper.mapOmrsEntityDetailToConnectorType(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateConnectorTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return connectorTypeClassifications;
    }

    public ConnectorType deleteConnectorTypeClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteConnectorTypeClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteConnectorTypeClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteConnectorTypeClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteConnectorTypeClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ConnectorType declassifiedConnectorType = ConnectorTypeMapper.mapOmrsEntityDetailToConnectorType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteConnectorTypeClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedConnectorType;
    }

    public Set<Line> getConnectorTypeRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getConnectorTypeRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getConnectorTypeRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getConnectorTypeRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getConnectorTypeRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getConnectorTypeRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public CohortMember getCohortMemberById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getCohortMemberById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCohortMemberById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getCohortMemberById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getCohortMemberById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        CohortMember gotcohortMember = CohortMemberMapper.mapOmrsEntityDetailToCohortMember(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCohortMemberById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotcohortMember);
        }
        return gotcohortMember;
    }

    public CohortMember createCohortMember(String userId, CohortMember cohortMember) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createCohortMemberById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createCohortMemberById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createCohortMemberById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("CohortMember");
        if (constraint != null) {
            constraint.preCreate(cohortMember);
        }
        EntityDetail entityDetail = CohortMemberMapper.mapCohortMemberToOmrsEntityDetail(cohortMember);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        CohortMember createdCohortMember = CohortMemberMapper.mapOmrsEntityDetailToCohortMember(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createCohortMemberById,userId=" + userId + ", created CohortMember=" + createdCohortMember);
        }
        return createdCohortMember;
    }

    public CohortMember updateCohortMember(String userId, CohortMember cohortMember) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateCohortMemberById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateCohortMemberById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateCohortMemberById", (String)userId);
        EntityDetail entityDetail = CohortMemberMapper.mapCohortMemberToOmrsEntityDetail(cohortMember);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateCohortMemberById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        CohortMember updatedCohortMember = CohortMemberMapper.mapOmrsEntityDetailToCohortMember(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateCohortMemberById,userId=" + userId + ",updated CohortMember=" + updatedCohortMember);
        }
        return updatedCohortMember;
    }

    public EntityDetail deleteCohortMemberByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteCohortMemberByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteCohortMemberByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteCohortMemberByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteCohortMemberByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("CohortMember");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "CohortMember", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteCohortMemberByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeCohortMemberByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeCohortMemberByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeCohortMemberByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeCohortMemberByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeCohortMemberByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("CohortMember");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "CohortMember", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeCohortMemberByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public CohortMember restoreCohortMember(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreCohortMemberByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreCohortMemberByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreCohortMemberByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreCohortMemberByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        CohortMember restoredCohortMember = CohortMemberMapper.mapOmrsEntityDetailToCohortMember(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreCohortMemberByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredCohortMember;
    }

    public CohortMember addCohortMemberClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addCohortMemberClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addCohortMemberClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addCohortMemberClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addCohortMemberClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        CohortMember cohortMemberClassifications = CohortMemberMapper.mapOmrsEntityDetailToCohortMember(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addCohortMemberClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified CohortMember=" + cohortMemberClassifications);
        }
        return cohortMemberClassifications;
    }

    public CohortMember updateCohortMemberClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateCohortMemberClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateCohortMemberClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateCohortMemberClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateCohortMemberClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateCohortMemberClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateCohortMemberClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        CohortMember cohortMemberClassifications = CohortMemberMapper.mapOmrsEntityDetailToCohortMember(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateCohortMemberClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return cohortMemberClassifications;
    }

    public CohortMember deleteCohortMemberClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteCohortMemberClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteCohortMemberClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteCohortMemberClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteCohortMemberClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        CohortMember declassifiedCohortMember = CohortMemberMapper.mapOmrsEntityDetailToCohortMember(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteCohortMemberClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedCohortMember;
    }

    public Set<Line> getCohortMemberRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getCohortMemberRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCohortMemberRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getCohortMemberRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getCohortMemberRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCohortMemberRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public ComplexSchemaType getComplexSchemaTypeById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getComplexSchemaTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getComplexSchemaTypeById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getComplexSchemaTypeById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getComplexSchemaTypeById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ComplexSchemaType gotcomplexSchemaType = ComplexSchemaTypeMapper.mapOmrsEntityDetailToComplexSchemaType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getComplexSchemaTypeById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotcomplexSchemaType);
        }
        return gotcomplexSchemaType;
    }

    public ComplexSchemaType createComplexSchemaType(String userId, ComplexSchemaType complexSchemaType) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createComplexSchemaTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createComplexSchemaTypeById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createComplexSchemaTypeById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("ComplexSchemaType");
        if (constraint != null) {
            constraint.preCreate(complexSchemaType);
        }
        EntityDetail entityDetail = ComplexSchemaTypeMapper.mapComplexSchemaTypeToOmrsEntityDetail(complexSchemaType);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        ComplexSchemaType createdComplexSchemaType = ComplexSchemaTypeMapper.mapOmrsEntityDetailToComplexSchemaType(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createComplexSchemaTypeById,userId=" + userId + ", created ComplexSchemaType=" + createdComplexSchemaType);
        }
        return createdComplexSchemaType;
    }

    public ComplexSchemaType updateComplexSchemaType(String userId, ComplexSchemaType complexSchemaType) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateComplexSchemaTypeById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateComplexSchemaTypeById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateComplexSchemaTypeById", (String)userId);
        EntityDetail entityDetail = ComplexSchemaTypeMapper.mapComplexSchemaTypeToOmrsEntityDetail(complexSchemaType);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateComplexSchemaTypeById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        ComplexSchemaType updatedComplexSchemaType = ComplexSchemaTypeMapper.mapOmrsEntityDetailToComplexSchemaType(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateComplexSchemaTypeById,userId=" + userId + ",updated ComplexSchemaType=" + updatedComplexSchemaType);
        }
        return updatedComplexSchemaType;
    }

    public EntityDetail deleteComplexSchemaTypeByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteComplexSchemaTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteComplexSchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteComplexSchemaTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteComplexSchemaTypeByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("ComplexSchemaType");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "ComplexSchemaType", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteComplexSchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeComplexSchemaTypeByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeComplexSchemaTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeComplexSchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeComplexSchemaTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeComplexSchemaTypeByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("ComplexSchemaType");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "ComplexSchemaType", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeComplexSchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public ComplexSchemaType restoreComplexSchemaType(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreComplexSchemaTypeByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreComplexSchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreComplexSchemaTypeByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreComplexSchemaTypeByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        ComplexSchemaType restoredComplexSchemaType = ComplexSchemaTypeMapper.mapOmrsEntityDetailToComplexSchemaType(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreComplexSchemaTypeByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredComplexSchemaType;
    }

    public ComplexSchemaType addComplexSchemaTypeClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addComplexSchemaTypeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addComplexSchemaTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addComplexSchemaTypeClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addComplexSchemaTypeClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ComplexSchemaType complexSchemaTypeClassifications = ComplexSchemaTypeMapper.mapOmrsEntityDetailToComplexSchemaType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addComplexSchemaTypeClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified ComplexSchemaType=" + complexSchemaTypeClassifications);
        }
        return complexSchemaTypeClassifications;
    }

    public ComplexSchemaType updateComplexSchemaTypeClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateComplexSchemaTypeClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateComplexSchemaTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateComplexSchemaTypeClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateComplexSchemaTypeClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateComplexSchemaTypeClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateComplexSchemaTypeClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ComplexSchemaType complexSchemaTypeClassifications = ComplexSchemaTypeMapper.mapOmrsEntityDetailToComplexSchemaType(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateComplexSchemaTypeClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return complexSchemaTypeClassifications;
    }

    public ComplexSchemaType deleteComplexSchemaTypeClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteComplexSchemaTypeClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteComplexSchemaTypeClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteComplexSchemaTypeClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteComplexSchemaTypeClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ComplexSchemaType declassifiedComplexSchemaType = ComplexSchemaTypeMapper.mapOmrsEntityDetailToComplexSchemaType(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteComplexSchemaTypeClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedComplexSchemaType;
    }

    public Set<Line> getComplexSchemaTypeRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getComplexSchemaTypeRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getComplexSchemaTypeRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getComplexSchemaTypeRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getComplexSchemaTypeRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getComplexSchemaTypeRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public GovernanceMetric getGovernanceMetricById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getGovernanceMetricById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGovernanceMetricById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGovernanceMetricById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGovernanceMetricById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceMetric gotgovernanceMetric = GovernanceMetricMapper.mapOmrsEntityDetailToGovernanceMetric(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGovernanceMetricById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotgovernanceMetric);
        }
        return gotgovernanceMetric;
    }

    public GovernanceMetric createGovernanceMetric(String userId, GovernanceMetric governanceMetric) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createGovernanceMetricById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createGovernanceMetricById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createGovernanceMetricById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("GovernanceMetric");
        if (constraint != null) {
            constraint.preCreate(governanceMetric);
        }
        EntityDetail entityDetail = GovernanceMetricMapper.mapGovernanceMetricToOmrsEntityDetail(governanceMetric);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        GovernanceMetric createdGovernanceMetric = GovernanceMetricMapper.mapOmrsEntityDetailToGovernanceMetric(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createGovernanceMetricById,userId=" + userId + ", created GovernanceMetric=" + createdGovernanceMetric);
        }
        return createdGovernanceMetric;
    }

    public GovernanceMetric updateGovernanceMetric(String userId, GovernanceMetric governanceMetric) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateGovernanceMetricById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGovernanceMetricById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGovernanceMetricById", (String)userId);
        EntityDetail entityDetail = GovernanceMetricMapper.mapGovernanceMetricToOmrsEntityDetail(governanceMetric);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGovernanceMetricById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        GovernanceMetric updatedGovernanceMetric = GovernanceMetricMapper.mapOmrsEntityDetailToGovernanceMetric(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateGovernanceMetricById,userId=" + userId + ",updated GovernanceMetric=" + updatedGovernanceMetric);
        }
        return updatedGovernanceMetric;
    }

    public EntityDetail deleteGovernanceMetricByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteGovernanceMetricByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGovernanceMetricByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGovernanceMetricByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGovernanceMetricByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernanceMetric");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "GovernanceMetric", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGovernanceMetricByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeGovernanceMetricByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeGovernanceMetricByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeGovernanceMetricByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeGovernanceMetricByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeGovernanceMetricByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("GovernanceMetric");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "GovernanceMetric", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeGovernanceMetricByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public GovernanceMetric restoreGovernanceMetric(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreGovernanceMetricByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreGovernanceMetricByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreGovernanceMetricByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreGovernanceMetricByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        GovernanceMetric restoredGovernanceMetric = GovernanceMetricMapper.mapOmrsEntityDetailToGovernanceMetric(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreGovernanceMetricByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredGovernanceMetric;
    }

    public GovernanceMetric addGovernanceMetricClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addGovernanceMetricClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addGovernanceMetricClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addGovernanceMetricClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addGovernanceMetricClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceMetric governanceMetricClassifications = GovernanceMetricMapper.mapOmrsEntityDetailToGovernanceMetric(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addGovernanceMetricClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified GovernanceMetric=" + governanceMetricClassifications);
        }
        return governanceMetricClassifications;
    }

    public GovernanceMetric updateGovernanceMetricClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateGovernanceMetricClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGovernanceMetricClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGovernanceMetricClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGovernanceMetricClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateGovernanceMetricClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateGovernanceMetricClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceMetric governanceMetricClassifications = GovernanceMetricMapper.mapOmrsEntityDetailToGovernanceMetric(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateGovernanceMetricClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return governanceMetricClassifications;
    }

    public GovernanceMetric deleteGovernanceMetricClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteGovernanceMetricClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGovernanceMetricClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGovernanceMetricClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGovernanceMetricClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        GovernanceMetric declassifiedGovernanceMetric = GovernanceMetricMapper.mapOmrsEntityDetailToGovernanceMetric(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteGovernanceMetricClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedGovernanceMetric;
    }

    public Set<Line> getGovernanceMetricRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getGovernanceMetricRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGovernanceMetricRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGovernanceMetricRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGovernanceMetricRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGovernanceMetricRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public ExternalId getExternalIdById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getExternalIdById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getExternalIdById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getExternalIdById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getExternalIdById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ExternalId gotexternalId = ExternalIdMapper.mapOmrsEntityDetailToExternalId(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getExternalIdById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotexternalId);
        }
        return gotexternalId;
    }

    public ExternalId createExternalId(String userId, ExternalId externalId) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createExternalIdById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createExternalIdById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createExternalIdById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("ExternalId");
        if (constraint != null) {
            constraint.preCreate(externalId);
        }
        EntityDetail entityDetail = ExternalIdMapper.mapExternalIdToOmrsEntityDetail(externalId);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        ExternalId createdExternalId = ExternalIdMapper.mapOmrsEntityDetailToExternalId(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createExternalIdById,userId=" + userId + ", created ExternalId=" + createdExternalId);
        }
        return createdExternalId;
    }

    public ExternalId updateExternalId(String userId, ExternalId externalId) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateExternalIdById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateExternalIdById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateExternalIdById", (String)userId);
        EntityDetail entityDetail = ExternalIdMapper.mapExternalIdToOmrsEntityDetail(externalId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateExternalIdById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        ExternalId updatedExternalId = ExternalIdMapper.mapOmrsEntityDetailToExternalId(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateExternalIdById,userId=" + userId + ",updated ExternalId=" + updatedExternalId);
        }
        return updatedExternalId;
    }

    public EntityDetail deleteExternalIdByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteExternalIdByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteExternalIdByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteExternalIdByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteExternalIdByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("ExternalId");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "ExternalId", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteExternalIdByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeExternalIdByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeExternalIdByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeExternalIdByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeExternalIdByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeExternalIdByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("ExternalId");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "ExternalId", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeExternalIdByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public ExternalId restoreExternalId(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreExternalIdByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreExternalIdByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreExternalIdByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreExternalIdByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        ExternalId restoredExternalId = ExternalIdMapper.mapOmrsEntityDetailToExternalId(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreExternalIdByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredExternalId;
    }

    public ExternalId addExternalIdClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addExternalIdClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addExternalIdClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addExternalIdClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addExternalIdClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ExternalId externalIdClassifications = ExternalIdMapper.mapOmrsEntityDetailToExternalId(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addExternalIdClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified ExternalId=" + externalIdClassifications);
        }
        return externalIdClassifications;
    }

    public ExternalId updateExternalIdClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateExternalIdClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateExternalIdClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateExternalIdClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateExternalIdClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateExternalIdClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateExternalIdClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ExternalId externalIdClassifications = ExternalIdMapper.mapOmrsEntityDetailToExternalId(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateExternalIdClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return externalIdClassifications;
    }

    public ExternalId deleteExternalIdClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteExternalIdClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteExternalIdClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteExternalIdClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteExternalIdClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        ExternalId declassifiedExternalId = ExternalIdMapper.mapOmrsEntityDetailToExternalId(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteExternalIdClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedExternalId;
    }

    public Set<Line> getExternalIdRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getExternalIdRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getExternalIdRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getExternalIdRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getExternalIdRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getExternalIdRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public Connection getConnectionById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getConnectionById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getConnectionById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getConnectionById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getConnectionById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Connection gotconnection = ConnectionMapper.mapOmrsEntityDetailToConnection(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getConnectionById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotconnection);
        }
        return gotconnection;
    }

    public Connection createConnection(String userId, Connection connection) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createConnectionById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createConnectionById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createConnectionById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Connection");
        if (constraint != null) {
            constraint.preCreate(connection);
        }
        EntityDetail entityDetail = ConnectionMapper.mapConnectionToOmrsEntityDetail(connection);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        Connection createdConnection = ConnectionMapper.mapOmrsEntityDetailToConnection(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createConnectionById,userId=" + userId + ", created Connection=" + createdConnection);
        }
        return createdConnection;
    }

    public Connection updateConnection(String userId, Connection connection) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateConnectionById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateConnectionById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateConnectionById", (String)userId);
        EntityDetail entityDetail = ConnectionMapper.mapConnectionToOmrsEntityDetail(connection);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateConnectionById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        Connection updatedConnection = ConnectionMapper.mapOmrsEntityDetailToConnection(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateConnectionById,userId=" + userId + ",updated Connection=" + updatedConnection);
        }
        return updatedConnection;
    }

    public EntityDetail deleteConnectionByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteConnectionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteConnectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteConnectionByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteConnectionByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Connection");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "Connection", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteConnectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeConnectionByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeConnectionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeConnectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeConnectionByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeConnectionByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Connection");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "Connection", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeConnectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public Connection restoreConnection(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreConnectionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreConnectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreConnectionByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreConnectionByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        Connection restoredConnection = ConnectionMapper.mapOmrsEntityDetailToConnection(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreConnectionByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredConnection;
    }

    public Connection addConnectionClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addConnectionClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addConnectionClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addConnectionClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addConnectionClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Connection connectionClassifications = ConnectionMapper.mapOmrsEntityDetailToConnection(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addConnectionClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified Connection=" + connectionClassifications);
        }
        return connectionClassifications;
    }

    public Connection updateConnectionClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateConnectionClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateConnectionClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateConnectionClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateConnectionClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateConnectionClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateConnectionClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Connection connectionClassifications = ConnectionMapper.mapOmrsEntityDetailToConnection(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateConnectionClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return connectionClassifications;
    }

    public Connection deleteConnectionClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteConnectionClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteConnectionClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteConnectionClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteConnectionClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Connection declassifiedConnection = ConnectionMapper.mapOmrsEntityDetailToConnection(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteConnectionClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedConnection;
    }

    public Set<Line> getConnectionRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getConnectionRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getConnectionRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getConnectionRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getConnectionRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getConnectionRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public Host getHostById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getHostById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getHostById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getHostById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getHostById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Host gothost = HostMapper.mapOmrsEntityDetailToHost(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getHostById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gothost);
        }
        return gothost;
    }

    public Host createHost(String userId, Host host) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createHostById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createHostById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createHostById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("Host");
        if (constraint != null) {
            constraint.preCreate(host);
        }
        EntityDetail entityDetail = HostMapper.mapHostToOmrsEntityDetail(host);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        Host createdHost = HostMapper.mapOmrsEntityDetailToHost(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createHostById,userId=" + userId + ", created Host=" + createdHost);
        }
        return createdHost;
    }

    public Host updateHost(String userId, Host host) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateHostById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateHostById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateHostById", (String)userId);
        EntityDetail entityDetail = HostMapper.mapHostToOmrsEntityDetail(host);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateHostById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        Host updatedHost = HostMapper.mapOmrsEntityDetailToHost(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateHostById,userId=" + userId + ",updated Host=" + updatedHost);
        }
        return updatedHost;
    }

    public EntityDetail deleteHostByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteHostByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteHostByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteHostByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteHostByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Host");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "Host", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteHostByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeHostByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeHostByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeHostByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeHostByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeHostByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("Host");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "Host", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeHostByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public Host restoreHost(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreHostByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreHostByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreHostByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreHostByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        Host restoredHost = HostMapper.mapOmrsEntityDetailToHost(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreHostByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredHost;
    }

    public Host addHostClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addHostClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addHostClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addHostClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addHostClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Host hostClassifications = HostMapper.mapOmrsEntityDetailToHost(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addHostClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified Host=" + hostClassifications);
        }
        return hostClassifications;
    }

    public Host updateHostClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateHostClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateHostClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateHostClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateHostClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateHostClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateHostClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Host hostClassifications = HostMapper.mapOmrsEntityDetailToHost(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateHostClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return hostClassifications;
    }

    public Host deleteHostClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteHostClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteHostClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteHostClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteHostClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        Host declassifiedHost = HostMapper.mapOmrsEntityDetailToHost(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteHostClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedHost;
    }

    public Set<Line> getHostRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getHostRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getHostRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getHostRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getHostRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getHostRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public SubscriberList getSubscriberListById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getSubscriberListById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getSubscriberListById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getSubscriberListById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getSubscriberListById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SubscriberList gotsubscriberList = SubscriberListMapper.mapOmrsEntityDetailToSubscriberList(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getSubscriberListById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotsubscriberList);
        }
        return gotsubscriberList;
    }

    public SubscriberList createSubscriberList(String userId, SubscriberList subscriberList) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createSubscriberListById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createSubscriberListById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createSubscriberListById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("SubscriberList");
        if (constraint != null) {
            constraint.preCreate(subscriberList);
        }
        EntityDetail entityDetail = SubscriberListMapper.mapSubscriberListToOmrsEntityDetail(subscriberList);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        SubscriberList createdSubscriberList = SubscriberListMapper.mapOmrsEntityDetailToSubscriberList(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createSubscriberListById,userId=" + userId + ", created SubscriberList=" + createdSubscriberList);
        }
        return createdSubscriberList;
    }

    public SubscriberList updateSubscriberList(String userId, SubscriberList subscriberList) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateSubscriberListById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateSubscriberListById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateSubscriberListById", (String)userId);
        EntityDetail entityDetail = SubscriberListMapper.mapSubscriberListToOmrsEntityDetail(subscriberList);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateSubscriberListById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        SubscriberList updatedSubscriberList = SubscriberListMapper.mapOmrsEntityDetailToSubscriberList(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateSubscriberListById,userId=" + userId + ",updated SubscriberList=" + updatedSubscriberList);
        }
        return updatedSubscriberList;
    }

    public EntityDetail deleteSubscriberListByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteSubscriberListByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteSubscriberListByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteSubscriberListByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteSubscriberListByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("SubscriberList");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "SubscriberList", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteSubscriberListByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeSubscriberListByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeSubscriberListByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeSubscriberListByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeSubscriberListByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeSubscriberListByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("SubscriberList");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "SubscriberList", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeSubscriberListByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public SubscriberList restoreSubscriberList(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreSubscriberListByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreSubscriberListByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreSubscriberListByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreSubscriberListByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        SubscriberList restoredSubscriberList = SubscriberListMapper.mapOmrsEntityDetailToSubscriberList(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreSubscriberListByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredSubscriberList;
    }

    public SubscriberList addSubscriberListClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addSubscriberListClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addSubscriberListClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addSubscriberListClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addSubscriberListClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SubscriberList subscriberListClassifications = SubscriberListMapper.mapOmrsEntityDetailToSubscriberList(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addSubscriberListClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified SubscriberList=" + subscriberListClassifications);
        }
        return subscriberListClassifications;
    }

    public SubscriberList updateSubscriberListClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateSubscriberListClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateSubscriberListClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateSubscriberListClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateSubscriberListClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateSubscriberListClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateSubscriberListClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SubscriberList subscriberListClassifications = SubscriberListMapper.mapOmrsEntityDetailToSubscriberList(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateSubscriberListClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return subscriberListClassifications;
    }

    public SubscriberList deleteSubscriberListClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteSubscriberListClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteSubscriberListClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteSubscriberListClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteSubscriberListClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        SubscriberList declassifiedSubscriberList = SubscriberListMapper.mapOmrsEntityDetailToSubscriberList(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteSubscriberListClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedSubscriberList;
    }

    public Set<Line> getSubscriberListRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getSubscriberListRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getSubscriberListRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getSubscriberListRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getSubscriberListRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getSubscriberListRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public CommunityMember getCommunityMemberById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getCommunityMemberById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCommunityMemberById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getCommunityMemberById", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getCommunityMemberById", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        CommunityMember gotcommunityMember = CommunityMemberMapper.mapOmrsEntityDetailToCommunityMember(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCommunityMemberById,userId=" + userId + ",guid=" + entityGuid + ",entity=" + gotcommunityMember);
        }
        return gotcommunityMember;
    }

    public CommunityMember createCommunityMember(String userId, CommunityMember communityMember) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, StatusNotSupportedException {
        String methodName = "createCommunityMemberById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createCommunityMemberById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createCommunityMemberById", (String)userId);
        SubjectAreaConstraint constraint = SubjectAreaConstraintsFactory.getSubjectAreaConstraint("CommunityMember");
        if (constraint != null) {
            constraint.preCreate(communityMember);
        }
        EntityDetail entityDetail = CommunityMemberMapper.mapCommunityMemberToOmrsEntityDetail(communityMember);
        EntityDetail addedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSAddEntity(userId, entityDetail);
        CommunityMember createdCommunityMember = CommunityMemberMapper.mapOmrsEntityDetailToCommunityMember(addedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createCommunityMemberById,userId=" + userId + ", created CommunityMember=" + createdCommunityMember);
        }
        return createdCommunityMember;
    }

    public CommunityMember updateCommunityMember(String userId, CommunityMember communityMember) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "updateCommunityMemberById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateCommunityMemberById,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateCommunityMemberById", (String)userId);
        EntityDetail entityDetail = CommunityMemberMapper.mapCommunityMemberToOmrsEntityDetail(communityMember);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateCommunityMemberById", (String)entityDetail.getGUID(), (String)"guid");
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSUpdateEntity(userId, entityDetail);
        CommunityMember updatedCommunityMember = CommunityMemberMapper.mapOmrsEntityDetailToCommunityMember(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method: updateCommunityMemberById,userId=" + userId + ",updated CommunityMember=" + updatedCommunityMember);
        }
        return updatedCommunityMember;
    }

    public EntityDetail deleteCommunityMemberByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "deleteCommunityMemberByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteCommunityMemberByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteCommunityMemberByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteCommunityMemberByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("CommunityMember");
        EntityDetail deletedOmrsEntityDetail = this.oMRSAPIHelper.callOMRSDeleteEntity(userId, "CommunityMember", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteCommunityMemberByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return deletedOmrsEntityDetail;
    }

    public void purgeCommunityMemberByGuid(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, EntityNotDeletedException, GUIDNotPurgedException {
        String methodName = "purgeCommunityMemberByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeCommunityMemberByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeCommunityMemberByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeCommunityMemberByGuid", (String)entityGuid, (String)"entityGuid");
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef entityDef = archiveAccessor.getEntityDefByName("CommunityMember");
        this.oMRSAPIHelper.callOMRSPurgeEntity(userId, "CommunityMember", entityDef.getGUID(), entityGuid);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: purgeCommunityMemberByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
    }

    public CommunityMember restoreCommunityMember(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotDeletedException, FunctionNotSupportedException {
        String methodName = "restoreCommunityMemberByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreCommunityMemberByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreCommunityMemberByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreCommunityMemberByGuid", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, entityGuid);
        CommunityMember restoredCommunityMember = CommunityMemberMapper.mapOmrsEntityDetailToCommunityMember(omrsEntity);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: restoreCommunityMemberByGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return restoredCommunityMember;
    }

    public CommunityMember addCommunityMemberClassifications(String userId, String entityGuid, List<Classification> classifications) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "addCommunityMemberClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: addCommunityMemberClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"addCommunityMemberClassifications", (String)userId);
        for (Classification classification : classifications) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            InputValidator.validateNameNotNull((String)className, (String)"addCommunityMemberClassifications", (String)name, (String)"classifications");
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        CommunityMember communityMemberClassifications = CommunityMemberMapper.mapOmrsEntityDetailToCommunityMember(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: addCommunityMemberClassifications,userId=" + userId + ",guid=" + entityGuid + ",classified CommunityMember=" + communityMemberClassifications);
        }
        return communityMemberClassifications;
    }

    public CommunityMember updateCommunityMemberClassification(String userId, String entityGuid, List<Classification> classificationsToUpdate) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "updateCommunityMemberClassifications";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateCommunityMemberClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateCommunityMemberClassifications", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateCommunityMemberClassifications", (String)entityGuid, (String)"entityGuid");
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        List existingClassificationNames = omrsEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toList());
        for (Classification classification : classificationsToUpdate) {
            String name = classification.getClassificationName();
            if (existingClassificationNames.contains(name)) continue;
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UPDATE_REQUESTED_ON_A_NON_EXISTENT_CLASSIFICATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "classificationsToUpdate", "updateCommunityMemberClassifications", entityGuid});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "updateCommunityMemberClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (Classification classification : classificationsToUpdate) {
            InstanceProperties instanceProperties = classification.obtainInstanceProperties();
            String name = classification.getClassificationName();
            this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
            this.oMRSAPIHelper.callOMRSClassifyEntity(userId, entityGuid, name, instanceProperties);
        }
        EntityDetail updatedOMRSEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        CommunityMember communityMemberClassifications = CommunityMemberMapper.mapOmrsEntityDetailToCommunityMember(updatedOMRSEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== Method: updateCommunityMemberClassifications,userId=" + userId + ",guid=" + entityGuid);
        }
        return communityMemberClassifications;
    }

    public CommunityMember deleteCommunityMemberClassification(String userId, String entityGuid, String name) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException {
        String methodName = "deleteCommunityMemberClassification";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteCommunityMemberClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteCommunityMemberClassification", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteCommunityMemberClassification", (String)entityGuid, (String)"entityGuid");
        this.oMRSAPIHelper.callOMRSDeClassifyEntity(userId, entityGuid, name);
        EntityDetail omrsEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, entityGuid);
        CommunityMember declassifiedCommunityMember = CommunityMemberMapper.mapOmrsEntityDetailToCommunityMember(omrsEntityDetail);
        if (log.isDebugEnabled()) {
            log.debug("<== successful Method: deleteCommunityMemberClassification,userId=" + userId + ",guid=" + entityGuid + ",name=" + name);
        }
        return declassifiedCommunityMember;
    }

    public Set<Line> getCommunityMemberRelationships(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getCommunityMemberRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCommunityMemberRelationships,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getCommunityMemberRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getCommunityMemberRelationships", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCommunityMemberRelationships,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    public GovernanceRule getGovernanceRuleById(String userId, String entityGuid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException {
        String methodName = "getGovernanceRuleById";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGovernanceRuleById,userId=" + userId + ",guid=" + entityGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGovernanceRu