/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.handlers;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class ErrorHandler {
    static String className = ErrorHandler.class.getName();

    public static void validateUserId(String userId, String methodName) throws InvalidParameterException {
        if (userId == null) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.NULL_USER_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public static void validateGUID(String guid, String parameterName, String methodName) throws InvalidParameterException {
        if (guid == null) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.NULL_GUID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public static void validateEnum(Object enumValue, String parameterName, String methodName) throws InvalidParameterException {
        if (enumValue == null) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.NULL_ENUM;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public static void validateName(String name, String parameterName, String methodName) throws InvalidParameterException {
        if (name == null) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.NULL_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public static void validateText(String text, String parameterName, String methodName) throws InvalidParameterException {
        if (text == null) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.NULL_TEXT;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public static OMRSMetadataCollection validateRepositoryConnector(String methodName, OMRSRepositoryConnector repositoryConnector) throws MetadataServerUncontactableException {
        if (repositoryConnector == null) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (!repositoryConnector.isActive()) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.OMRS_NOT_AVAILABLE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        try {
            return repositoryConnector.getMetadataCollection();
        }
        catch (Throwable error) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.OMRS_NOT_AVAILABLE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public static void handleUnauthorizedUser(String userId, String methodName, String serverName, String serviceName) throws UserNotAuthorizedException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.USER_NOT_AUTHORIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{userId, methodName, serviceName, serverName});
        throw new UserNotAuthorizedException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), userId);
    }

    public static void handleRepositoryError(Throwable error, String methodName, String serverName, String serviceName) throws MetadataServerUncontactableException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.METADATA_SERVER_UNCONTACTABLE_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{error.getMessage(), methodName, serviceName, serverName});
        throw new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public static void handleUnknownAsset(Throwable error, String assetGUID, String methodName, String serverName, String serviceName) throws UnrecognizedGUIDException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GUID_DOES_NOT_EXIST;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{assetGUID, methodName, serviceName, serverName, error.getMessage()});
        throw new UnrecognizedGUIDException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), assetGUID);
    }

    public static void handleInvalidParameterException(org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e, String methodName, String serverName, String serviceName) throws InvalidParameterException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.INVALID_PARAMETER;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public static void handleTypeDefNotKnownException(String typeName, String methodName, String serverName, String serviceName) throws InvalidParameterException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.TYPEDEF_NOT_KNOWN;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public static void handlePropertyErrorException(PropertyErrorException e, String methodName, String serverName, String serviceName) throws InvalidParameterException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.TYPEDEF_NOT_KNOWN;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public static void handleClassificationErrorException(ClassificationErrorException e, String methodName, String serverName, String serviceName) throws ClassificationException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.CLASSIFICATION_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        throw new ClassificationException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public static void handleStatusNotSupportedException(StatusNotSupportedException e, String methodName, String serverName, String serviceName) throws org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.STATUS_NOT_SUPPORTED_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        throw new org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public static void handleEntityNotKnownError(String guid, String methodName, String serverName, String serviceName) throws UnrecognizedGUIDException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.ENTITY_NOT_KNOWN_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, guid});
        throw new UnrecognizedGUIDException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), guid);
    }

    public static void handleEntityProxyOnlyException(EntityProxyOnlyException e, String methodName, String serverName, String serviceName) throws MetadataServerUncontactableException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.METADATA_SERVER_UNCONTACTABLE_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{e.getMessage(), e.getErrorMessage(), methodName, serviceName, serverName});
        throw new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public static void handleTypeErrorException(TypeErrorException e, String methodName, String serverName, String serviceName) throws InvalidParameterException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.TYPEDEF_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public static void handleFunctionNotSupportedException(org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException e, String methodName, String serverName, String serviceName) throws FunctionNotSupportedException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.FUNCTION_NOT_SUPPORTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public static void handlePagingErrorException(PagingErrorException e, String methodName, String serverName, String serviceName) throws InvalidParameterException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.PAGING_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public static void handleEntityNotDeletedException(EntityNotDeletedException e, String methodName, String serverName, String serviceName, String guid) throws GUIDNotPurgedException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GUID_NOT_PURGED_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, guid});
        throw new GUIDNotPurgedException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), guid);
    }

    public static void handleRelationshipNotKnownException(String guid, String methodName, String serverName, String serviceName) throws UnrecognizedGUIDException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GUID_DOES_NOT_EXIST;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, methodName});
        UnrecognizedGUIDException uge = new UnrecognizedGUIDException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), guid);
        throw uge;
    }

    public static void handleEntityNotKnownException(String guid, String methodName, String serverName, String serviceName) throws UnrecognizedGUIDException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GUID_DOES_NOT_EXIST;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, methodName});
        UnrecognizedGUIDException uge = new UnrecognizedGUIDException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), guid);
        throw uge;
    }

    public static void handleEntityNotDeletedException(String guid, String methodName, String serverName, String serviceName) throws GUIDNotDeletedException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GUID_NOT_DELETED_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        throw new GUIDNotDeletedException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), guid);
    }

    public static void handleRelationshipNotDeletedException(String guid, String methodName, String serverName, String serviceName) throws GUIDNotDeletedException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GUID_NOT_DELETED_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        throw new GUIDNotDeletedException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), guid);
    }

    public void handleMetadataServerUnContactable(MetadataServerUncontactableException e, String methodName, String serverName, String serviceName) throws MetadataServerUncontactableException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.METADATA_SERVER_UNCONTACTABLE_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        throw new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public void handleEntityNotPurgedException(String obsoleteGuid, String restAPIName, String serverName, String serviceName) throws GUIDNotPurgedException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GUID_NOT_PURGED_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{restAPIName});
        throw new GUIDNotPurgedException(errorCode.getHTTPErrorCode(), className, restAPIName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), obsoleteGuid);
    }

    public void handleRelationshipNotPurgedException(String obsoleteGuid, String restAPIName, String serverName, String serviceName) throws GUIDNotPurgedException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GUID_NOT_PURGED_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{restAPIName});
        throw new GUIDNotPurgedException(errorCode.getHTTPErrorCode(), className, restAPIName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), obsoleteGuid);
    }
}

