/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities;

import java.util.ArrayList;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryCategory.GlossaryCategory;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryMapper {
    private static final Logger log = LoggerFactory.getLogger(CategoryMapper.class);
    private static final String className = CategoryMapper.class.getName();

    public static GlossaryCategory mapCategoryToOMRSBean(Category category) throws InvalidParameterException {
        GlossaryCategory omrsBean = new GlossaryCategory();
        if (category.getSystemAttributes() != null) {
            omrsBean.setSystemAttributes(category.getSystemAttributes());
        }
        omrsBean.setEffectiveFromTime(category.getEffectiveFromTime());
        omrsBean.setEffectiveToTime(category.getEffectiveToTime());
        omrsBean.setQualifiedName(category.getQualifiedName());
        omrsBean.setDescription(category.getDescription());
        omrsBean.setDisplayName(category.getName());
        ArrayList classifications = category.getClassifications();
        if (classifications == null) {
            classifications = new ArrayList();
        }
        omrsBean.setClassifications(classifications);
        return omrsBean;
    }

    public static Category mapOMRSBeantoCategory(GlossaryCategory omrsBean) {
        Category category = new Category();
        category.setClassifications(omrsBean.getClassifications());
        category.setDescription(omrsBean.getDescription());
        if (omrsBean.getSystemAttributes() != null) {
            category.setSystemAttributes(omrsBean.getSystemAttributes());
        }
        category.setEffectiveFromTime(omrsBean.getEffectiveFromTime());
        category.setEffectiveToTime(omrsBean.getEffectiveToTime());
        category.setName(omrsBean.getDisplayName());
        category.setQualifiedName(omrsBean.getQualifiedName());
        return category;
    }
}

