/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities;

import java.util.ArrayList;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.CanonicalVocabulary.CanonicalVocabulary;
import org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Taxonomy.Taxonomy;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryMapper {
    private static final Logger log = LoggerFactory.getLogger(GlossaryMapper.class);
    private static final String className = GlossaryMapper.class.getName();

    public static Glossary mapGlossaryToOMRSBean(org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary glossary) throws InvalidParameterException {
        NodeType nodeType;
        Glossary omrsBean = new Glossary();
        if (glossary.getSystemAttributes() != null) {
            omrsBean.setSystemAttributes(glossary.getSystemAttributes());
        }
        omrsBean.setEffectiveFromTime(glossary.getEffectiveFromTime());
        omrsBean.setEffectiveToTime(glossary.getEffectiveToTime());
        omrsBean.setDescription(glossary.getDescription());
        omrsBean.setDisplayName(glossary.getName());
        omrsBean.setUsage(glossary.getUsage());
        omrsBean.setQualifiedName(glossary.getQualifiedName());
        omrsBean.setAdditionalProperties(glossary.getAdditionalProperties());
        ArrayList<Classification> classifications = glossary.getClassifications();
        if (classifications == null) {
            classifications = new ArrayList<Classification>();
        }
        if ((nodeType = glossary.getNodeType()) != null) {
            if (nodeType == NodeType.CanonicalGlossary) {
                CanonicalVocabulary canonicalVocabulary = new CanonicalVocabulary();
                classifications.add(canonicalVocabulary);
            } else if (nodeType == NodeType.Taxonomy) {
                Taxonomy taxonomy = new Taxonomy();
                classifications.add(taxonomy);
            } else if (nodeType == NodeType.TaxonomyAndCanonicalGlossary) {
                CanonicalVocabulary canonicalVocabulary = new CanonicalVocabulary();
                classifications.add(canonicalVocabulary);
                Taxonomy taxonomy = new Taxonomy();
                classifications.add(taxonomy);
            }
        }
        omrsBean.setClassifications(classifications);
        return omrsBean;
    }

    public static org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary mapOMRSBeantoGlossary(Glossary omrsBean) {
        org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary glossary = new org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary();
        glossary.setClassifications(omrsBean.getClassifications());
        glossary.setDescription(omrsBean.getDescription());
        if (omrsBean.getSystemAttributes() != null) {
            glossary.setSystemAttributes(omrsBean.getSystemAttributes());
        }
        glossary.setEffectiveFromTime(omrsBean.getEffectiveFromTime());
        glossary.setEffectiveToTime(omrsBean.getEffectiveToTime());
        glossary.setName(omrsBean.getDisplayName());
        glossary.setQualifiedName(omrsBean.getQualifiedName());
        glossary.setUsage(omrsBean.getUsage());
        glossary.setAdditionalProperties(omrsBean.getAdditionalProperties());
        glossary.setClassifications(omrsBean.getClassifications());
        return glossary;
    }
}

