/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Confidence.Confidence;
import org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Retention.Retention;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryTerm.GlossaryTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Confidentiality;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Criticality;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.ObjectIdentifier;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.SpineAttribute;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.SpineObject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.GovernanceActions;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeUtils;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermMapper {
    private static final Logger log = LoggerFactory.getLogger(TermMapper.class);
    private static final String className = TermMapper.class.getName();

    public static GlossaryTerm mapTermToOMRSBean(Term term) throws InvalidParameterException {
        GlossaryTerm omrsBean = new GlossaryTerm();
        if (term.getSystemAttributes() != null) {
            omrsBean.setSystemAttributes(term.getSystemAttributes());
        }
        omrsBean.setEffectiveFromTime(term.getEffectiveFromTime());
        omrsBean.setEffectiveToTime(term.getEffectiveToTime());
        omrsBean.setQualifiedName(term.getQualifiedName());
        omrsBean.setDescription(term.getDescription());
        omrsBean.setDisplayName(term.getName());
        omrsBean.setSummary(term.getSummary());
        ArrayList<Classification> classifications = term.getClassifications();
        if (classifications == null) {
            classifications = new ArrayList<Classification>();
        }
        for (Classification classification : classifications) {
            String classificationName = classification.getClassificationName();
            if (classificationName.equals(new org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Confidentiality.Confidentiality().getClassificationName())) {
                NodeUtils.foundGovernanceClassifications((String)classificationName);
                continue;
            }
            if (classificationName.equals(new Confidence().getClassificationName())) {
                NodeUtils.foundGovernanceClassifications((String)classificationName);
                continue;
            }
            if (classificationName.equals(new org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Criticality.Criticality().getClassificationName())) {
                NodeUtils.foundGovernanceClassifications((String)classificationName);
                continue;
            }
            if (!classificationName.equals(new Retention().getClassificationName())) continue;
            NodeUtils.foundGovernanceClassifications((String)classificationName);
        }
        GovernanceActions governanceActions = term.getGovernanceActions();
        if (governanceActions != null) {
            if (governanceActions.getConfidentiality() != null) {
                classifications.add((Classification)governanceActions.getConfidentiality());
            }
            if (governanceActions.getConfidence() != null) {
                classifications.add((Classification)governanceActions.getConfidence());
            }
            if (governanceActions.getCriticality() != null) {
                classifications.add((Classification)governanceActions.getCriticality());
            }
            if (governanceActions.getRetention() != null) {
                classifications.add((Classification)governanceActions.getRetention());
            }
        }
        omrsBean.setClassifications(classifications);
        return omrsBean;
    }

    public static Term mapOMRSBeantoTerm(GlossaryTerm omrsBean) {
        Term term = new Term();
        term.setClassifications(omrsBean.getClassifications());
        term.setDescription(omrsBean.getDescription());
        if (omrsBean.getSystemAttributes() != null) {
            term.setSystemAttributes(omrsBean.getSystemAttributes());
        }
        term.setEffectiveFromTime(omrsBean.getEffectiveFromTime());
        term.setEffectiveToTime(omrsBean.getEffectiveToTime());
        term.setName(omrsBean.getDisplayName());
        term.setSummary(omrsBean.getSummary());
        term.setQualifiedName(omrsBean.getQualifiedName());
        List<Classification> classifications = omrsBean.getClassifications();
        if (classifications != null) {
            GovernanceActions governanceActions = new GovernanceActions();
            for (Classification classification : classifications) {
                String classificationName = classification.getClassificationName();
                if (classificationName.equals(new org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Confidentiality.Confidentiality().getClassificationName())) {
                    governanceActions.setConfidentiality((Confidentiality)classification);
                    continue;
                }
                if (classificationName.equals(new Confidence().getClassificationName())) {
                    governanceActions.setConfidence((org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Confidence)classification);
                    continue;
                }
                if (classificationName.equals(new org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Criticality.Criticality().getClassificationName())) {
                    governanceActions.setCriticality((Criticality)classification);
                    continue;
                }
                if (classificationName.equals(new Retention().getClassificationName())) {
                    governanceActions.setRetention((org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Retention)classification);
                    continue;
                }
                if (classificationName.equals(new SpineObject().getClassificationName())) {
                    term.setSpineObject(true);
                    continue;
                }
                if (classificationName.equals(new SpineAttribute().getClassificationName())) {
                    term.setSpineAttribute(true);
                    continue;
                }
                if (!classificationName.equals(new ObjectIdentifier().getClassificationName())) continue;
                term.setObjectIdentifier(true);
            }
            term.setGovernanceActions(governanceActions);
        }
        return term;
    }
}

