/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.graph;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.LineType;
import org.odpi.openmetadata.repositoryservices.archivemanager.OMRSArchiveAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(LineTypeMapper.class);
    private static final String className = LineTypeMapper.class.getName();

    public static String mapLineTypeToRelationshipTypeGuid(LineType lineType) throws InvalidParameterException {
        String relationshipTypeName = lineType.name();
        return OMRSArchiveAccessor.getInstance().getRelationshipDefByName(relationshipTypeName).getGUID();
    }

    public static LineType mapRelationshipTypeGuidToLineType(String guid) {
        String lineTypeName = OMRSArchiveAccessor.getInstance().getRelationshipDefByGuid(guid).getName();
        LineType lineType = null;
        for (LineType lineTypeToCheck : LineType.values()) {
            if (!lineTypeToCheck.name().equals(lineTypeName)) continue;
            lineType = lineTypeToCheck;
            break;
        }
        return lineType;
    }
}

