/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermCategorization.TermCategorization;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermCategorizationRelationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermCategorizationMapper {
    private static final Logger log = LoggerFactory.getLogger(TermCategorizationMapper.class);
    private static final String className = TermCategorizationMapper.class.getName();

    public static TermCategorization mapTermCategorizationToOMRSRelationshipBean(TermCategorizationRelationship termCategorization) throws InvalidParameterException {
        TermCategorization omrsRelationshipBean = new TermCategorization((Line)termCategorization);
        omrsRelationshipBean.setEntity2Guid(termCategorization.getTermGuid());
        omrsRelationshipBean.setEntity1Guid(termCategorization.getCategoryGuid());
        omrsRelationshipBean.setDescription(termCategorization.getDescription());
        omrsRelationshipBean.setStatus(termCategorization.getStatus());
        omrsRelationshipBean.setGuid(termCategorization.getGuid());
        Map extraAttributes = omrsRelationshipBean.getExtraAttributes();
        if (extraAttributes != null) {
            String[] properties;
            for (String property : properties = TermCategorization.PROPERTY_NAMES_SET_VALUES) {
                if (!extraAttributes.containsKey(property)) continue;
                extraAttributes.remove(property);
            }
            omrsRelationshipBean.setExtraAttributes(extraAttributes);
        }
        return omrsRelationshipBean;
    }

    public static TermCategorizationRelationship mapOMRSRelationshipBeanToTermCategorization(TermCategorization omrsRelationshipBean) {
        TermCategorizationRelationship termCategorization = new TermCategorizationRelationship((Line)omrsRelationshipBean);
        termCategorization.setDescription(omrsRelationshipBean.getDescription());
        termCategorization.setStatus(omrsRelationshipBean.getStatus());
        termCategorization.setGuid(omrsRelationshipBean.getGuid());
        termCategorization.setTermGuid(omrsRelationshipBean.getEntity2Guid());
        termCategorization.setCategoryGuid(omrsRelationshipBean.getEntity1Guid());
        String[] properties = TermCategorization.PROPERTY_NAMES_SET_VALUES;
        HashMap extraAttributes = termCategorization.getExtraAttributes();
        if (properties != null && properties.length > 0) {
            if (extraAttributes == null) {
                extraAttributes = new HashMap();
            }
            for (String property : properties) {
                if (!extraAttributes.containsKey(property)) continue;
                extraAttributes.remove(property);
            }
            termCategorization.setExtraAttributes(extraAttributes);
        }
        return termCategorization;
    }
}

