/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.SubjectArea.SubjectArea;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryCategory.GlossaryCategory;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryCategory.GlossaryCategoryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CategoryAnchor.CategoryAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CategoryHierarchyLink.CategoryHierarchyLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.server.SubjectAreaBeansToAccessOMRS;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.SubjectAreaDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.IconSummary;
import org.odpi.openmetadata.accessservices.subjectarea.responses.CategoriesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.CategoryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaDefinitionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.CategoryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaGlossaryRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.TypeGuids;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.accessservices.subjectarea.validators.RestValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaCategoryRESTServices
extends SubjectAreaRESTServicesInstance {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaCategoryRESTServices.class);
    private static final String className = SubjectAreaCategoryRESTServices.class.getName();

    public SubjectAreaCategoryRESTServices() {
    }

    public SubjectAreaCategoryRESTServices(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
    }

    public SubjectAreaOMASAPIResponse createCategory(String serverName, String userId, Category suppliedCategory) {
        String methodName = "createCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createCategory,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        String categoryGuid = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, suppliedCategory.getEffectiveFromTime(), suppliedCategory.getEffectiveToTime(), "createCategory");
            InputValidator.validateNodeType((Object[])new Object[]{className, "createCategory", suppliedCategory.getNodeType(), NodeType.Category, NodeType.SubjectAreaDefinition});
            SubjectAreaGlossaryRESTServices glossaryRESTServices = new SubjectAreaGlossaryRESTServices();
            glossaryRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
            GlossaryCategory glossaryCategory = null;
            Glossary associatedGlossary = null;
            String suppliedCategoryParentGuid = null;
            if (suppliedCategory.getParentCategory() != null) {
                suppliedCategoryParentGuid = suppliedCategory.getParentCategory().getGuid();
            }
            glossaryCategory = CategoryMapper.mapCategoryToOMRSBean(suppliedCategory);
            String suppliedCategoryName = suppliedCategory.getName();
            if (suppliedCategoryName == null || suppliedCategoryName.equals("")) {
                SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GLOSSARY_CATEGORY_CREATE_WITHOUT_NAME;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "createCategory"});
                log.error(errorMessage);
                throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "createCategory", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            GlossarySummary suppliedGlossary = suppliedCategory.getGlossary();
            SubjectAreaOMASAPIResponse glossaryResponse = RestValidator.validateGlossarySummaryDuringCreation(serverName, userId, "createCategory", suppliedGlossary, glossaryRESTServices);
            if (glossaryResponse.getResponseCategory().equals((Object)ResponseCategory.Glossary)) {
                associatedGlossary = ((GlossaryResponse)glossaryResponse).getGlossary();
                GlossaryCategory newGlossaryCategory = subjectAreaOmasREST.createGlossaryCategory(userId, glossaryCategory);
                categoryGuid = newGlossaryCategory.getSystemAttributes().getGUID();
                String glossaryGuid = associatedGlossary.getSystemAttributes().getGUID();
                CategoryAnchor categoryAnchor = new CategoryAnchor();
                categoryAnchor.setEntity1Guid(glossaryGuid);
                categoryAnchor.setEntity2Guid(categoryGuid);
                subjectAreaOmasREST.createCategoryAnchorRelationship(userId, categoryAnchor);
                if (suppliedCategoryParentGuid != null) {
                    CategoryHierarchyLink categoryHierarchyLink = new CategoryHierarchyLink();
                    categoryHierarchyLink.setEntity1Guid(suppliedCategoryParentGuid);
                    categoryHierarchyLink.setEntity2Guid(categoryGuid);
                    subjectAreaOmasREST.createCategoryHierarchyLinkRelationship(userId, categoryHierarchyLink);
                }
                if (suppliedCategory.getNodeType() == NodeType.SubjectAreaDefinition) {
                    ArrayList<Classification> classifications = new ArrayList<Classification>();
                    classifications.add(new SubjectArea());
                    subjectAreaOmasREST.addGlossaryCategoryClassifications(userId, categoryGuid, classifications);
                }
            } else {
                response = glossaryResponse;
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (ClassificationException e) {
            response = OMASExceptionToResponse.convertClassificationException((ClassificationException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotsupportedException((StatusNotSupportedException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (response == null) {
            response = this.getCategory(serverName, userId, categoryGuid);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createCategory,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getCategory(String serverName, String userId, String guid) {
        String methodName = "getCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCategory,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        GlossaryCategory glossaryCategory = null;
        try {
            CategorySummary parentCategory;
            String categoryHierarchyLinkTypeGuid;
            Set<Line> categoryParentRelationships;
            Line glossaryRelationship;
            String anchorTypeGuid;
            Set<Line> glossaryRelationships;
            String mediaReferenceTypeGuid;
            Set<Line> mediaReferenceRelationships;
            Set<IconSummary> icons;
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getCategory");
            InputValidator.validateGUIDNotNull((String)className, (String)"getCategory", (String)guid, (String)"guid");
            NodeType nodeType = NodeType.Category;
            glossaryCategory = subjectAreaOmasREST.getGlossaryCategoryById(userId, guid);
            Category gotCategory = CategoryMapper.mapOMRSBeantoCategory(glossaryCategory);
            ArrayList<Classification> classifications = new ArrayList<Classification>();
            if (glossaryCategory.getClassifications() != null) {
                for (Classification classification : glossaryCategory.getClassifications()) {
                    if (classification.getClassificationName().equals("SubjectArea")) {
                        nodeType = NodeType.SubjectAreaDefinition;
                        continue;
                    }
                    classifications.add(classification);
                }
                if (classifications.size() > 0) {
                    gotCategory.setClassifications(classifications);
                } else {
                    gotCategory.setClassifications(null);
                }
            }
            if ((icons = SubjectAreaUtils.getIconSummarySet(userId, subjectAreaOmasREST, mediaReferenceRelationships = subjectAreaOmasREST.getGlossaryCategoryRelationships(userId, guid, mediaReferenceTypeGuid = TypeGuids.getMediaReferenceTypeGuid(), 0, null, null, null, 0))) != null) {
                gotCategory.setIcons(icons);
            }
            if ((glossaryRelationships = subjectAreaOmasREST.getGlossaryRelationships(userId, guid, anchorTypeGuid = TypeGuids.getCategoryAnchorTypeGuid(), 0, null, null, null, 0)).iterator().hasNext() && SubjectAreaUtils.isEffective(glossaryRelationship = glossaryRelationships.iterator().next())) {
                GlossarySummary glossarySummary = SubjectAreaUtils.getGlossarySummaryForCategory(userId, subjectAreaOmasREST, glossaryRelationship);
                gotCategory.setGlossary(glossarySummary);
            }
            if ((categoryParentRelationships = subjectAreaOmasREST.getGlossaryRelationships(userId, guid, categoryHierarchyLinkTypeGuid = TypeGuids.getCategoryHierarchyLinkTypeGuid(), 0, null, null, null, 0)) != null && categoryParentRelationships.size() > 0 && (parentCategory = SubjectAreaUtils.getParentCategorySummary(userId, subjectAreaOmasREST, categoryParentRelationships)) != null) {
                gotCategory.setParentCategory(parentCategory);
            }
            if (nodeType == NodeType.Category) {
                response = new CategoryResponse(gotCategory);
            } else {
                SubjectAreaDefinition subjectAreaDefinition = new SubjectAreaDefinition(gotCategory);
                response = new SubjectAreaDefinitionResponse(subjectAreaDefinition);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException functionNotSupportedException) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCategory,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse findCategory(String serverName, String userId, String searchCriteria, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: findCategory,userId=" + userId);
        }
        ArrayList<Category> categories = null;
        SubjectAreaOMASAPIResponse response = null;
        try {
            this.initializeAPI(serverName, userId, "findCategory");
            List<EntityDetail> entitydetails = OMRSAPIHelper.findEntitiesByType(this.oMRSAPIHelper, serverName, userId, "GlossaryCategory", searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty, "findCategory");
            if (entitydetails != null) {
                categories = new ArrayList<Category>();
                for (EntityDetail entityDetail : entitydetails) {
                    GlossaryCategory glossaryCategory = GlossaryCategoryMapper.mapOmrsEntityDetailToGlossaryCategory(entityDetail);
                    Category category = CategoryMapper.mapOMRSBeantoCategory(glossaryCategory);
                    categories.add(category);
                }
            }
            response = new CategoriesResponse(categories);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : findCategory,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getCategoryRelationships(String serverName, String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getCategoryRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCategoryRelationships,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getCategoryRelationships");
            InputValidator.validateGUIDNotNull((String)className, (String)"getCategoryRelationships", (String)guid, (String)"guid");
            subjectAreaOmasREST.getGlossaryCategoryById(userId, guid);
            response = this.getRelationshipsFromGuid(serverName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
        }
        catch (MetadataServerUncontactableException e) {
            OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UserNotAuthorizedException e) {
            OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCategoryRelationships,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateCategory(String serverName, String userId, String guid, Category suppliedCategory, boolean isReplace) {
        String methodName = "updateCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateCategory,userId=" + userId);
        }
        Object response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, suppliedCategory.getEffectiveFromTime(), suppliedCategory.getEffectiveToTime(), "updateCategory");
            InputValidator.validateUserIdNotNull((String)className, (String)"updateCategory", (String)userId);
            InputValidator.validateNodeType((Object[])new Object[]{className, "updateCategory", suppliedCategory.getNodeType(), NodeType.Category, NodeType.SubjectAreaDefinition});
            InputValidator.validateGUIDNotNull((String)className, (String)"updateCategory", (String)guid, (String)"guid");
            response = this.getCategory(serverName, userId, guid);
            if (response.getResponseCategory().equals((Object)ResponseCategory.Category)) {
                Status status;
                Category originalCategory = ((CategoryResponse)response).getCategory();
                if (originalCategory.getSystemAttributes() != null) {
                    status = originalCategory.getSystemAttributes().getStatus();
                    SubjectAreaUtils.checkStatusNotDeleted(status, SubjectAreaErrorCode.GLOSSARY_UPDATE_FAILED_ON_DELETED_GLOSSARY);
                }
                if (suppliedCategory.getSystemAttributes() != null) {
                    status = suppliedCategory.getSystemAttributes().getStatus();
                    SubjectAreaUtils.checkStatusNotDeleted(status, SubjectAreaErrorCode.STATUS_UPDATE_TO_DELETED_NOT_ALLOWED);
                }
                Category updateCategory = originalCategory;
                if (isReplace) {
                    updateCategory.setName(suppliedCategory.getName());
                    updateCategory.setQualifiedName(suppliedCategory.getQualifiedName());
                    updateCategory.setDescription(suppliedCategory.getDescription());
                    updateCategory.setAdditionalProperties(suppliedCategory.getAdditionalProperties());
                } else {
                    if (suppliedCategory.getName() != null) {
                        updateCategory.setName(suppliedCategory.getName());
                    }
                    if (suppliedCategory.getQualifiedName() != null) {
                        updateCategory.setQualifiedName(suppliedCategory.getQualifiedName());
                    }
                    if (suppliedCategory.getDescription() != null) {
                        updateCategory.setDescription(suppliedCategory.getDescription());
                    }
                    if (suppliedCategory.getAdditionalProperties() != null) {
                        updateCategory.setAdditionalProperties(suppliedCategory.getAdditionalProperties());
                    }
                }
                GlossaryCategory generatedCategory = null;
                generatedCategory = CategoryMapper.mapCategoryToOMRSBean(updateCategory);
                GlossaryCategory updatedGeneratedCategory = null;
                updatedGeneratedCategory = subjectAreaOmasREST.updateGlossaryCategory(userId, generatedCategory);
                Category updatedCategory = CategoryMapper.mapOMRSBeantoCategory(updatedGeneratedCategory);
                response = suppliedCategory.getNodeType() == NodeType.SubjectAreaDefinition ? new SubjectAreaDefinitionResponse(new SubjectAreaDefinition(updatedCategory)) : new CategoryResponse(updatedCategory);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateCategory,userId=" + userId + ",response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteCategory(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteCategory,userId=" + userId + ", guid=" + guid);
        }
        Object response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "deleteCategory");
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteCategory", (String)guid, (String)"guid");
            if (isPurge.booleanValue()) {
                subjectAreaOmasREST.purgeGlossaryCategoryByGuid(userId, guid);
                response = new VoidResponse();
            } else {
                GlossaryCategory deletedGeneratedCategory = null;
                EntityDetail entityDetail = subjectAreaOmasREST.deleteGlossaryCategoryByGuid(userId, guid);
                deletedGeneratedCategory = GlossaryCategoryMapper.mapOmrsEntityDetailToGlossaryCategory(entityDetail);
                NodeType nodeType = NodeType.Category;
                if (deletedGeneratedCategory.getClassifications() != null) {
                    ArrayList<Classification> classifications = new ArrayList<Classification>();
                    for (Classification classification : deletedGeneratedCategory.getClassifications()) {
                        if (classification.getClassificationName().equals("SubjectArea")) {
                            nodeType = NodeType.SubjectAreaDefinition;
                            continue;
                        }
                        classifications.add(classification);
                    }
                    if (classifications.size() > 0) {
                        deletedGeneratedCategory.setClassifications(classifications);
                    } else {
                        deletedGeneratedCategory.setClassifications(null);
                    }
                }
                Category deletedCategory = CategoryMapper.mapOMRSBeantoCategory(deletedGeneratedCategory);
                response = nodeType == NodeType.SubjectAreaDefinition ? new SubjectAreaDefinitionResponse(new SubjectAreaDefinition(deletedCategory)) : new CategoryResponse(deletedCategory);
            }
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (EntityNotDeletedException e) {
            response = OMASExceptionToResponse.convertEntityNotDeletedException((EntityNotDeletedException)e);
        }
        catch (GUIDNotPurgedException e) {
            response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteCategory,userId=" + userId);
        }
        return response;
    }

    public void checkSiblingCategoryNames(String userId, String methodName, String suppliedCategoryName, String suppliedCategoryParentGuid, SubjectAreaErrorCode errorCode) throws UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, FunctionNotSupportedException, MetadataServerUncontactableException {
        List<Relationship> omrsRelationships = null;
        if (suppliedCategoryParentGuid != null && (omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, suppliedCategoryParentGuid, "71e4b6fb-3412-4193-aff3-a16eccd87e8e", 0, null, null, null, null, 0)) != null) {
            for (Relationship omrsRelationship : omrsRelationships) {
                String siblingCategoryName;
                EntityDetail siblingEntityDetail;
                InstanceProperties siblingProperties;
                PrimitivePropertyValue primitivePropertyValue;
                CategoryHierarchyLink link;
                if (!omrsRelationship.getType().getTypeDefName().equals("CategoryHierarchyLink") || !(link = new CategoryHierarchyLink(omrsRelationship)).getEntity1Guid().equals(suppliedCategoryParentGuid) || (primitivePropertyValue = (PrimitivePropertyValue)(siblingProperties = (siblingEntityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, link.getEntity2Guid())).getProperties()).getPropertyValue("displayName")) == null || !(siblingCategoryName = (String)primitivePropertyValue.getPrimitiveValue()).equals(suppliedCategoryName)) continue;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName, suppliedCategoryName});
                log.error(errorMessage);
                throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        }
    }

    public SubjectAreaOMASAPIResponse restoreCategory(String serverName, String userId, String guid) {
        String methodName = "restoreCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreCategory,userId=" + userId + ",guid=" + guid);
        }
        Object response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "restoreCategory");
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreCategory", (String)guid, (String)"guid");
            EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, guid);
            GlossaryCategory restoredGeneratedCategory = GlossaryCategoryMapper.mapOmrsEntityDetailToGlossaryCategory(omrsEntity);
            NodeType nodeType = NodeType.Category;
            if (restoredGeneratedCategory.getClassifications() != null) {
                ArrayList<Classification> classifications = new ArrayList<Classification>();
                for (Classification classification : restoredGeneratedCategory.getClassifications()) {
                    if (classification.getClassificationName().equals("SubjectArea")) {
                        nodeType = NodeType.SubjectAreaDefinition;
                        continue;
                    }
                    classifications.add(classification);
                }
                if (classifications.size() > 0) {
                    restoredGeneratedCategory.setClassifications(classifications);
                } else {
                    restoredGeneratedCategory.setClassifications(null);
                }
            }
            Category deletedCategory = CategoryMapper.mapOMRSBeantoCategory(restoredGeneratedCategory);
            response = nodeType == NodeType.SubjectAreaDefinition ? new SubjectAreaDefinitionResponse(new SubjectAreaDefinition(deletedCategory)) : new CategoryResponse(deletedCategory);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotDeletedException e) {
            response = OMASExceptionToResponse.convertGUIDNotDeletedException((GUIDNotDeletedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreCategory,userId=" + userId + ", response=" + response);
        }
        return response;
    }
}

