/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.CanonicalVocabulary.CanonicalVocabulary;
import org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Taxonomy.Taxonomy;
import org.odpi.openmetadata.accessservices.subjectarea.generated.server.SubjectAreaBeansToAccessOMRS;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.IconSummary;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossariesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.InvalidParameterExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.GlossaryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.TypeGuids;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaGlossaryRESTServices
extends SubjectAreaRESTServicesInstance {
    public static final String GLOSSARY_TYPE_GUID = "36f66863-9726-4b41-97ee-714fd0dc6fe4";
    public static final String TERM_ANCHOR_RELATIONSHIP_GUID = "1d43d661-bdc7-4a91-a996-3239b8f82e56";
    public static final String CATEGORY_ANCHOR_RELATIONSHIP_GUID = "c628938e-815e-47db-8d1c-59bb2e84e028";
    public static final String CATEGORY_HIERARCHY_LINK_GUID = "71e4b6fb-3412-4193-aff3-a16eccd87e8e";
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaGlossaryRESTServices.class);
    private static final String className = SubjectAreaGlossaryRESTServices.class.getName();

    public SubjectAreaGlossaryRESTServices() {
    }

    public SubjectAreaGlossaryRESTServices(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
    }

    public SubjectAreaOMASAPIResponse createGlossary(String serverName, String userId, Glossary suppliedGlossary) {
        String methodName = "createGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createGlossary,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            ArrayList<Classification> classifications;
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, suppliedGlossary.getEffectiveFromTime(), suppliedGlossary.getEffectiveToTime(), "createGlossary");
            SubjectAreaGlossaryRESTServices glossaryRESTServices = new SubjectAreaGlossaryRESTServices();
            glossaryRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
            org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary generatedGlossary = null;
            InputValidator.validateNodeType((Object[])new Object[]{className, "createGlossary", suppliedGlossary.getNodeType(), NodeType.Glossary, NodeType.Taxonomy, NodeType.TaxonomyAndCanonicalGlossary, NodeType.CanonicalGlossary});
            String suppliedGlossaryName = suppliedGlossary.getName();
            generatedGlossary = GlossaryMapper.mapGlossaryToOMRSBean(suppliedGlossary);
            if (suppliedGlossaryName == null || suppliedGlossaryName.equals("")) {
                SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GLOSSARY_CREATE_WITHOUT_NAME;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "createGlossary"});
                log.error(errorMessage);
                throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "createGlossary", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary newGeneratedGlossary = subjectAreaOmasREST.createGlossary(userId, generatedGlossary);
            Glossary newGlossary = GlossaryMapper.mapOMRSBeantoGlossary(newGeneratedGlossary);
            String glossaryGuid = newGlossary.getSystemAttributes().getGUID();
            if (suppliedGlossary.getNodeType() == NodeType.Taxonomy || suppliedGlossary.getNodeType() == NodeType.TaxonomyAndCanonicalGlossary) {
                classifications = new ArrayList<Classification>();
                classifications.add(new Taxonomy());
                subjectAreaOmasREST.addGlossaryCategoryClassifications(userId, glossaryGuid, classifications);
            }
            if (suppliedGlossary.getNodeType() == NodeType.CanonicalGlossary || suppliedGlossary.getNodeType() == NodeType.TaxonomyAndCanonicalGlossary) {
                classifications = new ArrayList();
                classifications.add(new CanonicalVocabulary());
                subjectAreaOmasREST.addGlossaryCategoryClassifications(userId, glossaryGuid, classifications);
            }
            if (suppliedGlossary.getNodeType() == NodeType.CanonicalGlossary) {
                newGlossary.setNodeType(NodeType.CanonicalGlossary);
            } else if (suppliedGlossary.getNodeType() == NodeType.Taxonomy) {
                newGlossary.setNodeType(NodeType.Taxonomy);
            } else if (suppliedGlossary.getNodeType() == NodeType.TaxonomyAndCanonicalGlossary) {
                newGlossary.setNodeType(NodeType.TaxonomyAndCanonicalGlossary);
            }
            response = new GlossaryResponse(newGlossary);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (ClassificationException e) {
            response = OMASExceptionToResponse.convertClassificationException((ClassificationException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotsupportedException((StatusNotSupportedException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createGlossary,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getGlossaryByGuid(String serverName, String userId, String guid) {
        String methodName = "getGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGlossary,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getGlossary");
            InputValidator.validateGUIDNotNull((String)className, (String)"getGlossary", (String)guid, (String)"guid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary generatedGlossary = subjectAreaOmasREST.getGlossaryById(userId, guid);
            Glossary gotGlossary = GlossaryMapper.mapOMRSBeantoGlossary(generatedGlossary);
            List<Classification> classifications = generatedGlossary.getClassifications();
            gotGlossary.setClassifications(classifications);
            String mediaReferenceTypeGuid = TypeGuids.getMediaReferenceTypeGuid();
            Set<Line> glossaryRelationships = subjectAreaOmasREST.getGlossaryRelationships(userId, guid, mediaReferenceTypeGuid, 0, null, null, null, 0);
            Set<IconSummary> icons = SubjectAreaUtils.getIconSummarySet(userId, subjectAreaOmasREST, glossaryRelationships);
            if (icons != null) {
                gotGlossary.setIcons(icons);
            }
            response = new GlossaryResponse(gotGlossary);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGlossary,userId=" + userId);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse findGlossary(String serverName, String userId, String searchCriteria, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: findGlossary,userId=" + userId);
        }
        ArrayList<Glossary> glossaries = null;
        SubjectAreaOMASAPIResponse response = null;
        try {
            this.initializeAPI(serverName, userId, "findGlossary");
            List<EntityDetail> entitydetails = OMRSAPIHelper.findEntitiesByType(this.oMRSAPIHelper, serverName, userId, "Glossary", searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty, "findGlossary");
            if (entitydetails != null) {
                glossaries = new ArrayList<Glossary>();
                for (EntityDetail entityDetail : entitydetails) {
                    org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary generatedGlossary = org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.GlossaryMapper.mapOmrsEntityDetailToGlossary(entityDetail);
                    Glossary glossary = GlossaryMapper.mapOMRSBeantoGlossary(generatedGlossary);
                    glossaries.add(glossary);
                }
            }
            response = new GlossariesResponse(glossaries);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : findGlossary,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getGlossaryRelationships(String serverName, String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getGlossaryRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGlossaryRelationships,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getGlossaryRelationships");
            InputValidator.validateGUIDNotNull((String)className, (String)"getGlossaryRelationships", (String)guid, (String)"guid");
            subjectAreaOmasREST.getGlossaryById(userId, guid);
            response = this.getRelationshipsFromGuid(serverName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
        }
        catch (MetadataServerUncontactableException e) {
            OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UserNotAuthorizedException e) {
            OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGlossaryRelationships,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateGlossary(String serverName, String userId, String guid, Glossary suppliedGlossary, boolean isReplace) {
        String methodName = "updateGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGlossary,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "updateGlossary");
            InputValidator.validateNodeType((Object[])new Object[]{className, "updateGlossary", suppliedGlossary.getNodeType(), NodeType.Glossary, NodeType.Taxonomy, NodeType.TaxonomyAndCanonicalGlossary, NodeType.CanonicalGlossary});
            InputValidator.validateGUIDNotNull((String)className, (String)"updateGlossary", (String)guid, (String)"guid");
            response = this.getGlossaryByGuid(serverName, userId, guid);
            if (response.getResponseCategory().equals((Object)ResponseCategory.Glossary)) {
                Status status;
                Glossary originalGlossary = ((GlossaryResponse)response).getGlossary();
                if (originalGlossary.getSystemAttributes() != null) {
                    status = originalGlossary.getSystemAttributes().getStatus();
                    SubjectAreaUtils.checkStatusNotDeleted(status, SubjectAreaErrorCode.GLOSSARY_UPDATE_FAILED_ON_DELETED_GLOSSARY);
                }
                if (suppliedGlossary.getSystemAttributes() != null) {
                    status = suppliedGlossary.getSystemAttributes().getStatus();
                    SubjectAreaUtils.checkStatusNotDeleted(status, SubjectAreaErrorCode.STATUS_UPDATE_TO_DELETED_NOT_ALLOWED);
                }
                Glossary updateGlossary = originalGlossary;
                if (isReplace) {
                    updateGlossary.setName(suppliedGlossary.getName());
                    updateGlossary.setQualifiedName(suppliedGlossary.getQualifiedName());
                    updateGlossary.setDescription(suppliedGlossary.getDescription());
                    updateGlossary.setUsage(suppliedGlossary.getUsage());
                    updateGlossary.setAdditionalProperties(suppliedGlossary.getAdditionalProperties());
                } else {
                    if (suppliedGlossary.getName() != null) {
                        updateGlossary.setName(suppliedGlossary.getName());
                    }
                    if (suppliedGlossary.getQualifiedName() != null) {
                        updateGlossary.setQualifiedName(suppliedGlossary.getQualifiedName());
                    }
                    if (suppliedGlossary.getDescription() != null) {
                        updateGlossary.setDescription(suppliedGlossary.getDescription());
                    }
                    if (suppliedGlossary.getUsage() != null) {
                        updateGlossary.setUsage(suppliedGlossary.getUsage());
                    }
                    if (suppliedGlossary.getAdditionalProperties() != null) {
                        updateGlossary.setAdditionalProperties(suppliedGlossary.getAdditionalProperties());
                    }
                }
                org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary generatedGlossary = null;
                generatedGlossary = GlossaryMapper.mapGlossaryToOMRSBean(updateGlossary);
                org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary updatedGeneratedGlossary = null;
                updatedGeneratedGlossary = subjectAreaOmasREST.updateGlossary(userId, generatedGlossary);
                Glossary updatedGlossary = GlossaryMapper.mapOMRSBeantoGlossary(updatedGeneratedGlossary);
                response = new GlossaryResponse(updatedGlossary);
            }
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateGlossary,userId=" + userId + ",response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteGlossary(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGlossary,userId=" + userId + ", guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "deleteGlossary");
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteGlossary", (String)guid, (String)"guid");
            ArrayList<InstanceStatus> statusList = new ArrayList<InstanceStatus>();
            statusList.add(InstanceStatus.ACTIVE);
            if (isPurge.booleanValue()) {
                subjectAreaOmasREST.purgeGlossaryByGuid(userId, guid);
                response = new VoidResponse();
            } else {
                List<Relationship> terms = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, guid, TERM_ANCHOR_RELATIONSHIP_GUID, 0, statusList, null, null, null, 1);
                List<Relationship> categories = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, guid, CATEGORY_ANCHOR_RELATIONSHIP_GUID, 0, statusList, null, null, null, 1);
                if ((terms == null || terms.isEmpty()) && (categories == null || categories.isEmpty())) {
                    org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary deletedGeneratedGlossary = null;
                    EntityDetail entityDetail = subjectAreaOmasREST.deleteGlossaryByGuid(userId, guid);
                    deletedGeneratedGlossary = org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.GlossaryMapper.mapOmrsEntityDetailToGlossary(entityDetail);
                    Glossary deletedGlossary = GlossaryMapper.mapOMRSBeantoGlossary(deletedGeneratedGlossary);
                    response = new GlossaryResponse(deletedGlossary);
                } else {
                    SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GLOSSARY_CONTENT_PREVENTED_DELETE;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "deleteGlossary", guid});
                    log.error(errorMessage);
                    InvalidParameterException e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "deleteGlossary", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                    response = new InvalidParameterExceptionResponse((SubjectAreaCheckedExceptionBase)e);
                }
            }
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (GUIDNotPurgedException e) {
            response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
        }
        catch (EntityNotDeletedException e) {
            response = OMASExceptionToResponse.convertEntityNotDeletedException((EntityNotDeletedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteGlossary,userId=" + userId);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreGlossary(String serverName, String userId, String guid) {
        String methodName = "restoreGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreGlossary,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "restoreGlossary");
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreGlossary", (String)guid, (String)"guid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary restoredGeneratedGlossary = null;
            EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, guid);
            restoredGeneratedGlossary = org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.GlossaryMapper.mapOmrsEntityDetailToGlossary(omrsEntity);
            Glossary restoredGlossary = GlossaryMapper.mapOMRSBeantoGlossary(restoredGeneratedGlossary);
            response = new GlossaryResponse(restoredGlossary);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotDeletedException e) {
            response = OMASExceptionToResponse.convertGUIDNotDeletedException((GUIDNotDeletedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreGlossary,userId=" + userId + ", response=" + response);
        }
        return response;
    }
}

