/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.StatusFilter;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Graph;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.LineType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GraphResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.graph.LineTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.graph.NodeTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaGraphRESTServices
extends SubjectAreaRESTServicesInstance {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaGraphRESTServices.class);
    private static final String className = SubjectAreaGraphRESTServices.class.getName();

    public SubjectAreaGraphRESTServices() {
    }

    public SubjectAreaGraphRESTServices(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
    }

    public SubjectAreaOMASAPIResponse getGraph(String serverName, String userId, String guid, Date asOfTime, String nodeFilterStr, String lineFilterStr, StatusFilter statusFilter, Integer level) {
        String methodName = "getGraph";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGraph,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            Object tokenizer;
            this.initializeAPI(serverName, userId, "getGraph");
            HashSet<String> entityTypeGUIDs = new HashSet<String>();
            HashSet<Object> nodeFilter = new HashSet<Object>();
            HashSet<Object> lineFilter = new HashSet<Object>();
            if (nodeFilterStr == null) {
                nodeFilter = new HashSet();
                for (NodeType nodeType : NodeType.values()) {
                    if (nodeType == NodeType.Unknown) continue;
                    nodeFilter.add(nodeType);
                }
            } else if (nodeFilterStr.contains(",")) {
                tokenizer = new StringTokenizer(nodeFilterStr, ",");
                while (((StringTokenizer)tokenizer).hasMoreElements()) {
                    String string = (String)((StringTokenizer)tokenizer).nextElement();
                    NodeType[] nodeTypeArray = NodeType.values();
                    int n = nodeTypeArray.length;
                    for (int i = 0; i < n; ++i) {
                        NodeType nodeType2 = nodeTypeArray[i];
                        if (!nodeType2.name().equals(string)) continue;
                        nodeFilter.add(nodeType2);
                    }
                }
            } else {
                for (NodeType nodeType : NodeType.values()) {
                    if (!nodeType.name().equals(nodeFilterStr)) continue;
                    nodeFilter.add(nodeType);
                }
            }
            for (NodeType nodeType : nodeFilter) {
                String entityTypeGUID = NodeTypeMapper.mapNodeTypeToEntityTypeGuid(nodeType);
                entityTypeGUIDs.add(entityTypeGUID);
            }
            if (lineFilterStr == null) {
                for (LineType lineType : LineType.values()) {
                    if (lineType == LineType.Unknown) continue;
                    lineFilter.add(lineType);
                }
            } else if (lineFilterStr.contains(",")) {
                tokenizer = new StringTokenizer(lineFilterStr, ",");
                while (((StringTokenizer)tokenizer).hasMoreElements()) {
                    String string = (String)((StringTokenizer)tokenizer).nextElement();
                    for (LineType lineType : LineType.values()) {
                        if (!lineType.name().equals(string)) continue;
                        lineFilter.add(lineType);
                    }
                }
            } else {
                for (LineType lineType : LineType.values()) {
                    if (!lineType.name().equals(lineFilterStr)) continue;
                    lineFilter.add(lineType);
                }
            }
            OMRSRepositoryHelper oMRSRepositoryHelper = this.oMRSAPIHelper.getOMRSRepositoryHelper();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (LineType lineType : lineFilter) {
                String relationshipTypeGUID = LineTypeMapper.mapLineTypeToRelationshipTypeGuid(lineType);
                arrayList.add(relationshipTypeGUID);
            }
            ArrayList<String> entityTypeGUIDList = null;
            if (!entityTypeGUIDs.isEmpty()) {
                entityTypeGUIDList = new ArrayList<String>(entityTypeGUIDs);
            }
            Object var17_41 = null;
            ArrayList<InstanceStatus> arrayList2 = new ArrayList<InstanceStatus>();
            if (statusFilter == null || statusFilter == StatusFilter.ACTIVE) {
                arrayList2.add(SubjectAreaUtils.convertStatusToInstanceStatus(Status.ACTIVE));
            } else {
                for (Status omasStatus : Status.values()) {
                    arrayList2.add(SubjectAreaUtils.convertStatusToInstanceStatus(omasStatus));
                }
            }
            if (level == null) {
                level = 3;
            }
            InstanceGraph instanceGraph = this.oMRSAPIHelper.callGetEntityNeighbourhood(userId, guid, entityTypeGUIDList, arrayList, arrayList2, null, asOfTime, level);
            Graph graph = new Graph();
            HashSet<Node> nodes = null;
            HashSet<Line> lines = null;
            List entities = instanceGraph.getEntities();
            List relationships = instanceGraph.getRelationships();
            if (entities != null && !entities.isEmpty()) {
                nodes = new HashSet<Node>();
                for (EntityDetail entity : entities) {
                    String typeDefName;
                    Node node = new Node();
                    InstanceStatus instanceStatus = entity.getStatus();
                    Status omas_status = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
                    SystemAttributes systemAttributes = new SystemAttributes();
                    systemAttributes.setCreatedBy(entity.getCreatedBy());
                    systemAttributes.setStatus(omas_status);
                    systemAttributes.setCreatedBy(entity.getCreatedBy());
                    systemAttributes.setUpdatedBy(entity.getUpdatedBy());
                    systemAttributes.setCreateTime(entity.getCreateTime());
                    systemAttributes.setUpdateTime(entity.getUpdateTime());
                    systemAttributes.setVersion(Long.valueOf(entity.getVersion()));
                    systemAttributes.setGUID(entity.getGUID());
                    node.setSystemAttributes(systemAttributes);
                    InstanceProperties entityProperties = entity.getProperties();
                    if (entityProperties != null) {
                        String name;
                        InstancePropertyValue value;
                        node.setEffectiveFromTime(entity.getProperties().getEffectiveFromTime());
                        node.setEffectiveToTime(entity.getProperties().getEffectiveToTime());
                        Iterator omrsPropertyIterator = entityProperties.getPropertyNames();
                        if (omrsPropertyIterator.hasNext() && (value = entityProperties.getPropertyValue(name = (String)omrsPropertyIterator.next())).getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE) {
                            PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                            Object actualValue = primitivePropertyValue.getPrimitiveValue();
                            if (name.equals("displayName")) {
                                node.setName((String)actualValue);
                            }
                            if (name.equals("description")) {
                                node.setDescription((String)actualValue);
                            }
                            if (name.equals("qualifiedName")) {
                                node.setQualifiedName((String)actualValue);
                            }
                        }
                    }
                    String nodeType = typeDefName = entity.getType().getTypeDefName();
                    if (oMRSRepositoryHelper.isTypeOf("getGraph", typeDefName, "GlossaryTerm")) {
                        nodeType = "Term";
                    }
                    if (oMRSRepositoryHelper.isTypeOf("getGraph", typeDefName, "GlossaryCategory")) {
                        nodeType = "Category";
                    }
                    if (oMRSRepositoryHelper.isTypeOf("getGraph", typeDefName, "Glossary")) {
                        nodeType = "Glossary";
                    }
                    if (oMRSRepositoryHelper.isTypeOf("getGraph", typeDefName, "Asset")) {
                        nodeType = "Asset";
                    }
                    List classifications = entity.getClassifications();
                    Set classificationNames = null;
                    if (classifications != null && !classifications.isEmpty()) {
                        classificationNames = classifications.stream().map(x -> x.getName()).collect(Collectors.toSet());
                    }
                    for (NodeType nodeTypeValue : NodeType.values()) {
                        if (!nodeTypeValue.name().equals(nodeType)) continue;
                        if (classificationNames != null) {
                            if (nodeType.equals("Category") && classificationNames.contains("SubjectArea")) {
                                node.setNodeType(NodeType.SubjectAreaDefinition);
                            } else if (nodeType.equals("Glossary")) {
                                if (classificationNames.contains("Taxonomy") && classificationNames.contains("CanonicalGlossary")) {
                                    node.setNodeType(NodeType.TaxonomyAndCanonicalGlossary);
                                } else if (classificationNames.contains("Taxonomy")) {
                                    node.setNodeType(NodeType.Taxonomy);
                                } else if (classificationNames.contains("CanonicalGlossary")) {
                                    node.setNodeType(NodeType.CanonicalGlossary);
                                }
                            } else if (typeDefName.equals("Term") && classificationNames.contains("Activity")) {
                                node.setNodeType(NodeType.Activity);
                            }
                        }
                        if (node.getNodeType() != NodeType.Unknown) continue;
                        node.setNodeType(nodeTypeValue);
                    }
                    nodes.add(node);
                }
            }
            if (relationships != null && !relationships.isEmpty()) {
                lines = new HashSet<Line>();
                for (Relationship relationship : relationships) {
                    Line line = new Line(relationship);
                    line.setLineType(LineType.Unknown);
                    String typeDefName = relationship.getType().getTypeDefName();
                    for (LineType lineTypeValue : LineType.values()) {
                        if (!lineTypeValue.name().equals(typeDefName)) continue;
                        line.setLineType(lineTypeValue);
                    }
                    lines.add(line);
                }
            }
            if (nodes != null) {
                graph.setNodes(nodes);
            }
            if (lines != null) {
                graph.setLines(lines);
            }
            response = new GraphResponse(graph);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGraph,userId=" + userId + ", Response=" + response);
        }
        return response;
    }
}

