/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.OMRSRelationshipToLines;
import org.odpi.openmetadata.accessservices.subjectarea.generated.server.SubjectAreaBeansToAccessOMRS;
import org.odpi.openmetadata.accessservices.subjectarea.initialization.SubjectAreaInstanceHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaRESTServicesInstance {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaRESTServicesInstance.class);
    private static final String className = SubjectAreaRESTServicesInstance.class.getName();
    protected OMRSAPIHelper oMRSAPIHelper = null;
    protected static SubjectAreaInstanceHandler instanceHandler = new SubjectAreaInstanceHandler();

    protected SubjectAreaBeansToAccessOMRS initializeAPI(String serverName, String userId, String methodName) throws MetadataServerUncontactableException, InvalidParameterException {
        return this.initializeAPI(serverName, userId, null, null, methodName);
    }

    protected SubjectAreaBeansToAccessOMRS initializeAPI(String serverName, String userId, Date from, Date to, String methodName) throws MetadataServerUncontactableException, InvalidParameterException {
        if (this.oMRSAPIHelper == null) {
            this.oMRSAPIHelper = new OMRSAPIHelper();
        }
        OMRSRepositoryConnector omrsConnector = instanceHandler.getRepositoryConnector(serverName);
        this.oMRSAPIHelper.setOMRSRepositoryConnector(omrsConnector);
        SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = new SubjectAreaBeansToAccessOMRS();
        subjectAreaOmasREST.setOMRSAPIHelper(this.oMRSAPIHelper);
        InputValidator.validateUserIdNotNull((String)className, (String)methodName, (String)userId);
        InputValidator.validateEffectiveDate((String)className, (String)methodName, (Date)to, (Date)from);
        return subjectAreaOmasREST;
    }

    public void setOMRSAPIHelper(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
    }

    public SubjectAreaOMASAPIResponse getRelationshipsFromGuid(String serverName, String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getRelationshipsFromGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getRelationshipsFromGuid,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getRelationshipsFromGuid");
            InputValidator.validateGUIDNotNull((String)className, (String)"getRelationshipsFromGuid", (String)guid, (String)"guid");
            if (offset == null) {
                offset = new Integer(0);
            }
            if (pageSize == null) {
                pageSize = new Integer(0);
            }
            if (sequencingProperty != null) {
                try {
                    sequencingProperty = URLDecoder.decode(sequencingProperty, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder omrsSequencingOrder = SubjectAreaUtils.convertOMASToOMRSSequencingOrder(sequencingOrder);
            Set<Line> omrsRelationships = this.getRelationshipsFromGuid(userId, guid, null, offset, asOfTime, sequencingProperty, omrsSequencingOrder, pageSize);
            List<Line> relationshipsToReturn = SubjectAreaUtils.convertOMRSLinesToOMASLines(omrsRelationships);
            int sizeToGet = 0;
            if (omrsRelationships.size() > relationshipsToReturn.size()) {
                sizeToGet = omrsRelationships.size() - relationshipsToReturn.size();
            }
            while (sizeToGet > 0) {
                omrsRelationships = this.getRelationshipsFromGuid(userId, guid, null, offset + sizeToGet, asOfTime, sequencingProperty, omrsSequencingOrder, sizeToGet);
                if (omrsRelationships == null) continue;
                sizeToGet = this.getSizeToGet(omrsRelationships, relationshipsToReturn);
                offset = sizeToGet;
            }
            response = new RelationshipsResponse(relationshipsToReturn);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException functionNotSupportedException) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getRelationshipsFromGuid,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    private Set<Line> getRelationshipsFromGuid(String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder sequencingOrder, int pageSize) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException {
        String methodName = "getRelationshipsFromGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getRelationshipsFromGuid,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getRelationshipsFromGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getRelationshipsFromGuid", (String)entityGuid, (String)"entityGuid");
        Set<Line> lines = null;
        List<Relationship> omrsRelationships = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (omrsRelationships != null) {
            lines = OMRSRelationshipToLines.convert(omrsRelationships);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getRelationshipsFromGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return lines;
    }

    private int getSizeToGet(Set<Line> omrsTermRelationships, List<Line> termRelationships) {
        int sizeToGet = 0;
        List<Line> moreTermRelationships = SubjectAreaUtils.convertOMRSLinesToOMASLines(omrsTermRelationships);
        if (moreTermRelationships != null && moreTermRelationships.size() > 0) {
            for (Line moreTermRelationship : moreTermRelationships) {
                termRelationships.add(moreTermRelationship);
            }
            sizeToGet = omrsTermRelationships.size() - moreTermRelationships.size();
        }
        return sizeToGet;
    }
}

