/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.RelationshipNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ISARelationship.ISARelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.PreferredTerm.PreferredTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReplacementTerm.ReplacementTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SemanticAssignment.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Synonym.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Synonym.SynonymMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermCategorization.TermCategorization;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermCategorization.TermCategorizationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermHASARelationship.TermHASARelationship;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermHASARelationship.TermHASARelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermISATypeOFRelationship.TermISATypeOFRelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermTYPEDBYRelationship.TermTYPEDBYRelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Translation.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Translation.TranslationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.server.SubjectAreaBeansToAccessOMRS;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Antonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ISARelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ReplacementTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermCategorizationRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermISATypeOFRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermTYPEDBYRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.UsedInContext;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ValidValue;
import org.odpi.openmetadata.accessservices.subjectarea.responses.AntonymRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.PreferredTermRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.RelatedTermResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ReplacementRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SemanticAssignementRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SynonymRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermCategorizationRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermHASARelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermISARelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermISATYPEOFRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermTYPEDBYRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TranslationRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.UsedInContextRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ValidValueRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.AntonymMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.HasAMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.IsaMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.IsaTypeOfMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.RelatedTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.SemanticAssignmentMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermReplacementMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TypedByMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.UsedInContextMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.ValidValueMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaRelationshipRESTServices
extends SubjectAreaRESTServicesInstance {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaRelationshipRESTServices.class);
    private static final String className = SubjectAreaRelationshipRESTServices.class.getName();

    public SubjectAreaRelationshipRESTServices() {
    }

    public SubjectAreaRelationshipRESTServices(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
    }

    public SubjectAreaOMASAPIResponse createTermHASARelationship(String serverName, String userId, org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermHASARelationship termHASARelationship) {
        String methodName = "createTermHASARelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createTermHASARelationship,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, termHASARelationship.getEffectiveFromTime(), termHASARelationship.getEffectiveToTime(), "createTermHASARelationship");
            TermHASARelationship gennedRelationship = HasAMapper.mapTermHASARelationshipToOMRSRelationshipBean(termHASARelationship);
            TermHASARelationship createdGennedRelationship = subjectAreaOmasREST.createTermHASARelationshipRelationship(userId, gennedRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermHASARelationship createdRelationship = HasAMapper.mapOMRSRelationshipBeanToTermHASARelationship(createdGennedRelationship);
            response = new TermHASARelationshipResponse(createdRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createTermHASARelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getTermHASARelationship(String serverName, String userId, String guid) {
        String methodName = "getTermHASARelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getTermHASARelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getTermHASARelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"getTermHASARelationship", (String)guid, (String)"guid");
            TermHASARelationship relationshipBean = subjectAreaOmasREST.getTermHASARelationshipRelationshipByGuid(userId, guid);
            org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermHASARelationship termHASARelationship = HasAMapper.mapOMRSRelationshipBeanToTermHASARelationship(relationshipBean);
            response = new TermHASARelationshipResponse(termHASARelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTermHASARelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateTermHASARelationship(String serverName, String userId, org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermHASARelationship termHASARelationship, boolean isReplace) {
        String methodName = "updateTermHASARelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateTermHASARelationship,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        String relationshipGuid = termHASARelationship.getGuid();
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, termHASARelationship.getEffectiveFromTime(), termHASARelationship.getEffectiveToTime(), "updateTermHASARelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"updateTermHASARelationship", (String)relationshipGuid, (String)"termGuid");
            TermHASARelationship existingRelationship = subjectAreaOmasREST.getTermHASARelationshipRelationshipByGuid(userId, relationshipGuid);
            if (!isReplace) {
                if (termHASARelationship.getDescription() == null) {
                    termHASARelationship.setDescription(existingRelationship.getDescription());
                }
                if (termHASARelationship.getSource() == null) {
                    termHASARelationship.setSource(existingRelationship.getSource());
                }
                if (termHASARelationship.getStatus() == null) {
                    termHASARelationship.setStatus(existingRelationship.getStatus());
                }
                if (termHASARelationship.getSteward() == null) {
                    termHASARelationship.setSteward(existingRelationship.getSteward());
                }
            }
            TermHASARelationship gennedRelationship = HasAMapper.mapTermHASARelationshipToOMRSRelationshipBean(termHASARelationship);
            TermHASARelationship updatedGennedRelationship = subjectAreaOmasREST.updateTermHASARelationshipRelationship(userId, gennedRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermHASARelationship updatedRelationship = HasAMapper.mapOMRSRelationshipBeanToTermHASARelationship(updatedGennedRelationship);
            response = new TermHASARelationshipResponse(updatedRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTermHASARelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteTermHASARelationship(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteTermHASARelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteTermHASARelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "deleteTermHASARelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteTermHASARelationship", (String)guid, (String)"guid");
            if (isPurge.booleanValue()) {
                subjectAreaOmasREST.purgeRelationshipById(userId, guid, "TermHASARelationship");
                response = new VoidResponse();
            } else {
                Relationship omrsRelationship = subjectAreaOmasREST.deleteRelationshipById(userId, guid, "TermHASARelationship");
                TermHASARelationship deletedRelationshipBean = TermHASARelationshipMapper.mapOmrsRelationshipToTermHASARelationship(omrsRelationship);
                org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermHASARelationship deletedRelationship = HasAMapper.mapOMRSRelationshipBeanToTermHASARelationship(deletedRelationshipBean);
                response = new TermHASARelationshipResponse(deletedRelationship);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (RelationshipNotDeletedException e) {
            response = OMASExceptionToResponse.convertRelationshipNotDeletedException((RelationshipNotDeletedException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotPurgedException e) {
            response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteTermHASARelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreTermHASARelationship(String serverName, String userId, String guid) {
        String methodName = "restoreTermHASARelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreTermHASARelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "restoreTermHASARelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreTermHASARelationship", (String)guid, (String)"guid");
            Relationship omrsRelationship = this.oMRSAPIHelper.callOMRSRestoreRelationship(userId, guid);
            TermHASARelationship restoredRelationshipBean = TermHASARelationshipMapper.mapOmrsRelationshipToTermHASARelationship(omrsRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermHASARelationship restoredRelationship = HasAMapper.mapOMRSRelationshipBeanToTermHASARelationship(restoredRelationshipBean);
            response = new TermHASARelationshipResponse(restoredRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotDeletedException e) {
            response = OMASExceptionToResponse.convertGUIDNotDeletedException((GUIDNotDeletedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreTermHASARelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse createRelatedTerm(String serverName, String userId, RelatedTerm relatedTermRelationship) {
        String methodName = "RelatedTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: RelatedTerm,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        Object createdRelatedTerm = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, relatedTermRelationship.getEffectiveFromTime(), relatedTermRelationship.getEffectiveToTime(), "RelatedTerm");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RelatedTerm.RelatedTerm gennedRelationship = RelatedTermMapper.mapRelatedTermToOMRSRelationshipBean(relatedTermRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RelatedTerm.RelatedTerm createdGennedRelationship = subjectAreaOmasREST.createRelatedTermRelationship(userId, gennedRelationship);
            RelatedTerm createdRelationship = RelatedTermMapper.mapOMRSRelationshipBeanToRelatedTerm(createdGennedRelationship);
            response = new RelatedTermResponse(createdRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : RelatedTerm,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getRelatedTerm(String serverName, String userId, String guid) {
        String methodName = "getRelatedTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getRelatedTerm,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getRelatedTerm");
            InputValidator.validateGUIDNotNull((String)className, (String)"getRelatedTerm", (String)guid, (String)"guid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RelatedTerm.RelatedTerm relationshipBean = subjectAreaOmasREST.getRelatedTermRelationshipByGuid(userId, guid);
            RelatedTerm relatedterm = RelatedTermMapper.mapOMRSRelationshipBeanToRelatedTerm(relationshipBean);
            response = new RelatedTermResponse(relatedterm);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getRelatedTerm,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateRelatedTerm(String serverName, String userId, RelatedTerm relatedTermRelationship, boolean isReplace) {
        String methodName = "updateRelatedTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateRelatedTerm,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        Object createdRelatedTerm = null;
        String relationshipGuid = relatedTermRelationship.getGuid();
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, relatedTermRelationship.getEffectiveFromTime(), relatedTermRelationship.getEffectiveToTime(), "updateRelatedTerm");
            InputValidator.validateGUIDNotNull((String)className, (String)"updateRelatedTerm", (String)relationshipGuid, (String)"termGuid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RelatedTerm.RelatedTerm existingRelationship = subjectAreaOmasREST.getRelatedTermRelationshipByGuid(userId, relationshipGuid);
            if (!isReplace) {
                if (relatedTermRelationship.getDescription() == null) {
                    relatedTermRelationship.setDescription(existingRelationship.getDescription());
                }
                if (relatedTermRelationship.getSource() == null) {
                    relatedTermRelationship.setSource(existingRelationship.getSource());
                }
                if (relatedTermRelationship.getStatus() == null) {
                    relatedTermRelationship.setStatus(existingRelationship.getStatus());
                }
                if (relatedTermRelationship.getSteward() == null) {
                    relatedTermRelationship.setSteward(existingRelationship.getSteward());
                }
                if (relatedTermRelationship.getExpression() == null) {
                    relatedTermRelationship.setExpression(existingRelationship.getExpression());
                }
            }
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RelatedTerm.RelatedTerm gennedRelationship = RelatedTermMapper.mapRelatedTermToOMRSRelationshipBean(relatedTermRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RelatedTerm.RelatedTerm updatedGennedRelationship = subjectAreaOmasREST.updateRelatedTermRelationship(userId, gennedRelationship);
            RelatedTerm updatedRelationship = RelatedTermMapper.mapOMRSRelationshipBeanToRelatedTerm(updatedGennedRelationship);
            response = new RelatedTermResponse(updatedRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateRelatedTerm,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteRelatedTerm(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteRelatedTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteRelatedTerm,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "deleteRelatedTerm");
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteRelatedTerm", (String)guid, (String)"guid");
            if (isPurge.booleanValue()) {
                subjectAreaOmasREST.purgeRelationshipById(userId, guid, "RelatedTerm");
                response = new VoidResponse();
            } else {
                Relationship omrsRelationship = subjectAreaOmasREST.deleteRelationshipById(userId, guid, "RelatedTerm");
                org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RelatedTerm.RelatedTerm deletedRelationshipBean = org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RelatedTerm.RelatedTermMapper.mapOmrsRelationshipToRelatedTerm(omrsRelationship);
                RelatedTerm deletedRelationship = RelatedTermMapper.mapOMRSRelationshipBeanToRelatedTerm(deletedRelationshipBean);
                response = new RelatedTermResponse(deletedRelationship);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (RelationshipNotDeletedException e) {
            response = OMASExceptionToResponse.convertRelationshipNotDeletedException((RelationshipNotDeletedException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotPurgedException e) {
            response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteRelatedTerm,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreRelatedTerm(String serverName, String userId, String guid) {
        String methodName = "restoreRelatedTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreRelatedTerm,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "restoreRelatedTerm");
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreRelatedTerm", (String)guid, (String)"guid");
            Relationship omrsRelationship = this.oMRSAPIHelper.callOMRSRestoreRelationship(userId, guid);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RelatedTerm.RelatedTerm restoredRelationshipBean = org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RelatedTerm.RelatedTermMapper.mapOmrsRelationshipToRelatedTerm(omrsRelationship);
            RelatedTerm restoredRelationship = RelatedTermMapper.mapOMRSRelationshipBeanToRelatedTerm(restoredRelationshipBean);
            response = new RelatedTermResponse(restoredRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotDeletedException e) {
            response = OMASExceptionToResponse.convertGUIDNotDeletedException((GUIDNotDeletedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreRelatedTerm,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse createSynonym(String serverName, String userId, org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym synonym) {
        String methodName = "createSynonym";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createSynonym,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, synonym.getEffectiveFromTime(), synonym.getEffectiveToTime(), "createSynonym");
            Synonym gennedRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.SynonymMapper.mapSynonymToOMRSRelationshipBean(synonym);
            Synonym createdGennedRelationship = subjectAreaOmasREST.createSynonymRelationship(userId, gennedRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym createdRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.SynonymMapper.mapOMRSRelationshipBeanToSynonym(createdGennedRelationship);
            response = new SynonymRelationshipResponse(createdRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createSynonym,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getSynonymRelationship(String serverName, String userId, String guid) {
        String methodName = "getSynonymRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getSynonymRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getSynonymRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"getSynonymRelationship", (String)guid, (String)"guid");
            Synonym relationshipBean = subjectAreaOmasREST.getSynonymRelationshipByGuid(userId, guid);
            org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym termCategorization = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.SynonymMapper.mapOMRSRelationshipBeanToSynonym(relationshipBean);
            response = new SynonymRelationshipResponse(termCategorization);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getSynonymRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateSynonymRelationship(String serverName, String userId, org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym termCategorizationRelationship, boolean isReplace) {
        String methodName = "updateSynonymRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateSynonymRelationship,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        String relationshipGuid = termCategorizationRelationship.getGuid();
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, termCategorizationRelationship.getEffectiveFromTime(), termCategorizationRelationship.getEffectiveToTime(), "updateSynonymRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"updateSynonymRelationship", (String)relationshipGuid, (String)"relationshipGuid");
            Synonym existingRelationship = subjectAreaOmasREST.getSynonymRelationshipByGuid(userId, relationshipGuid);
            if (!isReplace) {
                if (termCategorizationRelationship.getDescription() == null) {
                    termCategorizationRelationship.setDescription(existingRelationship.getDescription());
                }
                if (termCategorizationRelationship.getSource() == null) {
                    termCategorizationRelationship.setSource(existingRelationship.getSource());
                }
                if (termCategorizationRelationship.getStatus() == null) {
                    termCategorizationRelationship.setStatus(existingRelationship.getStatus());
                }
                if (termCategorizationRelationship.getSteward() == null) {
                    termCategorizationRelationship.setSteward(existingRelationship.getSteward());
                }
                if (termCategorizationRelationship.getExpression() == null) {
                    termCategorizationRelationship.setExpression(existingRelationship.getExpression());
                }
            }
            Synonym gennedRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.SynonymMapper.mapSynonymToOMRSRelationshipBean(termCategorizationRelationship);
            Synonym updatedGennedRelationship = subjectAreaOmasREST.updateSynonymRelationship(userId, gennedRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym updatedRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.SynonymMapper.mapOMRSRelationshipBeanToSynonym(updatedGennedRelationship);
            response = new SynonymRelationshipResponse(updatedRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateSynonymRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteSynonymRelationship(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteSynonymRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteSynonymRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "deleteSynonymRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteSynonymRelationship", (String)guid, (String)"guid");
            if (isPurge.booleanValue()) {
                subjectAreaOmasREST.purgeRelationshipById(userId, guid, "Synonym");
                response = new VoidResponse();
            } else {
                Relationship omrsRelationship = subjectAreaOmasREST.deleteRelationshipById(userId, guid, "Synonym");
                Synonym deletedRelationshipBean = SynonymMapper.mapOmrsRelationshipToSynonym(omrsRelationship);
                org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym deletedRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.SynonymMapper.mapOMRSRelationshipBeanToSynonym(deletedRelationshipBean);
                response = new SynonymRelationshipResponse(deletedRelationship);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (RelationshipNotDeletedException e) {
            response = OMASExceptionToResponse.convertRelationshipNotDeletedException((RelationshipNotDeletedException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotPurgedException e) {
            response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteSynonymRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreSynonym(String serverName, String userId, String guid) {
        String methodName = "restoreSynonym";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreSynonym,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "restoreSynonym");
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreSynonym", (String)guid, (String)"guid");
            Relationship omrsRelationship = this.oMRSAPIHelper.callOMRSRestoreRelationship(userId, guid);
            Synonym restoredRelationshipBean = SynonymMapper.mapOmrsRelationshipToSynonym(omrsRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym restoredRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.SynonymMapper.mapOMRSRelationshipBeanToSynonym(restoredRelationshipBean);
            response = new SynonymRelationshipResponse(restoredRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotDeletedException e) {
            response = OMASExceptionToResponse.convertGUIDNotDeletedException((GUIDNotDeletedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreSynonym,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse createAntonym(String serverName, String userId, Antonym antonymRelationship) {
        String methodName = "createAntonym";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createAntonym,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, antonymRelationship.getEffectiveFromTime(), antonymRelationship.getEffectiveToTime(), "createAntonym");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Antonym.Antonym gennedRelationship = AntonymMapper.mapAntonymToOMRSRelationshipBean(antonymRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Antonym.Antonym createdGennedRelationship = subjectAreaOmasREST.createAntonymRelationship(userId, gennedRelationship);
            Antonym createdRelationship = AntonymMapper.mapOMRSRelationshipBeanToAntonym(createdGennedRelationship);
            response = new AntonymRelationshipResponse(createdRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createAntonym,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getAntonymRelationship(String serverName, String userId, String guid) {
        String methodName = "getAntonymRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getAntonymRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getAntonymRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"getAntonymRelationship", (String)guid, (String)"guid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Antonym.Antonym relationshipBean = subjectAreaOmasREST.getAntonymRelationshipByGuid(userId, guid);
            Antonym antonym = AntonymMapper.mapOMRSRelationshipBeanToAntonym(relationshipBean);
            response = new AntonymRelationshipResponse(antonym);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getAntonymRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateAntonymRelationship(String serverName, String userId, Antonym antonymRelationship, boolean isReplace) {
        String methodName = "updateAntonymRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateAntonymRelationship,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        String relationshipGuid = antonymRelationship.getGuid();
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, antonymRelationship.getEffectiveFromTime(), antonymRelationship.getEffectiveToTime(), "updateAntonymRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"updateAntonymRelationship", (String)relationshipGuid, (String)"guid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Antonym.Antonym existingRelationship = subjectAreaOmasREST.getAntonymRelationshipByGuid(userId, relationshipGuid);
            if (!isReplace) {
                if (antonymRelationship.getDescription() == null) {
                    antonymRelationship.setDescription(existingRelationship.getDescription());
                }
                if (antonymRelationship.getSource() == null) {
                    antonymRelationship.setSource(existingRelationship.getSource());
                }
                if (antonymRelationship.getStatus() == null) {
                    antonymRelationship.setStatus(existingRelationship.getStatus());
                }
                if (antonymRelationship.getSteward() == null) {
                    antonymRelationship.setSteward(existingRelationship.getSteward());
                }
                if (antonymRelationship.getExpression() == null) {
                    antonymRelationship.setExpression(existingRelationship.getExpression());
                }
            }
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Antonym.Antonym gennedRelationship = AntonymMapper.mapAntonymToOMRSRelationshipBean(antonymRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Antonym.Antonym updatedGennedRelationship = subjectAreaOmasREST.updateAntonymRelationship(userId, gennedRelationship);
            Antonym updatedRelationship = AntonymMapper.mapOMRSRelationshipBeanToAntonym(updatedGennedRelationship);
            response = new AntonymRelationshipResponse(updatedRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateAntonymRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteAntonymRelationship(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteAntonymRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteAntonymRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "deleteAntonymRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteAntonymRelationship", (String)guid, (String)"guid");
            if (isPurge.booleanValue()) {
                subjectAreaOmasREST.purgeRelationshipById(userId, guid, "Antonym");
                response = new VoidResponse();
            } else {
                Relationship omrsRelationship = subjectAreaOmasREST.deleteRelationshipById(userId, guid, "Antonym");
                org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Antonym.Antonym deletedRelationshipBean = org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Antonym.AntonymMapper.mapOmrsRelationshipToAntonym(omrsRelationship);
                Antonym deletedRelationship = AntonymMapper.mapOMRSRelationshipBeanToAntonym(deletedRelationshipBean);
                response = new AntonymRelationshipResponse(deletedRelationship);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (RelationshipNotDeletedException e) {
            response = OMASExceptionToResponse.convertRelationshipNotDeletedException((RelationshipNotDeletedException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotPurgedException e) {
            response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteAntonymRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreAntonym(String serverName, String userId, String guid) {
        String methodName = "restoreAntonym";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreAntonym,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "restoreAntonym");
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreAntonym", (String)guid, (String)"guid");
            Relationship omrsRelationship = this.oMRSAPIHelper.callOMRSRestoreRelationship(userId, guid);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Antonym.Antonym restoredRelationshipBean = org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Antonym.AntonymMapper.mapOmrsRelationshipToAntonym(omrsRelationship);
            Antonym restoredRelationship = AntonymMapper.mapOMRSRelationshipBeanToAntonym(restoredRelationshipBean);
            response = new AntonymRelationshipResponse(restoredRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotDeletedException e) {
            response = OMASExceptionToResponse.convertGUIDNotDeletedException((GUIDNotDeletedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreAntonym,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse createTranslation(String serverName, String userId, org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation translationRelationship) {
        String methodName = "Translation";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: Translation,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, translationRelationship.getEffectiveFromTime(), translationRelationship.getEffectiveToTime(), "Translation");
            Translation gennedRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TranslationMapper.mapTranslationToOMRSRelationshipBean(translationRelationship);
            Translation createdGennedRelationship = subjectAreaOmasREST.createTranslationRelationship(userId, gennedRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation createdRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TranslationMapper.mapOMRSRelationshipBeanToTranslation(createdGennedRelationship);
            response = new TranslationRelationshipResponse(createdRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : Translation,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getTranslationRelationship(String serverName, String userId, String guid) {
        String methodName = "getTranslationRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getTranslationRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getTranslationRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"getTranslationRelationship", (String)guid, (String)"guid");
            Translation relationshipBean = subjectAreaOmasREST.getTranslationRelationshipByGuid(userId, guid);
            org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation translation = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TranslationMapper.mapOMRSRelationshipBeanToTranslation(relationshipBean);
            response = new TranslationRelationshipResponse(translation);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTranslationRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateTranslationRelationship(String serverName, String userId, org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation translationRelationship, boolean isReplace) {
        String methodName = "updateTranslationRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateTranslationRelationship,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        String relationshipGuid = translationRelationship.getGuid();
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, translationRelationship.getEffectiveFromTime(), translationRelationship.getEffectiveToTime(), "updateTranslationRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"updateTranslationRelationship", (String)relationshipGuid, (String)"relationshipGuid");
            Translation existingRelationship = subjectAreaOmasREST.getTranslationRelationshipByGuid(userId, relationshipGuid);
            if (!isReplace) {
                if (translationRelationship.getDescription() == null) {
                    translationRelationship.setDescription(existingRelationship.getDescription());
                }
                if (translationRelationship.getSource() == null) {
                    translationRelationship.setSource(existingRelationship.getSource());
                }
                if (translationRelationship.getStatus() == null) {
                    translationRelationship.setStatus(existingRelationship.getStatus());
                }
                if (translationRelationship.getSteward() == null) {
                    translationRelationship.setSteward(existingRelationship.getSteward());
                }
                if (translationRelationship.getExpression() == null) {
                    translationRelationship.setExpression(existingRelationship.getExpression());
                }
            }
            Translation gennedRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TranslationMapper.mapTranslationToOMRSRelationshipBean(translationRelationship);
            Translation updatedGennedRelationship = subjectAreaOmasREST.updateTranslationRelationship(userId, gennedRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation updatedRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TranslationMapper.mapOMRSRelationshipBeanToTranslation(updatedGennedRelationship);
            response = new TranslationRelationshipResponse(updatedRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTranslationRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteTranslationRelationship(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteTranslationRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteTranslationRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "deleteTranslationRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteTranslationRelationship", (String)guid, (String)"guid");
            if (isPurge.booleanValue()) {
                subjectAreaOmasREST.purgeRelationshipById(userId, guid, "Translation");
                response = new VoidResponse();
            } else {
                Relationship omrsRelationship = subjectAreaOmasREST.deleteRelationshipById(userId, guid, "Translation");
                Translation deletedRelationshipBean = TranslationMapper.mapOmrsRelationshipToTranslation(omrsRelationship);
                org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation deletedRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TranslationMapper.mapOMRSRelationshipBeanToTranslation(deletedRelationshipBean);
                response = new TranslationRelationshipResponse(deletedRelationship);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (RelationshipNotDeletedException e) {
            response = OMASExceptionToResponse.convertRelationshipNotDeletedException((RelationshipNotDeletedException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotPurgedException e) {
            response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteTranslationRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreTranslation(String serverName, String userId, String guid) {
        String methodName = "restoreTranslation";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreTranslation,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "restoreTranslation");
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreTranslation", (String)guid, (String)"guid");
            Relationship omrsRelationship = this.oMRSAPIHelper.callOMRSRestoreRelationship(userId, guid);
            Translation restoredRelationshipBean = TranslationMapper.mapOmrsRelationshipToTranslation(omrsRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation restoredRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TranslationMapper.mapOMRSRelationshipBeanToTranslation(restoredRelationshipBean);
            response = new TranslationRelationshipResponse(restoredRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotDeletedException e) {
            response = OMASExceptionToResponse.convertGUIDNotDeletedException((GUIDNotDeletedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreTranslation,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse createUsedInContext(String serverName, String userId, UsedInContext usedInContextRelationship) {
        String methodName = "UsedInContext";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: UsedInContext,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        Object createdUsedInContext = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, usedInContextRelationship.getEffectiveFromTime(), usedInContextRelationship.getEffectiveToTime(), "UsedInContext");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.UsedInContext.UsedInContext gennedRelationship = UsedInContextMapper.mapUsedInContextToOMRSRelationshipBean(usedInContextRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.UsedInContext.UsedInContext createdGennedRelationship = subjectAreaOmasREST.createUsedInContextRelationship(userId, gennedRelationship);
            UsedInContext createdRelationship = UsedInContextMapper.mapOMRSRelationshipBeanToUsedInContext(createdGennedRelationship);
            response = new UsedInContextRelationshipResponse(createdRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : UsedInContext,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getUsedInContextRelationship(String serverName, String userId, String guid) {
        String methodName = "getUsedInContextRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getUsedInContextRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getUsedInContextRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"getUsedInContextRelationship", (String)guid, (String)"guid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.UsedInContext.UsedInContext relationshipBean = subjectAreaOmasREST.getUsedInContextRelationshipByGuid(userId, guid);
            UsedInContext usedInContext = UsedInContextMapper.mapOMRSRelationshipBeanToUsedInContext(relationshipBean);
            response = new UsedInContextRelationshipResponse(usedInContext);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getUsedInContextRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateUsedInContextRelationship(String serverName, String userId, UsedInContext usedInContextRelationship, boolean isReplace) {
        String methodName = "updateUsedInContextRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateUsedInContextRelationship,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        String relationshipGuid = usedInContextRelationship.getGuid();
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, usedInContextRelationship.getEffectiveFromTime(), usedInContextRelationship.getEffectiveToTime(), "updateUsedInContextRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"updateUsedInContextRelationship", (String)relationshipGuid, (String)"relationshipGuid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.UsedInContext.UsedInContext existingRelationship = subjectAreaOmasREST.getUsedInContextRelationshipByGuid(userId, relationshipGuid);
            if (!isReplace) {
                if (usedInContextRelationship.getDescription() == null) {
                    usedInContextRelationship.setDescription(existingRelationship.getDescription());
                }
                if (usedInContextRelationship.getSource() == null) {
                    usedInContextRelationship.setSource(existingRelationship.getSource());
                }
                if (usedInContextRelationship.getStatus() == null) {
                    usedInContextRelationship.setStatus(existingRelationship.getStatus());
                }
                if (usedInContextRelationship.getSteward() == null) {
                    usedInContextRelationship.setSteward(existingRelationship.getSteward());
                }
                if (usedInContextRelationship.getExpression() == null) {
                    usedInContextRelationship.setExpression(existingRelationship.getExpression());
                }
            }
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.UsedInContext.UsedInContext gennedRelationship = UsedInContextMapper.mapUsedInContextToOMRSRelationshipBean(usedInContextRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.UsedInContext.UsedInContext updatedGennedRelationship = subjectAreaOmasREST.updateUsedInContextRelationship(userId, gennedRelationship);
            UsedInContext updatedRelationship = UsedInContextMapper.mapOMRSRelationshipBeanToUsedInContext(updatedGennedRelationship);
            response = new UsedInContextRelationshipResponse(updatedRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateUsedInContextRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteUsedInContextRelationship(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteUsedInContextRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteUsedInContextRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "deleteUsedInContextRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteUsedInContextRelationship", (String)guid, (String)"guid");
            if (isPurge.booleanValue()) {
                subjectAreaOmasREST.purgeRelationshipById(userId, guid, "UsedInContext");
                response = new VoidResponse();
            } else {
                Relationship omrsRelationship = subjectAreaOmasREST.deleteRelationshipById(userId, guid, "UsedInContext");
                org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.UsedInContext.UsedInContext deletedRelationshipBean = org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.UsedInContext.UsedInContextMapper.mapOmrsRelationshipToUsedInContext(omrsRelationship);
                UsedInContext deletedRelationship = UsedInContextMapper.mapOMRSRelationshipBeanToUsedInContext(deletedRelationshipBean);
                response = new UsedInContextRelationshipResponse(deletedRelationship);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (RelationshipNotDeletedException e) {
            response = OMASExceptionToResponse.convertRelationshipNotDeletedException((RelationshipNotDeletedException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotPurgedException e) {
            response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteUsedInContextRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreUsedInContext(String serverName, String userId, String guid) {
        String methodName = "restoreUsedInContext";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreUsedInContext,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "restoreUsedInContext");
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreUsedInContext", (String)guid, (String)"guid");
            Relationship omrsRelationship = this.oMRSAPIHelper.callOMRSRestoreRelationship(userId, guid);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.UsedInContext.UsedInContext restoredRelationshipBean = org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.UsedInContext.UsedInContextMapper.mapOmrsRelationshipToUsedInContext(omrsRelationship);
            UsedInContext restoredRelationship = UsedInContextMapper.mapOMRSRelationshipBeanToUsedInContext(restoredRelationshipBean);
            response = new UsedInContextRelationshipResponse(restoredRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotDeletedException e) {
            response = OMASExceptionToResponse.convertGUIDNotDeletedException((GUIDNotDeletedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreUsedInContext,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse createPreferredTerm(String serverName, String userId, PreferredTerm preferredTermRelationship) {
        String methodName = "PreferredTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: PreferredTerm,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        Object createdPreferredTerm = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, preferredTermRelationship.getEffectiveFromTime(), preferredTermRelationship.getEffectiveToTime(), "PreferredTerm");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.PreferredTerm.PreferredTerm gennedRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.PreferredTermMapper.mapPreferredTermToOMRSRelationshipBean(preferredTermRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.PreferredTerm.PreferredTerm createdGennedRelationship = subjectAreaOmasREST.createPreferredTermRelationship(userId, gennedRelationship);
            PreferredTerm createdRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.PreferredTermMapper.mapOMRSRelationshipBeanToPreferredTerm(createdGennedRelationship);
            response = new PreferredTermRelationshipResponse(createdRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : PreferredTerm,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getPreferredTermRelationship(String serverName, String userId, String guid) {
        String methodName = "getPreferredTermRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getPreferredTermRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getPreferredTermRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"getPreferredTermRelationship", (String)guid, (String)"guid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.PreferredTerm.PreferredTerm relationshipBean = subjectAreaOmasREST.getPreferredTermRelationshipByGuid(userId, guid);
            PreferredTerm preferredTerm = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.PreferredTermMapper.mapOMRSRelationshipBeanToPreferredTerm(relationshipBean);
            response = new PreferredTermRelationshipResponse(preferredTerm);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getPreferredTermRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updatePreferredTermRelationship(String serverName, String userId, PreferredTerm preferredTermRelationship, boolean isReplace) {
        String methodName = "updatePreferredTermRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updatePreferredTermRelationship,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        String relationshipGuid = preferredTermRelationship.getGuid();
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, preferredTermRelationship.getEffectiveFromTime(), preferredTermRelationship.getEffectiveToTime(), "updatePreferredTermRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"updatePreferredTermRelationship", (String)relationshipGuid, (String)"relationshipGuid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.PreferredTerm.PreferredTerm existingRelationship = subjectAreaOmasREST.getPreferredTermRelationshipByGuid(userId, relationshipGuid);
            if (!isReplace) {
                if (preferredTermRelationship.getDescription() == null) {
                    preferredTermRelationship.setDescription(existingRelationship.getDescription());
                }
                if (preferredTermRelationship.getSource() == null) {
                    preferredTermRelationship.setSource(existingRelationship.getSource());
                }
                if (preferredTermRelationship.getStatus() == null) {
                    preferredTermRelationship.setStatus(existingRelationship.getStatus());
                }
                if (preferredTermRelationship.getSteward() == null) {
                    preferredTermRelationship.setSteward(existingRelationship.getSteward());
                }
                if (preferredTermRelationship.getExpression() == null) {
                    preferredTermRelationship.setExpression(existingRelationship.getExpression());
                }
            }
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.PreferredTerm.PreferredTerm gennedRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.PreferredTermMapper.mapPreferredTermToOMRSRelationshipBean(preferredTermRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.PreferredTerm.PreferredTerm updatedGennedRelationship = subjectAreaOmasREST.updatePreferredTermRelationship(userId, gennedRelationship);
            PreferredTerm updatedRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.PreferredTermMapper.mapOMRSRelationshipBeanToPreferredTerm(updatedGennedRelationship);
            response = new PreferredTermRelationshipResponse(updatedRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updatePreferredTermRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deletePreferredTermRelationship(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deletePreferredTermRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deletePreferredTermRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "deletePreferredTermRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"deletePreferredTermRelationship", (String)guid, (String)"guid");
            if (isPurge.booleanValue()) {
                subjectAreaOmasREST.purgeRelationshipById(userId, guid, "PreferredTerm");
                response = new VoidResponse();
            } else {
                Relationship omrsRelationship = subjectAreaOmasREST.deleteRelationshipById(userId, guid, "PreferredTerm");
                org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.PreferredTerm.PreferredTerm deletedRelationshipBean = PreferredTermMapper.mapOmrsRelationshipToPreferredTerm(omrsRelationship);
                PreferredTerm deletedRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.PreferredTermMapper.mapOMRSRelationshipBeanToPreferredTerm(deletedRelationshipBean);
                response = new PreferredTermRelationshipResponse(deletedRelationship);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (RelationshipNotDeletedException e) {
            response = OMASExceptionToResponse.convertRelationshipNotDeletedException((RelationshipNotDeletedException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotPurgedException e) {
            response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deletePreferredTermRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restorePreferredTerm(String serverName, String userId, String guid) {
        String methodName = "restorePreferredTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restorePreferredTerm,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "restorePreferredTerm");
            InputValidator.validateGUIDNotNull((String)className, (String)"restorePreferredTerm", (String)guid, (String)"guid");
            Relationship omrsRelationship = this.oMRSAPIHelper.callOMRSRestoreRelationship(userId, guid);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.PreferredTerm.PreferredTerm restoredRelationshipBean = PreferredTermMapper.mapOmrsRelationshipToPreferredTerm(omrsRelationship);
            PreferredTerm restoredRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.PreferredTermMapper.mapOMRSRelationshipBeanToPreferredTerm(restoredRelationshipBean);
            response = new PreferredTermRelationshipResponse(restoredRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotDeletedException e) {
            response = OMASExceptionToResponse.convertGUIDNotDeletedException((GUIDNotDeletedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restorePreferredTerm,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse createValidValue(String serverName, String userId, ValidValue validValueRelationship) {
        String methodName = "ValidValue";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: ValidValue,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        Object createdValidValue = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, validValueRelationship.getEffectiveFromTime(), validValueRelationship.getEffectiveToTime(), "ValidValue");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ValidValue.ValidValue gennedRelationship = ValidValueMapper.mapValidValueToOMRSRelationshipBean(validValueRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ValidValue.ValidValue createdGennedRelationship = subjectAreaOmasREST.createValidValueRelationship(userId, gennedRelationship);
            ValidValue createdRelationship = ValidValueMapper.mapOMRSRelationshipBeanToValidValue(createdGennedRelationship);
            response = new ValidValueRelationshipResponse(createdRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : ValidValue,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getValidValueRelationship(String serverName, String userId, String guid) {
        String methodName = "getValidValueRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getValidValueRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getValidValueRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"getValidValueRelationship", (String)guid, (String)"guid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ValidValue.ValidValue relationshipBean = subjectAreaOmasREST.getValidValueRelationshipByGuid(userId, guid);
            ValidValue validValue = ValidValueMapper.mapOMRSRelationshipBeanToValidValue(relationshipBean);
            response = new ValidValueRelationshipResponse(validValue);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getValidValueRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateValidValueRelationship(String serverName, String userId, ValidValue validValueRelationship, boolean isReplace) {
        String methodName = "updateValidValueRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateValidValueRelationship,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        String relationshipGuid = validValueRelationship.getGuid();
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "updateValidValueRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"updateValidValueRelationship", (String)relationshipGuid, (String)"relationshipGuid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ValidValue.ValidValue existingRelationship = subjectAreaOmasREST.getValidValueRelationshipByGuid(userId, relationshipGuid);
            if (!isReplace) {
                if (validValueRelationship.getDescription() == null) {
                    validValueRelationship.setDescription(existingRelationship.getDescription());
                }
                if (validValueRelationship.getSource() == null) {
                    validValueRelationship.setSource(existingRelationship.getSource());
                }
                if (validValueRelationship.getStatus() == null) {
                    validValueRelationship.setStatus(existingRelationship.getStatus());
                }
                if (validValueRelationship.getSteward() == null) {
                    validValueRelationship.setSteward(existingRelationship.getSteward());
                }
                if (validValueRelationship.getExpression() == null) {
                    validValueRelationship.setExpression(existingRelationship.getExpression());
                }
            }
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ValidValue.ValidValue gennedRelationship = ValidValueMapper.mapValidValueToOMRSRelationshipBean(validValueRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ValidValue.ValidValue updatedGennedRelationship = subjectAreaOmasREST.updateValidValueRelationship(userId, gennedRelationship);
            ValidValue updatedRelationship = ValidValueMapper.mapOMRSRelationshipBeanToValidValue(updatedGennedRelationship);
            response = new ValidValueRelationshipResponse(updatedRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateValidValueRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteValidValueRelationship(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteValidValueRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteValidValueRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "deleteValidValueRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteValidValueRelationship", (String)guid, (String)"guid");
            if (isPurge.booleanValue()) {
                subjectAreaOmasREST.purgeRelationshipById(userId, guid, "ValidValue");
                response = new VoidResponse();
            } else {
                Relationship omrsRelationship = subjectAreaOmasREST.deleteRelationshipById(userId, guid, "ValidValue");
                org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ValidValue.ValidValue deletedRelationshipBean = org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ValidValue.ValidValueMapper.mapOmrsRelationshipToValidValue(omrsRelationship);
                ValidValue deletedRelationship = ValidValueMapper.mapOMRSRelationshipBeanToValidValue(deletedRelationshipBean);
                response = new ValidValueRelationshipResponse(deletedRelationship);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (RelationshipNotDeletedException e) {
            response = OMASExceptionToResponse.convertRelationshipNotDeletedException((RelationshipNotDeletedException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotPurgedException e) {
            response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteValidValueRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreValidValue(String serverName, String userId, String guid) {
        String methodName = "restoreValidValue";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreValidValue,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "restoreValidValue");
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreValidValue", (String)guid, (String)"guid");
            Relationship omrsRelationship = this.oMRSAPIHelper.callOMRSRestoreRelationship(userId, guid);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ValidValue.ValidValue restoredRelationshipBean = org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ValidValue.ValidValueMapper.mapOmrsRelationshipToValidValue(omrsRelationship);
            ValidValue restoredRelationship = ValidValueMapper.mapOMRSRelationshipBeanToValidValue(restoredRelationshipBean);
            response = new ValidValueRelationshipResponse(restoredRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotDeletedException e) {
            response = OMASExceptionToResponse.convertGUIDNotDeletedException((GUIDNotDeletedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreValidValue,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse createReplacementTerm(String serverName, String userId, ReplacementTerm replacementTermRelationship) {
        String methodName = "ReplacementTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: ReplacementTerm,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        Object createdReplacementTerm = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, replacementTermRelationship.getEffectiveFromTime(), replacementTermRelationship.getEffectiveToTime(), "ReplacementTerm");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReplacementTerm.ReplacementTerm gennedRelationship = TermReplacementMapper.mapReplacementTermToOMRSRelationshipBean(replacementTermRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReplacementTerm.ReplacementTerm createdGennedRelationship = subjectAreaOmasREST.createReplacementTermRelationship(userId, gennedRelationship);
            ReplacementTerm createdRelationship = TermReplacementMapper.mapOMRSRelationshipBeanToReplacementTerm(createdGennedRelationship);
            response = new ReplacementRelationshipResponse(createdRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : ReplacementTerm,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getReplacementTermRelationship(String serverName, String userId, String guid) {
        String methodName = "getReplacementTermRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getReplacementTermRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getReplacementTermRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"getReplacementTermRelationship", (String)guid, (String)"guid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReplacementTerm.ReplacementTerm relationshipBean = subjectAreaOmasREST.getReplacementTermRelationshipByGuid(userId, guid);
            ReplacementTerm replacementTerm = TermReplacementMapper.mapOMRSRelationshipBeanToReplacementTerm(relationshipBean);
            response = new ReplacementRelationshipResponse(replacementTerm);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getReplacementTermRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateReplacementTermRelationship(String serverName, String userId, ReplacementTerm replacementTermRelationship, boolean isReplace) {
        String methodName = "updateReplacementTermRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateReplacementTermRelationship,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        String relationshipGuid = replacementTermRelationship.getGuid();
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, replacementTermRelationship.getEffectiveFromTime(), replacementTermRelationship.getEffectiveToTime(), "updateReplacementTermRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"updateReplacementTermRelationship", (String)relationshipGuid, (String)"relationshipGuid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReplacementTerm.ReplacementTerm existingRelationship = subjectAreaOmasREST.getReplacementTermRelationshipByGuid(userId, relationshipGuid);
            if (!isReplace) {
                if (replacementTermRelationship.getDescription() == null) {
                    replacementTermRelationship.setDescription(existingRelationship.getDescription());
                }
                if (replacementTermRelationship.getSource() == null) {
                    replacementTermRelationship.setSource(existingRelationship.getSource());
                }
                if (replacementTermRelationship.getStatus() == null) {
                    replacementTermRelationship.setStatus(existingRelationship.getStatus());
                }
                if (replacementTermRelationship.getSteward() == null) {
                    replacementTermRelationship.setSteward(existingRelationship.getSteward());
                }
                if (replacementTermRelationship.getExpression() == null) {
                    replacementTermRelationship.setExpression(existingRelationship.getExpression());
                }
            }
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReplacementTerm.ReplacementTerm gennedRelationship = TermReplacementMapper.mapReplacementTermToOMRSRelationshipBean(replacementTermRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReplacementTerm.ReplacementTerm updatedGennedRelationship = subjectAreaOmasREST.updateReplacementTermRelationship(userId, gennedRelationship);
            ReplacementTerm updatedRelationship = TermReplacementMapper.mapOMRSRelationshipBeanToReplacementTerm(updatedGennedRelationship);
            response = new ReplacementRelationshipResponse(updatedRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateReplacementTermRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteReplacementTermRelationship(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteReplacementTermRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteReplacementTermRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "deleteReplacementTermRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteReplacementTermRelationship", (String)guid, (String)"guid");
            if (isPurge.booleanValue()) {
                subjectAreaOmasREST.purgeRelationshipById(userId, guid, "ReplacementTerm");
                response = new VoidResponse();
            } else {
                Relationship omrsRelationship = subjectAreaOmasREST.deleteRelationshipById(userId, guid, "ReplacementTerm");
                org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReplacementTerm.ReplacementTerm deletedRelationshipBean = ReplacementTermMapper.mapOmrsRelationshipToReplacementTerm(omrsRelationship);
                ReplacementTerm deletedRelationship = TermReplacementMapper.mapOMRSRelationshipBeanToReplacementTerm(deletedRelationshipBean);
                response = new ReplacementRelationshipResponse(deletedRelationship);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (RelationshipNotDeletedException e) {
            response = OMASExceptionToResponse.convertRelationshipNotDeletedException((RelationshipNotDeletedException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotPurgedException e) {
            response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteReplacementTermRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreReplacementTerm(String serverName, String userId, String guid) {
        String methodName = "restoreReplacementTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreReplacementTerm,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "restoreReplacementTerm");
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreReplacementTerm", (String)guid, (String)"guid");
            Relationship omrsRelationship = this.oMRSAPIHelper.callOMRSRestoreRelationship(userId, guid);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReplacementTerm.ReplacementTerm restoredRelationshipBean = ReplacementTermMapper.mapOmrsRelationshipToReplacementTerm(omrsRelationship);
            ReplacementTerm restoredRelationship = TermReplacementMapper.mapOMRSRelationshipBeanToReplacementTerm(restoredRelationshipBean);
            response = new ReplacementRelationshipResponse(restoredRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotDeletedException e) {
            response = OMASExceptionToResponse.convertGUIDNotDeletedException((GUIDNotDeletedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreReplacementTerm,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse createTermTYPEDBYRelationship(String serverName, String userId, TermTYPEDBYRelationship termTYPEDBYRelationship) {
        String methodName = "TermTYPEDBYRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: TermTYPEDBYRelationship,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, termTYPEDBYRelationship.getEffectiveFromTime(), termTYPEDBYRelationship.getEffectiveToTime(), "TermTYPEDBYRelationship");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermTYPEDBYRelationship.TermTYPEDBYRelationship gennedRelationship = TypedByMapper.mapTermTYPEDBYRelationshipToOMRSRelationshipBean(termTYPEDBYRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermTYPEDBYRelationship.TermTYPEDBYRelationship createdGennedRelationship = subjectAreaOmasREST.createTermTYPEDBYRelationshipRelationship(userId, gennedRelationship);
            TermTYPEDBYRelationship createdRelationship = TypedByMapper.mapOMRSRelationshipBeanToTermTYPEDBYRelationship(createdGennedRelationship);
            response = new TermTYPEDBYRelationshipResponse(createdRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : TermTYPEDBYRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getTermTYPEDBYRelationship(String serverName, String userId, String guid) {
        String methodName = "getTermTYPEDBYRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getTermTYPEDBYRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getTermTYPEDBYRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"getTermTYPEDBYRelationship", (String)guid, (String)"guid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermTYPEDBYRelationship.TermTYPEDBYRelationship relationshipBean = subjectAreaOmasREST.getTermTYPEDBYRelationshipRelationshipByGuid(userId, guid);
            TermTYPEDBYRelationship termTYPEDBYRelationship = TypedByMapper.mapOMRSRelationshipBeanToTermTYPEDBYRelationship(relationshipBean);
            response = new TermTYPEDBYRelationshipResponse(termTYPEDBYRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTermTYPEDBYRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateTermTYPEDBYRelationship(String serverName, String userId, TermTYPEDBYRelationship termTYPEDBYRelationshipRelationship, boolean isReplace) {
        String methodName = "updateTermTYPEDBYRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateTermTYPEDBYRelationship,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        String relationshipGuid = termTYPEDBYRelationshipRelationship.getGuid();
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, termTYPEDBYRelationshipRelationship.getEffectiveFromTime(), termTYPEDBYRelationshipRelationship.getEffectiveToTime(), "updateTermTYPEDBYRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"updateTermTYPEDBYRelationship", (String)relationshipGuid, (String)"relationshipGuid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermTYPEDBYRelationship.TermTYPEDBYRelationship existingRelationship = subjectAreaOmasREST.getTermTYPEDBYRelationshipRelationshipByGuid(userId, relationshipGuid);
            if (!isReplace) {
                if (termTYPEDBYRelationshipRelationship.getDescription() == null) {
                    termTYPEDBYRelationshipRelationship.setDescription(existingRelationship.getDescription());
                }
                if (termTYPEDBYRelationshipRelationship.getSource() == null) {
                    termTYPEDBYRelationshipRelationship.setSource(existingRelationship.getSource());
                }
                if (termTYPEDBYRelationshipRelationship.getStatus() == null) {
                    termTYPEDBYRelationshipRelationship.setStatus(existingRelationship.getStatus());
                }
                if (termTYPEDBYRelationshipRelationship.getSteward() == null) {
                    termTYPEDBYRelationshipRelationship.setSteward(existingRelationship.getSteward());
                }
            }
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermTYPEDBYRelationship.TermTYPEDBYRelationship gennedRelationship = TypedByMapper.mapTermTYPEDBYRelationshipToOMRSRelationshipBean(termTYPEDBYRelationshipRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermTYPEDBYRelationship.TermTYPEDBYRelationship updatedGennedRelationship = subjectAreaOmasREST.updateTermTYPEDBYRelationshipRelationship(userId, gennedRelationship);
            TermTYPEDBYRelationship updatedRelationship = TypedByMapper.mapOMRSRelationshipBeanToTermTYPEDBYRelationship(updatedGennedRelationship);
            response = new TermTYPEDBYRelationshipResponse(updatedRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTermTYPEDBYRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteTermTYPEDBYRelationship(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteTermTYPEDBYRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteTermTYPEDBYRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "deleteTermTYPEDBYRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteTermTYPEDBYRelationship", (String)guid, (String)"guid");
            if (isPurge.booleanValue()) {
                subjectAreaOmasREST.purgeRelationshipById(userId, guid, "TermTYPEDBYRelationship");
                response = new VoidResponse();
            } else {
                Relationship omrsRelationship = subjectAreaOmasREST.deleteRelationshipById(userId, guid, "TermTYPEDBYRelationship");
                org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermTYPEDBYRelationship.TermTYPEDBYRelationship deletedRelationshipBean = TermTYPEDBYRelationshipMapper.mapOmrsRelationshipToTermTYPEDBYRelationship(omrsRelationship);
                TermTYPEDBYRelationship deletedRelationship = TypedByMapper.mapOMRSRelationshipBeanToTermTYPEDBYRelationship(deletedRelationshipBean);
                response = new TermTYPEDBYRelationshipResponse(deletedRelationship);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (RelationshipNotDeletedException e) {
            response = OMASExceptionToResponse.convertRelationshipNotDeletedException((RelationshipNotDeletedException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotPurgedException e) {
            response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteTermTYPEDBYRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreTermTYPEDBYRelationship(String serverName, String userId, String guid) {
        String methodName = "restoreTermTYPEDBYRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreTermTYPEDBYRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "restoreTermTYPEDBYRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreTermTYPEDBYRelationship", (String)guid, (String)"guid");
            Relationship omrsRelationship = this.oMRSAPIHelper.callOMRSRestoreRelationship(userId, guid);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermTYPEDBYRelationship.TermTYPEDBYRelationship restoredRelationshipBean = TermTYPEDBYRelationshipMapper.mapOmrsRelationshipToTermTYPEDBYRelationship(omrsRelationship);
            TermTYPEDBYRelationship restoredRelationship = TypedByMapper.mapOMRSRelationshipBeanToTermTYPEDBYRelationship(restoredRelationshipBean);
            response = new TermTYPEDBYRelationshipResponse(restoredRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotDeletedException e) {
            response = OMASExceptionToResponse.convertGUIDNotDeletedException((GUIDNotDeletedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreTermTYPEDBYRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse createISARelationship(String serverName, String userId, ISARelationship iSARelationship) {
        String methodName = "ISARelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: ISARelationship,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        Object createdISARelationship = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, iSARelationship.getEffectiveFromTime(), iSARelationship.getEffectiveFromTime(), "ISARelationship");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ISARelationship.ISARelationship gennedRelationship = IsaMapper.mapISARelationshipToOMRSRelationshipBean(iSARelationship);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ISARelationship.ISARelationship createdGennedRelationship = subjectAreaOmasREST.createISARelationshipRelationship(userId, gennedRelationship);
            ISARelationship createdRelationship = IsaMapper.mapOMRSRelationshipBeanToISARelationship(createdGennedRelationship);
            response = new TermISARelationshipResponse(createdRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : ISARelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getISARelationship(String serverName, String userId, String guid) {
        String methodName = "getISARelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getISARelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getISARelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"getISARelationship", (String)guid, (String)"guid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ISARelationship.ISARelationship relationshipBean = subjectAreaOmasREST.getISARelationshipRelationshipByGuid(userId, guid);
            ISARelationship iSARelationship = IsaMapper.mapOMRSRelationshipBeanToISARelationship(relationshipBean);
            response = new TermISARelationshipResponse(iSARelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getISARelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateISARelationship(String serverName, String userId, ISARelationship iSARelationshipRelationship, boolean isReplace) {
        String methodName = "updateISARelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateISARelationship,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        String relationshipGuid = iSARelationshipRelationship.getGuid();
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, iSARelationshipRelationship.getEffectiveFromTime(), iSARelationshipRelationship.getEffectiveToTime(), "updateISARelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"updateISARelationship", (String)relationshipGuid, (String)"relationshipGuid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ISARelationship.ISARelationship existingRelationship = subjectAreaOmasREST.getISARelationshipRelationshipByGuid(userId, relationshipGuid);
            if (!isReplace) {
                if (iSARelationshipRelationship.getDescription() == null) {
                    iSARelationshipRelationship.setDescription(existingRelationship.getDescription());
                }
                if (iSARelationshipRelationship.getSource() == null) {
                    iSARelationshipRelationship.setSource(existingRelationship.getSource());
                }
                if (iSARelationshipRelationship.getStatus() == null) {
                    iSARelationshipRelationship.setStatus(existingRelationship.getStatus());
                }
                if (iSARelationshipRelationship.getSteward() == null) {
                    iSARelationshipRelationship.setSteward(existingRelationship.getSteward());
                }
                if (iSARelationshipRelationship.getExpression() == null) {
                    iSARelationshipRelationship.setExpression(existingRelationship.getExpression());
                }
            }
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ISARelationship.ISARelationship gennedRelationship = IsaMapper.mapISARelationshipToOMRSRelationshipBean(iSARelationshipRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ISARelationship.ISARelationship updatedGennedRelationship = subjectAreaOmasREST.updateISARelationshipRelationship(userId, gennedRelationship);
            ISARelationship updatedRelationship = IsaMapper.mapOMRSRelationshipBeanToISARelationship(updatedGennedRelationship);
            response = new TermISARelationshipResponse(updatedRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateISARelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteISARelationship(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteISARelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteISARelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "deleteISARelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteISARelationship", (String)guid, (String)"guid");
            if (isPurge.booleanValue()) {
                subjectAreaOmasREST.purgeRelationshipById(userId, guid, "ISARelationship");
                response = new VoidResponse();
            } else {
                Relationship omrsRelationship = subjectAreaOmasREST.deleteRelationshipById(userId, guid, "ISARelationship");
                org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ISARelationship.ISARelationship deletedRelationshipBean = ISARelationshipMapper.mapOmrsRelationshipToISARelationship(omrsRelationship);
                ISARelationship deletedRelationship = IsaMapper.mapOMRSRelationshipBeanToISARelationship(deletedRelationshipBean);
                response = new TermISARelationshipResponse(deletedRelationship);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (RelationshipNotDeletedException e) {
            response = OMASExceptionToResponse.convertRelationshipNotDeletedException((RelationshipNotDeletedException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotPurgedException e) {
            response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteISARelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreISARelationship(String serverName, String userId, String guid) {
        String methodName = "restoreISARelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreISARelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "restoreISARelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreISARelationship", (String)guid, (String)"guid");
            Relationship omrsRelationship = this.oMRSAPIHelper.callOMRSRestoreRelationship(userId, guid);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ISARelationship.ISARelationship deletedRelationshipBean = ISARelationshipMapper.mapOmrsRelationshipToISARelationship(omrsRelationship);
            ISARelationship deletedRelationship = IsaMapper.mapOMRSRelationshipBeanToISARelationship(deletedRelationshipBean);
            response = new TermISARelationshipResponse(deletedRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotDeletedException e) {
            response = OMASExceptionToResponse.convertGUIDNotDeletedException((GUIDNotDeletedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreISARelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse createTermISATypeOFRelationship(String serverName, String userId, TermISATypeOFRelationship termISATypeOFRelationship) {
        String methodName = "TermISATypeOFRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: TermISATypeOFRelationship,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        Object createdTermISATypeOFRelationship = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, termISATypeOFRelationship.getEffectiveFromTime(), termISATypeOFRelationship.getEffectiveToTime(), "TermISATypeOFRelationship");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermISATypeOFRelationship.TermISATypeOFRelationship gennedRelationship = IsaTypeOfMapper.mapTermISATypeOFRelationshipToOMRSRelationshipBean(termISATypeOFRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermISATypeOFRelationship.TermISATypeOFRelationship createdGennedRelationship = subjectAreaOmasREST.createTermISATypeOFRelationshipRelationship(userId, gennedRelationship);
            TermISATypeOFRelationship createdRelationship = IsaTypeOfMapper.mapOMRSRelationshipBeanToTermISATypeOFRelationship(createdGennedRelationship);
            response = new TermISATYPEOFRelationshipResponse(createdRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : TermISATypeOFRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getTermISATypeOFRelationship(String serverName, String userId, String guid) {
        String methodName = "getTermISATypeOFRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getTermISATypeOFRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getTermISATypeOFRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"getTermISATypeOFRelationship", (String)guid, (String)"guid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermISATypeOFRelationship.TermISATypeOFRelationship relationshipBean = subjectAreaOmasREST.getTermISATypeOFRelationshipRelationshipByGuid(userId, guid);
            TermISATypeOFRelationship termISATypeOFRelationship = IsaTypeOfMapper.mapOMRSRelationshipBeanToTermISATypeOFRelationship(relationshipBean);
            response = new TermISATYPEOFRelationshipResponse(termISATypeOFRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTermISATypeOFRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateTermISATypeOFRelationship(String serverName, String userId, TermISATypeOFRelationship termISATypeOFRelationshipRelationship, boolean isReplace) {
        String methodName = "updateTermISATypeOFRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateTermISATypeOFRelationship,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        String relationshipGuid = termISATypeOFRelationshipRelationship.getGuid();
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, termISATypeOFRelationshipRelationship.getEffectiveFromTime(), termISATypeOFRelationshipRelationship.getEffectiveToTime(), "updateTermISATypeOFRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"updateTermISATypeOFRelationship", (String)relationshipGuid, (String)"relationshipGuid");
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermISATypeOFRelationship.TermISATypeOFRelationship existingRelationship = subjectAreaOmasREST.getTermISATypeOFRelationshipRelationshipByGuid(userId, relationshipGuid);
            if (!isReplace) {
                if (termISATypeOFRelationshipRelationship.getDescription() == null) {
                    termISATypeOFRelationshipRelationship.setDescription(existingRelationship.getDescription());
                }
                if (termISATypeOFRelationshipRelationship.getSource() == null) {
                    termISATypeOFRelationshipRelationship.setSource(existingRelationship.getSource());
                }
                if (termISATypeOFRelationshipRelationship.getStatus() == null) {
                    termISATypeOFRelationshipRelationship.setStatus(existingRelationship.getStatus());
                }
                if (termISATypeOFRelationshipRelationship.getSteward() == null) {
                    termISATypeOFRelationshipRelationship.setSteward(existingRelationship.getSteward());
                }
            }
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermISATypeOFRelationship.TermISATypeOFRelationship gennedRelationship = IsaTypeOfMapper.mapTermISATypeOFRelationshipToOMRSRelationshipBean(termISATypeOFRelationshipRelationship);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermISATypeOFRelationship.TermISATypeOFRelationship updatedGennedRelationship = subjectAreaOmasREST.updateTermISATypeOFRelationshipRelationship(userId, gennedRelationship);
            TermISATypeOFRelationship updatedRelationship = IsaTypeOfMapper.mapOMRSRelationshipBeanToTermISATypeOFRelationship(updatedGennedRelationship);
            response = new TermISATYPEOFRelationshipResponse(updatedRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTermISATypeOFRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteIsATypeOfRelationship(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteIsATypeOfRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteIsATypeOfRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "deleteIsATypeOfRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteIsATypeOfRelationship", (String)guid, (String)"guid");
            if (isPurge.booleanValue()) {
                subjectAreaOmasREST.purgeRelationshipById(userId, guid, "TermISATypeOFRelationship");
                response = new VoidResponse();
            } else {
                Relationship omrsRelationship = subjectAreaOmasREST.deleteRelationshipById(userId, guid, "TermISATypeOFRelationship");
                org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermISATypeOFRelationship.TermISATypeOFRelationship deletedRelationshipBean = TermISATypeOFRelationshipMapper.mapOmrsRelationshipToTermISATypeOFRelationship(omrsRelationship);
                TermISATypeOFRelationship deletedRelationship = IsaTypeOfMapper.mapOMRSRelationshipBeanToTermISATypeOFRelationship(deletedRelationshipBean);
                response = new TermISATYPEOFRelationshipResponse(deletedRelationship);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (RelationshipNotDeletedException e) {
            response = OMASExceptionToResponse.convertRelationshipNotDeletedException((RelationshipNotDeletedException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotPurgedException e) {
            response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteIsATypeOfRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreTermISATypeOF(String serverName, String userId, String guid) {
        String methodName = "restoreTermISATypeOF";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreTermISATypeOF,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "restoreTermISATypeOF");
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreTermISATypeOF", (String)guid, (String)"guid");
            Relationship omrsRelationship = this.oMRSAPIHelper.callOMRSRestoreRelationship(userId, guid);
            org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermISATypeOFRelationship.TermISATypeOFRelationship deletedRelationshipBean = TermISATypeOFRelationshipMapper.mapOmrsRelationshipToTermISATypeOFRelationship(omrsRelationship);
            TermISATypeOFRelationship deletedRelationship = IsaTypeOfMapper.mapOMRSRelationshipBeanToTermISATypeOFRelationship(deletedRelationshipBean);
            response = new TermISATYPEOFRelationshipResponse(deletedRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotDeletedException e) {
            response = OMASExceptionToResponse.convertGUIDNotDeletedException((GUIDNotDeletedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreTermISATypeOF,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse createTermCategorization(String serverName, String userId, TermCategorizationRelationship termCategorizationRelationship) {
        String methodName = "createTermCategorization";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createTermCategorization,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, termCategorizationRelationship.getEffectiveFromTime(), termCategorizationRelationship.getEffectiveToTime(), "createTermCategorization");
            TermCategorization gennedRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermCategorizationMapper.mapTermCategorizationToOMRSRelationshipBean(termCategorizationRelationship);
            TermCategorization createdGennedRelationship = subjectAreaOmasREST.createTermCategorizationRelationship(userId, gennedRelationship);
            TermCategorizationRelationship createdRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermCategorizationMapper.mapOMRSRelationshipBeanToTermCategorization(createdGennedRelationship);
            response = new TermCategorizationRelationshipResponse(createdRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createTermCategorization,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getTermCategorizationRelationship(String serverName, String userId, String guid) {
        String methodName = "getTermCategorizationRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getTermCategorizationRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getTermCategorizationRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"getTermCategorizationRelationship", (String)guid, (String)"guid");
            TermCategorization relationshipBean = subjectAreaOmasREST.getTermCategorizationRelationshipByGuid(userId, guid);
            TermCategorizationRelationship termCategorization = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermCategorizationMapper.mapOMRSRelationshipBeanToTermCategorization(relationshipBean);
            response = new TermCategorizationRelationshipResponse(termCategorization);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTermCategorizationRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateTermCategorizationRelationship(String serverName, String userId, TermCategorizationRelationship termCategorizationRelationship, Boolean isReplace) {
        String methodName = "updateTermCategorizationRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateTermCategorizationRelationship,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        String relationshipGuid = termCategorizationRelationship.getGuid();
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, termCategorizationRelationship.getEffectiveFromTime(), termCategorizationRelationship.getEffectiveToTime(), "updateTermCategorizationRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"updateTermCategorizationRelationship", (String)relationshipGuid, (String)"relationshipGuid");
            TermCategorization existingRelationship = subjectAreaOmasREST.getTermCategorizationRelationshipByGuid(userId, relationshipGuid);
            if (!isReplace.booleanValue()) {
                if (termCategorizationRelationship.getDescription() == null) {
                    termCategorizationRelationship.setDescription(existingRelationship.getDescription());
                }
                if (termCategorizationRelationship.getStatus() == null) {
                    termCategorizationRelationship.setStatus(existingRelationship.getStatus());
                }
            }
            TermCategorization gennedRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermCategorizationMapper.mapTermCategorizationToOMRSRelationshipBean(termCategorizationRelationship);
            TermCategorization updatedGennedRelationship = subjectAreaOmasREST.updateTermCategorizationRelationship(userId, gennedRelationship);
            TermCategorizationRelationship updatedRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermCategorizationMapper.mapOMRSRelationshipBeanToTermCategorization(updatedGennedRelationship);
            response = new TermCategorizationRelationshipResponse(updatedRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotSupportedException((StatusNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTermCategorizationRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteTermCategorizationRelationship(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteTermCategorizationRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteTermCategorizationRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "deleteTermCategorizationRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteTermCategorizationRelationship", (String)guid, (String)"guid");
            if (isPurge.booleanValue()) {
                subjectAreaOmasREST.purgeRelationshipById(userId, guid, "TermCategorization");
                response = new VoidResponse();
            } else {
                Relationship omrsRelationship = subjectAreaOmasREST.deleteRelationshipById(userId, guid, "TermCategorization");
                TermCategorization deletedRelationshipBean = TermCategorizationMapper.mapOmrsRelationshipToTermCategorization(omrsRelationship);
                TermCategorizationRelationship deletedRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermCategorizationMapper.mapOMRSRelationshipBeanToTermCategorization(deletedRelationshipBean);
                response = new TermCategorizationRelationshipResponse(deletedRelationship);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (RelationshipNotDeletedException e) {
            response = OMASExceptionToResponse.convertRelationshipNotDeletedException((RelationshipNotDeletedException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotPurgedException e) {
            response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteTermCategorizationRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreTermCategorizationRelationship(String serverName, String userId, String guid) {
        String methodName = "restoreTermCategorization";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreTermCategorization,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "restoreTermCategorization");
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreTermCategorization", (String)guid, (String)"guid");
            Relationship omrsRelationship = this.oMRSAPIHelper.callOMRSRestoreRelationship(userId, guid);
            TermCategorization restoredRelationshipBean = TermCategorizationMapper.mapOmrsRelationshipToTermCategorization(omrsRelationship);
            TermCategorizationRelationship restoredRelationship = org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermCategorizationMapper.mapOMRSRelationshipBeanToTermCategorization(restoredRelationshipBean);
            response = new TermCategorizationRelationshipResponse(restoredRelationship);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotDeletedException e) {
            response = OMASExceptionToResponse.convertGUIDNotDeletedException((GUIDNotDeletedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreTermCategorization,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getSemanticAssignmentRelationship(String serverName, String userId, String guid) {
        String methodName = "getSemanticAssignmentRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getSemanticAssignmentRelationship,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getSemanticAssignmentRelationship");
            InputValidator.validateGUIDNotNull((String)className, (String)"getSemanticAssignmentRelationship", (String)guid, (String)"guid");
            SemanticAssignment relationshipBean = subjectAreaOmasREST.getSemanticAssignmentRelationshipByGuid(userId, guid);
            org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.SemanticAssignment semanticAssignment = SemanticAssignmentMapper.mapOMRSRelationshipBeanToSemanticAssignment(relationshipBean);
            response = new SemanticAssignementRelationshipResponse(semanticAssignment);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getSemanticAssignmentRelationship,userId=" + userId + ", response=" + response);
        }
        return response;
    }
}

