/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.accessservices.subjectarea.initialization.SubjectAreaRegistration;
import org.odpi.openmetadata.accessservices.subjectarea.initialization.SubjectAreaServicesInstanceMap;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.adminservices.OMAGAccessServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistration;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaServicesInstance {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaServicesInstance.class);
    private static final String className = SubjectAreaServicesInstance.class.getName();
    private OMRSRepositoryConnector repositoryConnector = null;
    private OMRSMetadataCollection metadataCollection = null;
    private String serverName = null;
    private AccessServiceDescription myDescription = AccessServiceDescription.SUBJECT_AREA_OMAS;
    protected OMRSAPIHelper oMRSAPIHelper = new OMRSAPIHelper();

    public SubjectAreaServicesInstance(OMRSRepositoryConnector repositoryConnector) throws NewInstanceException {
        String methodName = "new SubjectAreaRESTServicesInstance";
        if (repositoryConnector != null) {
            try {
                this.repositoryConnector = repositoryConnector;
                this.serverName = repositoryConnector.getServerName();
                this.metadataCollection = repositoryConnector.getMetadataCollection();
                SubjectAreaServicesInstanceMap.setNewInstanceForJVM(this.serverName, this);
            }
            catch (Throwable error) {
                SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.OMRS_NOT_INITIALIZED;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"new SubjectAreaRESTServicesInstance"});
                throw new NewInstanceException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "new SubjectAreaRESTServicesInstance", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        } else {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"new SubjectAreaRESTServicesInstance"});
            throw new NewInstanceException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "new SubjectAreaRESTServicesInstance", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public String getServerName() throws NewInstanceException {
        String methodName = "getServerName";
        if (this.serverName != null) {
            return this.serverName;
        }
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.OMRS_NOT_AVAILABLE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getServerName"});
        throw new NewInstanceException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getServerName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public void setOMRSAPIHelper(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
    }

    public OMRSRepositoryConnector getRepositoryConnector() {
        return this.repositoryConnector;
    }

    public SubjectAreaServicesInstance() {
        boolean initialized = false;
        List registeredServices = OMAGAccessServiceRegistration.getAccessServiceRegistrationList();
        for (AccessServiceRegistration accessServiceRegistration : registeredServices) {
            if (AccessServiceDescription.SUBJECT_AREA_OMAS.getAccessServiceCode() != accessServiceRegistration.getAccessServiceCode()) continue;
            initialized = true;
        }
        if (!initialized) {
            SubjectAreaRegistration.registerAccessService();
        }
    }

    public void shutdown() {
        SubjectAreaServicesInstanceMap.removeInstanceForJVM(this.serverName);
    }

    public String getAccessServiceName() {
        return "Subject Area Open Metadata Access Services";
    }

    public OMRSMetadataCollection getMetadataCollection() {
        return this.metadataCollection;
    }
}

