/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryTerm.GlossaryTerm;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryTerm.GlossaryTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermAnchor.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.generated.server.SubjectAreaBeansToAccessOMRS;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.AbstractConcept;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.ActivityDescription;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Confidence;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Confidentiality;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.ContextDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Criticality;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.DataValue;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.ObjectIdentifier;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Retention;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.SpineAttribute;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.SpineObject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.GovernanceActions;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.IconSummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.TermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaGlossaryRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.ClassificationGroupByOperation;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.TypeGuids;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.accessservices.subjectarea.validators.RestValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaTermRESTServices
extends SubjectAreaRESTServicesInstance {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaTermRESTServices.class);
    private static final String className = SubjectAreaTermRESTServices.class.getName();
    public static final Set<String> SUBJECT_AREA_TERM_CLASSIFICATIONS = new HashSet<String>(Arrays.asList(SpineObject.class.getSimpleName(), SpineAttribute.class.getSimpleName(), ObjectIdentifier.class.getSimpleName(), Confidentiality.class.getSimpleName(), Confidence.class.getSimpleName(), Criticality.class.getSimpleName(), Retention.class.getSimpleName(), AbstractConcept.class.getSimpleName(), ActivityDescription.class.getSimpleName(), DataValue.class.getSimpleName(), ContextDefinition.class.getSimpleName()));

    public SubjectAreaTermRESTServices() {
    }

    public SubjectAreaTermRESTServices(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
    }

    public SubjectAreaOMASAPIResponse createTerm(String serverName, String userId, Term suppliedTerm) {
        String methodName = "createTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createTerm,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        GlossaryTerm glossaryTerm = null;
        Glossary associatedGlossary = null;
        try {
            SubjectAreaBeansToAccessOMRS termRESTServices = this.initializeAPI(serverName, userId, suppliedTerm.getEffectiveFromTime(), suppliedTerm.getEffectiveToTime(), "createTerm");
            InputValidator.validateNodeType((Object[])new Object[]{className, "createTerm", suppliedTerm.getNodeType(), NodeType.Term});
            SubjectAreaGlossaryRESTServices glossaryRESTServices = new SubjectAreaGlossaryRESTServices();
            glossaryRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
            glossaryTerm = TermMapper.mapTermToOMRSBean(suppliedTerm);
            String suppliedTermName = suppliedTerm.getName();
            if (suppliedTermName == null || suppliedTermName.equals("")) {
                SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GLOSSARY_TERM_CREATE_WITHOUT_NAME;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "createTerm"});
                log.error(errorMessage);
                throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "createTerm", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            GlossarySummary suppliedGlossary = suppliedTerm.getGlossary();
            SubjectAreaOMASAPIResponse glossaryResponse = RestValidator.validateGlossarySummaryDuringCreation(serverName, userId, "createTerm", suppliedGlossary, glossaryRESTServices);
            if (glossaryResponse.getResponseCategory().equals((Object)ResponseCategory.Glossary)) {
                associatedGlossary = ((GlossaryResponse)glossaryResponse).getGlossary();
                GlossaryTerm newGlossaryTerm = termRESTServices.createGlossaryTerm(userId, glossaryTerm);
                String termGuid = newGlossaryTerm.getSystemAttributes().getGUID();
                String glossaryGuid = associatedGlossary.getSystemAttributes().getGUID();
                TermAnchor termAnchor = new TermAnchor();
                termAnchor.setEntity1Guid(glossaryGuid);
                termAnchor.setEntity2Guid(termGuid);
                termRESTServices.createTermAnchorRelationship(userId, termAnchor);
                response = this.getTermByGuid(serverName, userId, termGuid);
            } else {
                response = glossaryResponse;
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (ClassificationException e) {
            response = OMASExceptionToResponse.convertClassificationException((ClassificationException)e);
        }
        catch (StatusNotSupportedException e) {
            response = OMASExceptionToResponse.convertStatusNotsupportedException((StatusNotSupportedException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createTerm,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getTermByGuid(String serverName, String userId, String guid) {
        String methodName = "getTermByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getTermByGuid,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            Line glossaryRelationship;
            String anchorTypeGuid;
            Set<Line> glossaryRelationships;
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getTermByGuid");
            InputValidator.validateGUIDNotNull((String)className, (String)"getTermByGuid", (String)guid, (String)"guid");
            GlossaryTerm glossaryTerm = subjectAreaOmasREST.getGlossaryTermById(userId, guid);
            Term gotTerm = TermMapper.mapOMRSBeantoTerm(glossaryTerm);
            List<Classification> classifications = glossaryTerm.getClassifications();
            gotTerm.setClassifications(classifications);
            String mediaReferenceTypeGuid = TypeGuids.getMediaReferenceTypeGuid();
            Set<Line> mediaRelationships = subjectAreaOmasREST.getGlossaryRelationships(userId, guid, mediaReferenceTypeGuid, 0, null, null, null, 0);
            Set<IconSummary> icons = SubjectAreaUtils.getIconSummarySet(userId, subjectAreaOmasREST, mediaRelationships);
            if (icons != null) {
                gotTerm.setIcons(icons);
            }
            if ((glossaryRelationships = subjectAreaOmasREST.getGlossaryRelationships(userId, guid, anchorTypeGuid = TypeGuids.getTermAnchorTypeGuid(), 0, null, null, null, 0)).iterator().hasNext() && SubjectAreaUtils.isEffective(glossaryRelationship = glossaryRelationships.iterator().next())) {
                GlossarySummary glossarySummary = SubjectAreaUtils.getGlossarySummaryForTerm(userId, subjectAreaOmasREST, glossaryRelationship);
                gotTerm.setGlossary(glossarySummary);
            }
            response = new TermResponse(gotTerm);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException functionNotSupportedException) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTermByGuid,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getTermRelationships(String serverName, String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getTermRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getTermRelationships,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "getTermRelationships");
            InputValidator.validateGUIDNotNull((String)className, (String)"getTermRelationships", (String)guid, (String)"guid");
            subjectAreaOmasREST.getGlossaryTermById(userId, guid);
            response = this.getRelationshipsFromGuid(serverName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
        }
        catch (MetadataServerUncontactableException e) {
            OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UserNotAuthorizedException e) {
            OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTermRelationships,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse findTerm(String serverName, String userId, String searchCriteria, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: findTerm,userId=" + userId);
        }
        ArrayList<Term> terms = null;
        SubjectAreaOMASAPIResponse response = null;
        try {
            this.initializeAPI(serverName, userId, "findTerm");
            List<EntityDetail> entitydetails = OMRSAPIHelper.findEntitiesByType(this.oMRSAPIHelper, serverName, userId, "GlossaryTerm", searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty, "findTerm");
            if (entitydetails != null) {
                terms = new ArrayList<Term>();
                for (EntityDetail entityDetail : entitydetails) {
                    GlossaryTerm glossaryTerm = GlossaryTermMapper.mapOmrsEntityDetailToGlossaryTerm(entityDetail);
                    Term term = TermMapper.mapOMRSBeantoTerm(glossaryTerm);
                    terms.add(term);
                }
            }
            response = new TermsResponse(terms);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : findTerm,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateTerm(String serverName, String userId, String guid, Term suppliedTerm, boolean isReplace) {
        String methodName = "updateTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateTerm,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, suppliedTerm.getEffectiveFromTime(), suppliedTerm.getEffectiveToTime(), "updateTerm");
            InputValidator.validateNodeType((Object[])new Object[]{className, "updateTerm", suppliedTerm.getNodeType(), NodeType.Term});
            InputValidator.validateGUIDNotNull((String)className, (String)"updateTerm", (String)guid, (String)"guid");
            response = this.getTermByGuid(serverName, userId, guid);
            if (response.getResponseCategory().equals((Object)ResponseCategory.Term)) {
                Status status;
                Term originalTerm = ((TermResponse)response).getTerm();
                if (originalTerm.getSystemAttributes() != null) {
                    status = originalTerm.getSystemAttributes().getStatus();
                    SubjectAreaUtils.checkStatusNotDeleted(status, SubjectAreaErrorCode.GLOSSARY_UPDATE_FAILED_ON_DELETED_GLOSSARY);
                }
                if (suppliedTerm.getSystemAttributes() != null) {
                    status = suppliedTerm.getSystemAttributes().getStatus();
                    SubjectAreaUtils.checkStatusNotDeleted(status, SubjectAreaErrorCode.STATUS_UPDATE_TO_DELETED_NOT_ALLOWED);
                }
                Term updateTerm = new Term();
                updateTerm.setSystemAttributes(originalTerm.getSystemAttributes());
                if (isReplace) {
                    updateTerm.setName(suppliedTerm.getName());
                    updateTerm.setQualifiedName(suppliedTerm.getQualifiedName());
                    updateTerm.setDescription(suppliedTerm.getDescription());
                    updateTerm.setUsage(suppliedTerm.getUsage());
                    updateTerm.setAbbreviation(suppliedTerm.getAbbreviation());
                    updateTerm.setExamples(suppliedTerm.getExamples());
                    updateTerm.setSpineObject(suppliedTerm.isSpineObject());
                    updateTerm.setSpineAttribute(suppliedTerm.isSpineAttribute());
                    updateTerm.setObjectIdentifier(suppliedTerm.isObjectIdentifier());
                    updateTerm.setAdditionalProperties(suppliedTerm.getAdditionalProperties());
                } else {
                    if (suppliedTerm.getName() == null) {
                        updateTerm.setName(originalTerm.getName());
                    } else {
                        updateTerm.setName(suppliedTerm.getName());
                    }
                    if (suppliedTerm.getQualifiedName() == null) {
                        updateTerm.setQualifiedName(originalTerm.getQualifiedName());
                    } else {
                        updateTerm.setQualifiedName(suppliedTerm.getQualifiedName());
                    }
                    if (suppliedTerm.getDescription() == null) {
                        updateTerm.setDescription(originalTerm.getDescription());
                    } else {
                        updateTerm.setDescription(suppliedTerm.getDescription());
                    }
                    if (suppliedTerm.getUsage() == null) {
                        updateTerm.setUsage(originalTerm.getUsage());
                    } else {
                        updateTerm.setUsage(suppliedTerm.getUsage());
                    }
                    if (suppliedTerm.getAbbreviation() == null) {
                        updateTerm.setAbbreviation(originalTerm.getAbbreviation());
                    } else {
                        updateTerm.setAbbreviation(suppliedTerm.getAbbreviation());
                    }
                    if (suppliedTerm.getAdditionalProperties() == null) {
                        updateTerm.setAdditionalProperties(originalTerm.getAdditionalProperties());
                    } else {
                        updateTerm.setAdditionalProperties(suppliedTerm.getAdditionalProperties());
                    }
                    if (suppliedTerm.getExamples() == null) {
                        updateTerm.setExamples(originalTerm.getExamples());
                    } else {
                        updateTerm.setExamples(suppliedTerm.getExamples());
                    }
                }
                GovernanceActions suppliedGovernanceActions = suppliedTerm.getGovernanceActions();
                updateTerm.setGovernanceActions(suppliedGovernanceActions);
                GlossaryTerm generatedTerm = TermMapper.mapTermToOMRSBean(updateTerm);
                GlossaryTerm updatedGeneratedTerm = subjectAreaOmasREST.updateGlossaryTerm(userId, generatedTerm);
                Set<Classification> suppliedClassifications = this.getClassificationFromTerm(suppliedTerm, suppliedGovernanceActions);
                Set<Classification> existingClassifications = this.getClassificationFromTerm(originalTerm, originalTerm.getGovernanceActions());
                ClassificationGroupByOperation classificationGroupByOperation = new ClassificationGroupByOperation(SUBJECT_AREA_TERM_CLASSIFICATIONS, existingClassifications, suppliedClassifications);
                List<Classification> addClassifications = classificationGroupByOperation.getAddClassifications();
                List<String> removeClassificationNames = classificationGroupByOperation.getRemoveClassifications();
                List<Classification> updateClassifications = classificationGroupByOperation.getUpdateClassifications();
                if (!addClassifications.isEmpty()) {
                    updatedGeneratedTerm = subjectAreaOmasREST.addGlossaryTermClassifications(userId, guid, addClassifications);
                }
                if (!removeClassificationNames.isEmpty()) {
                    for (String classificationName : removeClassificationNames) {
                        updatedGeneratedTerm = subjectAreaOmasREST.deleteGlossaryTermClassification(userId, guid, classificationName);
                    }
                }
                if (!updateClassifications.isEmpty()) {
                    updatedGeneratedTerm = subjectAreaOmasREST.updateGlossaryTermClassification(userId, guid, updateClassifications);
                }
                Term updatedTerm = TermMapper.mapOMRSBeantoTerm(updatedGeneratedTerm);
                response = new TermResponse(updatedTerm);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (ClassificationException e) {
            response = OMASExceptionToResponse.convertClassificationException((ClassificationException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTerm,userId=" + userId + ",response=" + response);
        }
        return response;
    }

    private Set<Classification> getClassificationFromTerm(Term suppliedTerm, GovernanceActions governanceActions) {
        HashSet<Classification> classifications = new HashSet<Classification>();
        if (suppliedTerm.isObjectIdentifier()) {
            classifications.add((Classification)new ObjectIdentifier());
        }
        if (suppliedTerm.isSpineObject()) {
            classifications.add((Classification)new SpineObject());
        }
        if (suppliedTerm.isSpineAttribute()) {
            classifications.add((Classification)new SpineAttribute());
        }
        if (governanceActions != null) {
            Retention suppliedRetention = governanceActions.getRetention();
            Confidentiality suppliedConfidentiality = governanceActions.getConfidentiality();
            Confidence suppliedConfidence = governanceActions.getConfidence();
            Criticality suppliedCriticallity = governanceActions.getCriticality();
            if (suppliedRetention != null) {
                classifications.add((Classification)suppliedRetention);
            }
            if (suppliedConfidentiality != null) {
                classifications.add((Classification)suppliedConfidentiality);
            }
            if (suppliedConfidence != null) {
                classifications.add((Classification)suppliedConfidence);
            }
            if (suppliedCriticallity != null) {
                classifications.add((Classification)suppliedCriticallity);
            }
        }
        return classifications;
    }

    public SubjectAreaOMASAPIResponse deleteTerm(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteTerm,userId=" + userId + ", guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "deleteTerm");
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteTerm", (String)guid, (String)"guid");
            if (isPurge.booleanValue()) {
                subjectAreaOmasREST.purgeGlossaryTermByGuid(userId, guid);
                response = new VoidResponse();
            } else {
                GlossaryTerm deletedGeneratedTerm = null;
                EntityDetail entityDetail = subjectAreaOmasREST.deleteGlossaryTermByGuid(userId, guid);
                deletedGeneratedTerm = GlossaryTermMapper.mapOmrsEntityDetailToGlossaryTerm(entityDetail);
                Term deletedTerm = TermMapper.mapOMRSBeantoTerm(deletedGeneratedTerm);
                response = new TermResponse(deletedTerm);
            }
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (GUIDNotPurgedException e) {
            response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
        }
        catch (EntityNotDeletedException e) {
            response = OMASExceptionToResponse.convertEntityNotDeletedException((EntityNotDeletedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteTerm,userId=" + userId);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreTerm(String serverName, String userId, String guid) {
        String methodName = "restoreTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreTerm,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaBeansToAccessOMRS subjectAreaOmasREST = this.initializeAPI(serverName, userId, "restoreTerm");
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreTerm", (String)guid, (String)"guid");
            GlossaryTerm restoredGeneratedTerm = null;
            EntityDetail omrsEntity = this.oMRSAPIHelper.callOMRSRestoreEntity(userId, guid);
            restoredGeneratedTerm = GlossaryTermMapper.mapOmrsEntityDetailToGlossaryTerm(omrsEntity);
            Term restoredTerm = TermMapper.mapOMRSBeantoTerm(restoredGeneratedTerm);
            response = new TermResponse(restoredTerm);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (GUIDNotDeletedException e) {
            response = OMASExceptionToResponse.convertGUIDNotDeletedException((GUIDNotDeletedException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreTerm,userId=" + userId + ", response=" + response);
        }
        return response;
    }
}

