/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.utilities;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.server.handlers.ErrorHandler;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.archivemanager.OMRSArchiveAccessor;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSAPIHelper {
    private static final Logger log = LoggerFactory.getLogger(OMRSAPIHelper.class);
    private static final String className = OMRSAPIHelper.class.getName();
    private OMRSMetadataCollection oMRSMetadataCollection = null;
    private ErrorHandler errorHandler = null;
    private String serviceName = "Subject Area OMAS";
    private String serverName = null;
    private OMRSRepositoryHelper omrsRepositoryHelper = null;

    public OMRSMetadataCollection getOMRSMetadataCollection() throws MetadataServerUncontactableException {
        this.validateInitialization();
        return this.oMRSMetadataCollection;
    }

    public OMRSRepositoryHelper getOMRSRepositoryHelper() {
        return this.omrsRepositoryHelper;
    }

    public void setOMRSRepositoryConnector(OMRSRepositoryConnector connector) throws MetadataServerUncontactableException {
        String restAPIName = "";
        String methodName = "setOMRSRepositoryConnector";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + "connector=" + connector);
        }
        try {
            this.oMRSMetadataCollection = connector.getMetadataCollection();
            this.omrsRepositoryHelper = connector.getRepositoryHelper();
        }
        catch (RepositoryErrorException e) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.METADATA_SERVER_UNCONTACTABLE_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{e.getMessage(), restAPIName, this.serviceName, this.serverName});
            log.error(errorMessage);
            throw new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), this.getClass().getName(), restAPIName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
    }

    private void validateInitialization() throws MetadataServerUncontactableException {
        String restAPIName = "";
        if (this.oMRSMetadataCollection == null && this.omrsRepositoryHelper == null) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.SERVICE_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{restAPIName});
            throw new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), this.getClass().getName(), restAPIName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public TypeDefGallery callGetAllTypes(String userId) throws UserNotAuthorizedException, MetadataServerUncontactableException {
        String methodName = "callGetAllTypes";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = "";
        TypeDefGallery typeDefGallery = null;
        try {
            typeDefGallery = this.getOMRSMetadataCollection().getAllTypes(userId);
        }
        catch (RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return typeDefGallery;
    }

    public TypeDef callGetTypeDefByName(String userId, String typeName) throws UserNotAuthorizedException, InvalidParameterException, MetadataServerUncontactableException {
        String methodName = "callGetTypeDefByName";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        TypeDef typeDef = null;
        String restAPIName = "";
        try {
            typeDef = this.getOMRSMetadataCollection().getTypeDefByName(userId, typeName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeDefNotKnownException e) {
            ErrorHandler.handleTypeDefNotKnownException(typeName, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return typeDef;
    }

    public EntityDetail callOMRSAddEntity(String userId, EntityDetail entityDetail) throws UserNotAuthorizedException, InvalidParameterException, ClassificationException, org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException, MetadataServerUncontactableException {
        String methodName = "callOMRSAddEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = "";
        EntityDetail addedEntityDetail = null;
        InstanceProperties instanceProperties = entityDetail.getProperties();
        try {
            addedEntityDetail = this.getOMRSMetadataCollection().addEntity(userId, entityDetail.getType().getTypeDefGUID(), instanceProperties, entityDetail.getClassifications(), InstanceStatus.ACTIVE);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException | RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeErrorException e) {
            ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (ClassificationErrorException e) {
            ErrorHandler.handleClassificationErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (StatusNotSupportedException e) {
            ErrorHandler.handleStatusNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return addedEntityDetail;
    }

    public EntityDetail callOMRSGetEntityByGuid(String userId, String entityGUID) throws UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, MetadataServerUncontactableException {
        String methodName = "callOMRSGetEntityByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = "";
        EntityDetail gotEntityDetail = null;
        try {
            gotEntityDetail = this.getOMRSMetadataCollection().getEntityDetail(userId, entityGUID);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            ErrorHandler.handleEntityNotKnownError(entityGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityProxyOnlyException e) {
            ErrorHandler.handleEntityProxyOnlyException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return gotEntityDetail;
    }

    public List<EntityDetail> callFindEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder sequencingOrder, int pageSize) throws UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, MetadataServerUncontactableException {
        String methodName = "callFindEntitiesByPropertyValue";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = "";
        List foundEntities = null;
        try {
            foundEntities = this.getOMRSMetadataCollection().findEntitiesByPropertyValue(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException e) {
            ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeErrorException e) {
            ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PagingErrorException e) {
            ErrorHandler.handlePagingErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return foundEntities;
    }

    public EntityDetail callOMRSUpdateEntity(String userId, EntityDetail entityDetail) throws UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, MetadataServerUncontactableException {
        String methodName = "callOMRSUpdateEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = "";
        EntityDetail updatedEntity = null;
        InstanceProperties instanceProperties = entityDetail.getProperties();
        try {
            updatedEntity = this.getOMRSMetadataCollection().updateEntityProperties(userId, entityDetail.getGUID(), instanceProperties);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException | RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            ErrorHandler.handleEntityNotKnownError(entityDetail.getGUID(), restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return updatedEntity;
    }

    public EntityDetail callOMRSDeleteEntity(String userId, String typeDefName, String typeDefGuid, String obsoleteGuid) throws UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, UnrecognizedGUIDException, MetadataServerUncontactableException {
        String methodName = "callOMRSDeleteEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = "";
        EntityDetail deletedEntity = null;
        try {
            deletedEntity = this.getOMRSMetadataCollection().deleteEntity(userId, typeDefGuid, typeDefName, obsoleteGuid);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException e) {
            ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            ErrorHandler.handleEntityNotKnownError(obsoleteGuid, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return deletedEntity;
    }

    public void callOMRSPurgeEntity(String userId, String typeDefName, String typeDefGuid, String obsoleteGuid) throws UserNotAuthorizedException, MetadataServerUncontactableException, EntityNotDeletedException, InvalidParameterException, UnrecognizedGUIDException, GUIDNotPurgedException {
        String methodName = "callOMRSPurgeEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = "";
        try {
            this.getOMRSMetadataCollection().purgeEntity(userId, typeDefGuid, typeDefName, obsoleteGuid);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException | RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            ErrorHandler.handleEntityNotKnownError(obsoleteGuid, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException e) {
            this.errorHandler.handleEntityNotPurgedException(obsoleteGuid, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
    }

    public EntityDetail callOMRSRestoreEntity(String userId, String guid) throws UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException, MetadataServerUncontactableException, GUIDNotDeletedException {
        String methodName = "callOMRSRestoreEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = methodName;
        EntityDetail restoredEntity = null;
        try {
            restoredEntity = this.getOMRSMetadataCollection().restoreEntity(userId, guid);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException e) {
            ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            ErrorHandler.handleEntityNotKnownException(guid, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException e) {
            ErrorHandler.handleEntityNotDeletedException(guid, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return restoredEntity;
    }

    public EntityDetail callOMRSClassifyEntity(String userId, String entityGUID, String classificationName, InstanceProperties instanceProperties) throws UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException, MetadataServerUncontactableException {
        String methodName = "callOMRSClassifyEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = "";
        EntityDetail entity = null;
        try {
            entity = this.getOMRSMetadataCollection().classifyEntity(userId, entityGUID, classificationName, instanceProperties);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException | RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            ErrorHandler.handleEntityNotKnownError(entityGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (ClassificationErrorException e) {
            ErrorHandler.handleClassificationErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return entity;
    }

    public EntityDetail callOMRSDeClassifyEntity(String userId, String entityGUID, String classificationName) throws UserNotAuthorizedException, InvalidParameterException, ClassificationException, UnrecognizedGUIDException, MetadataServerUncontactableException {
        String methodName = "callOMRSDeClassifyEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = "";
        EntityDetail entity = null;
        try {
            entity = this.getOMRSMetadataCollection().declassifyEntity(userId, entityGUID, classificationName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException | RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            ErrorHandler.handleEntityNotKnownError(entityGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (ClassificationErrorException e) {
            ErrorHandler.handleClassificationErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return entity;
    }

    public Relationship callOMRSAddRelationship(String userId, Relationship relationship) throws UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, MetadataServerUncontactableException, org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException {
        String methodName = "callOMRSDeClassifyEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = "";
        Relationship addedRelationship = null;
        try {
            addedRelationship = this.getOMRSMetadataCollection().addRelationship(userId, relationship.getType().getTypeDefGUID(), relationship.getProperties(), relationship.getEntityOneProxy().getGUID(), relationship.getEntityTwoProxy().getGUID(), InstanceStatus.ACTIVE);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException | RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (StatusNotSupportedException e) {
            ErrorHandler.handleStatusNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            ErrorHandler.handleEntityNotKnownError(relationship.getGUID(), restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeErrorException e) {
            ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return addedRelationship;
    }

    public Relationship callOMRSGetRelationshipByGuid(String userId, String relationshipGUID) throws UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, MetadataServerUncontactableException {
        String methodName = "callOMRSGetRelationshipByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = methodName;
        Relationship relationship = null;
        try {
            relationship = this.getOMRSMetadataCollection().getRelationship(userId, relationshipGUID);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotKnownException e) {
            ErrorHandler.handleRelationshipNotKnownException(relationshipGUID, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return relationship;
    }

    public Relationship callOMRSUpdateRelationship(String userId, Relationship relationship) throws UserNotAuthorizedException, MetadataServerUncontactableException, InvalidParameterException, org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException, UnrecognizedGUIDException {
        String methodName = "callOMRSUpdateRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = methodName;
        Relationship updatedRelationship = null;
        try {
            updatedRelationship = this.getOMRSMetadataCollection().updateRelationshipProperties(userId, relationship.getGUID(), relationship.getProperties());
            if (relationship.getStatus() != null && updatedRelationship != null && !relationship.getStatus().equals((Object)updatedRelationship.getStatus())) {
                updatedRelationship = this.getOMRSMetadataCollection().updateRelationshipStatus(userId, relationship.getGUID(), relationship.getStatus());
            }
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException | RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotKnownException e) {
            ErrorHandler.handleRelationshipNotKnownException(relationship.getGUID(), restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (StatusNotSupportedException e) {
            ErrorHandler.handleStatusNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return updatedRelationship;
    }

    public Relationship callOMRSDeleteRelationship(String userId, String typeGuid, String typeName, String guid) throws UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException, MetadataServerUncontactableException {
        String methodName = "callOMRSDeleteRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = methodName;
        Relationship deletedRelationship = null;
        try {
            deletedRelationship = this.getOMRSMetadataCollection().deleteRelationship(userId, typeGuid, typeName, guid);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException e) {
            ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotKnownException e) {
            ErrorHandler.handleRelationshipNotKnownException(guid, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return deletedRelationship;
    }

    public Relationship callOMRSRestoreRelationship(String userId, String guid) throws UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException, MetadataServerUncontactableException, GUIDNotDeletedException {
        String methodName = "callOMRSRestoreRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = methodName;
        Relationship restoredRelationship = null;
        try {
            restoredRelationship = this.getOMRSMetadataCollection().restoreRelationship(userId, guid);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException e) {
            ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotKnownException e) {
            ErrorHandler.handleRelationshipNotKnownException(guid, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotDeletedException e) {
            ErrorHandler.handleRelationshipNotDeletedException(guid, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return restoredRelationship;
    }

    public void callOMRSPurgeRelationship(String userId, String typeGuid, String typeName, String guid) throws UserNotAuthorizedException, InvalidParameterException, GUIDNotPurgedException, UnrecognizedGUIDException, MetadataServerUncontactableException {
        String methodName = "callOMRSPurgeRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = methodName;
        Object updatedRelationship = null;
        try {
            this.getOMRSMetadataCollection().purgeRelationship(userId, typeGuid, typeName, guid);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException | RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotKnownException e) {
            ErrorHandler.handleRelationshipNotKnownException(guid, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotDeletedException e) {
            this.errorHandler.handleRelationshipNotPurgedException(guid, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
    }

    public List<Relationship> callGetRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder sequencingOrder, int pageSize) throws UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException, MetadataServerUncontactableException {
        String methodName = "callGetRelationshipsForEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = methodName;
        ArrayList<InstanceStatus> statusList = new ArrayList<InstanceStatus>();
        statusList.add(InstanceStatus.ACTIVE);
        List relationships = null;
        try {
            relationships = this.getOMRSMetadataCollection().getRelationshipsForEntity(userId, entityGUID, relationshipTypeGuid, fromRelationshipElement, statusList, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeErrorException e) {
            ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            ErrorHandler.handleEntityNotKnownError(entityGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException e) {
            ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PagingErrorException e) {
            ErrorHandler.handlePagingErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return relationships;
    }

    public List<Relationship> callGetRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder sequencingOrder, int pageSize) throws UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnrecognizedGUIDException, MetadataServerUncontactableException {
        String methodName = "callGetRelationshipsForEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = methodName;
        List relationships = null;
        try {
            relationships = this.getOMRSMetadataCollection().getRelationshipsForEntity(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeErrorException e) {
            ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            ErrorHandler.handleEntityNotKnownError(entityGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException e) {
            ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PagingErrorException e) {
            ErrorHandler.handlePagingErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return relationships;
    }

    public String callGetTypeGuid(String userId, String typeName) throws UserNotAuthorizedException, InvalidParameterException, MetadataServerUncontactableException {
        String methodName = "callgetTypeGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = methodName;
        String typeDefGuid = null;
        try {
            TypeDef typeDef = this.getOMRSMetadataCollection().getTypeDefByName(userId, typeName);
            typeDefGuid = typeDef.getGUID().toString();
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeDefNotKnownException e) {
            ErrorHandler.handleTypeDefNotKnownException(typeName, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return typeDefGuid;
    }

    public InstanceGraph callGetEntityNeighbourhood(String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level) throws UserNotAuthorizedException, MetadataServerUncontactableException, InvalidParameterException, UnrecognizedGUIDException, FunctionNotSupportedException {
        String methodName = "callgetEntityNeighborhood";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        String restAPIName = methodName;
        InstanceGraph instanceGraph = null;
        try {
            instanceGraph = this.getOMRSMetadataCollection().getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            String method_not_implemented_msg_id = OMRSErrorCode.METHOD_NOT_IMPLEMENTED.getErrorMessageId();
            if (!e.getErrorMessage().startsWith(method_not_implemented_msg_id)) {
                ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
            }
        }
        catch (TypeErrorException e) {
            ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            ErrorHandler.handleEntityNotKnownError(entityGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException e) {
            ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        return instanceGraph;
    }

    public static List<EntityDetail> findEntitiesByType(OMRSAPIHelper oMRSAPIHelper, String serverName, String userId, String type, String searchCriteria, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty, String methodName) throws MetadataServerUncontactableException, InvalidParameterException, UserNotAuthorizedException, FunctionNotSupportedException {
        if (offset == null) {
            offset = new Integer(0);
        }
        if (pageSize == null) {
            pageSize = new Integer(0);
        }
        if (sequencingProperty != null) {
            try {
                sequencingProperty = URLDecoder.decode(sequencingProperty, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (searchCriteria != null) {
            try {
                searchCriteria = URLDecoder.decode(searchCriteria, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder omrsSequencingOrder = SubjectAreaUtils.convertOMASToOMRSSequencingOrder(sequencingOrder);
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef typeDef = archiveAccessor.getEntityDefByName(type);
        String entityTypeGUID = typeDef.getGUID();
        return oMRSAPIHelper.callFindEntitiesByPropertyValue(userId, entityTypeGUID, searchCriteria, offset, null, null, asOfTime, sequencingProperty, omrsSequencingOrder, pageSize);
    }
}

